<?php
 
add_filter( 'ppt_blocks_args',  array('block_hero150',  'data') );
add_action( 'hero150',  			array('block_hero150', 'output' ) );
add_action( 'hero150-css',  		array('block_hero150', 'css' ) );
add_action( 'hero150-js',  		array('block_hero150', 'js' ) );

class block_hero150 {

	function __construct(){}		

	public static function data($a){ 
	
		global $CORE;
  
		$a['hero150'] = array(
			"name" 	=> "Hero 120",
			"image"	=> "hero150.jpg",
			"cat"	=> "hero",
			"widget" => "ppt-hero",			
			"order" => 1.9,
			"desc" 	=> "", 
			"data" 	=> array( ),
			"defaults" => array(),
					
		);		
		
		return $a;
	
	} public static function output(){ global $CORE, $settings, $hero_settings, $userdata;	
	    
	 	// ALL DEFAULT FIELDS
		 $df = ppt_theme_blocks_defaults("hero"); 
		  
		// APPLY CUSTOM CHANGES 
		$cc = array(
 
            "image"         => "https://premiumpress1063.b-cdn.net/_demoimagesv10/framework/layouts/_da/popular/bg1.jpg",
            "image1"        => "https://premiumpress1063.b-cdn.net/_demoimagesv10/framework/layouts/_da/popular/bg2.jpg",

            "title"         => "Over 1,000+ Users Waiting To Meet You.",
            "subtitle"      => $CORE->LAYOUT("get_placeholder_text_new", array("hero1", "s" ) ),
            "desc"          => $CORE->LAYOUT("get_placeholder_text_new", array("text102", "title" ) ),

            "image1_alt" =>  __("Join Free!","premiumpress"),
	 
		); 

		$df = array_merge($df, $cc); 
		
		// 1. ELEMENTOR
		if(!empty($hero_settings)){
			foreach($df as $k => $v){				
				if(isset($hero_settings[$k]) && $hero_settings[$k] != "" ){
					$df[$k] = $hero_settings[$k];
				}
			}
			
		// 2. HOME DESIGNS		
		}else{	
			 
		 	$settings =   $CORE->LAYOUT("get_block_settings_defaults_new", array("hero", "hero150"  ) );
		 
		 	foreach($df as $h => $j){
				if(isset($settings[$h]) && $settings[$h] != ""){
					$df[$h] = $settings[$h];
				}
			 } 
		} 
 
		ob_start();
		
		?> 


<section class="hero150 position-relative section-60  mobile-pt-4" <?php if($df['section_overlay'] == ""){ ?>data-overlay="white"<?php } ?> data-fullpage="1">



<div class="container position-relative z-10 py-0 _contents">
        <div class="align-items-center">

<div class="col-12 col-md-6 col-lg-5 mx-auto"> 


    <div class="bg-white p-4 rounded-10 card shadow">

    <div class="ribbon ribbon-top-right"><span><?php echo $df['image1_alt']; ?></span></div> 
  
    <div class="text-center">

    <h1 data-ppt-title class="fs-lg text-700 text-center text-primary mb-2"><?php echo $df['title']; ?></h1>

    <p  data-ppt-subtitle class="text-600 opacity-5"><?php echo $df['subtitle']; ?></p> 
 
    <div class="position-relative">
 
    <img src="<?php echo $df['image1']; ?>" class="img-fluid rounded  <?php if(isset($df['image1_shadow'])){ echo $df['image1_shadow']; } ?>" alt="image" data-ppt-image1> </a>

    </div>

    <div class="lh-30 mt-2 text-600 mb-2" data-ppt-desc><?php echo $df['desc']; ?></div> 

    <a data-ppt-btn data-ppt-btn-txt data-ppt-btn-link class="btn-primary btn-lg" <?php if($userdata->ID){ ?>href="<?php echo _ppt(array('links','myaccount')); ?>"<?php }else{ ?> href="<?php echo _ppt(array('links','add')); ?>"<?php } ?>>
    <?php echo __("Continue","premiumpress"); ?>
    </a> 

     <div> <i class="fa fa-arrow-up mt-2"> </i></div> 
        
    </div>

    </div> 
 
 </div>


        </div>
</div>


<div class="bg-image" style="background-image:url('<?php echo $df['image']; ?>');" data-ppt-image-bg>&nbsp;</div>


<?php  _ppt_template( 'framework/design/hero/parts/overlay' ); ?> 

 </section> 
 
<?php
$output = ob_get_contents();
ob_end_clean();
echo ppt_theme_block_output($output, $hero_settings, array("hero", "hero150"));
	
	}
	public static function css(){ global $CORE;


    $rc = _ppt(array('design','color_secondary'));
    if($rc == ""){
      $rc = "red";
    }


ob_start();?>
<style>
.hero150 {
    background: hsla(0, 0%, 100%, .2);
    height: calc(100vh - 64px);
    margin-top: 4px;
    position: relative;
    width: 100%;
    z-index: 2;
}
.hero150 .img {
    background: hsla(0, 0%, 100%, .2);
    bottom: 0;
    height: 100%;
    left: 0;
    position: absolute;
    right: 0;
    top: 0;
    width: 100%;
}



.box {
  position: relative;
  max-width: 600px;
  width: 90%;
  height: 400px;
  background: #fff;
  box-shadow: 0 0 15px rgba(0,0,0,.1);
}

/* common */
.ribbon {
  width: 150px;
  height: 150px;
  overflow: hidden;
  position: absolute;
}
.ribbon::before,
.ribbon::after {
  position: absolute;
  z-index: -1;
  content: '';
  display: block;
  border: 5px solid <?php echo $rc; ?>;
}
.ribbon span {
  position: absolute;
  display: block;
  width: 225px;
  padding: 15px 0;
  background-color: <?php echo $rc; ?>;
  box-shadow: 0 5px 10px rgba(0,0,0,.1);
  color: #fff;
  font: 700 18px/1 'Lato', sans-serif;
  text-shadow: 0 1px 1px rgba(0,0,0,.2);
  text-transform: uppercase;
  text-align: center;
}

 

/* top right*/
.ribbon-top-right {
  top: -10px;
  right: -10px;
}
.ribbon-top-right::before,
.ribbon-top-right::after {
  border-top-color: transparent;
  border-right-color: transparent;
}
.ribbon-top-right::before {
  top: 0;
  left: 0;
}
.ribbon-top-right::after {
  bottom: 0;
  right: 0;
}
.ribbon-top-right span {
  left: -25px;
  top: 30px;
  transform: rotate(45deg);
}


@-webkit-keyframes pulse {
  0% {
    -webkit-transform: scale(1);
    transform: scale(1);
  }

  50% {
    -webkit-transform: scale(1.1);
    transform: scale(1.1);
  }

  100% {
    -webkit-transform: scale(1);
    transform: scale(1);
  }
}

@keyframes pulse {
  0% {
    -webkit-transform: scale(1);
    -ms-transform: scale(1);
    transform: scale(1);
  }

  50% {
    -webkit-transform: scale(1.1);
    -ms-transform: scale(1.1);
    transform: scale(1.1);
  }

  100% {
    -webkit-transform: scale(1);
    -ms-transform: scale(1);
    transform: scale(1);
  }
}

.pulse {
  -webkit-animation-iteration-count: infinite;
  animation-iteration-count: infinite;
  -webkit-animation-name: pulse;
  animation-name: pulse;
    -webkit-animation-duration: 1s;
  animation-duration: 5s;
  -webkit-animation-fill-mode: both;
  animation-fill-mode: both;
}


</style>
        <?php
	 
		$output = ob_get_contents();
		ob_end_clean();
		echo $output;	
	
	}		
	public static function js(){ global $CORE;
		ob_start();
 
		$output = ob_get_contents();
		ob_end_clean();
		echo $output;	
	
	}	
	
}

?>