<?php
 
add_filter( 'ppt_blocks_args', 	array('block_category500',  'data') );
add_action( 'category500',  		array('block_category500', 'output' ) );
add_action( 'category500-css',  	array('block_category500', 'css' ) );
add_action( 'category500-js',  	array('block_category500', 'js' ) );

class block_category500 {

	function __construct(){}		

	public static function data($a){ 
  
		$a['category500'] = array(
			"name" 	=> "Category Listings",
			"image"	=> "category500.jpg",
			"cat"	=> "category",
			"widget" => "ppt-category",
			"desc" 	=> "", 
			"data" 	=> array(  ),
			"order" => 3,	 
		);		
		
		return $a;
	
	} public static function output(){ global $CORE, $category_settings, $settings;
	
	
		// ALL DEFAULT FIELDS
		 $df = ppt_theme_blocks_defaults("category"); 
		  
		// APPLY CUSTOM CHANGES 
		$cc = array(
            "tax" 		=> "listing",
             

            "show" 		=> 4,
            "custom"    => "",
            "card"      => "grid",
            "perrow"    => "",

            "btn_show" 	=> 1,
            "btn_txt" 	=> $CORE->LAYOUT("get_placeholder_text_new", array("short", "more" ) ),
            "title" 	=> $CORE->LAYOUT("get_placeholder_text_new", array("short", "featured_listings" ) ),
            "subtitle" 	=> "",

            "title_show" => 1,
		 );
		 

		$df = array_merge($df, $cc);
		
		
		// 1. ELEMENTOR
		if(!empty($category_settings)){
			foreach($df as $k => $v){				
				if(isset($category_settings[$k]) && $category_settings[$k] != "" ){
					$df[$k] = $category_settings[$k];
				}
			}
			
		// 2. HOME DESIGNS		
		}else{	
			 
		 	$settings =  $CORE->LAYOUT("get_block_settings_defaults_new", array("category", "category500" ) );
		 	foreach($df as $h => $j){
				if(isset($settings[$h]) && $settings[$h] != ""){
					$df[$h] = $settings[$h];
				}
			 } 
		}
		   

///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
	
	$limit = 10;
	if(isset($df['limit']) && $df['limit'] > 0){
	$limit = $df['limit'];
	} 
	
	$hide_empty = 1;
	if(isset($df['hide_empty']) && $df['hide_empty'] !=""){
	$hide_empty = $df['hide_empty'];
	} 
	
	$orderby = "menu_order";
	if(isset($df['orderby']) && $df['orderby'] != ""){
		$orderby = $df['orderby'];
	} 
	
	$order = "desc";
	if(isset($df['order']) && $df['order'] != ""){
		$order = $df['order'];
	}

    $tax = "";
	if(isset($df['tax']) && $df['tax'] != ""){
		$tax = $df['tax'];
	} 
 
	$showOnlyCats = array();	
	if(!empty($df['cat'])){
		$showOnlyCats = $df['cat'];
		if(!is_array($showOnlyCats)){
		$showOnlyCats = array($showOnlyCats);
		}
	}
	 

///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

 

$args = array(
    'posts_per_page'    => $df['limit'], 
    'post_type'         => THEME_TAXONOMY.'_type', 
    'orderby'           => $df['orderby'] , 
    'order'             => $df['order'],
    'post_status'       => array("publish"),
);

if(strlen($tax) > 1){
   
    if(!empty($showOnlyCats)){
        $args['tax_query']["tax_".$tax]  = array(
            'taxonomy' => $tax,	
            'field'     => 'term_id',
			'terms'     => $showOnlyCats,
			'operator'  => 'IN', 
        );
    }

}
 		

$postData = array("args" => $args, "posts" => array() );  
$query1 = new WP_Query( $args );

//print_r($query1 );

if(isset($query1->posts) && is_array($query1->posts)){

	foreach($query1->posts as $post){
 
        $postData["posts"][$post->ID] = $post->ID;

    }
} 

///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

ob_start();
?> 
 

<section class="section-40 category500">
<div class="container">
<div class="row">



<?php if($df['title_show'] == 1){ ?>
      <div class="col-md-12 mb-3">
        <div <?php if($df['btn_show'] == "1" && strlen($df['btn_txt']) > 2){ ?> class="d-flex justify-content-between align-items-center"<?php } ?>>

		<div>

          <h2 data-ppt-title><?php echo $df['title']; ?></h2>

		 <?php if(strlen($df['subtitle']) > 2){ ?> 
		  <p data-ppt-subtitle><?php echo $df['subtitle']; ?></p>
		  <?php } ?>

		</div>
          
        <?php if($df['btn_show'] == "1" && strlen($df['btn_txt']) > 2){ ?>
			<div class="justify-content-center">
            <a href="<?php echo home_url(); ?>/?s=" data-ppt-btn data-ppt-btn-link class="btn-system btn-rounded-25 btn-md"><?php echo $df['btn_txt']; ?></a>
            </div>
		<?php } ?>
          
        </div>
      </div>
      <?php } ?>
 

      
        
      <?php global $post; 
      
      foreach($postData['posts'] as $postID){ 

        $post = get_post($postID);

        if(isset($atts['card'])){
			global $settings;
			$settings['card'] = $atts['card'];
		}

            if(in_array(THEME_KEY,array("jb","cp"))){
			
            echo '<div class="col-12 col-md-4 col-lg-4 col-xl-3">';
    
            }else{
    
                echo '<div class="col-6 col-md-4 col-lg-4 col-xl-3">';
            }
	
		    _ppt_template( 'content-listing'); 

            echo '</div>';        
        
      }
      ?>

</div></div> 
  
</section>
<?php
$output = ob_get_contents();
ob_end_clean();
 
echo ppt_theme_block_output($output, $df, array("category", "category500"));

	
	}
		public static function css(){
        return "";
		ob_start();
		$output = ob_get_contents();
		ob_end_clean();
		echo $output;
		}	
		public static function js(){
		return "";
		ob_start();
		?>
<?php	
		$output = ob_get_contents();
		ob_end_clean();
		echo $output;
		}	
}

?>
