<?php
 
add_filter( 'ppt_blocks_args', 	array('block_category202',  'data') );
add_action( 'category202',  		array('block_category202', 'output' ) );
add_action( 'category202-css',  	array('block_category202', 'css' ) );
add_action( 'category202-js',  	array('block_category202', 'js' ) );

class block_category202 {

	function __construct(){}		

	public static function data($a){ 
  
		$a['category202'] = array(
			"name" 	=> "Style 200",
			"image"	=> "category202.jpg",
			"cat"	=> "category",
			"widget" => "ppt-category",
			"desc" 	=> "", 
			"data" 	=> array(  ),
			"order" => 3,			
		);		
		
		return $a;
	
	} public static function output(){ global $CORE, $category_settings, $settings;
	
	
		// ALL DEFAULT FIELDS
		 $df = ppt_theme_blocks_defaults("category"); 
		  
		// APPLY CUSTOM CHANGES 
		$cc = array(
		"tax" 		=> "listing",
		"btn_show" => 1,
		 );
		 

		$df = array_merge($df, $cc);
		
		
		// 1. ELEMENTOR
		if(!empty($category_settings)){
			foreach($df as $k => $v){				
				if(isset($category_settings[$k]) && $category_settings[$k] != "" ){
					$df[$k] = $category_settings[$k];
				}
			}
			
		// 2. HOME DESIGNS		
		}else{	
			 
		 	$settings =  $CORE->LAYOUT("get_block_settings_defaults_new", array("category", "category202" ) );
		 	foreach($df as $h => $j){
				if(isset($settings[$h]) && $settings[$h] != ""){
					$df[$h] = $settings[$h];
				}
			 } 
		}
		   

///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
	
	$limit = 3;
	if(isset($df['limit']) && $df['limit'] > 0){
	$limit = $df['limit'];
	}
	
	$hide_empty = 1;
	if(isset($df['hide_empty']) && $df['hide_empty'] !=""){
	$hide_empty = $df['hide_empty'];
	} 
	
	$orderby = "menu_order";
	if(isset($df['orderby']) && $df['orderby'] != ""){
		$orderby = $df['orderby'];
	} 
	
	$order = "desc";
	if(isset($df['order']) && $df['order'] != ""){
		$order = $df['order'];
	} 
 
	$showOnlyCats = array();	
	if(!empty($df['cat'])){
		$showOnlyCats = $df['cat'];
		if(!is_array($showOnlyCats)){
		$showOnlyCats = array($showOnlyCats);
		}
	}
	
	
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

$termdata = get_terms($df['tax'], 'orderby='.$orderby.'&order='.$order.'&hide_empty='.$hide_empty.'&parent=0');
if(is_wp_error( $termdata )){ 
	echo $termdata->get_error_message(); 
	return;
}
$total_merchants = count($termdata);

$data = array(); $i=1;
foreach ($termdata as $term) {
 
		if(!empty($showOnlyCats) && !in_array($term->term_id,$showOnlyCats)){
		continue; 
		}
		
		if($i > $limit){
		$i++; continue;
		}

		// SUB CATS ONLY
		if(isset($df['cat_subs']) && $df['cat_subs'] == "1"){
		 
			$termdatasub = get_terms($df['tax'], 'orderby=count&order=desc&hide_empty='.$hide_empty.'&parent='.$term->term_id);
			if(is_wp_error( $termdatasub )){ 
				echo $termdatasub->get_error_message(); 
				return;
			}
			  
			foreach ($termdatasub as $terms) {
			
				if($i > $limit){
				 continue;
				}
				
				if(isset($df['image'.$i]) && strlen($df['image'.$i]) > 2){
				$img =  $df['image'.$i];
				}else{
				$img = do_shortcode('[CATEGORYIMAGE term_id="'.$terms->term_id.'" pathonly=1 placeholder=1 tax="'.$df['tax'].'"]');
				}

				$subtitle = _ppt('subtitle_'.$term->term_id);
				if($subtitle == "" && defined('WLT_DEMOMODE') ){
					$subtitle =  $CORE->FUNC("demo_title", rand(1,20));
				}

				$data[] = array( 
				"name"	=> $CORE->GEO("translation_tax_with_termdata", $terms), 
				"subtitle" => $subtitle, 
				"link"	=> get_term_link($terms), 
				"count"	=> $terms->count,  
				"image" => $img,
				"icon" 	=> do_shortcode('[CATEGORYIMAGE term_id="'.$terms->term_id.'" pathonly=1 placeholder=1 tax="'.$df['tax'].'"]'),
				); 
				
				$i++; 
			}
		
		// PARENT CAT
		}else{  
		
			$icon = "";
			$image = do_shortcode('[CATEGORYIMAGE term_id="'.$term->term_id.'" pathonly=1 placeholder=1 big=1 tax="'.$df['tax'].'"]');
			 
			if($df['tax'] == "store"){ 
				$icon = do_shortcode('[STOREIMAGE sid='.$term->term_id.']'); 
			}else{
				$icon = do_shortcode('[CATEGORYIMAGE term_id="'.$term->term_id.'" pathonly=1 placeholder=1 tax="'.$df['tax'].'"]');
			} 

			$subtitle = _ppt('subtitle_'.$term->term_id);
			if($subtitle == "" && defined('WLT_DEMOMODE') ){
				$subtitle =  $CORE->FUNC("demo_title", rand(1,20));
			}
			
			if(isset($df['image'.$i]) && strlen($df['image'.$i]) > 2){
				$img =  $df['image'.$i];
			}else{
				$img = $image;
			}
			
			$data[] = array( 
				"name"	=> $CORE->GEO("translation_tax_with_termdata", $term),  
				"subtitle" => $subtitle,
				"link"	=> get_term_link($term), 
				"count"	=> $term->count,  
				"image" => $img,
				"icon" 	=> $icon,
			);
			
			$i++; 
		
		} 
} 

///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

		
	ob_start();
	?>


 

<section class="section-40 category202">
<div class="container">
<div class="row">

  <div class="col-md-12">
   
  
  <h1 class="text-center mb-4 fs-3" data-ppt-title><?php echo $CORE->LAYOUT("get_placeholder_text_new", array("hero1", "t" ) ); ?></h1>
  
   
</div>


<div class="col-12">
<div class="listing1-carousel-1 owl-carousel owl-theme" data-0="1" data-1000="2" data-1200="3"  data-margin="30" data-autoplay="1">
 
<?php $i=1; foreach($data as $cat){ ?> 
 

<div ppt-border2 class="position-relative rounded-10 mb-4 bg-content overflow-hidden"> 

<div class="txtwrap text-light">
<div class="fs-6"><?php echo $cat['name']; ?></div>
<div class="small font-weight-bold"><?php echo $cat['subtitle']; ?> </div>
</div>
    
    <a href="<?php echo $cat['link']; ?>" style="position: relative;display: block;">
        <div class="bg-overlay-dark"> </div>
        <img src="<?php echo $cat['image']; ?>" class="img-fluid" alt="<?php echo $cat['name']; ?>">    
    </a>

    <div class="hide-mobile ncaticon">

    <a href="<?php echo $cat['link']; ?>">
		<img src="<?php echo $cat['icon']; ?>" class="img-fluid" alt="<?php echo $cat['name']; ?>" >
	</a>

    </div>

</div>  

<?php $i++; } ?>    
</div></div> </div>
 
 

<?php

///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

?> 

  
</div>
</div>
</section>
<?php
		$output = ob_get_contents();
		ob_end_clean();
		
echo ppt_theme_block_output($output, $df, array("category", "category202"));

	
	}
		public static function css(){
		ob_start();
		?>
<style>
  

.category202 .ncaticon { position: absolute;
    left: 15px;  height:70px; width:110px; line-height: 60px;
    border: 1px solid #e7edf3;
    box-shadow: 1px 1px 0 0 rgb(196 196 196 / 24%);
    bottom: 70px; background:#fff; z-index: 1; overflow:hidden; }

.category202 .txtwrap { position:absolute; bottom: 10px;    left: 15px;    z-index: 1; }
 

</style>
<?php	
		$output = ob_get_contents();
		ob_end_clean();
		echo $output;
		}	
		public static function js(){
		return "";
		ob_start();
		?>
<?php	
		$output = ob_get_contents();
		ob_end_clean();
		echo $output;
		}	
}

?>
