<?php
 
add_filter( 'ppt_blocks_args', 	array('block_category200',  'data') );
add_action( 'category200',  		array('block_category200', 'output' ) );
add_action( 'category200-css',  	array('block_category200', 'css' ) );
add_action( 'category200-js',  	array('block_category200', 'js' ) );

class block_category200 {

	function __construct(){}		

	public static function data($a){ 
  
		$a['category200'] = array(
			"name" 	=> "Style 200",
			"image"	=> "category200.jpg",
			"cat"	=> "category",
			"widget" => "ppt-category",
			"desc" 	=> "", 
			"data" 	=> array(  ),
			"order" => 3,			
		);		
		
		return $a;
	
	} public static function output(){ global $CORE, $category_settings, $settings;
	
	
		// ALL DEFAULT FIELDS
		 $df = ppt_theme_blocks_defaults("category"); 
		  
		// APPLY CUSTOM CHANGES 
		$cc = array(
		"tax" 		=> "listing",
		"btn_show" => 1,
		 );
		 

		$df = array_merge($df, $cc);
		
		
		// 1. ELEMENTOR
		if(!empty($category_settings)){
			foreach($df as $k => $v){				
				if(isset($category_settings[$k]) && $category_settings[$k] != "" ){
					$df[$k] = $category_settings[$k];
				}
			}
			
		// 2. HOME DESIGNS		
		}else{	
			 
		 	$settings =  $CORE->LAYOUT("get_block_settings_defaults_new", array("category", "category200" ) );
		 	foreach($df as $h => $j){
				if(isset($settings[$h]) && $settings[$h] != ""){
					$df[$h] = $settings[$h];
				}
			 } 
		}
		   

///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
	
	$limit = 10;
	if(isset($df['limit']) && $df['limit'] > 0){
	$limit = $df['limit'];
	} 
	
	$hide_empty = 1;
	if(isset($df['hide_empty']) && $df['hide_empty'] !=""){
	$hide_empty = $df['hide_empty'];
	} 
	
	$orderby = "menu_order";
	if(isset($df['orderby']) && $df['orderby'] != ""){
		$orderby = $df['orderby'];
	} 
	
	$order = "desc";
	if(isset($df['order']) && $df['order'] != ""){
		$order = $df['order'];
	} 
 
	$showOnlyCats = array();	
	if(!empty($df['cat'])){
		$showOnlyCats = $df['cat'];
		if(!is_array($showOnlyCats)){
		$showOnlyCats = array($showOnlyCats);
		}
	}
	
	
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

 
$termdata = get_terms($df['tax'], 'orderby='.$orderby.'&order='.$order.'&hide_empty='.$hide_empty.'&parent=0');
if(is_wp_error( $termdata )){ 
	echo $termdata->get_error_message(); 
	return;
}
$total_merchants = count($termdata);

$data = array(); $i=1;
foreach ($termdata as $term) {
 
		if(!empty($showOnlyCats) && !in_array($term->term_id,$showOnlyCats)){
		continue; 
		}
		
		if($i > $limit){
		$i++; continue;
		}

		// SUB CATS ONLY
		if(isset($df['cat_subs']) && $df['cat_subs'] == "1"){
		 
			$termdatasub = get_terms($df['tax'], 'orderby=count&order=desc&hide_empty='.$hide_empty.'&parent='.$term->term_id);
			if(is_wp_error( $termdatasub )){ 
				echo $termdatasub->get_error_message(); 
				return;
			}
			  
			foreach ($termdatasub as $terms) {
			
				if($i > $limit){
				 continue;
				}
				
				if(isset($df['image'.$i]) && strlen($df['image'.$i]) > 2){
				$img =  $df['image'.$i];
				}else{
				$img = do_shortcode('[CATEGORYIMAGE term_id="'.$terms->term_id.'" pathonly=1 placeholder=1 tax="'.$df['tax'].'"]');
				}

				$subtitle = _ppt('subtitle_'.$term->term_id);
				if($subtitle == "" && defined('WLT_DEMOMODE') ){
					$subtitle =  $CORE->FUNC("demo_title", rand(1,20));
				}

				$data[] = array( 
				"name"	=> $CORE->GEO("translation_tax_with_termdata", $terms), 
				"subtitle" => $subtitle, 
				"link"	=> get_term_link($terms), 
				"count"	=> $terms->count,  
				"image" => $img,
				"icon" 	=> do_shortcode('[CATEGORYIMAGE term_id="'.$terms->term_id.'" pathonly=1 placeholder=1 tax="'.$df['tax'].'"]'),
				); 
				
				$i++; 
			}
		
		// PARENT CAT
		}else{  
		
			$icon = "";
			$image = do_shortcode('[CATEGORYIMAGE term_id="'.$term->term_id.'" pathonly=1 placeholder=1 big=1 tax="'.$df['tax'].'"]');
			 
			if($df['tax'] == "store"){ 
				$icon = do_shortcode('[STOREIMAGE sid='.$term->term_id.']'); 
			}else{
				$icon = do_shortcode('[CATEGORYIMAGE term_id="'.$term->term_id.'" pathonly=1 placeholder=1 tax="'.$df['tax'].'"]');
			} 

			$subtitle = _ppt('subtitle_'.$term->term_id);
			if($subtitle == "" && defined('WLT_DEMOMODE') ){
				$subtitle =  $CORE->FUNC("demo_title", rand(1,20));
			}
			
			if(isset($df['image'.$i]) && strlen($df['image'.$i]) > 2){
				$img =  $df['image'.$i];
			}else{
				$img = $image;
			}
			
			$data[] = array( 
				"name"	=> $CORE->GEO("translation_tax_with_termdata", $term),  
				"subtitle" => $subtitle,
				"link"	=> get_term_link($term), 
				"count"	=> $term->count,  
				"image" => $img,
				"icon" 	=> $icon,
			);
			
			$i++; 
		
		} 
} 

///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

		
	ob_start();
	?>


 

<section class="section-40 category200">
<div class="container">
<div class="row">
  <div class="col-md-6">
    <h2 class="mb-4" data-ppt-title><?php echo $CORE->LAYOUT("get_placeholder_text_new", array("short", "pop_cats" ) ); ?></h2>
  </div>
 <div class="col-md-6 hide-mobile text-right">
 <a href="<?php echo _ppt(array('links','categories')); ?>" class="btn btn-system"><?php echo __("View All","premiumpress"); ?></a>
 </div>
 
<div class="col-12 hide-mobile">

<div class="listing1-carousel-1 owl-carousel owl-theme" data-0="1" data-1200="4" data-1000="4" data-margin="30">
<?php $i=1; foreach($data as $cat){ ?>
  


	<div ppt-border2 class="position-relative rounded-10 mb-4 hide-mobile">
    
    <a href="<?php echo $cat['link']; ?>" style="position: relative;display: block;">
	<div class="bg-overlay-dark"> </div>
        <img src="<?php echo $cat['image']; ?>" class="img-fluid" alt="<?php echo $cat['name']; ?>">
    
    </a>
<?php if($icon != ""){ ?>
     <div class="hide-mobile ncaticon">

<img src="<?php echo $cat['icon']; ?>" class="img-fluid" alt="<?php echo $cat['name']; ?>" >

</div>
<?php } ?>
     


      <div class="p-3" ppt-flex-between>
        <div class="text-600 text-black">     

<div class="fs-6"><?php echo $cat['name']; ?></div>
<div class="small"><?php echo $cat['subtitle']; ?> </div>


        </div>
        
        
        
        <a href="<?php echo $cat['link']; ?>" class="btn btn-system " ppt-btn><?php echo __("View","premiumpress"); ?></a>
      </div>
    </div> 



<?php $i++; } ?>    
</div></div> 
 
 
<?php

// MOBILE
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////


?> 
<div class="col-12 show-mobile"><div class="row">
<?php $i=1; foreach($data as $cat){ if($i > 9){ continue; } ?>
<div class="col-lg-3 col-md-4 col-4 col-lg-5ths ">
        <div class="card mb-md-4 card-mobile-transparent">
          <div class="card-body text-center card-hover">           
            <a href="<?php echo $cat['link']; ?>" class="text-decoration-none text-dark">            
            <div class="row">
              <div class="col-12 col-md-12">
                <div class="card p-2"><img data-src="<?php echo $cat['icon']; ?>" class="img-fluid lazy" alt="<?php echo $cat['name']; ?>" /></div>
              </div>              
              <div class="col-12  col-md-12">
                <div class="mobile-icon-text text-600 my-2"><?php echo $cat['name']; ?></div>
              </div>              
            </div>
           </a>
          </div>
    </div>
</div>
<?php $i++; } ?>    
</div></div>

<?php

///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

?> 

  
</div>
</div>
</section>
<?php
		$output = ob_get_contents();
		ob_end_clean();
		
echo ppt_theme_block_output($output, $df, array("category", "category200"));

	
	}
		public static function css(){
		ob_start();
		?>
<style>
 
 

 .category200 .ncaticon  {position: absolute;
    left: 10px;  height:70px;width:110px;line-height: 60px;
    border: 1px solid #e7edf3;
    box-shadow: 1px 1px 0 0 rgb(196 196 196 / 24%);
    bottom: 70px; background:#fff }}

</style>
<?php	
		$output = ob_get_contents();
		ob_end_clean();
		echo $output;
		}	
		public static function js(){
		return "";
		ob_start();
		?>
<?php	
		$output = ob_get_contents();
		ob_end_clean();
		echo $output;
		}	
}

?>
