<?php
 
add_filter( 'ppt_blocks_args', 	array('block_category2',  'data') );
add_action( 'category2',  		array('block_category2', 'output' ) );
add_action( 'category2-css',  	array('block_category2', 'css' ) );
add_action( 'category2-js',  	array('block_category2', 'js' ) );

class block_category2 {

	function __construct(){}		

	public static function data($a){ 
  
		$a['category2'] = array(
			"name" 	=> "Style 2 - Basic List",
			"image"	=> "category2.jpg",
			"cat"	=> "category",
			"widget" => "ppt-category",
			"desc" 	=> "", 
			"data" 	=> array(  ),
			"order" => 80,			
		);		
		
		return $a;
	
	} public static function output(){ global $CORE, $category_settings, $settings;
 
		// ALL DEFAULT FIELDS
		 $df = ppt_theme_blocks_defaults("category");
		 
		  
		// APPLY CUSTOM CHANGES 
		$cc = array(

		    "tax" 		=> "listing",
		    

			"title" 		=> $CORE->LAYOUT("get_placeholder_text_new", array("short", "pop_cats" ) ),
			"subtitle" 		=> "Quidam officiis similique sea ei, vel tollit indoctum efficiendi.", 

			"btn_show" => 1,
			"btn_txt" => $CORE->LAYOUT("get_placeholder_text_new", array("short", "more" ) ),
			
		 );
		 

		$df = array_merge($df, $cc); 
		
		// 1. ELEMENTOR
		if(!empty($category_settings)){
			foreach($df as $k => $v){				
				if(isset($category_settings[$k]) && $category_settings[$k] != "" ){
					$df[$k] = $category_settings[$k];
				}
			}
			
		// 2. HOME DESIGNS		
		}else{	
			 
		 	$settings =  $CORE->LAYOUT("get_block_settings_defaults_new", array("category", "category2" ) ); 
			
		 	foreach($df as $h => $j){
				if(isset($settings[$h]) && $settings[$h] != ""){
					$df[$h] = $settings[$h];
				}
			 } 
		}
		   

///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
	
	$limit = 100;
	if(isset($df['limit']) && $df['limit'] > 0){
	$limit = $df['limit'];
	} 
	
	 
	$hide_empty = 1;
	if(isset($df['hide_empty']) ){
			if($df['hide_empty'] == 1){

			}else{
				$hide_empty = 0;
			}
 
	} 
	
	$orderby = "menu_order";
	if(isset($df['orderby']) && $df['orderby'] != ""){
		$orderby = $df['orderby'];
	} 
	
	$order = "desc";
	if(isset($df['order']) && $df['order'] != ""){
		$order = $df['order'];
	} 
 
	$showOnlyCats = array();	
	if(!empty($df['cat'])){
		$showOnlyCats = $df['cat'];
		if(!is_array($showOnlyCats)){
		$showOnlyCats = array($showOnlyCats);
		}
	} 
	
	 
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

  
	$termdata = get_terms($df['tax'], 'orderby='.$orderby.'&order='.$order.'&hide_empty='.$hide_empty.'&parent=0');
 
	if(is_wp_error( $termdata )){ 
		echo $termdata->get_error_message(); 
		return;
	}
	$total_merchants = count($termdata);
 
	$data = array(); $i=1;
	foreach ($termdata as $term) {
 	
			if(!empty($showOnlyCats) && count($showOnlyCats) > 2 && !in_array($term->term_id,$showOnlyCats)){
			continue; 
			}
			
			if($i > $limit){
			$i++; continue;
			}
 
			// SUB CATS ONLY
			if(isset($df['cat_subs']) && $df['cat_subs'] == "1"){
			 
				$termdatasub = get_terms($df['tax'], 'orderby=count&order=desc&hide_empty='.$hide_empty.'&parent='.$term->term_id);
				if(is_wp_error( $termdatasub )){ 
					echo $termdatasub->get_error_message(); 
					return;
				}
				  
				foreach ($termdatasub as $terms) {
				
					if($i > $limit){
					 continue;
					}
					
					if(isset($df['image'.$i]) && strlen($df['image'.$i]) > 2){
					$img =  $df['image'.$i];
					}else{
					$img = do_shortcode('[CATEGORYIMAGE term_id="'.$terms->term_id.'" pathonly=1 placeholder=1 big=1 tax="'.$df['tax'].'"]');
					}
						
					$data[] = array( 
					"name"	=> $CORE->GEO("translation_tax", array($terms->term_id, $terms->name)),  
					"link"	=> get_term_link($terms), 
					"count"	=> $terms->count,  
					"image" => $img,
					"icon" 	=> do_shortcode('[CATEGORYIMAGE term_id="'.$terms->term_id.'" pathonly=1 placeholder=1 tax="listing"]'),
					); 
					
					$i++; 
				}
			
			// PARENT CAT
			}else{
			
			if($df['tax'] == "store"){
			$image = do_shortcode('[STOREIMAGE]');
	 		}else{
			$image = do_shortcode('[CATEGORYIMAGE term_id="'.$term->term_id.'" pathonly=1 placeholder=1 big=1 tax="'.$df['tax'].'"]');
			}
			
			if(isset($df['image'.$i]) && strlen($df['image'.$i]) > 2){
			$img =  $df['image'.$i];
			}else{
			$img = $image;
			}
			
			$data[] = array( 
				"name"	=> $CORE->GEO("translation_tax", array($term->term_id, $term->name)),  
				"link"	=> get_term_link($term), 
				"count"	=> $term->count,  
				"image" => $img,
				"icon" 	=> do_shortcode('[CATEGORYIMAGE term_id="'.$term->term_id.'" pathonly=1 placeholder=1 tax="'.$df['tax'].'"]'),
			); 
			
			$i++; 
			
			}
	
	}  
	
	if($orderby == "count"){
		usort($data, fn($a, $b) => $a['count'] <=> $b['count']);
		$data= array_reverse($data);
	}
 
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

	ob_start();
	?>

<section>
  <div class="container">
    <div class="row">


<?php if(strlen($df['title']) > 2){ ?>
<div class="col-12 mb-1">
<div class="d-flex justify-content-between align-items-center">
	<div>	
		<h3 class="mb-1" data-ppt-title><?php echo $df['title']; ?></h3>
		<?php if(strlen($df['subtitle']) > 2){ ?><div class="mb-3" data-ppt-subtitle><?php echo $df['subtitle']; ?></div><?php } ?>
	</div>

	<?php if($df['btn_show'] == "1" && strlen($df['btn_txt']) > 1){ ?>
	<div class="justify-content-center">
	<a href="<?php if(isset($df['btn_link']) && $df['btn_link'] != ""){ echo $df['btn_link']; }else{ ?><?php echo home_url(); ?>/?s=<?php } ?>"  data-ppt-btn data-ppt-btn-link class="btn-system btn-rounded-25 btn-md">
		<?php echo $df['btn_txt']; ?>
	</a>
	</div>
	<?php } ?>
</div>
</div>
<?php } ?>

 
      <?php $i=1; foreach($data as $cat){ ?>
      <div class="col-md-4 col-lg-3 mb-3 <?php if($i > 10000000000){ ?>hide-mobile<?php } ?>">
        <a href="<?php echo $cat['link']; ?>" class="text-decoration-none <?php if(!in_array($df['section_bg'],array("bg-dark")) ){?> text-dark<?php }else{ ?>text-light <?php } ?>">
        <div class="text-600 d-flex justify-content-between">
          <div>

		 <?php if($df['tax_icon']  =="star"){ ?>
		 <span class="fa fa-star text-primary mr-2"> </span>		 
		 <?php }elseif($df['tax_icon']  == "arrow"){ ?>
		 <span class="fa fa-arrow-right text-primary mr-2"> </span>
		 <?php }elseif($df['tax_icon']  == "plus"){ ?>
		 <span class="fa fa-plus-square text-primary mr-2"> </span>
		 <?php }elseif($df['tax_icon']  == "checkbox"){ ?>
		 <span class="fa fa-check-square text-primary mr-2"> </span>


		 

		  <?php }elseif($df['tax'] == "country" && empty($showOnlyCats) && $df['tax_icon'] != "hide" ){ ?>
		  <span class="flag mr-2 <?php echo $CORE->GEO("get_flagicon_from_name", array($cat['name'], $GLOBALS['core_country_list_new']));  ?>"> </span> 
		  <?php } ?>

		  <span><?php echo $cat['name']; ?></span>

          </div>

          <div>

		  <?php if($df['tax_count'] == "hide"){ ?>
		
			<?php }elseif($df['tax_count'] == "button"){ ?>

				<div class="px-2 text-center" style="min-width:30px;" ppt-border1><?php echo number_format($cat['count'],0); ?></div>
			
			<?php }elseif($df['tax_count'] == "op"){ ?>

				<span <?php if($cat['count'] == 0){ ?>class="opacity-5"<?php } ?>><?php echo number_format($cat['count'],0); ?></span>

			<?php }else{ ?>

            <?php echo number_format($cat['count'],0); ?>

			<?php } ?>


          </div>


        </div>
        </a>
      </div>
      <?php $i++; } 


?>
    </div>
  </div>
</section>
<?php
		$output = ob_get_contents();
		ob_end_clean();
		
echo ppt_theme_block_output($output, $df, array("category", "category2"));

	
	}
		public static function css(){
		ob_start();
		?>
<style>
 
 
.mobile-icon-text { font-size:14px !important; }

</style>
<?php	
		$output = ob_get_contents();
		ob_end_clean();
		echo $output;
		}	
		public static function js(){
		return "";
		ob_start();
		?>
<?php	
		$output = ob_get_contents();
		ob_end_clean();
		echo $output;
		}	
}

?>