 <?php
/* 
* Theme: PREMIUMPRESS CORE FRAMEWORK FILE
* Url: www.premiumpress.com
* Author: Mark Fail
*
* THIS FILE WILL BE UPDATED WITH EVERY UPDATE
* IF YOU WANT TO MODIFY THIS FILE, CREATE A CHILD THEME
*
* http://codex.wordpress.org/Child_Themes
*/
if (!defined('THEME_VERSION')) {	header('HTTP/1.0 403 Forbidden'); exit; }

global $CORE;
 
 
global $settings, $CORE, $CORE_ADMIN;
 	 
  $settings = array(
  
  "title" => __("Live Data","premiumpress"), 
  "desc" => __("Here you can see all the imported country data and active listing count for each.","premiumpress"), 
  
  "back-link" => "admin.php?page=locations",
   
  
  ); 




  
  
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////


$termdata = get_terms('country', 'orderby=count&order=desc&hide_empty=0&number=1000');
$total_cats = count($termdata);		

$categoryList = array();
$i=1; $sf = 0;
foreach ($termdata as $term) { 
 
	if($term->parent == "0"){
		
		$categoryList[$term->term_id] = array("id" => $term->term_id, "name" =>  $term->name, "slug" => $term->slug, "data" => array(), "count" => $term->count );
	
	}elseif(isset($categoryList[$term->parent])){

    // CHECK FOR CITIES
    $cityArray = array();
    $citydata = get_terms('country', 'hide_empty=0&number=1000&parent='.$term->term_id);
    if(!empty($citydata)){
      foreach ($citydata as $cd) { 
        $cityArray[] = array("id" => $cd->term_id, "name" =>  $cd->name, "slug" => $cd->slug, "count" => $cd->count );
      }
    }

		array_push($categoryList[$term->parent]['data'], array("id" => $term->term_id, "name" =>  $term->name, "slug" => $term->slug, "data" => $cityArray , "count" => $term->count ) );
 
  }
}
$total_parent_cats = count($categoryList);
$letters = range('A', 'Z');

$showmmorethan = 40;


///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

  
   _ppt_template('framework/admin/_form-wrap-top' ); ?>
 
<div class="card card-admin">
  <div class="card-body">
 

  <a href="edit-tags.php?taxonomy=country&post_type=listing_type" target="_blank" class="btn-system btn-sm float-right" data-ppt-btn><?php echo __("Edit Data","premiumpress") ?></a>

  <p class="mt-2 opacity-5"><?php echo __("List of all locations.","premiumpress") ?></p>
    
    <div class="tablist">
        
        <div class="tab tab-all active"><a href="javascript:void(0);" onclick="filterLetters('all');"><?php echo __("All","premiumpress") ?></a></div>
        
        <?php foreach($letters as $l){ ?>
        
        <div class="tab tab-<?php echo $l; ?>"><a href="javascript:void(0);" onclick="filterLetters('<?php echo $l; ?>');"><?php echo $l; ?></a></div>
        
        <?php } ?>
    </div>
    
    <div class="clearfix"></div>
    


   
    <?php foreach($letters as $l){ ?>
    <div class="wrap wrap-<?php echo $l; ?>" id="<?php echo $l; ?>">
    <h3><?php echo $l; ?></h3>
    <hr />
    <div class="row ">
   
		<?php $i =1; foreach($categoryList as $catid => $catdata){   ?>    
            
            <?php if(substr(strtolower($catdata['name']), 0,1) == strtolower($l)){ ?>
            
        <div class="col-md-4"> 

           <div class="clearfix mb-1" data-topcatid="<?php echo $catid; ?>">
           
                <div <?php if($catdata['count'] > 0){ ?>class="text-600"<?php } ?>>
                    
                    <a href="<?php echo get_term_link($catdata['slug'], "country"); ?>" target="_blank" class="text-dark">

                        <span class="flag <?php echo $CORE->GEO("get_flagicon_from_name", array($catdata['name'], $GLOBALS['core_country_list_new']));  ?>"></span>
                
                        <span class="ml-2"><?php echo $CORE->GEO("translation_tax", array($catdata['id'], $catdata['name'])); ?> <span class="<?php if($catdata['count'] > 0){ }else{ ?>small opacity-5<?php } ?>">(<?php echo $catdata['count']; ?>)</span></span>
                
                    </a>
        
                </div>
            
            </div>
            
            <?php if(isset($catdata['data']) && !empty($catdata['data'])){ ?>
            
                </div><div class="col-12"><div class="row small text-dark">
            
				<?php foreach($catdata['data'] as $subcat){ ?>                	
                    <div class="col-6 col-md-4 py-2 mobile-text-12">
                        <a href="<?php echo get_term_link($subcat['slug'], "country"); ?>" target="_blank"  class="text-dark">
                            <?php echo $CORE->GEO("translation_tax", array($subcat['id'], $subcat['name'])); ?> </a> <span class="<?php if($subcat['count'] > 0){ }else{ ?>small opacity-5<?php } ?>">(<?php echo $subcat['count']; ?>)</span> 
                        
                        
                        

                            <?php if(isset($subcat['data']) && !empty($subcat['data'])){  ?>  

<div class="mt-2">
 <?php foreach($subcat['data'] as $city){ ?> 

 <span> &#183; 
 
 <a href="<?php echo get_term_link($city['slug'], "country"); ?>" class="text-dark">
   <?php echo $CORE->GEO("translation_tax", array($city['id'], $city['name'])); ?>
 </a> 
 
 <span class="<?php if($city['count'] > 0){ }else{ ?>small opacity-5<?php } ?>">
   (<?php echo $city['count']; ?>)
 </span>

 </span>
 <?php } ?>
 </div>
<?php } ?>
                        
                        </div> 



                <?php } ?>
             </div></div>

             <div>

            <?php } ?>  
            
           </div>
            <?php $i++; } ?> 
           
            
        <?php } ?>  
  
 	</div>
    </div>
    <?php } ?>
       


	</div>
</div>

<style>
.tablist .tab { padding: 5px 15px; float:left;  }
.tablist .tab.active { background:#111; border-radius:4px; }
.tablist .tab.active a { color:#fff; font-weight:bold; }
.bg-image-wrap { height:130px; width:100%; border-radius:4px; position:relative; background: #fff; border: 1px solid #ddd; }
.bg-image-wrap .bg-image { background-size: unset; background-repeat: no-repeat;  }

@media (max-width: 575.98px) {
.bg-image-wrap { height:100px; }
.bg-image-wrap .bg-image {
    background-size: contain;
 
}
}
</style>
<script>
function filterLetters(l){
	
	jQuery(".tab").removeClass('active');
	jQuery(".tab-"+l).addClass('active');
	
	
	
	if(l == "all"){
		
		jQuery(".wrap").show();
		cleanCats();
		
	}else{
		jQuery(".wrap").hide();
		jQuery(".wrap-"+l).show();		
	}

}
function filterCategory(l){ 
	
	if(l == "all"){
		
		jQuery(".wrap").show();
		cleanCats();
		
	}else{
		jQuery(".wrap").hide();
		jQuery(".hascat-"+l).show();
				
	}

}

function cleanCats(){

	var a = jQuery(".wrap");
    a.each(function (a) {
        wrapid = jQuery(this).attr('id').toString();
		
	 
		var a = jQuery(".wrap-"+wrapid+" .category-wrap");
		a.each(function (a) {
			topid = jQuery(this).attr('data-topcatid');
			
			jQuery('.wrap-'+wrapid+'').addClass(" hascat-"+topid)
			 
		});  
		
		 
		links = jQuery('.wrap-'+wrapid+' a').length; 
		if(links == 0){
			jQuery(this).hide();
			jQuery('.tablist').removeClass('justify-content-between');
			jQuery(".tab-"+wrapid).hide();
			 
		}
    }); 

}

jQuery(document).ready(function(){

cleanCats();

});

</script>
<?php _ppt_template('framework/admin/_form-wrap-bottom' ); ?> 
