/**
 * Donutty ~ Create SVG donut charts with Javascript
 * 19/10/2022
 * @author simeydotme <simey.me@gmail.com>
 * @version 2.4.0
 * @license ISC
 * @link http://simey.me
 * @preserve
 */
!function(o,t){var i,n="http://www.w3.org/2000/svg";function e(t){return void 0!==t}function s(t){return parseFloat(t,10)}function r(t){return e(t)&&(!0===t||"true"===t)}(i=t.Donutty=function(t,i){return t&&"string"==typeof t?this.$wrapper=o.querySelectorAll(t)[0]:t instanceof window.HTMLElement?this.$wrapper=t:(this.$wrapper=o.body,i=t),this.$wrapper&&(e(i)||(i=this.getOptionsFromTag()),this.id=Math.random().toString(36).substr(2,5),this.state={},this.options=i||{},this.options.min=e(this.options.min)?s(this.options.min):0,this.options.max=e(this.options.max)?s(this.options.max):100,this.options.value=e(this.options.value)?s(this.options.value):50,this.options.round=!e(this.options.round)||r(this.options.round),this.options.circle=!e(this.options.circle)||r(this.options.circle),this.options.padding=e(this.options.padding)?s(this.options.padding):4,this.options.radius=s(this.options.radius)||50,this.options.thickness=s(this.options.thickness)||10,this.options.bg=this.options.bg||"rgba(70, 130, 180, 0.15)",this.options.color=this.options.color||"mediumslateblue",this.options.transition=this.options.transition||"all 1.2s cubic-bezier(0.57, 0.13, 0.18, 0.98)",this.options.text=!!e(this.options.text)&&this.options.text,this.options.title=e(this.options.title)?this.options.title:function(){return"Donut Chart Graphic"},this.options.desc=e(this.options.desc)?this.options.desc:function(t){return"A donut chart ranging from "+t.min+" to "+t.max+" with a current value of "+t.value+"."},this.options.dir=!!e(this.options.dir)&&this.options.dir,this.options.anchor=e(this.options.anchor)&&"top"===this.options.anchor?"top":"bottom",this.options.dir||(this.options.dir=this.$wrapper.dir),this.options.dir||(this.options.dir=document.body.parentElement.dir),this.init()),this}).prototype.getOptionsFromTag=function(){return JSON.parse(JSON.stringify(this.$wrapper.dataset))},i.prototype.init=function(){var t;return(this.$wrapper.donutty=this).createState(),t=this.getDashValues(),this.createSvg(),this.createBg(t),this.createDonut(t),this.createText(),this.createAccessibility(),this.insertFragments(t),this},i.prototype.createState=function(){return this.state.min=this.options.min,this.state.max=this.options.max,this.state.value=this.options.value,this.state.bg=this.options.bg,this.state.color=this.options.color,this},i.prototype.createText=function(){return"function"==typeof this.options.text&&(this.$text=o.createElement("span"),this.$text.setAttribute("class","donut-text"),this.$text.style.opacity=0,this.updateText()),this},i.prototype.createAccessibility=function(){return this.$title=o.createElementNS(n,"title"),this.$title.setAttribute("id","chartTitle-"+this.id),this.$title.setAttribute("class","donut-title"),this.$desc=o.createElementNS(n,"desc"),this.$desc.setAttribute("id","chartDesc-"+this.id),this.$desc.setAttribute("class","donut-desc"),this.updateAccessibility(),this},i.prototype.createBg=function(t){return this.$bg=o.createElementNS(n,"circle"),this.$bg.setAttribute("cx","50%"),this.$bg.setAttribute("cy","50%"),this.$bg.setAttribute("r",this.options.radius),this.$bg.setAttribute("fill","transparent"),this.$bg.setAttribute("stroke",this.state.bg),this.$bg.setAttribute("stroke-width",this.options.thickness+this.options.padding),this.$bg.setAttribute("stroke-dasharray",t.full*t.multiplier),this.$bg.setAttribute("class","donut-bg"),this.options.round&&this.$bg.setAttribute("stroke-linecap","round"),this},i.prototype.createDonut=function(t){return this.$donut=o.createElementNS(n,"circle"),this.$donut.setAttribute("fill","transparent"),this.$donut.setAttribute("cx","50%"),this.$donut.setAttribute("cy","50%"),this.$donut.setAttribute("r",this.options.radius),this.$donut.setAttribute("stroke",this.state.color),this.$donut.setAttribute("stroke-width",this.options.thickness),this.$donut.setAttribute("stroke-dashoffset",t.full),this.$donut.setAttribute("stroke-dasharray",t.full),this.$donut.setAttribute("class","donut-fill"),this.$donut.style.opacity=0,this.options.round&&this.$donut.setAttribute("stroke-linecap","round"),this},i.prototype.createSvg=function(){var t=2*this.options.radius+this.options.thickness+1,i=this.options.round?this.options.thickness/3:0,s=this.options.circle?90+i:-225,e=("rtl"===this.options.dir?"-1":"1")+","+("top"===this.options.anchor?"-1":"1");return 0<=this.options.padding&&(t+=this.options.padding),this.$html=o.createDocumentFragment(),this.$svg=o.createElementNS(n,"svg"),this.$svg.setAttribute("xmlns",n),this.$svg.setAttribute("viewbox","0 0 "+t+" "+t),this.$svg.setAttribute("width","100%"),this.$svg.setAttribute("style","transform: scale("+e+") rotate("+s+"deg)"),this.$svg.setAttribute("preserveAspectRatio","xMidYMid meet"),this.$svg.setAttribute("class","donut"),this.$svg.setAttribute("role","img"),this.$svg.setAttribute("aria-labelledby","chartTitle-"+this.id+" chartDesc-"+this.id),this.$svg.setAttribute("role","img"),this},i.prototype.insertFragments=function(t){this.$svg.appendChild(this.$title),this.$svg.appendChild(this.$desc),this.$svg.appendChild(this.$bg),this.$svg.appendChild(this.$donut),this.$html.appendChild(this.$svg),this.$text&&this.$html.appendChild(this.$text),this.$wrapper.appendChild(this.$html),this.$wrapper.innerHTML=this.$wrapper.innerHTML,this.$svg=this.$wrapper.querySelector(".donut"),this.$bg=this.$wrapper.querySelector(".donut-bg"),this.$donut=this.$wrapper.querySelector(".donut-fill"),this.$title=this.$wrapper.querySelector(".donut-title"),this.$desc=this.$wrapper.querySelector(".donut-desc"),this.$text&&(this.$text=this.$wrapper.querySelector(".donut-text")),this.animate(t.fill,t.full)},i.prototype.getDashValues=function(){var t,i,s,e;return e=this.options.circle?1:.75,s=(t=2*Math.PI*this.options.radius)-t*e/100*(i=(this.state.value-this.state.min)/(this.state.max-this.state.min)*100),this.options.round&&this.options.circle&&i<100&&s<this.options.thickness&&(s=this.options.thickness),{fill:s,full:t,multiplier:e}},i.prototype.animate=function(t,i){var s=this;this.$bg.style.transition=this.options.transition,this.$donut.style.transition=this.options.transition,this.$text&&(this.$text.style.transition=this.options.transition),window.setTimeout(function(){s.$bg.setAttribute("stroke",s.state.bg),s.$bg.style.opacity=1,s.$donut.setAttribute("stroke-dashoffset",t),s.$donut.setAttribute("stroke-dasharray",i),s.$donut.setAttribute("stroke",s.state.color),s.$donut.style.opacity=1,s.$text&&(s.$text.style.opacity=1)},16)},i.prototype.updateText=function(){return"function"==typeof this.options.text&&(this.$text.innerHTML=this.options.text(this.state)),this},i.prototype.updateAccessibility=function(){return"function"==typeof this.options.title?this.$title.innerHTML=this.options.title(this.state):this.$title.innerHTML=this.options.title,"function"==typeof this.options.desc?this.$desc.innerHTML=this.options.desc(this.state):this.$desc.innerHTML=this.options.desc,this},i.prototype.set=function(t,i){var s;return e(t)&&e(i)&&(this.state[t]=i,s=this.getDashValues(),this.updateText(),this.updateAccessibility(),this.animate(s.fill,s.full)),this},i.prototype.setState=function(t){var i;return e(t.value)&&(this.state.value=t.value),e(t.min)&&(this.state.min=t.min),e(t.max)&&(this.state.max=t.max),e(t.bg)&&(this.state.bg=t.bg),e(t.color)&&(this.state.color=t.color),i=this.getDashValues(),this.updateText(),this.updateAccessibility(),this.animate(i.fill,i.full),this}}(document,window),function(i){var t=document,s=function(){var t=document.querySelectorAll("[data-donutty]");Array.prototype.forEach.call(t,function(t){new i(t)})};"complete"===t.readyState||"loading"!==t.readyState&&!t.documentElement.doScroll?s():t.addEventListener("DOMContentLoaded",s)}(Donutty);