<?php
error_reporting(E_ALL & ~E_WARNING & ~E_NOTICE & ~E_DEPRECATED);
session_start();
ob_start();
if(empty($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest') {
    die();
}
require_once("../../db/connection.php");
require_once("../../backend/functions.php");
session_write_close();
$settings = get_settings();
if(!empty($settings['timezone'])) {
    date_default_timezone_set($settings['timezone']);
}
$now = date('Y-m-d H:i:s');
$id_virtualtour = (int)$_POST['id_virtualtour'];
$email = strtolower(trim(strip_tags($_POST['email'])));
$name = trim(strip_tags($_POST['name']));
$company = trim(strip_tags($_POST['company']));
$phone = trim(strip_tags($_POST['phone']));
$check = (int)$_POST['check'];
$webhook_url = "";
$query = "SELECT protect_lead_webhook_url FROM svt_virtualtours WHERE id=$id_virtualtour LIMIT 1;";
$result = $mysqli->query($query);
if($result->num_rows == 1) {
    $row = $result->fetch_array(MYSQLI_ASSOC);
    $webhook_url = $row['protect_lead_webhook_url'];
}
$query_check = "SELECT * FROM svt_leads WHERE id_virtualtour=? AND email=? LIMIT 1;";
if($smt = $mysqli->prepare($query_check)) {
    $smt->bind_param('is', $id_virtualtour, $email);
    $result_check = $smt->execute();
    if ($result_check) {
        $result_check = get_result($smt);
        if (count($result_check) == 1) {
            ob_end_clean();
            echo json_encode(array("status"=>"ok"));
            exit;
        } else {
            if($check==0) {
                $query = "INSERT INTO svt_leads(id_virtualtour,name,company,email,phone,datetime) VALUES(?,?,?,?,?,?);";
                if($smt = $mysqli->prepare($query)) {
                    $smt->bind_param('isssss',  $id_virtualtour,$name,$company,$email,$phone,$now);
                    $result = $smt->execute();
                    if ($result) {
                        if(!empty($webhook_url)) {
                            $data = [
                                'event' => 'lead.created',
                                'data' => [
                                    'id_virtualtour' => $id_virtualtour,
                                    'name' => $name,
                                    'email' => $email,
                                    'company' => $company,
                                    'phone' => $phone,
                                ],
                            ];
                            $jsonData = json_encode($data);
                            $ch = curl_init($webhook_url);
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($ch, CURLOPT_POST, true);
                            curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
                            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                                'Content-Type: application/json',
                                'Content-Length: ' . strlen($jsonData)
                            ]);
                            $response = curl_exec($ch);
                            curl_close($ch);
                        }
                        ob_end_clean();
                        echo json_encode(array("status"=>"ok"));
                        exit;
                    }
                }
            }
        }
    }
}
ob_end_clean();
echo json_encode(array("status"=>"error"));
exit;