CREATE TABLE IF NOT EXISTS `svt_plans` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` text,
  `description` longtext,
  `n_virtual_tours` smallint(5) NOT NULL DEFAULT '-1',
  `n_virtual_tours_month` smallint(5) NOT NULL DEFAULT '-1',
  `n_rooms` smallint(5) NOT NULL DEFAULT '-1',
  `n_rooms_tour` smallint(5) NOT NULL DEFAULT '-1',
  `n_markers` smallint(5) NOT NULL DEFAULT '-1',
  `n_pois` smallint(5) NOT NULL DEFAULT '-1',
  `n_gallery_images` smallint(5) NOT NULL DEFAULT '-1',
  `n_ai_generate_month` smallint(5) NOT NULL DEFAULT '-1',
  `ai_generate_mode` enum('credit','month') DEFAULT 'month',
  `n_autoenhance_generate_month` smallint(5) NOT NULL DEFAULT '-1',
  `autoenhance_generate_mode` enum('credit','month') DEFAULT 'month',
  `n_gsv_publish_month` smallint(5) NOT NULL DEFAULT '-1',
  `gsv_publish_mode` enum('credit','month') DEFAULT 'month',
  `n_custom_domain` smallint(5) NOT NULL DEFAULT '-1',
  `days` smallint(5) NOT NULL DEFAULT '-1',
  `create_landing` tinyint(1) NOT NULL DEFAULT '1',
  `create_showcase` tinyint(1) NOT NULL DEFAULT '1',
  `create_globes` tinyint(1) NOT NULL DEFAULT '1',
  `create_gallery` tinyint(1) NOT NULL DEFAULT '1',
  `create_presentation` tinyint(1) NOT NULL DEFAULT '1',
  `enable_live_session` tinyint(1) NOT NULL DEFAULT '1',
  `enable_meeting` tinyint(1) NOT NULL DEFAULT '1',
  `enable_chat` tinyint(1) NOT NULL DEFAULT '1',
  `enable_voice_commands` tinyint(1) NOT NULL DEFAULT '1',
  `enable_share` tinyint(1) NOT NULL DEFAULT '1',
  `enable_device_orientation` tinyint(1) NOT NULL DEFAULT '1',
  `enable_webvr` tinyint(1) NOT NULL DEFAULT '1',
  `enable_logo` tinyint(1) NOT NULL DEFAULT '1',
  `enable_nadir_logo` tinyint(1) NOT NULL DEFAULT '1',
  `enable_song` tinyint(1) NOT NULL DEFAULT '1',
  `enable_forms` tinyint(1) NOT NULL DEFAULT '1',
  `enable_annotations` tinyint(1) NOT NULL DEFAULT '1',
  `enable_rooms_multiple` tinyint(1) NOT NULL DEFAULT '1',
  `enable_rooms_protect` tinyint(1) NOT NULL DEFAULT '1',
  `enable_info_box` tinyint(1) NOT NULL DEFAULT '1',
  `enable_context_info` tinyint(1) NOT NULL DEFAULT '1',
  `enable_maps` tinyint(1) NOT NULL DEFAULT '1',
  `enable_icons_library` tinyint(1) NOT NULL DEFAULT '1',
  `enable_media_library` tinyint(1) NOT NULL DEFAULT '1',
  `enable_music_library` tinyint(1) NOT NULL DEFAULT '1',
  `enable_sound_library` tinyint(1) NOT NULL DEFAULT '1',
  `enable_password_tour` tinyint(1) NOT NULL DEFAULT '1',
  `enable_expiring_dates` tinyint(1) NOT NULL DEFAULT '1',
  `enable_statistics` tinyint(1) NOT NULL DEFAULT '1',
  `enable_flyin` tinyint(1) NOT NULL DEFAULT '1',
  `enable_auto_rotate` tinyint(1) NOT NULL DEFAULT '1',
  `enable_multires` tinyint(1) NOT NULL DEFAULT '1',
  `enable_export_vt` tinyint(1) NOT NULL DEFAULT '1',
  `enable_import_export` tinyint(1) NOT NULL DEFAULT '1',
  `enable_download_slideshow` tinyint(1) NOT NULL DEFAULT '1',
  `enable_shop` tinyint(1) NOT NULL DEFAULT '1',
  `enable_learning` tinyint(1) NOT NULL DEFAULT '1',
  `enable_dollhouse` tinyint(1) NOT NULL DEFAULT '1',
  `enable_measurements` tinyint(1) NOT NULL DEFAULT '1',
  `enable_editor_ui` tinyint(1) NOT NULL DEFAULT '1',
  `enable_custom_html` tinyint(1) NOT NULL DEFAULT '1',
  `enable_metatag` tinyint(1) NOT NULL DEFAULT '1',
  `enable_loading_iv` tinyint(1) NOT NULL DEFAULT '1',
  `enable_panorama_video` tinyint(1) NOT NULL DEFAULT '1',
  `enable_ai_room` tinyint(1) NOT NULL DEFAULT '1',
  `enable_autoenhance_room` tinyint(1) NOT NULL DEFAULT '1',
  `create_video360` tinyint(1) NOT NULL DEFAULT '1',
  `create_video_projects` tinyint(1) NOT NULL DEFAULT '1',
  `enable_comments` tinyint(1) NOT NULL DEFAULT '1',
  `enable_multilanguage` tinyint(1) NOT NULL DEFAULT '1',
  `enable_auto_translation` tinyint(1) NOT NULL DEFAULT '1',
  `enable_poweredby` tinyint(1) NOT NULL DEFAULT '1',
  `enable_avatar_video` tinyint(1) NOT NULL DEFAULT '1',
  `enable_intro_slider` tinyint(1) NOT NULL DEFAULT '1',
  `enable_gsv_publish` tinyint(1) NOT NULL DEFAULT '1',
  `enable_custom_domain` tinyint(1) NOT NULL DEFAULT '1',
  `enable_snapshot` tinyint(1) NOT NULL DEFAULT '1',
  `max_file_size_upload` smallint(5) NOT NULL DEFAULT '-1',
  `max_storage_space` smallint(5) NOT NULL DEFAULT '-1',
  `price` float NOT NULL DEFAULT '0',
  `price2` float NOT NULL DEFAULT '0',
  `price_label` text,
  `currency` varchar(3) NOT NULL DEFAULT 'USD',
  `frequency` enum('one_time','recurring','month_year') DEFAULT 'recurring',
  `interval_count` smallint(5) NOT NULL DEFAULT '1',
  `id_product_stripe` text,
  `id_price_stripe` text,
  `id_price2_stripe` text,
  `id_plan_paypal` text,
  `id_plan2_paypal` text,
  `id_product_2checkout` text,
  `id_product2_2checkout` text,
  `custom_features` text,
  `show_features` tinyint(1) NOT NULL DEFAULT '1',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `external_url` text,
  `customize_menu` text,
  `expire_tours` tinyint(1) NOT NULL DEFAULT '1',
  `button_type` enum('default','custom') DEFAULT 'default',
  `button_text` text,
  `button_icon` text,
  `override_sample` tinyint(1) NOT NULL DEFAULT '0',
  `enable_sample` tinyint(1) NOT NULL DEFAULT '1',
  `id_vt_sample` text,
  `override_template` tinyint(1) NOT NULL DEFAULT '0',
  `id_vt_template` bigint(20) unsigned DEFAULT NULL,
  `position` smallint(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT IGNORE INTO `svt_plans` (`id`, `name`) VALUES(1, 'Unlimited');

CREATE TABLE IF NOT EXISTS `svt_plans_lang` (
  `id_plan` bigint(20) unsigned DEFAULT NULL,
  `language` varchar(10) DEFAULT NULL,
  `name` text,
  `price_label` text,
  `description` longtext,
  `custom_features` text,
  `button_text` text,
UNIQUE KEY `id_plan` (`id_plan`,`language`),
CONSTRAINT `svt_plans_lang_ibfk_1` FOREIGN KEY (`id_plan`) REFERENCES `svt_plans` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_users` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `username` text,
  `email` text,
  `password` text,
  `role` varchar(50) DEFAULT 'customer',
  `super_admin` tinyint(1) NOT NULL DEFAULT '0',
  `id_plan` bigint(20) DEFAULT '1',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `forgot_code` text,
  `hash` text,
  `registration_date` timestamp DEFAULT CURRENT_TIMESTAMP,
  `expire_plan_date` datetime DEFAULT NULL,
  `expire_plan_date_manual` datetime DEFAULT NULL,
  `id_customer_stripe` text,
  `id_customer_2checkout` text,
  `id_subscription_stripe` text,
  `id_subscription_paypal` text,
  `id_subscription_2checkout` text,
  `status_subscription_stripe` tinyint(1) NOT NULL DEFAULT '0',
  `status_subscription_paypal` tinyint(1) NOT NULL DEFAULT '0',
  `status_subscription_2checkout` tinyint(1) NOT NULL DEFAULT '0',
  `language` text,
  `avatar` text,
  `first_name` text,
  `last_name` text,
  `company` text,
  `tax_id` text,
  `street` text,
  `city` text,
  `province` text,
  `postal_code` text,
  `country` text,
  `tel` text,
  `storage_space` float NOT NULL DEFAULT '0',
  `google_identifier` text,
  `facebook_identifier` text,
  `twitter_identifier` text,
  `wechat_identifier` text,
  `qq_identifier` text,
  `2fa_secretkey` text,
  `ai_credits` smallint(5) NOT NULL DEFAULT '0',
  `autoenhance_credits` smallint(5) NOT NULL DEFAULT '0',
  `gsv_publish_credits` smallint(5) NOT NULL DEFAULT '0',
  `services_credits` smallint(5) NOT NULL DEFAULT '0',
  `note` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT IGNORE INTO `svt_users` (`id`, `username`, `email`, `password`, `role`, `super_admin`) VALUES(1, '<USER_NAME>','<USER_EMAIL>', MD5(<PASSWORD>), 'administrator',1);

CREATE TABLE IF NOT EXISTS `svt_categories` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` text,
  `icon` text,
  `background` varchar(7) NOT NULL DEFAULT '#f8f9fa',
  `color` varchar(7) NOT NULL DEFAULT '#000000',
  `position` smallint(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_categories_lang` (
    `id_category` int(11) unsigned DEFAULT NULL,
    `language` varchar(10) DEFAULT NULL,
    `name` text,
    UNIQUE KEY `id_category` (`id_category`,`language`),
    CONSTRAINT `svt_categories_lang_ibfk_1` FOREIGN KEY (`id_category`) REFERENCES `svt_categories` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_virtualtours` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `id_user` int(11) unsigned DEFAULT NULL,
  `author` text,
  `date_created` date DEFAULT NULL,
  `name` text,
  `code` text,
  `hfov` smallint(5) NOT NULL DEFAULT '100',
  `min_hfov` smallint(5) NOT NULL DEFAULT '60',
  `max_hfov` smallint(5) NOT NULL DEFAULT '100',
  `hfov_mobile_ratio` float NOT NULL DEFAULT '1',
  `pan_speed` float NOT NULL DEFAULT '1',
  `pan_speed_mobile` float NOT NULL DEFAULT '2',
  `friction` float NOT NULL DEFAULT '0.1',
  `friction_mobile` float NOT NULL DEFAULT '0.4',
  `zoom_friction` float NOT NULL DEFAULT '0.05',
  `zoom_friction_mobile` float NOT NULL DEFAULT '0.05',
  `zoom_to_pointer` tinyint(1) NOT NULL DEFAULT '0',
  `mouse_zoom` tinyint(1) NOT NULL DEFAULT '1',
  `song` text,
  `song_bg_volume` float NOT NULL DEFAULT '1.0',
  `song_autoplay` tinyint(1) NOT NULL DEFAULT '0',
  `logo` text,
  `link_logo` text,
  `nadir_logo` text,
  `nadir_round` tinyint(1) NOT NULL DEFAULT '0',
  `nadir_size` varchar(8) NOT NULL DEFAULT '100px',
  `autorotate_speed` smallint(5) NOT NULL DEFAULT '0',
  `autorotate_inactivity` smallint(5) NOT NULL DEFAULT '0',
  `presentation_inactivity` smallint(5) NOT NULL DEFAULT '0',
  `markers_icon` varchar(50) NOT NULL DEFAULT 'fas fa-chevron-circle-up',
  `markers_icon_type` enum('round','square','round_outline','square_outline','stroke') DEFAULT 'round',
  `markers_id_icon_library` bigint(20) unsigned NOT NULL DEFAULT 0,
  `markers_background` varchar(28) NOT NULL DEFAULT 'rgba(255,255,255,0.7)',
  `markers_color` varchar(7) NOT NULL DEFAULT '#000000',
  `markers_show_room` tinyint(1) NOT NULL DEFAULT '1',
  `markers_tooltip_type` enum('none','text','preview','preview_square','preview_rect','room_name') NOT NULL DEFAULT 'none',
  `markers_tooltip_visibility` enum('hover','visible','visible_mobile') NOT NULL DEFAULT 'hover',
  `markers_tooltip_background` varchar(28) NOT NULL DEFAULT 'rgba(255,255,255,1)',
  `markers_tooltip_color` varchar(7) NOT NULL DEFAULT '#000000',
  `markers_default_lookat` tinyint(1) NOT NULL DEFAULT '1',
  `markers_default_backlink` tinyint(1) NOT NULL DEFAULT '0',
  `markers_default_scale` tinyint(1) NOT NULL DEFAULT '0',
  `markers_default_sticky` tinyint(1) NOT NULL DEFAULT '0',
  `markers_default_rotateX` smallint(5) NOT NULL DEFAULT '0',
  `markers_default_rotateZ` smallint(5) NOT NULL DEFAULT '0',
  `markers_default_size_scale` float NOT NULL DEFAULT '1',
  `markers_default_sound` text,
  `markers_animation` varchar(10) NOT NULL DEFAULT 'none',
  `pois_icon` varchar(50) NOT NULL DEFAULT 'fas fa-info-circle',
  `pois_icon_type` enum('round','square','round_outline','square_outline','stroke') DEFAULT 'round',
  `pois_id_icon_library` bigint(20) unsigned NOT NULL DEFAULT 0,
  `pois_background` varchar(28) NOT NULL DEFAULT 'rgba(255,255,255,0.7)',
  `pois_color` varchar(7) NOT NULL DEFAULT '#000000',
  `pois_style` tinyint(1) NOT NULL DEFAULT '0',
  `pois_tooltip_type` enum('none','text') NOT NULL DEFAULT 'none',
  `pois_tooltip_visibility` enum('hover','visible','visible_mobile') NOT NULL DEFAULT 'hover',
  `pois_tooltip_background` varchar(28) NOT NULL DEFAULT 'rgba(255,255,255,1)',
  `pois_tooltip_color` varchar(7) NOT NULL DEFAULT '#000000',
  `pois_default_scale` tinyint(1) NOT NULL DEFAULT '0',
  `pois_default_sticky` tinyint(1) NOT NULL DEFAULT '0',
  `pois_default_rotateX` smallint(5) NOT NULL DEFAULT '0',
  `pois_default_rotateZ` smallint(5) NOT NULL DEFAULT '0',
  `pois_default_size_scale` float NOT NULL DEFAULT '1',
  `pois_default_sound` text,
  `pois_animation` varchar(10) NOT NULL DEFAULT 'none',
  `arrows_nav` tinyint(1) NOT NULL DEFAULT '1',
  `info_box` longtext,
  `info_box_type` enum('popup','panel') NOT NULL DEFAULT 'popup',
  `dollhouse` longtext,
  `dollhouse_glb` text,
  `password` text,
  `password_title` text,
  `password_description` text,
  `protect_type` enum('none','password','lead','mailchimp') NOT NULL DEFAULT 'none',
  `protect_send_email` tinyint(1) NOT NULL DEFAULT '0',
  `protect_email` text,
  `protect_remember` tinyint(1) NOT NULL DEFAULT '1',
  `protect_mc_form` longtext,
  `protect_lead_params` text,
  `protect_lead_webhook_url` text,
  `voice_commands` tinyint(1) NOT NULL DEFAULT '0',
  `compass` tinyint(1) NOT NULL DEFAULT '1',
  `background_image` text,
  `background_video` text,
  `background_image_mobile` text,
  `background_video_mobile` text,
  `background_video_delay` smallint(5) NOT NULL DEFAULT '0',
  `background_video_delay_mobile` smallint(5) NOT NULL DEFAULT '0',
  `background_video_skip` tinyint(1) NOT NULL DEFAULT '1',
  `background_video_skip_mobile` tinyint(1) NOT NULL DEFAULT '1',
  `auto_start` tinyint(1) NOT NULL DEFAULT '1',
  `hide_loading` tinyint(1) NOT NULL DEFAULT '0',
  `show_background` tinyint(1) NOT NULL DEFAULT '1',
  `loading_background_color` varchar(7) DEFAULT '#343434',
  `loading_text_color` varchar(7) DEFAULT '#ffffff',
  `description` text,
  `ga_tracking_id` text,
  `friendly_url` text,
  `friendly_l_url` text,
  `compress_jpg` smallint(5) NOT NULL DEFAULT '90',
  `max_width_compress` smallint(5) NOT NULL DEFAULT '8192',
  `quality_viewer` float NOT NULL DEFAULT '1',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `sameAzimuth` tinyint(1) NOT NULL DEFAULT '0',
  `autoclose_menu` tinyint(1) NOT NULL DEFAULT '0',
  `autoopen_menu` tinyint(1) NOT NULL DEFAULT '0',
  `auto_show_slider` tinyint(1) NOT NULL DEFAULT '0',
  `autoclose_slider` tinyint(1) NOT NULL DEFAULT '0',
  `nav_slider` tinyint(1) NOT NULL DEFAULT '0',
  `nav_slider_mode` tinyint(1) NOT NULL DEFAULT '0',
  `form_icon` varchar(50) NOT NULL DEFAULT 'fas fa-file-signature',
  `form_content` text,
  `html_landing` longtext,
  `fb_messenger` tinyint(1) NOT NULL DEFAULT '0',
  `fb_page_id` text,
  `whatsapp_chat` tinyint(1) NOT NULL DEFAULT '0',
  `whatsapp_number` text,
  `show_info` tinyint(1) NOT NULL DEFAULT '1',
  `show_dollhouse` tinyint(1) NOT NULL DEFAULT '0',
  `show_custom` tinyint(1) NOT NULL DEFAULT '0',
  `show_custom2` tinyint(1) NOT NULL DEFAULT '0',
  `show_custom3` tinyint(1) NOT NULL DEFAULT '0',
  `show_custom4` tinyint(1) NOT NULL DEFAULT '0',
  `show_custom5` tinyint(1) NOT NULL DEFAULT '0',
  `show_media` tinyint(1) NOT NULL DEFAULT '0',
  `custom_content` longtext,
  `custom2_content` longtext,
  `custom3_content` longtext,
  `custom4_content` longtext,
  `custom5_content` longtext,
  `media_file` text,
  `poweredby_type` enum('text','image') NOT NULL DEFAULT 'image',
  `poweredby_image` text,
  `poweredby_text` text,
  `poweredby_link` text,
  `show_location` tinyint(1) NOT NULL DEFAULT '0',
  `show_comments` tinyint(1) NOT NULL DEFAULT '0',
  `disqus_shortname` text,
  `disqus_public_key` text,
  `location_content` longtext,
  `show_vt_title` tinyint(1) NOT NULL DEFAULT '1',
  `show_language` tinyint(1) NOT NULL DEFAULT '1',
  `show_logo` tinyint(1) NOT NULL DEFAULT '1',
  `show_poweredby` tinyint(1) NOT NULL DEFAULT '1',
  `show_avatar_video` tinyint(1) NOT NULL DEFAULT '1',
  `show_gallery` tinyint(1) NOT NULL DEFAULT '1',
  `gallery_mode` enum('images','slideshow') NOT NULL DEFAULT 'images',
  `gallery_params` text,
  `show_chat` tinyint(1) NOT NULL DEFAULT '1',
  `show_icons_toggle` tinyint(1) NOT NULL DEFAULT '1',
  `show_icons_content_toggle` tinyint(1) NOT NULL DEFAULT '0',
  `show_icons_nav_toggle` tinyint(1) NOT NULL DEFAULT '0',
  `show_measures_toggle` tinyint(1) NOT NULL DEFAULT '1',
  `show_autorotation_toggle` tinyint(1) NOT NULL DEFAULT '1',
  `show_nav_control` tinyint(1) NOT NULL DEFAULT '0',
  `show_presentation` tinyint(1) NOT NULL DEFAULT '1',
  `show_main_form` tinyint(1) NOT NULL DEFAULT '0',
  `show_inline_form` tinyint(1) NOT NULL DEFAULT '0',
  `show_share` tinyint(1) NOT NULL DEFAULT '1',
  `show_device_orientation` tinyint(1) NOT NULL DEFAULT '1',
  `drag_device_orientation` tinyint(1) NOT NULL DEFAULT '1',
  `show_webvr` tinyint(1) NOT NULL DEFAULT '1',
  `webvr_new_window` tinyint(1) NOT NULL DEFAULT '0',
  `show_map` tinyint(1) NOT NULL DEFAULT '1',
  `autoclose_map` tinyint(1) NOT NULL DEFAULT '0',
  `show_map_tour` tinyint(1) NOT NULL DEFAULT '1',
  `show_fullscreen` tinyint(1) NOT NULL DEFAULT '1',
  `show_audio` tinyint(1) NOT NULL DEFAULT '1',
  `show_snapshot` tinyint(1) NOT NULL DEFAULT '0',
  `snapshot_params` text,
  `live_session` tinyint(1) NOT NULL DEFAULT '0',
  `meeting` tinyint(1) NOT NULL DEFAULT '0',
  `show_annotations` tinyint(1) NOT NULL DEFAULT '1',
  `show_list_alt` tinyint(1) NOT NULL DEFAULT '0',
  `autoclose_list_alt` tinyint(1) NOT NULL DEFAULT '0',
  `grouped_list_alt` tinyint(1) NOT NULL DEFAULT '1',
  `list_alt` text,
  `intro_desktop` text,
  `intro_desktop_hide` smallint(5) NOT NULL DEFAULT '5',
  `intro_mobile` text,
  `intro_mobile_hide` smallint(5) NOT NULL DEFAULT '5',
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `start_url` text,
  `end_url` text,
  `auto_presentation_speed` smallint(5) NOT NULL DEFAULT '5',
  `presentation_video` text,
  `presentation_type` enum('manual','automatic','video') NOT NULL DEFAULT 'manual',
  `presentation_loop` tinyint(1) NOT NULL DEFAULT '0',
  `presentation_stop_click` tinyint(1) NOT NULL DEFAULT '0',
  `presentation_stop_id_room` bigint(20) unsigned DEFAULT '0',
  `presentation_view_pois` tinyint(1) NOT NULL DEFAULT '0',
  `presentation_view_measures` tinyint(1) NOT NULL DEFAULT '0',
  `enable_multires` tinyint(1) NOT NULL DEFAULT '0',
  `keep_original_panorama` tinyint(1) NOT NULL DEFAULT '1',
  `transition_loading` tinyint(1) NOT NULL DEFAULT '1',
  `transition_time` smallint(5) NOT NULL DEFAULT '300',
  `transition_zoom` smallint(5) NOT NULL DEFAULT '20',
  `transition_fadeout` smallint(5) NOT NULL DEFAULT '300',
  `transition_effect` varchar(10) NOT NULL DEFAULT 'puff',
  `transition_hfov` smallint(5) NOT NULL DEFAULT '10',
  `transition_hfov_time` smallint(5) NOT NULL DEFAULT '300',
  `note` text,
  `flyin` tinyint(1) NOT NULL DEFAULT '0',
  `flyin_duration` smallint(5) NOT NULL DEFAULT '2000',
  `language` text,
  `languages_enabled` text,
  `external` tinyint(1) NOT NULL DEFAULT '0',
  `external_url` text,
  `ar_simulator` tinyint(1) NOT NULL DEFAULT '0',
  `ar_camera_align` tinyint(1) NOT NULL DEFAULT '1',
  `id_category` int(11) unsigned DEFAULT NULL,
  `keyboard_mode` tinyint(1) NOT NULL DEFAULT '1',
  `password_meeting` text,
  `password_livesession` text,
  `preload_panoramas` tinyint(1) NOT NULL DEFAULT '1',
  `mobile_panoramas` tinyint(1) NOT NULL DEFAULT '1',
  `click_anywhere` tinyint(1) NOT NULL DEFAULT '0',
  `hide_markers` tinyint(1) NOT NULL DEFAULT '0',
  `hover_markers` tinyint(1) NOT NULL DEFAULT '0',
  `leave_poi_open` tinyint(1) NOT NULL DEFAULT '1',
  `close_poi_click_outside` tinyint(1) NOT NULL DEFAULT '1',
  `font_viewer` varchar(50) DEFAULT 'Roboto',
  `ui_style` text,
  `shop_type` enum('snipcart','woocommerce') NOT NULL DEFAULT 'snipcart',
  `snipcart_api_key` text,
  `snipcart_currency` varchar(3) NOT NULL DEFAULT 'USD',
  `woocommerce_store_url` text,
  `woocommerce_store_cart` varchar(50) DEFAULT 'cart/',
  `woocommerce_store_checkout` varchar(50) DEFAULT 'checkout/',
  `woocommerce_show_stock_quantity` tinyint(1) NOT NULL DEFAULT '1',
  `woocommerce_modal` tinyint(1) NOT NULL DEFAULT '0',
  `woocommerce_customer_key` text,
  `woocommerce_customer_secret` text,
  `enable_visitor_rt` tinyint(1) NOT NULL DEFAULT '0',
  `enable_views_stat` tinyint(1) NOT NULL DEFAULT '0',
  `enable_rooms_multiple` tinyint(1) NOT NULL DEFAULT '1',
  `interval_visitor_rt` smallint(5) NOT NULL DEFAULT '1000',
  `custom_html` longtext,
  `context_info` text,
  `meta_title` text,
  `meta_description` text,
  `meta_image` text,
  `meta_title_l` text,
  `meta_description_l` text,
  `meta_image_l` text,
  `show_in_first_page` tinyint(1) NOT NULL DEFAULT '0',
  `show_in_first_page_l` tinyint(1) NOT NULL DEFAULT '0',
  `initial_feedback` smallint(5) NOT NULL DEFAULT '0',
  `mouse_follow_feedback` float NOT NULL DEFAULT '0.2',
  `aws_s3` tinyint(1) NOT NULL DEFAULT '0',
  `cookie_consent` tinyint(1) NOT NULL DEFAULT '0',
  `avatar_video` text,
  `avatar_video_autoplay` tinyint(1) NOT NULL DEFAULT '1',
  `avatar_video_pause` tinyint(1) NOT NULL DEFAULT '0',
  `avatar_video_hide_end` tinyint(1) NOT NULL DEFAULT '1',
  `add_room_sort` enum('start','end') NOT NULL DEFAULT 'end',
  `intro_slider_delay` smallint(5) NOT NULL DEFAULT '6',
  `block_tour` tinyint(1) NOT NULL DEFAULT '0',
  `block_tour_msg` text,
  `pwa_enable` tinyint(1) NOT NULL DEFAULT '1',
  `vr_icons_size` text,
  `id_room_initial` bigint(20) NOT NULL DEFAULT '-2',
  `learning_mode` tinyint(1) NOT NULL DEFAULT '0',
  `learning_show_modal` tinyint(1) NOT NULL DEFAULT '0',
  `learning_modal_icon` varchar(50) NOT NULL DEFAULT 'fas fa-graduation-cap',
  `learning_modal_title` text,
  `learning_modal_subtitle` text,
  `learning_modal_description` text,
  `learning_modal_button` text,
  `learning_modal_color` varchar(7) DEFAULT '#007bff',
  `learning_modal_background` varchar(7) DEFAULT '#ffffff',
  `learning_modal_color_text` varchar(7) DEFAULT '#000000',
  `learning_modal_button_background` varchar(7) DEFAULT '#007bff',
  `learning_modal_button_color` varchar(7) DEFAULT '#ffffff',
  `learning_show_email` tinyint(1) NOT NULL DEFAULT '0',
  `learning_mandatory_email` tinyint(1) NOT NULL DEFAULT '0',
  `learning_placeholder_email` text,
  `learning_unlock_marker` tinyint(1) NOT NULL DEFAULT '0',
  `learning_poi_progressive` tinyint(1) NOT NULL DEFAULT '0',
  `learning_restore_session` tinyint(1) NOT NULL DEFAULT '0',
  `learning_summary_style` enum('default','minimal') NOT NULL DEFAULT 'default',
  `learning_summary_title` text,
  `learning_summary_background` varchar(28) DEFAULT 'rgba(255,255,255,1)',
  `learning_summary_color` varchar(7) DEFAULT '#000000',
  `learning_summary_partial_title` text,
  `learning_summary_partial_color` varchar(7) DEFAULT '#007AFF',
  `learning_summary_global_title` text,
  `learning_summary_global_color` varchar(7) DEFAULT '#FF3B30',
  `learning_check_icon` varchar(50) NOT NULL DEFAULT 'fas fa-check',
  `learning_check_background` varchar(7) DEFAULT '#006400',
  `learning_check_color` varchar(7) DEFAULT '#ffffff',
  PRIMARY KEY (`id`),
  KEY `id_user` (`id_user`),
  KEY `id_category` (`id_category`),
  CONSTRAINT `svt_virtualtours_ibfk_1` FOREIGN KEY (`id_user`) REFERENCES `svt_users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `svt_virtualtours_ibfk_2` FOREIGN KEY (`id_category`) REFERENCES `svt_categories` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_virtualtours_versions` (
    `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
    `id_virtualtour` bigint(20) unsigned,
    `version` text,
    `ui_style` text,
    `font_viewer` varchar(50) DEFAULT 'Roboto',
    `arrows_nav` tinyint(1) NOT NULL DEFAULT '1',
    `voice_commands` tinyint(1) NOT NULL DEFAULT '0',
    `compass` tinyint(1) NOT NULL DEFAULT '1',
    `auto_show_slider` tinyint(1) NOT NULL DEFAULT '0',
    `nav_slider` tinyint(1) NOT NULL DEFAULT '0',
    `nav_slider_mode` tinyint(1) NOT NULL DEFAULT '0',
    `show_custom` tinyint(1) NOT NULL DEFAULT '0',
    `show_custom2` tinyint(1) NOT NULL DEFAULT '0',
    `show_custom3` tinyint(1) NOT NULL DEFAULT '0',
    `show_custom4` tinyint(1) NOT NULL DEFAULT '0',
    `show_custom5` tinyint(1) NOT NULL DEFAULT '0',
    `show_info` tinyint(1) NOT NULL DEFAULT '1',
    `info_box_type` enum('popup','panel') NOT NULL DEFAULT 'popup',
    `show_gallery` tinyint(1) NOT NULL DEFAULT '1',
    `show_icons_toggle` tinyint(1) NOT NULL DEFAULT '1',
    `show_icons_content_toggle` tinyint(1) NOT NULL DEFAULT '0',
    `show_icons_nav_toggle` tinyint(1) NOT NULL DEFAULT '0',
    `show_measures_toggle` tinyint(1) NOT NULL DEFAULT '1',
    `show_autorotation_toggle` tinyint(1) NOT NULL DEFAULT '1',
    `show_nav_control` tinyint(1) NOT NULL DEFAULT '0',
    `show_presentation` tinyint(1) NOT NULL DEFAULT '1',
    `show_main_form` tinyint(1) NOT NULL DEFAULT '0',
    `show_inline_form` tinyint(1) NOT NULL DEFAULT '0',
    `show_share` tinyint(1) NOT NULL DEFAULT '1',
    `show_device_orientation` tinyint(1) NOT NULL DEFAULT '1',
    `drag_device_orientation` tinyint(1) NOT NULL DEFAULT '1',
    `show_webvr` tinyint(1) NOT NULL DEFAULT '1',
    `webvr_new_window` tinyint(1) NOT NULL DEFAULT '0',
    `show_audio` tinyint(1) NOT NULL DEFAULT '1',
    `show_snapshot` tinyint(1) NOT NULL DEFAULT '0',
    `snapshot_params` text,
    `show_vt_title` tinyint(1) NOT NULL DEFAULT '1',
    `show_fullscreen` tinyint(1) NOT NULL DEFAULT '1',
    `show_map` tinyint(1) NOT NULL DEFAULT '1',
    `show_map_tour` tinyint(1) NOT NULL DEFAULT '1',
    `live_session` tinyint(1) NOT NULL DEFAULT '0',
    `show_annotations` tinyint(1) NOT NULL DEFAULT '1',
    `show_list_alt` tinyint(1) NOT NULL DEFAULT '0',
    `fb_messenger` tinyint(1) NOT NULL DEFAULT '0',
    `whatsapp_chat` tinyint(1) NOT NULL DEFAULT '0',
    `meeting` tinyint(1) NOT NULL DEFAULT '0',
    `autoclose_menu` tinyint(1) NOT NULL DEFAULT '0',
    `autoopen_menu` tinyint(1) NOT NULL DEFAULT '0',
    `autoclose_list_alt` tinyint(1) NOT NULL DEFAULT '0',
    `grouped_list_alt` tinyint(1) NOT NULL DEFAULT '1',
    `autoclose_slider` tinyint(1) NOT NULL DEFAULT '0',
    `autoclose_map` tinyint(1) NOT NULL DEFAULT '0',
    `show_logo` tinyint(1) NOT NULL DEFAULT '1',
    `show_dollhouse` tinyint(1) NOT NULL DEFAULT '0',
    `autorotate_speed` smallint(5) NOT NULL DEFAULT '0',
    `autorotate_inactivity` smallint(5) NOT NULL DEFAULT '0',
    `song_autoplay` tinyint(1) NOT NULL DEFAULT '0',
    `show_location` tinyint(1) NOT NULL DEFAULT '0',
    `show_comments` tinyint(1) NOT NULL DEFAULT '0',
    `show_language` tinyint(1) NOT NULL DEFAULT '1',
    `show_poweredby` tinyint(1) NOT NULL DEFAULT '1',
    `show_media` tinyint(1) NOT NULL DEFAULT '0',
    `show_avatar_video` tinyint(1) NOT NULL DEFAULT '1',
    `enable_visitor_rt` tinyint(1) NOT NULL DEFAULT '0',
    `enable_views_stat` tinyint(1) NOT NULL DEFAULT '0',
    `enable_rooms_multiple` tinyint(1) NOT NULL DEFAULT '1',
    `interval_visitor_rt` smallint(5) NOT NULL DEFAULT '1000',
    `auto_start` tinyint(1) NOT NULL DEFAULT '1',
    `hide_loading` tinyint(1) NOT NULL DEFAULT '0',
    `show_background` tinyint(1) NOT NULL DEFAULT '1',
    `loading_background_color` varchar(7) DEFAULT '#343434',
    `loading_text_color` varchar(7) DEFAULT '#ffffff',
    `flyin` tinyint(1) NOT NULL DEFAULT '0',
    `flyin_duration` smallint(5) NOT NULL DEFAULT '2000',
    PRIMARY KEY (`id`),
    CONSTRAINT `svt_virtualtour_versions_ibfk_1` FOREIGN KEY (`id_virtualtour`) REFERENCES `svt_virtualtours` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_virtualtours_lang` (
  `id_virtualtour` bigint(20) unsigned DEFAULT NULL,
  `language` varchar(10) DEFAULT NULL,
  `name` text,
  `info_box` longtext,
  `form_content` text,
  `password_title` text,
  `password_description` text,
  `description` text,
  `meta_title` text,
  `meta_description` text,
  `list_alt` text,
  `avatar_video` text,
  `media_file` text,
  `media_title` text,
  `location_content` longtext,
  `location_title` text,
  `custom_content` longtext,
  `custom_title` text,
  `custom2_content` longtext,
  `custom2_title` text,
  `custom3_content` longtext,
  `custom3_title` text,
  `custom4_content` longtext,
  `custom4_title` text,
  `custom5_content` longtext,
  `custom5_title` text,
  `intro_desktop` text,
  `intro_mobile` text,
  `learning_modal_title` text,
  `learning_modal_subtitle` text,
  `learning_modal_description` text,
  `learning_modal_button` text,
  `learning_placeholder_email` text,
  `learning_summary_title` text,
  `learning_summary_partial_title` text,
  `learning_summary_global_title` text,
  UNIQUE KEY `id_virtualtour` (`id_virtualtour`,`language`),
  CONSTRAINT `svt_virtualtours_lang_ibfk_1` FOREIGN KEY (`id_virtualtour`) REFERENCES `svt_virtualtours` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_rooms` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `id_virtualtour` bigint(20) unsigned DEFAULT NULL,
  `name` text,
  `logo` text,
  `logo_height` smallint(5) NOT NULL DEFAULT '16',
  `type` enum('image','video','hls','lottie') DEFAULT 'image',
  `panorama_image` text,
  `thumb_image` text,
  `panorama_video` text,
  `panorama_url` text,
  `panorama_json` text,
  `northOffset` smallint(5) NOT NULL DEFAULT '0',
  `show_nadir` tinyint(1) NOT NULL DEFAULT '1',
  `pitch` smallint(5) NOT NULL DEFAULT '0',
  `yaw` smallint(5) NOT NULL DEFAULT '0',
  `hfov` smallint(5) NOT NULL DEFAULT '0',
  `h_pitch` smallint(5) NOT NULL DEFAULT '0',
  `h_roll` smallint(5) NOT NULL DEFAULT '0',
  `id_map` bigint(20) unsigned DEFAULT NULL,
  `map_top` smallint(5) DEFAULT NULL,
  `map_left` smallint(5) DEFAULT NULL,
  `lat` text,
  `lon` text,
  `allow_pitch` tinyint(1) NOT NULL DEFAULT '1',
  `allow_hfov` tinyint(1) NOT NULL DEFAULT '1',
  `min_pitch` smallint(5) NOT NULL DEFAULT '-125',
  `max_pitch` smallint(5) NOT NULL DEFAULT '125',
  `min_yaw` smallint(5) NOT NULL DEFAULT '-180',
  `max_yaw` smallint(5) NOT NULL DEFAULT '180',
  `haov` smallint(5) NOT NULL DEFAULT '360',
  `vaov` smallint(5) NOT NULL DEFAULT '180',
  `priority` smallint(5) NOT NULL DEFAULT '0',
  `access_count` bigint(20) NOT NULL DEFAULT '0',
  `visible_list` tinyint(1) NOT NULL DEFAULT '1',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `song` text,
  `song_bg_volume` float NOT NULL DEFAULT '0.3',
  `song_volume` float NOT NULL DEFAULT '1.0',
  `song_loop` tinyint(1) NOT NULL DEFAULT '1',
  `song_once` tinyint(1) NOT NULL DEFAULT '0',
  `audio_track_enable` tinyint(1) NOT NULL DEFAULT '0',
  `annotation_title` text,
  `annotation_description` text,
  `multires_status` tinyint(1) NOT NULL DEFAULT '0',
  `multires_config` longtext,
  `transition_override` tinyint(1) NOT NULL DEFAULT '0',
  `transition_time` smallint(5) NOT NULL DEFAULT '300',
  `transition_zoom` smallint(5) NOT NULL DEFAULT '20',
  `transition_fadeout` smallint(5) NOT NULL DEFAULT '300',
  `transition_effect` varchar(25) NOT NULL DEFAULT 'puff',
  `transition_hfov` smallint(5) NOT NULL DEFAULT '10',
  `transition_hfov_time` smallint(5) NOT NULL DEFAULT '300',
  `passcode_title` text,
  `passcode_description` text,
  `passcode` text,
  `protect_type` enum('none','passcode','leads','mailchimp') DEFAULT 'none',
  `protect_send_email` tinyint(1) NOT NULL DEFAULT '0',
  `protect_email` text,
  `protect_remember` tinyint(1) NOT NULL DEFAULT '1',
  `protect_mc_form` longtext,
  `protect_lead_params` text,
  `protect_lead_webhook_url` text,
  `filters` text,
  `effect` enum('none','snow','rain','fog','fireworks','confetti','sparkle','logo') DEFAULT 'none',
  `blur` tinyint(1) NOT NULL DEFAULT '0',
  `virtual_staging` tinyint(1) NOT NULL DEFAULT '0',
  `lp_duration` smallint(5) NOT NULL DEFAULT '3000',
  `lp_fade` smallint(5) NOT NULL DEFAULT '5000',
  `main_view_tooltip` varchar(100) NOT NULL DEFAULT '',
  `background_color` varchar(25) NOT NULL DEFAULT '1,1,1',
  `id_poi_autoopen` bigint(20) unsigned DEFAULT NULL,
  `video_end_goto` bigint(20) unsigned DEFAULT '0' ,
  `from_hour` time DEFAULT NULL,
  `to_hour` time DEFAULT NULL,
  `avatar_video` text,
  `avatar_video_play_once` tinyint(1) NOT NULL DEFAULT '0',
  `avatar_video_autoplay` tinyint(1) NOT NULL DEFAULT '1',
  `avatar_video_pause` tinyint(1) NOT NULL DEFAULT '0',
  `avatar_video_hide_end` tinyint(1) NOT NULL DEFAULT '1',
  `autorotate_override` tinyint(1) NOT NULL DEFAULT '0',
  `autorotate_speed` smallint(5) NOT NULL DEFAULT '0',
  `autorotate_inactivity` smallint(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_virtualtour` (`id_virtualtour`),
  CONSTRAINT `svt_rooms_ibfk_1` FOREIGN KEY (`id_virtualtour`) REFERENCES `svt_virtualtours` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_rooms_lang` (
   `id_room` bigint(20) unsigned DEFAULT NULL,
   `language` varchar(10) DEFAULT NULL,
   `name` text,
   `annotation_title` text,
   `annotation_description` text,
   `passcode_title` text,
   `passcode_description` text,
   `main_view_tooltip` text,
   `avatar_video` text,
   UNIQUE KEY `id_room` (`id_room`,`language`),
   CONSTRAINT `svt_rooms_lang_ibfk_1` FOREIGN KEY (`id_room`) REFERENCES `svt_rooms` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_rooms_alt` (
   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
   `id_room` bigint(20) unsigned NOT NULL,
   `panorama_image` text,
   `multires_status` tinyint(1) NOT NULL DEFAULT '0',
   `multires_config` longtext,
   `view_tooltip` varchar(100) NOT NULL DEFAULT '',
   `poi` tinyint(1) NOT NULL DEFAULT '0',
   `auto_open` tinyint(1) NOT NULL DEFAULT '0',
   `priority` smallint(5) NOT NULL DEFAULT '0',
   `from_hour` time DEFAULT NULL,
   `to_hour` time DEFAULT NULL,
   PRIMARY KEY (`id`),
   KEY `id_room` (`id_room`),
   CONSTRAINT `svt_rooms_alt_ibfk_1` FOREIGN KEY (`id_room`) REFERENCES `svt_rooms` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_rooms_alt_lang` (
   `id_room_alt` bigint(20) unsigned NOT NULL,
   `language` varchar(10) DEFAULT NULL,
   `view_tooltip` text,
   UNIQUE KEY `id_room_alt` (`id_room_alt`,`language`),
   CONSTRAINT `svt_rooms_alt_lang_ibfk_1` FOREIGN KEY (`id_room_alt`) REFERENCES `svt_rooms_alt` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_markers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `id_room` bigint(20) unsigned DEFAULT NULL,
  `pitch` float DEFAULT NULL,
  `yaw` float DEFAULT NULL,
  `rotateX` smallint(5) NOT NULL DEFAULT '0',
  `rotateZ` smallint(5) NOT NULL DEFAULT '0',
  `size_scale` float NOT NULL DEFAULT '1',
  `scale` tinyint(1) NOT NULL DEFAULT '0',
  `sticky` tinyint(1) NOT NULL DEFAULT '0',
  `id_room_target` bigint(20) unsigned DEFAULT NULL,
  `pitch_room_target` float DEFAULT NULL,
  `yaw_room_target` float DEFAULT NULL,
  `pitch_look_room_target` float DEFAULT NULL,
  `yaw_look_room_target` float DEFAULT NULL,
  `duration_look_room_target` smallint(5) NOT NULL DEFAULT '2000',
  `icon` varchar(50) NOT NULL DEFAULT 'fas fa-chevron-circle-up',
  `icon_type` enum('round','square','round_outline','square_outline','stroke') DEFAULT 'round',
  `label` text,
  `id_icon_library` bigint(20) unsigned NOT NULL DEFAULT '0',
  `background` varchar(28) NOT NULL DEFAULT 'rgba(255,255,255,0.7)',
  `color` varchar(7) NOT NULL DEFAULT '#000000',
  `tooltip_text` text,
  `tooltip_text_mobile` text,
  `tooltip_visibility` enum('hover','visible','visible_mobile') NOT NULL DEFAULT 'hover',
  `tooltip_background` varchar(28) NOT NULL DEFAULT 'rgba(255,255,255,1)',
  `tooltip_color` varchar(7) NOT NULL DEFAULT '#000000',
  `tooltip_type` enum('none','text','preview','preview_square','preview_rect','room_name') NOT NULL DEFAULT 'none',
  `show_room` tinyint(1) NOT NULL DEFAULT '1',
  `css_class` varchar(250) NOT NULL DEFAULT '',
  `animation` varchar(50) NOT NULL DEFAULT 'none',
  `embed_type` enum('selection') DEFAULT NULL,
  `embed_coords` text,
  `embed_size` text,
  `embed_content` longtext,
  `embed_params` text,
  `transform3d` tinyint(1) NOT NULL DEFAULT '1',
  `lookat` tinyint(1) NOT NULL DEFAULT '1',
  `zIndex` smallint(5) NOT NULL DEFAULT '1',
  `visible_multiview_ids` varchar(50) NOT NULL DEFAULT '',
  `sound` text,
  `exclude_from_apply_all` smallint(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_room` (`id_room`),
  KEY `id_room_target` (`id_room_target`),
  CONSTRAINT `svt_markers_ibfk_1` FOREIGN KEY (`id_room`) REFERENCES `svt_rooms` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `svt_markers_ibfk_2` FOREIGN KEY (`id_room_target`) REFERENCES `svt_rooms` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_markers_lang` (
 `id_marker` bigint(20) unsigned DEFAULT NULL,
 `language` varchar(10) DEFAULT NULL,
 `tooltip_text` text,
 `tooltip_text_mobile` text,
 `label` text,
 UNIQUE KEY `id_marker` (`id_marker`,`language`),
 CONSTRAINT `svt_markers_lang_ibfk_1` FOREIGN KEY (`id_marker`) REFERENCES `svt_markers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_pois` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `id_room` bigint(20) unsigned DEFAULT NULL,
  `pitch` float DEFAULT NULL,
  `yaw` float DEFAULT NULL,
  `rotateX` smallint(5) NOT NULL DEFAULT '0',
  `rotateZ` smallint(5) NOT NULL DEFAULT '0',
  `scale` tinyint(1) NOT NULL DEFAULT '0',
  `sticky` tinyint(1) NOT NULL DEFAULT '0',
  `type` enum('image','video','link','link_ext','html','html_sc','download','form','video360','audio','gallery','google_maps','object360','embed','object3d','lottie','product','switch_pano','pdf','callout','pointclouds','grouped','staging') DEFAULT NULL,
  `embed_type` enum('image','video','gallery','video_transparent','link','text','selection','video_chroma','object3d','html') DEFAULT NULL,
  `embed_coords` text,
  `embed_size` text,
  `embed_content` longtext,
  `embed_video_muted` tinyint(1) NOT NULL DEFAULT '1',
  `embed_video_autoplay` tinyint(1) NOT NULL DEFAULT '1',
  `embed_video_loop` tinyint(1) NOT NULL DEFAULT '1',
  `embed_gallery_autoplay` smallint(5) NOT NULL DEFAULT '0',
  `style` tinyint(1) NOT NULL DEFAULT '0',
  `icon` text,
  `icon_type` enum('round','square','round_outline','square_outline','stroke') DEFAULT 'round',
  `label` text,
  `id_icon_library` bigint(20) unsigned NOT NULL DEFAULT '0',
  `background` varchar(28) NOT NULL DEFAULT 'rgba(255,255,255,0.7)',
  `color` varchar(7) NOT NULL DEFAULT '#000000',
  `tooltip_text` text,
  `tooltip_text_mobile` text,
  `tooltip_visibility` enum('hover','visible','visible_mobile') NOT NULL DEFAULT 'hover',
  `tooltip_background` varchar(28) NOT NULL DEFAULT 'rgba(255,255,255,1)',
  `tooltip_color` varchar(7) NOT NULL DEFAULT '#000000',
  `tooltip_type` enum('none','text') NOT NULL DEFAULT 'none',
  `size_scale` float NOT NULL DEFAULT '1',
  `title` text,
  `description` text,
  `content` longtext,
  `params` longtext,
  `embed_params` text,
  `target` enum('_blank','_self','_parent','_top') DEFAULT NULL,
  `access_count` bigint(20) NOT NULL DEFAULT '0',
  `schedule` text,
  `css_class` varchar(250) NOT NULL DEFAULT '',
  `animation` varchar(50) NOT NULL DEFAULT 'none',
  `view_type` tinyint(1) NOT NULL DEFAULT '0',
  `box_pos` varchar(10) DEFAULT 'right',
  `box_maximize` tinyint(1) NOT NULL DEFAULT '1',
  `box_max_width` smallint(5) NOT NULL DEFAULT '350',
  `box_background` varchar(28) NOT NULL DEFAULT 'rgba(255,255,255,1.0)',
  `box_color` varchar(7) NOT NULL DEFAULT '#000000',
  `auto_close` smallint(5) NOT NULL DEFAULT '0',
  `song_bg_volume` float NOT NULL DEFAULT '0.3',
  `transform3d` tinyint(1) NOT NULL DEFAULT '1',
  `zIndex` smallint(5) NOT NULL DEFAULT '1',
  `visible_multiview_ids` varchar(50) NOT NULL DEFAULT '',
  `sound` text,
  `exclude_from_apply_all` smallint(5) NOT NULL DEFAULT '0',
  `learning` tinyint(1) NOT NULL DEFAULT '1',
  `learning_priority` smallint(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_room` (`id_room`),
  CONSTRAINT `svt_pois_ibfk_1` FOREIGN KEY (`id_room`) REFERENCES `svt_rooms` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_pois_lang` (
  `id_poi` bigint(20) unsigned DEFAULT NULL,
  `language` varchar(10) DEFAULT NULL,
  `embed_content` longtext,
  `label` text,
  `tooltip_text` text,
  `tooltip_text_mobile` text,
  `title` text,
  `description` text,
  `content` longtext,
  `params` text,
  UNIQUE KEY `id_poi` (`id_poi`,`language`),
  CONSTRAINT `svt_pois_lang_ibfk_1` FOREIGN KEY (`id_poi`) REFERENCES `svt_pois` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_access_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `id_virtualtour` bigint(20) unsigned DEFAULT NULL,
  `date_time` datetime DEFAULT NULL,
  `ip` text,
  PRIMARY KEY (`id`),
  KEY `id_virtualtour` (`id_virtualtour`),
  CONSTRAINT `svt_access_log_ibfk_1` FOREIGN KEY (`id_virtualtour`) REFERENCES `svt_virtualtours` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_presentations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `id_virtualtour` bigint(20) unsigned DEFAULT NULL,
  `id_room` bigint(20) unsigned DEFAULT NULL,
  `action` text,
  `params` text,
  `pos` text,
  `sleep` smallint(5) NOT NULL DEFAULT '0',
  `video_wait_end` tinyint(1) NOT NULL DEFAULT '0',
  `priority_1` smallint(5) DEFAULT NULL,
  `priority_2` smallint(5) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_virtual_tour` (`id_virtualtour`),
  KEY `id_room` (`id_room`),
  CONSTRAINT `svt_presentations_ibfk_1` FOREIGN KEY (`id_virtualtour`) REFERENCES `svt_virtualtours` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `svt_presentations_ibfk_2` FOREIGN KEY (`id_room`) REFERENCES `svt_rooms` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_presentations_lang` (
   `id_presentation` bigint(20) unsigned DEFAULT NULL,
   `language` varchar(10) DEFAULT NULL,
   `params` text,
   UNIQUE KEY `id_presentation` (`id_presentation`,`language`),
   CONSTRAINT `svt_presentations_lang_ibfk_1` FOREIGN KEY (`id_presentation`) REFERENCES `svt_presentations` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_gallery` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `id_virtualtour` bigint(20) unsigned DEFAULT NULL,
  `image` text,
  `title` text,
  `description` text,
  `priority` smallint(5) NOT NULL DEFAULT '0',
  `rotate` smallint(5) NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `id_virtualtour` (`id_virtualtour`),
  CONSTRAINT `svt_gallery_ibfk_1` FOREIGN KEY (`id_virtualtour`) REFERENCES `svt_virtualtours` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_gallery_lang` (
 `id_gallery` bigint(20) unsigned DEFAULT NULL,
 `language` varchar(10) DEFAULT NULL,
 `title` text,
 `description` text,
 UNIQUE KEY `id_gallery` (`id_gallery`,`language`),
 CONSTRAINT `svt_gallery_lang_ibfk_1` FOREIGN KEY (`id_gallery`) REFERENCES `svt_gallery` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_maps` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `id_virtualtour` bigint(20) unsigned NOT NULL,
  `map_type` enum('floorplan','map') DEFAULT 'floorplan',
  `default_view` enum('street','satellite') DEFAULT 'street',
  `map` text,
  `point_color` varchar(7) NOT NULL DEFAULT '#005eff',
  `point_view_color` varchar(7) NOT NULL DEFAULT '#005eff',
  `name` text,
  `point_size` smallint(5) NOT NULL DEFAULT '20',
  `point_view_size` smallint(5) NOT NULL DEFAULT '80',
  `map_thumb` tinyint(1) NOT NULL DEFAULT '1',
  `width_d` smallint(5) NOT NULL DEFAULT '300',
  `width_m` smallint(5) NOT NULL DEFAULT '225',
  `north_degree` smallint(5) NOT NULL DEFAULT '0',
  `zoom_level` smallint(5) NOT NULL DEFAULT '16',
  `zoom_to_point` tinyint(1) NOT NULL DEFAULT '0',
  `priority` smallint(5) NOT NULL DEFAULT '0',
  `info_link` text,
  `info_type` enum('blank','iframe') DEFAULT 'blank',
  `id_room_default` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_virtualtour` (`id_virtualtour`),
  CONSTRAINT `svt_maps_ibfk_1` FOREIGN KEY (`id_virtualtour`) REFERENCES `svt_virtualtours` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `svt_maps_svt_rooms_id_fk` FOREIGN KEY (`id_room_default`) REFERENCES `svt_rooms` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_maps_lang` (
  `id_map` bigint(20) unsigned NOT NULL,
  `language` varchar(10) DEFAULT NULL,
  `name` text,
  UNIQUE KEY `id_map` (`id_map`,`language`),
  CONSTRAINT `svt_maps_lang_ibfk_1` FOREIGN KEY (`id_map`) REFERENCES `svt_maps` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_voice_commands` (
  `id` int(11) NOT NULL DEFAULT '0',
  `language` varchar(10) NOT NULL DEFAULT 'en-US',
  `initial_msg` varchar(200) NOT NULL DEFAULT 'Listening ... Say HELP for command list',
  `listening_msg` varchar(200) NOT NULL DEFAULT 'Listening ...',
  `next_cmd` varchar(200) NOT NULL DEFAULT 'next',
  `next_msg` varchar(200) NOT NULL DEFAULT 'Ok, going to next room',
  `prev_cmd` varchar(200) NOT NULL DEFAULT 'prev',
  `prev_msg` varchar(200) NOT NULL DEFAULT 'Ok, going to previous room',
  `left_cmd` varchar(200) NOT NULL DEFAULT 'left',
  `left_msg` varchar(200) NOT NULL DEFAULT 'Ok, looking left',
  `right_cmd` varchar(200) NOT NULL DEFAULT 'right',
  `right_msg` varchar(200) NOT NULL DEFAULT 'Ok, looking right',
  `up_cmd` varchar(200) NOT NULL DEFAULT 'up',
  `up_msg` varchar(200) NOT NULL DEFAULT 'Ok, looking up',
  `down_cmd` varchar(200) NOT NULL DEFAULT 'down',
  `down_msg` varchar(200) NOT NULL DEFAULT 'Ok, looking down',
  `help_cmd` varchar(200) NOT NULL DEFAULT 'help',
  `help_msg_1` varchar(200) NOT NULL DEFAULT 'Say NEXT / PREVIOUS to navigate between rooms',
  `help_msg_2` varchar(200) NOT NULL DEFAULT 'Say LEFT / RIGHT / UP / DOWN to look around',
  `error_msg` varchar(200) NOT NULL DEFAULT 'I do not understand, repeat please...',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT IGNORE INTO `svt_voice_commands` (`id`) VALUES(1);

CREATE TABLE IF NOT EXISTS `svt_settings` (
  `id` int(11) NOT NULL DEFAULT '0',
  `purchase_code` text,
  `license` text,
  `license2` text,
  `name` varchar(200) DEFAULT 'Simple Virtual Tour',
  `theme_color` varchar(7) NOT NULL DEFAULT '#0b5394',
  `theme_color_dark` text,
  `dark_mode` tinyint(1) NOT NULL DEFAULT '1',
  `font_backend` varchar(50) DEFAULT 'Nunito',
  `sidebar` enum('gradient','flat') DEFAULT 'gradient',
  `sidebar_color1` text,
  `sidebar_color2` text,
  `sidebar_color1_dark` text,
  `sidebar_color2_dark` text,
  `logo` text,
  `small_logo` text,
  `background` text,
  `background_reg` text,
  `style_login` tinyint(1) NOT NULL DEFAULT '1',
  `style_register` tinyint(1) NOT NULL DEFAULT '1',
  `smtp_server` text,
  `smtp_auth` tinyint(1) NOT NULL DEFAULT '0',
  `smtp_username` text,
  `smtp_password` text,
  `smtp_secure` enum('none','ssl','tls') DEFAULT NULL,
  `smtp_port` smallint(5) DEFAULT NULL,
  `smtp_from_email` text,
  `smtp_from_name` text,
  `smtp_valid` tinyint(1) NOT NULL DEFAULT '0',
  `enable_registration` tinyint(1) NOT NULL DEFAULT '0',
  `terms_and_conditions` longtext,
  `privacy_policy` longtext,
  `cookie_policy` longtext,
  `cookie_consent` tinyint(1) NOT NULL DEFAULT '0',
  `validate_email` tinyint(1) NOT NULL DEFAULT '0',
  `default_id_plan` bigint(20) unsigned DEFAULT '1',
  `furl_blacklist` text,
  `language` varchar(10) NOT NULL DEFAULT 'en_US',
  `language_domain` varchar(50) NOT NULL DEFAULT 'default',
  `contact_email` text,
  `notify_email` text,
  `change_plan` tinyint(1) NOT NULL DEFAULT '0',
  `buy_services` tinyint(1) NOT NULL DEFAULT '0',
  `stripe_enabled` tinyint(1) NOT NULL DEFAULT '0',
  `stripe_automatic_tax_rate` enum('unspecified','inclusive','exclusive') DEFAULT 'unspecified',
  `stripe_secret_key` text,
  `stripe_public_key` text,
  `paypal_enabled` tinyint(1) NOT NULL DEFAULT '0',
  `paypal_live` tinyint(1) NOT NULL DEFAULT '0',
  `paypal_client_id` text,
  `paypal_client_secret` text,
  `id_product_paypal` text,
  `2checkout_enabled` tinyint(1) NOT NULL DEFAULT '0',
  `2checkout_merchant` text,
  `2checkout_secret` text,
  `2checkout_live` tinyint(1) NOT NULL DEFAULT '0',
  `version` varchar(10) NOT NULL DEFAULT '',
  `social_google_enable` tinyint(1) NOT NULL DEFAULT '0',
  `social_facebook_enable` tinyint(1) NOT NULL DEFAULT '0',
  `social_twitter_enable` tinyint(1) NOT NULL DEFAULT '0',
  `social_wechat_enable` tinyint(1) NOT NULL DEFAULT '0',
  `social_qq_enable` tinyint(1) NOT NULL DEFAULT '0',
  `social_google_id` text,
  `social_google_secret` text,
  `social_facebook_id` text,
  `social_facebook_secret` text,
  `social_twitter_id` text,
  `social_twitter_secret` text,
  `social_wechat_id` text,
  `social_wechat_secret` text,
  `social_qq_id` text,
  `social_qq_secret` text,
  `help_url` text,
  `website_url` text,
  `website_name` text,
  `enable_external_vt` tinyint(1) NOT NULL DEFAULT '0',
  `enable_ar_vt` tinyint(1) NOT NULL DEFAULT '0',
  `enable_ai_room` tinyint(1) NOT NULL DEFAULT '0',
  `enable_autoenhance_room` tinyint(1) NOT NULL DEFAULT '0',
  `enable_deepl` tinyint(1) NOT NULL DEFAULT '0',
  `enable_wizard` tinyint(1) NOT NULL DEFAULT '1',
  `mail_activate_subject` varchar(250) NOT NULL DEFAULT 'Activation Account',
  `mail_activate_body` longtext,
  `mail_forgot_subject` varchar(250) NOT NULL DEFAULT 'Forgot Password',
  `mail_forgot_body` longtext,
  `mail_plan_expiring_subject` varchar(250) NOT NULL DEFAULT 'Your plan is expiring',
  `mail_plan_expiring_body` longtext,
  `mail_plan_expired_subject` varchar(250) NOT NULL DEFAULT 'Your plan has expired',
  `mail_plan_expired_body` longtext,
  `mail_plan_changed_subject` varchar(250) NOT NULL DEFAULT 'Your plan has changed',
  `mail_plan_changed_body` longtext,
  `mail_plan_canceled_subject` varchar(250) NOT NULL DEFAULT 'Your plan has canceled',
  `mail_plan_canceled_body` longtext,
  `mail_service_purchased_subject` varchar(250) NOT NULL DEFAULT 'Your service is purchased',
  `mail_service_purchased_body` longtext,
  `mail_user_add_subject` varchar(250) NOT NULL DEFAULT 'Your account has been created',
  `mail_user_add_body` longtext,
  `first_name_enable` tinyint(1) NOT NULL DEFAULT '1',
  `last_name_enable` tinyint(1) NOT NULL DEFAULT '1',
  `company_enable` tinyint(1) NOT NULL DEFAULT '1',
  `tax_id_enable` tinyint(1) NOT NULL DEFAULT '1',
  `street_enable` tinyint(1) NOT NULL DEFAULT '1',
  `city_enable` tinyint(1) NOT NULL DEFAULT '1',
  `postal_code_enable` tinyint(1) NOT NULL DEFAULT '1',
  `province_enable` tinyint(1) NOT NULL DEFAULT '1',
  `country_enable` tinyint(1) NOT NULL DEFAULT '1',
  `tel_enable` tinyint(1) NOT NULL DEFAULT '1',
  `first_name_mandatory` tinyint(1) NOT NULL DEFAULT '0',
  `last_name_mandatory` tinyint(1) NOT NULL DEFAULT '0',
  `company_mandatory` tinyint(1) NOT NULL DEFAULT '0',
  `tax_id_mandatory` tinyint(1) NOT NULL DEFAULT '0',
  `street_mandatory` tinyint(1) NOT NULL DEFAULT '0',
  `city_mandatory` tinyint(1) NOT NULL DEFAULT '0',
  `postal_code_mandatory` tinyint(1) NOT NULL DEFAULT '0',
  `province_mandatory` tinyint(1) NOT NULL DEFAULT '0',
  `country_mandatory` tinyint(1) NOT NULL DEFAULT '0',
  `tel_mandatory` tinyint(1) NOT NULL DEFAULT '0',
  `peerjs_host` varchar(250) NOT NULL DEFAULT 'svtpeerjs.simpledemo.it',
  `peerjs_port` int(5) NOT NULL DEFAULT 9000,
  `peerjs_path` varchar(250) NOT NULL DEFAULT '/svt',
  `turn_host` varchar(250) NOT NULL DEFAULT 'svtpeerjs.simpledemo.it',
  `turn_port` int(5) NOT NULL DEFAULT 5349,
  `turn_username` varchar(100) NOT NULL DEFAULT 'svt',
  `turn_passwrod` varchar(100) NOT NULL DEFAULT 'svt',
  `jitsi_domain` varchar(250) NOT NULL DEFAULT 'meet.simplevirtualtour.it',
  `leaflet_street_basemap` varchar(250) NOT NULL DEFAULT 'https://{s}.google.com/vt/lyrs=m&x={x}&y={y}&z={z}',
  `leaflet_satellite_basemap` varchar(250) NOT NULL DEFAULT 'https://{s}.google.com/vt/lyrs=s&x={x}&y={y}&z={z}',
  `leaflet_street_subdomain` varchar(250) NOT NULL DEFAULT 'mt0,mt1,mt2,mt3',
  `leaflet_street_maxzoom` int(2) NOT NULL DEFAULT 20,
  `leaflet_satellite_subdomain` varchar(250) NOT NULL DEFAULT 'mt0,mt1,mt2,mt3',
  `leaflet_satellite_maxzoom` int(2) NOT NULL DEFAULT 20,
  `languages_enabled` text,
  `languages_viewer_enabled` text,
  `welcome_msg` longtext,
  `welcome_title` text,
  `welcome_icon` varchar(50) NOT NULL DEFAULT 'far fa-smile',
  `welcome_enable` tinyint(1) NOT NULL DEFAULT '1',
  `enable_sample` tinyint(1) NOT NULL DEFAULT '1',
  `id_vt_sample` text,
  `id_vt_template` bigint(20) unsigned DEFAULT NULL,
  `footer_link_1` text,
  `footer_value_1` text,
  `footer_link_2` text,
  `footer_value_2` text,
  `footer_link_3` text,
  `footer_value_3` text,
  `multires` enum('local','cloud') DEFAULT 'local',
  `multires_cloud_url` varchar(250) NOT NULL DEFAULT 'https://simplevirtualtour.it/app/tools/multires_cloud.php',
  `video360` enum('local','cloud') DEFAULT 'local',
  `video360_cloud_url` varchar(250) NOT NULL DEFAULT 'https://simplevirtualtour.it/app/tools/video360_cloud.php',
  `slideshow` enum('local','cloud') DEFAULT 'local',
  `slideshow_cloud_url` varchar(250) NOT NULL DEFAULT 'https://simplevirtualtour.it/app/tools/slideshow_cloud.php',
  `video_project` enum('local','cloud') DEFAULT 'local',
  `video_project_url` varchar(250) NOT NULL DEFAULT 'https://simplevirtualtour.it/app/tools/video_cloud.php',
  `enable_screencast` tinyint(1) NOT NULL DEFAULT '1',
  `url_screencast` varchar(250) NOT NULL DEFAULT 'https://studio.snipclip.app/record',
  `notify_registrations` tinyint(1) NOT NULL DEFAULT '1',
  `notify_useradd` tinyint(1) NOT NULL DEFAULT '1',
  `notify_plan_expires` tinyint(1) NOT NULL DEFAULT '1',
  `notify_plan_expiring` tinyint(1) NOT NULL DEFAULT '1',
  `notify_plan_changes` tinyint(1) NOT NULL DEFAULT '1',
  `notify_service_purchase` tinyint(1) NOT NULL DEFAULT '1',
  `notify_plan_cancels` tinyint(1) NOT NULL DEFAULT '1',
  `notify_vt_create` tinyint(1) NOT NULL DEFAULT '1',
  `notify_custom_domain_request` tinyint(1) NOT NULL DEFAULT '1',
  `captcha_login` tinyint(1) NOT NULL DEFAULT '0',
  `captcha_register` tinyint(1) NOT NULL DEFAULT '0',
  `2fa_enable` tinyint(1) NOT NULL DEFAULT '1',
  `vr_button` tinyint(1) NOT NULL DEFAULT '1',
  `share_providers` varchar(250) NOT NULL DEFAULT 'copy_link,email,whatsapp,facebook,twitter,linkedin,telegram,facebook_messenger,pinterest,reddit,line,viber,vk,qzone,wechat',
  `disqus_shortname` text,
  `disqus_public_key` text,
  `disqus_allow_tour` tinyint(1) NOT NULL DEFAULT '0',
  `font_provider` enum('systems','google','collabs') DEFAULT 'google',
  `days_expire_notification` smallint(5) NOT NULL DEFAULT '1',
  `aws_s3_enabled` tinyint(1) NOT NULL DEFAULT '0',
  `aws_s3_type` enum('aws','r2','digitalocean','wasabi','storj','backblaze') DEFAULT 'aws',
  `aws_s3_vt_auto` tinyint(1) NOT NULL DEFAULT '0',
  `aws_s3_accountid` text,
  `aws_s3_custom_domain` text,
  `aws_s3_region` text,
  `aws_s3_key` text,
  `aws_s3_secret` text,
  `aws_s3_bucket` text,
  `globe_ion_token` text,
  `globe_arcgis_token` text,
  `globe_googlemaps_key` text,
  `ai_key` text,
  `autoenhance_key` text,
  `deepl_api_key` text,
  `maintenance_backend` tinyint(1) NOT NULL DEFAULT '0',
  `maintenance_viewer` tinyint(1) NOT NULL DEFAULT '0',
  `maintenance_ip` text,
  `timezone` text,
  `ga_tracking_id` text,
  `extra_menu_items` text,
  `api_key` text,
  `tour_list_mode` enum('default','light','light_10','light_100','light_1000') DEFAULT 'default',
  `tour_inactive_days` smallint(5) NOT NULL DEFAULT '30',
  `max_concurrent_sessions` smallint(5) NOT NULL DEFAULT '0',
  `custom_html` longtext,
  `popup_add_room_vt` tinyint(1) NOT NULL DEFAULT '0',
  `enable_custom_domain` tinyint(1) NOT NULL DEFAULT '0',
  `custom_domain_ip_address` text,
  `server_domain_name` text,
  `restrict_domain_viewer` tinyint(1) NOT NULL DEFAULT '0',
  `restrict_domain_backend` tinyint(1) NOT NULL DEFAULT '0',
  `tawkto_chat_link` text,
  `pwa_enable` tinyint(1) NOT NULL DEFAULT '1',
  `meta_title` text,
  `meta_description` text,
  `meta_image` text,
  PRIMARY KEY (`id`),
  KEY `id_vt_template` (`id_vt_template`),
  CONSTRAINT `svt_settings_ibfk_2` FOREIGN KEY (`id_vt_template`) REFERENCES `svt_virtualtours` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT IGNORE INTO `svt_settings` (`id`,`furl_blacklist`,`mail_activate_body`,`mail_forgot_body`,`mail_plan_expiring_body`,`mail_plan_expired_body`,`mail_plan_changed_body`,`mail_plan_canceled_body`,`mail_user_add_body`,`mail_service_purchased_body`) VALUES(1,'ajax,content,css,gallery,header,icons,js,maps,media,object360,panoramas,pointclouds,products,vendor,videos','<p>Hi %USER_NAME%,<br>thanks for signing up!</p><p><br></p><p>Please click on this link to activate your account:</p><p>%LINK%</p>','<p>Hi %USER_NAME%,<br>this is your verification code: %VERIFICATION_CODE%</p><p><br></p><p>Please click on this link to change your password:</p><p>%LINK%</p>','<p>Hi %USER_NAME%,<br>your plan %PLAN_NAME% is expiring soon on %EXPIRE_DATE%.</p>','<p>Hi %USER_NAME%,<br>your plan %PLAN_NAME% just expired on %EXPIRE_DATE%.</p>','<p>Hi %USER_NAME%,<br>your plan has been changed to %PLAN_NAME%.</p>','<p>Hi %USER_NAME%,<br>your %PLAN_NAME% plan has been canceled.</p>','<p>Hi %USER_NAME%,</p><p>your account has been created!</p><p>Below you will find the details to login.</p><p><br></p><p>Link: %LINK%</p><p>Username: %USER_NAME%</p><p>Password: %PASSWORD%</p>','<p>Hi %USER_NAME%,<br>your %SERVICE_NAME% service has been purchased.<br><br><i>%NOTE%</i></p>');

CREATE TABLE IF NOT EXISTS `svt_settings_lang` (
    `id_settings` int(11) DEFAULT NULL,
    `language` varchar(10) DEFAULT NULL,
    `terms_and_conditions` longtext,
    `privacy_policy` longtext,
    `cookie_policy` longtext,
    `welcome_msg` longtext,
    `welcome_title` text,
    `footer_link_1` text,
    `footer_value_1` text,
    `footer_link_2` text,
    `footer_value_2` text,
    `footer_link_3` text,
    `footer_value_3` text,
    `extra_menu_items` text,
    `mail_activate_subject` text,
    `mail_activate_body` longtext,
    `mail_forgot_subject` text,
    `mail_forgot_body` longtext,
    `mail_plan_expiring_subject` text,
    `mail_plan_expiring_body` longtext,
    `mail_plan_expired_subject` text,
    `mail_plan_expired_body` longtext,
    `mail_plan_changed_subject` text,
    `mail_plan_changed_body` longtext,
    `mail_plan_canceled_subject` text,
    `mail_plan_canceled_body` longtext,
    `mail_service_purchased_subject` text,
    `mail_service_purchased_body` longtext,
    `mail_user_add_subject` text,
    `mail_user_add_body` longtext,
    UNIQUE KEY `id_settings` (`id_settings`,`language`),
    CONSTRAINT `svt_settings_lang_ibfk_1` FOREIGN KEY (`id_settings`) REFERENCES `svt_settings` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_icons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `id_virtualtour` bigint(20) unsigned DEFAULT NULL,
  `image` text,
  PRIMARY KEY (`id`),
  KEY `id_virtualtour` (`id_virtualtour`),
  CONSTRAINT `svt_icon_ibfk_1` FOREIGN KEY (`id_virtualtour`) REFERENCES `svt_virtualtours` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_rooms_access_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `id_room` bigint(20) unsigned DEFAULT NULL,
  `time` smallint(5) DEFAULT NULL,
  `ip` text,
  PRIMARY KEY (`id`),
  KEY `id_room` (`id_room`),
  CONSTRAINT `svt_rooms_access_log_ibfk_1` FOREIGN KEY (`id_room`) REFERENCES `svt_rooms` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_forms_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `datetime` datetime DEFAULT NULL,
  `id_virtualtour` bigint(20) unsigned NOT NULL,
  `id_room` bigint(20) unsigned DEFAULT NULL,
  `title` text,
  `field1` text,
  `field2` text,
  `field3` text,
  `field4` text,
  `field5` text,
  `field6` text,
  `field7` text,
  `field8` text,
  `field9` text,
  `field10` text,
  PRIMARY KEY (`id`),
  KEY `id_virtualtour` (`id_virtualtour`),
  CONSTRAINT `svt_forms_data_ibfk_1` FOREIGN KEY (`id_virtualtour`) REFERENCES `svt_virtualtours` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_poi_gallery` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `id_poi` bigint(20) unsigned DEFAULT NULL,
  `image` text,
  `title` text,
  `description` text,
  `priority` smallint(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_poi` (`id_poi`),
  CONSTRAINT `svt_poi_gallery_ibfk_1` FOREIGN KEY (`id_poi`) REFERENCES `svt_pois` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_poi_gallery_lang` (
  `id_poi_gallery` bigint(20) unsigned DEFAULT NULL,
  `language` varchar(10) DEFAULT NULL,
  `title` text,
  `description` text,
  UNIQUE KEY `id_poi_gallery` (`id_poi_gallery`,`language`),
  CONSTRAINT `svt_poi_gallery_lang_ibfk_1` FOREIGN KEY (`id_poi_gallery`) REFERENCES `svt_poi_gallery` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_assign_virtualtours` (
  `id_user` int(11) unsigned DEFAULT NULL,
  `id_virtualtour` bigint(20) unsigned DEFAULT NULL,
  `edit_virtualtour` tinyint(1) NOT NULL DEFAULT 1,
  `edit_virtualtour_ui` tinyint(1) NOT NULL DEFAULT 1,
  `edit_3d_view` tinyint(1) NOT NULL DEFAULT 1,
  `create_rooms` tinyint(1) NOT NULL DEFAULT 0,
  `edit_rooms` tinyint(1) NOT NULL DEFAULT 1,
  `delete_rooms` tinyint(1) NOT NULL DEFAULT 0,
  `create_markers` tinyint(1) NOT NULL DEFAULT 1,
  `edit_markers` tinyint(1) NOT NULL DEFAULT 1,
  `delete_markers` tinyint(1) NOT NULL DEFAULT 1,
  `create_pois` tinyint(1) NOT NULL DEFAULT 1,
  `edit_pois` tinyint(1) NOT NULL DEFAULT 1,
  `delete_pois` tinyint(1) NOT NULL DEFAULT 1,
  `create_maps` tinyint(1) NOT NULL DEFAULT 0,
  `edit_maps` tinyint(1) NOT NULL DEFAULT 1,
  `delete_maps` tinyint(1) NOT NULL DEFAULT 0,
  `info_box` tinyint(1) NOT NULL DEFAULT 1,
  `presentation` tinyint(1) NOT NULL DEFAULT 1,
  `video360` tinyint(1) NOT NULL DEFAULT 1,
  `video_projects` tinyint(1) NOT NULL DEFAULT 1,
  `gallery` tinyint(1) NOT NULL DEFAULT 1,
  `icons_library` tinyint(1) NOT NULL DEFAULT 1,
  `media_library` tinyint(1) NOT NULL DEFAULT 1,
  `music_library` tinyint(1) NOT NULL DEFAULT 1,
  `sound_library` tinyint(1) NOT NULL DEFAULT 1,
  `publish` tinyint(1) NOT NULL DEFAULT 0,
  `landing` tinyint(1) NOT NULL DEFAULT 1,
  `forms` tinyint(1) NOT NULL DEFAULT 1,
  `leads` tinyint(1) NOT NULL DEFAULT 1,
  `shop` tinyint(1) NOT NULL DEFAULT 1,
  `measurements` tinyint(1) NOT NULL DEFAULT 1,
  `translate` tinyint(1) NOT NULL DEFAULT 1,
  UNIQUE KEY `id_user` (`id_user`,`id_virtualtour`),
  KEY `id_virtualtour` (`id_virtualtour`),
  CONSTRAINT `svt_assign_virtualtours_ibfk_1` FOREIGN KEY (`id_user`) REFERENCES `svt_users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `svt_assign_virtualtours_ibfk_2` FOREIGN KEY (`id_virtualtour`) REFERENCES `svt_virtualtours` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_leads` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `datetime` datetime DEFAULT NULL,
  `id_virtualtour` bigint(20) unsigned NOT NULL,
  `name` text,
  `company` text,
  `email` text,
  `phone` text,
  PRIMARY KEY (`id`),
  KEY `id_virtualtour` (`id_virtualtour`),
  CONSTRAINT `svt_leads_ibfk_1` FOREIGN KEY (`id_virtualtour`) REFERENCES `svt_virtualtours` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_showcases` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `id_user` int(11) unsigned DEFAULT NULL,
  `code` text,
  `name` text,
  `friendly_url` text,
  `banner` text,
  `logo` text,
  `bg_color` varchar(7) NOT NULL DEFAULT '#EEEEEE',
  `header_html` longtext,
  `footer_html` longtext,
  `meta_title` text,
  `meta_description` text,
  `meta_image` text,
  `show_in_first_page` tinyint(1) NOT NULL DEFAULT '0',
  `sort_settings` text,
  `open_target` enum('self','new') NOT NULL DEFAULT 'self',
  `ga_tracking_id` text,
  `cookie_consent` tinyint(1) NOT NULL DEFAULT '0',
  `language` text,
  `languages_enabled` text,
  `pwa_enable` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `id_user` (`id_user`),
  CONSTRAINT `svt_showcases_ibfk_1` FOREIGN KEY (`id_user`) REFERENCES `svt_users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_showcases_lang` (
   `id_showcase` bigint(20) unsigned DEFAULT NULL,
   `language` varchar(10) DEFAULT NULL,
   `name` text,
   `header_html` longtext,
   `footer_html` longtext,
   `meta_title` text,
   `meta_description` text,
   UNIQUE KEY `id_showcase` (`id_showcase`,`language`),
   CONSTRAINT `svt_showcases_lang_ibfk_1` FOREIGN KEY (`id_showcase`) REFERENCES `svt_showcases` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_showcase_list` (
  `id_showcase` bigint(20) unsigned DEFAULT NULL,
  `id_virtualtour` bigint(20) unsigned DEFAULT NULL,
  `type_viewer` enum('viewer','landing') NOT NULL DEFAULT 'viewer',
  `priority` smallint(5) NOT NULL DEFAULT 0,
  KEY `id_showcase` (`id_showcase`),
  KEY `id_virtualtour` (`id_virtualtour`),
  CONSTRAINT `svt_showcase_list_ibfk_1` FOREIGN KEY (`id_showcase`) REFERENCES `svt_showcases` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `svt_showcase_list_ibfk_2` FOREIGN KEY (`id_virtualtour`) REFERENCES `svt_virtualtours` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_advertisements` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` text,
  `type` enum('image','video','iframe','html') NOT NULL DEFAULT 'image',
  `image` text,
  `video` text,
  `youtube` text,
  `iframe_link` text,
  `custom_html` longtext,
  `link` text,
  `countdown` smallint(5) NOT NULL DEFAULT 0,
  `id_plans` text,
  `auto_assign` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_assign_advertisements` (
  `id_advertisement` int(11) unsigned NOT NULL,
  `id_virtualtour` bigint(20) unsigned NOT NULL,
  KEY `id_advertisement` (`id_advertisement`),
  KEY `id_virtualtour` (`id_virtualtour`),
  CONSTRAINT `svt_assign_advertisements_ibfk_1` FOREIGN KEY (`id_advertisement`) REFERENCES `svt_advertisements` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `svt_assign_advertisements_ibfk_2` FOREIGN KEY (`id_virtualtour`) REFERENCES `svt_virtualtours` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_visitors` (
  `id_virtualtour` bigint(20) unsigned DEFAULT NULL,
  `initial_datetime` datetime DEFAULT NULL,
  `datetime` datetime DEFAULT NULL,
  `ip` varchar(100) DEFAULT NULL,
  `id` varchar(100) DEFAULT NULL,
  `id_room` bigint(20) unsigned DEFAULT NULL,
  `yaw` float DEFAULT NULL,
  `pitch` float DEFAULT NULL,
  `color` varchar(7) NOT NULL DEFAULT '#000000',
  UNIQUE KEY `id_virtualtour` (`id_virtualtour`,`ip`,`id`),
  CONSTRAINT `svt_visitors_ibfk_1` FOREIGN KEY (`id_virtualtour`) REFERENCES `svt_virtualtours` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_poi_objects360` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `id_poi` bigint(20) unsigned DEFAULT NULL,
  `image` text,
  `priority` smallint(5) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `id_poi` (`id_poi`),
  CONSTRAINT `svt_poi_objects360_ibfk_1` FOREIGN KEY (`id_poi`) REFERENCES `svt_pois` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_media_library` (
 `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
 `id_virtualtour` bigint(20) unsigned DEFAULT NULL,
 `file` text,
 PRIMARY KEY (`id`),
 KEY `id_virtualtour` (`id_virtualtour`),
 CONSTRAINT `svt_media_library_ibfk_1` FOREIGN KEY (`id_virtualtour`) REFERENCES `svt_virtualtours` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_poi_embedded_gallery` (
 `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
 `id_poi` bigint(20) unsigned DEFAULT NULL,
 `image` text,
 `priority` smallint(5) NOT NULL DEFAULT '0',
 PRIMARY KEY (`id`),
 KEY `id_poi` (`id_poi`),
 CONSTRAINT `svt_poi_embedded_gallery_ibfk_1` FOREIGN KEY (`id_poi`) REFERENCES `svt_pois` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_music_library` (
 `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
 `id_virtualtour` bigint(20) unsigned DEFAULT NULL,
 `file` text,
 PRIMARY KEY (`id`),
 KEY `id_virtualtour` (`id_virtualtour`),
 CONSTRAINT `svt_music_library_ibfk_1` FOREIGN KEY (`id_virtualtour`) REFERENCES `svt_virtualtours` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_sound_library` (
    `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
    `id_virtualtour` bigint(20) unsigned DEFAULT NULL,
    `file` text,
    PRIMARY KEY (`id`),
    KEY `id_virtualtour` (`id_virtualtour`),
    CONSTRAINT `svt_sound_library_ibfk_1` FOREIGN KEY (`id_virtualtour`) REFERENCES `svt_virtualtours` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_presets` (
 `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
 `id_virtualtour` bigint(20) unsigned DEFAULT NULL,
 `name` text,
 `type` text,
 `value` text,
 PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_products` (
 `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
 `id_virtualtour` bigint(20) unsigned DEFAULT NULL,
 `name` text,
 `description` text,
 `price` float NOT NULL DEFAULT '0',
 `purchase_type` enum('none','cart','link','popup') NOT NULL DEFAULT 'none',
 `link` text,
 `button_icon` varchar(50) NOT NULL DEFAULT 'fas fa-shopping-cart',
 `button_text` varchar(100) DEFAULT '',
 `button_background` varchar(7) NOT NULL DEFAULT '#000000',
 `button_color` varchar(7) NOT NULL DEFAULT '#ffffff',
 `custom_currency` varchar(25) DEFAULT '',
 PRIMARY KEY (`id`),
 KEY `id_virtualtour` (`id_virtualtour`),
 CONSTRAINT `svt_products_ibfk_1` FOREIGN KEY (`id_virtualtour`) REFERENCES `svt_virtualtours` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_products_lang` (
  `id_product` bigint(20) unsigned DEFAULT NULL,
  `language` varchar(10) DEFAULT NULL,
  `name` text,
  `description` text,
  `button_text` varchar(100) DEFAULT '',
  UNIQUE KEY `id_product` (`id_product`,`language`),
  CONSTRAINT `svt_products_lang_ibfk_1` FOREIGN KEY (`id_product`) REFERENCES `svt_products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_product_images` (
 `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
 `id_product` bigint(20) unsigned DEFAULT NULL,
 `image` text,
 `priority` smallint(5) NOT NULL DEFAULT '0',
 PRIMARY KEY (`id`),
 KEY `id_product` (`id_product`),
 CONSTRAINT `svt_product_images_ibfk_1` FOREIGN KEY (`id_product`) REFERENCES `svt_products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_access_log_room` (
 `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
 `id_room` bigint(20) unsigned DEFAULT NULL,
 `date_time` datetime DEFAULT NULL,
 `ip` text,
 PRIMARY KEY (`id`),
 KEY `id_room` (`id_room`),
 CONSTRAINT `svt_access_log_room_ibfk_1` FOREIGN KEY (`id_room`) REFERENCES `svt_rooms` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_access_log_poi` (
 `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
 `id_poi` bigint(20) unsigned DEFAULT NULL,
 `date_time` datetime DEFAULT NULL,
 `ip` text,
 PRIMARY KEY (`id`),
 KEY `id_poi` (`id_poi`),
 CONSTRAINT `svt_access_log_poi_ibfk_1` FOREIGN KEY (`id_poi`) REFERENCES `svt_pois` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_editor_ui_presets` (
 `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
 `id_user` int(11) unsigned DEFAULT NULL,
 `name` text,
 `public` tinyint(1) NOT NULL DEFAULT '0',
 `ui_style` text,
 PRIMARY KEY (`id`),
 KEY `id_user` (`id_user`),
 CONSTRAINT `svt_editor_ui_presets_ibfk_1` FOREIGN KEY (`id_user`) REFERENCES `svt_users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_editor_ui_presets_values` (
  `id_preset` int(11) unsigned,
  `font_viewer` varchar(50) DEFAULT 'Roboto',
  `arrows_nav` tinyint(1) NOT NULL DEFAULT '1',
  `voice_commands` tinyint(1) NOT NULL DEFAULT '0',
  `compass` tinyint(1) NOT NULL DEFAULT '1',
  `auto_show_slider` tinyint(1) NOT NULL DEFAULT '0',
  `nav_slider` tinyint(1) NOT NULL DEFAULT '0',
  `nav_slider_mode` tinyint(1) NOT NULL DEFAULT '0',
  `show_custom` tinyint(1) NOT NULL DEFAULT '0',
  `show_custom2` tinyint(1) NOT NULL DEFAULT '0',
  `show_custom3` tinyint(1) NOT NULL DEFAULT '0',
  `show_custom4` tinyint(1) NOT NULL DEFAULT '0',
  `show_custom5` tinyint(1) NOT NULL DEFAULT '0',
  `show_info` tinyint(1) NOT NULL DEFAULT '1',
  `info_box_type` enum('popup','panel') NOT NULL DEFAULT 'popup',
  `show_gallery` tinyint(1) NOT NULL DEFAULT '1',
  `show_icons_toggle` tinyint(1) NOT NULL DEFAULT '1',
  `show_icons_content_toggle` tinyint(1) NOT NULL DEFAULT '0',
  `show_icons_nav_toggle` tinyint(1) NOT NULL DEFAULT '0',
  `show_measures_toggle` tinyint(1) NOT NULL DEFAULT '1',
  `show_autorotation_toggle` tinyint(1) NOT NULL DEFAULT '1',
  `show_nav_control` tinyint(1) NOT NULL DEFAULT '0',
  `show_presentation` tinyint(1) NOT NULL DEFAULT '1',
  `show_main_form` tinyint(1) NOT NULL DEFAULT '0',
  `show_inline_form` tinyint(1) NOT NULL DEFAULT '0',
  `show_share` tinyint(1) NOT NULL DEFAULT '1',
  `show_device_orientation` tinyint(1) NOT NULL DEFAULT '1',
  `drag_device_orientation` tinyint(1) NOT NULL DEFAULT '1',
  `show_webvr` tinyint(1) NOT NULL DEFAULT '1',
  `webvr_new_window` tinyint(1) NOT NULL DEFAULT '0',
  `show_audio` tinyint(1) NOT NULL DEFAULT '1',
  `show_snapshot` tinyint(1) NOT NULL DEFAULT '0',
  `snapshot_params` text,
  `show_vt_title` tinyint(1) NOT NULL DEFAULT '1',
  `show_fullscreen` tinyint(1) NOT NULL DEFAULT '1',
  `show_map` tinyint(1) NOT NULL DEFAULT '1',
  `show_map_tour` tinyint(1) NOT NULL DEFAULT '1',
  `live_session` tinyint(1) NOT NULL DEFAULT '0',
  `show_annotations` tinyint(1) NOT NULL DEFAULT '1',
  `show_list_alt` tinyint(1) NOT NULL DEFAULT '0',
  `fb_messenger` tinyint(1) NOT NULL DEFAULT '0',
  `whatsapp_chat` tinyint(1) NOT NULL DEFAULT '0',
  `meeting` tinyint(1) NOT NULL DEFAULT '0',
  `autoclose_menu` tinyint(1) NOT NULL DEFAULT '0',
  `autoopen_menu` tinyint(1) NOT NULL DEFAULT '0',
  `autoclose_list_alt` tinyint(1) NOT NULL DEFAULT '0',
  `grouped_list_alt` tinyint(1) NOT NULL DEFAULT '1',
  `autoclose_slider` tinyint(1) NOT NULL DEFAULT '0',
  `autoclose_map` tinyint(1) NOT NULL DEFAULT '0',
  `show_logo` tinyint(1) NOT NULL DEFAULT '1',
  `show_dollhouse` tinyint(1) NOT NULL DEFAULT '0',
  `autorotate_speed` smallint(5) NOT NULL DEFAULT '0',
  `autorotate_inactivity` smallint(5) NOT NULL DEFAULT '0',
  `song_autoplay` tinyint(1) NOT NULL DEFAULT '0',
  `show_location` tinyint(1) NOT NULL DEFAULT '0',
  `show_comments` tinyint(1) NOT NULL DEFAULT '0',
  `show_language` tinyint(1) NOT NULL DEFAULT '1',
  `show_poweredby` tinyint(1) NOT NULL DEFAULT '1',
  `show_media` tinyint(1) NOT NULL DEFAULT '0',
  `show_avatar_video` tinyint(1) NOT NULL DEFAULT '1',
  `enable_visitor_rt` tinyint(1) NOT NULL DEFAULT '0',
  `enable_views_stat` tinyint(1) NOT NULL DEFAULT '0',
  `enable_rooms_multiple` tinyint(1) NOT NULL DEFAULT '1',
  `interval_visitor_rt` smallint(5) NOT NULL DEFAULT '1000',
  `markers_icon` varchar(50) NOT NULL DEFAULT 'fas fa-chevron-circle-up',
  `markers_icon_type` enum('round','square','round_outline','square_outline','stroke') DEFAULT 'round',
  `markers_id_icon_library` bigint(20) unsigned NOT NULL DEFAULT 0,
  `markers_background` varchar(28) NOT NULL DEFAULT 'rgba(255,255,255,0.7)',
  `markers_color` varchar(7) NOT NULL DEFAULT '#000000',
  `markers_show_room` tinyint(1) NOT NULL DEFAULT '1',
  `markers_tooltip_type` enum('none','text','preview','preview_square','preview_rect','room_name') NOT NULL DEFAULT 'none',
  `markers_tooltip_visibility` enum('hover','visible','visible_mobile') NOT NULL DEFAULT 'hover',
  `markers_tooltip_background` varchar(28) NOT NULL DEFAULT 'rgba(255,255,255,1)',
  `markers_tooltip_color` varchar(7) NOT NULL DEFAULT '#000000',
  `markers_default_scale` tinyint(1) NOT NULL DEFAULT '0',
  `markers_default_sticky` tinyint(1) NOT NULL DEFAULT '0',
  `markers_default_rotateX` smallint(5) NOT NULL DEFAULT '0',
  `markers_default_rotateZ` smallint(5) NOT NULL DEFAULT '0',
  `markers_default_size_scale` float NOT NULL DEFAULT '1',
  `markers_default_sound` text,
  `markers_animation` varchar(10) NOT NULL DEFAULT 'none',
  `pois_icon` varchar(50) NOT NULL DEFAULT 'fas fa-info-circle',
  `pois_icon_type` enum('round','square','round_outline','square_outline','stroke') DEFAULT 'round',
  `pois_id_icon_library` bigint(20) unsigned NOT NULL DEFAULT 0,
  `pois_background` varchar(28) NOT NULL DEFAULT 'rgba(255,255,255,0.7)',
  `pois_color` varchar(7) NOT NULL DEFAULT '#000000',
  `pois_style` tinyint(1) NOT NULL DEFAULT '0',
  `pois_tooltip_type` enum('none','text') NOT NULL DEFAULT 'none',
  `pois_tooltip_visibility` enum('hover','visible','visible_mobile') NOT NULL DEFAULT 'hover',
  `pois_tooltip_background` varchar(28) NOT NULL DEFAULT 'rgba(255,255,255,1)',
  `pois_tooltip_color` varchar(7) NOT NULL DEFAULT '#000000',
  `pois_default_scale` tinyint(1) NOT NULL DEFAULT '0',
  `pois_default_sticky` tinyint(1) NOT NULL DEFAULT '0',
  `pois_default_rotateX` smallint(5) NOT NULL DEFAULT '0',
  `pois_default_rotateZ` smallint(5) NOT NULL DEFAULT '0',
  `pois_default_size_scale` float NOT NULL DEFAULT '1',
  `pois_default_sound` text,
  `pois_animation` varchar(10) NOT NULL DEFAULT 'none',
  `nadir_size` varchar(25) NOT NULL DEFAULT '100px',
  KEY `id_preset` (`id_preset`),
  CONSTRAINT `svt_editor_ui_presets_values_ibfk_1` FOREIGN KEY (`id_preset`) REFERENCES `svt_editor_ui_presets` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_notifications` (
 `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
 `id_user` int(11) unsigned DEFAULT NULL,
 `notify_date` timestamp DEFAULT CURRENT_TIMESTAMP,
 `subject` text,
 `body` text,
 `notify_user` tinyint(1) NOT NULL DEFAULT '0',
 `notified` tinyint(1) NOT NULL DEFAULT '0',
 PRIMARY KEY (`id`),
 KEY `id_user` (`id_user`),
 CONSTRAINT `svt_notifications_ibfk_1` FOREIGN KEY (`id_user`) REFERENCES `svt_users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_globes` (
 `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
 `id_user` int(11) unsigned DEFAULT NULL,
 `code` text,
 `name` text,
 `friendly_url` text,
 `logo` text,
 `pointer_size` smallint(5) NOT NULL DEFAULT '15',
 `pointer_color` varchar(28) NOT NULL DEFAULT 'rgba(255,255,255,1)',
 `pointer_border` varchar(28) NOT NULL DEFAULT 'rgba(0,0,0,1)',
 `center_lat` text,
 `center_lon` text,
 `center_altitude` smallint(5) DEFAULT NULL,
 `initial_pos` text,
 `min_altitude` smallint(5) DEFAULT NULL,
 `zoom_duration` smallint(5) NOT NULL DEFAULT '2',
 `default_view` enum('street','satellite') NOT NULL DEFAULT 'satellite',
 `type` enum('default','google') NOT NULL DEFAULT 'default',
 `meta_title` text,
 `meta_description` text,
 `meta_image` text,
 `show_in_first_page` tinyint(1) NOT NULL DEFAULT '0',
 `open_target` enum('self','new') NOT NULL DEFAULT 'self',
 `ga_tracking_id` text,
 `cookie_consent` tinyint(1) NOT NULL DEFAULT '0',
 `pwa_enable` tinyint(1) NOT NULL DEFAULT '1',
 PRIMARY KEY (`id`),
 KEY `id_user` (`id_user`),
 CONSTRAINT `svt_globes_ibfk_1` FOREIGN KEY (`id_user`) REFERENCES `svt_users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_globe_list` (
 `id_globe` bigint(20) unsigned DEFAULT NULL,
 `id_virtualtour` bigint(20) unsigned DEFAULT NULL,
 `lat` text,
 `lon` text,
 `initial_pos` text,
 KEY `id_globe` (`id_globe`),
 KEY `id_virtualtour` (`id_virtualtour`),
 CONSTRAINT `svt_globe_list_ibfk_1` FOREIGN KEY (`id_globe`) REFERENCES `svt_globes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
 CONSTRAINT `svt_globe_list_ibfk_2` FOREIGN KEY (`id_virtualtour`) REFERENCES `svt_virtualtours` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_measures` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `id_room` bigint(20) unsigned DEFAULT NULL,
  `pitch_start` float DEFAULT NULL,
  `yaw_start` float DEFAULT NULL,
  `pitch_end` float DEFAULT NULL,
  `yaw_end` float DEFAULT NULL,
  `label` text,
  `params` text,
  `visible_multiview_ids` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `id_room` (`id_room`),
  CONSTRAINT `svt_measures_ibfk_1` FOREIGN KEY (`id_room`) REFERENCES `svt_rooms` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_users_log` (
  `id_user` int(11) unsigned DEFAULT NULL,
  `date_time` datetime DEFAULT NULL,
  `type` text,
  `params` text,
  KEY `id_user` (`id_user`),
  CONSTRAINT `svt_users_log_ibfk_1` FOREIGN KEY (`id_user`) REFERENCES `svt_users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_job_queue` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_time` datetime DEFAULT NULL,
  `id_virtualtour` bigint(20) unsigned DEFAULT NULL,
  `id_project` bigint(20) unsigned DEFAULT NULL,
  `type` text,
  `params` text,
  PRIMARY KEY (`id`),
  KEY `id_virtualtour` (`id_virtualtour`),
  CONSTRAINT `svt_job_queue_ibfk_1` FOREIGN KEY (`id_virtualtour`) REFERENCES `svt_virtualtours` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_video_projects` (
   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
   `date_time` datetime DEFAULT NULL,
   `id_virtualtour` bigint(20) unsigned DEFAULT NULL,
   `name` text,
   `resolution_w` smallint(5) DEFAULT 1920,
   `resolution_h` smallint(5) DEFAULT 1080,
   `fade` float DEFAULT 0.3,
   `fps` float DEFAULT 30,
   `watermark_pos` enum('none','bottom_left','top_left','bottom_right','top_right','center') NOT NULL DEFAULT 'none',
   `watermark_logo` text,
   `watermark_opacity` float DEFAULT 1.0,
   `audio` text,
   `voice` text,
   PRIMARY KEY (`id`),
   KEY `id_virtualtour` (`id_virtualtour`),
   CONSTRAINT `svt_video_projects_ibfk_1` FOREIGN KEY (`id_virtualtour`) REFERENCES `svt_virtualtours` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_video_project_slides` (
    `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
    `id_video_project` bigint(20) unsigned DEFAULT NULL,
    `type` enum('logo','text','panorama','video','image') DEFAULT NULL,
    `id_room` bigint(20) unsigned DEFAULT NULL,
    `file` text,
    `font` text,
    `duration` float DEFAULT 3,
    `params` text,
    `enabled` tinyint(1) NOT NULL DEFAULT 1,
    `priority` smallint(5) NOT NULL DEFAULT 0,
    PRIMARY KEY (`id`),
    KEY `id_video_project` (`id_video_project`),
    KEY `id_room` (`id_room`),
    CONSTRAINT `svt_video_project_slides_ibfk_1` FOREIGN KEY (`id_video_project`) REFERENCES `svt_video_projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT `svt_video_project_slides_ibfk_2` FOREIGN KEY (`id_room`) REFERENCES `svt_rooms` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_features` (
   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
   `feature` varchar(50) DEFAULT NULL,
   `name` text,
   `content` longtext,
   PRIMARY KEY (`id`),
   constraint svt_features_feature_uindex unique (feature)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_features_lang` (
    `id_feature` bigint(20) unsigned DEFAULT NULL,
    `language` varchar(10) DEFAULT NULL,
    `name` text,
    `content` longtext,
    UNIQUE KEY `id_feature` (`id_feature`,`language`),
    CONSTRAINT `svt_features_lang_ibfk_1` FOREIGN KEY (`id_feature`) REFERENCES `svt_features` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_category_vt_assoc` (
 `id_virtualtour` bigint(20) unsigned DEFAULT NULL,
 `id_category` int(11) unsigned DEFAULT NULL,
 KEY `id_virtualtour` (`id_virtualtour`),
 KEY `id_category` (`id_category`),
 CONSTRAINT `svt_category_vt_assoc_ibfk_1` FOREIGN KEY (`id_category`) REFERENCES `svt_categories` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
 CONSTRAINT `svt_category_vt_assoc_ibfk_2` FOREIGN KEY (`id_virtualtour`) REFERENCES `svt_virtualtours` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_ai_log` (
    `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
    `id_user` int(11) unsigned DEFAULT NULL,
    `date_time` datetime DEFAULT NULL,
    `response` text,
    `deleted` tinyint(1) NOT NULL DEFAULT 0,
    PRIMARY KEY (`id`),
    KEY `id_user` (`id_user`),
    CONSTRAINT `svt_ai_log_ibfk_1` FOREIGN KEY (`id_user`) REFERENCES `svt_users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_public_panoramas` (
   `id_room` bigint(20) unsigned NOT NULL,
   KEY `id_room` (`id_room`),
   CONSTRAINT `svt_public_panoramas_ibfk_1` FOREIGN KEY (`id_room`) REFERENCES `svt_rooms` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_sessions` (
   `id_user` int(11) unsigned DEFAULT NULL,
   `session` varchar(50) DEFAULT NULL,
   `date_time` datetime DEFAULT NULL,
   KEY `id_user` (`id_user`),
   CONSTRAINT `svt_sessions_ibfk_1` FOREIGN KEY (`id_user`) REFERENCES `svt_users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
   UNIQUE KEY `unique_user_session` (`id_user`, `session`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_intro_slider` (
    `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
    `id_virtualtour` bigint(20) unsigned DEFAULT NULL,
    `image` text,
    `priority` smallint(5) NOT NULL DEFAULT '0',
    PRIMARY KEY (`id`),
    KEY `id_virtualtour` (`id_virtualtour`),
    CONSTRAINT `svt_intro_slider_ibfk_1` FOREIGN KEY (`id_virtualtour`) REFERENCES `svt_virtualtours` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_autoenhance_log` (
    `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
    `id_user` int(11) unsigned DEFAULT NULL,
    `id_room` bigint(20) unsigned DEFAULT NULL,
    `date_time` datetime DEFAULT NULL,
    `id_image` text,
    `processed` tinyint(1) NOT NULL DEFAULT 0,
    `deleted` tinyint(1) NOT NULL DEFAULT 0,
    PRIMARY KEY (`id`),
    KEY `id_user` (`id_user`),
    KEY `id_room` (`id_room`),
    CONSTRAINT `svt_autoenhance_log_ibfk_1` FOREIGN KEY (`id_user`) REFERENCES `svt_users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT `svt_autoenhance_log_ibfk_2` FOREIGN KEY (`id_room`) REFERENCES `svt_rooms` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_custom_domains` (
    `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
    `id_user` int(11) unsigned DEFAULT NULL,
    `custom_domain` varchar(255) DEFAULT NULL,
    `date_time` datetime DEFAULT NULL,
    `status` tinyint(1) NOT NULL DEFAULT 0,
    `default_tour` tinyint(1) NOT NULL DEFAULT 0,
    `default_showcase` tinyint(1) NOT NULL DEFAULT 0,
    `default_globe` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `id_user` (`id_user`),
  CONSTRAINT `svt_custom_domains_ibfk_1` FOREIGN KEY (`id_user`) REFERENCES `svt_users` (`id`) ON DELETE SET NULL,
  UNIQUE KEY `unique_custom_domain` (`custom_domain`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_custom_domains_tours_assoc` (
    `id_custom_domain` bigint(20) unsigned DEFAULT NULL,
    `id_virtualtour` bigint(20) unsigned DEFAULT NULL,
    KEY `id_virtualtour` (`id_virtualtour`),
    KEY `id_custom_domain` (`id_custom_domain`),
    CONSTRAINT `svt_custom_domains_tours_assoc_ibfk_1` FOREIGN KEY (`id_virtualtour`) REFERENCES `svt_virtualtours` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT `svt_custom_domains_tours_assoc_ibfk_2` FOREIGN KEY (`id_custom_domain`) REFERENCES `svt_custom_domains` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
    UNIQUE KEY `unique_custom_domains_tours_assoc` (`id_virtualtour`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_custom_domains_showcase_assoc` (
    `id_custom_domain` bigint(20) unsigned DEFAULT NULL,
    `id_showcase` bigint(20) unsigned DEFAULT NULL,
    KEY `id_showcase` (`id_showcase`),
    KEY `id_custom_domain` (`id_custom_domain`),
    CONSTRAINT `svt_custom_domains_showcase_assoc_ibfk_1` FOREIGN KEY (`id_showcase`) REFERENCES `svt_showcases` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT `svt_custom_domains_showcase_assoc_ibfk_2` FOREIGN KEY (`id_custom_domain`) REFERENCES `svt_custom_domains` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
    UNIQUE KEY `unique_custom_domains_showcase_assoc` (`id_showcase`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_custom_domains_globe_assoc` (
    `id_custom_domain` bigint(20) unsigned DEFAULT NULL,
    `id_globe` bigint(20) unsigned DEFAULT NULL,
    KEY `id_globe` (`id_globe`),
    KEY `id_custom_domain` (`id_custom_domain`),
    CONSTRAINT `svt_custom_domains_globe_assoc_ibfk_1` FOREIGN KEY (`id_globe`) REFERENCES `svt_globes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT `svt_custom_domains_globe_assoc_ibfk_2` FOREIGN KEY (`id_custom_domain`) REFERENCES `svt_custom_domains` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
    UNIQUE KEY `unique_custom_domains_globe_assoc` (`id_globe`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_services` (
   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
   `name` text,
   `description` longtext,
   `price` float NOT NULL DEFAULT '0',
   `credits` smallint(5) NOT NULL DEFAULT '0',
   `type` enum('generic','tour_generic','tour_service') DEFAULT 'generic',
   `currency` varchar(3) NOT NULL DEFAULT 'USD',
   `block_tour` tinyint(1) NOT NULL DEFAULT '0',
   `visible` tinyint(1) NOT NULL DEFAULT '1',
   `position` smallint(5) NOT NULL DEFAULT '0',
   PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_services_lang` (
   `id_service` bigint(20) unsigned DEFAULT NULL,
   `language` varchar(10) DEFAULT NULL,
   `name` text,
   `description` longtext,
   UNIQUE KEY `id_service` (`id_service`,`language`),
   CONSTRAINT `svt_services_lang_ibfk_1` FOREIGN KEY (`id_service`) REFERENCES `svt_services` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_services_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uid` text,
  `id_user` int(11) unsigned DEFAULT NULL,
  `id_service` bigint(20) unsigned DEFAULT NULL,
  `id_virtualtour` bigint(20) unsigned DEFAULT NULL,
  `date_time` datetime DEFAULT NULL,
  `rooms_num` smallint(5) DEFAULT NULL,
  `credits_used` smallint(5) NOT NULL DEFAULT 0,
  `price` float NOT NULL DEFAULT '0',
  `currency` varchar(3) NOT NULL DEFAULT 'USD',
  `note` text,
  PRIMARY KEY (`id`),
  KEY `id_user` (`id_user`),
  KEY `id_service` (`id_service`),
  KEY `id_virtualtour` (`id_virtualtour`),
  CONSTRAINT `svt_services_log_ibfk_1` FOREIGN KEY (`id_user`) REFERENCES `svt_users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `svt_services_log_ibfk_2` FOREIGN KEY (`id_service`) REFERENCES `svt_services` (`id`) ON DELETE SET NULL,
  CONSTRAINT `svt_services_log_ibfk_3` FOREIGN KEY (`id_virtualtour`) REFERENCES `svt_virtualtours` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_poi_staging` (
    `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
    `id_poi` bigint(20) unsigned DEFAULT NULL,
    `default` tinyint(1) NOT NULL DEFAULT '0',
    `icon` text,
    `image` text,
    `tooltip` text,
    PRIMARY KEY (`id`),
    KEY `id_poi` (`id_poi`),
    CONSTRAINT `svt_poi_staging_ibfk_1` FOREIGN KEY (`id_poi`) REFERENCES `svt_pois` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_poi_staging_lang` (
  `id_staging` bigint(20) unsigned DEFAULT NULL,
  `language` varchar(10) DEFAULT NULL,
  `tooltip` text,
  UNIQUE KEY `id_staging` (`id_staging`,`language`),
  CONSTRAINT `svt_poi_staging_lang_ibfk_1` FOREIGN KEY (`id_staging`) REFERENCES `svt_poi_staging` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_learning_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(100) DEFAULT NULL,
  `email` varchar(150) DEFAULT NULL,
  `date_time` datetime DEFAULT NULL,
  `last_date_time` datetime DEFAULT NULL,
  `id_virtualtour` bigint(20) unsigned DEFAULT NULL,
  `score_global` smallint(5) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_virtualtour` (`id_virtualtour`,`ip`,`email`),
  CONSTRAINT `svt_learning_log_ibfk_1` FOREIGN KEY (`id_virtualtour`) REFERENCES `svt_virtualtours` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `svt_learning_poi_log` (
  `id_learning` bigint(20) unsigned DEFAULT NULL,
  `id_room` bigint(20) unsigned DEFAULT NULL,
  `id_poi` bigint(20) unsigned DEFAULT NULL,
  `visited` tinyint(1) NOT NULL DEFAULT '0',
  UNIQUE KEY `id_learning` (`id_learning`,`id_room`,`id_poi`),
  CONSTRAINT `svt_learning_poi_log_ibfk_1` FOREIGN KEY (`id_room`) REFERENCES `svt_rooms` (`id`) ON DELETE SET NULL,
  CONSTRAINT `svt_learning_poi_log_ibfk_2` FOREIGN KEY (`id_poi`) REFERENCES `svt_pois` (`id`) ON DELETE SET NULL,
  CONSTRAINT `svt_learning_poi_log_ibfk_3` FOREIGN KEY (`id_learning`) REFERENCES `svt_learning_log` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;