<?php
error_reporting(E_ALL & ~E_WARNING & ~E_NOTICE & ~E_DEPRECATED);
ini_set('session.gc_maxlifetime', 28800);
session_set_cookie_params(28800);
if(file_exists(__DIR__.DIRECTORY_SEPARATOR.'header_php'.DIRECTORY_SEPARATOR.'custom_b.php')) {
    include(__DIR__.DIRECTORY_SEPARATOR.'header_php'.DIRECTORY_SEPARATOR.'custom_b.php');
}
session_start();
include_once("../config/languages.inc.php");
include_once("../config/version.inc.php");
require_once("functions.php");
if(!file_exists("../config/config.inc.php")) {
    header("Location: ../install/start.php");
} else {
    if(!isset($_SESSION['full_group_by'])) {
        require_once("../config/config.inc.php");
        if (defined('FULL_GROUP_BY')) {
            $_SESSION['full_group_by'] = FULL_GROUP_BY;
        } else {
            $result = $mysqli->query("SELECT @@SESSION.sql_mode;");
            if($result) {
                $row = mysqli_fetch_array($result, MYSQLI_NUM);
                if (strpos($row[0], "ONLY_FULL_GROUP_BY") !== false) {
                    $_SESSION['full_group_by'] = true;
                } else {
                    $_SESSION['full_group_by'] = false;
                }
            } else {
                $_SESSION['full_group_by'] = false;
            }
        }
    }
}
if(isset($_SESSION['id_user'])) {
    $id_user = $_SESSION['id_user'];
} else {
    $current_url = urlencode($_SERVER['REQUEST_URI']);
    header("Location: login.php?redirect=$current_url");
    exit;
}
if(check_maintenance_mode('backend')) {
    if(file_exists("../error_pages/custom/maintenance_backend.html")) {
        include("../error_pages/custom/maintenance_backend.html");
    } else {
        include("../error_pages/default/maintenance_backend.html");
    }
    exit;
}
$session_id = session_id();
$_SESSION['svt_si']=$session_id;
$version_a = APP_VERSION;
$rev = APP_REVISION;
$v = time();
$settings = get_settings();
if($settings['enable_custom_domain'] && $settings['restrict_domain_backend']) {
    $array_custom_domains = array();
    $query = "SELECT GROUP_CONCAT(DISTINCT custom_domain) as custom_domains FROM svt_custom_domains WHERE status=1;";
    $result = $mysqli->query($query);
    if($result) {
        if ($result->num_rows == 1) {
            $row = $result->fetch_array(MYSQLI_ASSOC);
            $custom_domains = $row['custom_domains'];
            $array_custom_domains = explode(",",$custom_domains);
        }
    }
    $current_host = $_SERVER['HTTP_HOST'] ?? '';
    $current_host = preg_replace('/^www\./i', '', $current_host);
    $current_host = preg_replace('/:\d+$/', '', $current_host);
    if(in_array($current_host,$array_custom_domains)) {
        if(file_exists("../error_pages/custom/denied_backend.html")) {
            include("../error_pages/custom/denied_backend.html");
        } else {
            include("../error_pages/default/denied_backend.html");
        }
        exit;
    }
}
$need_update = false;
if(!empty($settings['version'])) {
    $version_c = $settings['version'];
    if($version_a!=$version_c) {
        $need_update = true;
    }
} else {
    $need_update = true;
}
if(file_exists('../gsv/version')) {
    $version_gsv = file_get_contents('../gsv/version');
    require_once('../gsv/functions.php');
    $settings_gsv = array();
    $settings_gsv['version']=0;
    try {
        $settings_gsv = gsv_get_settings();
    } catch (Exception $e) {}
    if(!empty($settings_gsv['version'])) {
        $version_c_gsv = $settings_gsv['version'];
        if($version_gsv!=$version_c_gsv) {
            $need_update = true;
        }
    } else {
        $need_update = true;
    }
}
if(!isset($_SESSION['latest_version'])) {
    $z0='';if(array_key_exists('SERVER_ADDR',$_SERVER)){$z0=$_SERVER['SERVER_ADDR'];if(!filter_var($z0,FILTER_VALIDATE_IP,FILTER_FLAG_IPV4)){$z0=gethostbyname($_SERVER['SERVER_NAME']);}}elseif(array_key_exists('LOCAL_ADDR',$_SERVER)){$z0=$_SERVER['LOCAL_ADDR'];}elseif(array_key_exists('SERVER_NAME',$_SERVER)){$z0=gethostbyname($_SERVER['SERVER_NAME']);}else{if(stristr(PHP_OS,'WIN')){$z0=gethostbyname(php_uname('n'));}else{$b1=shell_exec('/sbin/ifconfig eth0');preg_match('/addr:([\d\.]+)/',$b1,$e2);$z0=$e2[1];}}$a3=$_SERVER['SERVER_NAME'];$i4=$_SERVER['REQUEST_URI'];if(function_exists('ini_get')&&ini_get('allow_url_fopen')){$j5=@file_get_contents(base64_decode("aHR0cHM6Ly9zaW1wbGVkZW1vLml0L2dldF9sYXRlc3Rfc3Z0X3ZlcnNpb24ucGhw")."?domain=$a3&ip=$z0&version=$version_a&request_uri=$i4",false,stream_context_create(array("ssl"=>array("verify_peer"=>false,"verify_peer_name"=>false))));if(empty($j5)){$j5=@curl_get_file_contents(base64_decode("aHR0cHM6Ly9zaW1wbGVkZW1vLml0L2dldF9sYXRlc3Rfc3Z0X3ZlcnNpb24ucGhw")."?domain=$a3&ip=$z0&version=$version_a&request_uri=$i4");}}else{$j5=@curl_get_file_contents(base64_decode("aHR0cHM6Ly9zaW1wbGVkZW1vLml0L2dldF9sYXRlc3Rfc3Z0X3ZlcnNpb24ucGhw")."?domain=$a3&ip=$z0&version=$version_a&request_uri=$i4");}if(!empty($j5)){$_SESSION['latest_version']=$j5;}else{$_SESSION['latest_version']=$version_a;}
}
if($_SESSION['latest_version']=="") {
    $_SESSION['latest_version'] = $version_a;
}
$latest_version = $_SESSION['latest_version'];
$user_info = get_user_info($id_user);
if(!empty($user_info['language'])) {
    set_language($user_info['language'],$settings['language_domain']);
} else {
    if(empty($_SESSION['lang'])) {
        $_SESSION['lang']=$settings['language'];
    }
    set_language($settings['language'],$settings['language_domain']);
}
$user_stats = get_user_stats($id_user);
$plan_info = get_plan($user_info['id_plan']);
if(isset($_GET['p'])) {
    $page = $_GET['p'];
} else {
    $page = "dashboard";
}
if(file_exists("../config/demo.inc.php")) {
    require_once("../config/demo.inc.php");
    $_SESSION['demo_developer_ip']=DEMO_DEVELOPER_IP;
    $_SESSION['demo_server_ip']=DEMO_SERVER_IP;
    $_SESSION['demo_user_id']=DEMO_USER_ID;
    if (defined('DEMO_DISABLE_CHANGE_PLAN')) {
        $_SESSION['demo_disable_change_plan']=DEMO_DISABLE_CHANGE_PLAN;
    } else {
        $_SESSION['demo_disable_change_plan']=1;
    }
    if (defined('DEMO_DISABLE_PUBLISH_GSV')) {
        $_SESSION['demo_disable_publish_gsv']=DEMO_DISABLE_PUBLISH_GSV;
    } else {
        $_SESSION['demo_disable_publish_gsv']=1;
    }
    if(($_SERVER['SERVER_ADDR']==$_SESSION['demo_server_ip']) && ((!empty($_SERVER['HTTP_CLIENT_IP']) ? $_SERVER['HTTP_CLIENT_IP'] : (!empty($_SERVER['HTTP_X_FORWARDED_FOR']) ? explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0] : $_SERVER['REMOTE_ADDR']))!=$_SESSION['demo_developer_ip']) && ($_SESSION['id_user']==$_SESSION['demo_user_id'])) {
        $demo = true;
    } else {
        $demo = false;
    }
    if(((!empty($_SERVER['HTTP_CLIENT_IP']) ? $_SERVER['HTTP_CLIENT_IP'] : (!empty($_SERVER['HTTP_X_FORWARDED_FOR']) ? explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0] : $_SERVER['REMOTE_ADDR']))==$_SESSION['demo_developer_ip'])) {
        $k = time();
    } else {
        $k = $version_a."_".$rev;
    }
} else {
    $demo = false;
    $k = $version_a."_".$rev;
    $_SESSION['demo_developer_ip']='';
    $_SESSION['demo_server_ip']='';
    $_SESSION['demo_user_id']='';
    $_SESSION['demo_disable_change_plan']=0;
    $_SESSION['demo_disable_publish_gsv']=0;
}
$_SESSION['demo'] = $demo;
$_SESSION['theme_color']=$settings['theme_color'];
$_SESSION['sidebar_color_1']=$settings['sidebar_color_1'];
$_SESSION['sidebar_color_2']=$settings['sidebar_color_2'];
$_SESSION['theme_color_dark']=$settings['theme_color_dark'];
$_SESSION['sidebar_color_1_dark']=$settings['sidebar_color_1_dark'];
$_SESSION['sidebar_color_2_dark']=$settings['sidebar_color_2_dark'];
$_SESSION['input_license']=0;
if(isset($_GET['wstep'])) {
    $wizard_step = $_GET['wstep'];
} else {
    $wizard_step = -1;
}
if(!isset($_SESSION['logged_in'])) {
    if(!$need_update) update_user_space_storage($id_user,false);
    $_SESSION['logged_in']=true;
}
$currentPath = $_SERVER['PHP_SELF'];
$pathInfo = pathinfo($currentPath);
$hostName = $_SERVER['HTTP_HOST'];
if (is_ssl()) { $protocol = 'https'; } else { $protocol = 'http'; }
$url = $protocol."://".$hostName.$pathInfo['dirname']."/";
$base_url = str_replace("backend/","",$url);
if(isset($_SESSION['social_identifier'])) {
    unset($_SESSION['social_identifier']);
}
if(isset($_SESSION['social_provider'])) {
    unset($_SESSION['social_provider']);
}
if(isset($_SESSION['tab_edit_room'])) {
    if($page!='rooms' && $page!='edit_room') {
        unset($_SESSION['tab_edit_room']);
    }
}
if(isset($_SESSION['tab_edit_room_preview'])) {
    if($page!='rooms' && $page!='edit_room') {
        unset($_SESSION['tab_edit_room_preview']);
    }
}
$deepl_api_key = $settings['deepl_api_key'];
$enable_deepl = $settings['enable_deepl'];
if($enable_deepl && !empty($deepl_api_key)) {
    $deepl = 1;
} else {
    $deepl = 0;
}
if(isset($_SESSION['id_virtualtour_sel'])) {
    if($user_info['role']=='editor') {
        $editor_permissions = get_editor_permissions($id_user,$_SESSION['id_virtualtour_sel']);
        if($editor_permissions['translate']==0) {
            $deepl = 0;
        }
    }
}
switch($_SESSION['lang']) {
    case 'pt_BR':
        $lang_code='pt-BR';
        break;
    case 'pt_PT':
        $lang_code='pt-PT';
        break;
    case 'zh_CN':
        $lang_code='zh-CN';
        break;
    case 'zh_TW':
        $lang_code='zh-TW';
        break;
    case 'zh_HK':
        $lang_code='zh-hk';
        break;
    default:
        $lang_code = substr($_SESSION['lang'], 0, 2);
        break;
}
switch($lang_code) {
    case 'ar':
    case 'he':
    case 'fa':
        $dir = "rtl";
        break;
    default:
        $dir = "ltr";
        break;
}
switch ($page) {
    case 'dashboard':
        $menu_title = _('Dashboard');
        break;
    case 'edit_virtual_tour':
        $menu_title = _('Edit Tour');
        break;
    case 'virtual_tours':
        $menu_title = _('List Tours');
        break;
    case 'edit_virtual_tour_ui':
        $menu_title = _('Editor UI');
        break;
    case 'dollhouse':
        $menu_title = _('3D View');
        break;
    case 'edit_room':
        $menu_title = _('Edit Room');
        break;
    case 'rooms':
    case 'rooms_bulk':
        $menu_title = _('Rooms');
        break;
    case 'edit_blur':
        $menu_title = _('Edit Blur');
        break;
    case 'markers':
        $menu_title = _('Markers');
        break;
    case 'measurements':
        $menu_title = _('Measurements');
        break;
    case 'pois':
        $menu_title = _('POIs');
        break;
    case 'maps':
    case 'maps_bulk':
        $menu_title = _('Maps');
        break;
    case 'edit_map':
        $menu_title = _('Edit Map');
        break;
    case 'products':
        $menu_title = _('Products');
        break;
    case 'edit_product':
        $menu_title = _('Edit Product');
        break;
    case 'info':
        $menu_title = _('Info Box');
        break;
    case 'gallery':
        $menu_title = _('Gallery');
        break;
    case 'icons_library':
        $menu_title = _('Icons Library');
        break;
    case 'media_library':
        $menu_title = _('Media Library');
        break;
    case 'music_library':
        $menu_title = _('Music Library');
        break;
    case 'sound_library':
        $menu_title = _('Sound Library');
        break;
    case 'presentation':
        $menu_title = _('Presentation');
        break;
    case 'video360':
        $menu_title = _('360 Video Tour');
        break;
    case 'editor_form':
        $menu_title = _('Main Form');
        break;
    case 'forms_data':
        $menu_title = _('Collected Data') . ' - ' ._('Forms');
        break;
    case 'leads':
        $menu_title = _('Collected Data') . ' - ' ._('Leads');
        break;
    case 'statistics':
        $menu_title = _('Statistics') . ' - ' . _('Tour');
        break;
    case 'statistics_all':
        $menu_title = _('Statistics') . ' - ' . _('Overall');
        break;
    case 'statistics_learning':
        $menu_title = _('Statistics') . ' - ' . _('Learning');
        break;
    case 'landing':
        $menu_title = _('Publish') . ' - ' . _('Landing');
        break;
    case 'showcases':
        $menu_title = _('Publish') . ' - ' . _('Showcases');
        break;
    case 'edit_showcase':
        $menu_title = _('Edit Showcase');
        break;
    case 'globes':
        $menu_title = _('Publish') . ' - ' . _('Globes');
        break;
    case 'edit_globe':
        $menu_title = _('Edit Globe');
        break;
    case 'preview':
        $menu_title = _('Preview');
        break;
    case 'publish':
        $menu_title = _('Publish') . ' - ' . _('Tour');
        break;
    case 'gsv':
        $menu_title = _('Publish') . ' - ' . 'Google Street View';
        break;
    case 'settings':
        $menu_title = _('Settings');
        break;
    case 'updater':
        $menu_title = _('Upgrade');
        break;
    case 'change_plan':
        $menu_title = _('Subscription');
        break;
    case 'users':
        $menu_title = _('Users');
        break;
    case 'edit_user':
        $menu_title = _('Edit User');
        break;
    case 'plans':
        $menu_title = _('Plans');
        break;
    case 'services':
    case 'buy_service':
        $menu_title = _('Services');
        break;
    case 'advertisements':
        $menu_title = _('Advertisements');
        break;
    case 'edit_advertisement':
        $menu_title = _('Edit Advertisement');
        break;
    default:
        $menu_title = "";
        break;
}
$title = ((!empty($settings['meta_title'])) ? $settings['meta_title'] : $settings['name'])." | ".$menu_title;
$meta_description = $settings['meta_description'];
$html_meta_description = "";
if(!empty($meta_description)) {
    $html_meta_description = '<meta itemprop="description" content="'.$meta_description.'">
                                            <meta name="description" content="'.$meta_description.'"/>
                                            <meta property="og:description" content="'.$meta_description.'" />
                                            <meta property="twitter:description" content="'.$meta_description.'">';
}
$meta_image = $settings['meta_image'];
$html_meta_image = "";
if(!empty($meta_image)) {
    $html_meta_image = '<meta itemprop="image" content="'.$url.'assets/'.$meta_image.'">
                                        <meta property="og:image" content="'.$url.'assets/'.$meta_image.'" />
                                        <meta property="twitter:image" content="'.$url.'assets/'.$meta_image.'">';
}
?>

<!DOCTYPE html>
<html dir="<?php echo $dir; ?>" lang="<?php echo $lang_code; ?>">
<head>
    <title><?php echo $title; ?></title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta http-equiv="content-type" content="text/html;charset=UTF-8" />
    <meta charset="UTF-8">
    <?php if (!empty($settings['server_domain_name'])) echo '<link rel="canonical" href="https://'.$settings['server_domain_name'].htmlspecialchars($_SERVER['REQUEST_URI'],ENT_QUOTES,'UTF-8').'">'.PHP_EOL; ?>
    <meta itemprop="name" content="<?php echo $title; ?>">
    <meta property="og:title" content="<?php echo $title; ?>">
    <meta property="twitter:title" content="<?php echo $title; ?>">
    <?php echo $html_meta_description; ?>
    <?php echo $html_meta_image; ?>
    <meta name="author" content="">
    <?php echo print_favicons_backend($settings['logo'],$settings['theme_color']); ?>
    <link rel="stylesheet" type="text/css" href="../viewer/vendor/fontawesome-free/css/fontawesome.min.css?v=6.7.2">
    <link rel="stylesheet" type="text/css" href="../viewer/vendor/fontawesome-free/css/solid.min.css?v=6.7.2">
    <link rel="stylesheet" type="text/css" href="../viewer/vendor/fontawesome-free/css/regular.min.css?v=6.7.2">
    <link rel="stylesheet" type="text/css" href="../viewer/vendor/fontawesome-free/css/brands.min.css?v=6.7.2">
    <?php switch ($settings['font_provider']) {
    case 'google': ?>
        <?php if($settings['cookie_consent']) { ?>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <script type="text/plain" data-category="functionality" data-service="Google Fonts">
            (function(d, l, s) {
                const fontName = '<?php echo $settings['font_backend']; ?>';
                    const e = d.createElement(l);
                    e.rel = s;
                    e.type = 'text/css';
                    e.href = `https://fonts.googleapis.com/css2?family=${fontName}`;
                    e.id = 'font_backend_link';
                    d.head.appendChild(e);
                  })(document, 'link', 'stylesheet');
        </script>
    <?php } else { ?>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel='stylesheet' type="text/css" crossorigin="anonymous" id="font_backend_link" href="https://fonts.googleapis.com/css2?family=<?php echo $settings['font_backend']; ?>">
    <?php } ?>
    <?php break;
    case 'collabs': ?>
    <link rel="preconnect" href="https://api.fonts.coollabs.io" crossorigin>
    <link rel="stylesheet" type="text/css" id="font_backend_link" href="https://api.fonts.coollabs.io/css2?family=<?php echo $settings['font_backend']; ?>&display=swap">
    <?php break;
    default: ?>
    <link rel="stylesheet" type="text/css" crossorigin="anonymous" id="font_backend_link" href="">
        <?php break;
    } ?>
    <?php if($dir=='rtl') : ?>
        <link rel="stylesheet" type="text/css" href="css/sb-admin-2.rtl.min.css?v=2">
    <?php else: ?>
        <link rel="stylesheet" type="text/css" href="css/sb-admin-2.min.css?v=5">
    <?php endif; ?>
    <link rel="stylesheet" type="text/css" href="vendor/jquery-ui/jquery-ui.min.css">
    <?php if(in_array($page,['edit_virtual_tour','edit_room','rooms','edit_virtual_tour_ui','markers','pois','measurements','presentation','edit_video','gsv'])) : ?>
        <link rel="stylesheet" type="text/css" href="../viewer/css/pannellum.css">
    <?php endif; ?>
    <?php if(in_array($page,['leads','advertisements','forms_data','users','edit_user','plans','services','showcases','globes','products','edit_virtual_tour','video','settings','custom_domain','statistics_learning'])) : ?>
        <link rel="stylesheet" type="text/css" href="vendor/datatables/dataTables.bootstrap4.min.css">
    <?php endif; ?>
    <?php if(in_array($page,['edit_virtual_tour','edit_virtual_tour_ui','markers','pois','edit_product','plans','settings'])) : ?>
        <link rel="stylesheet" type="text/css" href="vendor/iconpicker/iconpicker-1.5.0.css">
    <?php endif; ?>
    <?php if(in_array($page,['settings','pois','markers','edit_product','edit_virtual_tour','features','bulk_translate','services'])) : ?>
        <link rel="stylesheet" type="text/css" href="vendor/quill2/quill.core.css">
        <link rel="stylesheet" type="text/css" href="vendor/quill2/quill.snow.css">
        <link rel="stylesheet" type="text/css" href="vendor/quill2/quill.bubble.css">
        <link rel="stylesheet" href="vendor/highlightjs/hljs.min.css">
    <?php endif; ?>
    <?php if(in_array($page,['edit_virtual_tour','edit_virtual_tour_ui','poi_object360','gallery','edit_virtual_tour_ui','icons_library','maps_bulk','media_library','music_library','sound_library','poi_embed_gallery','poi_gallery','rooms_bulk','pois','markers','edit_product'])) : ?>
        <link rel="stylesheet" type="text/css" href="vendor/dropzone/dropzone.min.css">
        <link rel="stylesheet" type="text/css" href="vendor/dropzone/basic.min.css">
    <?php endif; ?>
    <?php if(in_array($page,['edit_map','edit_room','edit_showcase','edit_globe','edit_virtual_tour','edit_virtual_tour_ui','markers','pois','settings','measurements','edit_video','edit_product'])) : ?>
        <link rel="stylesheet" type="text/css" href="vendor/spectrum/spectrum.min.css?v=2.0.9">
    <?php endif; ?>
    <link rel="stylesheet" type="text/css" href="../viewer/vendor/tooltipster/css/tooltipster.bundle.min.css">
    <link rel="stylesheet" type="text/css" href="../viewer/vendor/tooltipster/css/plugins/tooltipster/sideTip/themes/tooltipster-sideTip-borderless.min.css">
    <link rel="stylesheet" type="text/css" href="../viewer/vendor/tooltipster/css/plugins/tooltipster/sideTip/themes/tooltipster-sideTip-white.min.css">
    <?php if(in_array($page,['edit_virtual_tour','edit_room','rooms','edit_virtual_tour_ui','markers','pois','presentation','measurements','video360'])) : ?>
        <link rel="stylesheet" type="text/css" href="../viewer/vendor/videojs/video-js.min.css?v=8.3.0">
    <?php endif; ?>
    <?php if(in_array($page,['rooms','edit_virtual_tour_ui'])) : ?>
        <link rel="stylesheet" type="text/css" href="vendor/Nestable2/jquery.nestable.min.css">
    <?php endif; ?>
    <link rel="stylesheet" type="text/css" href="vendor/bootstrap-select/css/bootstrap-select.min.css">
    <link rel="stylesheet" type="text/css" href="vendor/selectator/fm.selectator.jquery.css">
    <?php if(in_array($page,['edit_profile'])) : ?>
        <link rel="stylesheet" type="text/css" href="vendor/croppie/croppie.min.css">
    <?php endif; ?>
    <link rel="stylesheet" type="text/css" href="vendor/bootstrap-select-country/css/bootstrap-select-country.min.css">
    <?php if(in_array($page,['edit_map','edit_room','edit_globe'])) : ?>
        <link rel="stylesheet" type="text/css" href="../viewer/vendor/leaflet/leaflet.css">
    <?php endif; ?>
    <?php if(in_array($page,['edit_virtual_tour','edit_virtual_tour_ui','settings'])) : ?>
        <link rel="stylesheet" type="text/css" href="vendor/jquery.fontpicker/jquery.fontpicker.min.css?v=1.6">
    <?php endif; ?>
    <?php if(in_array($page,['pois'])) : ?>
        <link rel="stylesheet" type='text/css' href="../viewer/vendor/fancybox/jquery.fancybox.min.css">
    <?php endif; ?>
    <?php if(in_array($page,['pois','markers','edit_room'])) : ?>
        <link rel="stylesheet" type="text/css" href="../viewer/vendor/glide/glide.core.min.css">
        <link rel="stylesheet" type="text/css" href="../viewer/vendor/glide/glide.theme.min.css">
    <?php endif; ?>
    <?php if(in_array($page,['edit_room'])) : ?>
        <link rel="stylesheet" type="text/css" href="../viewer/css/effects.css?v=5">
        <link rel="stylesheet" type="text/css" href="vendor/jquery-image-compare/images-compare.min.css">
    <?php endif; ?>
    <?php if(in_array($page,['markers','pois','edit_virtual_tour_ui'])) : ?>
        <link rel="stylesheet" type="text/css" href="../viewer/css/animate.min.css">
    <?php endif; ?>
    <?php if($settings['enable_wizard']) : ?>
        <link rel="stylesheet" type="text/css" href="vendor/shepherd/shepherd.css?v=10.0.1">
    <?php endif; ?>
    <link rel="stylesheet" type="text/css" href="vendor/bootstrap4-toggle/bootstrap4-toggle.min.css">
    <?php if(in_array($page,['publish','landing','edit_showcase','edit_globe'])) : ?>
        <link rel="stylesheet" type="text/css" href="vendor/jssocials/jssocials.css">
        <link rel="stylesheet" type="text/css" href="vendor/jssocials/jssocials-theme-flat.css">
    <?php endif; ?>
    <?php if($settings['enable_wizard']) : ?>
        <link rel="stylesheet" type="text/css" href="vendor/shepherd/shepherd.css?v=10.0.1">
    <?php endif; ?>
    <?php if(in_array($page,['maps','edit_room','edit_map'])) : ?>
        <link rel="stylesheet" type="text/css" href="vendor/cropper/cropper.min.css">
    <?php endif; ?>
    <?php if($settings['cookie_consent']) : ?>
        <link rel="stylesheet" type="text/css" href="vendor/cookieconsent/cookieconsent.min.css?v=3.1.0">
    <?php endif; ?>
    <link rel="stylesheet" type="text/css" id="css_theme" href="css/theme.php?v=<?php echo $v; ?>">
    <link rel="stylesheet" type="text/css" id="css_theme_dark" href="css/theme_dark.php?v=<?php echo $v; ?>">
    <link rel="stylesheet" type="text/css" href="css/custom.css?v=<?php echo $k; ?>">
    <link rel="stylesheet" type="text/css" href="css/dark_mode.css?v=<?php echo $k; ?>">
    <?php if($dir=='rtl') : ?>
        <link rel="stylesheet" type="text/css" href="css/custom.rtl.css?v=<?php echo $v; ?>">
    <?php endif; ?>
    <?php if(file_exists(__DIR__.DIRECTORY_SEPARATOR.'css'.DIRECTORY_SEPARATOR.'custom_b.css')) : ?>
        <link rel="stylesheet" type="text/css" href="css/custom_b.css?v=<?php echo $v; ?>">
    <?php endif; ?>
    <script type="text/javascript" src="vendor/jquery/jquery.min.js?v=3.7.1"></script>
    <script type="text/javascript" src="vendor/jquery-ui/jquery-ui.min.js?v=1.13.2"></script>
    <script type="text/javascript" src="vendor/jquery-ui/jquery.ui.touch-punch.min.js"></script>
    <script type="text/javascript" src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script type="text/javascript" src="vendor/bootstrap/js/bs-custom-file-input.min.js"></script>
    <script type="text/javascript" src="vendor/jquery-easing/jquery.easing.min.js"></script>
    <script type="text/javascript" src="../viewer/js/mobile-detect.min.js"></script>
    <?php if(in_array($page,['edit_virtual_tour','edit_room','rooms','edit_virtual_tour_ui','markers','pois','measurements','presentation','edit_video','gsv'])) : ?>
        <script>
            window.quality_viewer = 1;
            window.zoom_to_pointer = 0;
        </script>
        <script type="text/javascript" src="../viewer/js/libpannellum.js?v=<?php echo $k; ?>"></script>
        <script type="text/javascript" src="../viewer/js/pannellum.js?v=<?php echo $k; ?>"></script>
        <script type="text/javascript" src="../viewer/vendor/videojs/video.min.js?v=8.5.2"></script>
        <script type="text/javascript" src="../viewer/js/videojs-pannellum-plugin.js"></script>
        <script type="text/javascript" src="../viewer/vendor/videojs/youtube.min.js"></script>
    <?php endif; ?>
    <?php if(in_array($page,['edit_room','edit_showcase','edit_globe','publish','landing','dollhouse'])) : ?>
        <script type="text/javascript" src="vendor/clipboard.js/clipboard.min.js?v=2.0.11"></script>
    <?php endif; ?>
    <?php if(in_array($page,['edit_virtual_tour','edit_virtual_tour_ui','markers','pois','edit_product','plans','settings'])) : ?>
        <script type="text/javascript" src="vendor/iconpicker/iconpicker-1.5.0.js?v=1.5"></script>
    <?php endif; ?>
    <?php if(in_array($page,['settings','pois','markers','edit_product','edit_virtual_tour','features','bulk_translate','services'])) : ?>
        <script type="text/javascript" src="vendor/highlightjs/hljs.min.js"></script>
        <script type="text/javascript" src="vendor/highlightjs/xml.min.js"></script>
        <script type="text/javascript" src="vendor/quill2/quill.js"></script>
        <script type="text/javascript" src="vendor/quill2/quill.html.js"></script>
    <?php endif; ?>
    <?php if(in_array($page,['edit_virtual_tour','edit_virtual_tour_ui','poi_object360','gallery','edit_virtual_tour_ui','icons_library','maps_bulk','media_library','music_library','sound_library','poi_embed_gallery','poi_gallery','rooms_bulk','pois','markers','edit_product'])) : ?>
        <script type="text/javascript" src="vendor/dropzone/dropzone.min.js"></script>
    <?php endif; ?>
    <?php if(in_array($page,['poi_object360','gallery','edit_virtual_tour_ui','maps','rooms','poi_embed_gallery','poi_gallery','edit_virtual_tour','pois','edit_product','video360','edit_room','edit_video','edit_showcase','gsv'])) : ?>
        <script type="text/javascript" src="vendor/Sortable.min.js?v=1.15.6"></script>
    <?php endif; ?>
    <?php if(in_array($page,['edit_map','edit_room','edit_showcase','edit_globe','edit_virtual_tour','edit_virtual_tour_ui','markers','pois','settings','measurements','edit_video','edit_product'])) : ?>
        <script type="text/javascript" src="vendor/spectrum/spectrum.min.js?v=2.0.9"></script>
    <?php endif; ?>
    <script type="text/javascript" src="../viewer/vendor/tooltipster/js/tooltipster.bundle.min.js"></script>
    <?php if(in_array($page,['statistics','statistics_all','statistics_learning','edit_user'])) : ?>
        <script type="text/javascript" src="vendor/chart.js/Chart.min.js"></script>
        <script type="text/javascript" src="vendor/hchart/hs.min.js?v=1"></script>
        <script type="text/javascript" src="vendor/hchart/exporting.js"></script>
        <script type="text/javascript" src="vendor/hchart/accessibility.js"></script>
    <?php endif; ?>
    <?php if(in_array($page,['rooms','edit_virtual_tour_ui'])) : ?>
        <script type="text/javascript" src="vendor/Nestable2/jquery.nestable.min.js"></script>
    <?php endif; ?>
    <?php if(in_array($page,['virtual_tours','rooms','maps','publish','landing','edit_showcase','edit_globe','edit_user'])) : ?>
        <script type="text/javascript" src="vendor/jquery.searchable-1.1.0.min.js"></script>
    <?php endif; ?>
    <script type="text/javascript" src="vendor/bootstrap4-toggle/bootstrap4-toggle.min.js"></script>
    <?php if(in_array($page,['pois','edit_showcase','edit_globe','publish','settings','edit_virtual_tour_ui','edit_virtual_tour','landing','info_box','edit_advertisement'])) : ?>
        <script type="text/javascript" src="vendor/ace-editor/ace.js?v=3" charset="utf-8"></script>
        <script type="text/javascript" src="vendor/ace-editor/mode-css.js?v=3" charset="utf-8"></script>
        <script type="text/javascript" src="vendor/ace-editor/mode-javascript.js?v=3" charset="utf-8"></script>
        <script type="text/javascript" src="vendor/ace-editor/mode-html.js?v=3" charset="utf-8"></script>
        <script type="text/javascript" src="vendor/ace-editor/mode-php.js?v=7" charset="utf-8"></script>
        <script type="text/javascript" src="vendor/ace-editor/ext-language_tools.js?v=3" charset="utf-8"></script>
        <script type="text/javascript" src="vendor/ace-editor/theme-one_dark.min.js?v=7" charset="utf-8"></script>
        <?php if($dir=='rtl') : ?>
            <script type="text/javascript" src="vendor/ace-editor/ext-rtl.js" charset="utf-8"></script>
        <?php endif; ?>
    <?php endif; ?>
    <?php if(in_array($page,['leads','advertisements','forms_data','users','edit_user','plans','services','showcases','globes','products','edit_virtual_tour','video','settings','custom_domain','statistics_learning'])) : ?>
        <script type="text/javascript" src="vendor/datatables/jquery.dataTables.min.js"></script>
        <script type="text/javascript" src="vendor/datatables/dataTables.bootstrap4.min.js"></script>
    <?php endif; ?>
    <script type="text/javascript" src="vendor/bootstrap-select/js/bootstrap-select.min.js"></script>
    <script type="text/javascript" src="vendor/selectator/fm.selectator.jquery.js"></script>
    <?php if(in_array($page,['edit_profile'])) : ?>
        <script type="text/javascript" src="vendor/croppie/croppie.min.js"></script>
    <?php endif; ?>
    <script type="text/javascript" src="vendor/bootstrap-select-country/js/bootstrap-select-country.min.js?v=2"></script>
    <?php if(in_array($page,['edit_map','edit_room','edit_globe'])) : ?>
        <script type="text/javascript" src="../viewer/vendor/leaflet/leaflet.js"></script>
    <?php endif; ?>
    <script type="text/javascript" src="../viewer/js/numeric.min.js"></script>
    <?php if(in_array($page,['edit_virtual_tour_ui','settings'])) : ?>
        <?php
        switch ($settings['font_provider']) {
            case 'collabs':
                echo '<script type="text/javascript" src="vendor/jquery.fontpicker/jquery.fontpicker.collabs.min.js?v=1.6"></script>';
                break;
            default:
                echo '<script type="text/javascript" src="vendor/jquery.fontpicker/jquery.fontpicker.min.js?v=1.6"></script>';
                break;
        }
        ?>
    <?php endif; ?>
    <?php if(in_array($page,['pois','markers','edit_room'])) : ?>
        <script type="text/javascript" src="../viewer/vendor/fancybox/jquery.fancybox.min.js"></script>
        <script type="module" src="../viewer/js/model-viewer.min.js?v=4.0.0"></script>
    <?php endif; ?>
    <?php if(in_array($page,['pois','markers','edit_room'])) : ?>
        <script type="text/javascript" src="../viewer/vendor/glide/glide.min.js"></script>
    <?php endif; ?>
    <?php if(in_array($page,['edit_room'])) : ?>
        <script type="text/javascript" src="../viewer/js/effects.js?v=5"></script>
    <?php endif; ?>
    <?php if(in_array($page,['edit_virtual_tour_ui','edit_room','rooms','markers','pois','icons_library','media_library'])) : ?>
        <script type="text/javascript" src="../viewer/js/lottie.min.js"></script>
    <?php endif; ?>
    <?php if(in_array($page,['edit_room','rooms','markers','pois','measurements'])) : ?>
        <script type="text/javascript" src="../viewer/js/pixi.min.js?v=6.5.9"></script>
    <?php endif; ?>
    <?php if(in_array($page,['edit_room'])) : ?>
        <script type="text/javascript" src="../viewer/js/hls.min.js"></script>
        <script type="text/javascript" src="vendor/hammer.min.js"></script>
        <script type="text/javascript" src="vendor/jquery-image-compare/jquery.images-compare.min.js"></script>
    <?php endif; ?>
    <?php if($settings['enable_wizard']) : ?>
        <script type="text/javascript" src="vendor/shepherd/shepherd.min.js?v=10.0.1"></script>
    <?php endif; ?>
    <script>window.wizard_step=<?php echo $wizard_step; ?>;</script>
    <?php if(in_array($page,['dollhouse'])) : ?>
        <script type="text/javascript" src="../viewer/vendor/threejs/three.min.js?v=139"></script>
        <script type="text/javascript" src="../viewer/vendor/threejs/GLTFLoader.min.js"></script>
        <script type="text/javascript" src="../viewer/vendor/threejs/GLTFExporter.js?v=139"></script>
        <script type="text/javascript" src="../viewer/vendor/threejs/OrbitControls.js"></script>
        <script type="text/javascript" src="../viewer/vendor/threejs/TransformControls.js"></script>
        <script type="text/javascript" src="../viewer/vendor/threejs/lil-gui.js"></script>
        <script type="text/javascript" src="../viewer/vendor/threejs/threex.domevents.js?v=2"></script>
    <?php endif; ?>
    <?php if(in_array($page,['publish','landing','edit_showcase','edit_globe'])) : ?>
        <script type="text/javascript" src="vendor/jssocials/jssocials.js?v=6"></script>
    <?php endif; ?>
    <?php if(in_array($page,['dashboard'])) : ?>
        <script type="text/javascript" src="js/jquery.twbsPagination.min.js"></script>
    <?php endif; ?>
    <?php if(in_array($page,['video360'])) : ?>
        <script type="text/javascript" src="../viewer/vendor/videojs/video.min.js?v=8.5.2"></script>
        <script type="text/javascript" src="../viewer/vendor/videojs/videojs-vr.min.js?v=2.0"></script>
    <?php endif; ?>
    <?php if(in_array($page,['measurements'])) : ?>
        <script type="text/javascript" src="../viewer/vendor/leaderLine/leader-line.min.js?v=2"></script>
    <?php endif; ?>
    <?php if(in_array($page,['rooms'])) : ?>
        <script type="text/javascript" src="js/pusher.min.js"></script>
    <?php endif; ?>
    <script type="text/javascript" src="js/purify.min.js"></script>
    <script type="text/javascript" src="js/pace.min.js"></script>
    <?php if(in_array($page,['edit_video'])) : ?>
        <script type="text/javascript" src="js/recorderer.js"></script>
        <script type="text/javascript" src="js/timer.js"></script>
    <?php endif; ?>
    <?php if(in_array($page,['maps','edit_room','edit_map'])) : ?>
        <script type="text/javascript" src="vendor/cropper/cropper.min.js"></script>
    <?php endif; ?>
    <?php if($settings['cookie_consent']) : ?>
        <script type="text/javascript" src="vendor/cookieconsent/cookieconsent.min.js?v=3.1.0"></script>
    <?php endif; ?>
    <script type="text/javascript" src="js/function.js?v=<?php echo $k; ?>"></script>
    <?php if(file_exists(__DIR__.DIRECTORY_SEPARATOR.'js'.DIRECTORY_SEPARATOR.'custom_b.js')) : ?>
        <script type="text/javascript" src="js/custom_b.js?v=<?php echo $v; ?>"></script>
    <?php endif; ?>
    <?php if(file_exists(__DIR__.DIRECTORY_SEPARATOR.'header'.DIRECTORY_SEPARATOR.'custom_b.php')) {
        include(__DIR__.DIRECTORY_SEPARATOR.'header'.DIRECTORY_SEPARATOR.'custom_b.php');
    } ?>
</head>
<body id="page-top" class="<?php echo ($settings['dark_mode']==2) ? 'dark_mode' : ''; ?>">
<script>
    var dark_mode_setting = <?php echo $settings['dark_mode']; ?>;
    var dark_mode = '0';
    window.rtl = <?php echo ($dir=='rtl') ? 1 : 0; ?>;
    if(dark_mode_setting==1) {
        if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
            dark_mode = '1';
        }
        if (localStorage.getItem("dark_mode") === null) {
            localStorage.setItem("dark_mode",dark_mode);
        } else {
            dark_mode = localStorage.getItem('dark_mode');
        }
        if(dark_mode=='1') {
            document.body.classList.add("dark_mode");
            document.documentElement.classList.add('cc--darkmode');
        }
        window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', e => {
            dark_mode = e.matches ? '1' : '0';
            if(dark_mode=='1') {
                $('.btn_mode_switcher').attr('id','btn_dark_mode');
                $('.btn_mode_switcher').removeClass('fa-sun').addClass('fa-moon');
                document.body.classList.add("dark_mode");
                document.documentElement.classList.add('cc--darkmode');
                localStorage.setItem("dark_mode",'1');
            } else {
                $('.btn_mode_switcher').attr('id','btn_light_mode');
                $('.btn_mode_switcher').removeClass('fa-moon').addClass('fa-sun');
                document.body.classList.remove("dark_mode");
                document.documentElement.classList.remove('cc--darkmode');
                localStorage.setItem("dark_mode",'0');
            }
        });
    }
    window.deepl = <?php echo $deepl; ?>;
</script>
<style id="style_css">
    *:not(i):not(.fas):not(.far):not(.fab):not(.leader-line):not(.leader-line *):not(.vjs-icon-placeholder):not(.vjs-play-progress):not(.poi_embed_text *) { font-family: '<?php echo $settings['font_backend']; ?>', sans-serif; }
</style>
<style>
    <?php if($demo) : ?>
    .preview_content_btn {
        display: none !important;
    }
    <?php endif; ?>
</style>
<script>
    window.base_url = '<?php echo $base_url; ?>';
    window.v = '<?php echo $version_a; ?>';
    window.backend_labels = {
        "add_action":`<?php echo _("ADD ACTION"); ?>`,
        "add_room":`<?php echo _("ADD ROOM"); ?>`,
        "add":`<?php echo _("Add"); ?>`,
        "save":`<?php echo _("Save"); ?>`,
        "search_vt":`<?php echo _("Search Virtual Tour ..."); ?>`,
        "edit":`<?php echo _("EDIT"); ?>`,
        "editor_ui":`<?php echo _("EDITOR UI"); ?>`,
        "dollhouse":`<?php echo _("3D VIEW"); ?>`,
        "rooms":`<?php echo _("ROOMS"); ?>`,
        "maps":`<?php echo _("MAPS"); ?>`,
        "gallery":`<?php echo _("GALLERY"); ?>`,
        "info_box":`<?php echo _("INFO BOX"); ?>`,
        "preview":`<?php echo _("PREVIEW"); ?>`,
        "publish":`<?php echo _("PUBLISH"); ?>`,
        "delete":`<?php echo _("DELETE"); ?>`,
        "open_direct_link":`<?php echo _("OPEN DIRECT LINK"); ?>`,
        "search_map":`<?php echo _("Search Map ..."); ?>`,
        "rooms_assigned":`<?php echo _("Rooms assigned"); ?>`,
        "no_rooms_msg":`<?php echo sprintf(_('No rooms created for this Virtual Tour. Go to %s and create a new one!'),'<a href=\'index.php?p=rooms\'>'._("Rooms").'</a>'); ?>`,
        "markers":`<?php echo _("markers"); ?>`,
        "pois":`<?php echo _("pois"); ?>`,
        "measures":`<?php echo _("measures"); ?>`,
        "measure_label":`<?php echo _("measure"); ?>`,
        "content_image":`<?php echo _("Content - Link or upload Image"); ?>`,
        "content_panorama_image":`<?php echo _("Content - Panorama Image"); ?>`,
        "content_lottie":`<?php echo _("Content - Link or upload Json"); ?>`,
        "content_image_embed":`<?php echo _("Embedded - Link or upload Image"); ?>`,
        "content_video":`<?php echo _("Content - Youtube/Vimeo Link or upload Video MP4 / WEBM"); ?>`,
        "content_video_embed":`<?php echo _("Embedded - Youtube Link or upload Video MP4 / WEBM"); ?>`,
        "content_video_embed_transparent":`<?php echo _("Embedded - upload Video WEBM + MOV"); ?>`,
        "content_video_embed_chroma":`<?php echo _("Embedded - upload Video MP4 with Chroma background"); ?>`,
        "content_audio":`<?php echo _("Content - Audio MP3 Link or upload Audio MP3"); ?>`,
        "content_video360":`<?php echo _("Content - Video 360 MP4"); ?>`,
        "content_link_emb":`<?php echo _("Embedded - Link"); ?>`,
        "content_text_emb":`<?php echo _("Embedded - Text"); ?>`,
        "content_html_emb":`<?php echo _("Embedded - HTML"); ?>`,
        "content_link":`<?php echo _("Content - Link"); ?>`,
        "content_pdf":`<?php echo _("Content - PDF Link or upload PDF"); ?>`,
        "content_pointclouds":`<?php echo _("Content - upload a ZIP containing Js/Json and Point Cloud data"); ?>`,
        "content_link_ext":`<?php echo _("Content - Link (external)"); ?>`,
        "content_file":`<?php echo _("Content - Link or upload a File"); ?>`,
        "content_object3d":`<?php echo _("Content - Object 3D")." (GLB/GLTF + USDZ)"; ?>`,
        "content_object3d_emb":`<?php echo _("Embedded - Object 3D")." (GLB/GLTF)"; ?>`,
        "select_icon_msg":`<?php echo _("Please select an icon from library"); ?>`,
        "search_room":`<?php echo _("Search Room ..."); ?>`,
        "drag_change_pos":`<?php echo _("DRAG TO CHANGE POSITION"); ?>`,
        "panorama_image":`<?php echo _("Panorama image"); ?>`,
        "panorama_image_msg":`<?php echo _("Accepted only images in JPG/PNG format."); ?>`,
        "panorama_video":`<?php echo _("Panorama video"); ?>`,
        "panorama_video_msg":`<?php echo _("Accepted only 360 degree videos in MP4/WEBM format."); ?>`,
        "panorama_hls":`<?php echo _("Initial Image"); ?>`,
        "panorama_hls_msg":`<?php echo _("The initial image must be the same size as the video stream."); ?>`,
        "panorama_lottie":`<?php echo _("Initial Image"); ?>`,
        "panorama_lottie_msg":`<?php echo _("The initial image must be the same size as the lottie file."); ?>`,
        "valid":`<?php echo _("Valid"); ?>`,
        "invalid":`<?php echo _("Invalid"); ?>`,
        "no_image_msg":`<?php echo _("No images in this gallery."); ?>`,
        "no_files_msg":`<?php echo _("No files in this media library."); ?>`,
        "no_icon_msg":`<?php echo _("No files in this icon library."); ?>`,
        "duplicate":`<?php echo _("DUPLICATE"); ?>`,
        "image":`<?php echo _("Image (single)"); ?>`,
        "video":`<?php echo _("Video"); ?>`,
        "link":`<?php echo _("Link (emded)"); ?>`,
        "link_ext":`<?php echo _("Link (external)"); ?>`,
        "pdf":`PDF`,
        "pointclouds":`<?php echo _("Point Clouds"); ?>`,
        "html":`<?php echo _("Text"); ?>`,
        "html_sc":`<?php echo _("Html"); ?>`,
        "download":`<?php echo _("Download"); ?>`,
        "form":`<?php echo _("Form"); ?>`,
        "video360":`<?php echo _("Video 360"); ?>`,
        "video_projects":`<?php echo _("Video Projects"); ?>`,
        "slideshow":`<?php echo _("Slideshow"); ?>`,
        "image_gallery":`<?php echo _("Images (gallery)"); ?>`,
        "audio":`<?php echo _("Audio"); ?>`,
        "google_maps":`<?php echo _("Map"); ?>`,
        "object360":`<?php echo _("Object 360 (images)"); ?>`,
        "object3d":`<?php echo _("Object 3D")." (GLB/GLTF)"; ?>`,
        "product":`<?php echo _("Product"); ?>`,
        "switch_pano":`<?php echo _("Switch Panorama"); ?>`,
        "staging":`<?php echo _("Virtual Staging"); ?>`,
        "callout":`<?php echo _("Callout Text"); ?>`,
        "embed_image":`<?php echo _("Embed (image)"); ?>`,
        "embed_gallery":`<?php echo _("Embed (slideshow)"); ?>`,
        "embed_video":`<?php echo _("Embed (video)"); ?>`,
        "embed_video_transparent":`<?php echo _("Embed (video with transparency)"); ?>`,
        "embed_video_chroma":`<?php echo _("Embed (video with background removal)"); ?>`,
        "embed_object3d":`<?php echo _("Embed (object3d)"); ?>`,
        "embed_link":`<?php echo _("Embed (link)"); ?>`,
        "embed_text":`<?php echo _("Embed (text)"); ?>`,
        "embed_html":`<?php echo _("Embed (html)"); ?>`,
        "embed_selection":`<?php echo _("Selection Area"); ?>`,
        "icon":`<?php echo _("Icon"); ?>`,
        "none":`<?php echo _("None"); ?>`,
        "grouped":`<?php echo _("Grouped"); ?>`,
        "multiple_poi":`<?php echo _("Multiple POIs"); ?>`,
        "loading":`<?php echo _("Loading"); ?>`,
        "sending":`<?php echo _("Sending"); ?>`,
        "waiting":`<?php echo _("Waiting"); ?>`,
        "processing":`<?php echo _("Processing"); ?>`,
        "processed":`<?php echo _("Processed"); ?>`,
        "error":`<?php echo _("Error"); ?>`,
        "delete_sure_msg":`<?php echo _("Are you sure you want to delete?"); ?>`,
        "import_sure_msg":`<?php echo _("Are you sure you want to import?"); ?>`,
        "duplicate_sure_msg":`<?php echo _("Are you sure you want to duplicate?"); ?>`,
        "assign_sure_msg":`<?php echo _("Are you sure you want to assign all?"); ?>`,
        "unassign_sure_msg":`<?php echo _("Are you sure you want to unassign all?"); ?>`,
        "file_size_too_big":`<?php echo _("File size is too big."); ?>`,
        "all":`<?php echo _("All"); ?>`,
        "all_categories":`<?php echo _("All Categories"); ?>`,
        "all_users":`<?php echo _("All Users"); ?>`,
        "export_vt":`<?php echo _("Download"); ?>`,
        "change_poi_style_msg":`<?php echo _("Are you sure? the contents of this element will be lost!"); ?>`,
        "color":`<?php echo _("Color"); ?>`,
        "border_color":`<?php echo _("Border Color"); ?>`,
        "rooms_list":`<?php echo _("Rooms List"); ?>`,
        "wizard_title_1":`<?php echo _("Creating a New Tour"); ?>`,
        "wizard_title_2":`<?php echo _("Creating the first Room"); ?>`,
        "wizard_title_3":`<?php echo _("Creating the second Room"); ?>`,
        "wizard_title_4":`<?php echo _("Creating a Marker"); ?>`,
        "wizard_title_6":`<?php echo _("Creating a POI"); ?>`,
        "wizard_title_5":`<?php echo _("Preview the tour"); ?>`,
        "wizard_text_1":`<?php echo _("Click on the menu item <b>Virtual Tours</b>"); ?>`,
        "wizard_text_2":`<?php echo _("Click on the menu item <b>List Tours</b>"); ?>`,
        "wizard_text_3":`<?php echo _("This is the section to create a tour"); ?>`,
        "wizard_text_4":`<?php echo _("Enter the <b>name</b> of the tour"); ?>`,
        "wizard_text_5":`<?php echo _("Click on button <b>Create</b>"); ?>`,
        "wizard_text_6":`<?php echo _("Click on the menu item <b>Rooms</b>"); ?>`,
        "wizard_text_7":`<?php echo _("Click on the <b>plus</b> icon"); ?>`,
        "wizard_text_8":`<?php echo _("Enter the <b>name</b> of the room"); ?>`,
        "wizard_text_9":`<?php echo _("Upload a 360 panorama image for this Room by selecting from the <b>Browse</b> button and then click <b>Upload</b>"); ?>`,
        "wizard_text_10":`<?php echo _("Click on button <b>Create</b>"); ?>`,
        "wizard_text_11":`<?php echo _("Congratulations, your first room has been created, now create the second one"); ?>`,
        "wizard_text_17":`<?php echo _("Congratulations, your second room has been created, now let's look at how to create a marker to navigate from one to the other"); ?>`,
        "wizard_text_18":`<?php echo _("Click on the menu item <b>Markers</b>"); ?>`,
        "wizard_text_19":`<?php echo _("Select the first room"); ?>`,
        "wizard_text_20":`<?php echo _("Drag the view and center the white cursor at the position where you want to add the marker"); ?>`,
        "wizard_text_22":`<?php echo _("Here you can select the destination room linked to this marker"); ?>`,
        "wizard_text_23":`<?php echo _("Click the button <b>Add</b> to create the marker"); ?>`,
        "wizard_text_24":`<?php echo _("Congratulations, your marker has been created, now let's look at how to create a POI (Point Of Interest) to show content on the tour"); ?>`,
        "wizard_text_26":`<?php echo _("Click on the menu item <b>POIs</b>"); ?>`,
        "wizard_text_27":`<?php echo _("Select the first room"); ?>`,
        "wizard_text_28":`<?php echo _("Drag the view and center the white cursor at the position where you want to add the POI"); ?>`,
        "wizard_text_29":`<?php echo _("Here you can select the style and content of your POI"); ?>`,
        "wizard_text_30":`<?php echo _("Let's create a simple POI icon with an image as content"); ?>`,
        "wizard_text_31":`<?php echo _("Upload an image for this Poi by selecting from the <b>Browse</b> button and then click <b>Upload</b>"); ?>`,
        "wizard_text_32":`<?php echo _("Click on button <b>Save</b>"); ?>`,
        "wizard_text_33":`<?php echo _("Congratulations, your POI has been created"); ?>`,
        "wizard_text_25":`<?php echo _("And finally let's preview the tour you just created. Click on the menu item <b>Preview</b>"); ?>`,
        "wizard_continue":`<?php echo _("Continue"); ?>`,
        "wizard_close":`<?php echo _("Are you sure you want to exit the tour creation wizard?"); ?>`,
        "confirm_save_preset":`<?php echo _("Are you sure you want to update the preset?"); ?>`,
        "confirm_delete_preset":`<?php echo _("Are you sure you want to delete the preset?"); ?>`,
        "confirm_delete_version":`<?php echo _("Are you sure you want to delete the version?"); ?>`,
        "confirm_apply_preset":`<?php echo _("Are you sure you want to apply the preset?"); ?>`,
        "markers_quick_add":`<?php echo _("QUICK ADD THIS MARKER"); ?>`,
        "markers_add":`<?php echo _("ADD THIS MARKER"); ?>`,
        "list":`<?php echo _("List"); ?>`,
        "grid":`<?php echo _("Grid"); ?>`,
        "generic_error_msg": `<?php echo _("An error has occurred."); ?>`,
        "copied":`<?php echo _("copied"); ?>`,
        "preview_presentation":`<?php echo _("preview from here"); ?>`,
        "no_panorams":`<?php echo _("preview from here"); ?>`,
        "main_view":`<?php echo _("Main View"); ?>`,
        "view":`<?php echo _("View"); ?>`,
        "start":`<?php echo _("START"); ?>`,
        "end":`<?php echo _("END"); ?>`,
        "set":`<?php echo _("SET"); ?>`,
        "lead_params_error":`<?php echo _("At least one lead field must be enabled and required."); ?>`,
        "api_key_replace_msg":`<?php echo _("Are you sure your want to replace existing API key?"); ?>`,
        "no_tour_msg":`<?php echo _("No tours created yet!"); ?>`,
        "no_tour_msg_wizard":`<?php echo sprintf(_('No tours created yet! Create one manually above or use the %s.'),'<a href=\'index.php?p=dashboard&wstep=0\'>'._("Wizard").'</a>'); ?>`,
        "translating":`<?php echo _("translation in progress"); ?>`,
        "remove":`<?php echo _("remove"); ?>`,
        "set_heading":`<?php echo _("set heading"); ?>`,
        "select_room":`<?php echo _("Select a room"); ?>`,
        "no_location":`<?php echo _("No Location"); ?>`,
        "logout_google_msg":`<?php echo _("Are you sure you want logout from your Google Account?"); ?>`,
        "cancel":`<?php echo _("Cancel"); ?>`,
        "choose":`<?php echo _("Choose"); ?>`,
        "dns_record_not_exists":`<?php echo _("DNS record not exist"); ?>`,
        "custom_domain_exist":`<?php echo _("The domain entered already exists, please enter another one."); ?>`,
        "custom_domain_approve_msg":`<?php echo _("Are you sure you want approve this custom domain?"); ?>`,
        "custom_domain_reject_msg":`<?php echo _("Are you sure you want reject this custom domain?"); ?>`,
        "custom_domain_delete_msg":`<?php echo _("Are you sure you want delete this custom domain?"); ?>`,
        "lock_msg":`<?php echo _("This tour is locked."); ?>`,
        "lock":`<?php echo _("LOCK"); ?>`,
        "unlock":`<?php echo _("UNLOCK"); ?>`,
        "last_visit_at":`<?php echo _("last visit date"); ?>`,
        "gsv_published":`<?php echo _("published to GSV"); ?>`,
        "gsv_published_link":`<?php echo _("published to GSV, click to view"); ?>`,
        "gsv_ready":`<?php echo _("ready to be published on GSV"); ?>`,
        "status_created":`<?php echo _("status and creation date"); ?>`,
        "initial_room":`<?php echo _("Set initial room"); ?>`,
        "bulk_editor_colors":`<?php echo _("Are you sure you want to apply these colors to all the items in the same position?"); ?>`,
        "start_drawing":`<?php echo _("Start Drawing"); ?>`,
        "end_drawing":`<?php echo _("End Drawing"); ?>`,
        "enable":`<?php echo _("Enable"); ?>`,
        "enabled":`<?php echo _("Enabled"); ?>`,
        "disable":`<?php echo _("Disable"); ?>`,
        "disabled":`<?php echo _("Disabled"); ?>`,
    };
    refresh_session();
</script>
<?php if($need_update) : ?>
    <div id="updating_msg" class="text-center mt-4">
        <h1 class="text-primary"><?php echo _("UPDATE IN PROGRESS"); ?>...</h1>
        <div class="spinner-border text-primary" role="status">
            <span class="sr-only"><?php echo _("Loading"); ?>...</span>
        </div>
        <p class="text-primary lead text-gray-800 mt-4"><?php echo _("Not close this window"); ?></p>
    </div>
    <script>
        $.ajax({
            url: "../services/pre_update.php",
            type: "POST",
            async: true,
            timeout: 120,
            success: function () {
                update_ajax();
            },
            error: function () {
                update_ajax();
            }
        });
        function update_ajax() {
            $.ajax({
                url: "ajax/update.php",
                type: "POST",
                data: {
                    version: '<?php echo $version_a; ?>'
                },
                async: true,
                timeout: 300000,
                success: function () {
                    $.ajax({
                        url: "ajax/download_sample.php",
                        type: "POST",
                        async: true,
                        success: function () {
                            location.reload();
                        },
                        timeout: 120,
                        error: function () {
                            location.reload();
                        }
                    });
                },
                error: function () {
                    alert('error');
                }
            });
        }
    </script>
    <?php
    exit;
endif;
?>
<div id="wrapper">
    <?php include_once("sidebar.php"); ?>
    <div id="content-wrapper" class="d-flex flex-column position-relative">
        <div id="vt_select"></div>
        <div id="content" class="noselect">
            <?php include_once("topbar.php"); ?>
            <div class="container-fluid">
                <?php
                if(($settings['stripe_enabled']) && !empty($user_info['id_subscription_stripe']) && ($user_info['status_subscription_stripe']==0)) {
                    include_once("update_payment.php");
                } else {
                    if(($settings['change_plan']) && ($user_info['id_plan']==0)) {
                        include_once("change_plan.php");
                    } else {
                        if(check_profile_to_complete($id_user)) {
                            include_once("edit_profile.php");
                        } else {
                            if($user_info['role']=='administrator' && (empty($settings['license']) || empty($settings['purchase_code']))) {
                                $_SESSION['input_license']=1;
                                include_once("settings.php");
                            } else {
                                include_once("check_concurrent_sessions.php");
                                include_once("check_quota.php");
                                include_once("$page.php");
                            }
                        }
                    }
                }
                ?>
            </div>
        </div>
        <?php include_once("footer.php"); ?>
    </div>
</div>
<a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
</a>
<script src="js/sb-admin-2.js?v=11"></script>
<?php if(!empty($settings['ga_tracking_id'])) : ?>
    <?php if($settings['cookie_consent']) { ?>
        <script type="text/plain" data-category="analytics" data-service="Google Analytics" async src="https://www.googletagmanager.com/gtag/js?id=<?php echo $settings['ga_tracking_id']; ?>"></script>
        <script type="text/plain" data-category="analytics" data-service="Google Analytics">
            window.dataLayer = window.dataLayer || [];
            function gtag(){dataLayer.push(arguments);}
            gtag('js', new Date());
            gtag('config', '<?php echo $settings['ga_tracking_id']; ?>', {
            'page_title': '<?php echo $page; ?>'
        });
        </script>
    <?php } else { ?>
        <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo $settings['ga_tracking_id']; ?>"></script>
        <script>
            window.dataLayer = window.dataLayer || [];
            function gtag(){dataLayer.push(arguments);}
            gtag('js', new Date());
            gtag('config', '<?php echo $settings['ga_tracking_id']; ?>', {
                'page_title': '<?php echo $page; ?>'
            });
        </script>
    <?php } ?>
<?php endif; ?>
<?php if(!empty($settings['tawkto_chat_link'])) : ?>
    <script type="text/javascript">
        var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
        Tawk_API.visitor = {
            name : `<?php echo $user_info['username']; ?>`,
            email : `<?php echo $user_info['email']; ?>`
        };
    </script>
    <?php if($settings['cookie_consent']) { ?>
    <script type="text/plain" data-category="functionality" data-service="Live Chat (Tawk.to)">
        (function(){
            var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
            s1.async=true;
            s1.src='<?php echo str_replace('https://tawk.to/chat/','https://embed.tawk.to/',$settings['tawkto_chat_link']) ?>';
            s1.charset='UTF-8';
            s1.setAttribute('crossorigin','*');
            s0.parentNode.insertBefore(s1,s0);
        })();
    </script>
<?php } else { ?>
    <script type="text/javascript">
        (function(){
            var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
            s1.async=true;
            s1.src='<?php echo str_replace('https://tawk.to/chat/','https://embed.tawk.to/',$settings['tawkto_chat_link']) ?>';
            s1.charset='UTF-8';
            s1.setAttribute('crossorigin','*');
            s0.parentNode.insertBefore(s1,s0);
        })();
    </script>
<?php } ?>
    <script>
        const observer = new MutationObserver(() => {
            const widget = document.querySelector(".widget-visible");
            const permanentContainer = document.getElementById("tawk-container");
            if (widget && permanentContainer) {
                permanentContainer.appendChild(widget);
                observer.disconnect();
                setTimeout(function() {
                    var bottom = $('#tawk-container iframe').css('bottom');
                    var right = $('#tawk-container iframe').css('right');
                    if(bottom=='20px' && right=='20px') {
                        $('.scroll-to-top').addClass('fix_pos_scroll');
                    }
                },250);
            }
        });
        observer.observe(document.body, { childList: true, subtree: true });
    </script>
    <div id="tawk-container"></div>
<?php endif; ?>
<div id="custom_b_html">
    <?php if(!empty($settings['custom_html'])) echo $settings['custom_html']; ?>
</div>
<div id="modal_preview_global" class="modal" tabindex="-1" role="dialog" data-backdrop="static">
    <div class="modal-dialog" style="width: 95% !important; max-width: 95% !important;" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo _("Preview"); ?></h5>
                <button onclick="close_preview_global_viewer();" type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div style="margin-bottom:-10px;" class="modal-body p-0"></div>
        </div>
    </div>
</div>
<?php if($settings['cookie_consent']) : ?>
    <?php require_once('cookie_consent.php'); ?>
<?php endif; ?>
<script>
    window.addEventListener('load', () => {
        if ('serviceWorker' in navigator) {
            navigator.serviceWorker.register('service-worker.js?v=<?php echo $version_a; ?>', {
                scope: '.'
            });
        }
    });
</script>
</body>
</html>