<?php
session_start();
require_once("functions.php");
$id_user = $_SESSION['id_user'];
$id_virtualtour_sel = $_SESSION['id_virtualtour_sel'];
$virtual_tour = get_virtual_tour($id_virtualtour_sel,$id_user);
$tmp_languages = get_languages_vt();
$array_languages = $tmp_languages[0];
$default_language = $tmp_languages[1];
if($virtual_tour!==false) {
    $can_create = get_plan_permission($id_user)['enable_forms'];
    $forms = true;
    if($user_info['role']=='editor') {
        $editor_permissions = get_editor_permissions($id_user,$id_virtualtour_sel);
        if($editor_permissions['forms']==0) {
            $forms = false;
        }
    }
    $form_content = $virtual_tour['form_content'];
    if(!empty($form_content)) {
        $form_content = json_decode($form_content,true);
    }
    $array_input_lang = array();
    $query_lang = "SELECT * FROM svt_virtualtours_lang WHERE id_virtualtour=$id_virtualtour_sel;";
    $result_lang = $mysqli->query($query_lang);
    if($result_lang) {
        if ($result_lang->num_rows > 0) {
            while($row_lang = $result_lang->fetch_array(MYSQLI_ASSOC)) {
                $language = $row_lang['language'];
                if(!empty($row_lang['form_content'])) {
                    $row_lang['form_content']=json_decode($row_lang['form_content'],true);
                    for($i=0;$i<=10;$i++) {
                        if($i==0) {
                            if($row_lang['form_content'][0]['title']==$form_content[0]['title']) {
                                $row_lang['form_content'][0]['title']="";
                            }
                            if($row_lang['form_content'][0]['button']==$form_content[0]['button']) {
                                $row_lang['form_content'][0]['button']="";
                            }
                            if($row_lang['form_content'][0]['response']==$form_content[0]['response']) {
                                $row_lang['form_content'][0]['response']="";
                            }
                            if($row_lang['form_content'][0]['description']==$form_content[0]['description']) {
                                $row_lang['form_content'][0]['description']="";
                            }
                        } else {
                            if($row_lang['form_content'][$i]['label']==$form_content[$i]['label']) {
                                $row_lang['form_content'][$i]['label']="";
                            }
                        }
                    }
                } else {
                    $row_lang['form_content']=array();
                }
                unset($row_lang['id_virtualtour']);
                unset($row_lang['language']);
                $array_input_lang[$language]=$row_lang;
            }
        }
    }
} else {
    $forms = false;
}
?>

<?php include("check_plan.php"); ?>

<?php include("check_block_tour.php"); ?>

<?php if(!$forms): ?>
    <div class="text-center">
        <div class="error mx-auto" data-text="401">401</div>
        <p class="lead text-gray-800 mb-5"><?php echo _("Permission denied"); ?></p>
        <p class="text-gray-500 mb-0"><?php echo _("It looks like that you do not have permission to access this page"); ?></p>
        <a href="index.php?p=dashboard">← <?php echo _("Back to Dashboard"); ?></a>
    </div>
<?php die(); endif; ?>

<?php if($virtual_tour['external']==1) : ?>
    <div class="card bg-warning text-white shadow mb-4">
        <div class="card-body">
            <?php echo _("You cannot manage Forms on an external virtual tour!"); ?>
        </div>
    </div>
<?php exit; endif; ?>

<?php if(!$can_create) : ?>
    <div class="card bg-warning text-white shadow mb-4">
        <div class="card-body">
            <?php echo sprintf(_('Your "%s" plan not allow to manage Forms!'),$user_info['plan'])." ".$msg_change_plan; ?>
        </div>
    </div>
<?php exit; endif; ?>

<div class="row">
    <div class="col-md-12">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex justify-content-between align-items-center">
                <h6 class="m-0 font-weight-bold text-primary d-flex align-items-center">
                    <i class="fas fa-file-signature mr-2"></i> <?php echo _("Main Form"); ?>
                </h6>
                <a id="save_btn" href="#" role="button" onclick="save_form();return false;" class="btn btn-sm btn-success btn-icon-split <?php echo (($demo) ? 'disabled' : ''); ?>" title="<?php echo ($demo ? _('Disabled in demo mode') : ''); ?>">
                    <span class="icon text-white-50"><i class="far fa-circle"></i></span>
                    <span class="text text-white"><?php echo _("SAVE"); ?></span>
                </a>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label  for="form_title"><?php echo _("Title"); ?></label><?php echo print_language_input_selector($array_languages,$default_language,'form_title'); ?>
                            <input id="form_title" type="text" class="form-control" value="<?php echo htmlspecialchars($form_content[0]['title']); ?>">
                            <?php foreach ($array_languages as $lang) {
                                if($lang!=$default_language) : ?>
                                    <input style="display:none;" type="text" class="form-control input_lang" data-target-id="form_title" data-lang="<?php echo $lang; ?>" value="<?php echo htmlspecialchars($array_input_lang[$lang]['form_content'][0]['title']); ?>" />
                                <?php endif;
                            } ?>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label  for="form_button"><?php echo _("Button send"); ?></label><?php echo print_language_input_selector($array_languages,$default_language,'form_button'); ?>
                            <input id="form_button" type="text" class="form-control" value="<?php echo htmlspecialchars($form_content[0]['button']); ?>">
                            <?php foreach ($array_languages as $lang) {
                                if($lang!=$default_language) : ?>
                                    <input style="display:none;" type="text" class="form-control input_lang" data-target-id="form_button" data-lang="<?php echo $lang; ?>" value="<?php echo htmlspecialchars($array_input_lang[$lang]['form_content'][0]['button']); ?>" />
                                <?php endif;
                            } ?>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label  for="form_response"><?php echo _("Reply message"); ?></label><?php echo print_language_input_selector($array_languages,$default_language,'form_response'); ?>
                            <input id="form_response" type="text" class="form-control" value="<?php echo htmlspecialchars($form_content[0]['response']); ?>">
                            <?php foreach ($array_languages as $lang) {
                                if($lang!=$default_language) : ?>
                                    <input style="display:none;" type="text" class="form-control input_lang" data-target-id="form_response" data-lang="<?php echo $lang; ?>" value="<?php echo htmlspecialchars($array_input_lang[$lang]['form_content'][0]['response']); ?>" />
                                <?php endif;
                            } ?>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label  for="form_description"><?php echo _("Description"); ?></label><?php echo print_language_input_selector($array_languages,$default_language,'form_description'); ?>
                            <input id="form_description" type="text" class="form-control" value="<?php echo htmlspecialchars($form_content[0]['description']); ?>">
                            <?php foreach ($array_languages as $lang) {
                                if($lang!=$default_language) : ?>
                                    <input style="display:none;" type="text" class="form-control input_lang" data-target-id="form_description" data-lang="<?php echo $lang; ?>" value="<?php echo htmlspecialchars($array_input_lang[$lang]['form_content'][0]['description']); ?>" />
                                <?php endif;
                            } ?>
                        </div>
                    </div>
                    <div class="col-md-2 <?php echo (empty($settings['privacy_policy'])) ? 'disabled':''; ?>">
                        <div class="form-group">
                            <label><?php echo _("Show Privacy Policy"); ?></label><br>
                            <input <?php echo ($form_content[0]['privacy_policy'])?'checked':''; ?> id="form_privacy_policy" type="checkbox">
                        </div>
                    </div>
                    <div class="col-md-2 <?php echo (!$settings['smtp_valid']) ? 'disabled':''; ?>">
                        <div class="form-group">
                            <label><?php echo _("Send Notification"); ?></label><br>
                            <input <?php echo ($form_content[0]['send_email'])?'checked':''; ?> id="form_send_email" type="checkbox">
                        </div>
                    </div>
                    <div class="col-md-4 <?php echo (!$settings['smtp_valid']) ? 'disabled':''; ?>">
                        <div class="form-group">
                            <label for="form_email"><?php echo _("E-Mail"); ?></label>
                            <input id="form_email" type="email" class="form-control" placeholder="<?php echo $virtual_tour['email']; ?>" value="<?php echo $form_content[0]['email']; ?>">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="form_webhook_url"><?php echo _("Webhook URL"); ?></label>
                            <input id="form_webhook_url" type="text" class="form-control" value="<?php echo $form_content[0]['webhook_url']; ?>">
                        </div>
                    </div>
                </div>
                <hr class="d-none" style="margin: 3px">
                <div class="row d-none">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?php echo _("Background Color"); ?></label>
                            <input id="form_background_m" type="text" class="form-control" value="<?php echo (isset($form_content[0]['background'])) ? $form_content[0]['background'] : 'rgba(255,255,255,1.0)'; ?>">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?php echo _("Text Color"); ?></label>
                            <input id="form_color_m" type="text" class="form-control" value="<?php echo (isset($form_content[0]['color'])) ? $form_content[0]['color'] : '#000000'; ?>">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?php echo _("Button - Background Color"); ?></label>
                            <input id="form_background_button" type="text" class="form-control" value="<?php echo (isset($form_content[0]['background_button'])) ? $form_content[0]['background_button'] : '#000000'; ?>">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?php echo _("Button - Text Color"); ?></label>
                            <input id="form_color_button" type="text" class="form-control" value="<?php echo (isset($form_content[0]['color_button'])) ? $form_content[0]['color_button'] : '#ffffff'; ?>">
                        </div>
                    </div>
                </div>
                <?php for($i=1;$i<=10;$i++) { ?>
                    <div id="field_div_<?php echo $i; ?>" style="border: 1px solid lightgray;border-radius: 5px;opacity: <?php echo ($form_content[$i]['enabled'])?1:0.6; ?>" class="row mb-3 py-2">
                        <div class="col-md-2">
                            <div class="form-group mb-0">
                                <label><b><?php echo _("Field")." ".$i; ?></b></label><br>
                                <input onchange="change_field_form_checkbox(<?php echo $i; ?>);" <?php echo ($form_content[$i]['enabled'])?'checked':''; ?> id="form_field_<?php echo $i; ?>" type="checkbox">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group mb-0">
                                <label><?php echo _("Required"); ?></label><br>
                                <input <?php echo ($form_content[$i]['required'])?'checked':''; ?> id="form_field_required_<?php echo $i; ?>" type="checkbox">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group mb-0">
                                <label><?php echo _("Type"); ?></label><br>
                                <select onchange="change_form_field_type(<?php echo $i; ?>);" id="form_field_type_<?php echo $i; ?>" class="form-control">
                                    <option <?php echo ($form_content[$i]['type']=='text')?'selected':''; ?> id="text" value="text"><?php echo _("Text"); ?></option>
                                    <option <?php echo ($form_content[$i]['type']=='textarea')?'selected':''; ?> id="textarea" value="textarea"><?php echo _("Text (multiple lines)"); ?></option>
                                    <option <?php echo ($form_content[$i]['type']=='number')?'selected':''; ?> id="number" value="number"><?php echo _("Number"); ?></option>
                                    <option <?php echo ($form_content[$i]['type']=='tel')?'selected':''; ?> id="tel" value="tel"><?php echo _("Phone"); ?></option>
                                    <option <?php echo ($form_content[$i]['type']=='email')?'selected':''; ?> id="email" value="email"><?php echo _("E-Mail"); ?></option>
                                    <option <?php echo ($form_content[$i]['type']=='select')?'selected':''; ?> id="select" value="select"><?php echo _("Select"); ?></option>
                                    <option <?php echo ($form_content[$i]['type']=='checkbox')?'selected':''; ?> id="checkbox" value="checkbox"><?php echo _("Checkbox"); ?></option>
                                    <option <?php echo ($form_content[$i]['type']=='date')?'selected':''; ?> id="date" value="date"><?php echo _("Date"); ?></option>
                                    <option <?php echo ($form_content[$i]['type']=='time')?'selected':''; ?> id="time" value="time"><?php echo _("Time"); ?></option>
                                    <option <?php echo ($form_content[$i]['type']=='file')?'selected':''; ?> id="file" value="time"><?php echo _("File Upload"); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group mb-0">
                                <label><?php echo _("Label"); ?></label><?php echo print_language_input_selector($array_languages,$default_language,'form_field_label_'.$i); ?><br>
                                <input id="form_field_label_<?php echo $i; ?>" type="text" class="form-control" value="<?php echo htmlspecialchars($form_content[$i]['label']); ?>">
                                <?php foreach ($array_languages as $lang) {
                                    if($lang!=$default_language) : ?>
                                        <input style="display:none;" type="text" class="form-control input_lang" data-target-id="form_field_label_<?php echo $i; ?>" data-lang="<?php echo $lang; ?>" value="<?php echo htmlspecialchars($array_input_lang[$lang]['form_content'][$i]['label']); ?>" />
                                    <?php endif;
                                } ?>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>

<script>
    (function($) {
        "use strict"; // Start of use strict
        window.id_user = '<?php echo $id_user; ?>';
        window.id_virtualtour = '<?php echo $id_virtualtour_sel; ?>';
        window.form_need_save = false;
        $(document).ready(function () {

        });

        $("input").change(function(){
            window.form_need_save = true;
        });

        $("textarea").change(function(){
            window.form_need_save = true;
        });

        $("select").change(function(){
            window.form_need_save = true;
        });

        $(window).on('beforeunload', function(){
            if(window.form_need_save) {
                var c=confirm();
                if(c) return true; else return false;
            }
        });
    })(jQuery); // End of use strict
</script>