<?php
session_start();
$id_user = $_SESSION['id_user'];
$id_virtualtour_sel = $_SESSION['id_virtualtour_sel'];
if(isset($_GET['version'])) {
    $id_version_sel = $_GET['version'];
} else {
    $id_version_sel = 0;
}
$edit_version = false;
$name_version_sel = "";
$settings = get_settings();
$plan_permissions = get_plan_permission($_SESSION['id_user']);
$virtual_tour = get_virtual_tour($id_virtualtour_sel,$_SESSION['id_user']);
if($virtual_tour!==false) {
    $vt_versions = get_virtual_tour_versions($id_virtualtour_sel);
    foreach ($vt_versions as $vt_version) {
        if($vt_version['id']==$id_version_sel) {
            $name_version_sel = $vt_version['version'];
            $edit_version = true;
            foreach ($vt_version as $key => $value) {
                if (array_key_exists($key, $virtual_tour)) {
                    $virtual_tour[$key] = $value;
                }
            }
        }
    }
    $tmp_languages = get_languages_vt();
    $array_languages = $tmp_languages[0];
    $default_language = $tmp_languages[1];
    $s3_params = check_s3_tour_enabled($id_virtualtour_sel);
    $s3_enabled = false;
    $s3_url = "";
    if(!empty($s3_params)) {
        $s3_bucket_name = $s3_params['bucket'];
        $s3_region = $s3_params['region'];
        $s3_url = init_s3_client($s3_params);
        if($s3_url!==false) {
            $s3_enabled = true;
        }        $s3_url = init_s3_client($s3_params);
        if($s3_url!==false) {
            $s3_enabled = true;
        }
    }
    $query_lang = "SELECT * FROM svt_virtualtours_lang WHERE id_virtualtour=$id_virtualtour_sel;";
    $result_lang = $mysqli->query($query_lang);
    if($result_lang) {
        if ($result_lang->num_rows > 0) {
            while($row_lang = $result_lang->fetch_array(MYSQLI_ASSOC)) {
                $url_avatar_video_l = "";
                $language = $row_lang['language'];
                $array_input_lang[$language]=$row_lang;
            }
        }
    }
    $rooms = array();
    $array_r = array();
    $query = "SELECT r.id,r.name,r.panorama_image FROM svt_rooms AS r 
                JOIN svt_virtualtours AS v ON v.id=r.id_virtualtour
                WHERE v.id = $id_virtualtour_sel
                ORDER BY r.priority ASC, r.id ASC";
    $result = $mysqli->query($query);
    if($result) {
        if($result->num_rows>0) {
            while($row=$result->fetch_array(MYSQLI_ASSOC)) {
                $rooms[]=$row;
                $array_r[$row['id']]=$row['name'];
            }
        }
    }
    if(count($rooms)>0) {
        $room1 = get_room($rooms[0]['id'],$_SESSION['id_user']);
    } else {
        $room1 = false;
    }
    if(!empty($room1)) {
        $room1_pano = $room1['panorama_image'];
        $room1_name = $room1['name'];
        if(empty($room1_pano)) {
            $room1_pano = "data:image/jpeg;base64,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";
        } else {
            if($s3_enabled) {
                $room1_pano = $s3_url."viewer/panoramas/preview/$room1_pano";
            } else {
                $room1_pano = "../viewer/panoramas/preview/$room1_pano";
            }
        }
    } else {
        $room1_pano = "data:image/jpeg;base64,/9j/4AAQSkZJRgABAQEBLAEsAAD/4iOISUNDX1BST0ZJTEUAAQEAACN4bGNtcwIQAABtbnRyUkdCIFhZWiAH3wALAAoADAASADhhY3NwKm5peAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA9tYAAQAAAADTLWxjbXMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAtkZXNjAAABCAAAALBjcHJ0AAABuAAAARJ3dHB0AAACzAAAABRjaGFkAAAC4AAAACxyWFlaAAADDAAAABRiWFlaAAADIAAAABRnWFlaAAADNAAAABRyVFJDAAADSAAAIAxnVFJDAAADSAAAIAxiVFJDAAADSAAAIAxjaHJtAAAjVAAAACRkZXNjAAAAAAAAABxzUkdCLWVsbGUtVjItc3JnYnRyYy5pY2MAAAAAAAAAAAAAAB0AcwBSAEcAQgAtAGUAbABsAGUALQBWADIALQBzAHIAZwBiAHQAcgBjAC4AaQBjAGMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHRleHQAAAAAQ29weXJpZ2h0IDIwMTUsIEVsbGUgU3RvbmUgKHdlYnNpdGU6IGh0dHA6Ly9uaW5lZGVncmVlc2JlbG93LmNvbS87IGVtYWlsOiBlbGxlc3RvbmVAbmluZWRlZ3JlZXNiZWxvdy5jb20pLiBUaGlzIElDQyBwcm9maWxlIGlzIGxpY2Vuc2VkIHVuZGVyIGEgQ3JlYXRpdmUgQ29tbW9ucyBBdHRyaWJ1dGlvbi1TaGFyZUFsaWtlIDMuMCBVbnBvcnRlZCBMaWNlbnNlIChodHRwczovL2NyZWF0aXZlY29tbW9ucy5vcmcvbGljZW5zZXMvYnktc2EvMy4wL2xlZ2FsY29kZSkuAAAAAFhZWiAAAAAAAAD21gABAAAAANMtc2YzMgAAAAAAAQxCAAAF3v//8yUAAAeTAAD9kP//+6H///2iAAAD3AAAwG5YWVogAAAAAAAAb6AAADj1AAADkFhZWiAAAAAAAAAknwAAD4QAALbEWFlaIAAAAAAAAGKXAAC3hwAAGNljdXJ2AAAAAAAAEAAAAAABAAIABAAFAAYABwAJAAoACwAMAA4ADwAQABEAEwAUABUAFgAYABkAGgAbABwAHgAfACAAIQAjACQAJQAmACgAKQAqACsALQAuAC8AMAAyADMANAA1ADcAOAA5ADoAOwA9AD4APwBAAEIAQwBEAEUARwBIAEkASgBMAE0ATgBPAFEAUgBTAFQAVQBXAFgAWQBaAFwAXQBeAF8AYQBiAGMAZABmAGcAaABpAGsAbABtAG4AbwBxAHIAcwB0AHYAdwB4AHkAewB8AH0AfgCAAIEAggCDAIUAhgCHAIgAiQCLAIwAjQCOAJAAkQCSAJMAlQCWAJcAmACaAJsAnACdAJ8AoAChAKIApAClAKYApwCoAKoAqwCsAK0ArwCwALEAsgC0ALUAtgC3ALkAugC7ALwAvgC/AMAAwQDCAMQAxQDGAMcAyQDKAMsAzADOAM8A0ADRANMA1ADVANcA2ADZANoA3ADdAN4A4ADhAOIA5ADlAOYA6ADpAOoA7ADtAO8A8ADxAPMA9AD2APcA+AD6APsA/QD+AP8BAQECAQQBBQEHAQgBCgELAQ0BDgEPAREBEgEUARUBFwEYARoBGwEdAR8BIAEiASMBJQEmASgBKQErAS0BLgEwATEBMwE0ATYBOAE5ATsBPAE+AUABQQFDAUUBRgFIAUoBSwFNAU8BUAFSAVQBVQFXAVkBWgFcAV4BYAFhAWMBZQFnAWgBagFsAW4BbwFxAXMBdQF2AXgBegF8AX4BfwGBAYMBhQGHAYkBigGMAY4BkAGSAZQBlgGXAZkBmwGdAZ8BoQGjAaUBpwGpAasBrAGuAbABsgG0AbYBuAG6AbwBvgHAAcIBxAHGAcgBygHMAc4B0AHSAdQB1gHYAdoB3AHeAeEB4wHlAecB6QHrAe0B7wHxAfMB9QH4AfoB/AH+AgACAgIEAgcCCQILAg0CDwISAhQCFgIYAhoCHQIfAiECIwIlAigCKgIsAi4CMQIzAjUCOAI6AjwCPgJBAkMCRQJIAkoCTAJPAlECUwJWAlgCWgJdAl8CYQJkAmYCaQJrAm0CcAJyAnUCdwJ5AnwCfgKBAoMChgKIAosCjQKQApIClQKXApoCnAKfAqECpAKmAqkCqwKuArACswK1ArgCuwK9AsACwgLFAsgCygLNAs8C0gLVAtcC2gLdAt8C4gLkAucC6gLsAu8C8gL1AvcC+gL9Av8DAgMFAwgDCgMNAxADEwMVAxgDGwMeAyADIwMmAykDLAMuAzEDNAM3AzoDPQM/A0IDRQNIA0sDTgNRA1QDVgNZA1wDXwNiA2UDaANrA24DcQN0A3cDegN9A4ADggOFA4gDiwOOA5EDlAOYA5sDngOhA6QDpwOqA60DsAOzA7YDuQO8A78DwgPFA8kDzAPPA9ID1QPYA9sD3wPiA+UD6APrA+4D8gP1A/gD+wP+BAIEBQQIBAsEDwQSBBUEGAQcBB8EIgQlBCkELAQvBDMENgQ5BD0EQARDBEcESgRNBFEEVARXBFsEXgRiBGUEaARsBG8EcwR2BHkEfQSABIQEhwSLBI4EkgSVBJkEnASgBKMEpwSqBK4EsQS1BLgEvAS/BMMExgTKBM4E0QTVBNgE3ATgBOME5wTqBO4E8gT1BPkE/QUABQQFCAULBQ8FEwUWBRoFHgUiBSUFKQUtBTEFNAU4BTwFQAVDBUcFSwVPBVIFVgVaBV4FYgVmBWkFbQVxBXUFeQV9BYEFhAWIBYwFkAWUBZgFnAWgBaQFqAWsBa8FswW3BbsFvwXDBccFywXPBdMF1wXbBd8F4wXnBesF7wX0BfgF/AYABgQGCAYMBhAGFAYYBhwGIQYlBikGLQYxBjUGOQY+BkIGRgZKBk4GUwZXBlsGXwZjBmgGbAZwBnQGeQZ9BoEGhQaKBo4GkgaXBpsGnwakBqgGrAaxBrUGuQa+BsIGxgbLBs8G1AbYBtwG4QblBuoG7gbyBvcG+wcABwQHCQcNBxIHFgcbBx8HJAcoBy0HMQc2BzoHPwdDB0gHTQdRB1YHWgdfB2MHaAdtB3EHdgd7B38HhAeJB40HkgeXB5sHoAelB6kHrgezB7cHvAfBB8YHygfPB9QH2QfdB+IH5wfsB/EH9Qf6B/8IBAgJCA0IEggXCBwIIQgmCCsILwg0CDkIPghDCEgITQhSCFcIXAhhCGYIawhwCHUIegh/CIQIiQiOCJMImAidCKIIpwisCLEItgi7CMAIxQjKCM8I1AjZCN8I5AjpCO4I8wj4CP0JAwkICQ0JEgkXCR0JIgknCSwJMQk3CTwJQQlGCUwJUQlWCVsJYQlmCWsJcQl2CXsJgQmGCYsJkQmWCZsJoQmmCasJsQm2CbwJwQnGCcwJ0QnXCdwJ4gnnCe0J8gn4Cf0KAgoICg0KEwoZCh4KJAopCi8KNAo6Cj8KRQpKClAKVgpbCmEKZgpsCnIKdwp9CoMKiAqOCpQKmQqfCqUKqgqwCrYKvArBCscKzQrTCtgK3grkCuoK7wr1CvsLAQsHCwwLEgsYCx4LJAsqCy8LNQs7C0ELRwtNC1MLWQtfC2QLagtwC3YLfAuCC4gLjguUC5oLoAumC6wLsgu4C74LxAvKC9AL1gvcC+IL6QvvC/UL+wwBDAcMDQwTDBkMIAwmDCwMMgw4DD4MRQxLDFEMVwxdDGQMagxwDHYMfQyDDIkMjwyWDJwMogyoDK8MtQy7DMIMyAzODNUM2wzhDOgM7gz1DPsNAQ0IDQ4NFQ0bDSENKA0uDTUNOw1CDUgNTw1VDVwNYg1pDW8Ndg18DYMNiQ2QDZYNnQ2kDaoNsQ23Db4NxQ3LDdIN2Q3fDeYN7A3zDfoOAQ4HDg4OFQ4bDiIOKQ4vDjYOPQ5EDkoOUQ5YDl8OZg5sDnMOeg6BDogOjg6VDpwOow6qDrEOuA6+DsUOzA7TDtoO4Q7oDu8O9g79DwQPCw8SDxkPIA8nDy4PNQ88D0MPSg9RD1gPXw9mD20PdA97D4IPiQ+QD5gPnw+mD60PtA+7D8IPyg/RD9gP3w/mD+0P9Q/8EAMQChASEBkQIBAnEC8QNhA9EEQQTBBTEFoQYhBpEHAQeBB/EIYQjhCVEJ0QpBCrELMQuhDCEMkQ0BDYEN8Q5xDuEPYQ/REFEQwRFBEbESMRKhEyETkRQRFIEVARVxFfEWcRbhF2EX0RhRGNEZQRnBGkEasRsxG7EcIRyhHSEdkR4RHpEfAR+BIAEggSDxIXEh8SJxIuEjYSPhJGEk4SVRJdEmUSbRJ1En0ShBKMEpQSnBKkEqwStBK8EsQSzBLUEtsS4xLrEvMS+xMDEwsTExMbEyMTKxMzEzsTRBNME1QTXBNkE2wTdBN8E4QTjBOUE50TpROtE7UTvRPFE80T1hPeE+YT7hP2E/8UBxQPFBcUIBQoFDAUOBRBFEkUURRaFGIUahRzFHsUgxSMFJQUnBSlFK0UthS+FMYUzxTXFOAU6BTxFPkVARUKFRIVGxUjFSwVNBU9FUUVThVXFV8VaBVwFXkVgRWKFZMVmxWkFawVtRW+FcYVzxXYFeAV6RXyFfoWAxYMFhQWHRYmFi8WNxZAFkkWUhZaFmMWbBZ1Fn4WhhaPFpgWoRaqFrMWuxbEFs0W1hbfFugW8Rb6FwMXDBcUFx0XJhcvFzgXQRdKF1MXXBdlF24XdxeAF4kXkhecF6UXrhe3F8AXyRfSF9sX5BftF/cYABgJGBIYGxgkGC4YNxhAGEkYUhhcGGUYbhh3GIEYihiTGJwYphivGLgYwhjLGNQY3hjnGPAY+hkDGQwZFhkfGSkZMhk7GUUZThlYGWEZaxl0GX4ZhxmRGZoZpBmtGbcZwBnKGdMZ3RnmGfAZ+hoDGg0aFhogGioaMxo9GkYaUBpaGmMabRp3GoEaihqUGp4apxqxGrsaxRrOGtga4hrsGvUa/xsJGxMbHRsnGzAbOhtEG04bWBtiG2wbdRt/G4kbkxudG6cbsRu7G8UbzxvZG+Mb7Rv3HAEcCxwVHB8cKRwzHD0cRxxRHFscZRxwHHochByOHJgcohysHLYcwRzLHNUc3xzpHPQc/h0IHRIdHB0nHTEdOx1FHVAdWh1kHW8deR2DHY4dmB2iHa0dtx3BHcwd1h3hHesd9R4AHgoeFR4fHioeNB4+HkkeUx5eHmgecx59Hogekx6dHqgesh69Hsce0h7cHuce8h78HwcfEh8cHycfMh88H0cfUh9cH2cfch98H4cfkh+dH6cfsh+9H8gf0h/dH+gf8x/+IAggEyAeICkgNCA/IEogVCBfIGogdSCAIIsgliChIKwgtyDCIM0g2CDjIO4g+SEEIQ8hGiElITAhOyFGIVEhXCFnIXIhfiGJIZQhnyGqIbUhwCHMIdch4iHtIfgiBCIPIhoiJSIwIjwiRyJSIl4iaSJ0In8iiyKWIqEirSK4IsMizyLaIuYi8SL8IwgjEyMfIyojNSNBI0wjWCNjI28jeiOGI5EjnSOoI7QjvyPLI9Yj4iPuI/kkBSQQJBwkKCQzJD8kSyRWJGIkbiR5JIUkkSScJKgktCS/JMsk1yTjJO4k+iUGJRIlHiUpJTUlQSVNJVklZSVwJXwliCWUJaAlrCW4JcQl0CXcJecl8yX/JgsmFyYjJi8mOyZHJlMmXyZrJncmhCaQJpwmqCa0JsAmzCbYJuQm8Cb9JwknFSchJy0nOSdGJ1InXidqJ3YngyePJ5snpye0J8AnzCfZJ+Un8Sf9KAooFigjKC8oOyhIKFQoYChtKHkohiiSKJ4oqyi3KMQo0CjdKOko9ikCKQ8pGykoKTQpQSlNKVopZylzKYApjCmZKaYpsim/Kcwp2CnlKfEp/ioLKhgqJCoxKj4qSipXKmQqcSp9KooqlyqkKrEqvSrKKtcq5CrxKv4rCisXKyQrMSs+K0srWCtlK3IrfyuMK5krpSuyK78rzCvZK+Yr8ywBLA4sGywoLDUsQixPLFwsaSx2LIMskCyeLKssuCzFLNIs3yztLPotBy0ULSEtLy08LUktVi1kLXEtfi2LLZktpi2zLcEtzi3bLekt9i4ELhEuHi4sLjkuRy5ULmEuby58Loouly6lLrIuwC7NLtsu6C72LwMvES8eLywvOi9HL1UvYi9wL34viy+ZL6cvtC/CL9Av3S/rL/kwBjAUMCIwLzA9MEswWTBnMHQwgjCQMJ4wrDC5MMcw1TDjMPEw/zENMRoxKDE2MUQxUjFgMW4xfDGKMZgxpjG0McIx0DHeMewx+jIIMhYyJDIyMkAyTjJcMmoyeTKHMpUyozKxMr8yzTLcMuoy+DMGMxQzIzMxMz8zTTNcM2ozeDOGM5UzozOxM8AzzjPcM+sz+TQHNBY0JDQzNEE0TzReNGw0ezSJNJg0pjS1NMM00jTgNO80/TUMNRo1KTU3NUY1VDVjNXI1gDWPNZ01rDW7Nck12DXnNfU2BDYTNiE2MDY/Nk42XDZrNno2iTaXNqY2tTbENtM24TbwNv83DjcdNyw3OzdJN1g3Zzd2N4U3lDejN7I3wTfQN9837jf9OAw4GzgqODk4SDhXOGY4dTiEOJM4ojixOME40DjfOO44/TkMORs5Kzk6OUk5WDlnOXc5hjmVOaQ5tDnDOdI54TnxOgA6DzofOi46PTpNOlw6azp7Ooo6mjqpOrg6yDrXOuc69jsGOxU7JTs0O0Q7UztjO3I7gjuRO6E7sDvAO9A73zvvO/48DjwePC08PTxNPFw8bDx8PIs8mzyrPLo8yjzaPOo8+T0JPRk9KT05PUg9WD1oPXg9iD2YPac9tz3HPdc95z33Pgc+Fz4nPjc+Rz5XPmc+dz6HPpc+pz63Psc+1z7nPvc/Bz8XPyc/Nz9HP1c/Zz94P4g/mD+oP7g/yD/ZP+k/+UAJQBlAKkA6QEpAWkBrQHtAi0CcQKxAvEDNQN1A7UD+QQ5BHkEvQT9BT0FgQXBBgUGRQaJBskHDQdNB5EH0QgVCFUImQjZCR0JXQmhCeEKJQppCqkK7QstC3ELtQv1DDkMfQy9DQENRQ2FDckODQ5RDpEO1Q8ZD10PnQ/hECUQaRCtEO0RMRF1EbkR/RJBEoUSyRMJE00TkRPVFBkUXRShFOUVKRVtFbEV9RY5Fn0WwRcFF0kXjRfRGBUYXRihGOUZKRltGbEZ9Ro9GoEaxRsJG00bkRvZHB0cYRylHO0dMR11HbkeAR5FHoke0R8VH1kfoR/lICkgcSC1IP0hQSGFIc0iESJZIp0i5SMpI3EjtSP9JEEkiSTNJRUlWSWhJekmLSZ1JrknASdJJ40n1SgZKGEoqSjtKTUpfSnFKgkqUSqZKt0rJSttK7Ur/SxBLIks0S0ZLWEtpS3tLjUufS7FLw0vVS+dL+UwKTBxMLkxATFJMZEx2TIhMmkysTL5M0EziTPRNBk0ZTStNPU1PTWFNc02FTZdNqU28Tc5N4E3yTgROF04pTjtOTU5fTnJOhE6WTqlOu07NTt9O8k8ETxZPKU87T05PYE9yT4VPl0+qT7xPzk/hT/NQBlAYUCtQPVBQUGJQdVCHUJpQrVC/UNJQ5FD3UQlRHFEvUUFRVFFnUXlRjFGfUbFRxFHXUelR/FIPUiJSNFJHUlpSbVKAUpJSpVK4UstS3lLxUwRTFlMpUzxTT1NiU3VTiFObU65TwVPUU+dT+lQNVCBUM1RGVFlUbFR/VJJUpVS4VMtU3lTyVQVVGFUrVT5VUVVlVXhVi1WeVbFVxVXYVetV/lYSViVWOFZLVl9WclaFVplWrFa/VtNW5lb6Vw1XIFc0V0dXW1duV4JXlVepV7xX0FfjV/dYClgeWDFYRVhYWGxYgFiTWKdYuljOWOJY9VkJWR1ZMFlEWVhZa1l/WZNZp1m6Wc5Z4ln2WglaHVoxWkVaWVpsWoBalFqoWrxa0FrkWvhbC1sfWzNbR1tbW29bg1uXW6tbv1vTW+db+1wPXCNcN1xLXGBcdFyIXJxcsFzEXNhc7F0BXRVdKV09XVFdZV16XY5dol22Xctd313zXgheHF4wXkReWV5tXoJell6qXr9e017nXvxfEF8lXzlfTl9iX3dfi1+gX7RfyV/dX/JgBmAbYC9gRGBYYG1ggmCWYKtgv2DUYOlg/WESYSdhO2FQYWVhemGOYaNhuGHNYeFh9mILYiBiNWJJYl5ic2KIYp1ismLHYtti8GMFYxpjL2NEY1ljbmODY5hjrWPCY9dj7GQBZBZkK2RAZFVkamR/ZJVkqmS/ZNRk6WT+ZRNlKWU+ZVNlaGV9ZZNlqGW9ZdJl6GX9ZhJmJ2Y9ZlJmZ2Z9ZpJmp2a9ZtJm6Gb9ZxJnKGc9Z1NnaGd+Z5NnqWe+Z9Rn6Wf/aBRoKmg/aFVoamiAaJZoq2jBaNZo7GkCaRdpLWlDaVhpbmmEaZlpr2nFadtp8GoGahxqMmpIal1qc2qJap9qtWrKauBq9msMayJrOGtOa2RremuQa6ZrvGvSa+hr/mwUbCpsQGxWbGxsgmyYbK5sxGzabPBtBm0cbTNtSW1fbXVti22hbbhtzm3kbfpuEW4nbj1uU25qboBulm6tbsNu2W7wbwZvHG8zb0lvYG92b4xvo2+5b9Bv5m/9cBNwKnBAcFdwbXCEcJpwsXDHcN5w9HELcSJxOHFPcWZxfHGTcapxwHHXce5yBHIbcjJySHJfcnZyjXKkcrpy0XLocv9zFnMsc0NzWnNxc4hzn3O2c81z5HP6dBF0KHQ/dFZ0bXSEdJt0snTJdOB093UOdSZ1PXVUdWt1gnWZdbB1x3XedfZ2DXYkdjt2UnZqdoF2mHavdsd23nb1dwx3JHc7d1J3aneBd5h3sHfHd9539ngNeCV4PHhUeGt4gniaeLF4yXjgePh5D3kneT55VnlueYV5nXm0ecx543n7ehN6KnpCelp6cXqJeqF6uHrQeuh7AHsXey97R3tfe3Z7jnume7571nvufAV8HXw1fE18ZXx9fJV8rXzFfNx89H0MfSR9PH1UfWx9hH2cfbR9zX3lff1+FX4tfkV+XX51fo1+pX6+ftZ+7n8Gfx5/N39Pf2d/f3+Xf7B/yH/gf/mAEYApgEGAWoBygIqAo4C7gNSA7IEEgR2BNYFOgWaBf4GXgbCByIHhgfmCEoIqgkOCW4J0goyCpYK+gtaC74MHgyCDOYNRg2qDg4Obg7SDzYPlg/6EF4QwhEiEYYR6hJOErITEhN2E9oUPhSiFQYVahXKFi4Wkhb2F1oXvhgiGIYY6hlOGbIaFhp6Gt4bQhumHAocbhzSHTYdnh4CHmYeyh8uH5If9iBeIMIhJiGKIe4iViK6Ix4jgiPqJE4ksiUaJX4l4iZGJq4nEid6J94oQiiqKQ4pdinaKj4qpisKK3Ir1iw+LKItCi1uLdYuOi6iLwovbi/WMDowojEKMW4x1jI+MqIzCjNyM9Y0PjSmNQo1cjXaNkI2pjcON3Y33jhGOK45Ejl6OeI6SjqyOxo7gjvqPE48tj0ePYY97j5WPr4/Jj+OP/ZAXkDGQS5BlkH+QmpC0kM6Q6JECkRyRNpFQkWuRhZGfkbmR05HukgiSIpI8kleScZKLkqaSwJLakvSTD5Mpk0STXpN4k5OTrZPIk+KT/JQXlDGUTJRmlIGUm5S2lNCU65UFlSCVO5VVlXCVipWllcCV2pX1lg+WKpZFll+WepaVlrCWypbllwCXG5c1l1CXa5eGl6GXu5fWl/GYDJgnmEKYXZh3mJKYrZjImOOY/pkZmTSZT5lqmYWZoJm7mdaZ8ZoMmieaQppemnmalJqvmsqa5ZsAmxybN5tSm22biJukm7+b2pv1nBGcLJxHnGOcfpyZnLWc0JzrnQedIp09nVmddJ2Qnaudxp3inf2eGZ40nlCea56HnqKevp7anvWfEZ8sn0ifY59/n5uftp/Sn+6gCaAloEGgXKB4oJSgsKDLoOehA6EfoTqhVqFyoY6hqqHGoeGh/aIZojWiUaJtoomipaLBot2i+aMVozGjTaNpo4WjoaO9o9mj9aQRpC2kSaRlpIGknqS6pNak8qUOpSqlR6VjpX+lm6W4pdSl8KYMpimmRaZhpn6mmqa2ptOm76cLpyinRKdgp32nmae2p9Kn76gLqCioRKhhqH2omqi2qNOo76kMqSmpRaliqX6pm6m4qdSp8aoOqiqqR6pkqoCqnaq6qteq86sQqy2rSqtnq4OroKu9q9qr96wUrDCsTaxqrIespKzBrN6s+60YrTWtUq1vrYytqa3GreOuAK4drjquV650rpKur67MrumvBq8jr0CvXq97r5ivta/Tr/CwDbAqsEiwZbCCsJ+wvbDasPexFbEysVCxbbGKsaixxbHjsgCyHrI7slmydrKUsrGyz7LsswqzJ7NFs2KzgLOes7uz2bP2tBS0MrRPtG20i7SotMa05LUCtR+1PbVbtXm1lrW0tdK18LYOtiy2SbZntoW2o7bBtt+2/bcbtzm3V7d1t5O3sbfPt+24C7gpuEe4ZbiDuKG4v7jduPu5Gbk4uVa5dLmSubC5zrntugu6KbpHuma6hLqiusC637r9uxu7OrtYu3a7lbuzu9G78LwOvC28S7xqvIi8przFvOO9Ar0gvT+9Xb18vZu9ub3Yvfa+Fb4zvlK+cb6Pvq6+zb7rvwq/Kb9Hv2a/hb+kv8K/4cAAwB/APsBcwHvAmsC5wNjA98EVwTTBU8FywZHBsMHPwe7CDcIswkvCasKJwqjCx8LmwwXDJMNDw2LDgcOgw8DD38P+xB3EPMRbxHvEmsS5xNjE98UXxTbFVcV1xZTFs8XSxfLGEcYwxlDGb8aPxq7GzcbtxwzHLMdLx2vHiseqx8nH6cgIyCjIR8hnyIbIpsjFyOXJBckkyUTJZMmDyaPJw8niygLKIspBymHKgcqhysDK4MsAyyDLQMtfy3/Ln8u/y9/L/8wfzD/MXsx+zJ7MvszezP7NHs0+zV7Nfs2ezb7N3s3+zh/OP85fzn/On86/zt/O/88gz0DPYM+Az6DPwc/h0AHQIdBC0GLQgtCi0MPQ49ED0STRRNFl0YXRpdHG0ebSB9In0kfSaNKI0qnSydLq0wrTK9NM02zTjdOt087T7tQP1DDUUNRx1JLUstTT1PTVFNU11VbVd9WX1bjV2dX61hrWO9Zc1n3Wnta/1t/XANch10LXY9eE16XXxtfn2AjYKdhK2GvYjNit2M7Y79kQ2THZUtlz2ZTZtdnW2fjaGdo62lvafNqe2r/a4NsB2yLbRNtl24bbqNvJ2+rcC9wt3E7cb9yR3LLc1Nz13RbdON1Z3XvdnN2+3d/eAd4i3kTeZd6H3qjeyt7s3w3fL99Q33LflN+139ff+eAa4DzgXuB/4KHgw+Dl4QbhKOFK4WzhjeGv4dHh8+IV4jfiWeJ64pzivuLg4wLjJONG42jjiuOs487j8OQS5DTkVuR45JrkvOTe5QHlI+VF5WflieWr5c3l8OYS5jTmVuZ55pvmvebf5wLnJOdG52nni+et59Dn8ugU6DfoWeh76J7owOjj6QXpKOlK6W3pj+my6dTp9+oZ6jzqXuqB6qTqxurp6wvrLutR63Prluu569zr/uwh7ETsZuyJ7Kzsz+zy7RTtN+1a7X3toO3D7eXuCO4r7k7uce6U7rfu2u797yDvQ+9m74nvrO/P7/LwFfA48FvwfvCh8MXw6PEL8S7xUfF08Zjxu/He8gHyJPJI8mvyjvKx8tXy+PMb8z/zYvOF86nzzPPw9BP0NvRa9H30ofTE9Oj1C/Uv9VL1dvWZ9b314PYE9if2S/Zv9pL2tvbZ9v33IfdE92j3jPew99P39/gb+D74YviG+Kr4zvjx+RX5Ofld+YH5pfnJ+ez6EPo0+lj6fPqg+sT66PsM+zD7VPt4+5z7wPvk/Aj8LPxQ/HX8mfy9/OH9Bf0p/U39cv2W/br93v4C/if+S/5v/pT+uP7c/wD/Jf9J/23/kv+2/9v//2Nocm0AAAAAAAMAAAAAo9cAAFR8AABMzQAAmZoAACZnAAAPXP/bAEMABQMEBAQDBQQEBAUFBQYHDAgHBwcHDwsLCQwRDxISEQ8RERMWHBcTFBoVEREYIRgaHR0fHx8TFyIkIh4kHB4fHv/bAEMBBQUFBwYHDggIDh4UERQeHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHv/CABEIAGQAogMBIgACEQEDEQH/xAAaAAEBAQEBAQEAAAAAAAAAAAAABAMCAQUH/8QAFAEBAAAAAAAAAAAAAAAAAAAAAP/aAAwDAQACEAMQAAAB/VwAAAAAAAAAAAAAAAAAAAAAAAAPPcTJPSaEhd3FaAAAAAAAMdsSL6fzKCuPWQ1titAAAAAAAAOXQ5dDz0AAAAAAAAAAAAAAAAAAAAAAAAAAP//EAB8QAAEEAQUBAAAAAAAAAAAAAAEAAgMRMhATMEBgIf/aAAgBAQABBQLzZNB0htshvcatxqa4HoTYJkfwxtThRhz55sNZsoc+ebBMkpGQImzDn0KCoKgqHnv/xAAUEQEAAAAAAAAAAAAAAAAAAABg/9oACAEDAQE/ARv/xAAUEQEAAAAAAAAAAAAAAAAAAABg/9oACAECAQE/ARv/xAAcEAABBAMBAAAAAAAAAAAAAAAAAREhMRBAYFD/2gAIAQEABj8C5t1IomsxpOuG8hlIH0qQpCkKTnv/xAAkEAACAAUDBAMAAAAAAAAAAAAAARARMUCxQWDxIWGBkVFxof/aAAgBAQABPyHbatAJrOvAqleB3X6O6/Q3k1hkgp/hGF0Uhk4YLDJBQpfRgsMkJTR+RNVNjmNUwWPHHHHHHHCSVElt3//aAAwDAQACAAMAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAE4IAAAAAAAAgUoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//EABQRAQAAAAAAAAAAAAAAAAAAAGD/2gAIAQMBAT8QG//EABQRAQAAAAAAAAAAAAAAAAAAAGD/2gAIAQIBAT8QG//EACQQAQACAQIGAgMAAAAAAAAAAAEAETEh8RBAQVFhcWCxkaHB/9oACAEBAAE/EPjaZKE9Ei4o/MVG9JvSIrCF0lchl9OAAVvU8JVrfcYryn7n3eQz+kKsvFyiCY6cK6ec/wAz7v8AOQFvwOFGCjAyTTjyiiIjah1PZ8ggiII9GbYm2JtCbYl/rnYr47//2Q==";
        $room1_name = _("Room name")." 1";
    }
    if(count($rooms)>1) {
        $room2 = $rooms[1];
    } else {
        $room2 = false;
    }
    if(!empty($room2)) {
        $room2_pano = $room2['panorama_image'];
        $room2_name = $room2['name'];
        if(empty($room2_pano)) {
            $room2_pano = "data:image/jpeg;base64,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";
        } else {
            if($s3_enabled) {
                $room2_pano = $s3_url."viewer/panoramas/preview/$room2_pano";
            } else {
                $room2_pano = "../viewer/panoramas/preview/$room2_pano";
            }
        }
    } else {
        $room2_pano = "data:image/jpeg;base64,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";
        $room2_name = _("Room name")." 2";
    }
    if(count($rooms)>1) {
        $room3 = $rooms[2];
    } else {
        $room3 = false;
    }
    if(!empty($room3)) {
        $room3_pano = $room3['panorama_image'];
        $room3_name = $room3['name'];
        if(empty($room3_pano)) {
            $room3_pano = "data:image/jpeg;base64,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";
        } else {
            if($s3_enabled) {
                $room3_pano = $s3_url."viewer/panoramas/preview/$room3_pano";
            } else {
                $room3_pano = "../viewer/panoramas/preview/$room3_pano";
            }
        }
    } else {
        $room3_pano = "data:image/jpeg;base64,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";
        $room3_name = _("Room name")." 3";
    }
    $can_create = get_plan_permission($id_user)['enable_editor_ui'];
    if($user_info['role']=='editor') {
        $editor_permissions = get_editor_permissions($_SESSION['id_user'],$id_virtualtour_sel);
        if($editor_permissions['edit_virtualtour_ui']==0) {
            $virtual_tour=false;
        }
    }
    $icons_library = $plan_permissions['enable_icons_library'];
    if($user_info['role']=='editor') {
        $editor_permissions = get_editor_permissions($_SESSION['id_user'],$id_virtualtour_sel);
        if($editor_permissions['icons_library']==0) {
            $icons_library = 0;
        }
    }
    $markers_image_icon_library = "";
    if(!empty($virtual_tour['markers_image_icon_library'])) {
        if($s3_enabled) {
            $markers_image_icon_library = $s3_url."viewer/icons/".$virtual_tour['markers_image_icon_library'];
        } else {
            $markers_image_icon_library = "../viewer/icons/".$virtual_tour['markers_image_icon_library'];
        }
    }
    $pois_image_icon_library = "";
    if(!empty($virtual_tour['pois_image_icon_library'])) {
        if($s3_enabled) {
            $pois_image_icon_library = $s3_url."viewer/icons/".$virtual_tour['pois_image_icon_library'];
        } else {
            $pois_image_icon_library = "../viewer/icons/".$virtual_tour['pois_image_icon_library'];
        }
    }
    $logo = $virtual_tour['logo'];
    if(empty($logo)) {
        $logo = "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyMDAgNjAiIGNsYXNzPSJpbWctZmx1aWQgcm91bmRlZCBteC1hdXRvIGQtYmxvY2siIHdpZHRoPSIyMDAiIGhlaWdodD0iNjAiPgogICAgICAgICAgICAgICAgICAgIDxyZWN0IHdpZHRoPSIyMDAiIGhlaWdodD0iNjAiIGZpbGw9IiM0NDQ0NDQiPjwvcmVjdD4KICAgICAgICAgICAgICAgICAgICA8dGV4dCB4PSI1MCUiIHk9IjUwJSIgZG9taW5hbnQtYmFzZWxpbmU9Im1pZGRsZSIgdGV4dC1hbmNob3I9Im1pZGRsZSIgZm9udC1mYW1pbHk9Im1vbm9zcGFjZSIgZm9udC1zaXplPSIyNnB4IiBmaWxsPSIjZmZmZmZmIj5MT0dPPC90ZXh0PiAgIAogICAgICAgICAgICAgICAgPC9zdmc+CiAgICAgICAgICAgICAgICA8IS0tPGEgZG93bmxvYWQ9IkZJTEVOQU1FLnBuZyIgaHJlZj0iZGF0YTppbWFnZS9wbmc7YmFzZTY0LGFzZGFzZC4uLiI+RG93bmxvYWQ8L2E+LS0+";
    } else {
        if($s3_enabled) {
            $logo = $s3_url."viewer/content/$logo";
        } else {
            $logo = "../viewer/content/$logo";
        }
    }
    $poweredby_image = $virtual_tour['poweredby_image'];
    $poweredby_text = $virtual_tour['poweredby_text'];
    if(empty($poweredby_text)) {
        $poweredby_text = _("Powered By");
    }
    if(empty($poweredby_image)) {
        $poweredby_image = "data:image/png;base64,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";
    } else {
        if($s3_enabled) {
            $poweredby_image = $s3_url."viewer/content/$poweredby_image";
        } else {
            $poweredby_image = "../viewer/content/$poweredby_image";
        }
    }
    $avatar_video = $virtual_tour['avatar_video'];
    if(empty($avatar_video)) {
        $avatar_video = $room1['avatar_video'];
    }
    $avatar_video_image = "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyMTYgMzg0Ij4KICA8cmVjdCB3aWR0aD0iMjE2IiBoZWlnaHQ9IjM4NCIgZmlsbD0iI0FFQUVBRUZGIj48L3JlY3Q+CiAgPHRleHQgeD0iNTAlIiB5PSI1MCUiIGRvbWluYW50LWJhc2VsaW5lPSJtaWRkbGUiIHRleHQtYW5jaG9yPSJtaWRkbGUiIGZvbnQtZmFtaWx5PSJtb25vc3BhY2UiIGZvbnQtc2l6ZT0iMThweCIgZmlsbD0iI0ZGRkZGRkZGIj5BVkFUQVIgVklERU88L3RleHQ+ICAgCjwvc3ZnPg==";
    $url_media_file = "";
    $media_file = $virtual_tour['media_file'];
    if(!empty($media_file)) {
        if($s3_enabled) {
            $url_media_file = $s3_url."viewer/content/$media_file";
        } else {
            $url_media_file = "../viewer/content/$media_file";
        }
    }
    $map = get_fisrt_floorplan($id_virtualtour_sel);
    $multiple_room_view = check_multiple_room_view($id_virtualtour_sel);
    if(count($map)==0) {
        $map_image = false;
    } else {
        $map_image = $map['map'];
    }
    if(empty($map_image)) {
        $map_image = "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCA0NTAgMzAwIiBjbGFzcz0iaW1nLWZsdWlkIHJvdW5kZWQgbXgtYXV0byBkLWJsb2NrIiB3aWR0aD0iNDUwIiBoZWlnaHQ9IjMwMCI+CiAgICAgICAgICAgICAgICAgICAgPHJlY3Qgd2lkdGg9IjQ1MCIgaGVpZ2h0PSIzMDAiIGZpbGw9IiM0NDQ0NDQiPjwvcmVjdD4KICAgICAgICAgICAgICAgICAgICA8dGV4dCB4PSI1MCUiIHk9IjUwJSIgZG9taW5hbnQtYmFzZWxpbmU9Im1pZGRsZSIgdGV4dC1hbmNob3I9Im1pZGRsZSIgZm9udC1mYW1pbHk9Im1vbm9zcGFjZSIgZm9udC1zaXplPSIyNnB4IiBmaWxsPSIjZmZmZmZmIj5GTE9PUlBMQU48L3RleHQ+ICAgCiAgICAgICAgICAgICAgICA8L3N2Zz4KICAgICAgICAgICAgICAgIDwhLS08YSBkb3dubG9hZD0iRklMRU5BTUUucG5nIiBocmVmPSJkYXRhOmltYWdlL3BuZztiYXNlNjQsYXNkYXNkLi4uIj5Eb3dubG9hZDwvYT4tLT4=";
        $map_width = 250;
    } else {
        if($s3_enabled) {
            $map_image = $s3_url."viewer/maps/$map_image";
        } else {
            $map_image = "../viewer/maps/$map_image";
        }
        $map_width = $map['width_d'];
    }
    $form_icon = $virtual_tour['form_icon'];
    $list_alt = $virtual_tour['list_alt'];
    $array_list_alt = array();
    $array_id_rooms = array();
    if ($list_alt == '') {
        foreach ($rooms as $room) {
            array_push($array_list_alt,["id"=>$room['id'],"type"=>"room","hide"=>"0","name"=>$room['name']]);
        }
    } else {
        $list_alt_array = json_decode($list_alt, true);
        foreach ($list_alt_array as $item) {
            switch ($item['type']) {
                case 'room':
                    if(array_key_exists($item['id'],$array_r)) {
                        array_push($array_list_alt, ["id" => $item['id'], "type" => "room", "hide" => $item['hide'], "name" => $array_r[$item['id']]]);
                    }
                    array_push($array_id_rooms,$item['id']);
                    break;
                case 'category':
                    $childrens = array();
                    foreach ($item['children'] as $children) {
                        if ($children['type'] == "room") {
                            if(array_key_exists($children['id'],$array_r)) {
                                array_push($childrens, ["id" => $children['id'], "type" => "room", "hide" => $children['hide'], "name" => $array_r[$children['id']]]);
                            }
                            array_push($array_id_rooms,$children['id']);
                        }
                    }
                    array_push($array_list_alt, ["id" => $item['id'], "type" => "category", "name" => $item['cat'], "childrens" => $childrens]);
                    break;
            }
        }
        foreach ($rooms as $room) {
            $id_room = $room['id'];
            if(!in_array($id_room,$array_id_rooms)) {
                array_push($array_list_alt,["id"=>$room['id'],"type"=>"room","hide"=>"0","name"=>$room['name']]);
            }
        }
    }
    $snapshot_params = $virtual_tour['snapshot_params'];
    if(empty($snapshot_params)) {
        $snapshot_params = array();
        $snapshot_params['logo']='top_right';
        $snapshot_params['qrcode']='bottom_right';
        $snapshot_params['info']='bottom_left';
    } else {
        $snapshot_params = json_decode($snapshot_params,true);
    }
    $position_snapshot_elems = array(
        'top_left' => 'none',
        'top_right' => 'none',
        'bottom_left' => 'none',
        'bottom_right' => 'none'
    );
    foreach ($snapshot_params as $element => $position) {
        if (isset($position_snapshot_elems[$position])) {
            $position_snapshot_elems[$position] = $element;
        }
    }
    if(!empty($virtual_tour['ui_style'])) {
        $ui_style = json_decode($virtual_tour['ui_style'],true);
        if(!isset($ui_style['controls']['info']['icon'])) $ui_style['controls']['info']['icon']='fas fa-info';
        if(!isset($ui_style['controls']['gallery']['icon'])) $ui_style['controls']['gallery']['icon']='fas fa-images';
        if(!isset($ui_style['controls']['facebook']['icon'])) $ui_style['controls']['facebook']['icon']='fab fa-facebook-messenger';
        if(!isset($ui_style['controls']['whatsapp']['icon'])) $ui_style['controls']['whatsapp']['icon']='fab fa-whatsapp';
        if(!isset($ui_style['controls']['presentation']['icon'])) $ui_style['controls']['presentation']['icon']='fas fa-play';
        if(!isset($ui_style['controls']['share']['icon'])) $ui_style['controls']['share']['icon']='fas fa-share-alt';
        if(!isset($ui_style['controls']['form']['icon'])) $ui_style['controls']['form']['icon']=$form_icon;
        if(!isset($ui_style['controls']['live']['icon'])) $ui_style['controls']['live']['icon']='fas fa-phone';
        if(!isset($ui_style['controls']['meeting']['icon'])) $ui_style['controls']['meeting']['icon']='fas fa-handshake';
        if(!isset($ui_style['controls']['vr']['icon'])) $ui_style['controls']['vr']['icon']='fas fa-vr-cardboard';
        if(!isset($ui_style['controls']['icons']['icon'])) $ui_style['controls']['icons']['icon']='far fa-dot-circle';
        if(!isset($ui_style['controls']['autorotate']['icon'])) $ui_style['controls']['autorotate']['icon']='fas fa-sync-alt';
        if(!isset($ui_style['controls']['orient']['icon'])) $ui_style['controls']['orient']['icon']='far fa-compass';
        if(!isset($ui_style['controls']['annotations']['icon'])) $ui_style['controls']['annotations']['icon']='far fa-comment-alt';
        if(!isset($ui_style['controls']['custom'])) {
            $ui_style['controls']['custom']=[
                'type'=>'button',
                'position'=>'left',
                'order'=>10,
                'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,1);',
                'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);',
                'icon'=>'fas fa-bullhorn',
                'label'=>'Custom 1'
            ];
        }
        if(!isset($ui_style['controls']['custom2'])) {
            $ui_style['controls']['custom2']=[
                'type'=>'button',
                'position'=>'left',
                'order'=>11,
                'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,1);',
                'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);',
                'icon'=>'fas fa-bullhorn',
                'label'=>'Custom 2'
            ];
        }
        if(!isset($ui_style['controls']['custom3'])) {
            $ui_style['controls']['custom3']=[
                'type'=>'button',
                'position'=>'left',
                'order'=>12,
                'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,1);',
                'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);',
                'icon'=>'fas fa-bullhorn',
                'label'=>'Custom 3'
            ];
        }
        if(!isset($ui_style['controls']['custom4'])) {
            $ui_style['controls']['custom4']=[
                'type'=>'menu',
                'position'=>'left',
                'order'=>10,
                'style'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                'style_hover'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                'icon'=>'fas fa-bullhorn',
                'label'=>'Custom 4'
            ];
        }
        if(!isset($ui_style['controls']['custom5'])) {
            $ui_style['controls']['custom5']=[
                'type'=>'menu',
                'position'=>'left',
                'order'=>11,
                'style'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                'style_hover'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                'icon'=>'fas fa-bullhorn',
                'label'=>'Custom 5'
            ];
        }
        if(!isset($ui_style['controls']['list_alt_menu'])) {
            $ui_style['controls']['list_alt_menu']=[
                'style'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                'style_hover'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                'icon_color'=>'rgba(0,0,0,1)',
                'icon_color_hover'=>'rgba(0,0,0,1)'
            ];
        }
        if(!isset($ui_style['controls']['dollhouse'])) {
            $ui_style['controls']['dollhouse']=[
                'type'=>'button',
                'position'=>'left',
                'order'=>3,
                'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,1);',
                'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);',
                'icon'=>'fas fa-cube'
            ];
        }
        if(!isset($ui_style['items']['map']['color'])) $ui_style['items']['map']['color']='rgba(50,50,50,1)';
        if(!isset($ui_style['items']['map']['color_hover'])) $ui_style['items']['map']['color_hover']='rgba(0,0,0,1)';
        if(!isset($ui_style['items']['map']['background'])) $ui_style['items']['map']['background']='rgba(255,255,255,1)';
        if(!isset($ui_style['controls']['measures'])) {
            $ui_style['controls']['measures']=[
                'type'=>'menu',
                'position'=>'left',
                'order'=>0,
                'style'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                'style_hover'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                'icon'=>'fas fa-ruler-combined'
            ];
        }
        if(!isset($ui_style['icons_tooltips'])) $ui_style['icons_tooltips']=1;
        if(!isset($ui_style['preview_room_slider'])) $ui_style['preview_room_slider']=1;
        if(!isset($ui_style['controls']['share']['providers'])) $ui_style['controls']['share']['providers']='copy_link,email,whatsapp,facebook,twitter,linkedin,telegram,facebook_messenger,pinterest,reddit,line,viber,vk,qzone,wechat';
        if(!isset($ui_style['items']['logo']['padding_top'])) $ui_style['items']['logo']['padding_top']=0;
        if(!isset($ui_style['items']['logo']['padding_left'])) $ui_style['items']['logo']['padding_left']=0;
        if(!isset($ui_style['items']['logo']['padding_right'])) $ui_style['items']['logo']['padding_right']=0;
        if(!isset($ui_style['controls']['location'])) {
            $ui_style['controls']['location']=[
                'type'=>'button',
                'position'=>'right',
                'order'=>0,
                'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,1);',
                'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);',
                'icon'=>'fas fa-map-marker-alt',
                'label'=>'Location'
            ];
        }
        if(!isset($ui_style['controls']['media'])) {
            $ui_style['controls']['media']=[
                'type'=>'button',
                'position'=>'right',
                'order'=>-1,
                'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,1);',
                'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);',
                'icon'=>'fas fa-photo-film',
                'label'=>'Media'
            ];
        }
        if(!isset($ui_style['items']['title']['background_height'])) $ui_style['items']['title']['background_height']=85;
        if(!isset($ui_style['items']['comments']['color'])) $ui_style['items']['comments']['color']='rgba(255,255,255,1)';
        if(!isset($ui_style['items']['poweredby'])) {
            $ui_style['items']['poweredby']=[
                'position'=>'bottom_right',
                'image_height'=>40,
                'font_size'=>12,
                'font_color'=>'#ffffff',
            ];
        }
        if(!isset($ui_style['items']['avatar_video'])) {
            $ui_style['items']['avatar_video']=[
                'position'=>'bottom_right',
                'width'=>170,
                'height'=>300,
                'padding_left'=>0,
                'padding_bottom'=>0,
                'padding_right'=>0
            ];
        }
        if(!isset($ui_style['items']['multiple_room_views'])) {
            $ui_style['items']['multiple_room_views']=[
                'size'=>30,
                'style'=>'round',
                'border'=>1,
                'color'=>'rgba(255,255,255,1)'
            ];
        }
        if(!isset($ui_style['items']['visitors_rt_stats'])) {
            $ui_style['items']['visitors_rt_stats']=[
                'background'=>'rgba(0,0,0,0.6)',
                'color'=>'rgb(255,255,255)'
            ];
        }
        if(!isset($ui_style['controls']['fullscreen_alt'])) {
            $ui_style['controls']['fullscreen_alt']=[
                'type'=>'menu',
                'position'=>'right',
                'order'=>4,
                'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,1);',
                'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);',
            ];
        }
        if(!isset($ui_style['controls']['snapshot'])) {
            $ui_style['controls']['snapshot']=[
                'type'=>'button',
                'position'=>'right',
                'order'=>-1,
                'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,1);',
                'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);',
                'icon'=>'fas fa-camera',
            ];
        }
        if(!isset($ui_style['buttons_style'])) {
            $ui_style['buttons_style']='default';
        }
        if(!isset($ui_style['buttons_size'])) {
            $ui_style['buttons_size']='default';
        }
        if(!isset($ui_style['items']['logo']['opacity'])) {
            $ui_style['items']['logo']['opacity']=1;
            $ui_style['items']['logo']['opacity_hover']=1;
        }
        if(!isset($ui_style['items']['poweredby']['opacity'])) {
            $ui_style['items']['poweredby']['opacity']=1;
            $ui_style['items']['poweredby']['opacity_hover']=1;
        }
        if(!isset($ui_style['controls']['icons_content'])) {
            $ui_style['controls']['icons_content']=[
                'type'=>'menu',
                'position'=>'left',
                'order'=>0,
                'style'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                'style_hover'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                'icon'=>'fas fa-dot-circle'
            ];
        }
        if(!isset($ui_style['controls']['icons_nav'])) {
            $ui_style['controls']['icons_nav']=[
                'type'=>'menu',
                'position'=>'left',
                'order'=>0,
                'style'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                'style_hover'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                'icon'=>'fas fa-chevron-circle-up'
            ];
        }
        if(!isset($ui_style['controls']['map_alt'])) {
            $ui_style['controls']['map_alt']=[
                'type'=>'menu',
                'position'=>'right',
                'order'=>5,
                'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,1);',
                'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);',
                'icon'=>'fas fa-map',
            ];
        }
        if(!isset($ui_style['controls']['floorplan_alt'])) {
            $ui_style['controls']['floorplan_alt']=[
                'type'=>'menu',
                'position'=>'right',
                'order'=>6,
                'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,1);',
                'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);',
                'icon'=>'fas fa-object-group',
            ];
        }
        if(!isset($ui_style['controls']['language_alt'])) {
            $ui_style['controls']['language_alt']=[
                'type'=>'menu',
                'position'=>'right',
                'order'=>7,
                'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,1);',
                'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);'
            ];
        }
        if(!isset($ui_style['controls']['song_alt'])) {
            $ui_style['controls']['song_alt']=[
                'type'=>'menu',
                'position'=>'left',
                'order'=>4,
                'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,1);',
                'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);',
                'icon'=>'fas fa-volume-low',
            ];
        }
        if(!isset($ui_style['sidebar'])) {
            $ui_style['sidebar']=[
                'enable'=>false,
                'glass'=>false,
                'logo_height'=>100,
                'background'=>'rgba(0,0,0,0.7)',
            ];
        }
        if(!isset($ui_style['items']['inline_form'])) {
            $ui_style['items']['inline_form']=[
                'position'=>'top_left',
                'color'=>'rgba(255,255,255,1)',
                'background'=>'rgba(0,0,0,0.8)',
                'button_color'=>'rgb(0,0,0)',
                'button_background'=>'rgb(255,255,255)',
                'field_color'=>'rgb(255,255,255)',
                'field_background'=>'rgba(50,50,50,1)',
            ];
        }
    } else {
        $ui_style = [
            'buttons_style'=>'default',
            'buttons_size'=>'default',
            'icons_tooltips'=>1,
            'preview_room_slider'=>1,
            'sidebar'=>[
                'enable'=>false,
                'glass'=>false,
                'logo_height'=>100,
                'background'=>'rgba(0,0,0,0.7)',
            ],
            'items'=>[
                'list'=>[
                    'background_initial'=>'',
                    'background'=>'rgba(0,0,0,0.1)',
                ],
                'annotation'=>[
                    'position'=>'top_left',
                    'color'=>'rgba(255,255,255,1)',
                    'background'=>'rgba(0,0,0,0.4)',
                ],
                'inline_form'=>[
                    'position'=>'top_left',
                    'color'=>'rgba(255,255,255,1)',
                    'background'=>'rgba(0,0,0,0.8)',
                    'button_color'=>'rgb(0,0,0)',
                    'button_background'=>'rgb(255,255,255)',
                    'field_color'=>'rgb(255,255,255)',
                    'field_background'=>'rgba(50,50,50,1)',
                ],
                'title'=>[
                    'color'=>'rgba(255,255,255,1)',
                    'background'=>'rgba(0,0,0',
                    'background_height'=>85
                ],
                'multiple_room_views'=>[
                    'size'=>30,
                    'style'=>'round',
                    'border'=>1,
                    'color'=>'rgba(255,255,255,1)'
                ],
                'visitors_rt_stats'=>[
                    'background'=>'rgba(0,0,0,0.6)',
                    'color'=>'rgb(255,255,255)'
                ],
                'comments'=>[
                    'color'=>'rgba(255,255,255,1)'
                ],
                'nav_control'=>[
                    'color'=>'rgba(255,255,255,0.6)',
                    'color_hover'=>'rgba(255,255,255,1)',
                    'background'=>'rgba(0,0,0,0.4)'
                ],
                'logo'=>[
                    'position'=>'top_right',
                    'height'=>40,
                    'padding_top'=>0,
                    'padding_left'=>0,
                    'padding_right'=>0,
                    'opacity'=>1,
                    'opacity_hover'=>1
                ],
                'map'=>[
                    'position'=>'top_right',
                    'color'=>'rgba(50,50,50,1)',
                    'color_hover'=>'rgba(0,0,0,1)',
                    'background'=>'rgba(255,255,255,1)'
                ],
                'poweredby'=>[
                    'position'=>'bottom_right',
                    'image_height'=>40,
                    'font_size'=>12,
                    'font_color'=>'#ffffff',
                    'opacity'=>1,
                    'opacity_hover'=>1
                ],
                'avatar_video'=>[
                    'position'=>'bottom_right',
                    'width'=>170,
                    'height'=>300,
                    'padding_left'=>0,
                    'padding_bottom'=>0,
                    'padding_right'=>0
                ],
            ],
            'icons'=>[
                'menu'=>[
                    'color'=>'rgba(255,255,255,0.8)',
                    'color_hover'=>'rgba(255,255,255,1)',
                ],
                'list_alt'=>[
                    'color'=>'rgba(255,255,255,0.8)',
                    'color_hover'=>'rgba(255,255,255,1)',
                ],
                'audio'=>[
                    'color'=>'rgba(255,255,255,0.8)',
                    'color_hover'=>'rgba(255,255,255,1)',
                ],
                'floorplan'=>[
                    'color'=>'rgba(255,255,255,0.8)',
                    'color_hover'=>'rgba(255,255,255,1)',
                ],
                'map'=>[
                    'color'=>'rgba(255,255,255,0.8)',
                    'color_hover'=>'rgba(255,255,255,1)',
                ],
                'fullscreen'=>[
                    'color'=>'rgba(255,255,255,0.8)',
                    'color_hover'=>'rgba(255,255,255,1)',
                ]
            ],
            'controls'=>[
                'fullscreen_alt'=>[
                    'type'=>'menu',
                    'position'=>'right',
                    'order'=>4,
                    'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,1);',
                    'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);',
                ],
                'map_alt'=>[
                    'type'=>'menu',
                    'position'=>'right',
                    'order'=>5,
                    'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,1);',
                    'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);',
                    'icon'=>'fas fa-map',
                ],
                'floorplan_alt'=>[
                    'type'=>'menu',
                    'position'=>'right',
                    'order'=>6,
                    'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,1);',
                    'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);',
                    'icon'=>'fas fa-object-group',
                ],
                'language_alt'=>[
                    'type'=>'menu',
                    'position'=>'right',
                    'order'=>7,
                    'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,1);',
                    'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);'
                ],
                'song_alt'=>[
                    'type'=>'menu',
                    'position'=>'left',
                    'order'=>3,
                    'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,1);',
                    'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);',
                    'icon'=>'fas fa-volume-low',
                ],
                'list_alt_menu'=>[
                    'style'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'style_hover'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'icon_color'=>'rgba(0,0,0,1)',
                    'icon_color_hover'=>'rgba(0,0,0,1)'
                ],
                'list'=>[
                    'type'=>'default',
                    'position'=>'left',
                    'order'=>0,
                    'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,0.8);',
                    'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);'
                ],
                'arrows'=>[
                    'type'=>'default',
                    'position'=>'left',
                    'order'=>0,
                    'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,0.8);',
                    'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);'
                ],
                'nav_arrows'=>[
                    'style'=>'background-color:transparent;color:rgba(255,255,255,0.8);',
                    'style_hover'=>'background-color:transparent;color:rgba(255,255,255,1);'
                ],
                'voice'=>[
                    'type'=>'button',
                    'position'=>'left',
                    'order'=>0
                ],
                'custom'=>[
                    'type'=>'button',
                    'position'=>'left',
                    'order'=>10,
                    'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,1);',
                    'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);',
                    'icon'=>'fas fa-bullhorn',
                    'label'=>'Custom 1'
                ],
                'custom2'=>[
                    'type'=>'button',
                    'position'=>'left',
                    'order'=>11,
                    'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,1);',
                    'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);',
                    'icon'=>'fas fa-bullhorn',
                    'label'=>'Custom 2'
                ],
                'custom3'=>[
                    'type'=>'button',
                    'position'=>'left',
                    'order'=>12,
                    'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,1);',
                    'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);',
                    'icon'=>'fas fa-bullhorn',
                    'label'=>'Custom 3'
                ],
                'custom4'=>[
                    'type'=>'menu',
                    'position'=>'left',
                    'order'=>10,
                    'style'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'style_hover'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'icon'=>'fas fa-bullhorn',
                    'label'=>'Custom 4'
                ],
                'custom5'=>[
                    'type'=>'menu',
                    'position'=>'left',
                    'order'=>11,
                    'style'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'style_hover'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'icon'=>'fas fa-bullhorn',
                    'label'=>'Custom 5'
                ],
                'info'=>[
                    'type'=>'button',
                    'position'=>'left',
                    'order'=>1,
                    'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,1);',
                    'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);',
                    'icon'=>'fas fa-info'
                ],
                'dollhouse'=>[
                    'type'=>'button',
                    'position'=>'left',
                    'order'=>3,
                    'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,1);',
                    'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);',
                    'icon'=>'fas fa-cube'
                ],
                'gallery'=>[
                    'type'=>'button',
                    'position'=>'left',
                    'order'=>2,
                    'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,1);',
                    'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);',
                    'icon'=>'fas fa-images'
                ],
                'facebook'=>[
                    'type'=>'button',
                    'position'=>'right',
                    'order'=>1,
                    'style'=>'background-color:rgba(66,103,178,0.8);color:rgba(255,255,255,1);',
                    'style_hover'=>'background-color:rgba(66,103,178,0.9);color:rgba(255,255,255,1);',
                    'icon'=>'fab fa-facebook-messenger'
                ],
                'whatsapp'=>[
                    'type'=>'button',
                    'position'=>'right',
                    'order'=>2,
                    'style'=>'background-color:rgba(37,211,102,0.8);color:rgba(255,255,255,1);',
                    'style_hover'=>'background-color:rgba(37,211,102,0.9);color:rgba(255,255,255,1);',
                    'icon'=>'fab fa-whatsapp'
                ],
                'presentation'=>[
                    'type'=>'menu',
                    'position'=>'left',
                    'order'=>5,
                    'style'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'style_hover'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'icon'=>'fas fa-play'
                ],
                'share'=>[
                    'type'=>'menu',
                    'position'=>'left',
                    'order'=>6,
                    'style'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'style_hover'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'icon'=>'fas fa-share-alt',
                    'providers'=>'copy_link,email,whatsapp,facebook,twitter,linkedin,telegram,facebook_messenger,pinterest,reddit,line,viber,vk,qzone,wechat'
                ],
                'form'=>[
                    'type'=>'menu',
                    'position'=>'left',
                    'order'=>7,
                    'style'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'style_hover'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'icon'=>$form_icon
                ],
                'live'=>[
                    'type'=>'menu',
                    'position'=>'left',
                    'order'=>9,
                    'style'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'style_hover'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'icon'=>'fas fa-phone'
                ],
                'meeting'=>[
                    'type'=>'menu',
                    'position'=>'left',
                    'order'=>8,
                    'style'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'style_hover'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'icon'=>'fas fa-handshake'
                ],
                'vr'=>[
                    'type'=>'menu',
                    'position'=>'left',
                    'order'=>3,
                    'style'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'style_hover'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'icon'=>'fas fa-vr-cardboard'
                ],
                'compass'=>[
                    'type'=>'button',
                    'position'=>'right',
                    'order'=>3,
                    'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,1);',
                    'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);'
                ],
                'icons'=>[
                    'type'=>'menu',
                    'position'=>'left',
                    'order'=>0,
                    'style'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'style_hover'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'icon'=>'far fa-dot-circle'
                ],
                'icons_content'=>[
                    'type'=>'menu',
                    'position'=>'left',
                    'order'=>0,
                    'style'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'style_hover'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'icon'=>'fas fa-dot-circle'
                ],
                'icons_nav'=>[
                    'type'=>'menu',
                    'position'=>'left',
                    'order'=>0,
                    'style'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'style_hover'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'icon'=>'fas fa-chevron-circle-up'
                ],
                'measures'=>[
                    'type'=>'menu',
                    'position'=>'left',
                    'order'=>0,
                    'style'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'style_hover'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'icon'=>'fas fa-ruler-combined'
                ],
                'autorotate'=>[
                    'type'=>'menu',
                    'position'=>'left',
                    'order'=>1,
                    'style'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'style_hover'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'icon'=>'fas fa-sync-alt'
                ],
                'orient'=>[
                    'type'=>'menu',
                    'position'=>'left',
                    'order'=>2,
                    'style'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'style_hover'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'icon'=>'far fa-compass'
                ],
                'annotations'=>[
                    'type'=>'menu',
                    'position'=>'left',
                    'order'=>4,
                    'style'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'style_hover'=>'background-color:rgba(255,255,255,1);color:rgba(0,0,0,1);',
                    'icon'=>'far fa-comment-alt'
                ],
                'location'=>[
                    'type'=>'button',
                    'position'=>'right',
                    'order'=>0,
                    'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,1);',
                    'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);',
                    'icon'=>'fas fa-map-marker-alt',
                    'label'=>'Location'
                ],
                'media'=>[
                    'type'=>'button',
                    'position'=>'right',
                    'order'=>0,
                    'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,1);',
                    'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);',
                    'icon'=>'fas fa-photo-film',
                    'label'=>'Media'
                ],
                'snapshot'=>[
                    'type'=>'button',
                    'position'=>'right',
                    'order'=>0,
                    'style'=>'background-color:rgba(0,0,0,0.6);color:rgba(255,255,255,1);',
                    'style_hover'=>'background-color:rgba(0,0,0,0.8);color:rgba(255,255,255,1);',
                    'icon'=>'fas fa-camera',
                ],
            ]
        ];
    }
    $ui_style['controls']['custom']['label'] = str_replace('"',"'",$ui_style['controls']['custom']['label']);
    $ui_style['controls']['custom2']['label'] = str_replace('"',"'",$ui_style['controls']['custom2']['label']);
    $ui_style['controls']['custom3']['label'] = str_replace('"',"'",$ui_style['controls']['custom3']['label']);
    $ui_style['controls']['custom4']['label'] = str_replace('"',"'",$ui_style['controls']['custom4']['label']);
    $ui_style['controls']['custom5']['label'] = str_replace('"',"'",$ui_style['controls']['custom5']['label']);
    $ui_style['controls']['location']['label'] = str_replace('"',"'",$ui_style['controls']['location']['label']);
    $ui_style['controls']['media']['label'] = str_replace('"',"'",$ui_style['controls']['media']['label']);
    if (strpos($ui_style['items']['list']['background'], 'rgb(') !== false) {
        $ui_style['items']['list']['background'] = str_replace("rgb(","rgba(",$ui_style['items']['list']['background']);
        $ui_style['items']['list']['background'] = str_replace(")",",1)",$ui_style['items']['list']['background']);
    }
    $tmp = explode(',', $ui_style['items']['list']['background']);
    $percent = (float) trim(str_replace(")","",end($tmp))) / 2;
    array_pop($tmp);
    $ui_style['items']['list']['background_initial'] = implode(",",$tmp).",0) 70%, ".implode(",",$tmp).",$percent) 85%";
    $form_content = $virtual_tour['form_content'];
    $form_title = _("Main Form");
    $form_description = "";
    $form_button = _("SUBMIT");
    if(!empty($form_content)) {
        $form_content = json_decode($form_content,true);
        if(!empty($form_content[0]['title'])) {
            $form_title = $form_content[0]['title'];
        }
        if(!empty($form_content[0]['description'])) {
            $form_description = $form_content[0]['description'];
        }
        if(!empty($form_content[0]['button'])) {
            $form_button = $form_content[0]['button'];
        }
    }
    $tmp = explode(';', $ui_style['controls']['list']['style']);
    $active_border_list_color = str_replace("color:","",$tmp[1]);
    $tmp = explode(';', $ui_style['controls']['list_alt_menu']['style']);
    $list_alt_menu_background = str_replace("background-color:","",$tmp[0]);
    $presets_editor_ui = get_presets_editor_ui($id_user);
    $user_role = get_user_role($id_user);
    $array_library_icons = array();
    $array_public_library_icons = array();
    $query = "SELECT id,image,id_virtualtour FROM svt_icons WHERE id_virtualtour=$id_virtualtour_sel OR id_virtualtour IS NULL;";
    $result = $mysqli->query($query);
    if($result) {
        if($result->num_rows>0) {
            while($row=$result->fetch_array(MYSQLI_ASSOC)) {
                $id_icon = $row['id'];
                $image_icon = $row['image'];
                if(empty($row['id_virtualtour'])) {
                    $array_public_library_icons[$id_icon] = 1;
                }
                $array_library_icons[$id_icon] = $image_icon;
            }
        }
    }
}
?>

<?php include("check_plan.php"); ?>

<?php include("check_block_tour.php"); ?>

<link rel="stylesheet" type="text/css" href="../viewer/css/index.css?v=<?php echo time(); ?>">
<link rel="stylesheet" type="text/css" href="../viewer/vendor/SpeechKITT/themes/flat.css?v=15">

<?php if(!$virtual_tour): ?>
    <div class="text-center">
        <div class="error mx-auto" data-text="401">401</div>
        <p class="lead text-gray-800 mb-5"><?php echo _("Permission denied"); ?></p>
        <p class="text-gray-500 mb-0"><?php echo _("It looks like that you do not have permission to access this page"); ?></p>
        <a href="index.php?p=dashboard">← <?php echo _("Back to Dashboard"); ?></a>
    </div>
    <script>
        $('.vt_select_header').remove();
    </script>
<?php die(); endif; ?>

<?php if($virtual_tour['external']==1) : ?>
    <div class="card bg-warning text-white shadow mb-4">
        <div class="card-body">
            <?php echo _("You cannot edit UI on an external virtual tour!"); ?>
        </div>
    </div>
<?php exit; endif; ?>

<?php if(!$can_create) : ?>
    <div class="card bg-warning text-white shadow mb-4">
        <div class="card-body">
            <?php echo sprintf(_('Your "%s" plan not allow to use Editor UI!'),$user_info['plan'])." ".$msg_change_plan; ?>
        </div>
    </div>
<?php exit; endif; ?>

<?php switch ($settings['font_provider']) {
    case 'google': ?>
        <link id="css_font" rel='stylesheet' type="text/css" href="https://fonts.googleapis.com/css?family=<?php echo $virtual_tour['font_viewer']; ?>">
        <?php break;
    case 'collabs': ?>
        <link id="css_font" rel='stylesheet' type="text/css" href="https://api.fonts.coollabs.io/css2?family=<?php echo $virtual_tour['font_viewer']; ?>&display=swap">
        <?php break;
} ?>
<style>
    #ui_container *:not(i) { font-family: '<?php echo $virtual_tour['font_viewer']; ?>', sans-serif; }
    #ui_container .controls_btn, #ui_container .ms_control, #ui_container .menu_controls, #ui_container .list_alt_menu, #ui_container .song_control_icon, #ui_container .map_control, #ui_container .map_tour_control, #ui_container .fullscreen_control, #ui_container .title, #ui_container .dropdown, #ui_container #list_editor_ui_items ul li {
        font-family: sans-serif;
    }
</style>

<div class="row">
    <div class="col-md-12 mb-2 editor_ui_container">
        <div class="card shadow mb-3">
            <div id="editor_ui_div" style="background: white;" class="card-body p-0 position-relative">
                <div class="modal_fs_container">
                    <div style="display:none;" class="modal-backdrop show"></div>
                    <div id="modal_edit_contents" class="modal modal-fullscreen" tabindex="-1" role="dialog" data-backdrop="static">
                        <div class="modal-dialog modal-dialog-scrollable" role="document">
                            <div class="modal-content">
                                <div class="modal-body"></div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary mx-auto" data-dismiss="modal"><i class="fas fa-times"></i> <?php echo _("Close"); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="modal_change_languages" class="modal" tabindex="-1" role="dialog" data-backdrop="static">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title"><?php echo _("Languages"); ?></h5>
                                </div>
                                <div class="modal-body">
                                    <p><?php echo _("Enabled languages have changed. To apply them, you need to reload the page."); ?>
                                    </p>
                                </div>
                                <div class="modal-footer">
                                    <button <?php echo ($demo) ? 'disabled':''; ?> onclick="save_vt_ui(true,false,false,true);" type="button" class="btn btn-success"><i class="fas fa-check"></i> <?php echo _("Yes, Reload"); ?></button>
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fas fa-times"></i> <?php echo _("No, i will do later"); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="modal_list_alt" class="modal" tabindex="-1" role="dialog" data-backdrop="static">
                        <div class="modal-dialog modal-dialog-scrollable" role="document">
                            <div class="modal-content">
                                <div class="modal-body">
                                    <?php include("rooms_menu_list.php"); ?>
                                </div>
                                <div class="modal-footer">
                                    <button onclick="get_rooms_menu_list_editor_ui();" type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fas fa-times"></i> <?php echo _("Close"); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="modal_custom_content" class="modal" tabindex="-1" role="dialog" data-backdrop="static">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-body">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="custom_title"><?php echo _("Title"); ?></label><?php echo print_language_input_selector($array_languages,$default_language,'custom_title'); ?>
                                                <input oninput="change_custom_title();" onchange="change_custom_title();" id="custom_title" type="text" class="form-control" value="<?php echo $ui_style['controls']['custom']['label']; ?>">
                                                <?php foreach ($array_languages as $lang) {
                                                    if($lang!=$default_language) : ?>
                                                        <input id="custom_title_<?php echo $lang; ?>" type="text" class="form-control input_lang" data-target-id="custom_title" data-lang="<?php echo $lang; ?>" value="<?php echo $array_input_lang[$lang]['custom_title']; ?>">
                                                    <?php endif;
                                                } ?>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <label><?php echo _("Content - Html / Link"); ?></label><?php echo print_language_input_selector($array_languages,$default_language,'custom_content'); ?>
                                            <div id="custom_content"><?php echo htmlentities($virtual_tour['custom_content']); ?></div>
                                            <?php foreach ($array_languages as $lang) {
                                                if($lang!=$default_language) : ?>
                                                    <div id="custom_content_<?php echo $lang; ?>" class="input_lang" data-target-id="custom_content" data-lang="<?php echo $lang; ?>"><?php echo htmlentities($array_input_lang[$lang]['custom_content']); ?></div>
                                                <?php endif;
                                            } ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fas fa-times"></i> <?php echo _("Close"); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="modal_custom2_content" class="modal" tabindex="-1" role="dialog" data-backdrop="static">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-body">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="custom2_title"><?php echo _("Title"); ?></label><?php echo print_language_input_selector($array_languages,$default_language,'custom2_title'); ?>
                                                <input oninput="change_custom2_title();" onchange="change_custom2_title();" id="custom2_title" type="text" class="form-control" value="<?php echo $ui_style['controls']['custom2']['label']; ?>">
                                                <?php foreach ($array_languages as $lang) {
                                                    if($lang!=$default_language) : ?>
                                                        <input id="custom2_title_<?php echo $lang; ?>" type="text" class="form-control input_lang" data-target-id="custom2_title" data-lang="<?php echo $lang; ?>" value="<?php echo $array_input_lang[$lang]['custom2_title']; ?>">
                                                    <?php endif;
                                                } ?>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <label><?php echo _("Content - Html / Link"); ?></label><?php echo print_language_input_selector($array_languages,$default_language,'custom2_content'); ?>
                                            <div id="custom2_content"><?php echo htmlentities($virtual_tour['custom2_content']); ?></div>
                                            <?php foreach ($array_languages as $lang) {
                                                if($lang!=$default_language) : ?>
                                                    <div id="custom2_content_<?php echo $lang; ?>" class="input_lang" data-target-id="custom2_content" data-lang="<?php echo $lang; ?>"><?php echo htmlentities($array_input_lang[$lang]['custom2_content']); ?></div>
                                                <?php endif;
                                            } ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fas fa-times"></i> <?php echo _("Close"); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="modal_custom3_content" class="modal" tabindex="-1" role="dialog" data-backdrop="static">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-body">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="custom3_title"><?php echo _("Title"); ?></label><?php echo print_language_input_selector($array_languages,$default_language,'custom3_title'); ?>
                                                <input oninput="change_custom3_title();" onchange="change_custom3_title();" id="custom3_title" type="text" class="form-control" value="<?php echo $ui_style['controls']['custom3']['label']; ?>">
                                                <?php foreach ($array_languages as $lang) {
                                                    if($lang!=$default_language) : ?>
                                                        <input id="custom3_title_<?php echo $lang; ?>" type="text" class="form-control input_lang" data-target-id="custom3_title" data-lang="<?php echo $lang; ?>" value="<?php echo $array_input_lang[$lang]['custom3_title']; ?>">
                                                    <?php endif;
                                                } ?>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <label><?php echo _("Content - Html / Link"); ?></label><?php echo print_language_input_selector($array_languages,$default_language,'custom3_content'); ?>
                                            <div id="custom3_content"><?php echo htmlentities($virtual_tour['custom3_content']); ?></div>
                                            <?php foreach ($array_languages as $lang) {
                                                if($lang!=$default_language) : ?>
                                                    <div id="custom3_content_<?php echo $lang; ?>" class="input_lang" data-target-id="custom3_content" data-lang="<?php echo $lang; ?>"><?php echo htmlentities($array_input_lang[$lang]['custom3_content']); ?></div>
                                                <?php endif;
                                            } ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fas fa-times"></i> <?php echo _("Close"); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="modal_custom4_content" class="modal" tabindex="-1" role="dialog" data-backdrop="static">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-body">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="custom4_title"><?php echo _("Title"); ?></label><?php echo print_language_input_selector($array_languages,$default_language,'custom4_title'); ?>
                                                <input oninput="change_custom4_title();" onchange="change_custom4_title();" id="custom4_title" type="text" class="form-control" value="<?php echo $ui_style['controls']['custom4']['label']; ?>">
                                                <?php foreach ($array_languages as $lang) {
                                                    if($lang!=$default_language) : ?>
                                                        <input id="custom4_title_<?php echo $lang; ?>" type="text" class="form-control input_lang" data-target-id="custom4_title" data-lang="<?php echo $lang; ?>" value="<?php echo $array_input_lang[$lang]['custom4_title']; ?>">
                                                    <?php endif;
                                                } ?>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <label><?php echo _("Content - Html / Link"); ?></label><?php echo print_language_input_selector($array_languages,$default_language,'custom4_content'); ?>
                                            <div id="custom4_content"><?php echo htmlentities($virtual_tour['custom4_content']); ?></div>
                                            <?php foreach ($array_languages as $lang) {
                                                if($lang!=$default_language) : ?>
                                                    <div id="custom4_content_<?php echo $lang; ?>" class="input_lang" data-target-id="custom4_content" data-lang="<?php echo $lang; ?>"><?php echo htmlentities($array_input_lang[$lang]['custom4_content']); ?></div>
                                                <?php endif;
                                            } ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fas fa-times"></i> <?php echo _("Close"); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="modal_custom5_content" class="modal" tabindex="-1" role="dialog" data-backdrop="static">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-body">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="custom5_title"><?php echo _("Title"); ?></label><?php echo print_language_input_selector($array_languages,$default_language,'custom5_title'); ?>
                                                <input oninput="change_custom5_title();" onchange="change_custom5_title();" id="custom5_title" type="text" class="form-control" value="<?php echo $ui_style['controls']['custom5']['label']; ?>">
                                                <?php foreach ($array_languages as $lang) {
                                                    if($lang!=$default_language) : ?>
                                                        <input id="custom5_title_<?php echo $lang; ?>" type="text" class="form-control input_lang" data-target-id="custom5_title" data-lang="<?php echo $lang; ?>" value="<?php echo $array_input_lang[$lang]['custom5_title']; ?>">
                                                    <?php endif;
                                                } ?>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <label><?php echo _("Content - Html / Link"); ?></label><?php echo print_language_input_selector($array_languages,$default_language,'custom5_content'); ?>
                                            <div id="custom5_content"><?php echo htmlentities($virtual_tour['custom5_content']); ?></div>
                                            <?php foreach ($array_languages as $lang) {
                                                if($lang!=$default_language) : ?>
                                                    <div id="custom5_content_<?php echo $lang; ?>" class="input_lang" data-target-id="custom5_content" data-lang="<?php echo $lang; ?>"><?php echo htmlentities($array_input_lang[$lang]['custom5_content']); ?></div>
                                                <?php endif;
                                            } ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fas fa-times"></i> <?php echo _("Close"); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="modal_media_file" class="modal" tabindex="-1" role="dialog" data-backdrop="static">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-body">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="media_title"><?php echo _("Title"); ?></label><?php echo print_language_input_selector($array_languages,$default_language,'media_title'); ?>
                                                <input oninput="change_media_title();" onchange="change_media_title();" id="media_title" type="text" class="form-control" value="<?php echo $ui_style['controls']['media']['label']; ?>">
                                                <?php foreach ($array_languages as $lang) {
                                                    if($lang!=$default_language) : ?>
                                                        <input style="display:none;" type="text" class="form-control input_lang" data-target-id="media_title" data-lang="<?php echo $lang; ?>" value="<?php echo $array_input_lang[$lang]['media_title']; ?>" />
                                                    <?php endif;
                                                } ?>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <label><?php echo _("File"); ?></label><?php echo print_language_input_selector($array_languages,$default_language,'media_file'); ?>
                                        </div>
                                        <div id="div_exist_media" class="col-md-12">
                                            <div class="form-group">
                                                <select onchange="change_exist_media('');" class="form-control" id="exist_media">
                                                    <option selected id="0"><?php echo _("Upload new Image / Video file"); ?></option>
                                                    <?php echo get_option_exist_media($_SESSION['id_user'],$s3_enabled,$s3_url); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div style="display: none" id="div_image_media" class="col-md-12 text-center">
                                            <?php
                                            $display_image = "block";
                                            $display_video = "none";
                                            $pattern = "/\.([^\.]+)$/";
                                            preg_match($pattern, $url_media_file, $matches);
                                            if (isset($matches[1])) {
                                                switch($matches[1]) {
                                                    case 'mp4':
                                                    case 'webm':
                                                    $display_image = "none";
                                                    $display_video = "block";
                                                        break;
                                                    default:
                                                        break;
                                                }
                                            }
                                            ?>
                                            <img style="width:100%;height:250px;object-fit:contain;display:<?php echo $display_image; ?>" src="<?php echo $url_media_file; ?>" />
                                            <video style="width:100%;height:250px;object-fit:contain;display:<?php echo $display_video; ?>">
                                                <source src="<?php echo $url_media_file; ?>" type="video/<?php echo $matches[1]; ?>">
                                            </video>
                                        </div>
                                        <?php foreach ($array_languages as $lang) {
                                            if($lang!=$default_language) : ?>
                                                <div style="display: none" id="div_exist_media_<?php echo $lang; ?>" class="col-md-12 input_lang" data-target-id="div_exist_media" data-lang="<?php echo $lang; ?>">
                                                    <div class="form-group">
                                                        <select onchange="change_exist_media('<?php echo $lang; ?>');" class="form-control" id="exist_media_<?php echo $lang; ?>">
                                                            <option selected id="0"><?php echo _("Upload new Image / Video file"); ?></option>
                                                            <?php echo get_option_exist_media($_SESSION['id_user'],$s3_enabled,$s3_url); ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div style="display: none" id="div_image_media_<?php echo $lang; ?>" class="col-md-12 text-center input_lang" data-target-id="div_image_media" data-lang="<?php echo $lang; ?>">
                                                    <?php
                                                    $display_image = "block";
                                                    $display_video = "none";
                                                    $pattern = "/\.([^\.]+)$/";
                                                    $url_media_file = "";
                                                    $media_file = $array_input_lang[$lang]['media_file'];
                                                    if(!empty($media_file)) {
                                                        if($s3_enabled) {
                                                            $url_media_file = $s3_url."viewer/content/$media_file";
                                                        } else {
                                                            $url_media_file = "../viewer/content/$media_file";
                                                        }
                                                    }
                                                    preg_match($pattern, $url_media_file, $matches);
                                                    if (isset($matches[1])) {
                                                        switch($matches[1]) {
                                                            case 'mp4':
                                                            case 'webm':
                                                                $display_image = "none";
                                                                $display_video = "block";
                                                                break;
                                                            default:
                                                                break;
                                                        }
                                                    }
                                                    ?>
                                                    <input id="media_file_<?php echo $lang; ?>" type="hidden" value="<?php echo $media_file; ?>" />
                                                    <img style="width:100%;height:250px;object-fit:contain;display:<?php echo $display_image; ?>" src="<?php echo $url_media_file; ?>" />
                                                    <video style="width:100%;height:250px;object-fit:contain;display:<?php echo $display_video; ?>">
                                                        <source src="<?php echo $url_media_file; ?>" type="video/<?php echo $matches[1]; ?>">
                                                    </video>
                                                </div>
                                            <?php endif;
                                        } ?>
                                        <div style="display: none" id="div_delete_media" class="col-md-12 mt-2">
                                            <button <?php echo ($demo) ? 'disabled':''; ?> onclick="delete_media();" class="btn btn-block btn-danger"><?php echo _("REMOVE FILE"); ?></button>
                                        </div>
                                        <div style="display: none" class="col-md-12" id="div_upload_media">
                                            <?php if($upload_content) : ?>
                                                <form id="frm_m" action="ajax/upload_media_file.php" method="POST" enctype="multipart/form-data">
                                                    <div class="row">
                                                        <div class="col-md-12">
                                                            <div class="input-group">
                                                                <div class="custom-file">
                                                                    <input type="file" class="custom-file-input" id="txtFile_m" name="txtFile_m" />
                                                                    <label class="custom-file-label" for="txtFile_m"><?php echo _("Choose file"); ?></label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-12">
                                                            <div class="form-group">
                                                                <input <?php echo ($demo || $disabled_upload) ? 'disabled':''; ?> type="submit" class="btn btn-block btn-success" id="btnUpload_m" value="<?php echo _("Upload Media File"); ?>" />
                                                            </div>
                                                        </div>
                                                        <div class="col-md-12">
                                                            <div class="preview text-center">
                                                                <div class="progress progress_m" style="height: 2.35rem;display:none;">
                                                                    <div class="progress-bar" id="progressBar_m" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="width:0%;">
                                                                        0%
                                                                    </div>
                                                                </div>
                                                                <div style="display: none;padding: .38rem;" class="alert alert-danger" id="error_m"></div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </form>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fas fa-times"></i> <?php echo _("Close"); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="modal_location_content" class="modal" tabindex="-1" role="dialog" data-backdrop="static">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-body">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="location_title"><?php echo _("Title"); ?></label><?php echo print_language_input_selector($array_languages,$default_language,'location_title'); ?>
                                                <input oninput="change_location_title();" onchange="change_location_title();" id="location_title" type="text" class="form-control" value="<?php echo $ui_style['controls']['location']['label']; ?>">
                                                <?php foreach ($array_languages as $lang) {
                                                    if($lang!=$default_language) : ?>
                                                        <input style="display:none;" type="text" class="form-control input_lang" data-target-id="location_title" data-lang="<?php echo $lang; ?>" value="<?php echo $array_input_lang[$lang]['location_title']; ?>" />
                                                    <?php endif;
                                                } ?>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <?php
                                            $location_content = $virtual_tour['location_content'];
                                            $location_content_split = explode("|",$location_content);
                                            ?>
                                            <div style="margin-bottom: 5px;" class="form-group">
                                                <label><?php echo _("Map Embed Code / Link"); ?></label><?php echo print_language_input_selector($array_languages,$default_language,'gm_map'); ?>
                                                <textarea rows="4" id="gm_map" class="form-control"><?php echo $location_content_split[0]; ?></textarea>
                                                <?php foreach ($array_languages as $lang) {
                                                    if($lang!=$default_language) : ?>
                                                        <textarea style="display:none;" rows="4" id="gm_map_<?php echo $lang; ?>" class="form-control input_lang" data-target-id="gm_map" data-lang="<?php echo $lang; ?>"><?php echo explode("|",$array_input_lang[$lang]['location_content'])[0]; ?></textarea>
                                                    <?php endif;
                                                } ?>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div style="margin-bottom: 5px;" class="form-group">
                                                <label><?php echo _("Street View Embed Code / Link"); ?></label><?php echo print_language_input_selector($array_languages,$default_language,'gm_street'); ?>
                                                <textarea rows="4" id="gm_street" class="form-control"><?php echo $location_content_split[1]; ?></textarea>
                                                <?php foreach ($array_languages as $lang) {
                                                    if($lang!=$default_language) : ?>
                                                        <textarea style="display:none;" rows="4" id="gm_street_<?php echo $lang; ?>" class="form-control input_lang" data-target-id="gm_street" data-lang="<?php echo $lang; ?>"><?php echo explode("|",$array_input_lang[$lang]['location_content'])[1]; ?></textarea>
                                                    <?php endif;
                                                } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fas fa-times"></i> <?php echo _("Close"); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="modal_default_markers_style" class="modal" tabindex="-1" role="dialog" data-backdrop="static">
                        <div style="max-width:1100px;" class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-body">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="markers_style"><?php echo _("Type"); ?></label>
                                                <select onchange="change_marker_style_v()" id="markers_style" class="form-control form-control-sm">
                                                    <option <?php echo ($virtual_tour['markers_show_room']==1) ? 'selected' : '' ;  ?> id="icon_and_room"><?php echo _("Icon + Room's Name"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_show_room']==2) ? 'selected' : '' ;  ?> id="room_and_icon"><?php echo _("Room's Name + Icon"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_show_room']==6) ? 'selected' : '' ;  ?> id="icon_and_label"><?php echo _("Icon + Label"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_show_room']==7) ? 'selected' : '' ;  ?> id="label_and_icon"><?php echo _("Label + Icon"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_show_room']==0) ? 'selected' : '' ;  ?> id="only_icon"><?php echo _("Icon"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_show_room']==3) ? 'selected' : '' ;  ?> id="only_room"><?php echo _("Room's Name"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_show_room']==8) ? 'selected' : '' ;  ?> id="only_label"><?php echo _("Label"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_show_room']==4) ? 'selected' : '' ;  ?> id="custom_icon"><?php echo _("Custom Icons Library"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_show_room']==5) ? 'selected' : '' ;  ?> id="preview_room"><?php echo _("Preview Room"); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="markers_icon_type"><?php echo _("Style"); ?></label>
                                                <select onchange="change_marker_style_v();" id="markers_icon_type" class="form-control form-control-sm">
                                                    <option <?php echo ($virtual_tour['markers_icon_type']=='round') ? 'selected' : ''; ?> id="round"><?php echo _("Round"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_icon_type']=='square') ? 'selected' : ''; ?> id="square"><?php echo _("Square"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_icon_type']=='round_outline') ? 'selected' : ''; ?> id="round_outline"><?php echo _("Round (outline)"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_icon_type']=='square_outline') ? 'selected' : ''; ?> id="square_outline"><?php echo _("Square (outline)"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_icon_type']=='stroke') ? 'selected' : ''; ?> id="stroke"><?php echo _("Stroke"); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="markers_icon"><?php echo _("Icon"); ?></label><br>
                                                <div id="m_icon">
                                                    <button class="btn btn-sm btn-primary" type="button" id="GetIconPicker_p" data-iconpicker-input="input#markers_icon" data-iconpicker-preview="i#markers_icon_preview"><?php echo _("Select Icon"); ?></button>
                                                    <input readonly type="hidden" id="markers_icon" name="Icon" value="<?php echo $virtual_tour['markers_icon']; ?>" required="" placeholder="" autocomplete="off" spellcheck="false">
                                                    <div style="vertical-align: middle;" class="icon-preview d-inline-block ml-1" data-toggle="tooltip" title="">
                                                        <i style="font-size: 24px;" id="markers_icon_preview" class="<?php echo $virtual_tour['markers_icon']; ?>"></i>
                                                    </div>
                                                </div>
                                                <div id="m_custom_icon">
                                                    <button onclick="open_modal_library_icons_markers();" class="btn btn-sm btn-primary" type="button" id="btn_library_icon_markers"><?php echo _("Select Library Icon"); ?></button>
                                                    <input type="hidden" id="marker_library_icon" value="<?php echo $virtual_tour['markers_id_icon_library']; ?>" /><?php
                                                    if(!empty($virtual_tour['markers_image_icon_library'])) {
                                                        $tmp = explode('.',$virtual_tour['markers_image_icon_library']);
                                                        $ext = strtolower(end($tmp));
                                                        if($ext=='json') {
                                                            $show_icon_j = true;
                                                            $show_icon_i = false;
                                                        } else {
                                                            $show_icon_j = false;
                                                            $show_icon_i = true;
                                                        }
                                                    } else {
                                                        $show_icon_j = false;
                                                        $show_icon_i = true;
                                                    }
                                                    ?>
                                                    <img id="marker_library_icon_preview" style="height:30px;<?php echo ($virtual_tour['markers_id_icon_library']==0 || !$show_icon_i || empty($virtual_tour['markers_image_icon_library'])) ? 'display:none;' : '' ;  ?>" src="<?php echo $markers_image_icon_library; ?>" />
                                                    <div id="marker_library_icon_preview_l" style="height:30px;vertical-align:middle;<?php echo ($virtual_tour['markers_id_icon_library']==0 || !$show_icon_j || empty($virtual_tour['markers_image_icon_library'])) ? 'display:none;' : 'display:inline-block;' ;  ?>"></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="markers_animation"><?php echo _("Animation"); ?></label>
                                                <select onchange="change_marker_animation_vt();" id="markers_animation" class="form-control form-control-sm">
                                                    <option <?php echo ($virtual_tour['markers_animation']=='none') ? 'selected' : '' ;  ?> id="none"><?php echo _("None"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_animation']=='bounce') ? 'selected' : '' ;  ?> id="bounce"><?php echo _("Bounce"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_animation']=='flash') ? 'selected' : '' ;  ?> id="flash"><?php echo _("Flash"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_animation']=='rubberBand') ? 'selected' : '' ;  ?> id="rubberBand"><?php echo _("Rubberband"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_animation']=='shakeX') ? 'selected' : '' ;  ?> id="shakeX"><?php echo _("Shake X"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_animation']=='shakeY') ? 'selected' : '' ;  ?> id="shakeY"><?php echo _("Shake Y"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_animation']=='swing') ? 'selected' : '' ;  ?> id="swing"><?php echo _("Swing"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_animation']=='tada') ? 'selected' : '' ;  ?> id="tada"><?php echo _("Tada"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_animation']=='wobble') ? 'selected' : '' ;  ?> id="wobble"><?php echo _("Wobble"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_animation']=='jello') ? 'selected' : '' ;  ?> id="jello"><?php echo _("Jello"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_animation']=='heartBeat') ? 'selected' : '' ;  ?> id="heartBeat"><?php echo _("Heartbeat"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_animation']=='flip') ? 'selected' : '' ;  ?> id="flip"><?php echo _("Flip"); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="markers_color"><?php echo _("Color"); ?></label>
                                                <input type="text" id="markers_color" class="form-control form-control-sm" value="<?php echo $virtual_tour['markers_color']; ?>" />
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="markers_background"><?php echo _("Background"); ?></label>
                                                <input type="text" id="markers_background" class="form-control form-control-sm" value="<?php echo $virtual_tour['markers_background']; ?>" />
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="markers_tooltip_type"><?php echo _("Tooltip Type"); ?></label>
                                                <select onchange="change_tooltip_type_m_vt();" id="markers_tooltip_type" class="form-control form-control-sm">
                                                    <option <?php echo ($virtual_tour['markers_tooltip_type']=='none') ? 'selected' : '' ;  ?> id="none"><?php echo _("None"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_tooltip_type']=='room_name') ? 'selected' : '' ;  ?> id="room_name"><?php echo _("Target Room's Name"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_tooltip_type']=='preview') ? 'selected' : '' ;  ?> id="preview"><?php echo _("Target Room's Preview (Rounded)"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_tooltip_type']=='preview_square') ? 'selected' : '' ;  ?> id="preview_square"><?php echo _("Target Room's Preview (Squared)"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_tooltip_type']=='preview_rect') ? 'selected' : '' ;  ?> id="preview_rect"><?php echo _("Target Room's Preview (Rectangular)"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_tooltip_type']=='text') ? 'selected' : '' ;  ?> id="text"><?php echo _("Custom Text"); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="markers_tooltip_visibility"><?php echo _("Tooltip Visibility"); ?></label>
                                                <select id="markers_tooltip_visibility" class="form-control form-control-sm">
                                                    <option <?php echo ($virtual_tour['markers_tooltip_visibility']=='hover') ? 'selected' : '' ;  ?> id="hover"><?php echo _("Hover (Desktop)"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_tooltip_visibility']=='visible') ? 'selected' : '' ;  ?> id="visible"><?php echo _("Always (Desktop - Mobile)"); ?></option>
                                                    <option <?php echo ($virtual_tour['markers_tooltip_visibility']=='visible_mobile') ? 'selected' : '' ;  ?> id="visible_mobile"><?php echo _("Hover (Desktop) - Always (Mobile)"); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="markers_tooltip_background"><?php echo _("Tooltip Background"); ?></label>
                                                <input type="text" id="markers_tooltip_background" class="form-control form-control-sm" value="<?php echo $virtual_tour['markers_tooltip_background']; ?>" />
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="markers_tooltip_color"><?php echo _("Tooltip Color"); ?></label>
                                                <input type="text" id="markers_tooltip_color" class="form-control form-control-sm" value="<?php echo $virtual_tour['markers_tooltip_color']; ?>" />
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <label for="markers_default_sound"><?php echo _("Sound"); ?> <i title="<?php echo _("sound file must be uploaded into sound library."); ?>" class="help_t fas fa-question-circle"></i></label><br>
                                            <div class="input-group">
                                                <select id="markers_default_sound" class="form-control form-control-sm">
                                                    <option id=""><?php echo _("No Sound"); ?></option>
                                                    <?php echo get_option_exist_sound($_SESSION['id_user'],$id_virtualtour_sel,$virtual_tour['markers_default_sound']); ?>
                                                </select>
                                                <div class="input-group-append">
                                                    <button onclick="play_sound('markers_default_sound');" class="btn btn-sm btn-outline-secondary" type="button"><i class="fas fa-play"></i></button>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <label for="markers_default_scale"><?php echo _("Scale"); ?></label><br>
                                                <input type="checkbox" id="markers_default_scale" <?php echo ($virtual_tour['markers_default_scale']) ? 'checked' : ''; ?> />
                                            </div>
                                        </div>
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <label for="markers_default_sticky"><?php echo _("Sticky"); ?></label><br>
                                                <input type="checkbox" id="markers_default_sticky" <?php echo ($virtual_tour['markers_default_sticky']) ? 'checked' : ''; ?> />
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label><?php echo _("Perspective"); ?> <i style="font-size:12px;" id="markers_default_perspective_values">(<?php echo $virtual_tour['markers_default_rotateX']; ?>,<?php echo $virtual_tour['markers_default_rotateZ']; ?>)</i></label><br>
                                                <input oninput="change_default_perspective_m();" type="range" min="0" max="70" step="1" class="form-control-range" id="markers_default_rotateX" value="<?php echo $virtual_tour['markers_default_rotateX']; ?>">
                                                <input oninput="change_default_perspective_m();" type="range" min="-180" max="180" step="1" class="form-control-range" id="markers_default_rotateZ" value="<?php echo $virtual_tour['markers_default_rotateZ']; ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label><?php echo _("Size"); ?> <i style="font-size:12px;" id="markers_default_size_values">(<?php echo $virtual_tour['markers_default_size_scale']; ?>)</i></label>
                                                <input oninput="change_default_size_m();" type="range" step="0.1" min="0.5" max="2.0" class="form-control-range" id="markers_default_size_scale" value="<?php echo $virtual_tour['markers_default_size_scale']; ?>">
                                            </div>
                                        </div>
                                        <?php
                                        switch($virtual_tour['markers_icon_type']) {
                                            case 'round':
                                                $markers_style_icon_type = "";
                                                break;
                                            case 'square':
                                                $markers_style_icon_type = "border-radius:3px;";
                                                break;
                                            case 'round_outline':
                                                $markers_style_icon_type = "border:2px solid ".$virtual_tour['pois_color'].";";
                                                break;
                                            case 'square_outline':
                                                $markers_style_icon_type = "border:2px solid ".$virtual_tour['pois_color'].";border-radius:3px;";
                                                break;
                                            case 'stroke':
                                                $markers_style_icon_type = "background-color:transparent;border:none;";
                                                break;
                                        }
                                        ?>
                                        <div id="marker_preview_div" class="col-md-12">
                                            <div class="form-group">
                                                <label for="marker_final_preview"><?php echo _("Preview"); ?></label><br>
                                                <div style="background:lightgray;padding:25px 5px;" id="marker_icon_and_room" class="marker_final_preview <?php echo ($virtual_tour['markers_show_room']==1) ? '' : 'd-none' ;  ?>">
                                                    <div class="pnlm-hotspot-base animate__animated animate__slow animate__infinite animate__<?php echo $virtual_tour['markers_animation']; ?> custom-hotspot noselect pnlm-pointer" draggable="false" style="visibility:visible;position:relative;cursor:default;width:fit-content;margin:0 auto;transform:scale(<?php echo $virtual_tour['markers_default_size_scale']; ?>) perspective(500px) rotateX(<?php echo $virtual_tour['markers_default_rotateX']; ?>deg) rotateZ(<?php echo $virtual_tour['markers_default_rotateZ']; ?>deg);">
                                                        <div class="div_marker_wrapper div_marker_wrapper_bg" style="background-color: <?php echo $virtual_tour['markers_background']; ?>;<?php echo $markers_style_icon_type; ?>">
                                                            <i class="<?php echo $virtual_tour['markers_icon']; ?>" style="margin: 0px auto; vertical-align: middle; font-size: 24px; color: <?php echo $virtual_tour['markers_color']; ?>;"></i>
                                                            <span style="vertical-align: middle; color: <?php echo $virtual_tour['markers_color']; ?>;">&nbsp;<?php echo _('ROOM NAME'); ?></span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div style="background:lightgray;padding:25px 5px;" id="marker_label_and_icon" class="marker_final_preview <?php echo ($virtual_tour['markers_show_room']==7) ? '' : 'd-none' ;  ?>">
                                                    <div class="pnlm-hotspot-base animate__animated animate__slow animate__infinite animate__<?php echo $virtual_tour['markers_animation']; ?> custom-hotspot noselect pnlm-pointer" draggable="false" style="visibility:visible;position:relative;cursor:default;width:fit-content;margin:0 auto;transform:scale(<?php echo $virtual_tour['markers_default_size_scale']; ?>) perspective(500px) rotateX(<?php echo $virtual_tour['markers_default_rotateX']; ?>deg) rotateZ(<?php echo $virtual_tour['markers_default_rotateZ']; ?>deg);">
                                                        <div class="div_marker_wrapper div_marker_wrapper_bg" style="background-color: <?php echo $virtual_tour['markers_background']; ?>;<?php echo $markers_style_icon_type; ?>">
                                                            <span style="vertical-align: middle; color: <?php echo $virtual_tour['markers_color']; ?>;"><?php echo _('LABEL'); ?>&nbsp;</span>
                                                            <i class="<?php echo $virtual_tour['markers_icon']; ?>" style="margin: 0px auto; vertical-align: middle; font-size: 24px; color: <?php echo $virtual_tour['markers_color']; ?>;"></i>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div style="background:lightgray;padding:25px 5px;" id="marker_icon_and_label" class="marker_final_preview <?php echo ($virtual_tour['markers_show_room']==6) ? '' : 'd-none' ;  ?>">
                                                    <div class="pnlm-hotspot-base animate__animated animate__slow animate__infinite animate__<?php echo $virtual_tour['markers_animation']; ?> custom-hotspot noselect pnlm-pointer" draggable="false" style="visibility:visible;position:relative;cursor:default;width:fit-content;margin:0 auto;transform:scale(<?php echo $virtual_tour['markers_default_size_scale']; ?>) perspective(500px) rotateX(<?php echo $virtual_tour['markers_default_rotateX']; ?>deg) rotateZ(<?php echo $virtual_tour['markers_default_rotateZ']; ?>deg);">
                                                        <div class="div_marker_wrapper div_marker_wrapper_bg" style="background-color: <?php echo $virtual_tour['markers_background']; ?>;<?php echo $markers_style_icon_type; ?>">
                                                            <i class="<?php echo $virtual_tour['markers_icon']; ?>" style="margin: 0px auto; vertical-align: middle; font-size: 24px; color: <?php echo $virtual_tour['markers_color']; ?>;"></i>
                                                            <span style="vertical-align: middle; color: <?php echo $virtual_tour['markers_color']; ?>;">&nbsp;<?php echo _('LABEL'); ?></span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div style="background:lightgray;padding:25px 5px;" id="marker_room_and_icon" class="marker_final_preview <?php echo ($virtual_tour['markers_show_room']==2) ? '' : 'd-none' ;  ?>">
                                                    <div class="pnlm-hotspot-base animate__animated animate__slow animate__infinite animate__<?php echo $virtual_tour['markers_animation']; ?> custom-hotspot noselect pnlm-pointer" draggable="false" style="visibility:visible;position:relative;cursor:default;width:fit-content;margin:0 auto;transform:scale(<?php echo $virtual_tour['markers_default_size_scale']; ?>) perspective(500px) rotateX(<?php echo $virtual_tour['markers_default_rotateX']; ?>deg) rotateZ(<?php echo $virtual_tour['markers_default_rotateZ']; ?>deg);">
                                                        <div class="div_marker_wrapper div_marker_wrapper_bg" style="background-color: <?php echo $virtual_tour['markers_background']; ?>;<?php echo $markers_style_icon_type; ?>">
                                                            <span style="vertical-align: middle; color: <?php echo $virtual_tour['markers_color']; ?>;"><?php echo _('ROOM NAME'); ?>&nbsp;</span>
                                                            <i class="<?php echo $virtual_tour['markers_icon']; ?>" style="margin: 0px auto; vertical-align: middle; font-size: 24px; color: <?php echo $virtual_tour['markers_color']; ?>;"></i>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div style="background:lightgray;padding:25px 5px;" id="marker_only_icon" class="marker_final_preview <?php echo ($virtual_tour['markers_show_room']==0) ? '' : 'd-none' ;  ?>">
                                                    <div class="pnlm-hotspot-base animate__animated animate__slow animate__infinite animate__<?php echo $virtual_tour['markers_animation']; ?> custom-hotspot noselect pnlm-pointer" draggable="false" style="visibility:visible;position:relative;cursor:default;width:41px;margin:0 auto;transform:scale(<?php echo $virtual_tour['markers_default_size_scale']; ?>) perspective(500px) rotateX(<?php echo $virtual_tour['markers_default_rotateX']; ?>deg) rotateZ(<?php echo $virtual_tour['markers_default_rotateZ']; ?>deg);">
                                                        <div class="div_marker_wrapper div_marker_wrapper_bg" style="background-color: <?php echo $virtual_tour['markers_background']; ?>;<?php echo $markers_style_icon_type; ?>">
                                                            <i class="<?php echo $virtual_tour['markers_icon']; ?>" style="margin: 0px auto; vertical-align: middle; font-size: 24px; color: <?php echo $virtual_tour['markers_color']; ?>;"></i>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div style="background:lightgray;padding:25px 5px;" id="marker_only_room" class="marker_final_preview <?php echo ($virtual_tour['markers_show_room']==3) ? '' : 'd-none' ;  ?>">
                                                    <div class="pnlm-hotspot-base animate__animated animate__slow animate__infinite animate__<?php echo $virtual_tour['markers_animation']; ?> custom-hotspot noselect pnlm-pointer" draggable="false" style="visibility:visible;position:relative;cursor:default;width:fit-content;margin:0 auto;transform:scale(<?php echo $virtual_tour['markers_default_size_scale']; ?>) perspective(500px) rotateX(<?php echo $virtual_tour['markers_default_rotateX']; ?>deg) rotateZ(<?php echo $virtual_tour['markers_default_rotateZ']; ?>deg);">
                                                        <div class="div_marker_wrapper div_marker_wrapper_bg" style="background-color: <?php echo $virtual_tour['markers_background']; ?>;<?php echo $markers_style_icon_type; ?>">
                                                            <span style="vertical-align: middle; color: <?php echo $virtual_tour['markers_color']; ?>;"><?php echo _('ROOM NAME'); ?></span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div style="background:lightgray;padding:25px 5px;" id="marker_only_label" class="marker_final_preview <?php echo ($virtual_tour['markers_show_room']==8) ? '' : 'd-none' ;  ?>">
                                                    <div class="pnlm-hotspot-base animate__animated animate__slow animate__infinite animate__<?php echo $virtual_tour['markers_animation']; ?> custom-hotspot noselect pnlm-pointer" draggable="false" style="visibility:visible;position:relative;cursor:default;width:fit-content;margin:0 auto;transform:scale(<?php echo $virtual_tour['markers_default_size_scale']; ?>) perspective(500px) rotateX(<?php echo $virtual_tour['markers_default_rotateX']; ?>deg) rotateZ(<?php echo $virtual_tour['markers_default_rotateZ']; ?>deg);">
                                                        <div class="div_marker_wrapper div_marker_wrapper_bg" style="background-color: <?php echo $virtual_tour['markers_background']; ?>;<?php echo $markers_style_icon_type; ?>">
                                                            <span style="vertical-align: middle; color: <?php echo $virtual_tour['markers_color']; ?>;"><?php echo _('LABEL'); ?></span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div style="background:lightgray;padding:25px 5px;" id="marker_custom_icon" class="marker_final_preview <?php echo ($virtual_tour['markers_show_room']==4) ? '' : 'd-none' ;  ?>">
                                                    <div class="pnlm-hotspot-base animate__animated animate__slow animate__infinite animate__<?php echo $virtual_tour['markers_animation']; ?> custom-hotspot noselect pnlm-pointer" draggable="false" style="visibility:visible;position:relative;cursor:default;width:fit-content;margin:0 auto;transform:scale(<?php echo $virtual_tour['markers_default_size_scale']; ?>) perspective(500px) rotateX(<?php echo $virtual_tour['markers_default_rotateX']; ?>deg) rotateZ(<?php echo $virtual_tour['markers_default_rotateZ']; ?>deg);">
                                                        <div class="div_marker_wrapper" style="padding:0;">
                                                            <?php
                                                            if(!empty($virtual_tour['markers_image_icon_library'])) {
                                                                $tmp = explode('.',$virtual_tour['markers_image_icon_library']);
                                                                $ext = strtolower(end($tmp));
                                                                if(empty($virtual_tour['markers_image_icon_library'])) { $marker_image_icon = "data:image/jpeg;base64,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"; } else { $marker_image_icon = (($s3_enabled) ? $s3_url : '../')."viewer/icons/".$virtual_tour['markers_image_icon_library']; }
                                                                if($ext=='json') { $lottie_marker = true; } else { $lottie_marker = false; }
                                                            } else {
                                                                $lottie_marker = false;
                                                            }
                                                            ?>
                                                            <img class="<?php echo ($lottie_marker) ? 'd-none' : ''; ?>" src="<?php echo $marker_image_icon; ?>" draggable="false" style="width: 50px;">
                                                            <div id="marker_lottie_pewview" class="<?php echo ($lottie_marker) ? '' : 'd-none'; ?>" style="height:50px;vertical-align:middle;"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div style="background:lightgray;padding:25px 5px;" id="marker_preview_room" class="marker_final_preview <?php echo ($virtual_tour['markers_show_room']==5) ? '' : 'd-none' ;  ?>">
                                                    <div class="pnlm-hotspot-base custom-hotspot noselect pnlm-pointer" draggable="false" style="visibility:visible;position:relative;cursor:default;width:fit-content;margin:0 auto;transform:scale(<?php echo $virtual_tour['markers_default_size_scale']; ?>) perspective(500px) rotateX(<?php echo $virtual_tour['markers_default_rotateX']; ?>deg) rotateZ(<?php echo $virtual_tour['markers_default_rotateZ']; ?>deg);">
                                                        <div class="div_marker_wrapper marker_preview" style="padding:0;">
                                                            <div style="width: 48px; height: 48px; border-top-left-radius: 48px; border-top-right-radius: 48px; border-bottom-right-radius: 48px; border-bottom-left-radius: 48px; background-image: url('data:image/jpeg;base64,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'); background-size: cover; background-position: center center;"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button data-toggle="modal" data-target="#modal_markers_style_apply" id="btn_markers_style_apply" class="btn btn-primary mr-auto <?php echo ($demo) ? 'disabled_d':''; ?>"><i class="fas fa-check-double"></i> <?php echo _("Apply to all"); ?></button>
                                    <button type="button" class="btn btn-success" data-dismiss="modal"><i class="fas fa-check"></i> <?php echo _("Ok"); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="modal_default_pois_style" class="modal" tabindex="-1" role="dialog" data-backdrop="static">
                        <div style="max-width:1100px;" class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-body">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="pois_style"><?php echo _("Type"); ?></label>
                                                <select onchange="change_poi_style_v()" id="pois_style" class="form-control form-control-sm">
                                                    <option <?php echo ($virtual_tour['pois_style']==2) ? 'selected' : '' ;  ?> id="icon_and_label"><?php echo _("Icon + Label"); ?></option>
                                                    <option <?php echo ($virtual_tour['pois_style']==3) ? 'selected' : '' ;  ?> id="label_and_icon"><?php echo _("Label + Icon"); ?></option>
                                                    <option <?php echo ($virtual_tour['pois_style']==0) ? 'selected' : '' ;  ?> id="only_icon"><?php echo _("Icon"); ?></option>
                                                    <option <?php echo ($virtual_tour['pois_style']==4) ? 'selected' : '' ;  ?> id="only_label"><?php echo _("Label"); ?></option>
                                                    <option <?php echo ($virtual_tour['pois_style']==1) ? 'selected' : '' ;  ?> id="custom_icon"><?php echo _("Custom Icons Library"); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="pois_icon_type"><?php echo _("Style"); ?></label>
                                                <select onchange="change_poi_style_v();" id="pois_icon_type" class="form-control form-control-sm">
                                                    <option <?php echo ($virtual_tour['pois_icon_type']=='round') ? 'selected' : ''; ?> id="round"><?php echo _("Round"); ?></option>
                                                    <option <?php echo ($virtual_tour['pois_icon_type']=='square') ? 'selected' : ''; ?> id="square"><?php echo _("Square"); ?></option>
                                                    <option <?php echo ($virtual_tour['pois_icon_type']=='round_outline') ? 'selected' : ''; ?> id="round_outline"><?php echo _("Round (outline)"); ?></option>
                                                    <option <?php echo ($virtual_tour['pois_icon_type']=='square_outline') ? 'selected' : ''; ?> id="square_outline"><?php echo _("Square (outline)"); ?></option>
                                                    <option <?php echo ($virtual_tour['pois_icon_type']=='stroke') ? 'selected' : ''; ?> id="stroke"><?php echo _("Stroke"); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="markers_icon"><?php echo _("Icon"); ?></label><br>
                                                <div id="p_icon">
                                                    <button class="btn btn-sm btn-primary" type="button" id="GetIconPicker" data-iconpicker-input="input#pois_icon" data-iconpicker-preview="i#pois_icon_preview"><?php echo _("Select Icon"); ?></button>
                                                    <input readonly type="hidden" id="pois_icon" name="Icon" value="<?php echo $virtual_tour['pois_icon']; ?>" required="" placeholder="" autocomplete="off" spellcheck="false">
                                                    <div style="vertical-align: middle;" class="icon-preview d-inline-block ml-1" data-toggle="tooltip" title="">
                                                        <i style="font-size: 24px;" id="pois_icon_preview" class="<?php echo $virtual_tour['pois_icon']; ?>"></i>
                                                    </div>
                                                </div>
                                                <div id="p_custom_icon">
                                                    <button onclick="open_modal_library_icons_pois();" class="btn btn-sm btn-primary" type="button" id="btn_library_icon_pois"><?php echo _("Select Library Icon"); ?></button>
                                                    <input type="hidden" id="poi_library_icon" value="<?php echo $virtual_tour['pois_id_icon_library']; ?>" />
                                                    <?php
                                                    if(!empty($virtual_tour['pois_image_icon_library'])) {
                                                        $tmp = explode('.',$virtual_tour['pois_image_icon_library']);
                                                        $ext = strtolower(end($tmp));
                                                        if($ext=='json') {
                                                            $show_icon_j = true;
                                                            $show_icon_i = false;
                                                        } else {
                                                            $show_icon_j = false;
                                                            $show_icon_i = true;
                                                        }
                                                    } else {
                                                        $show_icon_j = false;
                                                        $show_icon_i = true;
                                                    }
                                                    ?>
                                                    <img id="poi_library_icon_preview" style="height:30px;<?php echo ($virtual_tour['pois_id_icon_library']==0 || !$show_icon_i || empty($virtual_tour['pois_image_icon_library'])) ? 'display:none;' : '' ;  ?>" src="<?php echo $pois_image_icon_library; ?>" />
                                                    <div id="poi_library_icon_preview_l" style="height:30px;vertical-align:middle;<?php echo ($virtual_tour['pois_id_icon_library']==0 || !$show_icon_j || empty($virtual_tour['pois_image_icon_library'])) ? 'display:none;' : 'display:inline-block;' ;  ?>"></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="pois_animation"><?php echo _("Animation"); ?></label>
                                                <select onchange="change_poi_animation_vt();" id="pois_animation" class="form-control form-control-sm">
                                                    <option <?php echo ($virtual_tour['pois_animation']=='none') ? 'selected' : '' ;  ?> id="none"><?php echo _("None"); ?></option>
                                                    <option <?php echo ($virtual_tour['pois_animation']=='bounce') ? 'selected' : '' ;  ?> id="bounce"><?php echo _("Bounce"); ?></option>
                                                    <option <?php echo ($virtual_tour['pois_animation']=='flash') ? 'selected' : '' ;  ?> id="flash"><?php echo _("Flash"); ?></option>
                                                    <option <?php echo ($virtual_tour['pois_animation']=='rubberBand') ? 'selected' : '' ;  ?> id="rubberBand"><?php echo _("Rubberband"); ?></option>
                                                    <option <?php echo ($virtual_tour['pois_animation']=='shakeX') ? 'selected' : '' ;  ?> id="shakeX"><?php echo _("Shake X"); ?></option>
                                                    <option <?php echo ($virtual_tour['pois_animation']=='shakeY') ? 'selected' : '' ;  ?> id="shakeY"><?php echo _("Shake Y"); ?></option>
                                                    <option <?php echo ($virtual_tour['pois_animation']=='swing') ? 'selected' : '' ;  ?> id="swing"><?php echo _("Swing"); ?></option>
                                                    <option <?php echo ($virtual_tour['pois_animation']=='tada') ? 'selected' : '' ;  ?> id="tada"><?php echo _("Tada"); ?></option>
                                                    <option <?php echo ($virtual_tour['pois_animation']=='wobble') ? 'selected' : '' ;  ?> id="wobble"><?php echo _("Wobble"); ?></option>
                                                    <option <?php echo ($virtual_tour['pois_animation']=='jello') ? 'selected' : '' ;  ?> id="jello"><?php echo _("Jello"); ?></option>
                                                    <option <?php echo ($virtual_tour['pois_animation']=='heartBeat') ? 'selected' : '' ;  ?> id="heartBeat"><?php echo _("Heartbeat"); ?></option>
                                                    <option <?php echo ($virtual_tour['pois_animation']=='flip') ? 'selected' : '' ;  ?> id="flip"><?php echo _("Flip"); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="pois_color"><?php echo _("Color"); ?></label>
                                                <input type="text" id="pois_color" class="form-control form-control-sm" value="<?php echo $virtual_tour['pois_color']; ?>" />
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="pois_background"><?php echo _("Background"); ?></label>
                                                <input type="text" id="pois_background" class="form-control form-control-sm" value="<?php echo $virtual_tour['pois_background']; ?>" />
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="pois_tooltip_type"><?php echo _("Tooltip Type"); ?></label>
                                                <select onchange="change_tooltip_type_p_vt();" id="pois_tooltip_type" class="form-control form-control-sm">
                                                    <option <?php echo ($virtual_tour['pois_tooltip_type']=='none') ? 'selected' : '' ;  ?> id="none"><?php echo _("None"); ?></option>
                                                    <option <?php echo ($virtual_tour['pois_tooltip_type']=='text') ? 'selected' : '' ;  ?> id="text"><?php echo _("Custom Text"); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="pois_tooltip_visibility"><?php echo _("Tooltip Visibility"); ?></label>
                                                <select id="pois_tooltip_visibility" class="form-control form-control-sm">
                                                    <option <?php echo ($virtual_tour['pois_tooltip_visibility']=='hover') ? 'selected' : '' ;  ?> id="hover"><?php echo _("Hover (Desktop)"); ?></option>
                                                    <option <?php echo ($virtual_tour['pois_tooltip_visibility']=='visible') ? 'selected' : '' ;  ?> id="visible"><?php echo _("Always (Desktop - Mobile)"); ?></option>
                                                    <option <?php echo ($virtual_tour['pois_tooltip_visibility']=='visible_mobile') ? 'selected' : '' ;  ?> id="visible_mobile"><?php echo _("Hover (Desktop) - Always (Mobile)"); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="pois_tooltip_background"><?php echo _("Tooltip Background"); ?></label>
                                                <input type="text" id="pois_tooltip_background" class="form-control form-control-sm" value="<?php echo $virtual_tour['pois_tooltip_background']; ?>" />
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="pois_tooltip_color"><?php echo _("Tooltip Color"); ?></label>
                                                <input type="text" id="pois_tooltip_color" class="form-control form-control-sm" value="<?php echo $virtual_tour['pois_tooltip_color']; ?>" />
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <label for="pois_default_sound"><?php echo _("Sound"); ?> <i title="<?php echo _("sound file must be uploaded into sound library."); ?>" class="help_t fas fa-question-circle"></i></label><br>
                                            <div class="input-group">
                                                <select id="pois_default_sound" class="form-control form-control-sm">
                                                    <option id=""><?php echo _("No Sound"); ?></option>
                                                    <?php echo get_option_exist_sound($_SESSION['id_user'],$id_virtualtour_sel,$virtual_tour['pois_default_sound']); ?>
                                                </select>
                                                <div class="input-group-append">
                                                    <button onclick="play_sound('pois_default_sound');" class="btn btn-sm btn-outline-secondary" type="button"><i class="fas fa-play"></i></button>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <label for="pois_default_scale"><?php echo _("Scale"); ?></label><br>
                                                <input type="checkbox" id="pois_default_scale" <?php echo ($virtual_tour['pois_default_scale']) ? 'checked' : ''; ?> />
                                            </div>
                                        </div>
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <label for="pois_default_sticky"><?php echo _("Sticky"); ?></label><br>
                                                <input type="checkbox" id="pois_default_sticky" <?php echo ($virtual_tour['pois_default_sticky']) ? 'checked' : ''; ?> />
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label><?php echo _("Perspective"); ?> <i style="font-size:12px;" id="pois_default_perspective_values">(<?php echo $virtual_tour['pois_default_rotateX']; ?>,<?php echo $virtual_tour['pois_default_rotateZ']; ?>)</i></label><br>
                                                <input oninput="change_default_perspective_p();" type="range" min="0" max="70" step="1" class="form-control-range" id="pois_default_rotateX" value="<?php echo $virtual_tour['pois_default_rotateX']; ?>">
                                                <input oninput="change_default_perspective_p();" type="range" min="-180" max="180" step="1" class="form-control-range" id="pois_default_rotateZ" value="<?php echo $virtual_tour['pois_default_rotateZ']; ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label><?php echo _("Size"); ?> <i style="font-size:12px;" id="pois_default_size_values">(<?php echo $virtual_tour['pois_default_size_scale']; ?>)</i></label>
                                                <input oninput="change_default_size_p();" type="range" step="0.1" min="0.5" max="2.0" class="form-control-range" id="pois_default_size_scale" value="<?php echo $virtual_tour['pois_default_size_scale']; ?>">
                                            </div>
                                        </div>
                                        <?php
                                        switch($virtual_tour['pois_icon_type']) {
                                            case 'round':
                                                $pois_style_icon_type = "";
                                                break;
                                            case 'square':
                                                $pois_style_icon_type = "border-radius:3px;";
                                                break;
                                            case 'round_outline':
                                                $pois_style_icon_type = "border:2px solid ".$virtual_tour['pois_color'].";";
                                                break;
                                            case 'square_outline':
                                                $pois_style_icon_type = "border:2px solid ".$virtual_tour['pois_color'].";border-radius:3px;";
                                                break;
                                            case 'stroke':
                                                $pois_style_icon_type = "background-color:transparent;border:none;";
                                                break;
                                        }
                                        ?>
                                        <div id="poi_preview_div" class="col-md-12">
                                            <div class="form-group">
                                                <label for="poi_final_preview"><?php echo _("Preview"); ?></label><br>
                                                <div style="background:lightgray;padding:25px 5px;" id="poi_icon_and_label" class="poi_final_preview <?php echo ($virtual_tour['pois_style']==2) ? '' : 'd-none' ;  ?>">
                                                    <div class="pnlm-hotspot-base animate__animated animate__slow animate__infinite animate__<?php echo $virtual_tour['pois_animation']; ?> custom-hotspot-content noselect pnlm-pointer" draggable="false" style="visibility:visible;position:relative;cursor:default;width:fit-content;margin:0 auto;transform:scale(<?php echo $virtual_tour['pois_default_size_scale']; ?>) perspective(500px) rotateX(<?php echo $virtual_tour['pois_default_rotateX']; ?>deg) rotateZ(<?php echo $virtual_tour['pois_default_rotateZ']; ?>deg);">
                                                        <div class="div_poi_wrapper div_poi_wrapper_bg" style="background-color: <?php echo $virtual_tour['pois_background']; ?>;<?php echo $pois_style_icon_type; ?>">
                                                            <i class="<?php echo $virtual_tour['pois_icon']; ?>" style="margin: 0px auto; vertical-align: middle; font-size: 24px; color: <?php echo $virtual_tour['pois_color']; ?>;"></i>
                                                            <span style="vertical-align: middle; color: <?php echo $virtual_tour['pois_color']; ?>;">&nbsp;<?php echo _('POI LABEL'); ?></span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div style="background:lightgray;padding:25px 5px;" id="poi_label_and_icon" class="poi_final_preview <?php echo ($virtual_tour['pois_style']==3) ? '' : 'd-none' ;  ?>">
                                                    <div class="pnlm-hotspot-base animate__animated animate__slow animate__infinite animate__<?php echo $virtual_tour['pois_animation']; ?> custom-hotspot-content noselect pnlm-pointer" draggable="false" style="visibility:visible;position:relative;cursor:default;width:fit-content;margin:0 auto;transform:scale(<?php echo $virtual_tour['pois_default_size_scale']; ?>) perspective(500px) rotateX(<?php echo $virtual_tour['pois_default_rotateX']; ?>deg) rotateZ(<?php echo $virtual_tour['pois_default_rotateZ']; ?>deg);">
                                                        <div class="div_poi_wrapper div_poi_wrapper_bg" style="background-color: <?php echo $virtual_tour['pois_background']; ?>;<?php echo $pois_style_icon_type; ?>">
                                                            <span style="vertical-align: middle; color: <?php echo $virtual_tour['pois_color']; ?>;"><?php echo _('POI LABEL'); ?>&nbsp;</span>
                                                            <i class="<?php echo $virtual_tour['pois_icon']; ?>" style="margin: 0px auto; vertical-align: middle; font-size: 24px; color: <?php echo $virtual_tour['pois_color']; ?>;"></i>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div style="background:lightgray;padding:25px 5px;" id="poi_only_icon" class="poi_final_preview <?php echo ($virtual_tour['pois_style']==0) ? '' : 'd-none' ;  ?>">
                                                    <div class="pnlm-hotspot-base animate__animated animate__slow animate__infinite animate__<?php echo $virtual_tour['pois_animation']; ?> custom-hotspot-content noselect pnlm-pointer" draggable="false" style="visibility:visible;position:relative;cursor:default;width:41px;margin:0 auto;transform:scale(<?php echo $virtual_tour['pois_default_size_scale']; ?>) perspective(500px) rotateX(<?php echo $virtual_tour['pois_default_rotateX']; ?>deg) rotateZ(<?php echo $virtual_tour['pois_default_rotateZ']; ?>deg);">
                                                        <div class="div_poi_wrapper div_poi_wrapper_bg" style="background-color: <?php echo $virtual_tour['pois_background']; ?>;<?php echo $pois_style_icon_type; ?>">
                                                            <i class="<?php echo $virtual_tour['pois_icon']; ?>" style="margin: 0px auto; vertical-align: middle; font-size: 24px; color: <?php echo $virtual_tour['pois_color']; ?>;"></i>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div style="background:lightgray;padding:25px 5px;" id="poi_only_label" class="poi_final_preview <?php echo ($virtual_tour['pois_style']==4) ? '' : 'd-none' ;  ?>">
                                                    <div class="pnlm-hotspot-base animate__animated animate__slow animate__infinite animate__<?php echo $virtual_tour['pois_animation']; ?> custom-hotspot-content noselect pnlm-pointer" draggable="false" style="visibility:visible;position:relative;cursor:default;width:fit-content;margin:0 auto;transform:scale(<?php echo $virtual_tour['pois_default_size_scale']; ?>) perspective(500px) rotateX(<?php echo $virtual_tour['pois_default_rotateX']; ?>deg) rotateZ(<?php echo $virtual_tour['pois_default_rotateZ']; ?>deg);">
                                                        <div class="div_poi_wrapper div_poi_wrapper_bg" style="background-color: <?php echo $virtual_tour['pois_background']; ?>;<?php echo $pois_style_icon_type; ?>">
                                                            <span style="vertical-align: middle; color: <?php echo $virtual_tour['pois_color']; ?>;"><?php echo _('POI LABEL'); ?></span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div style="background:lightgray;padding:25px 5px;" id="poi_custom_icon" class="poi_final_preview <?php echo ($virtual_tour['pois_style']==1) ? '' : 'd-none' ;  ?>">
                                                    <div class="pnlm-hotspot-base animate__animated animate__slow animate__infinite animate__<?php echo $virtual_tour['pois_animation']; ?> custom-hotspot-content noselect pnlm-pointer" draggable="false" style="visibility:visible;position:relative;cursor:default;width:fit-content;margin:0 auto;transform:scale(<?php echo $virtual_tour['pois_default_size_scale']; ?>) perspective(500px) rotateX(<?php echo $virtual_tour['pois_default_rotateX']; ?>deg) rotateZ(<?php echo $virtual_tour['pois_default_rotateZ']; ?>deg);">
                                                        <div class="div_poi_wrapper" style="padding:0;">
                                                            <?php
                                                            if(!empty($virtual_tour['pois_image_icon_library'])) {
                                                                $tmp = explode('.',$virtual_tour['pois_image_icon_library']);
                                                                $ext = strtolower(end($tmp));
                                                                if(empty($virtual_tour['pois_image_icon_library'])) { $poi_image_icon = "data:image/jpeg;base64,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"; } else { $poi_image_icon = (($s3_enabled) ? $s3_url : '../')."viewer/icons/".$virtual_tour['pois_image_icon_library']; }
                                                                if($ext=='json') { $lottie_poi = true; } else { $lottie_poi = false; }
                                                            } else {
                                                                $lottie_poi = false;
                                                            }
                                                            ?>
                                                            <img class="<?php echo ($lottie_poi) ? 'd-none' : ''; ?>" src="<?php echo $poi_image_icon; ?>" draggable="false" style="width: 50px;">
                                                            <div id="poi_lottie_pewview" class="<?php echo ($lottie_poi) ? '' : 'd-none'; ?>" style="height:50px;vertical-align:middle;"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button data-toggle="modal" data-target="#modal_pois_style_apply" id="btn_pois_style_apply" class="btn btn-primary mr-auto <?php echo ($demo) ? 'disabled_d':''; ?>"><i class="fas fa-check-double"></i> <?php echo _("Apply to all"); ?></button>
                                    <button type="button" class="btn btn-success" data-dismiss="modal"><i class="fas fa-check"></i> <?php echo _("Ok"); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="modal_markers_style_apply" class="modal" tabindex="-1" role="dialog" data-backdrop="static">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title"><?php echo _("Markers Settings"); ?></h5>
                                </div>
                                <div class="modal-body">
                                    <p><?php echo _("Are you sure you want to apply these settings to all existing markers by overwriting them?"); ?></p>
                                    <div class="row">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_marker_style"><?php echo _("Type"); ?></label><br>
                                                <input type="checkbox" id="apply_marker_style" checked />
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_marker_icon"><?php echo _("Icon"); ?></label><br>
                                                <input type="checkbox" id="apply_marker_icon" checked />
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_marker_animation"><?php echo _("Animation"); ?></label><br>
                                                <input type="checkbox" id="apply_marker_animation" checked />
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_marker_color"><?php echo _("Color"); ?></label><br>
                                                <input type="checkbox" id="apply_marker_color" checked />
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_marker_background"><?php echo _("Background"); ?></label><br>
                                                <input type="checkbox" id="apply_marker_background" checked />
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_marker_icon_type"><?php echo _("Style"); ?></label><br>
                                                <input type="checkbox" id="apply_marker_icon_type" checked />
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_marker_tooltip_type"><?php echo _("Tooltip Type"); ?></label><br>
                                                <input type="checkbox" id="apply_marker_tooltip_type" checked />
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_marker_tooltip_visibility"><?php echo _("Tooltip Visibility"); ?></label><br>
                                                <input type="checkbox" id="apply_marker_tooltip_visibility" checked />
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_marker_tooltip_background"><?php echo _("Tooltip Background"); ?></label><br>
                                                <input type="checkbox" id="apply_marker_tooltip_background" checked />
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_marker_tooltip_color"><?php echo _("Tooltip Color"); ?></label><br>
                                                <input type="checkbox" id="apply_marker_tooltip_color" checked />
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_marker_default_sound"><?php echo _("Sound"); ?></label><br>
                                                <input type="checkbox" id="apply_marker_default_sound" />
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_marker_perspective"><?php echo _("Perspective"); ?></label><br>
                                                <input type="checkbox" id="apply_marker_perspective" />
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_marker_size_scale"><?php echo _("Size"); ?></label><br>
                                                <input type="checkbox" id="apply_marker_size_scale" />
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_marker_default_scale"><?php echo _("Scale"); ?></label><br>
                                                <input type="checkbox" id="apply_marker_default_scale" />
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_marker_default_sticky"><?php echo _("Sticky"); ?></label><br>
                                                <input type="checkbox" id="apply_marker_default_sticky" />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button <?php echo ($demo) ? 'disabled':''; ?> onclick="apply_default_styles('markers');" type="button" class="btn btn-success"><i class="fas fa-check"></i> <?php echo _("Yes, Apply"); ?></button>
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fas fa-times"></i> <?php echo _("Close"); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="modal_pois_style_apply" class="modal" tabindex="-1" role="dialog" data-backdrop="static">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title"><?php echo _("POIs Settings"); ?></h5>
                                </div>
                                <div class="modal-body">
                                    <p><?php echo _("Are you sure you want to apply these settings to all existing POIs by overwriting them?"); ?></p>
                                    <div class="row">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_poi_style"><?php echo _("Type"); ?></label><br>
                                                <input type="checkbox" id="apply_poi_style" checked />
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_poi_icon"><?php echo _("Icon"); ?></label><br>
                                                <input type="checkbox" id="apply_poi_icon" checked />
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_poi_animation"><?php echo _("Animation"); ?></label><br>
                                                <input type="checkbox" id="apply_poi_animation" checked />
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_poi_color"><?php echo _("Color"); ?></label><br>
                                                <input type="checkbox" id="apply_poi_color" checked />
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_poi_background"><?php echo _("Background"); ?></label><br>
                                                <input type="checkbox" id="apply_poi_background" checked />
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_poi_icon_type"><?php echo _("Style"); ?></label><br>
                                                <input type="checkbox" id="apply_poi_icon_type" checked />
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_poi_tooltip_type"><?php echo _("Tooltip Type"); ?></label><br>
                                                <input type="checkbox" id="apply_poi_tooltip_type" checked />
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_poi_tooltip_visibility"><?php echo _("Tooltip Visibility"); ?></label><br>
                                                <input type="checkbox" id="apply_poi_tooltip_visibility" checked />
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_poi_tooltip_background"><?php echo _("Tooltip Background"); ?></label><br>
                                                <input type="checkbox" id="apply_poi_tooltip_background" checked />
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_poi_tooltip_color"><?php echo _("Tooltip Color"); ?></label><br>
                                                <input type="checkbox" id="apply_poi_tooltip_color" checked />
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_poi_default_sound"><?php echo _("Sound"); ?></label><br>
                                                <input type="checkbox" id="apply_poi_default_sound" />
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_poi_perspective"><?php echo _("Perspective"); ?></label><br>
                                                <input type="checkbox" id="apply_poi_perspective" />
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_poi_size_scale"><?php echo _("Size"); ?></label><br>
                                                <input type="checkbox" id="apply_poi_size_scale" />
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_poi_default_scale"><?php echo _("Scale"); ?></label><br>
                                                <input type="checkbox" id="apply_poi_default_scale" />
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="apply_poi_default_sticky"><?php echo _("Sticky"); ?></label><br>
                                                <input type="checkbox" id="apply_poi_default_sticky" />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button <?php echo ($demo) ? 'disabled':''; ?> onclick="apply_default_styles('pois');" type="button" class="btn btn-success"><i class="fas fa-check"></i> <?php echo _("Yes, Apply"); ?></button>
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fas fa-times"></i> <?php echo _("Close"); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="modal_library_icons_markers" class="modal" tabindex="-1" role="dialog" data-backdrop="static">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title"><?php echo _("Library Icons"); ?></h5>
                                </div>
                                <div class="modal-body">
                                    <div class="mb-3 <?php echo ($icons_library==0) ? 'd-none' : ''; ?>">
                                        <form action="ajax/upload_icon_image.php" class="dropzone noselect" id="gallery-dropzone-im"></form>
                                    </div>
                                    <div id="list_images_im">
                                        <?php echo get_library_icons_v($id_virtualtour_sel,'marker'); ?>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fas fa-times"></i> <?php echo _("Close"); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="modal_library_icons_pois" class="modal" tabindex="-1" role="dialog" data-backdrop="static">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title"><?php echo _("Library Icons"); ?></h5>
                                </div>
                                <div class="modal-body">
                                    <div class="mb-3 <?php echo ($icons_library==0) ? 'd-none' : ''; ?>">
                                        <form action="ajax/upload_icon_image.php" class="dropzone noselect" id="gallery-dropzone-ip"></form>
                                    </div>
                                    <div id="list_images_ip">
                                        <?php echo get_library_icons_v($id_virtualtour_sel,'poi'); ?>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fas fa-times"></i> <?php echo _("Close"); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="modal_library_icons" class="modal" tabindex="-1" role="dialog" data-backdrop="static">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title"><?php echo _("Library Icons"); ?></h5>
                                </div>
                                <div class="modal-body">
                                    <div class="mb-3 <?php echo ($icons_library==0) ? 'd-none' : ''; ?>">
                                        <form action="ajax/upload_icon_image.php" class="dropzone noselect" id="gallery-dropzone"></form>
                                    </div>
                                    <div id="list_images">
                                        <?php echo get_library_icons($id_virtualtour_sel,'icons'); ?>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fas fa-times"></i> <?php echo _("Close"); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="modal_presets" class="modal" tabindex="-1" role="dialog" data-backdrop="static">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-body">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="presets_editor_ui"><?php echo _("Presets"); ?></label>
                                                <select onchange="change_preset_editor_ui()" id="presets_editor_ui" class="form-control form-control-sm">
                                                    <option data-name="" data-public="0" data-delete="0" data-update="1" id="0"><?php echo _("Add new preset"); ?></option>
                                                    <?php foreach ($presets_editor_ui as $preset) {
                                                        $id_preset = $preset['id'];
                                                        $id_user_preset = $preset['id_user'];
                                                        $name_preset = $preset['name'];
                                                        $public_preset = $preset['public'];
                                                        $delete=0;
                                                        $update=0;
                                                        if($user_role=='administrator') {
                                                            $delete=1;
                                                            $update=1;
                                                        } else if($id_user==$id_user_preset) {
                                                            if($public_preset==0) {
                                                                $delete=1;
                                                            }
                                                            $update=1;
                                                        }
                                                        echo '<option data-name="'.$name_preset.'" data-public="'.$public_preset.'" data-delete="'.$delete.'" data-update="'.$update.'" id="'.$id_preset.'">'.$name_preset.'</option>';
                                                    } ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-<?php echo ($user_role=='administrator') ? '9' : '12'; ?>">
                                            <div class="form-group">
                                                <label for="preset_new_name"><?php echo _("Name"); ?></label>
                                                <input id="preset_new_name" type="text" class="form-control form-control-sm" />
                                            </div>
                                        </div>
                                        <div class="col-md-3 <?php echo ($user_role!='administrator') ? 'd-none' : ''; ?>">
                                            <div class="form-group">
                                                <label for="preset_public"><?php echo _("Public"); ?></label><br>
                                                <input id="preset_public" type="checkbox" />
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <button id="btn_update_preset" onclick="save_vt_ui(true,true,false);" class="btn btn-block btn-success <?php echo ($demo) ? 'disabled_d':''; ?>"><i class="fas fa-save"></i>&nbsp;&nbsp;<?php echo _("ADD / UPDATE"); ?></button>
                                        </div>
                                        <div class="col-md-6">
                                            <button id="btn_delete_preset" class="btn btn-block btn-danger disabled <?php echo ($demo) ? 'disabled_d':''; ?>"><i class="fas fa-trash"></i>&nbsp;&nbsp;<?php echo _("DELETE"); ?></button>
                                        </div>
                                        <div class="col-md-12 mt-2">
                                            <button id="btn_apply_preset" onclick="apply_editor_ui_preset();" class="btn btn-block btn-primary disabled <?php echo ($demo) ? 'disabled_d':''; ?>"><i class="fas fa-check"></i>&nbsp;&nbsp;<?php echo _("APPLY PRESET"); ?></button>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fas fa-times"></i> <?php echo _("Close"); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="modal_versions" class="modal" tabindex="-1" role="dialog" data-backdrop="static">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-body">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="versions_editor_ui"><?php echo _("Versions"); ?></label>
                                                <select onchange="change_version_editor_ui()" id="versions_editor_ui" class="form-control form-control-sm">
                                                    <option data-name="" id="-1"><?php echo _("Add new version"); ?></option>
                                                    <option <?php echo ($id_version_sel==0) ? 'selected' : ''; ?> data-name="<?php echo _("Main"); ?>" id="0"><?php echo _("Main"); ?></option>
                                                    <?php foreach ($vt_versions as $version) {
                                                        $id_version = $version['id'];
                                                        $name_version = $version['version'];
                                                        echo '<option '.(($id_version==$id_version_sel) ? 'selected' : '').' data-name="'.$name_version.'" id="'.$id_version.'">'.$name_version.'</option>';
                                                    } ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="version_new_name"><?php echo _("Name"); ?></label>
                                                <input id="version_new_name" type="text" class="form-control form-control-sm" />
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <button id="btn_add_version" onclick="save_vt_ui(true,false,false,true,true);" class="btn btn-block btn-success <?php echo ($demo) ? 'disabled_d':''; ?>"><i class="fas fa-save"></i>&nbsp;&nbsp;<?php echo _("ADD / UPDATE"); ?></button>
                                        </div>
                                        <div class="col-md-6">
                                            <button id="btn_delete_version" class="btn btn-block btn-danger disabled <?php echo ($demo) ? 'disabled_d':''; ?>"><i class="fas fa-trash"></i>&nbsp;&nbsp;<?php echo _("DELETE"); ?></button>
                                        </div>
                                        <div class="col-md-12 mt-2">
                                            <button id="btn_apply_version" onclick="save_vt_ui(true,false,false,true,false,true);" class="btn btn-block btn-primary disabled <?php echo ($demo) ? 'disabled_d':''; ?>"><i class="fas fa-check"></i>&nbsp;&nbsp;<?php echo _("SWITCH TO THIS VERSION"); ?></button>
                                        </div>
                                        <script>
                                            var id_version_sel = <?php echo $id_version_sel; ?>;
                                            change_version_editor_ui();
                                        </script>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fas fa-times"></i> <?php echo _("Close"); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="editor_toolbar" class="row p-1">
                    <div id="tool_ui" class="col-md-12 d-none">
                        <button onclick="toggle_editor_ui_items();" class="btn btn-sm btn-outline-secondary"><i class="fas fa-list"></i> <?php echo _("UI Item List"); ?></button>
                        <input type="text" class="form-control form-control-sm <?php echo ($settings['font_provider']=='systems') ? 'd-none' : ''; ?>" id="font_viewer" value="<?php echo $virtual_tour['font_viewer']; ?>" />
                        <select onchange="apply_system_font_editor_ui();" class="form-control form-control-sm <?php echo ($settings['font_provider']=='systems') ? '' : 'd-none'; ?>" id="font_viewer_system">
                            <option id="Arial" <?php echo ($settings['font_backend'] === 'Arial') ? 'selected' : ''; ?>>Arial</option>
                            <option id="Helvetica" <?php echo ($settings['font_backend'] === 'Helvetica') ? 'selected' : ''; ?>>Helvetica</option>
                            <option id="Tahoma" <?php echo ($settings['font_backend'] === 'Tahoma') ? 'selected' : ''; ?>>Tahoma</option>
                            <option id="Verdana" <?php echo ($settings['font_backend'] === 'Verdana') ? 'selected' : ''; ?>>Verdana</option>
                            <option id="Geneva" <?php echo ($settings['font_backend'] === 'Geneva') ? 'selected' : ''; ?>>Geneva</option>
                            <option id="Calibri" <?php echo ($settings['font_backend'] === 'Calibri') ? 'selected' : ''; ?>>Calibri</option>
                            <option id="Trebuchet MS" <?php echo ($settings['font_backend'] === 'Trebuchet MS') ? 'selected' : ''; ?>>Trebuchet MS</option>
                            <option id="Times New Roman" <?php echo ($settings['font_backend'] === 'Times New Roman') ? 'selected' : ''; ?>>Times New Roman</option>
                            <option id="Georgia" <?php echo ($settings['font_backend'] === 'Georgia') ? 'selected' : ''; ?>>Georgia</option>
                            <option id="Garamond" <?php echo ($settings['font_backend'] === 'Garamond') ? 'selected' : ''; ?>>Garamond</option>
                            <option id="Book Antiqua" <?php echo ($settings['font_backend'] === 'Book Antiqua') ? 'selected' : ''; ?>>Book Antiqua</option>
                            <option id="Palatino Linotype" <?php echo ($settings['font_backend'] === 'Palatino Linotype') ? 'selected' : ''; ?>>Palatino Linotype</option>
                            <option id="Courier New" <?php echo ($settings['font_backend'] === 'Courier New') ? 'selected' : ''; ?>>Courier New</option>
                            <option id="Lucida Console" <?php echo ($settings['font_backend'] === 'Lucida Console') ? 'selected' : ''; ?>>Lucida Console</option>
                            <option id="Monaco" <?php echo ($settings['font_backend'] === 'Monaco') ? 'selected' : ''; ?>>Monaco</option>
                            <option id="Comic Sans MS" <?php echo ($settings['font_backend'] === 'Comic Sans MS') ? 'selected' : ''; ?>>Comic Sans MS</option>
                            <option id="Bradley Hand" <?php echo ($settings['font_backend'] === 'Bradley Hand') ? 'selected' : ''; ?>>Bradley Hand</option>
                            <option id="Impact" <?php echo ($settings['font_backend'] === 'Impact') ? 'selected' : ''; ?>>Impact</option>
                            <option id="Chalkduster" <?php echo ($settings['font_backend'] === 'Chalkduster') ? 'selected' : ''; ?>>Chalkduster</option>
                        </select>
                        <button onclick="change_marker_style_v();" data-toggle="modal" data-target="#modal_default_markers_style" class="btn btn-sm btn-outline-secondary <?php echo ($edit_version) ? 'disabled_d' : ''; ?>"><i class="fas fa-caret-square-up"></i> <?php echo _("Default Markers Style"); ?></button>
                        <button onclick="change_poi_style_v();" data-toggle="modal" data-target="#modal_default_pois_style" class="btn btn-sm btn-outline-secondary <?php echo ($edit_version) ? 'disabled_d' : ''; ?>"><i class="fas fa-bullseye"></i> <?php echo _("Default POIs Style"); ?></button>
                        <button onclick="open_edit_ui_style();" class="btn btn-sm btn-outline-secondary"><i class="fas fa-palette"></i> <?php echo _("UI Style"); ?></button>
                        <button data-toggle="modal" data-target="#modal_presets" class="btn btn-sm btn-outline-secondary"><i class="fas fa-th-list"></i> <?php echo _("Presets"); ?></button>
                        <button data-toggle="modal" data-target="#modal_versions" class="btn btn-sm btn-outline-secondary"><i class="fas fa-list-1-2"></i> <?php echo _("Version"); ?>: <b id="active_version_name"><?php echo (($edit_version) ? $name_version_sel : _("Main")); ?></b></button>
                        <a id="save_btn" href="#" onclick="save_vt_ui(true,false,false);return false;" class="btn btn-sm btn-success btn-icon-split float-right <?php echo ($demo) ? 'disabled':''; ?>">
                            <span class="icon text-white-50">
                              <i class="far fa-circle"></i>
                            </span>
                            <span class="text text-white"><?php echo _("SAVE"); ?></span>
                        </a>
                        <button onclick="toggle_fullscreen_div('editor_ui_div');" title="<?php echo _("TOGGLE FULLSCREEN"); ?>" id="btn_toggle_fullscreen" class="btn btn-sm btn-primary float-right mr-1"><i class="fas fa-expand"></i></button>
                    </div>
                </div>
                <div style="margin-bottom:-3px;opacity:0;" id="ui_container" class="noselect">
                    <div id="list_editor_ui_items" class="noselect">
                        <ul>
                            <li data-ui-target="ui_edit_menu"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Menu"); ?></li>
                            <li data-ui-target="ui_edit_info"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Info"); ?></li>
                            <li data-ui-target="ui_edit_dollhouse"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("3D View"); ?></li>
                            <li data-ui-target="ui_edit_gallery"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Gallery"); ?></li>
                            <li data-ui-target="ui_edit_facebook"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Facebook Chat"); ?></li>
                            <li data-ui-target="ui_edit_whatsapp"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Whatsapp Chat"); ?></li>
                            <li data-ui-target="ui_edit_orientation"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Device Orientation"); ?></li>
                            <li data-ui-target="ui_edit_vr"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Web VR"); ?></li>
                            <li data-ui-target="ui_edit_icons"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Icons"); ?></li>
                            <li data-ui-target="ui_edit_icons_content"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Content Icons"); ?></li>
                            <li data-ui-target="ui_edit_icons_nav"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Navigation Icons"); ?></li>
                            <li data-ui-target="ui_edit_measures"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Measures"); ?></li>
                            <li data-ui-target="ui_edit_autorotation"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Auto Rotation"); ?></li>
                            <li data-ui-target="ui_edit_annotations"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Annotations"); ?></li>
                            <li data-ui-target="ui_edit_presentation"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Presentation"); ?></li>
                            <li data-ui-target="ui_edit_form"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Main Form"); ?></li>
                            <li data-ui-target="ui_edit_inline_form"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Main Form - Inline"); ?></li>
                            <li data-ui-target="ui_edit_share"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Share"); ?></li>
                            <li data-ui-target="ui_edit_live_session"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Start Live Session"); ?></li>
                            <li data-ui-target="ui_edit_meeting"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Join Meeting"); ?></li>
                            <li data-ui-target="ui_edit_custom"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Custom"); ?> 1 <i><?php echo ($ui_style['controls']['custom']['label']!='Custom 1') ? $ui_style['controls']['custom']['label'] : ''; ?></i></li>
                            <li data-ui-target="ui_edit_custom2"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Custom"); ?> 2 <i><?php echo ($ui_style['controls']['custom2']['label']!='Custom 2') ? $ui_style['controls']['custom2']['label'] : ''; ?></i></li>
                            <li data-ui-target="ui_edit_custom3"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Custom"); ?> 3 <i><?php echo ($ui_style['controls']['custom3']['label']!='Custom 3') ? $ui_style['controls']['custom3']['label'] : ''; ?></i></li>
                            <li data-ui-target="ui_edit_custom4"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Custom"); ?> 4 <i><?php echo ($ui_style['controls']['custom4']['label']!='Custom 4') ? $ui_style['controls']['custom4']['label'] : ''; ?></i></li>
                            <li data-ui-target="ui_edit_custom5"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Custom"); ?> 5 <i><?php echo ($ui_style['controls']['custom5']['label']!='Custom 5') ? $ui_style['controls']['custom5']['label'] : ''; ?></i></li>
                            <li data-ui-target="ui_edit_location"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Location"); ?> <i><?php echo ($ui_style['controls']['location']['label']!='Location') ? $ui_style['controls']['location']['label'] : ''; ?></i></li>
                            <li data-ui-target="ui_edit_media"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Media"); ?> <i><?php echo ($ui_style['controls']['media']['label']!='Media') ? $ui_style['controls']['media']['label'] : ''; ?></i></li>
                            <li data-ui-target="ui_edit_snapshot"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Snapshot"); ?></li>
                            <li data-ui-target="ui_edit_list_alt"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Rooms List Menu"); ?></li>
                            <li data-ui-target="ui_edit_audio"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Audio"); ?></li>
                            <li data-ui-target="ui_edit_title"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Tour Title"); ?></li>
                            <li data-ui-target="ui_edit_multiple_room_views"><i style="color:<?php echo (!$multiple_room_view) ? 'darkorange' : 'darkgreen'; ?>" class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Multiple Room Views"); ?></li>
                            <li data-ui-target="ui_edit_comments"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Comments"); ?></li>
                            <li data-ui-target="ui_edit_fullscreen"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Fullscreen"); ?></li>
                            <li data-ui-target="ui_edit_map"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Floorplan"); ?></li>
                            <li data-ui-target="ui_edit_map_tour"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Map"); ?></li>
                            <li data-ui-target="ui_edit_localization"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Language"); ?></li>
                            <li data-ui-target="ui_edit_logo"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Logo"); ?></li>
                            <li data-ui-target="ui_edit_poweredby"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Powered By - Logo / Text"); ?></li>
                            <li data-ui-target="ui_edit_avatar_video"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Avatar Video"); ?></li>
                            <li data-ui-target="ui_edit_arrows_nav"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Arrows Prev/Next"); ?></li>
                            <li data-ui-target="ui_edit_nav"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Nav Control"); ?></li>
                            <li data-ui-target="ui_edit_slider"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Room's List Slider"); ?></li>
                            <li data-ui-target="ui_edit_voice"><i class="fas fa-circle"></i>&nbsp;&nbsp;<?php echo _("Voice Commands"); ?></li>
                        </ul>
                    </div>
                    <div class="menu_controls noselect">
                        <div class="title"><i title="<?php echo _("Menu"); ?>" onclick="click_menu_controls();" data-ui-target="ui_edit_menu" data-id-color="menu" id="menu_icon" class="fas fa-bars small-element"></i>
                            <div class="arrow"></div>
                        </div>
                        <div class="dropdown">
                            <div id="menu_controls_mt" style="height:5px;order:0;"></div>
                            <p id="song_alt_control_menu" style="order:<?php echo ($ui_style['controls']['song_alt']['order']); ?>" data-ui-target="ui_edit_audio" data-id-color="song_alt" class="song_alt_control <?php echo ($ui_style['controls']['song_alt']['type']=='button' || $ui_style['controls']['song_alt']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_audio']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('audio','list'); ?><i style="<?php echo ($ui_style['controls']['song_alt']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['song_alt']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<?php echo _("Audio"); ?> <i class="fa fa-circle <?php echo ($virtual_tour['song_autoplay']>0) ? 'active':'not_active'; ?>"></i></p>
                            <p id="floorplan_alt_control_menu" style="order:<?php echo ($ui_style['controls']['floorplan_alt']['order']); ?>" data-ui-target="ui_edit_map" data-id-color="floorplan_alt" class="floorplan_alt_control <?php echo ($ui_style['controls']['floorplan_alt']['type']=='button' || $ui_style['controls']['floorplan_alt']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_map']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('floorplan_alt','list'); ?><i style="<?php echo ($ui_style['controls']['floorplan_alt']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['floorplan_alt']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<?php echo _("Floorplan"); ?> <i class="fa fa-circle <?php echo ($virtual_tour['show_map']==3 || $virtual_tour['show_map']==5) ? 'active':'not_active'; ?>"></i></p>
                            <p id="map_alt_control_menu" style="order:<?php echo ($ui_style['controls']['map_alt']['order']); ?>" data-ui-target="ui_edit_map_tour" data-id-color="map_alt" class="map_alt_control <?php echo ($ui_style['controls']['map_alt']['type']=='button' || $ui_style['controls']['map_alt']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_map_tour']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('map_alt','list'); ?><i style="<?php echo ($ui_style['controls']['map_alt']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['map_alt']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<?php echo _("Map"); ?> <i class="fa fa-circle <?php echo ($virtual_tour['show_map_tour']>1) ? 'active':'not_active'; ?>"></i></p>
                            <p id="fullscreen_alt_control_menu" style="order:<?php echo ($ui_style['controls']['fullscreen_alt']['order']); ?>" data-ui-target="ui_edit_fullscreen" data-id-color="fullscreen_alt" class="fullscreen_alt_control <?php echo ($ui_style['controls']['fullscreen_alt']['type']=='button' || $ui_style['controls']['fullscreen_alt']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_fullscreen']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('fullscreen_alt','list'); ?><i style="<?php echo ($ui_style['controls']['fullscreen_alt']['icon_library']!=0) ? 'display:none':''; ?>" class="fas fa-expand"></i>&nbsp;&nbsp;&nbsp;<?php echo _("Fullscreen"); ?></p>
                            <p id="info_control_menu" style="order:<?php echo ($ui_style['controls']['info']['order']); ?>" data-ui-target="ui_edit_info" data-id-color="info" class="info_control <?php echo ($ui_style['controls']['info']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_info']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('info','list'); ?><i style="<?php echo ($ui_style['controls']['info']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['info']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<?php echo _("Info"); ?></p>
                            <p id="dollhouse_control_menu" style="order:<?php echo ($ui_style['controls']['dollhouse']['order']); ?>" data-ui-target="ui_edit_dollhouse" data-id-color="dollhouse" class="dollhouse_control <?php echo ($ui_style['controls']['dollhouse']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_dollhouse']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('dollhouse','list'); ?><i style="<?php echo ($ui_style['controls']['dollhouse']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['dollhouse']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<?php echo _("3D View"); ?></p>
                            <p id="gallery_control_menu" style="order:<?php echo ($ui_style['controls']['gallery']['order']); ?>" data-ui-target="ui_edit_gallery" data-id-color="gallery" class="gallery_control <?php echo ($ui_style['controls']['gallery']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_gallery']==0)?'ui_disabled':''; ?>" ><?php echo print_library_icon('gallery','list'); ?><i style="<?php echo ($ui_style['controls']['gallery']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['gallery']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<?php echo _("Gallery"); ?></p>
                            <p id="facebook_control_menu" style="order:<?php echo ($ui_style['controls']['facebook']['order']); ?>" data-ui-target="ui_edit_facebook" data-id-color="facebook" class="facebook_control <?php echo ($ui_style['controls']['facebook']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['fb_messenger'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('facebook','list'); ?><i style="<?php echo ($ui_style['controls']['facebook']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['facebook']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<?php echo _("Facebook Chat"); ?></p>
                            <p id="whatsapp_control_menu" style="order:<?php echo ($ui_style['controls']['whatsapp']['order']); ?>" data-ui-target="ui_edit_whatsapp" data-id-color="whatsapp" class="whatsapp_control <?php echo ($ui_style['controls']['whatsapp']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['whatsapp_chat'])?'':'ui_disabled'; ?>" onclick=""><?php echo print_library_icon('whatsapp','list'); ?><i style="<?php echo ($ui_style['controls']['whatsapp']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['whatsapp']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<?php echo _("Whatsapp Chat"); ?></p>
                            <p id="orient_control_menu" style="order:<?php echo ($ui_style['controls']['orient']['order']); ?>" data-ui-target="ui_edit_orientation" data-id-color="orient" class="orient_control <?php echo ($ui_style['controls']['orient']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['ar_simulator'])?'hidden_menu':''; ?> <?php echo ($virtual_tour['show_device_orientation']==0) ? 'ui_disabled':''; ?>"><?php echo print_library_icon('orient','list'); ?><i style="<?php echo ($ui_style['controls']['orient']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['orient']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<?php echo _("Device Orientation"); ?> <i class="fa fa-circle <?php echo ($virtual_tour['show_device_orientation']==2) ? 'active':'not_active'; ?>"></i></p>
                            <p id="vr_control_menu" style="order:<?php echo ($ui_style['controls']['vr']['order']); ?>" data-ui-target="ui_edit_vr" data-id-color="vr" class="vr_control <?php echo ($virtual_tour['ar_simulator'])?'hidden_menu':''; ?> <?php echo ($ui_style['controls']['vr']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_webvr'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('vr','list'); ?><i style="<?php echo ($ui_style['controls']['vr']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['vr']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<?php echo _("Web VR"); ?></p>
                            <p id="icons_control_menu" style="order:<?php echo ($ui_style['controls']['icons']['order']); ?>" data-ui-target="ui_edit_icons" data-id-color="icons" class="icons_control active_control <?php echo ($ui_style['controls']['icons']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_icons_toggle']>0 && $virtual_tour['show_icons_content_toggle']==0 && $virtual_tour['show_icons_nav_toggle']==0)?'':'ui_disabled'; ?>"><?php echo print_library_icon('icons','list'); ?><i style="<?php echo ($ui_style['controls']['icons']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['icons']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<?php echo _("Icons"); ?> <i class="fa fa-circle <?php echo ($virtual_tour['show_icons_toggle']==1) ? 'active':'not_active'; ?>"></i></p>
                            <p id="icons_content_control_menu" style="order:<?php echo ($ui_style['controls']['icons_content']['order']); ?>" data-ui-target="ui_edit_icons_content" data-id-color="icons_content" class="icons_content_control active_control <?php echo ($ui_style['controls']['icons_content']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_icons_content_toggle'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('icons_content','list'); ?><i style="<?php echo ($ui_style['controls']['icons_content']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['icons_content']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<?php echo _("Content Icons"); ?> <i class="fa fa-circle <?php echo ($virtual_tour['show_icons_content_toggle']==1) ? 'active':'not_active'; ?>"></i></p>
                            <p id="icons_nav_control_menu" style="order:<?php echo ($ui_style['controls']['icons_nav']['order']); ?>" data-ui-target="ui_edit_icons_nav" data-id-color="icons_nav" class="icons_nav_control active_control <?php echo ($ui_style['controls']['icons_nav']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_icons_nav_toggle'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('icons_nav','list'); ?><i style="<?php echo ($ui_style['controls']['icons_nav']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['icons_nav']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<?php echo _("Navigation Icons"); ?> <i class="fa fa-circle <?php echo ($virtual_tour['show_icons_nav_toggle']==1) ? 'active':'not_active'; ?>"></i></p>
                            <p id="measures_control_menu" style="order:<?php echo ($ui_style['controls']['measures']['order']); ?>" data-ui-target="ui_edit_measures" data-id-color="measures" class="measures_control active_control <?php echo ($ui_style['controls']['measures']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_measures_toggle'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('measures','list'); ?><i style="<?php echo ($ui_style['controls']['measures']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['measures']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<?php echo _("Measures"); ?> <i class="fa fa-circle <?php echo ($virtual_tour['show_measures_toggle']==1) ? 'active':'not_active'; ?>"></i></p>
                            <p id="autorotate_control_menu" style="order:<?php echo ($ui_style['controls']['autorotate']['order']); ?>" data-ui-target="ui_edit_autorotation" data-id-color="autorotate" class="autorotate_control active_control <?php echo ($ui_style['controls']['autorotate']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['ar_simulator'])?'hidden_menu':''; ?> <?php echo ($virtual_tour['show_autorotation_toggle']==0 || $virtual_tour['autorotate_speed']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('autorotate','list'); ?><i style="<?php echo ($ui_style['controls']['autorotate']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['autorotate']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<?php echo _("Auto Rotation"); ?> <i class="fa fa-circle <?php echo (($virtual_tour['show_autorotation_toggle']==1 || $virtual_tour['show_autorotation_toggle']==3) && $virtual_tour['autorotate_speed']!=0) ? 'active':'not_active'; ?>""></i></p>
                            <p id="annotations_control_menu" style="order:<?php echo ($ui_style['controls']['annotations']['order']); ?>" data-ui-target="ui_edit_annotations" data-id-color="annotations" class="annotations_control active_control <?php echo ($ui_style['controls']['annotations']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_annotations'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('annotations','list'); ?><i style="<?php echo ($ui_style['controls']['annotations']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['annotations']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<?php echo _("Annotations"); ?> <i class="fa fa-circle <?php echo ($virtual_tour['show_annotations']==1) ? 'active':'not_active'; ?>"></i></p>
                            <p id="presentation_control_menu" style="order:<?php echo ($ui_style['controls']['presentation']['order']); ?>" data-ui-target="ui_edit_presentation" data-id-color="presentation" class="presentation_control <?php echo ($virtual_tour['ar_simulator'])?'hidden_menu':''; ?> <?php echo ($ui_style['controls']['presentation']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_presentation']==0) ? 'ui_disabled':''; ?>"><?php echo print_library_icon('presentation','list'); ?><i style="<?php echo ($ui_style['controls']['presentation']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['presentation']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<?php echo _("Presentation"); ?></p>
                            <p id="form_control_menu" style="order:<?php echo ($ui_style['controls']['form']['order']); ?>" data-ui-target="ui_edit_form" data-id-color="form" class="form_control <?php echo ($ui_style['controls']['form']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_main_form'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('form','list'); ?><i style="<?php echo ($ui_style['controls']['form']['icon_library']!=0) ? 'display:none':''; ?>" data-ui-target="ui_edit_form" class="<?php echo $ui_style['controls']['form']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<span data-ui-target="ui_edit_form" id="mform_name"><?php echo $form_title; ?></span></p>
                            <p id="share_control_menu" style="order:<?php echo ($ui_style['controls']['share']['order']); ?>" data-ui-target="ui_edit_share" data-id-color="share" class="share_control <?php echo ($ui_style['controls']['share']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_share']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('share','list'); ?><i style="<?php echo ($ui_style['controls']['share']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['share']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<?php echo _("Share"); ?> <i class="fa fa-circle not_active"></i></p>
                            <p id="live_control_menu" style="order:<?php echo ($ui_style['controls']['live']['order']); ?>" data-ui-target="ui_edit_live_session" data-id-color="live" class="live_control <?php echo ($virtual_tour['ar_simulator'])?'hidden_menu':''; ?> <?php echo ($ui_style['controls']['live']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['live_session'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('live','list'); ?><i style="<?php echo ($ui_style['controls']['live']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['live']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<?php echo _("Start Live Session"); ?></p>
                            <p id="meeting_control_menu" style="order:<?php echo ($ui_style['controls']['meeting']['order']); ?>" data-ui-target="ui_edit_meeting" data-id-color="meeting" class="meeting_control <?php echo ($virtual_tour['ar_simulator'])?'hidden_menu':''; ?> <?php echo ($ui_style['controls']['meeting']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['meeting']==0) ? 'ui_disabled':''; ?>"><?php echo print_library_icon('meeting','list'); ?><i style="<?php echo ($ui_style['controls']['meeting']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['meeting']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<span data-ui-target="ui_edit_meeting"><?php echo _("Join Meeting"); ?></span></p>
                            <p id="custom_control_menu" style="order:<?php echo ($ui_style['controls']['custom']['order']); ?>" data-ui-target="ui_edit_custom" data-id-color="custom" class="custom_control <?php echo ($ui_style['controls']['custom']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_custom']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('custom','list'); ?><i style="<?php echo ($ui_style['controls']['custom']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['custom']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<span data-ui-target="ui_edit_custom" id="custom_name"><?php echo $ui_style['controls']['custom']['label']; ?></span></p>
                            <p id="custom2_control_menu" style="order:<?php echo ($ui_style['controls']['custom2']['order']); ?>" data-ui-target="ui_edit_custom2" data-id-color="custom2" class="custom2_control <?php echo ($ui_style['controls']['custom2']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_custom2']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('custom2','list'); ?><i style="<?php echo ($ui_style['controls']['custom2']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['custom2']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<span data-ui-target="ui_edit_custom2" id="custom2_name"><?php echo $ui_style['controls']['custom2']['label']; ?></span></p>
                            <p id="custom3_control_menu" style="order:<?php echo ($ui_style['controls']['custom3']['order']); ?>" data-ui-target="ui_edit_custom3" data-id-color="custom3" class="custom3_control <?php echo ($ui_style['controls']['custom3']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_custom3']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('custom3','list'); ?><i style="<?php echo ($ui_style['controls']['custom3']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['custom3']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<span data-ui-target="ui_edit_custom3" id="custom3_name"><?php echo $ui_style['controls']['custom3']['label']; ?></span></p>
                            <p id="custom4_control_menu" style="order:<?php echo ($ui_style['controls']['custom4']['order']); ?>" data-ui-target="ui_edit_custom4" data-id-color="custom4" class="custom4_control <?php echo ($ui_style['controls']['custom4']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_custom4']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('custom4','list'); ?><i style="<?php echo ($ui_style['controls']['custom4']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['custom4']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<span data-ui-target="ui_edit_custom4" id="custom4_name"><?php echo $ui_style['controls']['custom4']['label']; ?></span></p>
                            <p id="custom5_control_menu" style="order:<?php echo ($ui_style['controls']['custom5']['order']); ?>" data-ui-target="ui_edit_custom5" data-id-color="custom5" class="custom5_control <?php echo ($ui_style['controls']['custom5']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_custom5']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('custom5','list'); ?><i style="<?php echo ($ui_style['controls']['custom5']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['custom5']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<span data-ui-target="ui_edit_custom5" id="custom5_name"><?php echo $ui_style['controls']['custom5']['label']; ?></span></p>
                            <p id="location_control_menu" style="order:<?php echo ($ui_style['controls']['location']['order']); ?>" data-ui-target="ui_edit_location" data-id-color="location" class="location_control <?php echo ($ui_style['controls']['location']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_location']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('location','list'); ?><i style="<?php echo ($ui_style['controls']['location']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['location']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<span data-ui-target="ui_edit_location" id="location_name"><?php echo $ui_style['controls']['location']['label']; ?></span></p>
                            <p id="media_control_menu" style="order:<?php echo ($ui_style['controls']['media']['order']); ?>" data-ui-target="ui_edit_media" data-id-color="media" class="media_control <?php echo ($ui_style['controls']['media']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_media']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('media','list'); ?><i style="<?php echo ($ui_style['controls']['media']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['media']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<span data-ui-target="ui_edit_media" id="media_name"><?php echo $ui_style['controls']['media']['label']; ?></span></p>
                            <p id="snapshot_control_menu" style="order:<?php echo ($ui_style['controls']['snapshot']['order']); ?>" data-ui-target="ui_edit_snapshot" data-id-color="snapshot" class="snapshot_control <?php echo ($ui_style['controls']['snapshot']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_snapshot']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('snapshot','list'); ?><i style="<?php echo ($ui_style['controls']['snapshot']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['snapshot']['icon']; ?>"></i>&nbsp;&nbsp;&nbsp;<span data-ui-target="ui_edit_snapshot"><?php echo _("Snapshot"); ?></span></p>
                            <div id="menu_controls_md" style="height:5px;order:9999;"></div>
                        </div>
                    </div>
                    <div id="menu_sidebar" class="menu_sidebar <?php echo ($ui_style['sidebar']['glass']) ? 'glass' : ''; ?>" data-ui-target="ui_edit_menu" data-id-color="menu_sidebar">
                        <div id="ms_close" class="menu_sidebar" onclick="close_menu_sidebar();">
                            <i class="fas fa-close"></i>
                        </div>
                        <div id="ms_language_switcher" data-ui-target="ui_edit_menu" class="<?php echo ($virtual_tour['show_language']==0 || count($array_languages)<=1)?'ui_disabled':''; ?> <?php echo ($ui_style['controls']['language_alt']['type']=='menu') ? 'ui_hidden' : ''; ?>">
                            <?php
                            include_once("../config/languages.inc.php");
                            if ((!(array_key_exists('en_US', $array_languages) && $array_languages['en_US'] == 1) && (array_key_exists('en_GB', $array_languages) && $array_languages['en_GB'] == 1)) || ((array_key_exists('en_US', $array_languages) && $array_languages['en_US'] == 1) && !(array_key_exists('en_GB', $array_languages) && $array_languages['en_GB'] == 1))) {
                                $languages_list['en_GB']['name'] = "English";
                                $languages_list['en_US']['name'] = "English";
                            }
                            foreach($languages_list as $lang_code => $lang_data) { ?>
                                    <img id="lang_btn_<?php echo $lang_code; ?>" data-ui-target="ui_edit_localization" class="small-element <?php echo (!in_array($lang_code,$array_languages)) ? 'ui_hidden' : ''; ?> <?php echo ($default_language==$lang_code) ? 'active' : ''; ?>" title="<?php echo $lang_data['name']; ?>" src="../viewer/css/flags_lang/<?php echo $lang_code; ?>.png?v=2" />
                            <?php } ?>
                        </div>
                        <div data-ui-target="ui_edit_menu" id="ms_logo" class="<?php echo ($ui_style['sidebar']['logo_height']==0) ? 'ui_hidden' : ''; ?>">
                            <img style="max-height: <?php echo $ui_style['sidebar']['logo_height']; ?>px;" data-ui-target="ui_edit_menu" src="<?php echo $logo; ?>" />
                        </div>
                        <div id="ms_controls" data-ui-target="ui_edit_menu">
                            <div id="info_control_ms" title="<?php echo _("Info"); ?>" data-ui-target="ui_edit_info" data-id-color="info" style="order:<?php echo ($ui_style['controls']['info']['order']); ?>" class="ms_control info_control <?php echo ($ui_style['controls']['info']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_info']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('info','icon'); ?><i style="<?php echo ($ui_style['controls']['info']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['info']['icon']; ?>"></i></div>
                            <div id="song_alt_control_ms" title="<?php echo _("Audio"); ?>" data-ui-target="ui_edit_audio" data-id-color="song_alt" style="order:<?php echo ($ui_style['controls']['song_alt']['order']); ?>" class="ms_control song_alt_control <?php echo ($ui_style['controls']['song_alt']['type']=='button' || $ui_style['controls']['song_alt']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_audio']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('song_alt','icon'); ?><i style="<?php echo ($ui_style['controls']['song_alt']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['song_alt']['icon']; ?>"></i></div>
                            <div id="floorplan_alt_control_ms" title="<?php echo _("Floorplan"); ?>" data-ui-target="ui_edit_map" data-id-color="floorplan_alt" style="order:<?php echo ($ui_style['controls']['floorplan_alt']['order']); ?>" class="ms_control floorplan_alt_control <?php echo ($ui_style['controls']['floorplan_alt']['type']=='button' || $ui_style['controls']['floorplan_alt']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_map']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('floorplan_alt','icon'); ?><i style="<?php echo ($ui_style['controls']['floorplan_alt']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['floorplan_alt']['icon']; ?>"></i></div>
                            <div id="map_alt_control_ms" title="<?php echo _("Map"); ?>" data-ui-target="ui_edit_map_tour" data-id-color="map_alt" style="order:<?php echo ($ui_style['controls']['map_alt']['order']); ?>" class="ms_control map_alt_control <?php echo ($ui_style['controls']['map_alt']['type']=='button' || $ui_style['controls']['map_alt']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_map_tour']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('map_alt','icon'); ?><i style="<?php echo ($ui_style['controls']['map_alt']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['map_alt']['icon']; ?>"></i></div>
                            <div id="fullscreen_alt_control_ms" title="<?php echo _("Fullscreen"); ?>" data-ui-target="ui_edit_fullscreen" data-id-color="fullscreen_alt" style="order:<?php echo ($ui_style['controls']['fullscreen_alt']['order']); ?>" class="ms_control fullscreen_alt_control <?php echo ($ui_style['controls']['fullscreen_alt']['type']=='button' || $ui_style['controls']['fullscreen_alt']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_fullscreen']==0)?'ui_disabled':''; ?>"><i class="fas fa-expand"></i></div>
                            <div id="dollhouse_control_ms" title="<?php echo _("3D View"); ?>" data-ui-target="ui_edit_dollhouse" data-id-color="dollhouse" style="order:<?php echo ($ui_style['controls']['dollhouse']['order']); ?>" class="ms_control dollhouse_control <?php echo ($ui_style['controls']['dollhouse']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_dollhouse']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('dollhouse','icon'); ?><i style="<?php echo ($ui_style['controls']['dollhouse']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['dollhouse']['icon']; ?>"></i></div>
                            <div id="gallery_control_ms" title="<?php echo _("Gallery"); ?>" data-ui-target="ui_edit_gallery" data-id-color="gallery" style="order:<?php echo ($ui_style['controls']['gallery']['order']); ?>" class="ms_control gallery_control <?php echo ($ui_style['controls']['gallery']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_gallery']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('gallery','icon'); ?><i style="<?php echo ($ui_style['controls']['gallery']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['gallery']['icon']; ?>"></i></div>
                            <div id="facebook_control_ms" title="<?php echo _("Facebook Chat"); ?>" data-ui-target="ui_edit_facebook" data-id-color="facebook" style="order:<?php echo ($ui_style['controls']['facebook']['order']); ?>" class="ms_control facebook_control <?php echo ($ui_style['controls']['facebook']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['fb_messenger'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('facebook','icon'); ?><i style="<?php echo ($ui_style['controls']['facebook']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['facebook']['icon']; ?>"></i></div>
                            <div id="whatsapp_control_ms" title="<?php echo _("Whatsapp Chat"); ?>" data-ui-target="ui_edit_whatsapp" data-id-color="whatsapp" style="order:<?php echo ($ui_style['controls']['whatsapp']['order']); ?>" class="ms_control whatsapp_control <?php echo ($ui_style['controls']['whatsapp']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['whatsapp_chat'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('whatsapp','icon'); ?><i style="<?php echo ($ui_style['controls']['whatsapp']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['whatsapp']['icon']; ?>"></i></div>
                            <div id="orient_control_ms" title="<?php echo _("Device Orientation"); ?>" data-ui-target="ui_edit_orientation" data-id-color="orient" style="order:<?php echo ($ui_style['controls']['orient']['order']); ?>" class="ms_control orient_control <?php echo ($ui_style['controls']['orient']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['ar_simulator'])?'hidden_menu':''; ?> <?php echo ($virtual_tour['show_device_orientation']==0) ? 'ui_disabled':''; ?>"><?php echo print_library_icon('orient','icon'); ?><i style="<?php echo ($ui_style['controls']['orient']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['orient']['icon']; ?>"></i></div>
                            <div id="vr_control_ms" title="<?php echo _("Web VR"); ?>" data-ui-target="ui_edit_vr" data-id-color="vr" style="order:<?php echo ($ui_style['controls']['vr']['order']); ?>" class="ms_control vr_control <?php echo ($ui_style['controls']['vr']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_webvr'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('vr','icon'); ?><i style="<?php echo ($ui_style['controls']['vr']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['vr']['icon']; ?>"></i></div>
                            <div id="icons_control_ms" title="<?php echo _("Icons"); ?>" data-ui-target="ui_edit_icons" data-id-color="icons" style="order:<?php echo ($ui_style['controls']['icons']['order']); ?>" class="ms_control icons_control active_control <?php echo ($ui_style['controls']['icons']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_icons_toggle']>0 && $virtual_tour['show_icons_content_toggle']==0 && $virtual_tour['show_icons_nav_toggle']==0)?'':'ui_disabled'; ?>"><?php echo print_library_icon('icons','icon'); ?><i style="<?php echo ($ui_style['controls']['icons']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['icons']['icon']; ?>"></i></div>
                            <div id="icons_content_control_ms" title="<?php echo _("Content Icons"); ?>" data-ui-target="ui_edit_icons_content" data-id-color="icons_content" style="order:<?php echo ($ui_style['controls']['icons_content']['order']); ?>" class="ms_control icons_content_control active_control <?php echo ($ui_style['controls']['icons_content']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_icons_content_toggle'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('icons_content','icon'); ?><i style="<?php echo ($ui_style['controls']['icons_content']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['icons_content']['icon']; ?>"></i></div>
                            <div id="icons_nav_control_ms" title="<?php echo _("Navigation Icons"); ?>" data-ui-target="ui_edit_icons_nav" data-id-color="icons_nav" style="order:<?php echo ($ui_style['controls']['icons_nav']['order']); ?>" class="ms_control icons_nav_control active_control <?php echo ($ui_style['controls']['icons_nav']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_icons_nav_toggle'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('icons_nav','icon'); ?><i style="<?php echo ($ui_style['controls']['icons_nav']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['icons_nav']['icon']; ?>"></i></div>
                            <div id="measures_control_ms" title="<?php echo _("Measures"); ?>" data-ui-target="ui_edit_measures" data-id-color="measures" style="order:<?php echo ($ui_style['controls']['measures']['order']); ?>" class="ms_control measures_control active_control <?php echo ($ui_style['controls']['measures']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_measures_toggle'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('measures','icon'); ?><i style="<?php echo ($ui_style['controls']['measures']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['measures']['icon']; ?>"></i></div>
                            <div id="autorotate_control_ms" title="<?php echo _("Auto Rotation"); ?>" data-ui-target="ui_edit_autorotation" data-id-color="autorotate" style="order:<?php echo ($ui_style['controls']['autorotate']['order']); ?>" class="ms_control autorotate_control active_control <?php echo ($ui_style['controls']['autorotate']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['ar_simulator'])?'hidden_menu':''; ?> <?php echo ($virtual_tour['show_autorotation_toggle']==0 || $virtual_tour['autorotate_speed']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('autorotate','icon'); ?><i style="<?php echo ($ui_style['controls']['autorotate']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['autorotate']['icon']; ?>"></i></div>
                            <div id="annotations_control_ms" title="<?php echo _("Annotations"); ?>" data-ui-target="ui_edit_annotations" data-id-color="annotations" style="order:<?php echo ($ui_style['controls']['annotations']['order']); ?>" class="ms_control annotations_control active_control <?php echo ($ui_style['controls']['annotations']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_annotations'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('annotations','icon'); ?><i style="<?php echo ($ui_style['controls']['annotations']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['annotations']['icon']; ?>"></i></div>
                            <div id="presentation_control_ms" title="<?php echo _("Presentation"); ?>" data-ui-target="ui_edit_presentation" data-id-color="presentation" style="order:<?php echo ($ui_style['controls']['presentation']['order']); ?>" class="ms_control presentation_control <?php echo ($ui_style['controls']['presentation']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['ar_simulator'])?'hidden_menu':''; ?> <?php echo ($virtual_tour['show_presentation']==0) ? 'ui_disabled':''; ?>"><?php echo print_library_icon('presentation','icon'); ?><i style="<?php echo ($ui_style['controls']['presentation']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['presentation']['icon']; ?>"></i></div>
                            <div id="form_control_ms" title="<?php echo $form_title; ?>" data-ui-target="ui_edit_form" data-id-color="form" style="order:<?php echo ($ui_style['controls']['form']['order']); ?>" class="ms_control form_control <?php echo ($ui_style['controls']['form']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_main_form'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('form','icon'); ?><i style="<?php echo ($ui_style['controls']['form']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['form']['icon']; ?>"></i></div>
                            <div id="share_control_ms" title="<?php echo _("Share"); ?>" data-ui-target="ui_edit_share" data-id-color="share" style="order:<?php echo ($ui_style['controls']['share']['order']); ?>" class="ms_control share_control <?php echo ($ui_style['controls']['share']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_share']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('share','icon'); ?><i style="<?php echo ($ui_style['controls']['share']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['share']['icon']; ?>"></i></div>
                            <div id="live_control_ms" title="<?php echo _("Start Live Session"); ?>" data-ui-target="ui_edit_live_session" data-id-color="live" style="order:<?php echo ($ui_style['controls']['live']['order']); ?>" class="ms_control live_control <?php echo ($ui_style['controls']['live']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['ar_simulator'])?'hidden_menu':''; ?> <?php echo ($virtual_tour['live_session'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('live','icon'); ?><i style="<?php echo ($ui_style['controls']['live']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['live']['icon']; ?>"></i></div>
                            <div id="meeting_control_ms" title="<?php echo _("Join Meeting"); ?>" data-ui-target="ui_edit_meeting" data-id-color="meeting" style="order:<?php echo ($ui_style['controls']['meeting']['order']); ?>" class="ms_control meeting_control <?php echo ($ui_style['controls']['meeting']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['meeting']==0) ? 'ui_disabled':''; ?>"><?php echo print_library_icon('meeting','icon'); ?><i style="<?php echo ($ui_style['controls']['meeting']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['meeting']['icon']; ?>"></i></div>
                            <div id="custom_control_ms" title="<?php echo $ui_style['controls']['custom']['label']; ?>" data-ui-target="ui_edit_custom" data-id-color="custom" style="order:<?php echo ($ui_style['controls']['custom']['order']); ?>" class="ms_control custom_control <?php echo ($ui_style['controls']['custom']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_custom']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('custom','icon'); ?><i style="<?php echo ($ui_style['controls']['custom']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['custom']['icon']; ?>"></i></div>
                            <div id="custom2_control_ms" title="<?php echo $ui_style['controls']['custom2']['label']; ?>" data-ui-target="ui_edit_custom2" data-id-color="custom2" style="order:<?php echo ($ui_style['controls']['custom2']['order']); ?>" class="ms_control custom2_control <?php echo ($ui_style['controls']['custom2']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_custom2']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('custom2','icon'); ?><i style="<?php echo ($ui_style['controls']['custom2']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['custom2']['icon']; ?>"></i></div>
                            <div id="custom3_control_ms" title="<?php echo $ui_style['controls']['custom3']['label']; ?>" data-ui-target="ui_edit_custom3" data-id-color="custom3" style="order:<?php echo ($ui_style['controls']['custom3']['order']); ?>" class="ms_control custom3_control <?php echo ($ui_style['controls']['custom3']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_custom3']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('custom3','icon'); ?><i style="<?php echo ($ui_style['controls']['custom3']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['custom3']['icon']; ?>"></i></div>
                            <div id="custom4_control_ms" title="<?php echo $ui_style['controls']['custom4']['label']; ?>" data-ui-target="ui_edit_custom4" data-id-color="custom4" style="order:<?php echo ($ui_style['controls']['custom4']['order']); ?>" class="ms_control custom4_control <?php echo ($ui_style['controls']['custom4']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_custom4']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('custom4','icon'); ?><i style="<?php echo ($ui_style['controls']['custom4']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['custom4']['icon']; ?>"></i></div>
                            <div id="custom5_control_ms" title="<?php echo $ui_style['controls']['custom5']['label']; ?>" data-ui-target="ui_edit_custom5" data-id-color="custom5" style="order:<?php echo ($ui_style['controls']['custom5']['order']); ?>" class="ms_control custom5_control <?php echo ($ui_style['controls']['custom5']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_custom5']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('custom5','icon'); ?><i style="<?php echo ($ui_style['controls']['custom5']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['custom5']['icon']; ?>"></i></div>
                            <div id="location_control_ms" title="<?php echo $ui_style['controls']['location']['label']; ?>" data-ui-target="ui_edit_location" data-id-color="location" style="order:<?php echo ($ui_style['controls']['location']['order']); ?>" class="ms_control location_control <?php echo ($ui_style['controls']['location']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_location']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('location','icon'); ?><i style="<?php echo ($ui_style['controls']['location']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['location']['icon']; ?>"></i></div>
                            <div id="media_control_ms" title="<?php echo $ui_style['controls']['media']['label']; ?>" data-ui-target="ui_edit_media" data-id-color="media" style="order:<?php echo ($ui_style['controls']['media']['order']); ?>" class="ms_control media_control <?php echo ($ui_style['controls']['media']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_media']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('media','icon'); ?><i style="<?php echo ($ui_style['controls']['media']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['media']['icon']; ?>"></i></div>
                            <div id="snapshot_control_ms" title="<?php echo _("Snapshot"); ?>" data-ui-target="ui_edit_snapshot" data-id-color="snapshot" style="order:<?php echo ($ui_style['controls']['snapshot']['order']); ?>" class="ms_control snapshot_control <?php echo ($ui_style['controls']['snapshot']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_snapshot']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('snapshot','icon'); ?><i style="<?php echo ($ui_style['controls']['snapshot']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['snapshot']['icon']; ?>"></i></div>
                        </div>
                        <div class="list_alt_menu <?php echo ($virtual_tour['show_list_alt']) ? '' : 'ui_disabled'; ?>" id="ms_list_rooms" data-ui-target="ui_edit_menu">
                            <div class="dropdown" data-ui-target="ui_edit_menu"></div>
                        </div>
                    </div>
                    <div data-ui-target="ui_edit_list_alt" id="list_alt_menu" class="list_alt_menu noselect <?php echo ($ui_style['sidebar']['enable'])?'ui_hidden':''; ?> <?php echo ($virtual_tour['ar_simulator'])?'hidden_menu':''; ?> <?php echo ($virtual_tour['show_list_alt']==0) ? 'ui_disabled':''; ?>">
                        <div data-ui-target="ui_edit_list_alt" class="title"><i title="<?php echo _("Rooms List Menu"); ?>" onclick="click_list_alt_controls();" data-ui-target="ui_edit_list_alt" data-id-color="list_alt" class="fas fa-layer-group small-element"></i>
                            <div class="arrow"></div>
                        </div>
                        <div data-ui-target="ui_edit_list_alt" class="dropdown"></div>
                    </div>
                    <div title="<?php echo _("Audio"); ?>" data-ui-target="ui_edit_audio" data-id-color="audio" class="small-element song_control song_control_icon noselect <?php echo ($virtual_tour['show_audio'])?'':'ui_disabled'; ?> <?php echo ($ui_style['controls']['song_alt']['type']=='button' || $ui_style['controls']['song_alt']['type']=='menulist') ? 'ui_hidden' : ''; ?>"><i class="fas fa-volume-down"></i></div>
                    <div class="header_vt">
                        <div title="<?php echo _("Tour Title"); ?>" data-ui-target="ui_edit_title" class="name_vt <?php echo ($virtual_tour['show_vt_title']==1 || ($virtual_tour['show_vt_title']==2))?'':'ui_disabled'; ?>"><?php echo $virtual_tour['name']; ?></div>
                        <div title="<?php echo _("Tour Title"); ?>" data-ui-target="ui_edit_title" class="room_vt <?php echo ($virtual_tour['show_vt_title']==1 || ($virtual_tour['show_vt_title']==3))?'':'ui_disabled'; ?>"><?php echo _("Room name"); ?></div>
                        <div title="<?php echo _("Comments"); ?>" data-ui-target="ui_edit_comments" class="comments_vt <?php echo ($virtual_tour['show_comments']!=0)?'':'ui_disabled'; ?>" style="display:block;">
                            <i data-ui-target="ui_edit_comments" id="comments_control" class="fas fa-comments"></i>
                            <span data-ui-target="ui_edit_comments" class="disqus-comment-count" data-disqus-identifier="0"># <?php echo _("Comments"); ?></span>
                        </div>
                        <div class="visitors_rt_stats tooltip_view small-element noselect <?php echo ($virtual_tour['enable_views_stat']==0 && $virtual_tour['enable_visitor_rt']==0) ? 'ui_disabled':''; ?>" title="<?php echo _("Visitors"); ?>" data-ui-target="ui_edit_visitors"><div class="visitors_block" data-ui-target="ui_edit_visitors"><span id="visitors_here">#</span>&nbsp;<?php echo _("here"); ?>&nbsp;&nbsp;<i class="fas fa-users"></i>&nbsp;&nbsp;<span id="visitors_total">#</span>&nbsp;<?php echo _("total"); ?></div><div class="separator_block" data-ui-target="ui_edit_visitors">&nbsp;&nbsp;|&nbsp;&nbsp;</div><div class="views_block" data-ui-target="ui_edit_visitors"><i class="fas fa-eye"></i>&nbsp;<span id="views_total_count">#</span> <?php echo _("views"); ?></div></div>
                        <div class="rooms_view_sel <?php echo (!$multiple_room_view)?'disabled':''; ?> <?php echo ($virtual_tour['enable_rooms_multiple']==0) ? 'ui_disabled':''; ?>" data-ui-target="ui_edit_multiple_room_views" style="display:block;top:100px">
                            <img title="<?php echo _("Multiple Room Views"); ?>" data-ui-target="ui_edit_multiple_room_views" data-id-color="room_alt" class="active rooms_alt tooltip_view small-element noselect" src="<?php echo $room1_pano; ?>">
                            <img title="<?php echo _("Multiple Room Views"); ?>" data-ui-target="ui_edit_multiple_room_views" data-id-color="room_alt" class="rooms_alt tooltip_view small-element noselect" src="<?php echo $room1_pano; ?>">
                        </div>
                    </div>
                    <div id="controls_top_right">
                        <div title="<?php echo _("Fullscreen"); ?>" data-ui-target="ui_edit_fullscreen" data-id-color="fullscreen" class="small-element fullscreen_control fullscreen_control_icon noselect <?php echo ($virtual_tour['show_fullscreen'])?'':'ui_disabled'; ?> <?php echo ($ui_style['controls']['fullscreen_alt']['type']=='button' || $ui_style['controls']['fullscreen_alt']['type']=='menulist') ? 'ui_hidden' : ''; ?>"><i class="fas fa-expand"></i></div>
                        <div title="<?php echo _("Floorplan"); ?>" data-ui-target="ui_edit_map" data-id-color="floorplan" class="small-element map_control map_control_icon noselect <?php echo ($virtual_tour['show_map']==0)?'ui_disabled':''; ?> <?php echo ($ui_style['controls']['floorplan_alt']['type']=='button' || $ui_style['controls']['floorplan_alt']['type']=='menulist') ? 'ui_hidden' : ''; ?>"><i class="<?php echo ($virtual_tour['show_map']==3) ? 'icon-map_on':'icon-map_off'; ?>"></i></div>
                        <div title="<?php echo _("Map"); ?>" data-ui-target="ui_edit_map_tour" data-id-color="map" class="small-element map_tour_control map_tour_control_icon noselect <?php echo ($virtual_tour['show_map_tour']==0)?'ui_disabled':''; ?> <?php echo ($ui_style['controls']['map_alt']['type']=='button' || $ui_style['controls']['map_alt']['type']=='menulist') ? 'ui_hidden' : ''; ?>"><i class="<?php echo ($virtual_tour['show_map_tour']==2)?'fas':'far'; ?> fa-map"></i></div>
                        <div title="<?php echo _("Language"); ?>" data-ui-target="ui_edit_localization" class="small-element language_control language_control_icon noselect <?php echo ($virtual_tour['show_language']==0 || count($array_languages)<=1)?'ui_disabled':''; ?> <?php echo ($ui_style['controls']['language_alt']['type']=='menulist') ? 'ui_hidden' : ''; ?>"><img src="img/flags_lang/<?php echo $default_language; ?>.png?v=2"/></div>
                    </div>
                    <div title="<?php echo _("Annotations"); ?>" data-ui-target="ui_edit_annotations" class="annotation annotation_<?php echo $ui_style['items']['annotation']['position']; ?> noselect <?php echo ($virtual_tour['show_annotations']==1)?'':'ui_disabled'; ?>">
                        <h2 data-ui-target="ui_edit_annotations" class="annotation_title"><?php echo _("Annotation Title"); ?></h2>
                        <hr data-ui-target="ui_edit_annotations">
                        <p data-ui-target="ui_edit_annotations" class="annotation_description"><?php echo _("Annotation Description"); ?></p>
                    </div>
                    <div title="<?php echo _("Main Form - Inline"); ?>"  data-ui-target="ui_edit_inline_form" class="inline_form inline_form_<?php echo $ui_style['items']['inline_form']['position']; ?> noselect <?php echo ($virtual_tour['show_inline_form']==1)?'':'ui_disabled'; ?>">
                        <button data-ui-target="ui_edit_inline_form" id="inline_form_toggle">
                            <span data-ui-target="ui_edit_inline_form"><?php echo $form_title; ?></span>
                            <i data-ui-target="ui_edit_inline_form" style="transform: rotate(0deg);" id="inline_form_arrow_icon" class="fa-solid fa-chevron-down"></i>
                        </button>
                        <div data-ui-target="ui_edit_inline_form" id="inline_form_content">
                            <div data-ui-target="ui_edit_inline_form" class="inline_form_content_wrapper">
                                <form style="pointer-events:none;" id="inline_form_main" method="POST" enctype="multipart/form-data">
                                    <?php if(!empty($form_description)) : ?><p class="inline_form_description"><?php echo $form_description; ?></p><?php endif; ?>
                                    <div style="margin-bottom:0;" class="inline_form_group"><label for="form_field_1" class="inline_form_label"><?php echo _("Field"); ?> *</label><input type="text" id="form_field_1" name="form_field_1" class="inline_form_input" required="" value="<?php echo _("Value"); ?>"></div>
                                    <div style="margin-bottom:0;" class="inline_form_group">...</div>
                                    <div class="inline_form_button_container">
                                        <button type="submit" class="inline_form_submit_button"><?php echo $form_button; ?></button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div title="<?php echo _("Logo"); ?>" data-ui-target="ui_edit_logo" class="logo logo_<?php echo $ui_style['items']['logo']['position']; ?>">
                        <img data-ui-target="ui_edit_logo" class="<?php echo ($virtual_tour['show_logo']>0)?'':'ui_disabled'; ?>" src="<?php echo $logo; ?>">
                    </div>
                    <div title="<?php echo _("Powered By - Logo / Text"); ?>" data-ui-target="ui_edit_poweredby" class="poweredby poweredby_<?php echo $ui_style['items']['poweredby']['position']; ?>">
                        <?php
                        switch ($virtual_tour['poweredby_type']) {
                            case 'image':
                                if(!empty($poweredby_image)) : ?>
                                    <img class="<?php echo ($virtual_tour['show_poweredby']>0)?'':'ui_disabled'; ?>" data-ui-target="ui_edit_poweredby" src="<?php echo $poweredby_image; ?>" />
                                <?php endif;
                                break;
                            case 'text':
                                if(!empty($poweredby_text)) : ?>
                                    <span class="<?php echo ($virtual_tour['show_poweredby']>0)?'':'ui_disabled'; ?>" data-ui-target="ui_edit_poweredby"><?php echo $poweredby_text; ?></span>
                                <?php endif;
                                break;
                        }
                        ?>
                    </div>
                    <div title="<?php echo _("Avatar Video"); ?>" data-ui-target="ui_edit_avatar_video" class="avatar_video avatar_video_<?php echo $ui_style['items']['avatar_video']['position']; ?>">
                        <img class="<?php echo ($virtual_tour['show_avatar_video'])?'':'ui_disabled'; ?> <?php echo (empty($avatar_video))?'':'hidden'; ?>" data-ui-target="ui_edit_avatar_video" src="<?php echo $avatar_video_image; ?>" />
                        <video playsinline webkit-playsinline class="<?php echo ($virtual_tour['show_avatar_video'])?'':'ui_disabled'; ?> <?php echo (empty($avatar_video))?'hidden':''; ?>" data-ui-target="ui_edit_avatar_video" muted preload="auto" src=""></video>
                    </div>
                    <div  title="<?php echo _("Floorplan"); ?>"data-ui-target="ui_edit_map" style="display: block;width:<?php echo $map_width; ?>px;" class="map map_<?php echo $ui_style['items']['map']['position']; ?>">
                        <div data-ui-target="ui_edit_map" class="all_maps <?php echo ($virtual_tour['show_map']==0 || $virtual_tour['show_map']==4)?'ui_disabled':''; ?>" style="overflow: hidden">
                            <div data-ui-target="ui_edit_map" class="map_wrapper">
                                <img class="" data-ui-target="ui_edit_map" style="width:<?php echo $map_width; ?>px;" src="<?php echo $map_image; ?>">
                            </div>
                        </div>
                        <div data-ui-target="ui_edit_map" class="map_bar <?php echo ($virtual_tour['show_map']==0 || $virtual_tour['show_map']==4)?'ui_disabled':''; ?>">
                            <div data-ui-target="ui_edit_map" class="map_selector_control noselect"><i data-ui-target="ui_edit_map" class="fas fa-layer-group"></i></div>
                            <div data-ui-target="ui_edit_map" style="padding-left: 2px;" class="map_name noselect"><?php echo _("Map Name"); ?></div>
                            <div data-ui-target="ui_edit_map" class="map_controls_btn">
                                <div data-ui-target="ui_edit_map" class="map_zoom_minus_control noselect"><i data-ui-target="ui_edit_map" class="fas fa-minus"></i></div>
                                <div data-ui-target="ui_edit_map" class="map_zoom_plus_control noselect"><i data-ui-target="ui_edit_map" class="fas fa-plus"></i></div>
                                <div data-ui-target="ui_edit_map" class="map_zoom_control noselect"><i data-ui-target="ui_edit_map" class="fas fa-expand-alt"></i></div>
                                <div data-ui-target="ui_edit_map" class="map_close_control noselect"><i data-ui-target="ui_edit_map" class="fas fa-times-circle"></i></div>
                            </div>
                        </div>
                    </div>
                    <div class="arrows_nav <?php echo ($virtual_tour['ar_simulator'])?'hidden_menu':''; ?> <?php echo ($ui_style['controls']['arrows']['type']=='button') ? 'ui_hidden' : ''; ?>">
                        <i title="<?php echo _("Arrows Prev/Next"); ?>" data-ui-target="ui_edit_arrows_nav" data-id-color="arrows" class="arrows prev_arrow fas fa-chevron-left small-element <?php echo ($virtual_tour['arrows_nav']==0) ? 'ui_disabled':''; ?>"></i>
                        <i title="<?php echo _("Arrows Prev/Next"); ?>" data-ui-target="ui_edit_arrows_nav" data-id-color="arrows" class="arrows next_arrow fas fa-chevron-right small-element <?php echo ($virtual_tour['arrows_nav']==0) ? 'ui_disabled':''; ?>"></i>
                    </div>
                    <div title="<?php echo _("Nav Control"); ?>" data-ui-target="ui_edit_nav" data-id-color="nav_control" class="nav_control <?php echo ($virtual_tour['ar_simulator'])?'hidden_menu':''; ?> <?php echo ($virtual_tour['show_nav_control'])?'':'ui_disabled'; ?>">
                        <i data-ui-target="ui_edit_nav" data-id-color="nav_control" class="nav_up fas fa-chevron-up small-element"></i>
                        <i data-ui-target="ui_edit_nav" data-id-color="nav_control" class="nav_down fas fa-chevron-down small-element"></i>
                        <i data-ui-target="ui_edit_nav" data-id-color="nav_control" class="nav_left fas fa-chevron-left small-element"></i>
                        <i data-ui-target="ui_edit_nav" data-id-color="nav_control" class="nav_right fas fa-chevron-right small-element"></i>
                        <i data-ui-target="ui_edit_nav" data-id-color="nav_control" class="nav_rotate fas fa-sync-alt small-element"></i>
                    </div>
                    <div title="<?php echo _("Room's List Slider"); ?>" data-ui-target="ui_edit_slider" data-id-color="list" class="small-element list_control <?php echo ($virtual_tour['ar_simulator'])?'hidden_menu':''; ?> <?php echo ($ui_style['controls']['list']['type']=='button') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['auto_show_slider']==2) ? 'ui_disabled':''; ?>"><i data-ui-target="ui_edit_slider" class="fas fa-chevron-<?php echo ($virtual_tour['auto_show_slider']==1) ? 'down':'up'; ?>"></i></div>
                    <div class="controls_bottom <?php echo ($ui_style['buttons_style']!='default') ? $ui_style['buttons_style']."-btn" : ''; ?> <?php echo ($ui_style['buttons_size']!='default') ? $ui_style['buttons_size']."-btn" : ''; ?>">
                        <div id="controls_bottom_left">
                            <div data-ui-target="ui_edit_voice" style="order:<?php echo ($ui_style['controls']['voice']['order']); ?>" class="voice_control noselect <?php echo ($virtual_tour['ar_simulator'])?'hidden_menu':''; ?>"><div title="<?php echo _("Voice Commands"); ?>" data-ui-target="ui_edit_voice" class="<?php echo ($virtual_tour['voice_commands']==0) ? 'ui_disabled':''; ?>" id="skitt-ui"><a data-ui-target="ui_edit_voice" id="skitt-toggle-button">&nbsp;</a></div></div>
                            <div id="controls_arrow_left" style="order:<?php echo ($ui_style['controls']['arrows']['order']); ?>;" class="controls_arrows noselect <?php echo ($ui_style['controls']['arrows']['position']=='left' || $ui_style['controls']['list']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['list']['type']=='default' && $ui_style['controls']['arrows']['type']=='default') ? 'ui_hidden' : ''; ?>">
                                <i title="<?php echo _("Room's List Slider"); ?>" data-ui-target="ui_edit_slider" data-id-color="list" class="fa fa-chevron-<?php echo ($virtual_tour['auto_show_slider']==1) ? 'down':'up'; ?> list_control_alt noselect small-element <?php echo ($ui_style['controls']['list']['type']=='default') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['auto_show_slider']==2) ? 'ui_disabled':''; ?>"></i>
                                <i title="<?php echo _("Arrows Prev/Next"); ?>" data-ui-target="ui_edit_arrows_nav" data-id-color="arrows" class="fa fa-chevron-left prev_arrow noselect small-element <?php echo ($ui_style['controls']['arrows']['type']=='default') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['arrows_nav']==0) ? 'ui_disabled':''; ?>"></i>
                                <i title="<?php echo _("Arrows Prev/Next"); ?>" data-ui-target="ui_edit_arrows_nav" data-id-color="arrows" class="fa fa-chevron-right next_arrow noselect small-element <?php echo ($ui_style['controls']['arrows']['type']=='default') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['arrows_nav']==0) ? 'ui_disabled':''; ?>"></i>
                            </div>
                            <div id="info_control_left" title="<?php echo _("Info"); ?>" style="order:<?php echo ($ui_style['controls']['info']['order']); ?>;" data-ui-target="ui_edit_info" data-id-color="info" class="small-element controls_btn info_control <?php echo ($ui_style['controls']['info']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['info']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_info']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('info','icon'); ?><i style="<?php echo ($ui_style['controls']['info']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['info']['icon']; ?>"></i></div>
                            <div id="dollhouse_control_left" title="<?php echo _("3D View"); ?>" style="order:<?php echo ($ui_style['controls']['dollhouse']['order']); ?>;" data-ui-target="ui_edit_dollhouse" data-id-color="dollhouse" class="small-element controls_btn dollhouse_control <?php echo ($ui_style['controls']['dollhouse']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['dollhouse']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_dollhouse']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('dollhouse','icon'); ?><i style="<?php echo ($ui_style['controls']['dollhouse']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['dollhouse']['icon']; ?>"></i></div>
                            <div id="gallery_control_left" title="<?php echo _("Gallery"); ?>" style="order:<?php echo ($ui_style['controls']['gallery']['order']); ?>;" data-ui-target="ui_edit_gallery" data-id-color="gallery" class="small-element controls_btn gallery_control <?php echo ($ui_style['controls']['gallery']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['gallery']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_gallery']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('gallery','icon'); ?><i style="<?php echo ($ui_style['controls']['gallery']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['gallery']['icon']; ?>"></i></div>
                            <div id="facebook_control_left" title="<?php echo _("Facebook"); ?>" style="order:<?php echo ($ui_style['controls']['facebook']['order']); ?>;" data-ui-target="ui_edit_facebook" data-id-color="facebook" class="small-element controls_btn facebook_control <?php echo ($ui_style['controls']['facebook']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['facebook']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['fb_messenger'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('facebook','icon'); ?><i style="<?php echo ($ui_style['controls']['facebook']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['facebook']['icon']; ?>"></i></div>
                            <div id="whatsapp_control_left" title="<?php echo _("Whatsapp"); ?>" style="order:<?php echo ($ui_style['controls']['whatsapp']['order']); ?>;" data-ui-target="ui_edit_whatsapp" data-id-color="whatsapp" class="small-element controls_btn whatsapp_control <?php echo ($ui_style['controls']['whatsapp']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['whatsapp']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['whatsapp_chat'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('whatsapp','icon'); ?><i style="<?php echo ($ui_style['controls']['whatsapp']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['whatsapp']['icon']; ?>"></i></div>
                            <div id="presentation_control_left" title="<?php echo _("Presentation"); ?>" style="order:<?php echo ($ui_style['controls']['presentation']['order']); ?>;" data-ui-target="ui_edit_presentation" data-id-color="presentation" class="small-element controls_btn presentation_control <?php echo ($ui_style['controls']['presentation']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['presentation']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_presentation']==0) ? 'ui_disabled':''; ?>"><?php echo print_library_icon('presentation','icon'); ?><i style="<?php echo ($ui_style['controls']['presentation']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['presentation']['icon']; ?>"></i></div>
                            <div id="form_control_left" title="<?php echo _("Main Form"); ?>" style="order:<?php echo ($ui_style['controls']['form']['order']); ?>;" data-ui-target="ui_edit_form" data-id-color="form" class="small-element controls_btn form_control <?php echo ($ui_style['controls']['form']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['form']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_main_form'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('form','icon'); ?><i style="<?php echo ($ui_style['controls']['form']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['form']['icon']; ?>"></i></div>
                            <div id="share_control_left" title="<?php echo _("Share"); ?>" style="order:<?php echo ($ui_style['controls']['share']['order']); ?>;" data-ui-target="ui_edit_share" data-id-color="share" class="small-element controls_btn share_control <?php echo ($ui_style['controls']['share']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['share']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_share']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('share','icon'); ?><i style="<?php echo ($ui_style['controls']['share']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['share']['icon']; ?>"></i></div>
                            <div id="live_control_left" title="<?php echo _("Live Session"); ?>" style="order:<?php echo ($ui_style['controls']['live']['order']); ?>;" data-ui-target="ui_edit_live_session" data-id-color="live" class="small-element controls_btn live_control <?php echo ($ui_style['controls']['live']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['live']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['live_session'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('live','icon'); ?><i style="<?php echo ($ui_style['controls']['live']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['live']['icon']; ?>"></i></div>
                            <div id="meeting_control_left" title="<?php echo _("Meeting"); ?>" style="order:<?php echo ($ui_style['controls']['meeting']['order']); ?>;" data-ui-target="ui_edit_meeting" data-id-color="meeting" class="small-element controls_btn meeting_control <?php echo ($ui_style['controls']['meeting']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['meeting']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['meeting']==0) ? 'ui_disabled':''; ?>"><?php echo print_library_icon('meeting','icon'); ?><i style="<?php echo ($ui_style['controls']['meeting']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['meeting']['icon']; ?>"></i></div>
                            <div id="vr_control_left" title="<?php echo _("Web VR"); ?>" style="order:<?php echo ($ui_style['controls']['vr']['order']); ?>;" data-ui-target="ui_edit_vr" data-id-color="vr" class="small-element controls_btn vr_control <?php echo ($ui_style['controls']['vr']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['vr']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_webvr'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('vr','icon'); ?><i style="<?php echo ($ui_style['controls']['vr']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['vr']['icon']; ?>"></i></div>
                            <div id="compass_control_left" title="<?php echo _("Compass"); ?>" style="order:<?php echo ($ui_style['controls']['compass']['order']); ?>;" data-ui-target="ui_edit_compass" data-id-color="compass" class="small-element controls_btn compass_control <?php echo ($ui_style['controls']['compass']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($virtual_tour['compass'])?'':'ui_disabled'; ?>"><i class="icon-compass"></i></div>
                            <div id="custom_control_left" title="<?php echo $ui_style['controls']['custom']['label']; ?>" style="order:<?php echo ($ui_style['controls']['custom']['order']); ?>;" data-ui-target="ui_edit_custom" data-id-color="custom" class="small-element controls_btn custom_control <?php echo ($ui_style['controls']['custom']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['custom']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_custom']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('custom','icon'); ?><i style="<?php echo ($ui_style['controls']['custom']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['custom']['icon']; ?>"></i></div>
                            <div id="custom2_control_left" title="<?php echo $ui_style['controls']['custom2']['label']; ?>" style="order:<?php echo ($ui_style['controls']['custom2']['order']); ?>;" data-ui-target="ui_edit_custom2" data-id-color="custom2" class="small-element controls_btn custom2_control <?php echo ($ui_style['controls']['custom2']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['custom2']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_custom2']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('custom2','icon'); ?><i style="<?php echo ($ui_style['controls']['custom2']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['custom2']['icon']; ?>"></i></div>
                            <div id="custom3_control_left" title="<?php echo $ui_style['controls']['custom3']['label']; ?>" style="order:<?php echo ($ui_style['controls']['custom3']['order']); ?>;" data-ui-target="ui_edit_custom3" data-id-color="custom3" class="small-element controls_btn custom3_control <?php echo ($ui_style['controls']['custom3']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['custom3']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_custom3']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('custom3','icon'); ?><i style="<?php echo ($ui_style['controls']['custom3']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['custom3']['icon']; ?>"></i></div>
                            <div id="custom4_control_left" title="<?php echo $ui_style['controls']['custom4']['label']; ?>" style="order:<?php echo ($ui_style['controls']['custom4']['order']); ?>;" data-ui-target="ui_edit_custom4" data-id-color="custom4" class="small-element controls_btn custom4_control <?php echo ($ui_style['controls']['custom4']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['custom4']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_custom4']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('custom4','icon'); ?><i style="<?php echo ($ui_style['controls']['custom4']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['custom4']['icon']; ?>"></i></div>
                            <div id="custom5_control_left" title="<?php echo $ui_style['controls']['custom5']['label']; ?>" style="order:<?php echo ($ui_style['controls']['custom5']['order']); ?>;" data-ui-target="ui_edit_custom5" data-id-color="custom5" class="small-element controls_btn custom5_control <?php echo ($ui_style['controls']['custom5']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['custom5']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_custom5']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('custom5','icon'); ?><i style="<?php echo ($ui_style['controls']['custom5']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['custom5']['icon']; ?>"></i></div>
                            <div id="location_control_left" title="<?php echo $ui_style['controls']['location']['label']; ?>" style="order:<?php echo ($ui_style['controls']['location']['order']); ?>;" data-ui-target="ui_edit_location" data-id-color="location" class="small-element controls_btn location_control <?php echo ($ui_style['controls']['location']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['location']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_location']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('location','icon'); ?><i style="<?php echo ($ui_style['controls']['location']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['location']['icon']; ?>"></i></div>
                            <div id="media_control_left" title="<?php echo $ui_style['controls']['media']['label']; ?>" style="order:<?php echo ($ui_style['controls']['media']['order']); ?>;" data-ui-target="ui_edit_media" data-id-color="media" class="small-element controls_btn media_control <?php echo ($ui_style['controls']['media']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['media']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_media']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('media','icon'); ?><i style="<?php echo ($ui_style['controls']['media']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['media']['icon']; ?>"></i></div>
                            <div id="snapshot_control_left" title="<?php echo _("Snapshot"); ?>" style="order:<?php echo ($ui_style['controls']['snapshot']['order']); ?>;" data-ui-target="ui_edit_snapshot" data-id-color="snapshot" class="small-element controls_btn snapshot_control <?php echo ($ui_style['controls']['snapshot']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['snapshot']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_snapshot']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('snapshot','icon'); ?><i style="<?php echo ($ui_style['controls']['snapshot']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['snapshot']['icon']; ?>"></i></div>
                            <div id="orient_control_left" title="<?php echo _("Device Orientation"); ?>" style="order:<?php echo ($ui_style['controls']['orient']['order']); ?>;" data-ui-target="ui_edit_orientation" data-id-color="orient" class="small-element controls_btn orient_control <?php echo ($ui_style['controls']['orient']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['orient']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_device_orientation']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('orient','icon'); ?><i style="<?php echo ($ui_style['controls']['orient']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['orient']['icon']; ?>"></i></div>
                            <div id="autorotate_control_left" title="<?php echo _("Auto Rotation"); ?>" style="order:<?php echo ($ui_style['controls']['autorotate']['order']); ?>;" data-ui-target="ui_edit_autorotation" data-id-color="autorotate" class="small-element controls_btn autorotate_control <?php echo ($ui_style['controls']['autorotate']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['autorotate']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['ar_simulator'])?'hidden_menu':''; ?> <?php echo ($virtual_tour['show_autorotation_toggle']==0 || $virtual_tour['autorotate_speed']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('autorotate','icon'); ?><i style="<?php echo ($ui_style['controls']['autorotate']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['autorotate']['icon']; ?>"></i></div>
                            <div id="icons_control_left" title="<?php echo _("Icons"); ?>" style="order:<?php echo ($ui_style['controls']['icons']['order']); ?>;" data-ui-target="ui_edit_icons" data-id-color="icons" class="small-element controls_btn icons_control <?php echo ($ui_style['controls']['icons']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['icons']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_icons_toggle']>0 && $virtual_tour['show_icons_content_toggle']==0 && $virtual_tour['show_icons_nav_toggle']==0)?'':'ui_disabled'; ?>"><?php echo print_library_icon('icons','icon'); ?><i style="<?php echo ($ui_style['controls']['icons']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['icons']['icon']; ?>"></i></div>
                            <div id="icons_content_control_left" title="<?php echo _("Content Icons"); ?>" style="order:<?php echo ($ui_style['controls']['icons_content']['order']); ?>;" data-ui-target="ui_edit_icons_content" data-id-color="icons_content" class="small-element controls_btn icons_content_control <?php echo ($ui_style['controls']['icons_content']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['icons_content']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_icons_content_toggle']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('icons_content','icon'); ?><i style="<?php echo ($ui_style['controls']['icons_content']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['icons_content']['icon']; ?>"></i></div>
                            <div id="icons_nav_control_left" title="<?php echo _("Navigation Icons"); ?>" style="order:<?php echo ($ui_style['controls']['icons_nav']['order']); ?>;" data-ui-target="ui_edit_icons_nav" data-id-color="icons_nav" class="small-element controls_btn icons_nav_control <?php echo ($ui_style['controls']['icons_nav']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['icons_nav']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_icons_nav_toggle']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('icons_nav','icon'); ?><i style="<?php echo ($ui_style['controls']['icons_nav']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['icons_nav']['icon']; ?>"></i></div>
                            <div id="measures_control_left" title="<?php echo _("Measures"); ?>" style="order:<?php echo ($ui_style['controls']['measures']['order']); ?>;" data-ui-target="ui_edit_measures" data-id-color="measures" class="small-element controls_btn measures_control <?php echo ($ui_style['controls']['measures']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['measures']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_measures_toggle']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('measures','icon'); ?><i style="<?php echo ($ui_style['controls']['measures']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['measures']['icon']; ?>"></i></div>
                            <div id="annotations_control_left" title="<?php echo _("Annotations"); ?>" style="order:<?php echo ($ui_style['controls']['annotations']['order']); ?>;" data-ui-target="ui_edit_annotations" data-id-color="annotations" class="small-element controls_btn annotations_control <?php echo ($ui_style['controls']['annotations']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['annotations']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_annotations']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('annotations','icon'); ?><i style="<?php echo ($ui_style['controls']['annotations']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['annotations']['icon']; ?>"></i></div>
                            <div id="fullscreen_alt_control_left" title="<?php echo _("Fullscreen"); ?>" style="order:<?php echo ($ui_style['controls']['fullscreen_alt']['order']); ?>;" data-ui-target="ui_edit_fullscreen" data-id-color="fullscreen_alt" class="small-element controls_btn fullscreen_alt_control <?php echo ($ui_style['controls']['fullscreen_alt']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['fullscreen_alt']['type']=='menu' || $ui_style['controls']['fullscreen_alt']['type']=='menulist') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_fullscreen']==0)?'ui_disabled':''; ?>"><i class="fas fa-expand"></i></div>
                            <div id="floorplan_alt_control_left" title="<?php echo _("Floorplan"); ?>" style="order:<?php echo ($ui_style['controls']['floorplan_alt']['order']); ?>;" data-ui-target="ui_edit_map" data-id-color="floorplan_alt" class="small-element controls_btn floorplan_alt_control <?php echo ($ui_style['controls']['floorplan_alt']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['floorplan_alt']['type']=='menu' || $ui_style['controls']['floorplan_alt']['type']=='menulist') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_map']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('floorplan_alt','icon'); ?><i style="<?php echo ($ui_style['controls']['floorplan_alt']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['floorplan_alt']['icon']; ?>"></i></div>
                            <div id="map_alt_control_left" title="<?php echo _("Map"); ?>" style="order:<?php echo ($ui_style['controls']['map_alt']['order']); ?>;" data-ui-target="ui_edit_map_tour" data-id-color="map_alt" class="small-element controls_btn map_alt_control <?php echo ($ui_style['controls']['map_alt']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['map_alt']['type']=='menu' || $ui_style['controls']['map_alt']['type']=='menulist') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_map_tour']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('map_alt','icon'); ?><i style="<?php echo ($ui_style['controls']['map_alt']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['map_alt']['icon']; ?>"></i></div>
                            <div id="song_alt_control_left" title="<?php echo _("Audio"); ?>" style="order:<?php echo ($ui_style['controls']['song_alt']['order']); ?>;" data-ui-target="ui_edit_audio" data-id-color="song_alt" class="small-element controls_btn song_alt_control <?php echo ($ui_style['controls']['song_alt']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['song_alt']['type']=='menu' || $ui_style['controls']['song_alt']['type']=='menulist') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_audio']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('song_alt','icon'); ?><i style="<?php echo ($ui_style['controls']['song_alt']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['song_alt']['icon']; ?>"></i></div>
                            <div id="language_alt_control_left" title="<?php echo _("Language"); ?>" style="order:<?php echo ($ui_style['controls']['language_alt']['order']); ?>;" data-ui-target="ui_edit_localization" data-id-color="language_alt" class="small-element controls_btn language_alt_control <?php echo ($ui_style['controls']['language_alt']['position']=='left') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['language_alt']['type']=='menu' || $ui_style['controls']['language_alt']['type']=='menulist') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_language']==0 || count($array_languages)<=1)?'ui_disabled':''; ?>"><img src="img/flags_lang/<?php echo $default_language; ?>.png?v=2"/></div>
                        </div>
                        <div class="controls_bottom_center_wrap">
                            <div id="controls_bottom_center">
                                <div id="controls_arrow_center" style="order:<?php echo ($ui_style['controls']['arrows']['order']); ?>;" class="controls_arrows noselect <?php echo ($ui_style['controls']['arrows']['position']=='center' || $ui_style['controls']['list']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['list']['type']=='default' && $ui_style['controls']['arrows']['type']=='default') ? 'ui_hidden' : ''; ?>">
                                    <i title="<?php echo _("Room's List Slider"); ?>" data-ui-target="ui_edit_slider" data-id-color="list" class="fa fa-chevron-<?php echo ($virtual_tour['auto_show_slider']==1) ? 'down':'up'; ?> list_control_alt noselect small-element <?php echo ($ui_style['controls']['list']['type']=='default') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['auto_show_slider']==2) ? 'ui_disabled':''; ?>"></i>
                                    <i title="<?php echo _("Arrows Prev/Next"); ?>" data-ui-target="ui_edit_arrows_nav" data-id-color="arrows" class="fa fa-chevron-left prev_arrow noselect small-element <?php echo ($ui_style['controls']['arrows']['type']=='default') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['arrows_nav']==0) ? 'ui_disabled':''; ?>"></i>
                                    <i title="<?php echo _("Arrows Prev/Next"); ?>" data-ui-target="ui_edit_arrows_nav" data-id-color="arrows" class="fa fa-chevron-right next_arrow noselect small-element <?php echo ($ui_style['controls']['arrows']['type']=='default') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['arrows_nav']==0) ? 'ui_disabled':''; ?>"></i>
                                </div>
                                <div id="info_control_center" title="<?php echo _("Info"); ?>" style="order:<?php echo ($ui_style['controls']['info']['order']); ?>;" data-ui-target="ui_edit_info" data-id-color="info" class="small-element controls_btn info_control <?php echo ($ui_style['controls']['info']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['info']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_info']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('info','icon'); ?><i style="<?php echo ($ui_style['controls']['info']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['info']['icon']; ?>"></i></div>
                                <div id="dollhouse_control_center" title="<?php echo _("3D View"); ?>" style="order:<?php echo ($ui_style['controls']['dollhouse']['order']); ?>;" data-ui-target="ui_edit_dollhouse" data-id-color="dollhouse" class="small-element controls_btn dollhouse_control <?php echo ($ui_style['controls']['dollhouse']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['dollhouse']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_dollhouse']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('dollhouse','icon'); ?><i style="<?php echo ($ui_style['controls']['dollhouse']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['dollhouse']['icon']; ?>"></i></div>
                                <div id="gallery_control_center" title="<?php echo _("Gallery"); ?>" style="order:<?php echo ($ui_style['controls']['gallery']['order']); ?>;" data-ui-target="ui_edit_gallery" data-id-color="gallery" class="small-element controls_btn gallery_control <?php echo ($ui_style['controls']['gallery']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['gallery']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_gallery']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('gallery','icon'); ?><i style="<?php echo ($ui_style['controls']['gallery']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['gallery']['icon']; ?>"></i></div>
                                <div id="facebook_control_center" title="<?php echo _("Facebook"); ?>" style="order:<?php echo ($ui_style['controls']['facebook']['order']); ?>;" data-ui-target="ui_edit_facebook" data-id-color="facebook" class="small-element controls_btn facebook_control <?php echo ($ui_style['controls']['facebook']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['facebook']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['fb_messenger'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('facebook','icon'); ?><i style="<?php echo ($ui_style['controls']['facebook']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['facebook']['icon']; ?>"></i></div>
                                <div id="whatsapp_control_center" title="<?php echo _("Whatsapp"); ?>" style="order:<?php echo ($ui_style['controls']['whatsapp']['order']); ?>;" data-ui-target="ui_edit_whatsapp" data-id-color="whatsapp" class="small-element controls_btn whatsapp_control <?php echo ($ui_style['controls']['whatsapp']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['whatsapp']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['whatsapp_chat'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('whatsapp','icon'); ?><i style="<?php echo ($ui_style['controls']['whatsapp']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['whatsapp']['icon']; ?>"></i></div>
                                <div id="presentation_control_center" title="<?php echo _("Presentation"); ?>" style="order:<?php echo ($ui_style['controls']['presentation']['order']); ?>;" data-ui-target="ui_edit_presentation" data-id-color="presentation" class="small-element controls_btn presentation_control <?php echo ($ui_style['controls']['presentation']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['presentation']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_presentation']==0) ? 'ui_disabled':''; ?>"><?php echo print_library_icon('presentation','icon'); ?><i style="<?php echo ($ui_style['controls']['presentation']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['presentation']['icon']; ?>"></i></div>
                                <div id="form_control_center" title="<?php echo _("Main Form"); ?>" style="order:<?php echo ($ui_style['controls']['form']['order']); ?>;" data-ui-target="ui_edit_form" data-id-color="form" class="small-element controls_btn form_control <?php echo ($ui_style['controls']['form']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['form']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_main_form'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('form','icon'); ?><i style="<?php echo ($ui_style['controls']['form']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['form']['icon']; ?>"></i></div>
                                <div id="share_control_center" title="<?php echo _("Share"); ?>" style="order:<?php echo ($ui_style['controls']['share']['order']); ?>;" data-ui-target="ui_edit_share" data-id-color="share" class="small-element controls_btn share_control <?php echo ($ui_style['controls']['share']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['share']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_share']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('share','icon'); ?><i style="<?php echo ($ui_style['controls']['share']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['share']['icon']; ?>"></i></div>
                                <div id="live_control_center" title="<?php echo _("Live Session"); ?>" style="order:<?php echo ($ui_style['controls']['live']['order']); ?>;" data-ui-target="ui_edit_live_session" data-id-color="live" class="small-element controls_btn live_control <?php echo ($ui_style['controls']['live']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['live']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['live_session'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('live','icon'); ?><i style="<?php echo ($ui_style['controls']['live']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['live']['icon']; ?>"></i></div>
                                <div id="meeting_control_center" title="<?php echo _("Meeting"); ?>" style="order:<?php echo ($ui_style['controls']['meeting']['order']); ?>;" data-ui-target="ui_edit_meeting" data-id-color="meeting" class="small-element controls_btn meeting_control <?php echo ($ui_style['controls']['meeting']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['meeting']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['meeting']==0) ? 'ui_disabled':''; ?>"><?php echo print_library_icon('meeting','icon'); ?><i style="<?php echo ($ui_style['controls']['meeting']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['meeting']['icon']; ?>"></i></div>
                                <div id="vr_control_center" title="<?php echo _("Web VR"); ?>" style="order:<?php echo ($ui_style['controls']['vr']['order']); ?>;" data-ui-target="ui_edit_vr" data-id-color="vr" class="small-element controls_btn vr_control <?php echo ($ui_style['controls']['vr']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['vr']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_webvr'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('vr','icon'); ?><i style="<?php echo ($ui_style['controls']['vr']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['vr']['icon']; ?>"></i></div>
                                <div id="compass_control_center" title="<?php echo _("Compass"); ?>" style="order:<?php echo ($ui_style['controls']['compass']['order']); ?>;" data-ui-target="ui_edit_compass" data-id-color="compass" class="small-element controls_btn compass_control <?php echo ($ui_style['controls']['compass']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($virtual_tour['compass'])?'':'ui_disabled'; ?>"><i class="icon-compass"></i></div>
                                <div id="custom_control_center" title="<?php echo $ui_style['controls']['custom']['label']; ?>" style="order:<?php echo ($ui_style['controls']['custom']['order']); ?>;" data-ui-target="ui_edit_custom" data-id-color="custom" class="small-element controls_btn custom_control <?php echo ($ui_style['controls']['custom']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['custom']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_custom']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('custom','icon'); ?><i style="<?php echo ($ui_style['controls']['custom']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['custom']['icon']; ?>"></i></div>
                                <div id="custom2_control_center" title="<?php echo $ui_style['controls']['custom2']['label']; ?>" style="order:<?php echo ($ui_style['controls']['custom2']['order']); ?>;" data-ui-target="ui_edit_custom2" data-id-color="custom2" class="small-element controls_btn custom2_control <?php echo ($ui_style['controls']['custom2']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['custom2']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_custom2']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('custom2','icon'); ?><i style="<?php echo ($ui_style['controls']['custom2']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['custom2']['icon']; ?>"></i></div>
                                <div id="custom3_control_center" title="<?php echo $ui_style['controls']['custom3']['label']; ?>" style="order:<?php echo ($ui_style['controls']['custom3']['order']); ?>;" data-ui-target="ui_edit_custom3" data-id-color="custom3" class="small-element controls_btn custom3_control <?php echo ($ui_style['controls']['custom3']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['custom3']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_custom3']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('custom3','icon'); ?><i style="<?php echo ($ui_style['controls']['custom3']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['custom3']['icon']; ?>"></i></div>
                                <div id="custom4_control_center" title="<?php echo $ui_style['controls']['custom4']['label']; ?>" style="order:<?php echo ($ui_style['controls']['custom4']['order']); ?>;" data-ui-target="ui_edit_custom4" data-id-color="custom4" class="small-element controls_btn custom4_control <?php echo ($ui_style['controls']['custom4']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['custom4']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_custom4']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('custom4','icon'); ?><i style="<?php echo ($ui_style['controls']['custom4']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['custom4']['icon']; ?>"></i></div>
                                <div id="custom5_control_center" title="<?php echo $ui_style['controls']['custom5']['label']; ?>" style="order:<?php echo ($ui_style['controls']['custom5']['order']); ?>;" data-ui-target="ui_edit_custom5" data-id-color="custom5" class="small-element controls_btn custom5_control <?php echo ($ui_style['controls']['custom5']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['custom5']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_custom5']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('custom5','icon'); ?><i style="<?php echo ($ui_style['controls']['custom5']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['custom5']['icon']; ?>"></i></div>
                                <div id="location_control_center" title="<?php echo $ui_style['controls']['location']['label']; ?>" style="order:<?php echo ($ui_style['controls']['location']['order']); ?>;" data-ui-target="ui_edit_location" data-id-color="location" class="small-element controls_btn location_control <?php echo ($ui_style['controls']['location']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['location']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_location']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('location','icon'); ?><i style="<?php echo ($ui_style['controls']['location']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['location']['icon']; ?>"></i></div>
                                <div id="media_control_center" title="<?php echo $ui_style['controls']['media']['label']; ?>" style="order:<?php echo ($ui_style['controls']['media']['order']); ?>;" data-ui-target="ui_edit_media" data-id-color="media" class="small-element controls_btn media_control <?php echo ($ui_style['controls']['media']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['media']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_media']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('media','icon'); ?><i style="<?php echo ($ui_style['controls']['media']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['media']['icon']; ?>"></i></div>
                                <div id="snapshot_control_center" title="<?php echo _("Snapshot"); ?>" style="order:<?php echo ($ui_style['controls']['snapshot']['order']); ?>;" data-ui-target="ui_edit_snapshot" data-id-color="snapshot" class="small-element controls_btn snapshot_control <?php echo ($ui_style['controls']['snapshot']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['snapshot']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_snapshot']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('snapshot','icon'); ?><i style="<?php echo ($ui_style['controls']['snapshot']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['snapshot']['icon']; ?>"></i></div>
                                <div id="orient_control_center" title="<?php echo _("Device Orientation"); ?>" style="order:<?php echo ($ui_style['controls']['orient']['order']); ?>;" data-ui-target="ui_edit_orientation" data-id-color="orient" class="small-element controls_btn orient_control <?php echo ($ui_style['controls']['orient']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['orient']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_device_orientation']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('orient','icon'); ?><i style="<?php echo ($ui_style['controls']['orient']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['orient']['icon']; ?>"></i></div>
                                <div id="autorotate_control_center" title="<?php echo _("Auto Rotation"); ?>" style="order:<?php echo ($ui_style['controls']['autorotate']['order']); ?>;" data-ui-target="ui_edit_autorotation" data-id-color="autorotate" class="small-element controls_btn autorotate_control <?php echo ($ui_style['controls']['autorotate']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['autorotate']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['ar_simulator'])?'hidden_menu':''; ?> <?php echo ($virtual_tour['show_autorotation_toggle']==0 || $virtual_tour['autorotate_speed']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('autorotate','icon'); ?><i style="<?php echo ($ui_style['controls']['autorotate']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['autorotate']['icon']; ?>"></i></div>
                                <div id="icons_control_center" title="<?php echo _("Icons"); ?>" style="order:<?php echo ($ui_style['controls']['icons']['order']); ?>;" data-ui-target="ui_edit_icons" data-id-color="icons" class="small-element controls_btn icons_control <?php echo ($ui_style['controls']['icons']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['icons']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_icons_toggle']>0 && $virtual_tour['show_icons_content_toggle']==0 && $virtual_tour['show_icons_nav_toggle']==0)?'':'ui_disabled'; ?>"><?php echo print_library_icon('icons','icon'); ?><i style="<?php echo ($ui_style['controls']['icons']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['icons']['icon']; ?>"></i></div>
                                <div id="icons_content_control_center" title="<?php echo _("Content Icons"); ?>" style="order:<?php echo ($ui_style['controls']['icons_content']['order']); ?>;" data-ui-target="ui_edit_icons_content" data-id-color="icons_content" class="small-element controls_btn icons_content_control <?php echo ($ui_style['controls']['icons_content']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['icons_content']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_icons_content_toggle']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('icons_content','icon'); ?><i style="<?php echo ($ui_style['controls']['icons_content']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['icons_content']['icon']; ?>"></i></div>
                                <div id="icons_nav_control_center" title="<?php echo _("Navigation Icons"); ?>" style="order:<?php echo ($ui_style['controls']['icons_nav']['order']); ?>;" data-ui-target="ui_edit_icons_nav" data-id-color="icons_nav" class="small-element controls_btn icons_nav_control <?php echo ($ui_style['controls']['icons_nav']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['icons_nav']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_icons_nav_toggle']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('icons_nav','icon'); ?><i style="<?php echo ($ui_style['controls']['icons_nav']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['icons_nav']['icon']; ?>"></i></div>
                                <div id="measures_control_center" title="<?php echo _("Measures"); ?>" style="order:<?php echo ($ui_style['controls']['measures']['order']); ?>;" data-ui-target="ui_edit_measures" data-id-color="measures" class="small-element controls_btn measures_control <?php echo ($ui_style['controls']['measures']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['measures']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_measures_toggle']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('measures','icon'); ?><i style="<?php echo ($ui_style['controls']['measures']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['measures']['icon']; ?>"></i></div>
                                <div id="annotations_control_center" title="<?php echo _("Annotations"); ?>" style="order:<?php echo ($ui_style['controls']['annotations']['order']); ?>;" data-ui-target="ui_edit_annotations" data-id-color="annotations" class="small-element controls_btn annotations_control <?php echo ($ui_style['controls']['annotations']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['annotations']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_annotations']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('annotations','icon'); ?><i style="<?php echo ($ui_style['controls']['annotations']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['annotations']['icon']; ?>"></i></div>
                                <div id="fullscreen_alt_control_center" title="<?php echo _("Fullscreen"); ?>" style="order:<?php echo ($ui_style['controls']['fullscreen_alt']['order']); ?>;" data-ui-target="ui_edit_fullscreen" data-id-color="fullscreen_alt" class="small-element controls_btn fullscreen_alt_control <?php echo ($ui_style['controls']['fullscreen_alt']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['fullscreen_alt']['type']=='menu' || $ui_style['controls']['fullscreen_alt']['type']=='menulist') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_fullscreen']==0)?'ui_disabled':''; ?>"><i class="fas fa-expand"></i></div>
                                <div id="floorplan_alt_control_center" title="<?php echo _("Floorplan"); ?>" style="order:<?php echo ($ui_style['controls']['floorplan_alt']['order']); ?>;" data-ui-target="ui_edit_map" data-id-color="floorplan_alt" class="small-element controls_btn floorplan_alt_control <?php echo ($ui_style['controls']['floorplan_alt']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['floorplan_alt']['type']=='menu' || $ui_style['controls']['floorplan_alt']['type']=='menulist') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_map']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('floorplan_alt','icon'); ?><i style="<?php echo ($ui_style['controls']['floorplan_alt']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['floorplan_alt']['icon']; ?>"></i></div>
                                <div id="map_alt_control_center" title="<?php echo _("Map"); ?>" style="order:<?php echo ($ui_style['controls']['map_alt']['order']); ?>;" data-ui-target="ui_edit_map_tour" data-id-color="map_alt" class="small-element controls_btn map_alt_control <?php echo ($ui_style['controls']['map_alt']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['map_alt']['type']=='menu' || $ui_style['controls']['map_alt']['type']=='menulist') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_map_tour']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('map_alt','icon'); ?><i style="<?php echo ($ui_style['controls']['map_alt']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['map_alt']['icon']; ?>"></i></div>
                                <div id="song_alt_control_center" title="<?php echo _("Audio"); ?>" style="order:<?php echo ($ui_style['controls']['song_alt']['order']); ?>;" data-ui-target="ui_edit_audio" data-id-color="song_alt" class="small-element controls_btn song_alt_control <?php echo ($ui_style['controls']['song_alt']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['song_alt']['type']=='menu' || $ui_style['controls']['song_alt']['type']=='menulist') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_audio']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('song_alt','icon'); ?><i style="<?php echo ($ui_style['controls']['song_alt']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['song_alt']['icon']; ?>"></i></div>
                                <div id="language_alt_control_center" title="<?php echo _("Language"); ?>" style="order:<?php echo ($ui_style['controls']['language_alt']['order']); ?>;" data-ui-target="ui_edit_localization" data-id-color="language_alt" class="small-element controls_btn language_alt_control <?php echo ($ui_style['controls']['language_alt']['position']=='center') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['language_alt']['type']=='menu' || $ui_style['controls']['language_alt']['type']=='menulist') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_language']==0 || count($array_languages)<=1)?'ui_disabled':''; ?>"><img src="img/flags_lang/<?php echo $default_language; ?>.png?v=2"/></div>
                            </div>
                        </div>
                        <div id="controls_bottom_right">
                            <div id="controls_arrow_right" style="order:<?php echo ($ui_style['controls']['arrows']['order']); ?>;" class="controls_arrows noselect <?php echo ($ui_style['controls']['arrows']['position']=='right' || $ui_style['controls']['list']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['list']['type']=='default' && $ui_style['controls']['arrows']['type']=='default') ? 'ui_hidden' : ''; ?>">
                                <i title="<?php echo _("Room's List Slider"); ?>" data-ui-target="ui_edit_slider" data-id-color="list" class="fa fa-chevron-<?php echo ($virtual_tour['auto_show_slider']==1) ? 'down':'up'; ?> list_control_alt noselect small-element <?php echo ($ui_style['controls']['list']['type']=='default') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['auto_show_slider']==2) ? 'ui_disabled':''; ?>"></i>
                                <i title="<?php echo _("Arrows Prev/Next"); ?>" data-ui-target="ui_edit_arrows_nav" data-id-color="arrows" class="fa fa-chevron-left prev_arrow noselect small-element <?php echo ($ui_style['controls']['arrows']['type']=='default') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['arrows_nav']==0) ? 'ui_disabled':''; ?>"></i>
                                <i title="<?php echo _("Arrows Prev/Next"); ?>" data-ui-target="ui_edit_arrows_nav" data-id-color="arrows" class="fa fa-chevron-right next_arrow noselect small-element <?php echo ($ui_style['controls']['arrows']['type']=='default') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['arrows_nav']==0) ? 'ui_disabled':''; ?>"></i>
                            </div>
                            <div id="info_control_right" title="<?php echo _("Info"); ?>" style="order:<?php echo ($ui_style['controls']['info']['order']); ?>;" data-ui-target="ui_edit_info" data-id-color="info" class="small-element controls_btn info_control <?php echo ($ui_style['controls']['info']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['info']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_info']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('info','icon'); ?><i style="<?php echo ($ui_style['controls']['info']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['info']['icon']; ?>"></i></div>
                            <div id="dollhouse_control_right" title="<?php echo _("3D View"); ?>" style="order:<?php echo ($ui_style['controls']['dollhouse']['order']); ?>;" data-ui-target="ui_edit_dollhouse" data-id-color="dollhouse" class="small-element controls_btn dollhouse_control <?php echo ($ui_style['controls']['dollhouse']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['dollhouse']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_dollhouse']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('dollhouse','icon'); ?><i style="<?php echo ($ui_style['controls']['dollhouse']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['dollhouse']['icon']; ?>"></i></div>
                            <div id="gallery_control_right" title="<?php echo _("Gallery"); ?>" style="order:<?php echo ($ui_style['controls']['gallery']['order']); ?>;" data-ui-target="ui_edit_gallery" data-id-color="gallery" class="small-element controls_btn gallery_control <?php echo ($ui_style['controls']['gallery']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['gallery']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_gallery']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('gallery','icon'); ?><i style="<?php echo ($ui_style['controls']['gallery']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['gallery']['icon']; ?>"></i></div>
                            <div id="facebook_control_right" title="<?php echo _("Facebook"); ?>" style="order:<?php echo ($ui_style['controls']['facebook']['order']); ?>;" data-ui-target="ui_edit_facebook" data-id-color="facebook" class="small-element controls_btn facebook_control <?php echo ($ui_style['controls']['facebook']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['facebook']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['fb_messenger'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('facebook','icon'); ?><i style="<?php echo ($ui_style['controls']['facebook']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['facebook']['icon']; ?>"></i></div>
                            <div id="whatsapp_control_right" title="<?php echo _("Whatsapp"); ?>" style="order:<?php echo ($ui_style['controls']['whatsapp']['order']); ?>;" data-ui-target="ui_edit_whatsapp" data-id-color="whatsapp" class="small-element controls_btn whatsapp_control <?php echo ($ui_style['controls']['whatsapp']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['whatsapp']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['whatsapp_chat'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('whatsapp','icon'); ?><i style="<?php echo ($ui_style['controls']['whatsapp']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['whatsapp']['icon']; ?>"></i></div>
                            <div id="presentation_control_right" title="<?php echo _("Presentation"); ?>" style="order:<?php echo ($ui_style['controls']['presentation']['order']); ?>;" data-ui-target="ui_edit_presentation" data-id-color="presentation" class="small-element controls_btn presentation_control <?php echo ($ui_style['controls']['presentation']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['presentation']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_presentation']==0) ? 'ui_disabled':''; ?>"><?php echo print_library_icon('presentation','icon'); ?><i style="<?php echo ($ui_style['controls']['presentation']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['presentation']['icon']; ?>"></i></div>
                            <div id="form_control_right" title="<?php echo _("Main Form"); ?>" style="order:<?php echo ($ui_style['controls']['form']['order']); ?>;" data-ui-target="ui_edit_form" data-id-color="form" class="small-element controls_btn form_control <?php echo ($ui_style['controls']['form']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['form']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_main_form'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('form','icon'); ?><i style="<?php echo ($ui_style['controls']['form']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['form']['icon']; ?>"></i></div>
                            <div id="share_control_right" title="<?php echo _("Share"); ?>" style="order:<?php echo ($ui_style['controls']['share']['order']); ?>;" data-ui-target="ui_edit_share" data-id-color="share" class="small-element controls_btn share_control <?php echo ($ui_style['controls']['share']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['share']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_share']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('share','icon'); ?><i style="<?php echo ($ui_style['controls']['share']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['share']['icon']; ?>"></i></div>
                            <div id="live_control_right" title="<?php echo _("Live Session"); ?>" style="order:<?php echo ($ui_style['controls']['live']['order']); ?>;" data-ui-target="ui_edit_live_session" data-id-color="live" class="small-element controls_btn live_control <?php echo ($ui_style['controls']['live']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['live']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['live_session'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('live','icon'); ?><i style="<?php echo ($ui_style['controls']['live']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['live']['icon']; ?>"></i></div>
                            <div id="meeting_control_right" title="<?php echo _("Meeting"); ?>" style="order:<?php echo ($ui_style['controls']['meeting']['order']); ?>;" data-ui-target="ui_edit_meeting" data-id-color="meeting" class="small-element controls_btn meeting_control <?php echo ($ui_style['controls']['meeting']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['meeting']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['meeting']==0) ? 'ui_disabled':''; ?>"><?php echo print_library_icon('meeting','icon'); ?><i style="<?php echo ($ui_style['controls']['meeting']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['meeting']['icon']; ?>"></i></div>
                            <div id="vr_control_right" title="<?php echo _("Web VR"); ?>" style="order:<?php echo ($ui_style['controls']['vr']['order']); ?>;" data-ui-target="ui_edit_vr" data-id-color="vr" class="small-element controls_btn vr_control <?php echo ($ui_style['controls']['vr']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['vr']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_webvr'])?'':'ui_disabled'; ?>"><?php echo print_library_icon('vr','icon'); ?><i style="<?php echo ($ui_style['controls']['vr']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['vr']['icon']; ?>"></i></div>
                            <div id="compass_control_right" title="<?php echo _("Compass"); ?>" style="order:<?php echo ($ui_style['controls']['compass']['order']); ?>;" data-ui-target="ui_edit_compass" data-id-color="compass" class="small-element controls_btn compass_control <?php echo ($ui_style['controls']['compass']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($virtual_tour['compass'])?'':'ui_disabled'; ?>"><i class="icon-compass"></i></div>
                            <div id="custom_control_right" title="<?php echo $ui_style['controls']['custom']['label']; ?>" style="order:<?php echo ($ui_style['controls']['custom']['order']); ?>;" data-ui-target="ui_edit_custom" data-id-color="custom" class="small-element controls_btn custom_control <?php echo ($ui_style['controls']['custom']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['custom']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_custom']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('custom','icon'); ?><i style="<?php echo ($ui_style['controls']['custom']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['custom']['icon']; ?>"></i></div>
                            <div id="custom2_control_right" title="<?php echo $ui_style['controls']['custom2']['label']; ?>" style="order:<?php echo ($ui_style['controls']['custom2']['order']); ?>;" data-ui-target="ui_edit_custom2" data-id-color="custom2" class="small-element controls_btn custom2_control <?php echo ($ui_style['controls']['custom2']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['custom2']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_custom2']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('custom2','icon'); ?><i style="<?php echo ($ui_style['controls']['custom2']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['custom2']['icon']; ?>"></i></div>
                            <div id="custom3_control_right" title="<?php echo $ui_style['controls']['custom3']['label']; ?>" style="order:<?php echo ($ui_style['controls']['custom3']['order']); ?>;" data-ui-target="ui_edit_custom3" data-id-color="custom3" class="small-element controls_btn custom3_control <?php echo ($ui_style['controls']['custom3']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['custom3']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_custom3']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('custom3','icon'); ?><i style="<?php echo ($ui_style['controls']['custom3']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['custom3']['icon']; ?>"></i></div>
                            <div id="custom4_control_right" title="<?php echo $ui_style['controls']['custom4']['label']; ?>" style="order:<?php echo ($ui_style['controls']['custom4']['order']); ?>;" data-ui-target="ui_edit_custom4" data-id-color="custom4" class="small-element controls_btn custom4_control <?php echo ($ui_style['controls']['custom4']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['custom4']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_custom4']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('custom4','icon'); ?><i style="<?php echo ($ui_style['controls']['custom4']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['custom4']['icon']; ?>"></i></div>
                            <div id="custom5_control_right" title="<?php echo $ui_style['controls']['custom5']['label']; ?>" style="order:<?php echo ($ui_style['controls']['custom5']['order']); ?>;" data-ui-target="ui_edit_custom5" data-id-color="custom5" class="small-element controls_btn custom5_control <?php echo ($ui_style['controls']['custom5']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['custom5']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_custom5']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('custom5','icon'); ?><i style="<?php echo ($ui_style['controls']['custom5']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['custom5']['icon']; ?>"></i></div>
                            <div id="location_control_right" title="<?php echo $ui_style['controls']['location']['label']; ?>" style="order:<?php echo ($ui_style['controls']['location']['order']); ?>;" data-ui-target="ui_edit_location" data-id-color="location" class="small-element controls_btn location_control <?php echo ($ui_style['controls']['location']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['location']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_location']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('location','icon'); ?><i style="<?php echo ($ui_style['controls']['location']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['location']['icon']; ?>"></i></div>
                            <div id="media_control_right" title="<?php echo $ui_style['controls']['media']['label']; ?>" style="order:<?php echo ($ui_style['controls']['media']['order']); ?>;" data-ui-target="ui_edit_media" data-id-color="media" class="small-element controls_btn media_control <?php echo ($ui_style['controls']['media']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['media']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_media']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('media','icon'); ?><i style="<?php echo ($ui_style['controls']['media']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['media']['icon']; ?>"></i></div>
                            <div id="snapshot_control_right" title="<?php echo _("Snapshot"); ?>" style="order:<?php echo ($ui_style['controls']['snapshot']['order']); ?>;" data-ui-target="ui_edit_snapshot" data-id-color="snapshot" class="small-element controls_btn snapshot_control <?php echo ($ui_style['controls']['snapshot']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['snapshot']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_snapshot']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('snapshot','icon'); ?><i style="<?php echo ($ui_style['controls']['snapshot']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['snapshot']['icon']; ?>"></i></div>
                            <div id="orient_control_right" title="<?php echo _("Device Orientation"); ?>" style="order:<?php echo ($ui_style['controls']['orient']['order']); ?>;" data-ui-target="ui_edit_orientation" data-id-color="orient" class="small-element controls_btn orient_control <?php echo ($ui_style['controls']['orient']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['orient']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_device_orientation']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('orient','icon'); ?><i style="<?php echo ($ui_style['controls']['orient']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['orient']['icon']; ?>"></i></div>
                            <div id="autorotate_control_right" title="<?php echo _("Auto Rotation"); ?>" style="order:<?php echo ($ui_style['controls']['autorotate']['order']); ?>;" data-ui-target="ui_edit_autorotation" data-id-color="autorotate" class="small-element controls_btn autorotate_control <?php echo ($ui_style['controls']['autorotate']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['autorotate']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['ar_simulator'])?'hidden_menu':''; ?> <?php echo ($virtual_tour['show_autorotation_toggle']==0 || $virtual_tour['autorotate_speed']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('autorotate','icon'); ?><i style="<?php echo ($ui_style['controls']['autorotate']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['autorotate']['icon']; ?>"></i></div>
                            <div id="icons_control_right" title="<?php echo _("Icons"); ?>" style="order:<?php echo ($ui_style['controls']['icons']['order']); ?>;" data-ui-target="ui_edit_icons" data-id-color="icons" class="small-element controls_btn icons_control <?php echo ($ui_style['controls']['icons']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['icons']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_icons_toggle']>0 && $virtual_tour['show_icons_content_toggle']==0 && $virtual_tour['show_icons_nav_toggle']==0)?'':'ui_disabled'; ?>"><?php echo print_library_icon('icons','icon'); ?><i style="<?php echo ($ui_style['controls']['icons']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['icons']['icon']; ?>"></i></div>
                            <div id="icons_content_control_right" title="<?php echo _("Content Icons"); ?>" style="order:<?php echo ($ui_style['controls']['icons_content']['order']); ?>;" data-ui-target="ui_edit_icons_content" data-id-color="icons_content" class="small-element controls_btn icons_content_control <?php echo ($ui_style['controls']['icons_content']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['icons_content']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_icons_content_toggle']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('icons_content','icon'); ?><i style="<?php echo ($ui_style['controls']['icons_content']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['icons_content']['icon']; ?>"></i></div>
                            <div id="icons_nav_control_right" title="<?php echo _("Navigation Icons"); ?>" style="order:<?php echo ($ui_style['controls']['icons_nav']['order']); ?>;" data-ui-target="ui_edit_icons_nav" data-id-color="icons_nav" class="small-element controls_btn icons_nav_control <?php echo ($ui_style['controls']['icons_nav']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['icons_nav']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_icons_nav_toggle']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('icons_nav','icon'); ?><i style="<?php echo ($ui_style['controls']['icons_nav']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['icons_nav']['icon']; ?>"></i></div>
                            <div id="measures_control_right" title="<?php echo _("Measures"); ?>" style="order:<?php echo ($ui_style['controls']['measures']['order']); ?>;" data-ui-target="ui_edit_measures" data-id-color="measures" class="small-element controls_btn measures_control <?php echo ($ui_style['controls']['measures']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['measures']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_measures_toggle']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('measures','icon'); ?><i style="<?php echo ($ui_style['controls']['measures']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['measures']['icon']; ?>"></i></div>
                            <div id="annotations_control_right" title="<?php echo _("Annotations"); ?>" style="order:<?php echo ($ui_style['controls']['annotations']['order']); ?>;" data-ui-target="ui_edit_annotations" data-id-color="annotations" class="small-element controls_btn annotations_control <?php echo ($ui_style['controls']['annotations']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['annotations']['type']=='menu') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_annotations']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('annotations','icon'); ?><i style="<?php echo ($ui_style['controls']['annotations']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['annotations']['icon']; ?>"></i></div>
                            <div id="fullscreen_alt_control_right" title="<?php echo _("Fullscreen"); ?>" style="order:<?php echo ($ui_style['controls']['fullscreen_alt']['order']); ?>;" data-ui-target="ui_edit_fullscreen" data-id-color="fullscreen_alt" class="small-element controls_btn fullscreen_alt_control <?php echo ($ui_style['controls']['fullscreen_alt']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['fullscreen_alt']['type']=='menu' || $ui_style['controls']['fullscreen_alt']['type']=='menulist') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_fullscreen']==0)?'ui_disabled':''; ?>"><i class="fas fa-expand"></i></div>
                            <div id="floorplan_alt_control_right" title="<?php echo _("Floorplan"); ?>" style="order:<?php echo ($ui_style['controls']['floorplan_alt']['order']); ?>;" data-ui-target="ui_edit_map" data-id-color="floorplan_alt" class="small-element controls_btn floorplan_alt_control <?php echo ($ui_style['controls']['floorplan_alt']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['floorplan_alt']['type']=='menu' || $ui_style['controls']['floorplan_alt']['type']=='menulist') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_map']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('floorplan_alt','icon'); ?><i style="<?php echo ($ui_style['controls']['floorplan_alt']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['floorplan_alt']['icon']; ?>"></i></div>
                            <div id="map_alt_control_right" title="<?php echo _("Map"); ?>" style="order:<?php echo ($ui_style['controls']['map_alt']['order']); ?>;" data-ui-target="ui_edit_map_tour" data-id-color="map_alt" class="small-element controls_btn map_alt_control <?php echo ($ui_style['controls']['map_alt']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['map_alt']['type']=='menu' || $ui_style['controls']['map_alt']['type']=='menulist') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_map_tour']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('map_alt','icon'); ?><i style="<?php echo ($ui_style['controls']['map_alt']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['map_alt']['icon']; ?>"></i></div>
                            <div id="song_alt_control_right" title="<?php echo _("Audio"); ?>" style="order:<?php echo ($ui_style['controls']['song_alt']['order']); ?>;" data-ui-target="ui_edit_audio" data-id-color="song_alt" class="small-element controls_btn song_alt_control <?php echo ($ui_style['controls']['song_alt']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['song_alt']['type']=='menu' || $ui_style['controls']['song_alt']['type']=='menulist') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_audio']==0)?'ui_disabled':''; ?>"><?php echo print_library_icon('song_alt','icon'); ?><i style="<?php echo ($ui_style['controls']['song_alt']['icon_library']!=0) ? 'display:none':''; ?>" class="<?php echo $ui_style['controls']['song_alt']['icon']; ?>"></i></div>
                            <div id="language_alt_control_right" title="<?php echo _("Language"); ?>" style="order:<?php echo ($ui_style['controls']['language_alt']['order']); ?>;" data-ui-target="ui_edit_localization" data-id-color="language_alt" class="small-element controls_btn language_alt_control <?php echo ($ui_style['controls']['language_alt']['position']=='right') ? '' : 'ui_hidden'; ?> <?php echo ($ui_style['controls']['language_alt']['type']=='menu' || $ui_style['controls']['language_alt']['type']=='menulist') ? 'ui_hidden' : ''; ?> <?php echo ($virtual_tour['show_language']==0 || count($array_languages)<=1)?'ui_disabled':''; ?>"><img src="img/flags_lang/<?php echo $default_language; ?>.png?v=2"/></div>
                        </div>
                    </div>
                    <div class="list_slider noselect <?php echo ($virtual_tour['ar_simulator'])?'hidden_menu':''; ?> <?php echo ($virtual_tour['auto_show_slider']==2) ? 'ui_disabled':''; ?>">
                        <ul title="<?php echo _("Room's List Slider"); ?>" data-ui-target="ui_edit_slider" class="slidee noselect <?php echo ($virtual_tour['auto_show_slider']==2) ? 'ui_disabled':''; ?>">
                            <li data-ui-target="ui_edit_slider" class="pointer_list pointer_list_1 active <?php echo ($virtual_tour['auto_show_slider']==2) ? 'ui_disabled':''; ?>"><img data-ui-target="ui_edit_slider" src="<?php echo $room1_pano; ?>" /><span data-ui-target="ui_edit_slider" class="room_name_slider noselect"><?php echo $room1_name; ?></span></li>
                            <li data-ui-target="ui_edit_slider" class="pointer_list pointer_list_2 <?php echo ($virtual_tour['auto_show_slider']==2) ? 'ui_disabled':''; ?>"><img data-ui-target="ui_edit_slider" src="<?php echo $room2_pano; ?>" /><span data-ui-target="ui_edit_slider" class="room_name_slider noselect"><?php echo $room2_name; ?></span></li>
                            <li data-ui-target="ui_edit_slider" class="pointer_list pointer_list_3 <?php echo ($virtual_tour['auto_show_slider']==2) ? 'ui_disabled':''; ?>"><img data-ui-target="ui_edit_slider" src="<?php echo $room3_pano; ?>" /><span data-ui-target="ui_edit_slider" class="room_name_slider noselect"><?php echo $room3_name; ?></span></li>
                        </ul>
                        <i title="<?php echo _("Arrows Room's List Slider"); ?>" data-ui-target="ui_edit_slider_nav" class="list_left fa fa-chevron-left <?php echo ($virtual_tour['nav_slider']==2)?'ui_disabled':''; ?> <?php echo ($virtual_tour['auto_show_slider']==2) ? 'ui_disabled':''; ?>"></i>
                        <i title="<?php echo _("Arrows Room's List Slider"); ?>" data-ui-target="ui_edit_slider_nav" class="list_right fa fa-chevron-right <?php echo ($virtual_tour['nav_slider']==2)?'ui_disabled':''; ?> <?php echo ($virtual_tour['auto_show_slider']==2) ? 'ui_disabled':''; ?>"></i>
                    </div>
                    <div style="width:100%;height:100%;" id="div_panorama">
                        <div style="width:100%;height:100%" id="panorama"></div>
                        <div style="width:100%;height:100%;display:none;" id="panorama_video"></div>
                    </div>
                </div>
                <div id="ui_edit_ui_style" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("UI Style"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="buttons_style"><?php echo _("Buttons Style"); ?></label><br>
                                    <select onchange="save_vt_ui(false,false,false);" id="buttons_style" class="form-control form-control-sm">
                                        <option <?php echo ($ui_style['buttons_style']=='default')?'selected':''; ?> id="default"><?php echo _("Circle"); ?></option>
                                        <option <?php echo ($ui_style['buttons_style']=='square')?'selected':''; ?> id="square"><?php echo _("Square"); ?></option>
                                        <option <?php echo ($ui_style['buttons_style']=='bar')?'selected':''; ?> id="bar"><?php echo _("Bar"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="buttons_size"><?php echo _("Buttons Size"); ?></label><br>
                                    <select onchange="save_vt_ui(false,false,false);" id="buttons_size" class="form-control form-control-sm">
                                        <option <?php echo ($ui_style['buttons_size']=='small')?'selected':''; ?> id="small"><?php echo _("Small"); ?></option>
                                        <option <?php echo ($ui_style['buttons_size']=='default')?'selected':''; ?> id="default"><?php echo _("Medium"); ?></option>
                                        <option <?php echo ($ui_style['buttons_size']=='large')?'selected':''; ?> id="large"><?php echo _("Large"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label for="icons_tooltips"><?php echo _("Tooltips"); ?></label><br>
                                <input <?php echo ($ui_style['icons_tooltips']==1) ? 'checked' : '' ; ?> id="icons_tooltips" type="checkbox" />
                            </div>
                        </div>
                    </div>
                </div>
                <div id="ui_edit_title" class="ui_edit_box noselect" style="top:230px">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Tour Title"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_vt_title"><?php echo _("Show"); ?></label><br>
                                    <select onchange="save_vt_ui(false,false,false);" id="show_vt_title" class="form-control form-control-sm">
                                        <option <?php echo ($virtual_tour['show_vt_title']==0)?'selected':''; ?> id="0"><?php echo _("Hidden"); ?></option>
                                        <option <?php echo ($virtual_tour['show_vt_title']==2)?'selected':''; ?> id="2"><?php echo _("Visible (only tour)"); ?></option>
                                        <option <?php echo ($virtual_tour['show_vt_title']==3)?'selected':''; ?> id="3"><?php echo _("Visible (only room)"); ?></option>
                                        <option <?php echo ($virtual_tour['show_vt_title']==1)?'selected':''; ?> id="1"><?php echo _("Visible (tour and room)"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="vt_title_height"><?php echo _("Background Height"); ?></label><br>
                                    <input style="width:100%" onchange="save_vt_ui(false,false,false);" type="number" id="vt_title_height" value="<?php echo $ui_style['items']['title']['background_height']; ?>" />
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('title',true,false); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('title',false,true); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="ui_edit_multiple_room_views" class="ui_edit_box noselect" style="top:230px">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Multiple Room Views"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="enable_rooms_multiple"><?php echo _("Show"); ?></label><br>
                                    <input onchange="save_vt_ui(false,false,false);" type="checkbox" id="enable_rooms_multiple" <?php echo ($virtual_tour['enable_rooms_multiple'])?'checked':''; ?> />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="multiple_room_views_style"><?php echo _("Style"); ?></label>
                                    <select onchange="save_vt_ui(false,false,false);" class="form-control form-control-sm" id="multiple_room_views_style">
                                        <option <?php echo ($ui_style['items']['multiple_room_views']['style']=='round') ? 'selected' : ''; ?> id="round"><?php echo _("Round"); ?></option>
                                        <option <?php echo ($ui_style['items']['multiple_room_views']['style']=='square') ? 'selected' : ''; ?> id="square"><?php echo _("Square"); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="multiple_room_views_size"><?php echo _("Size"); ?></label><br>
                                    <input min="10" max="120" step="1" class="form-control form-control-sm" style="width:100%" onchange="save_vt_ui(false,false,false);" type="number" id="multiple_room_views_size" value="<?php echo $ui_style['items']['multiple_room_views']['size']; ?>" />
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="multiple_room_views_border"><?php echo _("Border Size"); ?></label><br>
                                    <input min="0" max="20" step="1" class="form-control form-control-sm" style="width:100%" onchange="save_vt_ui(false,false,false);" type="number" id="multiple_room_views_border" value="<?php echo $ui_style['items']['multiple_room_views']['border']; ?>" />
                                </div>
                            </div>
                            <div class="col-md-4">
                                <?php echo print_ui_main_color('multiple_room_views',true,false); ?>
                            </div>
                        </div>
                    </div>
                    <hr class="my-0 py-0">
                    <div class="ui_title_msg py-1 px-3 noselect"><i class="fas fa-exclamation-circle"></i>&nbsp;&nbsp;<?php echo _("upload in: virtual tours - rooms - edit - multiple room views tab"); ?></div>
                </div>
                <div id="ui_edit_visitors" class="ui_edit_box noselect" style="top:230px">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Visitors"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-<?php echo ($user_info['role']=='administrator') ? 4 : 6; ?>">
                                <div class="form-group">
                                    <label for="enable_views_stat"><?php echo _("Total Views"); ?> <i title="<?php echo _("enables viewing of total views directly on the tour"); ?>" class="help_t fas fa-question-circle"></i></label><br>
                                    <input onchange="save_vt_ui(false,false,false);" type="checkbox" id="enable_views_stat" <?php echo ($virtual_tour['enable_views_stat']==1) ? 'checked':''; ?>>
                                </div>
                            </div>
                            <div class="col-md-<?php echo ($user_info['role']=='administrator') ? 4 : 6; ?>">
                                <div class="form-group">
                                    <label for="enable_visitor_rt"><?php echo _("Visitors"); ?> <i title="<?php echo _("enables viewing of online visitors directly on the tour"); ?>" class="help_t fas fa-question-circle"></i></label><br>
                                    <input onchange="save_vt_ui(false,false,false);" type="checkbox" id="enable_visitor_rt" <?php echo ($virtual_tour['enable_visitor_rt']==1) ? 'checked':''; ?>>
                                </div>
                            </div>
                            <div class="col-md-4 <?php echo ($user_info['role']=='administrator') ? '' : 'd-none'; ?>">
                                <div class="form-group">
                                    <label for="interval_visitor_rt"><?php echo _("Visitors update"); ?> <i title="<?php echo _("visitor update time in milliseconds (0 = real time). Low values can increase server utilization."); ?>" class="help_t fas fa-question-circle"></i></label><br>
                                    <div class="input-group">
                                        <input type="number" min="0" class="form-control" id="interval_visitor_rt" value="<?php echo $virtual_tour['interval_visitor_rt']; ?>" />
                                        <div class="input-group-append">
                                            <span class="input-group-text">ms</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('visitors_rt_stats',true,false); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('visitors_rt_stats',false,true); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="ui_edit_localization" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Localization"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_language"><?php echo _("Show"); ?></label><br>
                                    <input onchange="save_vt_ui(false,false,false);" type="checkbox" id="show_language" <?php echo ($virtual_tour['show_language'])?'checked':''; ?> />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('language_alt',''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="language"><?php echo _("Default Language"); ?></label>
                                    <select onchange="save_vt_ui(false,false,false);" class="form-control <?php echo ($edit_version) ? 'disabled_d' : ''; ?>" id="language">
                                        <?php if((!check_language_enabled_viewer('en_US',$settings['languages_enabled']) && check_language_enabled_viewer('en_GB',$settings['languages_enabled'])) || (check_language_enabled_viewer('en_US',$settings['languages_enabled']) && !check_language_enabled_viewer('en_GB',$settings['languages_enabled']))) {
                                            $languages_list['en_GB']['name'] = "English";
                                            $languages_list['en_US']['name'] = "English";
                                        } ?>
                                        <option <?php echo ($virtual_tour['language']=='') ? 'selected':''; ?> id=""><?php echo _("Default")." ({$settings['language']})"; ?></option>
                                        <?php foreach ($languages_list as $lang_code => $lang_data): ?>
                                            <?php if (check_language_enabled_viewer($lang_code, $settings['languages_viewer_enabled'])): ?>
                                                <option <?php echo ($virtual_tour['language']==$lang_code) ? 'selected':''; ?> id="<?php echo $lang_code; ?>"><?php echo $lang_data['name']." - ".$lang_data['native_name']." ($lang_code)"; ?></option>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    </select>
                                    <script type="text/javascript">
                                        var initialSelectedValue = $('#language option:selected').attr('id');
                                        $('#language').on('change', function (e) {
                                            var currentSelectedValue = $('#language option:selected').attr('id');
                                            var currentSelectedValues = $('#languages_enabled').val();
                                            if (currentSelectedValue!=initialSelectedValue && currentSelectedValues.length>0) {
                                                $('#modal_change_languages').modal('show');
                                            }
                                        });
                                    </script>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="languages_enabled"><?php echo _("Languages Enabled"); ?></label>
                                    <select <?php echo (!$plan_permissions['enable_multilanguage']) ? 'disabled' : '' ; ?> onchange="save_vt_ui(false,false,false);" style="height: 125px" multiple class="form-control selectpicker <?php echo ($edit_version) ? 'disabled_d' : ''; ?>" id="languages_enabled" data-container="body" data-actions-box="true" data-selected-text-format="count > 2" data-count-selected-text="{0} <?php echo _("items selected"); ?>" data-deselect-all-text="<?php echo _("Deselect All"); ?>" data-select-all-text="<?php echo _("Select All"); ?>" data-none-selected-text="<?php echo _("Only default"); ?>" data-none-results-text="<?php echo _("No results matched"); ?> {0}">
                                        <?php if((!check_language_enabled_viewer('en_US',$settings['languages_enabled']) && check_language_enabled_viewer('en_GB',$settings['languages_enabled'])) || (check_language_enabled_viewer('en_US',$settings['languages_enabled']) && !check_language_enabled_viewer('en_GB',$settings['languages_enabled']))) {
                                            $languages_list['en_GB']['name'] = "English";
                                            $languages_list['en_US']['name'] = "English";
                                        }
                                        foreach ($languages_list as $lang_code => $lang_data): ?>
                                            <?php if (check_language_enabled_viewer($lang_code, $settings['languages_viewer_enabled'])): ?>
                                                <option <?php echo (check_language_enabled_vt($lang_code,$settings['languages_viewer_enabled'],$virtual_tour['languages_enabled'])) ? 'selected':''; ?> id="ls_<?php echo $lang_code; ?>"><?php echo $lang_data['name']." - ".$lang_data['native_name']." ($lang_code)"; ?></option>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    </select>
                                    <script type="text/javascript">
                                        var initialSelectedValues = $('#languages_enabled').val().slice();
                                        $('#languages_enabled').selectpicker('render');
                                        $('#languages_enabled').on('hidden.bs.select', function (e) {
                                            var currentSelectedValues = $('#languages_enabled').val();
                                            if (currentSelectedValues.length !== initialSelectedValues.length ||
                                                currentSelectedValues.some(value => !initialSelectedValues.includes(value)) ||
                                                initialSelectedValues.some(value => !currentSelectedValues.includes(value))) {
                                                $('#modal_change_languages').modal('show');
                                            }
                                        });
                                    </script>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="ui_edit_comments" class="ui_edit_box noselect" style="top:230px">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Comments"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_comments"><?php echo _("Show"); ?></label><br>
                                    <select onchange="save_vt_ui(false,false,false);" <?php echo (!$plan_permissions['enable_comments']) ? 'disabled' : '' ; ?> id="show_comments" class="form-control form-control-sm">
                                        <option <?php echo ($virtual_tour['show_comments']==0)?'selected':''; ?> id="0"><?php echo _("Disabled"); ?></option>
                                        <option <?php echo ($virtual_tour['show_comments']==1)?'selected':''; ?> id="1"><?php echo _("Enabled (for entire tour)"); ?></option>
                                        <option <?php echo ($virtual_tour['show_comments']==2)?'selected':''; ?> id="2"><?php echo _("Enabled (for each rooms)"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('comments',true,false); ?>
                            </div>
                        </div>
                        <hr>
                        <div class="row <?php echo ($settings['disqus_allow_tour'] && $plan_permissions['enable_comments']) ? '':'d-none'; ?>">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="disqus_shortname">Disqus <?php echo _("Shortname"); ?> <i title="<?php echo _("leave empty for default setting"); ?>" class="help_t fas fa-question-circle"></i></label>
                                    <input type="text" class="form-control form-control-sm <?php echo ($edit_version) ? 'disabled_d' : ''; ?>" id="disqus_shortname" value="<?php echo $virtual_tour['disqus_shortname']; ?>" />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="disqus_public_key">Disqus <?php echo _("Public API Key"); ?> <i title="<?php echo _("leave empty for default setting"); ?>" class="help_t fas fa-question-circle"></i></label>
                                    <input autocomplete="new-password" class="form-control form-control-sm <?php echo ($edit_version) ? 'disabled_d' : ''; ?>" type="password" id="disqus_public_key" value="<?php echo ($virtual_tour['disqus_public_key']!='') ? 'keep_disqus_public_key' : ''; ?>" />
                                </div>
                            </div>
                        </div>
                        <div class="row <?php echo ($settings['disqus_allow_tour'] && $plan_permissions['enable_comments']) ? '':'d-none'; ?>">
                            <div class="col-md-12 mt-2 text-left">
                                1) <?php echo sprintf(_("Login into your %s account."),'<a class="text-primary" target="_blank" href="https://disqus.com/profile/signup/">Disqus <i class="fas fa-external-link-square-alt"></i></a>'); ?><br>
                                2) <?php echo sprintf(_("Create a new site %s and copy the <b>shortname</b> in the field above."),'<a class="text-primary" target="_blank" href="https://disqus.com/admin/create/">'._("here").' <i class="fas fa-external-link-square-alt"></i></a>'); ?><br>
                                2) <?php echo sprintf(_("Register a new API application %s, add your site domain as trusted domain and copy the generated <b>public key</b> in the field above."),'<a class="text-primary" target="_blank" href="https://disqus.com/api/applications/register/">'._("here").' <i class="fas fa-external-link-square-alt"></i></a>'); ?><br>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="ui_edit_audio" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Audio"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_audio"><?php echo _("Show"); ?></label><br>
                                    <input onchange="save_vt_ui(false,false,false);" <?php echo (!$plan_permissions['enable_song']) ? 'disabled' : '' ; ?> type="checkbox" id="show_audio" <?php echo ($virtual_tour['show_audio'])?'checked':''; ?> />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('song_alt',''); ?>
                            </div>
                        </div>
                        <div class="row song_alt_colors <?php echo ($ui_style['controls']['song_alt']['type']=='menu') ? 'd-none' : ''; ?>">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('song_alt'); ?>
                            </div>
                        </div>
                        <div class="row song_colors <?php echo ($ui_style['controls']['song_alt']['type']=='menu') ? '' : 'd-none'; ?>">
                            <div class="col-md-6">
                                <?php echo print_ui_icon_color('audio','song_control'); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_icon_color_hover('audio','song_control'); ?>
                            </div>
                        </div>
                        <div class="row song_alt_colors <?php echo ($ui_style['controls']['song_alt']['type']=='menu') ? 'd-none' : ''; ?>">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('song_alt',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('song_alt',true,true,true); ?>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="song_autoplay"><?php echo _("Autoplay Audio"); ?> <i title="<?php echo _("if the popup is not displayed until the user interacts with the borwser, the audio may not be heard"); ?>" class="help_t fas fa-question-circle"></i></label><br>
                                    <select onchange="save_vt_ui(false,false,false);" <?php echo (!$plan_permissions['enable_song']) ? 'disabled' : '' ; ?> id="song_autoplay" class="form-control form-control-sm">
                                        <option <?php echo ($virtual_tour['song_autoplay']==0)?'selected':''; ?> id="0"><?php echo _("Disabled"); ?></option>
                                        <option <?php echo ($virtual_tour['song_autoplay']==1)?'selected':''; ?> id="1"><?php echo _("Enabled, automatic"); ?></option>
                                        <option <?php echo ($virtual_tour['song_autoplay']==2)?'selected':''; ?> id="2"><?php echo _("Enabled, without pop-up"); ?></option>
                                        <option <?php echo ($virtual_tour['song_autoplay']==3)?'selected':''; ?> id="3"><?php echo _("Enabled, with pop-up"); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr class="my-0 py-0">
                    <div class="ui_title_msg py-1 px-3 noselect"><i class="fas fa-exclamation-circle"></i>&nbsp;&nbsp;<?php echo _("upload in: virtual tours - list tours - edit - contents tab - song").'&nbsp;&nbsp;<span onclick="open_modal_edit_contents(\'vt_content\');" class="editor_ui_shortcut_icon badge badge-primary"><i class="fas fa-external-link-alt"></i></span>'."<br>"._("virtual tours - rooms - edit - contents tab - audio"); ?></div>
                </div>
                <div id="ui_edit_fullscreen" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Fullscreen"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_fullscreen"><?php echo _("Show"); ?></label><br>
                                    <select onchange="save_vt_ui(false,false,false);" id="show_fullscreen" class="form-control form-control-sm">
                                        <option <?php echo ($virtual_tour['show_fullscreen']==0) ? 'selected':''; ?> id="0"><?php echo _("Hidden"); ?></option>
                                        <option <?php echo ($virtual_tour['show_fullscreen']==1) ? 'selected':''; ?> id="1"><?php echo _("Visible"); ?></option>
                                        <option <?php echo ($virtual_tour['show_fullscreen']==2) ? 'selected':''; ?> id="2"><?php echo _("Visible, enabled at start"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('fullscreen_alt',''); ?>
                            </div>
                        </div>
                        <div class="row fullscreen_colors <?php echo ($ui_style['controls']['fullscreen_alt']['type']=='menu') ? '' : 'd-none'; ?>">
                            <div class="col-md-6">
                                <?php echo print_ui_icon_color('fullscreen','fullscreen_control'); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_icon_color_hover('fullscreen','fullscreen_control'); ?>
                            </div>
                        </div>
                        <div class="row fullscreen_alt_colors <?php echo ($ui_style['controls']['fullscreen_alt']['type']=='menu') ? 'd-none' : ''; ?>">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('fullscreen_alt',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('fullscreen_alt',true,true,true); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="ui_edit_map" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Floorplan"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_map"><?php echo _("Show"); ?></label><br>
                                    <select onchange="save_vt_ui(false,false,false);" <?php echo (!$plan_permissions['enable_maps']) ? 'disabled' : '' ; ?> id="show_map" class="form-control form-control-sm">
                                        <option <?php echo ($virtual_tour['show_map']==0) ? 'selected':''; ?> id="0"><?php echo _("Hidden"); ?></option>
                                        <option <?php echo ($virtual_tour['show_map']==1) ? 'selected':''; ?> id="1"><?php echo _("Visible, minimized on Mobile"); ?></option>
                                        <option <?php echo ($virtual_tour['show_map']==2) ? 'selected':''; ?> id="2"><?php echo _("Visible, minimized on Desktop and Mobile"); ?></option>
                                        <option <?php echo ($virtual_tour['show_map']==3) ? 'selected':''; ?> id="3"><?php echo _("Visible, opened"); ?></option>
                                        <option <?php echo ($virtual_tour['show_map']==5) ? 'selected':''; ?> id="5"><?php echo _("Visible, opened fullscreen"); ?></option>
                                        <option <?php echo ($virtual_tour['show_map']==4) ? 'selected':''; ?> id="4"><?php echo _("Visible, no minimap"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('floorplan_alt',''); ?>
                            </div>
                        </div>
                        <div class="row floorplan_alt_colors <?php echo ($ui_style['controls']['floorplan_alt']['type']=='menu') ? 'd-none' : ''; ?>">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('floorplan_alt'); ?>
                            </div>
                        </div>
                        <div class="row floorplan_colors <?php echo ($ui_style['controls']['floorplan_alt']['type']=='menu') ? '' : 'd-none'; ?>">
                            <div class="col-md-6">
                                <?php echo print_ui_icon_color('floorplan','map_control'); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_icon_color_hover('floorplan','map_control'); ?>
                            </div>
                        </div>
                        <div class="row floorplan_alt_colors <?php echo ($ui_style['controls']['floorplan_alt']['type']=='menu') ? 'd-none' : ''; ?>">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('floorplan_alt',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('floorplan_alt',true,true,true); ?>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="map_position"><?php echo _("Position"); ?></label><br>
                                    <select onchange="save_vt_ui(false,false,false);" id="map_position" class="form-control form-control-sm">
                                        <option <?php echo ($ui_style['items']['map']['position']=='top_left') ? 'selected' : ''; ?> id="top_left"><?php echo _("Top Left"); ?></option>
                                        <option <?php echo ($ui_style['items']['map']['position']=='top_right') ? 'selected' : ''; ?> id="top_right"><?php echo _("Top Right"); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('map_bar',false,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('map_bar',true,false); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_icon_color_hover('map_bar','map_bar'); ?>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="autoclose_map"><?php echo _("Auto-close"); ?> <i title="<?php echo _("automatically closes the map when it is opened in full screen and an item in it is clicked"); ?>" class="help_t fas fa-question-circle"></i></label><br>
                                    <input onchange="save_vt_ui(false,false,false);" type="checkbox" id="autoclose_map" <?php echo ($virtual_tour['autoclose_map'])?'checked':''; ?> />
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr class="my-0 py-0">
                    <div class="ui_title_msg py-1 px-3 noselect"><i class="fas fa-exclamation-circle"></i>&nbsp;&nbsp;<?php echo _("upload in: virtual tours - maps"); ?>&nbsp;&nbsp;<span onclick="open_modal_edit_contents('maps');" class="editor_ui_shortcut_icon badge badge-primary"><i class="fas fa-external-link-alt"></i></span></div>
                </div>
                <div id="ui_edit_map_tour" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Map"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_map_tour"><?php echo _("Show"); ?></label><br>
                                    <select onchange="save_vt_ui(false,false,false);" <?php echo (!$plan_permissions['enable_maps']) ? 'disabled' : '' ; ?> id="show_map_tour" class="form-control form-control-sm">
                                        <option <?php echo ($virtual_tour['show_map_tour']==0) ? 'selected':''; ?> id="0"><?php echo _("Hidden"); ?></option>
                                        <option <?php echo ($virtual_tour['show_map_tour']==1) ? 'selected':''; ?> id="1"><?php echo _("Visible, minimized"); ?></option>
                                        <option <?php echo ($virtual_tour['show_map_tour']==2) ? 'selected':''; ?> id="2"><?php echo _("Visible, opened"); ?></option>
                                        <option <?php echo ($virtual_tour['show_map_tour']==4) ? 'selected':''; ?> id="4"><?php echo _("Visible, opened (only on desktop)"); ?></option>
                                        <option <?php echo ($virtual_tour['show_map_tour']==3) ? 'selected':''; ?> id="3"><?php echo _("Visible, opened fullscreen"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('map_alt',''); ?>
                            </div>
                        </div>
                        <div class="row map_alt_colors <?php echo ($ui_style['controls']['map_alt']['type']=='menu') ? 'd-none' : ''; ?>">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('map_alt'); ?>
                            </div>
                        </div>
                        <div class="row map_colors <?php echo ($ui_style['controls']['map_alt']['type']=='menu') ? '' : 'd-none'; ?>">
                            <div class="col-md-6">
                                <?php echo print_ui_icon_color('map','map_tour_control'); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_icon_color_hover('map','map_tour_control'); ?>
                            </div>
                        </div>
                        <div class="row map_alt_colors <?php echo ($ui_style['controls']['map_alt']['type']=='menu') ? 'd-none' : ''; ?>">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('map_alt',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('map_alt',true,true,true); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="ui_edit_list_alt" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Rooms List Menu"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_list_alt"><?php echo _("Show"); ?></label><br>
                                    <div class="input-group">
                                        <select onchange="save_vt_ui(false,false,false);" id="show_list_alt" class="form-control form-control-sm">
                                            <option <?php echo ($virtual_tour['show_list_alt']==0) ? 'selected':''; ?> id="0"><?php echo _("Hidden"); ?></option>
                                            <option <?php echo ($virtual_tour['show_list_alt']==1) ? 'selected':''; ?> id="1"><?php echo _("Visible, minimized"); ?></option>
                                            <option <?php echo ($virtual_tour['show_list_alt']==2) ? 'selected':''; ?> id="2"><?php echo _("Visible, opened"); ?></option>
                                        </select>
                                        <div class="input-group-append">
                                            <button data-toggle="modal" data-target="#modal_list_alt" class="btn btn-primary btn-sm" type="button"><i style="color: white" class="fas fa-cog"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="autoclose_list_alt"><?php echo _("Auto-close"); ?> <i title="<?php echo _("automatically closes the rooms list menu when you click on any item in it"); ?>" class="help_t fas fa-question-circle"></i></label><br>
                                    <input onchange="save_vt_ui(false,false,false);" type="checkbox" id="autoclose_list_alt" <?php echo ($virtual_tour['autoclose_list_alt'])?'checked':''; ?> />
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_icon_color('list_alt','list_alt_menu .title i'); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_icon_color_hover('list_alt','list_alt_menu .title i'); ?>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('list_alt_menu',true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('list_alt_menu',true,true); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('list_alt_menu_icon',true,false); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('list_alt_menu_icon',true,false); ?>
                            </div>
                        </div>
                    </div>
                    <hr class="my-0 py-0">
                    <div class="ui_title_msg py-1 px-3 noselect"><i class="fas fa-exclamation-circle"></i>&nbsp;&nbsp;<?php echo _("create in: click on gear button above"); ?></div>
                </div>
                <div id="ui_edit_menu" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Menu"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-8">
                                <div class="form-group">
                                    <label for="menu_type"><?php echo _("Type"); ?></label><br>
                                    <select onchange="save_vt_ui(false,false,false);" id="menu_type" class="form-control form-control-sm">
                                        <option <?php echo ($ui_style['sidebar']['enable']==0) ? 'selected':''; ?> id="dropdown"><?php echo _("Dropdown"); ?></option>
                                        <option <?php echo ($ui_style['sidebar']['enable']==1) ? 'selected':''; ?> id="sidebar"><?php echo _("Sidebar"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="autoopen_menu"><?php echo _("Auto-open"); ?> <i title="<?php echo _("automatically open the menu when the tour loads"); ?>" class="help_t fas fa-question-circle"></i></label><br>
                                    <input onchange="save_vt_ui(false,false,false);" type="checkbox" id="autoopen_menu" <?php echo ($virtual_tour['autoopen_menu'])?'checked':''; ?> />
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <?php echo print_ui_icon_color('menu','menu_controls .title i'); ?>
                            </div>
                            <div class="col-md-4">
                                <?php echo print_ui_icon_color_hover('menu','menu_controls .title i'); ?>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="autoclose_menu"><?php echo _("Auto-close"); ?> <i title="<?php echo _("automatically closes the menu when you click on any item in it"); ?>" class="help_t fas fa-question-circle"></i></label><br>
                                    <input onchange="save_vt_ui(false,false,false);" type="checkbox" id="autoclose_menu" <?php echo ($virtual_tour['autoclose_menu'])?'checked':''; ?> />
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div id="sidebar_options" class="<?php echo ($ui_style['controls']['sidebar']['enable']) ? 'd-none' : ''; ?>">
                            <div class="row">
                                <div class="col-md-4">
                                    <?php echo print_ui_main_color('menu_sidebar',false,true); ?>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="sidebar_glass"><?php echo _("Background Blur"); ?></label><br>
                                        <input onchange="save_vt_ui(false,false,false);" type="checkbox" id="sidebar_glass" <?php echo ($ui_style['sidebar']['glass'])?'checked':''; ?> />
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="sidebar_logo_height"><?php echo _("Logo Size"); ?></label><br>
                                        <input <?php echo (!$plan_permissions['enable_logo']) ? 'disabled' : '' ; ?> oninput="save_vt_ui(false,false,false);" class="form-control form-control-sm" type="number" min="0" id="sidebar_logo_height" value="<?php echo $ui_style['sidebar']['logo_height']; ?>" />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="ui_edit_annotations" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Annotations"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_annotations"><?php echo _("Show"); ?></label><br>
                                    <select onchange="save_vt_ui(false,false,false);" id="show_annotations" class="form-control form-control-sm <?php echo (!$plan_permissions['enable_annotations']) ? 'disabled' : '' ; ?>">
                                        <option <?php echo ($virtual_tour['show_annotations']==0) ? 'selected':''; ?> id="0"><?php echo _("Hidden"); ?></option>
                                        <option <?php echo ($virtual_tour['show_annotations']==1) ? 'selected':''; ?> id="1"><?php echo _("Visible, annotations shown"); ?></option>
                                        <option <?php echo ($virtual_tour['show_annotations']==2) ? 'selected':''; ?> id="2"><?php echo _("Visible, annotations hidden"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('annotations',''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('annotations'); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('annotations',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('annotations',true,true,true); ?>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="annotation_position"><?php echo _("Position"); ?></label><br>
                                    <select onchange="save_vt_ui(false,false,false);" id="annotation_position" class="form-control form-control-sm">
                                        <option <?php echo ($ui_style['items']['annotation']['position']=='top_left') ? 'selected' : ''; ?> id="top_left"><?php echo _("Top Left"); ?></option>
                                        <option <?php echo ($ui_style['items']['annotation']['position']=='top_right') ? 'selected' : ''; ?> id="top_right"><?php echo _("Top Right"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <?php echo print_ui_main_color('annotation',false,true); ?>
                            </div>
                            <div class="col-md-4">
                                <?php echo print_ui_main_color('annotation',true,false); ?>
                            </div>
                        </div>
                    </div>
                    <hr class="my-0 py-0">
                    <div class="ui_title_msg py-1 px-3 noselect"><i class="fas fa-exclamation-circle"></i>&nbsp;&nbsp;<?php echo _("create in: virtual tours - rooms - edit - contents tab - annotation"); ?></div>
                </div>
                <div id="ui_edit_inline_form" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Main Form - Inline"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_inline_form"><?php echo _("Show"); ?></label><br>
                                    <input onchange="save_vt_ui(false,false,false);" <?php echo (!$plan_permissions['enable_forms']) ? 'disabled' : '' ; ?> type="checkbox" id="show_inline_form" <?php echo ($virtual_tour['show_inline_form'])?'checked':''; ?> />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="inline_form_position"><?php echo _("Position"); ?></label><br>
                                    <select onchange="save_vt_ui(false,false,false);" id="inline_form_position" class="form-control form-control-sm">
                                        <option <?php echo ($ui_style['items']['inline_form']['position']=='top_left') ? 'selected' : ''; ?> id="top_left"><?php echo _("Top Left"); ?></option>
                                        <option <?php echo ($ui_style['items']['inline_form']['position']=='top_right') ? 'selected' : ''; ?> id="top_right"><?php echo _("Top Right"); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('inline_form',false,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('inline_form',true,false); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('inline_form_field',false,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('inline_form_field',true,false); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('inline_form_button',false,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('inline_form_button',true,false); ?>
                            </div>
                        </div>
                    </div>
                    <hr class="my-0 py-0">
                    <div class="ui_title_msg py-1 px-3 noselect"><i class="fas fa-exclamation-circle"></i>&nbsp;&nbsp;<?php echo _("create in: virtual tours - main form"); ?>&nbsp;&nbsp;<span onclick="open_modal_edit_contents('editor_form');" class="editor_ui_shortcut_icon badge badge-primary"><i class="fas fa-external-link-alt"></i></span></div>
                </div>
                <div id="ui_edit_logo" class="ui_edit_box noselect" style="top:230px">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Logo"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="show_logo"><?php echo _("Show"); ?></label><br>
                                    <select onchange="save_vt_ui(false,false,false);" id="show_logo" class="form-control form-control-sm <?php echo (!$plan_permissions['enable_logo']) ? 'disabled' : '' ; ?>">
                                        <option <?php echo ($virtual_tour['show_logo']==0) ? 'selected':''; ?> id="0"><?php echo _("Hidden"); ?></option>
                                        <option <?php echo ($virtual_tour['show_logo']==1) ? 'selected':''; ?> id="1"><?php echo _("Visible, Desktop and Mobile"); ?></option>
                                        <option <?php echo ($virtual_tour['show_logo']==2) ? 'selected':''; ?> id="2"><?php echo _("Visible, only on Desktop"); ?></option>
                                        <option <?php echo ($virtual_tour['show_logo']==3) ? 'selected':''; ?> id="3"><?php echo _("Visible, only on Mobile"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="logo_height"><?php echo _("Size"); ?></label><br>
                                    <input <?php echo (!$plan_permissions['enable_logo']) ? 'disabled' : '' ; ?> oninput="save_vt_ui(false,false,false);" class="form-control form-control-sm" type="number" min="0" id="logo_height" value="<?php echo $ui_style['items']['logo']['height']; ?>" />
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="logo_position"><?php echo _("Position"); ?></label><br>
                                    <select <?php echo (!$plan_permissions['enable_logo']) ? 'disabled' : '' ; ?> onchange="save_vt_ui(false,false,false);" id="logo_position" class="form-control form-control-sm">
                                        <option <?php echo ($ui_style['items']['logo']['position']=='top_left') ? 'selected' : ''; ?> id="top_left"><?php echo _("Top Left"); ?></option>
                                        <option <?php echo ($ui_style['items']['logo']['position']=='top_center') ? 'selected' : ''; ?> id="top_center"><?php echo _("Top Center"); ?></option>
                                        <option <?php echo ($ui_style['items']['logo']['position']=='top_right') ? 'selected' : ''; ?> id="top_right"><?php echo _("Top Right"); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="logo_padding_left"><?php echo _("Padding Left"); ?></label><br>
                                    <input <?php echo (!$plan_permissions['enable_logo']) ? 'disabled' : '' ; ?> oninput="save_vt_ui(false,false,false);" class="form-control form-control-sm" type="number" id="logo_padding_left" value="<?php echo $ui_style['items']['logo']['padding_left']; ?>" />
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="logo_padding_top"><?php echo _("Padding Top"); ?></label><br>
                                    <input <?php echo (!$plan_permissions['enable_logo']) ? 'disabled' : '' ; ?> oninput="save_vt_ui(false,false,false);" class="form-control form-control-sm" type="number" id="logo_padding_top" value="<?php echo $ui_style['items']['logo']['padding_top']; ?>" />
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="logo_padding_right"><?php echo _("Padding Right"); ?></label><br>
                                    <input <?php echo (!$plan_permissions['enable_logo']) ? 'disabled' : '' ; ?> oninput="save_vt_ui(false,false,false);" class="form-control form-control-sm" type="number" id="logo_padding_right" value="<?php echo $ui_style['items']['logo']['padding_right']; ?>" />
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo _("Opacity"); ?> <i style="font-size:12px;" id="logo_opacity_val">(<?php echo $ui_style['items']['logo']['opacity']; ?>)</i></label>
                                    <input oninput="save_vt_ui(false,false,false);" type="range" step="0.1" min="0.1" max="1.0" class="form-control-range" id="logo_opacity" value="<?php echo $ui_style['items']['logo']['opacity']; ?>">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo _("Opacity Hover"); ?> <i style="font-size:12px;" id="logo_opacity_hover_val">(<?php echo $ui_style['items']['logo']['opacity_hover']; ?>)</i></label>
                                    <input oninput="save_vt_ui(false,false,false);" type="range" step="0.1" min="0.1" max="1.0" class="form-control-range" id="logo_opacity_hover" value="<?php echo $ui_style['items']['logo']['opacity_hover']; ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr class="my-0 py-0">
                    <div class="ui_title_msg py-1 px-3 noselect"><i class="fas fa-exclamation-circle"></i>&nbsp;&nbsp;<?php echo _("upload in: virtual tours - list tours - edit - contents tab - logo"); ?>&nbsp;&nbsp;<span onclick="open_modal_edit_contents('vt_content');" class="editor_ui_shortcut_icon badge badge-primary"><i class="fas fa-external-link-alt"></i></span></div>
                </div>
                <div id="ui_edit_avatar_video" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Avatar Video"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="show_avatar_video"><?php echo _("Show"); ?></label><br>
                                    <input <?php echo (!$plan_permissions['enable_avatar_video']) ? 'disabled' : '' ; ?> onchange="save_vt_ui(false,false,false);" type="checkbox" id="show_avatar_video" <?php echo ($virtual_tour['show_avatar_video'])?'checked':''; ?> />
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="avatar_video_width"><?php echo _("Size - Width"); ?></label><br>
                                    <input <?php echo (!$plan_permissions['enable_avatar_video']) ? 'disabled' : '' ; ?> oninput="save_vt_ui(false,false,false);" class="form-control form-control-sm" type="number" min="0" id="avatar_video_width" value="<?php echo $ui_style['items']['avatar_video']['width']; ?>" />
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="avatar_video_height"><?php echo _("Size - Height"); ?></label><br>
                                    <input <?php echo (!$plan_permissions['enable_avatar_video']) ? 'disabled' : '' ; ?> oninput="save_vt_ui(false,false,false);" class="form-control form-control-sm" type="number" min="0" id="avatar_video_height" value="<?php echo $ui_style['items']['avatar_video']['height']; ?>" />
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="avatar_video_position"><?php echo _("Position"); ?></label><br>
                                    <select <?php echo (!$plan_permissions['enable_avatar_video']) ? 'disabled' : '' ; ?> onchange="save_vt_ui(false,false,false);" id="avatar_video_position" class="form-control form-control-sm">
                                        <option <?php echo ($ui_style['items']['avatar_video']['position']=='bottom_left') ? 'selected' : ''; ?> id="bottom_left"><?php echo _("Bottom Left"); ?></option>
                                        <option <?php echo ($ui_style['items']['avatar_video']['position']=='bottom_center') ? 'selected' : ''; ?> id="bottom_center"><?php echo _("Bottom Center"); ?></option>
                                        <option <?php echo ($ui_style['items']['avatar_video']['position']=='bottom_right') ? 'selected' : ''; ?> id="bottom_right"><?php echo _("Bottom Right"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="avatar_video_padding_left"><?php echo _("Padding Left"); ?></label><br>
                                    <input <?php echo (!$plan_permissions['enable_avatar_video']) ? 'disabled' : '' ; ?> oninput="save_vt_ui(false,false,false);" class="form-control form-control-sm" type="number" id="avatar_video_padding_left" value="<?php echo $ui_style['items']['avatar_video']['padding_left']; ?>" />
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="avatar_video_padding_bottom"><?php echo _("Padding Bottom"); ?></label><br>
                                    <input <?php echo (!$plan_permissions['enable_avatar_video']) ? 'disabled' : '' ; ?> oninput="save_vt_ui(false,false,false);" class="form-control form-control-sm" type="number" id="avatar_video_padding_bottom" value="<?php echo $ui_style['items']['avatar_video']['padding_bottom']; ?>" />
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="avatar_video_padding_right"><?php echo _("Padding Right"); ?></label><br>
                                    <input <?php echo (!$plan_permissions['enable_avatar_video']) ? 'disabled' : '' ; ?> oninput="save_vt_ui(false,false,false);" class="form-control form-control-sm" type="number" id="avatar_video_padding_right" value="<?php echo $ui_style['items']['avatar_video']['padding_right']; ?>" />
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr class="my-0 py-0">
                    <div class="ui_title_msg py-1 px-3 noselect"><i class="fas fa-exclamation-circle"></i>&nbsp;&nbsp;<?php echo _("upload in: virtual tours - list tours - edit - contents tab - avatar video").'&nbsp;&nbsp;<span onclick="open_modal_edit_contents(\'vt_content\');" class="editor_ui_shortcut_icon badge badge-primary"><i class="fas fa-external-link-alt"></i></span>'."<br>"._("virtual tours - rooms - edit - contents tab - avatar video"); ?></div>
                </div>
                <div style="min-width: 330px" id="ui_edit_poweredby" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Powered By - Logo / Text"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_poweredby"><?php echo _("Show"); ?></label><br>
                                    <select onchange="save_vt_ui(false,false,false);" id="show_poweredby" class="form-control form-control-sm <?php echo (!$plan_permissions['enable_poweredby']) ? 'disabled' : '' ; ?>">
                                        <option <?php echo ($virtual_tour['show_poweredby']==0) ? 'selected':''; ?> id="0"><?php echo _("Hidden"); ?></option>
                                        <option <?php echo ($virtual_tour['show_poweredby']==1) ? 'selected':''; ?> id="1"><?php echo _("Visible, Desktop and Mobile"); ?></option>
                                        <option <?php echo ($virtual_tour['show_poweredby']==2) ? 'selected':''; ?> id="2"><?php echo _("Visible, only on Desktop"); ?></option>
                                        <option <?php echo ($virtual_tour['show_poweredby']==3) ? 'selected':''; ?> id="3"><?php echo _("Visible, only on Mobile"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="poweredby_position"><?php echo _("Position"); ?></label><br>
                                    <select <?php echo (!$plan_permissions['enable_poweredby']) ? 'disabled' : '' ; ?> onchange="save_vt_ui(false,false,false);" id="poweredby_position" class="form-control form-control-sm">
                                        <option <?php echo ($ui_style['items']['poweredby']['position']=='bottom_left') ? 'selected' : ''; ?> id="bottom_left"><?php echo _("Bottom Left"); ?></option>
                                        <option <?php echo ($ui_style['items']['poweredby']['position']=='bottom_center') ? 'selected' : ''; ?> id="bottom_center"><?php echo _("Bottom Center"); ?></option>
                                        <option <?php echo ($ui_style['items']['poweredby']['position']=='bottom_right') ? 'selected' : ''; ?> id="bottom_right"><?php echo _("Bottom Right"); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row <?php echo ($virtual_tour['poweredby_type']=='image') ? '' : 'd-none'; ?>">
                            <div class="col-md-4"></div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="poweredby_height"><?php echo _("Size"); ?></label><br>
                                    <input <?php echo (!$plan_permissions['enable_poweredby']) ? 'disabled' : '' ; ?> oninput="save_vt_ui(false,false,false);" class="form-control form-control-sm" type="number" id="poweredby_height" value="<?php echo $ui_style['items']['poweredby']['image_height']; ?>" />
                                </div>
                            </div>
                            <div class="col-md-4"></div>
                        </div>
                        <div class="row <?php echo ($virtual_tour['poweredby_type']=='text') ? '' : 'd-none'; ?>">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="poweredby_font_size"><?php echo _("Size"); ?></label><br>
                                    <input <?php echo (!$plan_permissions['enable_poweredby']) ? 'disabled' : '' ; ?> oninput="save_vt_ui(false,false,false);" class="form-control form-control-sm" type="number" id="poweredby_font_size" value="<?php echo $ui_style['items']['poweredby']['font_size']; ?>" />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="poweredby_font_color"><?php echo _("Color"); ?></label>
                                    <input <?php echo (!$plan_permissions['enable_poweredby']) ? 'disabled' : '' ; ?> type="text" id="poweredby_font_color" class="form-control form-control-sm" value="<?php echo $ui_style['items']['poweredby']['font_color']; ?>" />
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo _("Opacity"); ?> <i style="font-size:12px;" id="poweredby_opacity_val">(<?php echo $ui_style['items']['poweredby']['opacity']; ?>)</i></label>
                                    <input oninput="save_vt_ui(false,false,false);" type="range" step="0.1" min="0.1" max="1.0" class="form-control-range" id="poweredby_opacity" value="<?php echo $ui_style['items']['poweredby']['opacity']; ?>">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo _("Opacity Hover"); ?> <i style="font-size:12px;" id="poweredby_opacity_hover_val">(<?php echo $ui_style['items']['poweredby']['opacity_hover']; ?>)</i></label>
                                    <input oninput="save_vt_ui(false,false,false);" type="range" step="0.1" min="0.1" max="1.0" class="form-control-range" id="poweredby_opacity_hover" value="<?php echo $ui_style['items']['poweredby']['opacity_hover']; ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr class="my-0 py-0">
                    <div class="ui_title_msg py-1 px-3 noselect"><i class="fas fa-exclamation-circle"></i>&nbsp;&nbsp;<?php echo _("upload in: virtual tours - list tours - edit - contents tab - powered by"); ?>&nbsp;&nbsp;<span onclick="open_modal_edit_contents('vt_content');" class="editor_ui_shortcut_icon badge badge-primary"><i class="fas fa-external-link-alt"></i></span></div>
                </div>
                <div id="ui_edit_nav" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Nav Control"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_nav_control"><?php echo _("Show"); ?></label><br>
                                    <input onchange="save_vt_ui(false,false,false);" type="checkbox" id="show_nav_control" <?php echo ($virtual_tour['show_nav_control'])?'checked':''; ?> />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('nav_control',false,true); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_icon_color('nav_control','nav_control i'); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_icon_color_hover('nav_control','nav_control i'); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="ui_edit_voice" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Voice Commands"); ?></div>
                    <div class="ui_content_box">
                        <div class="form-group mb-0">
                            <label for="voice_commands"><?php echo _("Show"); ?></label><br>
                            <select onchange="save_vt_ui(false,false,false);" <?php echo (!$plan_permissions['enable_voice_commands']) ? 'disabled' : '' ; ?> id="voice_commands" class="form-control form-control-sm">
                                <option <?php echo ($virtual_tour['voice_commands']==0) ? 'selected':''; ?> id="0"><?php echo _("Disabled"); ?></option>
                                <option <?php echo ($virtual_tour['voice_commands']==1) ? 'selected':''; ?> id="1"><?php echo _("Enabled, paused"); ?></option>
                                <option <?php echo ($virtual_tour['voice_commands']==2) ? 'selected':''; ?> id="2"><?php echo _("Enabled, autostart"); ?></option>
                            </select>
                        </div>
                    </div>
                </div>
                <div id="ui_edit_custom" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Custom"); ?> 1</div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_custom"><?php echo _("Show"); ?></label><br>
                                    <div class="input-group">
                                        <select onchange="save_vt_ui(false,false,false);" id="show_custom" class="form-control form-control-sm">
                                            <option <?php echo ($virtual_tour['show_custom']==0) ? 'selected':''; ?> id="0"><?php echo _("Hidden"); ?></option>
                                            <option <?php echo ($virtual_tour['show_custom']==1) ? 'selected':''; ?> id="1"><?php echo _("Visible, minimized"); ?></option>
                                            <option <?php echo ($virtual_tour['show_custom']==2) ? 'selected':''; ?> id="2"><?php echo _("Visible, opened"); ?></option>
                                        </select>
                                        <div class="input-group-append">
                                            <button data-toggle="modal" data-target="#modal_custom_content" class="btn btn-primary btn-sm <?php echo ($edit_version) ? 'disabled_d' : ''; ?>" type="button"><i style="color: white" class="fas fa-cog"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('custom',''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('custom'); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('custom',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('custom',true,true,true); ?>
                            </div>
                        </div>
                    </div>
                    <hr class="my-0 py-0">
                    <div class="ui_title_msg py-1 px-3 noselect"><i class="fas fa-exclamation-circle"></i>&nbsp;&nbsp;<?php echo _("create in: click on gear button above"); ?></div>
                </div>
                <div id="ui_edit_custom2" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Custom"); ?> 2</div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_custom2"><?php echo _("Show"); ?></label><br>
                                    <div class="input-group">
                                        <select onchange="save_vt_ui(false,false,false);" id="show_custom2" class="form-control form-control-sm">
                                            <option <?php echo ($virtual_tour['show_custom2']==0) ? 'selected':''; ?> id="0"><?php echo _("Hidden"); ?></option>
                                            <option <?php echo ($virtual_tour['show_custom2']==1) ? 'selected':''; ?> id="1"><?php echo _("Visible, minimized"); ?></option>
                                            <option <?php echo ($virtual_tour['show_custom2']==2) ? 'selected':''; ?> id="2"><?php echo _("Visible, opened"); ?></option>
                                        </select>
                                        <div class="input-group-append">
                                            <button data-toggle="modal" data-target="#modal_custom2_content" class="btn btn-primary btn-sm <?php echo ($edit_version) ? 'disabled_d' : ''; ?>" type="button"><i style="color: white" class="fas fa-cog"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('custom2',''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('custom2'); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('custom2',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('custom2',true,true,true); ?>
                            </div>
                        </div>
                    </div>
                    <hr class="my-0 py-0">
                    <div class="ui_title_msg py-1 px-3 noselect"><i class="fas fa-exclamation-circle"></i>&nbsp;&nbsp;<?php echo _("create in: click on gear button above"); ?></div>
                </div>
                <div id="ui_edit_custom3" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Custom"); ?> 3</div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_custom3"><?php echo _("Show"); ?></label><br>
                                    <div class="input-group">
                                        <select onchange="save_vt_ui(false,false,false);" id="show_custom3" class="form-control form-control-sm">
                                            <option <?php echo ($virtual_tour['show_custom3']==0) ? 'selected':''; ?> id="0"><?php echo _("Hidden"); ?></option>
                                            <option <?php echo ($virtual_tour['show_custom3']==1) ? 'selected':''; ?> id="1"><?php echo _("Visible, minimized"); ?></option>
                                            <option <?php echo ($virtual_tour['show_custom3']==2) ? 'selected':''; ?> id="2"><?php echo _("Visible, opened"); ?></option>
                                        </select>
                                        <div class="input-group-append">
                                            <button data-toggle="modal" data-target="#modal_custom3_content" class="btn btn-primary btn-sm <?php echo ($edit_version) ? 'disabled_d' : ''; ?>" type="button"><i style="color: white" class="fas fa-cog"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('custom3',''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('custom3'); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('custom3',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('custom3',true,true,true); ?>
                            </div>
                        </div>
                    </div>
                    <hr class="my-0 py-0">
                    <div class="ui_title_msg py-1 px-3 noselect"><i class="fas fa-exclamation-circle"></i>&nbsp;&nbsp;<?php echo _("create in: click on gear button above"); ?></div>
                </div>
                <div id="ui_edit_custom4" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Custom"); ?> 4</div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_custom4"><?php echo _("Show"); ?></label><br>
                                    <div class="input-group">
                                        <select onchange="save_vt_ui(false,false,false);" id="show_custom4" class="form-control form-control-sm">
                                            <option <?php echo ($virtual_tour['show_custom4']==0) ? 'selected':''; ?> id="0"><?php echo _("Hidden"); ?></option>
                                            <option <?php echo ($virtual_tour['show_custom4']==1) ? 'selected':''; ?> id="1"><?php echo _("Visible, minimized"); ?></option>
                                            <option <?php echo ($virtual_tour['show_custom4']==2) ? 'selected':''; ?> id="2"><?php echo _("Visible, opened"); ?></option>
                                        </select>
                                        <div class="input-group-append">
                                            <button data-toggle="modal" data-target="#modal_custom4_content" class="btn btn-primary btn-sm <?php echo ($edit_version) ? 'disabled_d' : ''; ?>" type="button"><i style="color: white" class="fas fa-cog"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('custom4',''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('custom4'); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('custom4',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('custom4',true,true,true); ?>
                            </div>
                        </div>
                    </div>
                    <hr class="my-0 py-0">
                    <div class="ui_title_msg py-1 px-3 noselect"><i class="fas fa-exclamation-circle"></i>&nbsp;&nbsp;<?php echo _("create in: click on gear button above"); ?></div>
                </div>
                <div id="ui_edit_custom5" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Custom"); ?> 5</div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_custom5"><?php echo _("Show"); ?></label><br>
                                    <div class="input-group">
                                        <select onchange="save_vt_ui(false,false,false);" id="show_custom5" class="form-control form-control-sm">
                                            <option <?php echo ($virtual_tour['show_custom5']==0) ? 'selected':''; ?> id="0"><?php echo _("Hidden"); ?></option>
                                            <option <?php echo ($virtual_tour['show_custom5']==1) ? 'selected':''; ?> id="1"><?php echo _("Visible, minimized"); ?></option>
                                            <option <?php echo ($virtual_tour['show_custom5']==2) ? 'selected':''; ?> id="2"><?php echo _("Visible, opened"); ?></option>
                                        </select>
                                        <div class="input-group-append">
                                            <button data-toggle="modal" data-target="#modal_custom5_content" class="btn btn-primary btn-sm <?php echo ($edit_version) ? 'disabled_d' : ''; ?>" type="button"><i style="color: white" class="fas fa-cog"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('custom5',''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('custom5'); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('custom5',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('custom5',true,true,true); ?>
                            </div>
                        </div>
                    </div>
                    <hr class="my-0 py-0">
                    <div class="ui_title_msg py-1 px-3 noselect"><i class="fas fa-exclamation-circle"></i>&nbsp;&nbsp;<?php echo _("create in: click on gear button above"); ?></div>
                </div>
                <div id="ui_edit_location" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Location"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_location"><?php echo _("Show"); ?></label><br>
                                    <div class="input-group">
                                        <select onchange="save_vt_ui(false,false,false);" id="show_location" class="form-control form-control-sm">
                                            <option <?php echo ($virtual_tour['show_location']==0) ? 'selected':''; ?> id="0"><?php echo _("Hidden"); ?></option>
                                            <option <?php echo ($virtual_tour['show_location']==1) ? 'selected':''; ?> id="1"><?php echo _("Visible, minimized"); ?></option>
                                            <option <?php echo ($virtual_tour['show_location']==2) ? 'selected':''; ?> id="2"><?php echo _("Visible, opened"); ?></option>
                                        </select>
                                        <div class="input-group-append">
                                            <button data-toggle="modal" data-target="#modal_location_content" class="btn btn-primary btn-sm <?php echo ($edit_version) ? 'disabled_d' : ''; ?>" type="button"><i style="color: white" class="fas fa-cog"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('location',''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('location'); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('location',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('location',true,true,true); ?>
                            </div>
                        </div>
                    </div>
                    <hr class="my-0 py-0">
                    <div class="ui_title_msg py-1 px-3 noselect"><i class="fas fa-exclamation-circle"></i>&nbsp;&nbsp;<?php echo _("create in: click on gear button above"); ?></div>
                </div>
                <div id="ui_edit_media" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Media"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_media"><?php echo _("Show"); ?></label><br>
                                    <div class="input-group">
                                        <select onchange="save_vt_ui(false,false,false);" id="show_media" class="form-control form-control-sm">
                                            <option <?php echo ($virtual_tour['show_media']==0) ? 'selected':''; ?> id="0"><?php echo _("Hidden"); ?></option>
                                            <option <?php echo ($virtual_tour['show_media']==1) ? 'selected':''; ?> id="1"><?php echo _("Visible, minimized"); ?></option>
                                            <option <?php echo ($virtual_tour['show_media']==2) ? 'selected':''; ?> id="2"><?php echo _("Visible, opened"); ?></option>
                                        </select>
                                        <div class="input-group-append">
                                            <button data-toggle="modal" data-target="#modal_media_file" class="btn btn-primary btn-sm <?php echo ($edit_version) ? 'disabled_d' : ''; ?>" type="button"><i style="color: white" class="fas fa-upload"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('media',''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('media'); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('media',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('media',true,true,true); ?>
                            </div>
                        </div>
                    </div>
                    <hr class="my-0 py-0">
                    <div class="ui_title_msg py-1 px-3 noselect"><i class="fas fa-exclamation-circle"></i>&nbsp;&nbsp;<?php echo _("upload in: click on upload button above"); ?></div>
                </div>
                <div id="ui_edit_snapshot" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Snapshot"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_snapshot"><?php echo _("Show"); ?></label><br>
                                    <input onchange="save_vt_ui(false,false,false);" type="checkbox" id="show_snapshot" <?php echo ($virtual_tour['show_snapshot'])?'checked':''; ?> />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('snapshot',''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('snapshot'); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('snapshot',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('snapshot',true,true,true); ?>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="snapshot_top_left"><?php echo _("Top Left"); ?></label>
                                    <select class="form-control" id="snapshot_top_left">
                                        <option <?php echo ($position_snapshot_elems['top_left']=='none') ? 'selected' : '' ?> id="none" value="none">--</option>
                                        <option <?php echo ($position_snapshot_elems['top_left']=='logo') ? 'selected' : '' ?> id="logo" value="logo"><?php echo _("Logo"); ?></option>
                                        <option <?php echo ($position_snapshot_elems['top_left']=='qrcode') ? 'selected' : '' ?> id="qrcode" value="qrcode"><?php echo _("QR Code"); ?></option>
                                        <option <?php echo ($position_snapshot_elems['top_left']=='info') ? 'selected' : '' ?> id="info" value="info"><?php echo _("Info"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="snapshot_top_right"><?php echo _("Top Right"); ?></label>
                                    <select class="form-control" id="snapshot_top_right">
                                        <option <?php echo ($position_snapshot_elems['top_right']=='none') ? 'selected' : '' ?> id="none" value="none">--</option>
                                        <option <?php echo ($position_snapshot_elems['top_right']=='logo') ? 'selected' : '' ?> id="logo" value="logo"><?php echo _("Logo"); ?></option>
                                        <option <?php echo ($position_snapshot_elems['top_right']=='qrcode') ? 'selected' : '' ?> id="qrcode" value="qrcode"><?php echo _("QR Code"); ?></option>
                                        <option <?php echo ($position_snapshot_elems['top_right']=='info') ? 'selected' : '' ?> id="info" value="info"><?php echo _("Info"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="snapshot_bottom_left"><?php echo _("Bottom Left"); ?></label>
                                    <select class="form-control" id="snapshot_bottom_left">
                                        <option <?php echo ($position_snapshot_elems['bottom_left']=='none') ? 'selected' : '' ?> id="none" value="none">--</option>
                                        <option <?php echo ($position_snapshot_elems['bottom_left']=='logo') ? 'selected' : '' ?> id="logo" value="logo"><?php echo _("Logo"); ?></option>
                                        <option <?php echo ($position_snapshot_elems['bottom_left']=='qrcode') ? 'selected' : '' ?> id="qrcode" value="qrcode"><?php echo _("QR Code"); ?></option>
                                        <option <?php echo ($position_snapshot_elems['bottom_left']=='info') ? 'selected' : '' ?> id="info" value="info"><?php echo _("Info"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="snapshot_bottom_right"><?php echo _("Bottom Right"); ?></label>
                                    <select class="form-control" id="snapshot_bottom_right">
                                        <option <?php echo ($position_snapshot_elems['bottom_right']=='none') ? 'selected' : '' ?> id="none" value="none">--</option>
                                        <option <?php echo ($position_snapshot_elems['bottom_right']=='logo') ? 'selected' : '' ?> id="logo" value="logo"><?php echo _("Logo"); ?></option>
                                        <option <?php echo ($position_snapshot_elems['bottom_right']=='qrcode') ? 'selected' : '' ?> id="qrcode" value="qrcode"><?php echo _("QR Code"); ?></option>
                                        <option <?php echo ($position_snapshot_elems['bottom_right']=='info') ? 'selected' : '' ?> id="info" value="info"><?php echo _("Info"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <script>
                                function adjustElements(changedId) {
                                    var selects = {
                                        'snapshot_top_left': document.getElementById('snapshot_top_left'),
                                        'snapshot_top_right': document.getElementById('snapshot_top_right'),
                                        'snapshot_bottom_left': document.getElementById('snapshot_bottom_left'),
                                        'snapshot_bottom_right': document.getElementById('snapshot_bottom_right')
                                    };
                                    var currentValue = selects[changedId].value;
                                    if (currentValue === 'none') {
                                        return;
                                    }
                                    for (var id in selects) {
                                        if (id !== changedId && selects[id].value === currentValue) {
                                            selects[id].value = 'none';
                                        }
                                    }
                                }
                                ['snapshot_top_left', 'snapshot_top_right', 'snapshot_bottom_left', 'snapshot_bottom_right'].forEach(function(id) {
                                    document.getElementById(id).addEventListener('change', function() {
                                        adjustElements(id);
                                    });
                                });
                            </script>
                        </div>
                    </div>
                </div>
                <div id="ui_edit_info" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Info"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_info"><?php echo _("Show"); ?></label><br>
                                    <select onchange="save_vt_ui(false,false,false);" <?php echo (!$plan_permissions['enable_info_box']) ? 'disabled' : '' ; ?> id="show_info" class="form-control form-control-sm">
                                        <option <?php echo ($virtual_tour['show_info']==0) ? 'selected':''; ?> id="0"><?php echo _("Hidden"); ?></option>
                                        <option <?php echo ($virtual_tour['show_info']==1) ? 'selected':''; ?> id="1"><?php echo _("Visible, minimized"); ?></option>
                                        <option <?php echo ($virtual_tour['show_info']==2) ? 'selected':''; ?> id="2"><?php echo _("Visible, opened"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('info',''); ?>
                            </div>
                            <div class="col-md-3"></div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="info_box_type"><?php echo _("Info Type"); ?></label><br>
                                    <select onchange="save_vt_ui(false,false,false);" <?php echo (!$plan_permissions['enable_info_box']) ? 'disabled' : '' ; ?> id="info_box_type" class="form-control form-control-sm">
                                        <option <?php echo ($virtual_tour['info_box_type']=='popup') ? 'selected':''; ?> id="popup"><?php echo _("Popup"); ?></option>
                                        <option <?php echo ($virtual_tour['info_box_type']=='panel') ? 'selected':''; ?> id="panel"><?php echo _("Panel"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3"></div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('info'); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('info',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('info',true,true,true); ?>
                            </div>
                        </div>
                    </div>
                    <hr class="my-0 py-0">
                    <div class="ui_title_msg py-1 px-3 noselect"><i class="fas fa-exclamation-circle"></i>&nbsp;&nbsp;<?php echo _("create in: virtual tours - info box"); ?>&nbsp;&nbsp;<span onclick="open_modal_edit_contents('info');" class="editor_ui_shortcut_icon badge badge-primary"><i class="fas fa-external-link-alt"></i></span></div>
                </div>
                <div id="ui_edit_dollhouse" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("3D View"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_dollhouse"><?php echo _("Show"); ?></label><br>
                                    <select onchange="save_vt_ui(false,false,false);" <?php echo (!$plan_permissions['enable_dollhouse']) ? 'disabled' : '' ; ?> id="show_dollhouse" class="form-control form-control-sm">
                                        <option <?php echo ($virtual_tour['show_dollhouse']==0) ? 'selected':''; ?> id="0"><?php echo _("Hidden"); ?></option>
                                        <option <?php echo ($virtual_tour['show_dollhouse']==1) ? 'selected':''; ?> id="1"><?php echo _("Visible, minimized"); ?></option>
                                        <option <?php echo ($virtual_tour['show_dollhouse']==2) ? 'selected':''; ?> id="2"><?php echo _("Visible, opened"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('dollhouse',''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('dollhouse'); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('dollhouse',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('dollhouse',true,true,true); ?>
                            </div>
                        </div>
                    </div>
                    <hr class="my-0 py-0">
                    <div class="ui_title_msg py-1 px-3 noselect"><i class="fas fa-exclamation-circle"></i>&nbsp;&nbsp;<?php echo _("create in: virtual tours - 3d view"); ?>&nbsp;&nbsp;<span onclick="open_modal_edit_contents('dollhouse');" class="editor_ui_shortcut_icon badge badge-primary"><i class="fas fa-external-link-alt"></i></span></div>
                </div>
                <div id="ui_edit_gallery" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Gallery"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_gallery"><?php echo _("Show"); ?></label><br>
                                    <select onchange="save_vt_ui(false,false,false);" <?php echo (!$plan_permissions['create_gallery']) ? 'disabled' : '' ; ?> id="show_gallery" class="form-control form-control-sm">
                                        <option <?php echo ($virtual_tour['show_gallery']==0) ? 'selected':''; ?> id="0"><?php echo _("Hidden"); ?></option>
                                        <option <?php echo ($virtual_tour['show_gallery']==1) ? 'selected':''; ?> id="1"><?php echo _("Visible, minimized"); ?></option>
                                        <option <?php echo ($virtual_tour['show_gallery']==2) ? 'selected':''; ?> id="2"><?php echo _("Visible, opened"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('gallery',''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('gallery'); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('gallery',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('gallery',true,true,true); ?>
                            </div>
                        </div>
                    </div>
                    <hr class="my-0 py-0">
                    <div class="ui_title_msg py-1 px-3 noselect"><i class="fas fa-exclamation-circle"></i>&nbsp;&nbsp;<?php echo _("upload in: media - gallery"); ?>&nbsp;&nbsp;<span onclick="open_modal_edit_contents('gallery');" class="editor_ui_shortcut_icon badge badge-primary"><i class="fas fa-external-link-alt"></i></span></div>
                </div>
                <div id="ui_edit_compass" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Compass"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="compass"><?php echo _("Show"); ?></label><br>
                                    <input onchange="save_vt_ui(false,false,false);" type="checkbox" id="compass" <?php echo ($virtual_tour['compass'])?'checked':''; ?> />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('compass',''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('compass',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('compass',true,true,true); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="ui_edit_whatsapp" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Whatsapp"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="whatsapp_chat"><?php echo _("Show"); ?></label><br>
                                    <input onchange="save_vt_ui(false,false,false);" type="checkbox" id="whatsapp_chat" <?php echo ($virtual_tour['whatsapp_chat'])?'checked':''; ?> />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('whatsapp',''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('whatsapp'); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('whatsapp',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('whatsapp',true,true,true); ?>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="whatsapp_number"><?php echo _("Whatsapp Number"); ?> <i title="<?php echo _("Phone number for whatsapp chat"); ?>" class="help_t fas fa-question-circle"></i></label><br>
                                    <input <?php echo (!$plan_permissions['enable_chat']) ? 'disabled' : '' ; ?> type="text" class="form-control <?php echo ($edit_version) ? 'disabled_d' : ''; ?>" id="whatsapp_number" value="<?php echo $virtual_tour['whatsapp_number']; ?>" />
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="ui_edit_facebook" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Facebook Messenger"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="fb_messenger"><?php echo _("Show"); ?></label><br>
                                    <input onchange="save_vt_ui(false,false,false);" type="checkbox" id="fb_messenger" <?php echo ($virtual_tour['fb_messenger'])?'checked':''; ?> />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('facebook',''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('facebook'); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('facebook',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('facebook',true,true,true); ?>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="fb_page_id"><?php echo _("Facebook page ID"); ?> <i title="<?php echo _("Id of Facebook page for Facebook Messenger Note: in order to works you need to add the url to facebook page - settings - messenger platform - whitelist domain"); ?>" class="help_t fas fa-question-circle"></i></label><br>
                                    <input <?php echo (!$plan_permissions['enable_chat']) ? 'disabled' : '' ; ?> type="text" class="form-control <?php echo ($edit_version) ? 'disabled_d' : ''; ?>" id="fb_page_id" value="<?php echo $virtual_tour['fb_page_id']; ?>" />
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="ui_edit_arrows_nav" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Arrows Prev/Next"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="arrows_nav"><?php echo _("Show"); ?></label><br>
                                    <select onchange="save_vt_ui(false,false,false);" id="arrows_nav" class="form-control form-control-sm">
                                        <option <?php echo ($virtual_tour['arrows_nav']==0) ? 'selected':''; ?> id="0"><?php echo _("Disabled"); ?></option>
                                        <option <?php echo ($virtual_tour['arrows_nav']==1) ? 'selected':''; ?> id="1"><?php echo _("Enabled, Mobile and Desktop"); ?></option>
                                        <option <?php echo ($virtual_tour['arrows_nav']==2) ? 'selected':''; ?> id="2"><?php echo _("Enabled, only Desktop"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('arrows',''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('arrows',true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('arrows',true,true); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="ui_edit_slider_nav" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Arrows Room's List Slider"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="nav_slider"><?php echo _("Show"); ?></label><br>
                                    <select onchange="save_vt_ui(false,false,false);" id="nav_slider" class="form-control form-control-sm">
                                        <option <?php echo ($virtual_tour['nav_slider']==2) ? 'selected':''; ?> id="2"><?php echo _("Hidden"); ?></option>
                                        <option <?php echo ($virtual_tour['nav_slider']==0) ? 'selected':''; ?> id="0"><?php echo _("Visible, Desktop and Mobile"); ?></option>
                                        <option <?php echo ($virtual_tour['nav_slider']==1) ? 'selected':''; ?> id="1"><?php echo _("Visible, only on Desktop"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="nav_slider_mode"><?php echo _("Show"); ?></label><br>
                                    <select onchange="save_vt_ui(false,false,false);" id="nav_slider_mode" class="form-control form-control-sm">
                                        <option <?php echo ($virtual_tour['nav_slider_mode']==0) ? 'selected':''; ?> id="0"><?php echo _("Go to Room"); ?></option>
                                        <option <?php echo ($virtual_tour['nav_slider_mode']==1) ? 'selected':''; ?> id="1"><?php echo _("Scroll"); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('nav_arrows',true,false); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('nav_arrows',true,false); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="ui_edit_slider" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Room's List Slider"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="auto_show_slider"><?php echo _("Show"); ?></label><br>
                                    <select onchange="save_vt_ui(false,false,false);" id="auto_show_slider" class="form-control form-control-sm">
                                        <option <?php echo ($virtual_tour['auto_show_slider']==2) ? 'selected':''; ?> id="2"><?php echo _("Hidden"); ?></option>
                                        <option <?php echo ($virtual_tour['auto_show_slider']==0) ? 'selected':''; ?> id="0"><?php echo _("Visible, minimized"); ?></option>
                                        <option <?php echo ($virtual_tour['auto_show_slider']==1) ? 'selected':''; ?> id="1"><?php echo _("Visible, opened"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <?php echo print_ui_position('list',''); ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('list',true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('list',true,true); ?>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('slider',false,true); ?>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="autoclose_slider"><?php echo _("Auto-close"); ?> <i title="<?php echo _("automatically closes the room's list slider when you click on any item in it"); ?>" class="help_t fas fa-question-circle"></i></label><br>
                                    <input onchange="save_vt_ui(false,false,false);" type="checkbox" id="autoclose_slider" <?php echo ($virtual_tour['autoclose_slider'])?'checked':''; ?> />
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="preview_room_slider"><?php echo _("Preview on Hover"); ?> <i title="<?php echo _("when you hover over the room thumbnail in the slider a rotating preview of the room is shown"); ?>" class="help_t fas fa-question-circle"></i></label><br>
                                    <input onchange="save_vt_ui(false,false,false);" type="checkbox" id="preview_room_slider" <?php echo ($ui_style['preview_room_slider']==1)?'checked':''; ?> />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="grouped_list_alt"><?php echo _("Group Rooms"); ?> <i title="<?php echo _("group rooms in the slider if they are part of the same category"); ?>" class="help_t fas fa-question-circle"></i></label><br>
                                    <input onchange="save_vt_ui(false,false,false);" type="checkbox" id="grouped_list_alt" <?php echo ($virtual_tour['grouped_list_alt']==1)?'checked':''; ?> />
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="ui_edit_icons" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Icons"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_icons_toggle"><?php echo _("Show"); ?></label><br>
                                    <select onchange="save_vt_ui(false,false,false);" id="show_icons_toggle" class="form-control form-control-sm">
                                        <option <?php echo ($virtual_tour['show_icons_toggle']==0) ? 'selected':''; ?> id="0"><?php echo _("Hidden"); ?></option>
                                        <option <?php echo ($virtual_tour['show_icons_toggle']==1) ? 'selected':''; ?> id="1"><?php echo _("Visible, icons shown"); ?></option>
                                        <option <?php echo ($virtual_tour['show_icons_toggle']==2) ? 'selected':''; ?> id="2"><?php echo _("Visible, icons hidden"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('icons',''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('icons'); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('icons',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('icons',true,true,true); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="ui_edit_icons_content" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Content Icons"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_icons_content_toggle"><?php echo _("Show"); ?></label><br>
                                    <select onchange="save_vt_ui(false,false,false);" id="show_icons_content_toggle" class="form-control form-control-sm">
                                        <option <?php echo ($virtual_tour['show_icons_content_toggle']==0) ? 'selected':''; ?> id="0"><?php echo _("Hidden"); ?></option>
                                        <option <?php echo ($virtual_tour['show_icons_content_toggle']==1) ? 'selected':''; ?> id="1"><?php echo _("Visible, icons shown"); ?></option>
                                        <option <?php echo ($virtual_tour['show_icons_content_toggle']==2) ? 'selected':''; ?> id="2"><?php echo _("Visible, icons hidden"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('icons_content',''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('icons_content'); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('icons_content',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('icons_content',true,true,true); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="ui_edit_icons_nav" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Navigation Icons"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_icons_nav_toggle"><?php echo _("Show"); ?></label><br>
                                    <select onchange="save_vt_ui(false,false,false);" id="show_icons_nav_toggle" class="form-control form-control-sm">
                                        <option <?php echo ($virtual_tour['show_icons_nav_toggle']==0) ? 'selected':''; ?> id="0"><?php echo _("Hidden"); ?></option>
                                        <option <?php echo ($virtual_tour['show_icons_nav_toggle']==1) ? 'selected':''; ?> id="1"><?php echo _("Visible, icons shown"); ?></option>
                                        <option <?php echo ($virtual_tour['show_icons_nav_toggle']==2) ? 'selected':''; ?> id="2"><?php echo _("Visible, icons hidden"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('icons_nav',''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('icons_nav'); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('icons_nav',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('icons_nav',true,true,true); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="ui_edit_measures" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Measures"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_measures_toggle"><?php echo _("Show"); ?></label>
                                    <select onchange="save_vt_ui(false,false,false);" id="show_measures_toggle" class="form-control form-control-sm">
                                        <option <?php echo ($virtual_tour['show_measures_toggle']==0) ? 'selected':''; ?> id="0"><?php echo _("Hidden"); ?></option>
                                        <option <?php echo ($virtual_tour['show_measures_toggle']==1) ? 'selected':''; ?> id="1"><?php echo _("Visible, measures shown"); ?></option>
                                        <option <?php echo ($virtual_tour['show_measures_toggle']==2) ? 'selected':''; ?> id="2"><?php echo _("Visible, measures hidden"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('measures',''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('measures'); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('measures',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('measures',true,true,true); ?>
                            </div>
                        </div>
                    </div>
                    <hr class="my-0 py-0">
                    <div class="ui_title_msg py-1 px-3 noselect"><i class="fas fa-exclamation-circle"></i>&nbsp;&nbsp;<?php echo _("create in: virtual tours - measurements"); ?>&nbsp;&nbsp;<span onclick="open_modal_edit_contents('measurements');" class="editor_ui_shortcut_icon badge badge-primary"><i class="fas fa-external-link-alt"></i></span></div>
                </div>
                <div id="ui_edit_autorotation" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Auto Rotation"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_autorotation_toggle"><?php echo _("Show"); ?></label><br>
                                    <select onchange="save_vt_ui(false,false,false);" id="show_autorotation_toggle" class="form-control form-control-sm">
                                        <option <?php echo ($virtual_tour['show_autorotation_toggle']==0) ? 'selected':''; ?> id="0"><?php echo _("Hidden, disabled"); ?></option>
                                        <option <?php echo ($virtual_tour['show_autorotation_toggle']==3) ? 'selected':''; ?> id="3"><?php echo _("Hidden, enabled"); ?></option>
                                        <option <?php echo ($virtual_tour['show_autorotation_toggle']==2) ? 'selected':''; ?> id="2"><?php echo _("Visible, disabled"); ?></option>
                                        <option <?php echo ($virtual_tour['show_autorotation_toggle']==1) ? 'selected':''; ?> id="1"><?php echo _("Visible, enabled"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('autorotate',''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('autorotate'); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('autorotate',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('autorotate',true,true,true); ?>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-6 <?php echo ($virtual_tour['ar_simulator']) ? 'd-none' : ''; ?>">
                                <div class="form-group">
                                    <label for="autorotate_speed"><?php echo _("AutoRotate speed"); ?> <i title="<?php echo _("0 to disable autorotate, -1 to -10 speed clockwise, 1 to 10 speed counterclockwise"); ?>" class="help_t fas fa-question-circle"></i></label>
                                    <input onchange="save_vt_ui(false,false,false);" oninput="save_vt_ui(false,false,false);" <?php echo (!$plan_permissions['enable_auto_rotate']) ? 'disabled' : '' ; ?> min="-10" max="10" type="number" class="form-control" id="autorotate_speed" value="<?php echo $virtual_tour['autorotate_speed']; ?>" />
                                </div>
                            </div>
                            <div class="col-md-6 <?php echo ($virtual_tour['ar_simulator']) ? 'd-none' : ''; ?>">
                                <div class="form-group">
                                    <label for="autorotate_inactivity"><?php echo _("AutoRotate inactivity"); ?> <i title="<?php echo _("time in milliseconds to wait before starting the autorotation"); ?>" class="help_t fas fa-question-circle"></i></label>
                                    <div class="input-group">
                                        <input <?php echo (!$plan_permissions['enable_auto_rotate']) ? 'disabled' : '' ; ?> type="number" class="form-control" id="autorotate_inactivity" value="<?php echo $virtual_tour['autorotate_inactivity']; ?>" />
                                        <div class="input-group-append">
                                            <span class="input-group-text">ms</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="ui_edit_orientation" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Device Orientation"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <label for="show_device_orientation"><?php echo _("Show"); ?></label><br>
                                <select onchange="save_vt_ui(false,false,false);" <?php echo (!$plan_permissions['enable_device_orientation']) ? 'disabled' : '' ; ?> id="show_device_orientation" class="form-control form-control-sm">
                                    <option <?php echo ($virtual_tour['show_device_orientation']==0) ? 'selected':''; ?> id="0"><?php echo _("Hidden, disabled"); ?></option>
                                    <option <?php echo ($virtual_tour['show_device_orientation']==3) ? 'selected':''; ?> id="3"><?php echo _("Hidden, enabled"); ?></option>
                                    <option <?php echo ($virtual_tour['show_device_orientation']==1) ? 'selected':''; ?> id="1"><?php echo _("Visible, disabled"); ?></option>
                                    <option <?php echo ($virtual_tour['show_device_orientation']==2) ? 'selected':''; ?> id="2"><?php echo _("Visible, enabled"); ?></option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('orient',''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('orient'); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('orient',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('orient',true,true,true); ?>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-12">
                                <label for="drag_device_orientation"><?php echo _("Drag Enabled when Device Orientation On"); ?></label><br>
                                <input onchange="save_vt_ui(false,false,false);" <?php echo (!$plan_permissions['enable_device_orientation']) ? 'disabled' : '' ; ?> type="checkbox" id="drag_device_orientation" <?php echo ($virtual_tour['drag_device_orientation'])?'checked':''; ?> />
                            </div>
                        </div>
                    </div>
                </div>
                <div id="ui_edit_vr" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Web VR"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <label for="show_webvr"><?php echo _("Show"); ?></label><br>
                                <input onchange="save_vt_ui(false,false,false);" <?php echo (!$plan_permissions['enable_webvr']) ? 'disabled' : '' ; ?> type="checkbox" id="show_webvr" <?php echo ($virtual_tour['show_webvr'])?'checked':''; ?> />
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('vr',''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('vr'); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('vr',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('vr',true,true,true); ?>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-12 <?php echo ($settings['vr_button']==0) ? 'disabled' : ''; ?>">
                                <label for="webvr_new_window"><?php echo _("Open in new window"); ?></label><br>
                                <input <?php echo (!$plan_permissions['enable_webvr']) ? 'disabled' : '' ; ?> type="checkbox" id="webvr_new_window" <?php echo ($virtual_tour['webvr_new_window'])?'checked':''; ?> />
                            </div>
                        </div>
                    </div>
                </div>
                <div id="ui_edit_presentation" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Presentation"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <label for="show_presentation"><?php echo _("Show"); ?></label><br>
                                <select onchange="save_vt_ui(false,false,false);" <?php echo (!$plan_permissions['create_presentation']) ? 'disabled' : '' ; ?> id="show_presentation" class="form-control form-control-sm">
                                    <option <?php echo ($virtual_tour['show_presentation']==0) ? 'selected':''; ?> id="0"><?php echo _("Hidden"); ?></option>
                                    <option <?php echo ($virtual_tour['show_presentation']==1) ? 'selected':''; ?> id="1"><?php echo _("Visible"); ?></option>
                                    <option <?php echo ($virtual_tour['show_presentation']==2) ? 'selected':''; ?> id="2"><?php echo _("Visible, autostart"); ?></option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('presentation',''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('presentation'); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('presentation',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('presentation',true,true,true); ?>
                            </div>
                        </div>
                    </div>
                    <hr class="my-0 py-0">
                    <div class="ui_title_msg py-1 px-3 noselect"><i class="fas fa-exclamation-circle"></i>&nbsp;&nbsp;<?php echo _("create in: virtual tours - presentation"); ?>&nbsp;&nbsp;<span onclick="open_modal_edit_contents('presentation');" class="editor_ui_shortcut_icon badge badge-primary"><i class="fas fa-external-link-alt"></i></span></div>
                </div>
                <div id="ui_edit_share" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Share"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <label for="show_share"><?php echo _("Show"); ?></label><br>
                                <select onchange="save_vt_ui(false,false,false);" <?php echo (!$plan_permissions['enable_share']) ? 'disabled' : '' ; ?> id="show_share" class="form-control form-control-sm">
                                    <option <?php echo ($virtual_tour['show_share']==0) ? 'selected':''; ?> id="0"><?php echo _("Hidden"); ?></option>
                                    <option <?php echo ($virtual_tour['show_share']==1) ? 'selected':''; ?> id="1"><?php echo _("Visible, share tour"); ?></option>
                                    <option <?php echo ($virtual_tour['show_share']==2) ? 'selected':''; ?> id="2"><?php echo _("Visible, share current position"); ?></option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('share',''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('share'); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('share',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('share',true,true,true); ?>
                            </div>
                        </div>
                        <hr>
                        <div class="row" style="margin-bottom: 10px;">
                            <?php
                            $array_share_providers = explode(",",$ui_style['controls']['share']['providers']);
                            $array_share_providers_settings = explode(",",$settings['share_providers']);
                            ?>
                            <div class="col-md-12">
                                <label for="share_providers"><?php echo _("Providers"); ?></label><br>
                                <select onchange="save_vt_ui(false,false,false);" <?php echo (!$plan_permissions['enable_share']) ? 'disabled' : '' ; ?> id="share_providers" data-iconBase="fa" data-tickIcon="fa-check" data-actions-box="true" data-selected-text-format="count > 8" data-count-selected-text="{0} <?php echo _("items selected"); ?>" data-deselect-all-text="<?php echo _("Deselect All"); ?>" data-select-all-text="<?php echo _("Select All"); ?>" data-none-selected-text="<?php echo _("Nothing selected"); ?>" data-none-results-text="<?php echo _("No results matched"); ?> {0}" data-size="9" class="form-control selectpicker" multiple>
                                    <?php if(in_array('copy_link',$array_share_providers_settings)) : ?><option data-icon="fas fa-link" id="provider_copy_link" <?php echo (in_array('copy_link',$array_share_providers) ? 'selected' : ''); ?>><?php echo _("Copy Link"); ?></option><?php endif; ?>
                                    <?php if(in_array('email',$array_share_providers_settings)) : ?><option data-icon="fas fa-envelope" id="provider_email" <?php echo (in_array('email',$array_share_providers) ? 'selected' : ''); ?>><?php echo _("Email"); ?></option><?php endif; ?>
                                    <?php if(in_array('whatsapp',$array_share_providers_settings)) : ?><option data-icon="fab fa-whatsapp" id="provider_whatsapp" <?php echo (in_array('whatsapp',$array_share_providers) ? 'selected' : ''); ?>><?php echo _("Whatsapp"); ?></option><?php endif; ?>
                                    <?php if(in_array('facebook',$array_share_providers_settings)) : ?><option data-icon="fab fa-facebook" id="provider_facebook" <?php echo (in_array('facebook',$array_share_providers) ? 'selected' : ''); ?>><?php echo _("Facebook"); ?></option><?php endif; ?>
                                    <?php if(in_array('twitter',$array_share_providers_settings)) : ?><option data-icon="fab fa-x-twitter" id="provider_twitter" <?php echo (in_array('twitter',$array_share_providers) ? 'selected' : ''); ?>><?php echo _("Twitter"); ?></option><?php endif; ?>
                                    <?php if(in_array('linkedin',$array_share_providers_settings)) : ?><option data-icon="fab fa-linkedin" id="provider_linkedin" <?php echo (in_array('linkedin',$array_share_providers) ? 'selected' : ''); ?>><?php echo _("Linkedin"); ?></option><?php endif; ?>
                                    <?php if(in_array('telegram',$array_share_providers_settings)) : ?><option data-icon="fab fa-telegram" id="provider_telegram" <?php echo (in_array('telegram',$array_share_providers) ? 'selected' : ''); ?>><?php echo _("Telegram"); ?></option><?php endif; ?>
                                    <?php if(in_array('facebook_messenger',$array_share_providers_settings)) : ?><option data-icon="fab fa-facebook-messenger" id="provider_facebook_messenger" <?php echo (in_array('facebook_messenger',$array_share_providers) ? 'selected' : ''); ?>><?php echo _("Facebook Messenger"); ?></option><?php endif; ?>
                                    <?php if(in_array('pinterest',$array_share_providers_settings)) : ?><option data-icon="fab fa-pinterest" id="provider_pinterest" <?php echo (in_array('pinterest',$array_share_providers) ? 'selected' : ''); ?>><?php echo _("Pinterest"); ?></option><?php endif; ?>
                                    <?php if(in_array('reddit',$array_share_providers_settings)) : ?><option data-icon="fab fa-reddit" id="provider_reddit" <?php echo (in_array('reddit',$array_share_providers) ? 'selected' : ''); ?>><?php echo _("Reddit"); ?></option><?php endif; ?>
                                    <?php if(in_array('line',$array_share_providers_settings)) : ?><option data-icon="fab fa-line" id="provider_line" <?php echo (in_array('line',$array_share_providers) ? 'selected' : ''); ?>><?php echo _("Line"); ?></option><?php endif; ?>
                                    <?php if(in_array('viber',$array_share_providers_settings)) : ?><option data-icon="fab fa-viber" id="provider_viber" <?php echo (in_array('viber',$array_share_providers) ? 'selected' : ''); ?>><?php echo _("Viber"); ?></option><?php endif; ?>
                                    <?php if(in_array('vk',$array_share_providers_settings)) : ?><option data-icon="fab fa-vk" id="provider_vk" <?php echo (in_array('vk',$array_share_providers) ? 'selected' : ''); ?>><?php echo _("VK"); ?></option><?php endif; ?>
                                    <?php if(in_array('qzone',$array_share_providers_settings)) : ?><option data-icon="fab fa-qq" id="provider_qzone" <?php echo (in_array('qzone',$array_share_providers) ? 'selected' : ''); ?>><?php echo _("Qzone"); ?></option><?php endif; ?>
                                    <?php if(in_array('wechat',$array_share_providers_settings)) : ?><option data-icon="fab fa-weixin" id="provider_wechat" <?php echo (in_array('wechat',$array_share_providers) ? 'selected' : ''); ?>><?php echo _("Wechat"); ?></option><?php endif; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="ui_edit_form" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Main Form"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <label for="show_main_form"><?php echo _("Show"); ?></label><br>
                                <input onchange="save_vt_ui(false,false,false);" <?php echo (!$plan_permissions['enable_forms']) ? 'disabled' : '' ; ?> type="checkbox" id="show_main_form" <?php echo ($virtual_tour['show_main_form'])?'checked':''; ?> />
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('form',''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('form'); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('form',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('form',true,true,true); ?>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label style="margin-bottom: 1px"><?php echo _("Background Color"); ?></label>
                                    <input id="form_background_m" type="text" class="form-control form-control-sm" value="<?php echo (isset($form_content[0]['background'])) ? $form_content[0]['background'] : 'rgba(255,255,255,1.0)'; ?>">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label style="margin-bottom: 1px"><?php echo _("Text Color"); ?></label>
                                    <input id="form_color_m" type="text" class="form-control form-control-sm" value="<?php echo (isset($form_content[0]['color'])) ? $form_content[0]['color'] : '#000000'; ?>">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label style="margin-bottom: 1px"><?php echo _("Button - Background Color"); ?></label>
                                    <input id="form_background_button" type="text" class="form-control form-control-sm" value="<?php echo (isset($form_content[0]['background_button'])) ? $form_content[0]['background_button'] : '#000000'; ?>">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label style="margin-bottom: 1px"><?php echo _("Button - Text Color"); ?></label>
                                    <input id="form_color_button" type="text" class="form-control form-control-sm" value="<?php echo (isset($form_content[0]['color_button'])) ? $form_content[0]['color_button'] : '#ffffff'; ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr class="my-0 py-0">
                    <div class="ui_title_msg py-1 px-3 noselect"><i class="fas fa-exclamation-circle"></i>&nbsp;&nbsp;<?php echo _("create in: virtual tours - main form"); ?>&nbsp;&nbsp;<span onclick="open_modal_edit_contents('editor_form');" class="editor_ui_shortcut_icon badge badge-primary"><i class="fas fa-external-link-alt"></i></span></div>
                </div>
                <div id="ui_edit_meeting" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Meeting"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <label for="meeting"><?php echo _("Show"); ?></label><br>
                                <select onchange="save_vt_ui(false,false,false);" <?php echo (!$plan_permissions['enable_meeting']) ? 'disabled' : '' ; ?> id="meeting" class="form-control form-control-sm">
                                    <option <?php echo ($virtual_tour['meeting']==0) ? 'selected':''; ?> id="0"><?php echo _("Disabled"); ?></option>
                                    <option <?php echo ($virtual_tour['meeting']==1) ? 'selected':''; ?> id="1"><?php echo _("Enabled"); ?></option>
                                    <option <?php echo ($virtual_tour['meeting']==2) ? 'selected':''; ?> id="2"><?php echo _("Enabled, opened"); ?></option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('meeting',''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('meeting'); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('meeting',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('meeting',true,true,true); ?>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-12 <?php echo ($virtual_tour['ar_simulator']) ? 'd-none' : ''; ?>">
                                <div class="form-group">
                                    <label for="password_meeting"><?php echo _("Password"); ?> <i title="<?php echo _("leave blank to disable password"); ?>" class="help_t fas fa-question-circle"></i></label><br>
                                    <input autocomplete="new-password" <?php echo (!$plan_permissions['enable_meeting']) ? 'disabled' : '' ; ?> type="password" class="form-control <?php echo ($edit_version) ? 'disabled_d' : ''; ?>" id="password_meeting" value="<?php echo ($virtual_tour['password_meeting']!='') ? 'keep_password' : ''; ?>" />
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="ui_edit_live_session" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Live Session"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-6">
                                <label for="live_session"><?php echo _("Show"); ?></label><br>
                                <input onchange="save_vt_ui(false,false,false);" <?php echo (!$plan_permissions['enable_live_session']) ? 'disabled' : '' ; ?> type="checkbox" id="live_session" <?php echo ($virtual_tour['live_session'])?'checked':''; ?> />
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_position('live',''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo print_ui_icon('live'); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo print_ui_main_color('live',true,true,true); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo print_ui_hover_color('live',true,true,true); ?>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-12 <?php echo ($virtual_tour['ar_simulator']) ? 'd-none' : ''; ?>">
                                <div class="form-group">
                                    <label for="password_livesession"><?php echo _("Password"); ?> <i title="<?php echo _("leave blank to disable password"); ?>" class="help_t fas fa-question-circle"></i></label><br>
                                    <input autocomplete="new-password" <?php echo (!$plan_permissions['enable_live_session']) ? 'disabled' : '' ; ?> type="password" class="form-control <?php echo ($edit_version) ? 'disabled_d' : ''; ?>" id="password_livesession" value="<?php echo ($virtual_tour['password_livesession']!='') ? 'keep_password' : ''; ?>" />
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="ui_edit_nadir" class="ui_edit_box noselect">
                    <div class="ui_title_box noselect"><i onclick="close_edit_box();" class="fas fa-times close_ui_edit_box"></i><?php echo _("Nadir"); ?></div>
                    <div class="ui_content_box">
                        <div class="row">
                            <div class="col-md-12">
                                <label for="nadir_size"><?php echo _("Size"); ?></label><br>
                                <input style="width:300px;" oninput="redraw_nadir();" type="range" min="10" max="600" step="5" value="<?php echo str_replace('px','',$virtual_tour['nadir_size']); ?>" class="form-control-range <?php echo ($edit_version) ? 'disabled_d' : ''; ?>" id="nadir_size" />
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    var show_logo = parseInt($('#show_logo option:selected').attr('id'));
    var logo_opacity = $('#logo_opacity').val();
    var logo_opacity_hover = $('#logo_opacity_hover').val();
    if(show_logo>0) {
        $(".logo").css('opacity',logo_opacity);
    }
    $(".logo").hover(function() {
        if(show_logo>0) {
            $(this).css('opacity',logo_opacity_hover);
        } else {
            $(this).css('opacity','');
        }
    }, function() {
        if(show_logo>0) {
            $(this).css('opacity',logo_opacity);
        } else {
            $(this).css('opacity','');
        }
    });
    var show_poweredby = parseInt($('#show_poweredby option:selected').attr('id'));
    var poweredby_opacity = $('#poweredby_opacity').val();
    var poweredby_opacity_hover = $('#poweredby_opacity_hover').val();
    if(show_poweredby>0) {
        $(".poweredby").css('opacity',poweredby_opacity);
    }
    $(".poweredby").hover(function() {
        if(show_poweredby>0) {
            $(this).css('opacity',poweredby_opacity_hover);
        } else {
            $(this).css('opacity','');
        }
    }, function() {
        if(show_poweredby>0) {
            $(this).css('opacity',poweredby_opacity);
        } else {
            $(this).css('opacity','');
        }
    });
</script>
<style>
    .header_vt { height: <?php echo $ui_style['items']['title']['background_height']; ?>px; }
    .comments_vt { color: <?php echo $ui_style['items']['comments']['color']; ?>; }
    .logo img { height: <?php echo $ui_style['items']['logo']['height']; ?>px;margin-top: <?php echo $ui_style['items']['logo']['padding_top']; ?>px;margin-left: <?php echo $ui_style['items']['logo']['padding_left']; ?>px;margin-right: <?php echo $ui_style['items']['logo']['padding_right']; ?>px; }
    .rooms_view_sel img { width: <?php echo $ui_style['items']['multiple_room_views']['size']; ?>px;height: <?php echo $ui_style['items']['multiple_room_views']['size']; ?>px;border-radius: <?php echo ($ui_style['items']['multiple_room_views']['style']=='round') ? '50%' : ($ui_style['items']['multiple_room_views']['size']/10).'px'; ?>;border-width: <?php echo $ui_style['items']['multiple_room_views']['border']; ?>px;border-color: <?php echo $ui_style['items']['multiple_room_views']['color']; ?>; }
    .rooms_view_sel img.active { border-color: <?php echo $ui_style['items']['multiple_room_views']['color']; ?>; }
    .poweredby img { height: <?php echo $ui_style['items']['poweredby']['image_height']; ?>px; }
    .poweredby span { font-size: <?php echo $ui_style['items']['poweredby']['font_size']; ?>px; color: <?php echo $ui_style['items']['poweredby']['font_color']; ?>; }
    .avatar_video { width: <?php echo ($ui_style['items']['avatar_video']['width']==0) ? 'auto' : $ui_style['items']['avatar_video']['width']."px"; ?>; height: <?php echo ($ui_style['items']['avatar_video']['height']==0) ? 'auto' : $ui_style['items']['avatar_video']['height']."px"; ?>;margin-bottom: <?php echo $ui_style['items']['avatar_video']['padding_bottom']; ?>px;margin-left: <?php echo $ui_style['items']['avatar_video']['padding_left']; ?>px;margin-right: <?php echo $ui_style['items']['avatar_video']['padding_right']; ?>px; }
    .nav_control { background-color: <?php echo $ui_style['items']['nav_control']['background']; ?>; }
    .nav_control i { color: <?php echo $ui_style['items']['nav_control']['color']; ?>; }
    .nav_control i:hover { color: <?php echo $ui_style['items']['nav_control']['color_hover']; ?>; }
    .fullscreen_control { color: <?php echo $ui_style['icons']['fullscreen']['color']; ?>; }
    .fullscreen_control:hover { color: <?php echo $ui_style['icons']['fullscreen']['color_hover']; ?>; }
    .map_control { color: <?php echo $ui_style['icons']['floorplan']['color']; ?>; }
    .map_control:hover { color: <?php echo $ui_style['icons']['floorplan']['color_hover']; ?>; }
    .map_tour_control { color: <?php echo $ui_style['icons']['map']['color']; ?>; }
    .map_tour_control:hover { color: <?php echo $ui_style['icons']['map']['color_hover']; ?>; }
    .song_control { color: <?php echo $ui_style['icons']['audio']['color']; ?>; }
    .song_control:hover { color: <?php echo $ui_style['icons']['audio']['color_hover']; ?>; }
    .list_alt_menu .title i { color: <?php echo $ui_style['icons']['list_alt']['color']; ?>; }
    .list_alt_menu .title i:hover { color: <?php echo $ui_style['icons']['list_alt']['color_hover']; ?>; }
    .list_alt_menu .arrow { border-bottom: 10px solid <?php echo $list_alt_menu_background; ?>; }
    .list_alt_menu .dropdown {  <?php echo $ui_style['controls']['list_alt_menu']['style']; ?>; }
    .list_alt_menu p:hover { <?php echo $ui_style['controls']['list_alt_menu']['style_hover']; ?>; }
    .list_alt_menu p i {  color: <?php echo $ui_style['controls']['list_alt_menu']['icon_color']; ?>; }
    .list_alt_menu p:hover i { color: <?php echo $ui_style['controls']['list_alt_menu']['icon_color_hover']; ?>; }
    .menu_controls .title i { color: <?php echo $ui_style['icons']['menu']['color']; ?>; }
    .menu_controls .title i:hover { color: <?php echo $ui_style['icons']['menu']['color_hover']; ?>; }
    .list_control { background: linear-gradient(180deg, <?php echo $ui_style['items']['list']['background_initial']; ?>, <?php echo $ui_style['items']['list']['background']; ?> 100%); }
    .list_control i { <?php echo $ui_style['controls']['list']['style']; ?> }
    .list_control:hover i { <?php echo $ui_style['controls']['list']['style_hover']; ?> }
    .list_slider { background-color: <?php echo $ui_style['items']['list']['background']; ?>; }
    .list_slider .list_left, .list_slider .list_right { <?php echo $ui_style['controls']['nav_arrows']['style']; ?> }
    .list_slider .list_left:hover, .list_slider .list_right:hover { <?php echo $ui_style['controls']['nav_arrows']['style_hover']; ?> }
    .list_slider .slidee li.active { box-shadow: 0px 0px 1px 0px <?php echo $active_border_list_color; ?>, 0px 0px 2px 1px <?php echo $active_border_list_color; ?>; }
    .controls_arrows { <?php echo $ui_style['controls']['arrows']['style']; ?> }
    .controls_arrows .next_arrow:hover, .controls_arrows .prev_arrow:hover { <?php echo $ui_style['controls']['arrows']['style_hover']; ?> }
    <?php if($ui_style['controls']['arrows']['type']=='default') { ?>
    .controls_arrows { background-color: transparent; }
    <?php } ?>
    .list_control_alt { <?php echo $ui_style['controls']['list']['style']; ?> }
    .list_control_alt:hover { <?php echo $ui_style['controls']['list']['style_hover']; ?> }
    .arrows_nav .prev_arrow, .arrows_nav .next_arrow { <?php echo $ui_style['controls']['arrows']['style']; ?> }
    .arrows_nav .prev_arrow:hover, .arrows_nav .next_arrow:hover { <?php echo $ui_style['controls']['arrows']['style_hover']; ?> }
    .custom_control { <?php echo $ui_style['controls']['custom']['style']; ?> }
    .custom_control:hover { <?php echo $ui_style['controls']['custom']['style_hover']; ?> }
    .custom2_control { <?php echo $ui_style['controls']['custom2']['style']; ?> }
    .custom2_control:hover { <?php echo $ui_style['controls']['custom2']['style_hover']; ?> }
    .custom3_control { <?php echo $ui_style['controls']['custom3']['style']; ?> }
    .custom3_control:hover { <?php echo $ui_style['controls']['custom3']['style_hover']; ?> }
    .custom4_control { <?php echo $ui_style['controls']['custom4']['style']; ?> }
    .custom4_control:hover { <?php echo $ui_style['controls']['custom4']['style_hover']; ?> }
    .custom5_control { <?php echo $ui_style['controls']['custom5']['style']; ?> }
    .custom5_control:hover { <?php echo $ui_style['controls']['custom5']['style_hover']; ?> }
    .location_control { <?php echo $ui_style['controls']['location']['style']; ?> }
    .location_control:hover { <?php echo $ui_style['controls']['location']['style_hover']; ?> }
    .media_control { <?php echo $ui_style['controls']['media']['style']; ?> }
    .media_control:hover { <?php echo $ui_style['controls']['media']['style_hover']; ?> }
    .snapshot_control { <?php echo $ui_style['controls']['snapshot']['style']; ?> }
    .snapshot_control:hover { <?php echo $ui_style['controls']['snapshot']['style_hover']; ?> }
    .info_control { <?php echo $ui_style['controls']['info']['style']; ?> }
    .info_control:hover { <?php echo $ui_style['controls']['info']['style_hover']; ?> }
    .dollhouse_control { <?php echo $ui_style['controls']['dollhouse']['style']; ?> }
    .dollhouse_control:hover { <?php echo $ui_style['controls']['dollhouse']['style_hover']; ?> }
    .gallery_control { <?php echo $ui_style['controls']['gallery']['style']; ?> }
    .gallery_control:hover { <?php echo $ui_style['controls']['gallery']['style_hover']; ?> }
    .presentation_control { <?php echo $ui_style['controls']['presentation']['style']; ?> }
    .presentation_control:hover { <?php echo $ui_style['controls']['presentation']['style_hover']; ?> }
    .facebook_control { <?php echo $ui_style['controls']['facebook']['style']; ?> }
    .facebook_control:hover { <?php echo $ui_style['controls']['facebook']['style_hover']; ?> }
    .whatsapp_control { <?php echo $ui_style['controls']['whatsapp']['style']; ?> }
    .whatsapp_control:hover { <?php echo $ui_style['controls']['whatsapp']['style_hover']; ?> }
    .share_control { <?php echo $ui_style['controls']['share']['style']; ?> }
    .share_control:hover { <?php echo $ui_style['controls']['share']['style_hover']; ?> }
    .form_control { <?php echo $ui_style['controls']['form']['style']; ?> }
    .form_control:hover { <?php echo $ui_style['controls']['form']['style_hover']; ?> }
    .live_control { <?php echo $ui_style['controls']['live']['style']; ?> }
    .live_control:hover { <?php echo $ui_style['controls']['live']['style_hover']; ?> }
    .meeting_control { <?php echo $ui_style['controls']['meeting']['style']; ?> }
    .meeting_control:hover { <?php echo $ui_style['controls']['meeting']['style_hover']; ?> }
    .vr_control { <?php echo $ui_style['controls']['vr']['style']; ?> }
    .vr_control:hover { <?php echo $ui_style['controls']['vr']['style_hover']; ?> }
    .icons_control { <?php echo $ui_style['controls']['icons']['style']; ?> }
    .icons_control:hover { <?php echo $ui_style['controls']['icons']['style_hover']; ?> }
    .icons_content_control { <?php echo $ui_style['controls']['icons_content']['style']; ?> }
    .icons_content_control:hover { <?php echo $ui_style['controls']['icons_content']['style_hover']; ?> }
    .icons_nav_control { <?php echo $ui_style['controls']['icons_nav']['style']; ?> }
    .icons_nav_control:hover { <?php echo $ui_style['controls']['icons_nav']['style_hover']; ?> }
    .measures_control { <?php echo $ui_style['controls']['measures']['style']; ?> }
    .measures_control:hover { <?php echo $ui_style['controls']['measures']['style_hover']; ?> }
    .autorotate_control { <?php echo $ui_style['controls']['autorotate']['style']; ?> }
    .autorotate_control:hover { <?php echo $ui_style['controls']['autorotate']['style_hover']; ?> }
    .orient_control { <?php echo $ui_style['controls']['orient']['style']; ?> }
    .orient_control:hover { <?php echo $ui_style['controls']['orient']['style_hover']; ?> }
    .annotations_control { <?php echo $ui_style['controls']['annotations']['style']; ?> }
    .annotations_control:hover { <?php echo $ui_style['controls']['annotations']['style_hover']; ?> }
    .compass_control { <?php echo $ui_style['controls']['compass']['style']; ?> }
    .compass_control:hover { <?php echo $ui_style['controls']['compass']['style_hover']; ?> }
    .annotation { background-color: <?php echo $ui_style['items']['annotation']['background']; ?>; color: <?php echo $ui_style['items']['annotation']['color']; ?>; }
    .annotation hr { color: <?php echo $ui_style['items']['annotation']['color']; ?>; border-top: 1px solid <?php echo $ui_style['items']['annotation']['color']; ?>; }
    #inline_form_toggle, #inline_form_content { background-color: <?php echo $ui_style['items']['inline_form']['background']; ?>; color: <?php echo $ui_style['items']['inline_form']['color']; ?>; }
    .inline_form_input, .inline_form_textarea, .inline_form_select { background-color: <?php echo $ui_style['items']['inline_form']['field_background']; ?>; color: <?php echo $ui_style['items']['inline_form']['field_color']; ?>; }
    .inline_form_submit_button { background-color: <?php echo $ui_style['items']['inline_form']['button_background']; ?>; color: <?php echo $ui_style['items']['inline_form']['button_color']; ?>; }
    <?php if(!empty($ui_style['items']['title']['background'])) { ?>
    .header_vt { color: <?php echo $ui_style['items']['title']['color']; ?>; background: linear-gradient(to bottom, <?php echo $ui_style['items']['title']['background']; ?>,0.3) 0%, <?php echo $ui_style['items']['title']['background']; ?>,0.269) 14.3%, <?php echo $ui_style['items']['title']['background']; ?>,0.24) 26.2%, <?php echo $ui_style['items']['title']['background']; ?>,0.214) 36%, <?php echo $ui_style['items']['title']['background']; ?>,0.19) 44.1%, <?php echo $ui_style['items']['title']['background']; ?>,0.168) 50.6%, <?php echo $ui_style['items']['title']['background']; ?>,0.148) 55.9%, <?php echo $ui_style['items']['title']['background']; ?>,0.129) 60.4%, <?php echo $ui_style['items']['title']['background']; ?>,0.111) 64.3%, <?php echo $ui_style['items']['title']['background']; ?>,0.094) 67.8%, <?php echo $ui_style['items']['title']['background']; ?>,0.078) 71.4%, <?php echo $ui_style['items']['title']['background']; ?>,0.062) 75.3%, <?php echo $ui_style['items']['title']['background']; ?>,0.047) 79.8%, <?php echo $ui_style['items']['title']['background']; ?>,0.031) 85.2%, <?php echo $ui_style['items']['title']['background']; ?>,0.016) 91.9%, <?php echo $ui_style['items']['title']['background']; ?>,0) 100%);}
    <?php } else { ?>
    .header_vt { color: <?php echo $ui_style['items']['title']['color']; ?>; background: transparent;}
    <?php } ?>
    <?php if($virtual_tour['ar_simulator']) : ?>
    #controls_bottom_left, #controls_bottom_center, #controls_bottom_right {
        bottom: 6px !important;
    }
    .song_control {
        left: 48px !important;
    }
    #controls_bottom_left {
        padding-left: 0px !important;
    }
    <?php endif; ?>
    .map_bar { width: 100%; background-color: <?php echo $ui_style['items']['map']['background']; ?>; }
    .all_maps { border: 1px solid <?php echo $ui_style['items']['map']['background']; ?>; }
    .map_name { color: <?php echo $ui_style['items']['map']['color']; ?> }
    .map_selector_control i { color: <?php echo $ui_style['items']['map']['color']; ?> }
    .map_selector_control:hover i { color: <?php echo $ui_style['items']['map']['color_hover']; ?> }
    .map_zoom_plus_control i { color: <?php echo $ui_style['items']['map']['color']; ?> }
    .map_zoom_plus_control:hover i { color: <?php echo $ui_style['items']['map']['color_hover']; ?> }
    .map_zoom_minus_control i { color: <?php echo $ui_style['items']['map']['color']; ?> }
    .map_zoom_minus_control:hover i { color: <?php echo $ui_style['items']['map']['color_hover']; ?> }
    .map_zoom_control i { color: <?php echo $ui_style['items']['map']['color']; ?> }
    .map_zoom_control:hover i { color: <?php echo $ui_style['items']['map']['color_hover']; ?> }
    .map_close_control i { color: <?php echo $ui_style['items']['map']['color']; ?> }
    .map_close_control:hover i { color: <?php echo $ui_style['items']['map']['color_hover']; ?> }
    .visitors_rt_stats { background-color: <?php echo $ui_style['items']['visitors_rt_stats']['background']; ?>; color: <?php echo $ui_style['items']['visitors_rt_stats']['color']; ?>; }
    .fullscreen_alt_control { <?php echo $ui_style['controls']['fullscreen_alt']['style']; ?> }
    .fullscreen_alt_control:hover { <?php echo $ui_style['controls']['fullscreen_alt']['style_hover']; ?> }
    .floorplan_alt_control { <?php echo $ui_style['controls']['floorplan_alt']['style']; ?> }
    .floorplan_alt_control:hover { <?php echo $ui_style['controls']['floorplan_alt']['style_hover']; ?> }
    .map_alt_control { <?php echo $ui_style['controls']['map_alt']['style']; ?> }
    .map_alt_control:hover { <?php echo $ui_style['controls']['map_alt']['style_hover']; ?> }
    .language_alt_control { <?php echo $ui_style['controls']['language_alt']['style']; ?> }
    .language_alt_control:hover { <?php echo $ui_style['controls']['language_alt']['style_hover']; ?> }
    .song_alt_control { <?php echo $ui_style['controls']['song_alt']['style']; ?> }
    .song_alt_control:hover { <?php echo $ui_style['controls']['song_alt']['style_hover']; ?> }
    #menu_sidebar, #menu_sidebar #ms_close { background-color: <?php echo $ui_style['sidebar']['background']; ?>; }
</style>

<script>
    (function($) {
        "use strict"; // Start of use strict
        Dropzone.autoDiscover = false;
        window.id_user = '<?php echo $id_user; ?>';
        window.id_virtualtour = '<?php echo $id_virtualtour_sel; ?>';
        window.ui_need_save = false;
        window.ui_edit_box_open = false;
        var is_dragging = false;
        window.hfov = '<?php echo ($room1['hfov']==0) ? $virtual_tour['hfov'] : $room1['hfov']; ?>';
        window.hfov_default = '<?php echo $virtual_tour['hfov']; ?>';
        window.min_hfov = '<?php echo $virtual_tour['min_hfov']; ?>';
        window.max_hfov = '<?php echo $virtual_tour['max_hfov']; ?>';
        window.nadir_logo = '<?php echo $virtual_tour['nadir_logo']; ?>';
        window.nadir_round = '<?php echo ($virtual_tour['nadir_round']) ? 1 : 0; ?>';
        window.nadir_size = '<?php echo $virtual_tour['nadir_size']; ?>';
        window.media_file = '<?php echo $virtual_tour['media_file']; ?>';
        window.avatar_video = '<?php echo $avatar_video; ?>';
        window.yaw = '<?php echo $room1['yaw']; ?>';
        window.pitch = '<?php echo $room1['pitch']; ?>';
        window.h_pitch = '<?php echo $room1['h_pitch']; ?>';
        window.h_roll = '<?php echo $room1['h_roll']; ?>';
        window.northOffset = '<?php echo $room1['northOffset']; ?>';
        window.allow_pitch = '<?php echo $room1['allow_pitch']; ?>';
        window.allow_hfov = '<?php echo $room1['allow_hfov']; ?>';
        window.min_pitch = '<?php echo $room1['min_pitch']; ?>';
        window.max_pitch = '<?php echo $room1['max_pitch']; ?>';
        window.map_north = '<?php echo $room1['north_degree']; ?>';
        window.min_yaw = '<?php echo $room1['min_yaw']; ?>';
        window.max_yaw = '<?php echo $room1['max_yaw']; ?>';
        window.haov = '<?php echo $room1['haov']; ?>';
        window.vaov = '<?php echo $room1['vaov']; ?>';
        window.room_type = '<?php echo $room1['type']; ?>';
        window.viewer = null;
        window.viewer_video = null;
        window.ratio_hfov = 1;
        window.viewer_initialized = false;
        window.video = document.createElement("video");
        window.canvas = document.createElement("canvas");
        window.s3_enabled = <?php echo ($s3_enabled) ? 1 : 0; ?>;
        window.s3_url = '<?php echo $s3_url; ?>';
        if(window.s3_enabled==1) {
            window.panorama_image = window.s3_url+"viewer/panoramas/<?php echo $room1['panorama_image']; ?>?s3=1";
            window.panorama_video = window.s3_url+"viewer/videos/<?php echo $room1['panorama_video']; ?>";
        } else {
            window.panorama_image = "../viewer/panoramas/<?php echo $room1['panorama_image']; ?>";
            window.panorama_video = "../viewer/videos/<?php echo $room1['panorama_video']; ?>";
        }
        window.multires = '<?php echo $room1['multires']; ?>';
        window.multires_config = '<?php echo $room1['multires_config']; ?>';
        window.custom_content_html = null;
        window.custom2_content_html = null;
        window.custom3_content_html = null;
        window.custom4_content_html = null;
        window.custom5_content_html = null;
        window.custom_content_html_langs = [];
        window.custom2_content_html_langs = [];
        window.custom3_content_html_langs = [];
        window.custom4_content_html_langs = [];
        window.custom5_content_html_langs = [];
        window.markers_color_spectrum = null;
        window.markers_background_spectrum = null;
        window.markers_tooltip_color_spectrum = null;
        window.markers_tooltip_background_spectrum = null;
        window.pois_color_spectrum = null;
        window.pois_background_spectrum = null;
        window.pois_tooltip_background_spectrum = null;
        window.pois_tooltip_color_spectrum = null;
        window.poweredby_font_color_spectrum = null;
        window.gallery_dropzone = null;
        window.gallery_dropzone_im = null;
        window.gallery_dropzone_ip = null;
        window.is_fullscreen = false;
        var markers_id_icon_library = '<?php echo $virtual_tour['markers_id_icon_library']; ?>';
        var markers_id_vt_library = '<?php echo $virtual_tour['markers_id_vt_library']; ?>';
        var markers_image_icon_library = '<?php echo $virtual_tour['markers_image_icon_library']; ?>';
        var pois_id_icon_library = '<?php echo $virtual_tour['pois_id_icon_library']; ?>';
        var pois_id_vt_library = '<?php echo $virtual_tour['pois_id_vt_library']; ?>';
        var pois_image_icon_library = '<?php echo $virtual_tour['pois_image_icon_library']; ?>';
        var list_alt = '<?php echo str_replace("'","\'",json_encode($array_list_alt)); ?>';
        var id_room_1 = '<?php echo $rooms[0]['id']; ?>';
        window.font_provider = '<?php echo $settings['font_provider']; ?>';
        window.default_language = '<?php echo $default_language; ?>';
        window.media_file_langs = {};
        $(document).ready(function () {
            $('.controls_btn').tooltip();
            $('#ms_language_switcher img').tooltip();
            $('.ms_control').tooltip();
            $('#skitt-ui').tooltip();
            $('.nav_control').tooltip();
            $('.prev_arrow').tooltip();
            $('.next_arrow').tooltip();
            $('.annotation').tooltip();
            $('.inline_form').tooltip();
            $('#menu_icon').tooltip();
            $('.song_control').tooltip();
            $('.map_control').tooltip();
            $('.map_tour_control').tooltip();
            $('.language_control').tooltip();
            $('.fullscreen_control').tooltip();
            $('.logo').tooltip();
            $('.poweredby').tooltip();
            $('.avatar_video').tooltip();
            $('.map').tooltip();
            $('.name_vt').tooltip();
            $('.room_vt').tooltip();
            $('.comments_vt').tooltip();
            $('.tooltip_view').tooltip();
            $('.list_alt_menu .title i').tooltip();
            $('*[data-ui-target="ui_edit_slider"]').tooltip();
            $('*[data-ui-target="ui_edit_slider_nav"]').tooltip();
            $('.input_lang[data-target-id="div_exist_media"]').each(function() {
                var lang = $(this).attr('data-lang');
                var media_file = $('#media_file_'+lang).val();
                window.media_file_langs[lang] = media_file;
            });
            get_rooms_menu_list_editor_ui();
            bsCustomFileInput.init();
            $('.help_t').tooltip();
            if(media_file=='') {
                $('#div_delete_media').hide();
                $('#div_image_media').hide();
                $('#div_upload_media').show();
                $('#div_exist_media').show();
            } else {
                $('#div_delete_media').show();
                $('#div_image_media').show();
                $('#div_upload_media').hide();
                $('#div_exist_media').hide();
            }
            if(window.avatar_video!='') {
                var video = $('.avatar_video video')[0];
                video.addEventListener('loadeddata', (event) => {
                    $('#ui_container .avatar_video').css('border-color','white');
                });
                var array_videos = window.avatar_video.split(",");
                var mov_video = '', webm_video = '';
                jQuery.each(array_videos, function(index_s, video_s) {
                    if(video_s.split('.').pop().toLowerCase()=='mov') {
                        mov_video = video_s;
                    }
                    if(video_s.split('.').pop().toLowerCase()=='webm') {
                        webm_video = video_s;
                    }
                });
                if(webm_video!='' && mov_video!='') {
                    if(supportsHEVCAlpha()) {
                        if(window.s3_enabled==1) {
                            $('.avatar_video video').attr('src',window.s3_url+'viewer/'+mov_video);
                        } else {
                            $('.avatar_video video').attr('src','../viewer/'+mov_video);
                        }
                    } else {
                        if(window.s3_enabled==1) {
                            $('.avatar_video video').attr('src',window.s3_url+'viewer/'+webm_video);
                        } else {
                            $('.avatar_video video').attr('src','../viewer/'+webm_video);
                        }
                    }
                } else if(webm_video!='' && mov_video=='') {
                    if(window.s3_enabled==1) {
                        $('.avatar_video video').attr('src',window.s3_url+'viewer/'+webm_video);
                    } else {
                        $('.avatar_video video').attr('src','../viewer/'+webm_video);
                    }
                } else if(webm_video=='' && mov_video!='') {
                    if(window.s3_enabled==1) {
                        $('.avatar_video video').attr('src',window.s3_url+'viewer/'+mov_video);
                    } else {
                        $('.avatar_video video').attr('src','../viewer/'+mov_video);
                    }
                }
            } else {
                $('#ui_container .avatar_video').css('border-color','white');
            }
            $('#font_viewer').fontpicker({
                variants:false,
                localFonts: {},
                nrRecents: 0,
                parentElement: '#editor_ui_div',
                onSelect: function(e) {
                    var font = e.fontFamily;
                    switch(font_provider) {
                        case 'google':
                            $('#css_font').attr('href','https://fonts.googleapis.com/css?family='+font);
                            break;
                        case 'collabs':
                            $('#css_font').attr('href','https://api.fonts.coollabs.io/css2?family='+font+'&display=swap');
                            break;
                    }
                    $('#ui_container *:not(i):not(.controls_btn):not(.ms_control):not(.menu_controls):not(.list_alt_menu):not(.song_control):not(.title):not(.dropdown)').css('font-family',"'"+font+"', sans-serif");
                }
            });
            if(window.font_provider=='systems') {
                $('.font-picker').addClass('d-none');
            }
            var container_h = $('#content-wrapper').height() - 205;
            $('#ui_container').css('height',container_h+'px');
            toggle_menu_control_disabled_ui();
            fix_ui_order();
            adjust_elements_positions();
            change_tooltip_type_m_vt();
            change_tooltip_type_p_vt();
            check_all_editor_ui_items();
            $('#ui_container').css('opacity',1);
            $('#tool_ui').removeClass('d-none');
            try {
                multires_config = JSON.parse(multires_config);
            } catch (e) {
                multires = false;
            }
            setTimeout(function () {
                fix_colors_menu();
                load_viewer_ui(room_type,window.panorama_image,window.panorama_video,yaw,pitch,h_pitch,h_roll,haov,vaov,min_yaw,max_yaw);
                setTimeout(function () {
                    initialize_editor_ui_elements();
                },200);
            },0);
        });
        $(window).resize(function () {
            if(window.is_fullscreen) {
                var b_h = $('#editor_toolbar').height();
                $('#ui_container').css('height','calc(100% - '+b_h+'px)');
            } else {
                var container_h = $('#content-wrapper').height() - 205;
                $('#ui_container').css('height',container_h+'px');
            }
        });
        const toggleButton = document.getElementById('inline_form_toggle');
        const formContainer = document.getElementById('inline_form_content');
        const arrowIcon = document.getElementById('inline_form_arrow_icon');
        toggleButton.addEventListener('click', () => {
            const isOpening = !formContainer.classList.contains('open');
            arrowIcon.style.transform = isOpening ? 'rotate(180deg)' : 'rotate(0deg)';
            if (isOpening) {
                toggleButton.classList.add('form_is_open');
                formContainer.classList.add('open');
            } else {
                formContainer.classList.remove('open');
                formContainer.addEventListener('transitionend', () => {
                    toggleButton.classList.remove('form_is_open');
                }, { once: true });
            }
        });
        window.get_rooms_menu_list_editor_ui = function () {
            $('.list_alt_menu .dropdown').empty();
            $.ajax({
                url: "ajax/get_rooms_menu_list.php",
                type: "POST",
                data: {
                    id_virtualtour: window.id_virtualtour,
                    language: ''
                },
                async: true,
                success: function (json) {
                    try {
                        var array_list_alt = JSON.parse(json);
                        parse_room_menu_list(array_list_alt,'root',0,parseInt(id_room_1));
                        removeEmptyCategories();
                    } catch (e) {}
                }
            });
        };
        window.initialize_editor_ui_elements = function() {
            IconPicker.Init({
                jsonUrl: 'vendor/iconpicker/iconpicker-6.7.2.json',
                searchPlaceholder: '<?php echo _("Search Icon"); ?>',
                showAllButton: '<?php echo _("Show All"); ?>',
                cancelButton: '<?php echo _("Cancel"); ?>',
                noResultsFound: '<?php echo _("No results found."); ?>',
                borderRadius: '20px',
                appendTo: document.getElementById('editor_ui_div')
            });
            IconPicker.Run('#GetIconPicker', function(){
                var icon = $('#pois_icon').val();
                $('.div_poi_wrapper i').removeClass();
                $('.div_poi_wrapper i').addClass(icon);
                window.vt_need_save = true;
            });
            IconPicker.Run('#GetIconPicker_p', function(){
                var icon = $('#markers_icon').val();
                $('.div_marker_wrapper i').removeClass();
                $('.div_marker_wrapper i').addClass(icon);
                window.vt_need_save = true;
            });
            window.markers_color_spectrum = $('#markers_color').spectrum({
                type: "text",
                preferredFormat: "hex",
                showAlpha: false,
                showButtons: false,
                allowEmpty: false,
                appendTo: '#editor_ui_div'
            });
            $("#markers_color").on('move.spectrum', function(e, color) {
                $('.div_marker_wrapper span').css('color',color.toRgbString());
                $('.div_marker_wrapper i').css('color',color.toRgbString());
                $('.div_marker_wrapper').css('border-color',color.toRgbString());
            });
            window.markers_background_spectrum = $('#markers_background').spectrum({
                type: "text",
                preferredFormat: "rgb",
                showAlpha: true,
                showButtons: false,
                allowEmpty: false,
                appendTo: '#editor_ui_div'
            });
            $("#markers_background").on('move.spectrum', function(e, color) {
                var style = $('#markers_icon_type option:selected').attr('id');
                switch(style) {
                    case 'stroke':
                        $('.div_marker_wrapper_bg i').css('-webkit-text-stroke','1px '+color.toRgbString());
                        $('.div_marker_wrapper_bg i').css('text-shadow','-1px -1px 0 '+color.toRgbString()+', 1px -1px 0 '+color.toRgbString()+', -1px 1px 0 '+color.toRgbString()+', 1px 1px 0 '+color.toRgbString());
                        $('.div_marker_wrapper_bg span').css('-webkit-text-stroke','1px '+color.toRgbString());
                        $('.div_marker_wrapper_bg span').css('text-shadow','-1px -1px 0 '+color.toRgbString()+', 1px -1px 0 '+color.toRgbString()+', -1px 1px 0 '+color.toRgbString()+', 1px 1px 0 '+color.toRgbString());
                        break;
                    default:
                        $('.div_marker_wrapper_bg').css('background-color',color.toRgbString());
                        break;
                }
            });
            window.markers_tooltip_color_spectrum = $('#markers_tooltip_color').spectrum({
                type: "text",
                preferredFormat: "hex",
                showAlpha: false,
                showButtons: false,
                allowEmpty: false,
                appendTo: '#editor_ui_div'
            });
            window.markers_tooltip_background_spectrum = $('#markers_tooltip_background').spectrum({
                type: "text",
                preferredFormat: "rgb",
                showAlpha: true,
                showButtons: false,
                allowEmpty: false,
                appendTo: '#editor_ui_div'
            });
            window.pois_color_spectrum = $('#pois_color').spectrum({
                type: "text",
                preferredFormat: "hex",
                showAlpha: false,
                showButtons: false,
                allowEmpty: false,
                appendTo: '#editor_ui_div'
            });
            $("#pois_color").on('move.spectrum', function(e, color) {
                $('.div_poi_wrapper span').css('color',color.toRgbString());
                $('.div_poi_wrapper i').css('color',color.toRgbString());
                $('.div_poi_wrapper').css('border-color',color.toRgbString());
            });
            window.pois_background_spectrum = $('#pois_background').spectrum({
                type: "text",
                preferredFormat: "rgb",
                showAlpha: true,
                showButtons: false,
                allowEmpty: false,
                appendTo: '#editor_ui_div'
            });
            $("#pois_background").on('move.spectrum', function(e, color) {
                var style = $('#pois_icon_type option:selected').attr('id');
                switch(style) {
                    case 'stroke':
                        $('.div_poi_wrapper_bg i').css('-webkit-text-stroke','1px '+color.toRgbString());
                        $('.div_poi_wrapper_bg i').css('text-shadow','-1px -1px 0 '+color.toRgbString()+', 1px -1px 0 '+color.toRgbString()+', -1px 1px 0 '+color.toRgbString()+', 1px 1px 0 '+color.toRgbString());
                        $('.div_poi_wrapper_bg span').css('-webkit-text-stroke','1px '+color.toRgbString());
                        $('.div_poi_wrapper_bg span').css('text-shadow','-1px -1px 0 '+color.toRgbString()+', 1px -1px 0 '+color.toRgbString()+', -1px 1px 0 '+color.toRgbString()+', 1px 1px 0 '+color.toRgbString());
                        break;
                    default:
                        $('.div_poi_wrapper_bg').css('background-color',color.toRgbString());
                        break;
                }
            });
            window.pois_tooltip_background_spectrum = $('#pois_tooltip_background').spectrum({
                type: "text",
                preferredFormat: "rgb",
                showAlpha: true,
                showButtons: false,
                allowEmpty: false,
                appendTo: '#editor_ui_div'
            });
            window.pois_tooltip_color_spectrum = $('#pois_tooltip_color').spectrum({
                type: "text",
                preferredFormat: "hex",
                showAlpha: false,
                showButtons: false,
                allowEmpty: false,
                appendTo: '#editor_ui_div'
            });
            window.poweredby_font_color_spectrum = $('#poweredby_font_color').spectrum({
                type: "text",
                preferredFormat: "hex",
                showAlpha: false,
                showButtons: false,
                allowEmpty: false,
                appendTo: '#editor_ui_div'
            });
            $("#poweredby_font_color").on('move.spectrum', function(e, color) {
                $('.poweredby span').css('color',color.toRgbString());
            });
            $('#form_background_m').spectrum({
                type: "text",
                preferredFormat: "rgb",
                showAlpha: true,
                showButtons: false,
                allowEmpty: false,
                appendTo: '#editor_ui_div'
            });
            $('#form_color_m').spectrum({
                type: "text",
                preferredFormat: "hex",
                showAlpha: false,
                showButtons: false,
                allowEmpty: false,
                appendTo: '#editor_ui_div'
            });
            $('#form_background_button').spectrum({
                type: "text",
                preferredFormat: "hex",
                showAlpha: false,
                showButtons: false,
                allowEmpty: false,
                appendTo: '#editor_ui_div'
            });
            $('#form_color_button').spectrum({
                type: "text",
                preferredFormat: "hex",
                showAlpha: false,
                showButtons: false,
                allowEmpty: false,
                appendTo: '#editor_ui_div'
            });
            $('.lottie_icon_marker_list').each(function () {
                var id = $(this).attr('data-id');
                var image = $(this).attr('data-image');
                var id_vt_library = $(this).attr('data-id_vt');
                if(window.s3_enabled==1 && id_vt_library!='') {
                    var image_url = window.s3_url+'viewer/icons/'+image;
                } else {
                    var image_url = '../viewer/icons/'+image;
                }
                bodymovin.loadAnimation({
                    container: document.getElementById('lottie_icon_marker_'+id),
                    renderer: 'svg',
                    loop: true,
                    autoplay: true,
                    path: image_url,
                    rendererSettings: {
                        progressiveLoad: true,
                    }
                });
            });
            $('.lottie_icon_poi_list').each(function () {
                var id = $(this).attr('data-id');
                var image = $(this).attr('data-image');
                var id_vt_library = $(this).attr('data-id_vt');
                if(window.s3_enabled==1 && id_vt_library!='') {
                    var image_url = window.s3_url+'viewer/icons/'+image;
                } else {
                    var image_url = '../viewer/icons/'+image;
                }
                bodymovin.loadAnimation({
                    container: document.getElementById('lottie_icon_poi_'+id),
                    renderer: 'svg',
                    loop: true,
                    autoplay: true,
                    path: image_url,
                    rendererSettings: {
                        progressiveLoad: true,
                    }
                });
            });
            var ext = markers_image_icon_library.split('.').pop().toLowerCase();
            if(ext=='json') {
                select_icon_library_v("marker", markers_id_icon_library, markers_image_icon_library, markers_id_vt_library);
            }
            var ext = pois_image_icon_library.split('.').pop().toLowerCase();
            if(ext=='json') {
                select_icon_library_v("poi", pois_id_icon_library, pois_image_icon_library, pois_id_vt_library);
            }
            window.custom_content_html = ace.edit('custom_content');
            window.custom_content_html.session.setMode("ace/mode/html");
            window.custom_content_html.setOption('enableLiveAutocompletion',true);
            window.custom_content_html.setShowPrintMargin(false);
            if($('body').hasClass('dark_mode')) {
                window.custom_content_html.setTheme("ace/theme/one_dark");
            }
            if(window.rtl==1) {
                window.custom_content_html.setOption("rtl", true);
            }
            window.custom2_content_html = ace.edit('custom2_content');
            window.custom2_content_html.session.setMode("ace/mode/html");
            window.custom2_content_html.setOption('enableLiveAutocompletion',true);
            window.custom2_content_html.setShowPrintMargin(false);
            if($('body').hasClass('dark_mode')) {
                window.custom2_content_html.setTheme("ace/theme/one_dark");
            }
            if(window.rtl==1) {
                window.custom2_content_html.setOption("rtl", true);
            }
            window.custom3_content_html = ace.edit('custom3_content');
            window.custom3_content_html.session.setMode("ace/mode/html");
            window.custom3_content_html.setOption('enableLiveAutocompletion',true);
            window.custom3_content_html.setShowPrintMargin(false);
            if($('body').hasClass('dark_mode')) {
                window.custom3_content_html.setTheme("ace/theme/one_dark");
            }
            if(window.rtl==1) {
                window.custom3_content_html.setOption("rtl", true);
            }
            window.custom4_content_html = ace.edit('custom4_content');
            window.custom4_content_html.session.setMode("ace/mode/html");
            window.custom4_content_html.setOption('enableLiveAutocompletion',true);
            window.custom4_content_html.setShowPrintMargin(false);
            if($('body').hasClass('dark_mode')) {
                window.custom4_content_html.setTheme("ace/theme/one_dark");
            }
            if(window.rtl==1) {
                window.custom4_content_html.setOption("rtl", true);
            }
            window.custom5_content_html = ace.edit('custom5_content');
            window.custom5_content_html.session.setMode("ace/mode/html");
            window.custom5_content_html.setOption('enableLiveAutocompletion',true);
            window.custom5_content_html.setShowPrintMargin(false);
            if($('body').hasClass('dark_mode')) {
                window.custom5_content_html.setTheme("ace/theme/one_dark");
            }
            if(window.rtl==1) {
                window.custom5_content_html.setOption("rtl", true);
            }
            $('.input_lang[data-target-id="custom_content"]').each(function() {
                var lang = $(this).attr('data-lang');
                window.custom_content_html_langs[lang] = ace.edit('custom_content_'+lang);
                window.custom_content_html_langs[lang].session.setMode("ace/mode/html");
                window.custom_content_html_langs[lang].setOption('enableLiveAutocompletion',true);
                window.custom_content_html_langs[lang].setShowPrintMargin(false);
                if($('body').hasClass('dark_mode')) {
                    window.custom_content_html_langs[lang].setTheme("ace/theme/one_dark");
                }
                if(window.rtl==1) {
                    window.custom_content_html_langs[lang].setOption("rtl", true);
                }
            });
            $('.input_lang[data-target-id="custom2_content"]').each(function() {
                var lang = $(this).attr('data-lang');
                window.custom2_content_html_langs[lang] = ace.edit('custom2_content_'+lang);
                window.custom2_content_html_langs[lang].session.setMode("ace/mode/html");
                window.custom2_content_html_langs[lang].setOption('enableLiveAutocompletion',true);
                window.custom2_content_html_langs[lang].setShowPrintMargin(false);
                if($('body').hasClass('dark_mode')) {
                    window.custom2_content_html_langs[lang].setTheme("ace/theme/one_dark");
                }
                if(window.rtl==1) {
                    window.custom2_content_html_langs[lang].setOption("rtl", true);
                }
            });
            $('.input_lang[data-target-id="custom3_content"]').each(function() {
                var lang = $(this).attr('data-lang');
                window.custom3_content_html_langs[lang] = ace.edit('custom3_content_'+lang);
                window.custom3_content_html_langs[lang].session.setMode("ace/mode/html");
                window.custom3_content_html_langs[lang].setOption('enableLiveAutocompletion',true);
                window.custom3_content_html_langs[lang].setShowPrintMargin(false);
                if($('body').hasClass('dark_mode')) {
                    window.custom3_content_html_langs[lang].setTheme("ace/theme/one_dark");
                }
                if(window.rtl==1) {
                    window.custom3_content_html_langs[lang].setOption("rtl", true);
                }
            });
            $('.input_lang[data-target-id="custom4_content"]').each(function() {
                var lang = $(this).attr('data-lang');
                window.custom4_content_html_langs[lang] = ace.edit('custom4_content_'+lang);
                window.custom4_content_html_langs[lang].session.setMode("ace/mode/html");
                window.custom4_content_html_langs[lang].setOption('enableLiveAutocompletion',true);
                window.custom4_content_html_langs[lang].setShowPrintMargin(false);
                if($('body').hasClass('dark_mode')) {
                    window.custom4_content_html_langs[lang].setTheme("ace/theme/one_dark");
                }
                if(window.rtl==1) {
                    window.custom4_content_html_langs[lang].setOption("rtl", true);
                }
            });
            $('.input_lang[data-target-id="custom5_content"]').each(function() {
                var lang = $(this).attr('data-lang');
                window.custom5_content_html_langs[lang] = ace.edit('custom5_content_'+lang);
                window.custom5_content_html_langs[lang].session.setMode("ace/mode/html");
                window.custom5_content_html_langs[lang].setOption('enableLiveAutocompletion',true);
                window.custom5_content_html_langs[lang].setShowPrintMargin(false);
                if($('body').hasClass('dark_mode')) {
                    window.custom5_content_html_langs[lang].setTheme("ace/theme/one_dark");
                }
                if(window.rtl==1) {
                    window.custom5_content_html_langs[lang].setOption("rtl", true);
                }
            });
            $('.icon_picker').each(function () {
                var id = $(this).attr('id');
                var target = $(this)[0].getAttribute('data-target');
                IconPicker.Run('#'+id, function(){
                    var icon_class = $('input#'+target+'_icon').val();
                    $('.'+target+'_control i:first-of-type').removeClass();
                    $('.'+target+'_control i:first-of-type').addClass(icon_class);
                });
            });
            if(!$('.controls_arrows .prev_arrow').hasClass('ui_hidden')) {
                $('.controls_arrows i:not(.ui_hidden):first-child').css('margin-right','-9px');
                $('.controls_arrows i:not(.ui_hidden):nth-child(2)').css('margin-right','-9px');
            }
            if($('.list_control').hasClass('ui_hidden')) {
                $('#controls_bottom_center').css('bottom','112px');
            } else {
                $('#controls_bottom_center').css('bottom','136px');
            }
            $(".controls_btn, .ms_control, .menu_controls .dropdown p").hover(
                function() {
                    if(!$(this).hasClass('ui_disabled')) {
                        var id = $(this).attr('data-id-color');
                        $(this).css('color',$('#'+id+'_color_hover').val());
                        $(this).css('background-color',$('#'+id+'_background_hover').val());
                    }
                }, function() {
                    var id = $(this).attr('data-id-color');
                    $(this).css('color', $('#'+id+'_color').val());
                    $(this).css('background-color', $('#'+id+'_background').val());
                }
            );
            $(".list_control_alt").hover(
                function() {
                    if(!$(this).hasClass('ui_disabled')) {
                        var id = $(this).attr('data-id-color');
                        $(this).css('color',$('#'+id+'_color_hover').val());
                        $(this).css('background-color',$('#'+id+'_background_hover').val());
                    }
                }, function() {
                    $('.list_control_alt').css('color', $('#list_color').val());
                    $('.list_control_alt').css('background-color', $('#list_background').val());
                }
            );
            $(".controls_arrows .prev_arrow, .controls_arrows .next_arrow").hover(
                function() {
                    if(!$(this).hasClass('ui_disabled')) {
                        var id = $(this).attr('data-id-color');
                        $(this).css('color',$('#'+id+'_color_hover').val());
                        $(this).css('background-color',$('#'+id+'_background_hover').val());
                    }
                }, function() {
                    $('.controls_arrows .prev_arrow').css('color', $('#arrows_color').val());
                    $('.controls_arrows .next_arrow').css('color', $('#arrows_color').val());
                    $('.controls_arrows .prev_arrow').css('background-color', '');
                    $('.controls_arrows .next_arrow').css('background-color', '');
                    $('.controls_arrows').css('background-color', $('#arrows_background').val());
                }
            );
            $(".arrows_nav i").hover(
                function() {
                    if(!$(this).hasClass('ui_disabled')) {
                        $(this).css('color',$('#arrows_color_hover').val());
                    }
                }, function() {
                    $(this).css('color', $('#arrows_color').val());
                }
            );
            $(".list_control").hover(
                function() {
                    if(!$(this).hasClass('ui_disabled')) {
                        $(".list_control i").css('color',$('#list_color_hover').val());
                    }
                }, function() {
                    $(".list_control i").css('color', $('#list_color').val());
                }
            );
            $(".list_slider i").hover(
                function() {
                    if(!$(this).hasClass('ui_disabled')) {
                        $(this).css('color',$('#nav_arrows_color_hover').val());
                    }
                }, function() {
                    $(this).css('color', $('#nav_arrows_color').val());
                }
            );
            $(".list_alt_menu p").hover(
                function() {
                    if(!$(this).hasClass('ui_disabled')) {
                        $(this).find('i').css('color',$('#list_alt_menu_icon_color_hover').val());
                        $(this).css('color',$('#list_alt_menu_color_hover').val());
                        $(this).css('background',$('#list_alt_menu_background_hover').val());
                    }
                }, function() {
                    $(this).find('i').css('color',$('#list_alt_menu_icon_color').val());
                    $(this).css('color', $('#list_alt_menu_color').val());
                    $(this).css('background','');
                }
            );
            $(".fullscreen_control, .map_tour_control, .map_control, .song_control, .list_alt_menu .title i, .menu_controls .title i, .nav_control i").hover(
                function() {
                    var id = $(this).attr('data-id-color');
                    if(!$(this).hasClass('ui_disabled')) {
                        $(this).css('color',$('#'+id+'_color_hover').val());
                    }
                }, function() {
                    var id = $(this).attr('data-id-color');
                    $(this).css('color', $('#'+id+'_color').val());
                }
            );
            $(".map_selector_control, .map_zoom_minus_control, .map_zoom_plus_control, .map_zoom_control, .map_close_control").hover(
                function() {
                    if(!$(this).hasClass('ui_disabled')) {
                        $(this).find("i").css('color',$('#map_bar_color_hover').val());
                    }
                }, function() {
                    $(this).find("i").css('color', $('#map_bar_color').val());
                }
            );
            $('#btn_toggle_fullscreen').tooltipster({
                delay: 10,
                hideOnClick: true,
                position: 'left'
            });
            $('.color_picker').spectrum({
                type: "text",
                preferredFormat: "rgb",
                showAlpha: true,
                showButtons: false,
                allowEmpty: false,
                appendTo: '#editor_ui_div'
            });
            $(".color_picker").on('dragstart.spectrum', function(e, color) {
                is_dragging = true;
            });
            $(".color_picker").on('dragstop.spectrum', function(e, color) {
                is_dragging = false;
                save_vt_ui(false,false,false);
            });
            $(".color_picker").on('move.spectrum', function(e, color) {
                var target = e.target.getAttribute('data-target');
                var target_type = e.target.getAttribute('data-target-type');
                switch(target_type) {
                    case 'color':
                        switch(target) {
                            case 'list_alt_menu_control':
                                $('.list_alt_menu p').css('color',color.toRgbString());
                                break;
                            case 'list_alt_menu_icon_control':
                                $('.list_alt_menu p i').css('color',color.toRgbString());
                                break;
                            case 'list_control':
                                $('.list_control i').css('color',color.toRgbString());
                                $('.list_control_alt').css('color',color.toRgbString());
                                $('.list_slider .slidee li.active').css('box-shadow','0px 0px 1px 0px '+color.toRgbString()+', 0px 0px 2px 1px '+color.toRgbString());
                                break;
                            case 'controls_arrow':
                            case 'controls_arrows':
                                $('.arrows_nav i').css('color',color.toRgbString());
                                $('.controls_arrows .next_arrow').css('color',color.toRgbString());
                                $('.controls_arrows .prev_arrow').css('color',color.toRgbString());
                                break;
                            case 'nav_arrows_control':
                                $('.list_slider i').css('color',color.toRgbString());
                                break;
                            case 'annotation':
                                $('.annotation').css('color',color.toRgbString());
                                $('.annotation hr').css('border-top','1px solid '+color.toRgbString());
                                break;
                            case 'inline_form':
                                $('#inline_form_toggle, #inline_form_content').css('color',color.toRgbString());
                                break;
                            case 'inline_form_button':
                                $('.inline_form_submit_button').css('color',color.toRgbString());
                                break;
                            case 'inline_form_field':
                                $('.inline_form_input, .inline_form_textarea, .inline_form_select').css('color',color.toRgbString());
                                break;
                            case 'map_bar':
                                $('.map_selector_control i').css('color',color.toRgbString());
                                $('.map_name').css('color',color.toRgbString());
                                $('.map_zoom_minus_control i').css('color',color.toRgbString());
                                $('.map_zoom_plus_control i').css('color',color.toRgbString());
                                $('.map_zoom_control i').css('color',color.toRgbString());
                                $('.map_close_control i').css('color',color.toRgbString());
                                break;
                            case 'rooms_alt':
                                $('.rooms_view_sel img').css('border-color',color.toRgbString());
                                break;
                            default:
                                $('.'+target).css('color',color.toRgbString());
                                break;
                        }
                        break;
                    case 'background':
                        switch(target) {
                            case 'list_alt_menu_control':
                                $('.list_alt_menu .dropdown').css('background',color.toRgbString());
                                $('.list_alt_menu .arrow').css('border-bottom','10px solid '+color.toRgbString());
                                break;
                            case 'list_control':
                                $('.list_control i').css('background',color.toRgbString());
                                $('.list_control_alt').css('background',color.toRgbString());
                                break;
                            case 'controls_arrow':
                            case 'controls_arrows':
                                $('.arrows_nav i').css('background',color.toRgbString());
                                $('.controls_arrows').css('background',color.toRgbString());
                                break;
                            case 'slider':
                                $('.list_slider').css('background',color.toRgbString());
                                var background_initial = color.toRgbString().split(",");
                                if(background_initial.length==4) {
                                    var opacity = background_initial.pop().replace(")","");
                                    opacity = opacity/2;
                                    background_initial = background_initial.toString()+")";
                                } else {
                                    var opacity = 0.5;
                                }
                                background_initial = background_initial.toString().replace('rgb(','rgba(');
                                var background_initial_style = "linear-gradient(180deg, "+background_initial.replace(")",",0)")+" 70%, "+ background_initial.replace(")",","+opacity+")") +" 85%, "+color.toRgbString()+" 100%)";
                                $('.list_control').css('background',background_initial_style);
                                break;
                            case 'annotation':
                                $('.annotation').css('background-color',color.toRgbString());
                                break;
                            case 'inline_form':
                                $('#inline_form_toggle, #inline_form_content').css('background-color',color.toRgbString());
                                break;
                            case 'inline_form_button':
                                $('.inline_form_submit_button').css('background-color',color.toRgbString());
                                break;
                            case 'inline_form_field':
                                $('.inline_form_input, .inline_form_textarea, .inline_form_select').css('background-color',color.toRgbString());
                                break;
                            case 'map_bar':
                                $('.map_bar').css('background-color',color.toRgbString());
                                $('.all_maps').css('border','1px solid '+color.toRgbString());
                                break;
                            default:
                                $('.'+target).css('background-color',color.toRgbString());
                                break;
                        }
                        break;
                }
                if(!is_dragging) {
                    save_vt_ui(false,false,false);
                } else {
                    fix_colors_menu();
                }
            });
            $('.color_picker_bg').spectrum({
                type: "text",
                preferredFormat: "rgb",
                showAlpha: false,
                showButtons: false,
                allowEmpty: true,
                appendTo: '#editor_ui_div'
            });
            $(".color_picker_bg").on('dragstart.spectrum', function(e, color) {
                is_dragging = true;
            });
            $(".color_picker_bg").on('dragstop.spectrum', function(e, color) {
                is_dragging = false;
                save_vt_ui(false,false,false);
            });
            $(".color_picker_bg").on('move.spectrum', function(e, color) {
                var target = e.target.getAttribute('data-target');
                var target_type = e.target.getAttribute('data-target-type');
                switch(target_type) {
                    case 'background':
                        switch(target) {
                            case 'header_vt':
                                if(color==null) {
                                    $('.header_vt').css('background','transparent');
                                } else {
                                    color = color.toRgbString().replace("rgb",'rgba').replace(")","");
                                    $('.header_vt').css('background','linear-gradient(to bottom, '+color+',0.3) 0%, '+color+',0.269) 14.3%, '+color+',0.24) 26.2%, '+color+',0.214) 36%, '+color+',0.19) 44.1%, '+color+',0.168) 50.6%, '+color+',0.148) 55.9%, '+color+',0.129) 60.4%, '+color+',0.111) 64.3%, '+color+',0.094) 67.8%, '+color+',0.078) 71.4%, '+color+',0.062) 75.3%, '+color+',0.047) 79.8%, '+color+',0.031) 85.2%, '+color+',0.016) 91.9%, '+color+',0) 100%)');
                                }
                                break;
                        }
                        break;
                }
                if(!is_dragging) {
                    save_vt_ui(false,false,false);
                }
            });
            if($('.lang_input_switcher').length) {
                $('.lang_input_switcher').each(function() {
                    var elem_o = $(this).attr('data-elem');
                    var lang_o = $(this).attr('data-default-lang');
                    switch_input_language(lang_o,lang_o,elem_o);
                });
            }
            $('#exist_media').selectator({
                useSearch: false
            });
        }
        
        $('#modal_default_pois_style').on('shown.bs.modal', function (e) { $(document).off('focusin.modal'); });
        $('#modal_default_markers_style').on('shown.bs.modal', function (e) { $(document).off('focusin.modal'); });
        var drag_slider = false, drag_slider_start = 0, drag_slider_end = 0;
        $(document).on('mousedown',function () {
            drag_slider_start = new Date().getTime();
            drag_slider = false;
        });
        $(document).on('mousemove',function () {
            drag_slider_end = new Date().getTime();
            drag_slider = true;
        });
        $(document).on("click", function(event){
            var diff_drag = drag_slider_end - drag_slider_start;
            if(drag_slider == false || diff_drag < 200) {
                if($(event.target).closest("#modal_list_alt").length) {
                } else if($(event.target).closest(".font-picker").length) {
                } else if($(event.target).closest("#IconPickerModal").length) {
                } else if($(event.target).closest("#modal_custom_content").length) {
                } else if($(event.target).closest("#modal_custom2_content").length) {
                } else if($(event.target).closest("#modal_custom3_content").length) {
                } else if($(event.target).closest("#modal_custom4_content").length) {
                } else if($(event.target).closest("#modal_custom5_content").length) {
                } else if($(event.target).closest("#modal_location_content").length) {
                } else if($(event.target).closest("#modal_media_file").length) {
                } else if($(event.target).closest("#btn_toggle_fullscreen").length) {
                } else if($(event.target).closest("#modal_library_icons").length) {
                } else if($(event.target).closest("#gallery-dropzone").length) {
                } else if($(event.target).closest(".dz-button").length) {
                } else if($(event.target).closest(".dz-hidden-input").length) {
                } else if($(event.target).closest("#tool_ui").length) {
                } else if($(event.target).closest(".editor_ui_shortcut_icon").length) {
                } else if($(event.target).closest("#modal_edit_contents").length) {
                } else if(!$(event.target).closest(".ui_edit_box").length) {
                    $(".ui_edit_box").hide();
                    $('#list_editor_ui_items li').removeClass('active');
                    $('#ui_container .avatar_video').css('z-index',30);
                    var ui_target = $(event.target).attr('data-ui-target');
                    if(ui_target !== undefined) {
                        if(ui_target=='ui_edit_avatar_video') {
                            $('#ui_container .avatar_video').css('z-index',1001);
                        }
                        if(ui_target=='ui_edit_menu') {
                            if ($('.menu_controls .dropdown')[0].classList.contains('down')) {
                                $('#list_editor_ui_items li[data-ui-target="'+ui_target+'"]').addClass('active');
                                $('#'+ui_target).show();
                            }
                            if ($('#menu_sidebar').hasClass('open')) {
                                $('#list_editor_ui_items li[data-ui-target="'+ui_target+'"]').addClass('active');
                                $('#'+ui_target).show();
                            }
                        } else {
                            $('#list_editor_ui_items li[data-ui-target="'+ui_target+'"]').addClass('active');
                            $('#'+ui_target).show();
                        }
                        if(ui_target=='ui_edit_list_alt') {
                            if ($('#list_alt_menu .dropdown')[0].classList.contains('down')) {
                                $('#list_editor_ui_items li[data-ui-target="'+ui_target+'"]').addClass('active');
                                $('#'+ui_target).show();
                            }
                        } else {
                            $('#list_editor_ui_items li[data-ui-target="'+ui_target+'"]').addClass('active');
                            $('#'+ui_target).show();
                        }
                    }
                }
            }
        });
        window.open_edit_ui_style = function () {
            $(".ui_edit_box").hide();
            $('#list_editor_ui_items li').removeClass('active');
            $('#ui_container .avatar_video').css('z-index',30);
            $('#ui_edit_ui_style').show();
        }
        window.click_menu_controls = function () {
            if($('#menu_type option:selected').attr('id')=='sidebar') {
                $('#menu_sidebar').addClass('open');
            } else {
                $('.menu_controls .dropdown')[0].classList.toggle('down');
                $('.menu_controls .arrow')[0].classList.toggle('gone');
                if ($('.menu_controls .dropdown')[0].classList.contains('down')) {
                    setTimeout(function() {
                        $('.menu_controls .dropdown')[0].style.overflow = 'visible';
                    }, 100)
                } else {
                    $('.menu_controls .dropdown')[0].style.overflow = 'hidden';
                }
                if ($('#list_alt_menu .dropdown')[0].classList.contains('down')) {
                    $('#list_alt_menu .dropdown')[0].classList.remove('down');
                    $('#list_alt_menu .arrow')[0].classList.remove('gone');
                    $('#list_alt_menu .dropdown')[0].style.overflow = 'hidden';
                }
            }
        }
        window.close_menu_sidebar = function () {
            $('#menu_sidebar').removeClass('open');
        }
        window.click_list_alt_controls = function () {
            $('#list_alt_menu .dropdown')[0].classList.toggle('down');
            $('#list_alt_menu .arrow')[0].classList.toggle('gone');
            if ($('#list_alt_menu .dropdown')[0].classList.contains('down')) {
                setTimeout(function() {
                    $('#list_alt_menu .dropdown')[0].style.overflow = 'visible';
                }, 100)
            } else {
                $('#list_alt_menu .dropdown')[0].style.overflow = 'hidden';
            }
            if ($('.menu_controls .dropdown')[0].classList.contains('down')) {
                $('.menu_controls .dropdown')[0].classList.remove('down');
                $('.menu_controls .arrow')[0].classList.remove('gone');
                $('.menu_controls .dropdown')[0].style.overflow = 'hidden';
            }
        }
        window.adjust_elements_positions = function () {
            var logo_h = $('.logo')[0].getBoundingClientRect().height;
            var annotation_h = $('.annotation')[0].getBoundingClientRect().height;
            var inline_form_h = $('#inline_form_toggle')[0].getBoundingClientRect().height;
            var top_right = 45;
            var top_left = 45;
            $('.map_top_right').css('top',top_right+'px');
            $('.annotation_top_right').css('top',top_right+'px');
            $('.inline_form_top_right').css('top',top_right+'px');
            $('.map_top_left').css('top',top_left+'px');
            $('.annotation_top_left').css('top',top_left+'px');
            $('.inline_form_top_left').css('top',top_left+'px');
            if($('.logo').hasClass('logo_top_right') && $('.logo').is(':visible')) {
                top_right += logo_h+5;
                $('.map_top_right').css('top',top_right+'px');
                $('.annotation_top_right').css('top',top_right+'px');
                $('.inline_form_top_right').css('top',top_right+'px');
            }
            if($('.annotation').hasClass('annotation_top_right') && $('.annotation').is(':visible')) {
                top_right += annotation_h+5;
                $('.map_top_right').css('top',top_right+'px');
                $('.inline_form_top_right').css('top',top_right+'px');
            }
            if($('.inline_form').hasClass('inline_form_top_right') && $('.inline_form').is(':visible')) {
                top_right += inline_form_h+5;
                $('.map_top_right').css('top',top_right+'px');
            }
            if($('.logo').hasClass('logo_top_left') && $('.logo').is(':visible')) {
                top_left += logo_h+5;
                $('.map_top_left').css('top',top_left+'px');
                $('.annotation_top_left').css('top',top_left+'px');
                $('.inline_form_top_left').css('top',top_left+'px');
            }
            if($('.annotation').hasClass('annotation_top_left') && $('.annotation').is(':visible')) {
                top_left += annotation_h+5;
                $('.map_top_left').css('top',top_left+'px');
                $('.inline_form_top_left').css('top',top_left+'px');
            }
            if($('.inline_form').hasClass('inline_form_top_left') && $('.inline_form').is(':visible')) {
                top_left += inline_form_h+5;
                $('.map_top_left').css('top',top_left+'px');
            }
            if($('.logo').hasClass('logo_top_center') && $('.logo').is(':visible')) {
                $('.name_vt').css('margin-top',(logo_h+3)+'px');
                $('.rooms_view_sel').css('margin-top',(logo_h+3)+'px');
            } else {
                $('.name_vt').css('margin-top','0');
                $('.rooms_view_sel').css('margin-top','0');
            }
            var menu_type = $('#menu_type option:selected').attr('id');
            if(menu_type=='sidebar') {
                $('#list_alt_menu').addClass('ui_hidden');
                $('.song_control_icon').css('left','45px');
                $('#list_alt_menu_background').hide();
                $('#list_alt_menu_background_hover').hide();
            } else {
                $('#list_alt_menu').removeClass('ui_hidden');
                $('.song_control_icon').css('left','75px');
                $('#list_alt_menu_background').show();
                $('#list_alt_menu_background_hover').show();
            }
        }

        $("input").on('input change',function(){
            window.ui_need_save = true;
        });

        $("select").on('input change',function(){
            if($(this).attr('id')!='virtualtour_selector') {
                window.ui_need_save = true;
            }
        });

        $(window).on('beforeunload', function(){
            if(window.ui_need_save) {
                var c=confirm();
                if(c) return true; else return false;
            }
        });

    })(jQuery); // End of use strict

    window.open_modal_library_icons_pois = function () {
        if(window.gallery_dropzone_ip==null) {
            window.gallery_dropzone_ip = new Dropzone("#gallery-dropzone-ip", {
                url: "ajax/upload_icon_image.php",
                parallelUploads: 1,
                maxFilesize: 20,
                timeout: 120000,
                dictDefaultMessage: "<?php echo _("Drop files or click here to upload"); ?>",
                dictFallbackMessage: "<?php echo _("Your browser does not support drag'n'drop file uploads."); ?>",
                dictFallbackText: "<?php echo _("Please use the fallback form below to upload your files like in the olden days."); ?>",
                dictFileTooBig: "<?php echo sprintf(_("File is too big (%sMiB). Max filesize: %sMiB."),'{{filesize}}','{{maxFilesize}}'); ?>",
                dictInvalidFileType: "<?php echo _("You can't upload files of this type."); ?>",
                dictResponseError: "<?php echo sprintf(_("Server responded with %s code."),'{{statusCode}}'); ?>",
                dictCancelUpload: "<?php echo _("Cancel upload"); ?>",
                dictCancelUploadConfirmation: "<?php echo _("Are you sure you want to cancel this upload?"); ?>",
                dictRemoveFile: "<?php echo _("Remove file"); ?>",
                dictMaxFilesExceeded: "<?php echo _("You can not upload any more files."); ?>",
                acceptedFiles: 'image/*,application/json'
            });
            window.gallery_dropzone_ip.on("addedfile", function(file) {
                $('#list_images_ip').addClass('disabled');
            });
            window.gallery_dropzone_ip.on("success", function(file,rsp) {
                add_image_to_icon_m(id_virtualtour,rsp,'poi');
            });
            window.gallery_dropzone_ip.on("queuecomplete", function() {
                $('#list_images_ip').removeClass('disabled');
                window.gallery_dropzone_ip.removeAllFiles();
            });
        }
        $('#modal_library_icons_pois').modal('show');
    }

    window.open_modal_library_icons_markers = function () {
        if(window.gallery_dropzone_im==null) {
            window.gallery_dropzone_im = new Dropzone("#gallery-dropzone-im", {
                url: "ajax/upload_icon_image.php",
                parallelUploads: 1,
                maxFilesize: 20,
                timeout: 120000,
                dictDefaultMessage: "<?php echo _("Drop files or click here to upload"); ?>",
                dictFallbackMessage: "<?php echo _("Your browser does not support drag'n'drop file uploads."); ?>",
                dictFallbackText: "<?php echo _("Please use the fallback form below to upload your files like in the olden days."); ?>",
                dictFileTooBig: "<?php echo sprintf(_("File is too big (%sMiB). Max filesize: %sMiB."),'{{filesize}}','{{maxFilesize}}'); ?>",
                dictInvalidFileType: "<?php echo _("You can't upload files of this type."); ?>",
                dictResponseError: "<?php echo sprintf(_("Server responded with %s code."),'{{statusCode}}'); ?>",
                dictCancelUpload: "<?php echo _("Cancel upload"); ?>",
                dictCancelUploadConfirmation: "<?php echo _("Are you sure you want to cancel this upload?"); ?>",
                dictRemoveFile: "<?php echo _("Remove file"); ?>",
                dictMaxFilesExceeded: "<?php echo _("You can not upload any more files."); ?>",
                acceptedFiles: 'image/*,application/json'
            });
            window.gallery_dropzone_im.on("addedfile", function(file) {
                $('#list_images_im').addClass('disabled');
            });
            window.gallery_dropzone_im.on("success", function(file,rsp) {
                add_image_to_icon_m(id_virtualtour,rsp,'marker');
            });
            window.gallery_dropzone_im.on("queuecomplete", function() {
                $('#list_images_im').removeClass('disabled');
                window.gallery_dropzone_im.removeAllFiles();
            });
        }
        $('#modal_library_icons_markers').modal('show');
    }

    window.element_icon_sel = '';
    window.open_modal_library_icons = function (element) {
        window.element_icon_sel = element;
        if(window.gallery_dropzone==null) {
            window.gallery_dropzone = new Dropzone("#gallery-dropzone", {
                url: "ajax/upload_icon_image.php",
                parallelUploads: 1,
                maxFilesize: 20,
                timeout: 120000,
                dictDefaultMessage: "<?php echo _("Drop files or click here to upload"); ?>",
                dictFallbackMessage: "<?php echo _("Your browser does not support drag'n'drop file uploads."); ?>",
                dictFallbackText: "<?php echo _("Please use the fallback form below to upload your files like in the olden days."); ?>",
                dictFileTooBig: "<?php echo sprintf(_("File is too big (%sMiB). Max filesize: %sMiB."),'{{filesize}}','{{maxFilesize}}'); ?>",
                dictInvalidFileType: "<?php echo _("You can't upload files of this type."); ?>",
                dictResponseError: "<?php echo sprintf(_("Server responded with %s code."),'{{statusCode}}'); ?>",
                dictCancelUpload: "<?php echo _("Cancel upload"); ?>",
                dictCancelUploadConfirmation: "<?php echo _("Are you sure you want to cancel this upload?"); ?>",
                dictRemoveFile: "<?php echo _("Remove file"); ?>",
                dictMaxFilesExceeded: "<?php echo _("You can not upload any more files."); ?>",
                acceptedFiles: 'image/*,application/json'
            });
            window.gallery_dropzone.on("addedfile", function(file) {
                $('#list_images').addClass('disabled');
            });
            window.gallery_dropzone.on("success", function(file,rsp) {
                if(rsp !== "" && !rsp.startsWith("ERROR")) {
                    add_image_to_icon_m(id_virtualtour, rsp, 'icons');
                }
            });
            window.gallery_dropzone.on("queuecomplete", function() {
                $('#list_images').removeClass('disabled');
                window.gallery_dropzone.removeAllFiles();
            });
        }
        $('#modal_library_icons').modal('show');
    }

    function change_form_title() {
        var form_title = $('#form_title').val();
        form_title = DOMPurify.sanitize(form_title);
        $('#mform_name').html(form_title);
        $('.form_control').attr('data-original-title',custom_title).tooltip();
    }

    function change_custom_title() {
        var custom_title = $('#custom_title').val();
        custom_title = DOMPurify.sanitize(custom_title);
        $('#custom_name').html(custom_title);
        $('.custom_control').attr('data-original-title',custom_title).tooltip();
    }

    function change_custom2_title() {
        var custom_title = $('#custom2_title').val();
        custom_title = DOMPurify.sanitize(custom_title);
        $('#custom2_name').html(custom_title);
        $('.custom2_control').attr('data-original-title',custom_title).tooltip();
    }

    function change_custom3_title() {
        var custom_title = $('#custom3_title').val();
        custom_title = DOMPurify.sanitize(custom_title);
        $('#custom3_name').html(custom_title);
        $('.custom3_control').attr('data-original-title',custom_title).tooltip();
    }

    function change_custom4_title() {
        var custom_title = $('#custom4_title').val();
        custom_title = DOMPurify.sanitize(custom_title);
        $('#custom4_name').html(custom_title);
        $('.custom4_control').attr('data-original-title',custom_title).tooltip();
    }

    function change_custom5_title() {
        var custom_title = $('#custom5_title').val();
        custom_title = DOMPurify.sanitize(custom_title);
        $('#custom5_name').html(custom_title);
        $('.custom5_control').attr('data-original-title',custom_title).tooltip();
    }

    function change_location_title() {
        var custom_title = $('#location_title').val();
        custom_title = DOMPurify.sanitize(custom_title);
        $('#location_name').html(custom_title);
        $('.location_control').attr('data-original-title',custom_title).tooltip();
    }

    function change_media_title() {
        var custom_title = $('#media_title').val();
        custom_title = DOMPurify.sanitize(custom_title);
        $('#media_name').html(custom_title);
        $('.media_control').attr('data-original-title',custom_title).tooltip();
    }

    function hotspot_nadir(hotSpotDiv, args) {
        var image = args[0];
        var round = args[1];
        if(window.s3_enabled==1) {
            hotSpotDiv.style = "background-image:url("+window.s3_url+"viewer/content/"+image+"?s3=1);background-size:cover !important;";
        } else {
            hotSpotDiv.style = "background-image:url(../viewer/content/"+image+");background-size:cover !important;";
        }
        hotSpotDiv.style.width = nadir_size;
        hotSpotDiv.style.height = nadir_size;
        hotSpotDiv.setAttribute('data-ui-target','ui_edit_nadir');
        hotSpotDiv.style.pointerEvents = 'initial';
        hotSpotDiv.style.cursor = 'pointer';
        if(round==1) {
            hotSpotDiv.style.aspectRatio = 1;
            hotSpotDiv.style.borderRadius = '50%';
        }
    }

    function redraw_nadir() {
        nadir_size = $('#nadir_size').val()+'px';
        window.viewer.removeHotSpot("nadir_hs");
        window.viewer.addHotSpot({
            "id": "nadir_hs",
            "type": "nadir",
            "view_type": 0,
            "object": "nadir",
            "transform3d": false,
            "pitch": -90,
            "yaw": 0,
            "rotateX": 0,
            "rotateZ": 0,
            "scale": true,
            "cssClass": "nadir-hotspot",
            "createTooltipFunc": hotspot_nadir,
            "createTooltipArgs": [nadir_logo,nadir_round]
        });
    }

    function load_viewer_ui(room_type,panorama_image,panorama_video,yaw,pitch,h_pitch,h_roll,haov,vaov,min_yaw,max_yaw) {
        if(allow_pitch==1) {
            min_pitch = (parseInt($('#min_pitch').val())*-1)-34;
            max_pitch = parseInt($('#max_pitch').val())+34;
        } else {
            min_pitch = 0;
            max_pitch = 0;
            pitch = 0;
        }
        if(allow_hfov==0) {
            min_hfov = hfov;
            max_hfov = hfov;
        }
        if(map_north=='') map_north=0;
        try {
            viewer.destroy();
        } catch (e) {}
        try {
            window.viewer_video.pnlmViewer.destroy();
            window.viewer_video.dispose();
            window.viewer_video = null;
            $('#panorama_video').empty();
        } catch (e) {}

        var hotSpots = [];
        if(nadir_logo!='') {
            hotSpots.push({
                "id": "nadir_hs",
                "type": "nadir",
                "view_type": 0,
                "object": "nadir",
                "transform3d": false,
                "pitch": -90,
                "yaw": 0,
                "rotateX": 0,
                "rotateZ": 0,
                "scale": true,
                "cssClass": "nadir-hotspot",
                "createTooltipFunc": hotspot_nadir,
                "createTooltipArgs": [nadir_logo,nadir_round]
            });
        }

        switch(room_type) {
            case 'video':
                $('#panorama').hide();
                $('#panorama_video').show();
                $('#panorama_video').append('<video playsinline webkit-playsinline id="video_viewer" class="video-js vjs-default-skin vjs-big-play-centered" style="width: 100%;height: 100%;" muted preload="none" crossorigin="anonymous"><source src="'+panorama_video+'" type="video/mp4"/></video>');
                viewer_video = videojs('video_viewer', {
                    loop: true,
                    autoload: true,
                    muted: true,
                    plugins: {
                        pannellum: {
                            "id_room": 1,
                            "autoLoad": true,
                            "showFullscreenCtrl": false,
                            "showControls": false,
                            "horizonPitch": parseInt(h_pitch),
                            "horizonRoll": parseInt(h_roll),
                            "hfov": parseInt(hfov),
                            "minHfov": parseInt(min_hfov),
                            "maxHfov": parseInt(max_hfov),
                            "yaw": parseInt(yaw),
                            "pitch": parseInt(pitch),
                            "minPitch": min_pitch,
                            "maxPitch" : max_pitch,
                            "minYaw": parseInt(min_yaw),
                            "maxYaw" : parseInt(max_yaw),
                            "haov": parseInt(haov),
                            "vaov": parseInt(vaov),
                            "compass": true,
                            "northOffset": parseInt(northOffset),
                            "map_north": parseInt(map_north),
                            "friction": 1,
                            "strings": {
                                "loadingLabel": "<?php echo _("Loading"); ?>...",
                            },
                            "hotSpots": hotSpots,
                        }
                    }
                });
                viewer_video.load();
                viewer_video.on('ready', function() {
                    viewer_video.play();
                    viewer_video.pnlmViewer.on('load',function () {
                        viewer_initialized = true;
                        adjust_ratio_hfov('panorama',viewer_video.pnlmViewer,hfov,min_hfov,max_hfov);
                    });
                });
                break;
            case 'hls':
            case 'image':
            case 'lottie':
                if(multires) {
                    viewer = pannellum.viewer('panorama', {
                        "id_room": 1,
                        "type": "multires",
                        "multiRes": multires_config,
                        "autoLoad": true,
                        "showFullscreenCtrl": false,
                        "showControls": false,
                        "multiResMinHfov": true,
                        "horizonPitch": parseInt(h_pitch),
                        "horizonRoll": parseInt(h_roll),
                        "hfov": parseInt(hfov),
                        "minHfov": parseInt(min_hfov),
                        "maxHfov": parseInt(max_hfov),
                        "yaw": parseInt(yaw),
                        "pitch": parseInt(pitch),
                        "minPitch": min_pitch,
                        "maxPitch" : max_pitch,
                        "minYaw": parseInt(min_yaw),
                        "maxYaw" : parseInt(max_yaw),
                        "haov": parseInt(haov),
                        "vaov": parseInt(vaov),
                        "compass": true,
                        "northOffset": parseInt(northOffset),
                        "map_north": parseInt(map_north),
                        "friction": 1,
                        "strings": {
                            "loadingLabel": "<?php echo _("Loading"); ?>...",
                        },
                        "hotSpots": hotSpots,
                    });
                    setTimeout(function () {
                        viewer_initialized = true;
                    },100);
                } else {
                    viewer = pannellum.viewer('panorama', {
                        "id_room": 1,
                        "type": "equirectangular",
                        "panorama": panorama_image,
                        "autoLoad": true,
                        "showFullscreenCtrl": false,
                        "showControls": false,
                        "multiResMinHfov": true,
                        "horizonPitch": parseInt(h_pitch),
                        "horizonRoll": parseInt(h_roll),
                        "hfov": parseInt(hfov),
                        "minHfov": parseInt(min_hfov),
                        "maxHfov": parseInt(max_hfov),
                        "yaw": parseInt(yaw),
                        "pitch": parseInt(pitch),
                        "minPitch": min_pitch,
                        "maxPitch" : max_pitch,
                        "minYaw": parseInt(min_yaw),
                        "maxYaw" : parseInt(max_yaw),
                        "haov": parseInt(haov),
                        "vaov": parseInt(vaov),
                        "compass": true,
                        "northOffset": parseInt(northOffset),
                        "map_north": parseInt(map_north),
                        "friction": 1,
                        "strings": {
                            "loadingLabel": "<?php echo _("Loading"); ?>...",
                        },
                        "hotSpots": hotSpots,
                    });
                    viewer.on('load', function () {
                        viewer_initialized = true;
                    });
                }
                break;
        }
    }

    function parse_room_menu_list(items, parentId = 'root', indent = 0,id_room_1 = 0) {
        for (var i = 0; i < items.length; i++) {
            var item = items[i];
            var id = item.id;
            var name = item.name;
            var type = item.type;
            var hide = parseInt(item.hide || 0);
            var margin = 15 * indent + "px";
            if (type === "room" && hide === 0) {
                var icon = 'far fa-circle';
                if (parseInt(id) === parseInt(id_room_1)) {
                    icon = 'fas fa-dot-circle';
                }
                $('.list_alt_menu .dropdown').append(
                    `<p data-ui-target="ui_edit_list_alt" style="margin-left: ${margin};" data-cat="${parentId}" class="children list_alt_${id} cat_parent_${parentId}">
                        <i data-ui-target="ui_edit_list_alt" class="${icon}"></i>&nbsp;&nbsp;&nbsp;${name}
                    </p>`
                );
            }
            if (type === "category") {
                $('.list_alt_menu .dropdown').append(
                    `<p data-ui-target="ui_edit_list_alt" style="margin-left: ${margin};" data-cat="${parentId}" class="cat cat_${id} cat_parent_${parentId}">
                        <i data-ui-target="ui_edit_list_alt" class="fas fa-chevron-down"></i>&nbsp;&nbsp;&nbsp;${name}
                    </p>`
                );
                if (item.childrens && item.childrens.length > 0) {
                    parse_room_menu_list(item.childrens, id, indent + 1, id_room_1);
                }
            }
        }
    }

    function removeEmptyCategories() {
        const container = document.querySelector('.list_alt_menu .dropdown');
        if (!container) return;
        const roomElements = container.querySelectorAll('.children');
        const usedCategories = new Set();
        roomElements.forEach(room => {
            const parentClass = [...room.classList].find(cls => cls.startsWith('cat_parent_'));
            if (parentClass) {
                const catId = parentClass.replace('cat_parent_', '');
                usedCategories.add(catId);
            }
        });
        let added = true;
        while (added) {
            added = false;
            container.querySelectorAll('p.cat').forEach(catEl => {
                const catIdMatch = [...catEl.classList].find(cls => cls.startsWith('cat_') && cls !== 'cat');
                const parentMatch = [...catEl.classList].find(cls => cls.startsWith('cat_parent_'));
                if (catIdMatch && parentMatch) {
                    const catId = catIdMatch.replace('cat_', '');
                    const parentId = parentMatch.replace('cat_parent_', '');
                    if (usedCategories.has(catId) && !usedCategories.has(parentId)) {
                        usedCategories.add(parentId);
                        added = true;
                    }
                }
            });
        }
        container.querySelectorAll('p.cat').forEach(catEl => {
            const catIdMatch = [...catEl.classList].find(cls => cls.startsWith('cat_') && cls !== 'cat');
            if (catIdMatch) {
                const catId = catIdMatch.replace('cat_', '');
                if (!usedCategories.has(catId)) {
                    catEl.remove();
                }
            }
        });
    }

    function fix_colors_menu() {
        var first = null;
        var last = null;
        $('.menu_controls').find("p:not(.ui_disabled):not(.ui_hidden)").sort(function(a, b) {
            return parseInt(a.style.order) > parseInt(b.style.order) ? 1 : -1;
        }).each(function () {
            if(first==null) {
                first=$(this);
            }
            last=$(this);
        });
        if(first!=null) {
            var bg_first = first.css('background-color');
            $('.menu_controls .arrow').css('border-bottom','10px solid '+bg_first);
            $('#menu_controls_mt').css('background-color',bg_first);
        }
        if(last!=null) {
            var bg_last = last.css('background-color');
            $('#menu_controls_md').css('background-color',bg_last);
        }
    }

    function bulk_set_editor_colors(element,hover=false) {
        var retVal = confirm(window.backend_labels.bulk_editor_colors);
        if( retVal == true ) {
            var position = $('#position_' + element + ' option:selected').attr('id');
            if(hover) {
                var color = $('#' + element + '_color_hover').val();
                var background = $('#' + element + '_background_hover').val();
            } else {
                var color = $('#' + element + '_color').val();
                var background = $('#' + element + '_background').val();
            }
            var container = null;
            var container2 = null;
            switch (position) {
                case 'button_left':
                    container = $('#controls_bottom_left .controls_btn');
                    break;
                case 'button_center':
                    container = $('#controls_bottom_center .controls_btn');
                    break;
                case 'button_right':
                    container = $('#controls_bottom_right .controls_btn');
                    break;
                case 'menu':
                    container = $('#ms_controls .ms_control');
                    container2 = $('.menu_controls .dropdown p');
                    break;
                default:
                    console.warn('Unknown position:', position);
                    return;
            }
            function applyColorLogic(containerSet,hover) {
                containerSet.each(function () {
                    var target_element = $(this).attr('data-id-color');
                    var target_position = $('#position_' + target_element + ' option:selected').attr('id');
                    if (target_position == position) {
                        if(hover) {
                            $('#' + target_element + '_color_hover').val(color).spectrum("set", color);
                            $('#' + target_element + '_background_hover').val(background).spectrum("set", background);
                        } else {
                            $('#' + target_element + '_color').val(color).spectrum("set", color);
                            $('#' + target_element + '_background').val(background).spectrum("set", background);
                            var target = $('#' + target_element + '_color').attr('data-target');
                            $('.' + target).css({
                                'color': color,
                                'background-color': background
                            });
                        }
                    }
                });
            }
            if (container && container.length) {
                applyColorLogic(container,hover);
            }
            if (container2 && container2.length) {
                applyColorLogic(container2,hover);
            }
        }
    }

    function getFileExtension(url) {
        const match = url.match(/\.([^\.]+)$/);
        return match ? match[1] : "";
    }

    $('body').on('submit','#frm_m',function(e){
        e.preventDefault();
        $('#error_m').hide();
        var url = $(this).attr('action');
        var frm = $(this);
        var data = new FormData();
        if(frm.find('#txtFile_m[type="file"]').length === 1 ){
            data.append('file', frm.find( '#txtFile_m' )[0].files[0]);
        }
        var ajax  = new XMLHttpRequest();
        ajax.upload.addEventListener('progress',function(evt){
            var percentage = (evt.loaded/evt.total)*100;
            update_progressbar_m(Math.round(percentage));
        },false);
        ajax.addEventListener('load',function(evt){
            if(evt.target.responseText.toLowerCase().indexOf('error')>=0){
                show_error_m(evt.target.responseText);
            } else {
                if(evt.target.responseText!='') {
                    window.vt_meed_save = true;
                    if($('#div_exist_media').css('display')=='block') {
                        window.media_file = evt.target.responseText;
                        var ext = getFileExtension(window.media_file);
                        switch(ext) {
                            case 'mp4':
                            case 'webm':
                                $('#div_image_media img').hide();
                                $('#div_image_media video').show();
                                if(window.s3_enabled==1) {
                                    $('#div_image_media video').attr('src',window.s3_url+'viewer/content/'+window.media_file);
                                } else {
                                    $('#div_image_media video').attr('src','../viewer/content/'+window.media_file);
                                }
                                break;
                            default:
                                $('#div_image_media img').show();
                                $('#div_image_media video').hide();
                                if(window.s3_enabled==1) {
                                    $('#div_image_media img').attr('src',window.s3_url+'viewer/content/'+window.media_file);
                                } else {
                                    $('#div_image_media img').attr('src','../viewer/content/'+window.media_file);
                                }
                                break;
                        }
                        $('#div_delete_media').show();
                        $('#div_image_media').show();
                        $('#div_upload_media').hide();
                        $('#div_exist_media').hide();
                    } else {
                        $('.input_lang[data-target-id="div_exist_media"]').each(function() {
                            if($(this).css('display')=='block') {
                                var lang = $(this).attr('data-lang');
                                window.media_file_langs[lang] = evt.target.responseText;
                                var ext = getFileExtension(window.media_file_langs[lang]);
                                switch(ext) {
                                    case 'mp4':
                                    case 'webm':
                                        $('#div_image_media_'+lang+' img').hide();
                                        $('#div_image_media_'+lang+' video').show();
                                        if(window.s3_enabled==1) {
                                            $('#div_image_media_'+lang+' video').attr('src',window.s3_url+'viewer/content/'+window.media_file_langs[lang]);
                                        } else {
                                            $('#div_image_media_'+lang+' video').attr('src','../viewer/content/'+window.media_file_langs[lang]);
                                        }
                                        break;
                                    default:
                                        $('#div_image_media_'+lang+' img').show();
                                        $('#div_image_media_'+lang+' video').hide();
                                        if(window.s3_enabled==1) {
                                            $('#div_image_media_'+lang+' img').attr('src',window.s3_url+'viewer/content/'+window.media_file_langs[lang]);
                                        } else {
                                            $('#div_image_media_'+lang+' img').attr('src','../viewer/content/'+window.media_file_langs[lang]);
                                        }
                                        break;
                                }
                                $('#div_delete_media').show();
                                $('#div_image_media_'+lang).show();
                                $('#div_upload_media').hide();
                                $('#div_exist_media_'+lang).hide();
                            }
                        });
                    }
                }
            }
            update_progressbar_m(0);
            frm[0].reset();
        },false);
        ajax.addEventListener('error',function(evt){
            show_error_m('upload failed');
            update_progressbar_m(0);
        },false);
        ajax.addEventListener('abort',function(evt){
            show_error_m('upload aborted');
            update_progressbar_m(0);
        },false);
        ajax.open('POST',url);
        ajax.send(data);
        return false;
    });

    function update_progressbar_m(value){
        $('#progressBar_m').css('width',value+'%').html(value+'%');
        if(value==0){
            $('.progress_m').hide();
        }else{
            $('.progress_m').show();
        }
    }

    function show_error_m(error){
        $('.progress_m').hide();
        $('#error_m').show();
        $('#error_m').html(error);
    }

    $(document).on('shown.bs.modal', '.modal', function () {
        if(window.is_fullscreen) {
            $('.modal_fs_container .modal-backdrop').show();
        }
    });

    $(document).on('hide.bs.modal', '.modal', function () {
        $('.modal_fs_container .modal-backdrop').hide();
    });

    if (document.addEventListener) {
        document.addEventListener('fullscreenchange', exitHandler, false);
        document.addEventListener('mozfullscreenchange', exitHandler, false);
        document.addEventListener('MSFullscreenChange', exitHandler, false);
        document.addEventListener('webkitfullscreenchange', exitHandler, false);
    }

    function exitHandler() {
        if (!document.webkitIsFullScreen && !document.mozFullScreen && !document.msFullscreenElement) {
            window.is_fullscreen = false;
            $('.modal_fs_container .modal-backdrop').hide();
            $(window).trigger('resize');
        }
    }

    let isMoved = false;
    let wasMovedUp = false;

    function isOverlapping(el1, el2, tolerance = 5) {
        const rect1 = el1.getBoundingClientRect();
        const rect2 = el2.getBoundingClientRect();
        return !(
            rect1.right < rect2.left - tolerance ||
            rect1.left > rect2.right + tolerance
        );
    }

    function adjustCenterDiv() {
        const centerDiv = document.getElementById('controls_bottom_center');
        const leftDiv = document.getElementById('controls_bottom_left');
        const rightDiv = document.getElementById('controls_bottom_right');
        const overlapsLeft = isOverlapping(centerDiv, leftDiv);
        const overlapsRight = isOverlapping(centerDiv, rightDiv);
        const shouldMove = overlapsLeft || overlapsRight;
        if (shouldMove && !isMoved) {
            centerDiv.classList.add('moved');
            isMoved = true;
            wasMovedUp = true;
        }
        else if (!shouldMove && isMoved && wasMovedUp) {
            centerDiv.classList.remove('moved');
            isMoved = false;
        }
    }

    let resizeTimeout;
    window.addEventListener('resize', () => {
        clearTimeout(resizeTimeout);
        resizeTimeout = setTimeout(adjustCenterDiv, 100);
    });
    
    window.addEventListener('load', adjustCenterDiv);

    window.open_modal_edit_contents = function(page) {
        $('#modal_edit_contents .modal-body').empty();
        switch(page) {
            case 'vt_content':
                window.open('index.php?p=edit_virtual_tour&id='+window.id_virtualtour+'&tab=content');
                break;
            case 'dollhouse':
            case 'measurements':
            case 'presentation':
            case 'maps':
                window.open('index.php?p='+page+'&id_vt='+window.id_virtualtour);
                break;
            default:
                $('#modal_edit_contents .modal-body').load(page+'.php');
                $('#modal_edit_contents').modal('show');
                break;
        }
    }
</script>

<?php
function print_ui_position($element,$disabled) {
    global $ui_style;
    switch($element) {
        case 'list':
        case 'arrows':
            $html = '<div class="form-group">
                <label for="position_'.$element.'">'._("Icon Position").'</label>&nbsp;&nbsp;&nbsp;&nbsp;<i style="cursor:pointer;" onclick="change_ui_order(\'prev\',\'controls_arrows\',\'position_'.$element.'\');" class="fas fa-caret-square-left"></i>&nbsp;&nbsp;<i style="cursor:pointer;" onclick="change_ui_order(\'next\',\'controls_arrows\',\'position_'.$element.'\');" class="fas fa-caret-square-right"></i><br>
                <select '.$disabled.' onchange="change_ui_position(\'position_'.$element.'\');" data-target="'.$element.'_control" id="position_'.$element.'" class="form-control form-control-sm position_select">
                    <option '.(($ui_style['controls'][$element]['type']=='button' && $ui_style['controls'][$element]['position']=='left') ? 'selected' : '').' id="button_left">'._("Icon Button - Left").'</option>
                    <option '.(($ui_style['controls'][$element]['type']=='button' && $ui_style['controls'][$element]['position']=='center') ? 'selected' : '').' id="button_center">'._("Icon Button - Center").'</option>
                    <option '.(($ui_style['controls'][$element]['type']=='button' && $ui_style['controls'][$element]['position']=='right') ? 'selected' : '').' id="button_right">'._("Icon Button - Right").'</option>
                    <option '.(($ui_style['controls'][$element]['type']=='default') ? 'selected' : '').' id="default">'._("Default").'</option>
                </select>
            </div>';
            break;
        case 'compass':
            $html = '<div class="form-group">
                <label for="position_'.$element.'">'._("Icon Position").'</label>&nbsp;&nbsp;&nbsp;&nbsp;<i style="cursor:pointer;" onclick="change_ui_order(\'prev\',\''.$element.'_control\',\'position_'.$element.'\');" class="fas fa-caret-square-left"></i>&nbsp;&nbsp;<i style="cursor:pointer;" onclick="change_ui_order(\'next\',\''.$element.'_control\',\'position_'.$element.'\');" class="fas fa-caret-square-right"></i><br>
                <select '.$disabled.' onchange="change_ui_position(\'position_'.$element.'\');" data-target="'.$element.'_control" id="position_'.$element.'" class="form-control form-control-sm position_select">
                    <option '.(($ui_style['controls'][$element]['type']=='button' && $ui_style['controls'][$element]['position']=='left') ? 'selected' : '').' id="button_left">'._("Icon Button - Left").'</option>
                    <option '.(($ui_style['controls'][$element]['type']=='button' && $ui_style['controls'][$element]['position']=='center') ? 'selected' : '').' id="button_center">'._("Icon Button - Center").'</option>
                    <option '.(($ui_style['controls'][$element]['type']=='button' && $ui_style['controls'][$element]['position']=='right') ? 'selected' : '').' id="button_right">'._("Icon Button - Right").'</option>
                </select>
            </div>';
            break;
        case 'fullscreen_alt':
        case 'floorplan_alt':
        case 'map_alt':
            $html = '<div class="form-group">
                <label for="position_'.$element.'">'._("Icon Position").'</label>&nbsp;&nbsp;&nbsp;&nbsp;<i style="cursor:pointer;" onclick="change_ui_order(\'prev\',\''.$element.'_control\',\'position_'.$element.'\');" class="fas fa-caret-square-left"></i>&nbsp;&nbsp;<i style="cursor:pointer;" onclick="change_ui_order(\'next\',\''.$element.'_control\',\'position_'.$element.'\');" class="fas fa-caret-square-right"></i><br>
                <select '.$disabled.' onchange="change_ui_position(\'position_'.$element.'\');" data-target="'.$element.'_control" id="position_'.$element.'" class="form-control form-control-sm position_select">
                    <option '.(($ui_style['controls'][$element]['type']=='button' && $ui_style['controls'][$element]['position']=='left') ? 'selected' : '').' id="button_left">'._("Icon Button - Left").'</option>
                    <option '.(($ui_style['controls'][$element]['type']=='button' && $ui_style['controls'][$element]['position']=='center') ? 'selected' : '').' id="button_center">'._("Icon Button - Center").'</option>
                    <option '.(($ui_style['controls'][$element]['type']=='button' && $ui_style['controls'][$element]['position']=='right') ? 'selected' : '').' id="button_right">'._("Icon Button - Right").'</option>
                    <option '.(($ui_style['controls'][$element]['type']=='menulist') ? 'selected' : '').' id="menulist">'._("Menu Item / Sidebar").'</option>
                    <option '.(($ui_style['controls'][$element]['type']=='menu') ? 'selected' : '').' id="menu">'._("Icon - Top Right").'</option>
                </select>
            </div>';
            break;
        case 'language_alt':
            $html = '<div class="form-group">
                <label for="position_'.$element.'">'._("Icon Position").'</label>&nbsp;&nbsp;&nbsp;&nbsp;<i style="cursor:pointer;" onclick="change_ui_order(\'prev\',\''.$element.'_control\',\'position_'.$element.'\');" class="fas fa-caret-square-left"></i>&nbsp;&nbsp;<i style="cursor:pointer;" onclick="change_ui_order(\'next\',\''.$element.'_control\',\'position_'.$element.'\');" class="fas fa-caret-square-right"></i><br>
                <select '.$disabled.' onchange="change_ui_position(\'position_'.$element.'\');" data-target="'.$element.'_control" id="position_'.$element.'" class="form-control form-control-sm position_select">
                    <option '.(($ui_style['controls'][$element]['type']=='menulist') ? 'selected' : '').' id="menulist">'._("Sidebar").'</option>
                    <option '.(($ui_style['controls'][$element]['type']=='menu') ? 'selected' : '').' id="menu">'._("Icon - Top Right").'</option>
                </select>
            </div>';
            break;
        case 'song_alt':
            $html = '<div class="form-group">
                <label for="position_'.$element.'">'._("Icon Position").'</label>&nbsp;&nbsp;&nbsp;&nbsp;<i style="cursor:pointer;" onclick="change_ui_order(\'prev\',\''.$element.'_control\',\'position_'.$element.'\');" class="fas fa-caret-square-left"></i>&nbsp;&nbsp;<i style="cursor:pointer;" onclick="change_ui_order(\'next\',\''.$element.'_control\',\'position_'.$element.'\');" class="fas fa-caret-square-right"></i><br>
                <select '.$disabled.' onchange="change_ui_position(\'position_'.$element.'\');" data-target="'.$element.'_control" id="position_'.$element.'" class="form-control form-control-sm position_select">
                    <option '.(($ui_style['controls'][$element]['type']=='button' && $ui_style['controls'][$element]['position']=='left') ? 'selected' : '').' id="button_left">'._("Icon Button - Left").'</option>
                    <option '.(($ui_style['controls'][$element]['type']=='button' && $ui_style['controls'][$element]['position']=='center') ? 'selected' : '').' id="button_center">'._("Icon Button - Center").'</option>
                    <option '.(($ui_style['controls'][$element]['type']=='button' && $ui_style['controls'][$element]['position']=='right') ? 'selected' : '').' id="button_right">'._("Icon Button - Right").'</option>
                    <option '.(($ui_style['controls'][$element]['type']=='menulist') ? 'selected' : '').' id="menulist">'._("Menu Item / Sidebar").'</option>
                    <option '.(($ui_style['controls'][$element]['type']=='menu') ? 'selected' : '').' id="menu">'._("Icon - Top Left").'</option>
                </select>
            </div>';
            break;
        default:
            $html = '<div class="form-group">
                <label for="position_'.$element.'">'._("Icon Position").'</label>&nbsp;&nbsp;&nbsp;&nbsp;<i style="cursor:pointer;" onclick="change_ui_order(\'prev\',\''.$element.'_control\',\'position_'.$element.'\');" class="fas fa-caret-square-left"></i>&nbsp;&nbsp;<i style="cursor:pointer;" onclick="change_ui_order(\'next\',\''.$element.'_control\',\'position_'.$element.'\');" class="fas fa-caret-square-right"></i><br>
                <select '.$disabled.' onchange="change_ui_position(\'position_'.$element.'\');" data-target="'.$element.'_control" id="position_'.$element.'" class="form-control form-control-sm position_select">
                    <option '.(($ui_style['controls'][$element]['type']=='button' && $ui_style['controls'][$element]['position']=='left') ? 'selected' : '').' id="button_left">'._("Icon Button - Left").'</option>
                    <option '.(($ui_style['controls'][$element]['type']=='button' && $ui_style['controls'][$element]['position']=='center') ? 'selected' : '').' id="button_center">'._("Icon Button - Center").'</option>
                    <option '.(($ui_style['controls'][$element]['type']=='button' && $ui_style['controls'][$element]['position']=='right') ? 'selected' : '').' id="button_right">'._("Icon Button - Right").'</option>
                    <option '.(($ui_style['controls'][$element]['type']=='menu') ? 'selected' : '').' id="menu">'._("Menu Item / Sidebar").'</option>
                </select>
            </div>';
            break;
    }
    return $html;
}

function print_ui_main_color($element,$color,$background,$apply_to_all=false) {
    global $ui_style;
    switch($element) {
        case 'list':
            if($ui_style['controls'][$element]['type']=='default') {
                $background = false;
            }
            $html = '<div class="form-group">
                <label>'._("Main Color").'</label><br>
                <input id="'.$element.'_color" type="text" data-target="list_control" data-target-type="color" class="form-control form-control-sm color_picker '.((!$color) ? 'd-none' : '').'" value="'.get_string_between($ui_style['controls']['list']['style'],';color:',';').'" />
                <input id="'.$element.'_background" type="text" data-target="list_control" data-target-type="background" class="form-control form-control-sm color_picker '.((!$background) ? 'd-none' : '').'" value="'.get_string_between($ui_style['controls']['list']['style'],'background-color:',';').'" />
            </div>';
            break;
        case 'arrows':
            if($ui_style['controls'][$element]['type']=='default') {
                $background = false;
            }
            $html = '<div class="form-group">
                <label>'._("Main Color").'</label><br>
                <input id="'.$element.'_color" type="text" data-target="controls_arrows" data-target-type="color" class="form-control form-control-sm color_picker '.((!$color) ? 'd-none' : '').'" value="'.get_string_between($ui_style['controls']['arrows']['style'],';color:',';').'" />
                <input id="'.$element.'_background" type="text" data-target="controls_arrows" data-target-type="background" class="form-control form-control-sm color_picker '.((!$background) ? 'd-none' : '').'" value="'.get_string_between($ui_style['controls']['arrows']['style'],'background-color:',';').'" />
            </div>';
            break;
        case 'nav_control':
            $html = '<div class="form-group">
                <label>'._("Background Color").'</label><br>
                <input id="nav_background" type="text" data-target="nav_control" data-target-type="background" class="form-control form-control-sm color_picker" value="'.$ui_style['items']['nav_control']['background'].'" />
            </div>';
            break;
        case 'slider':
            $html = '<div class="form-group">
                <label>'._("Background Color").'</label><br>
                <input id="'.$element.'_background" type="text" data-target="slider" data-target-type="background" class="form-control form-control-sm color_picker '.((!$background) ? 'd-none' : '').'" value="'.$ui_style['items']['list']['background'].'" />
            </div>';
            break;
        case 'annotation':
            if($background) {
                $html = '<div class="form-group">
                <label>'._("Background Color").'</label><br>
                <input id="'.$element.'_background" type="text" data-target="annotation" data-target-type="background" class="form-control form-control-sm color_picker" value="'.$ui_style['items']['annotation']['background'].'" />
            </div>';
            }
            if($color) {
                $html = '<div class="form-group">
                <label>'._("Text Color").'</label><br>
                <input id="'.$element.'_color" type="text" data-target="annotation" data-target-type="color" class="form-control form-control-sm color_picker" value="'.$ui_style['items']['annotation']['color'].'" />
            </div>';
            }
            break;
        case 'inline_form':
            if($background) {
                $html = '<div class="form-group">
                <label>'._("Background Color").'</label><br>
                <input id="'.$element.'_background" type="text" data-target="inline_form" data-target-type="background" class="form-control form-control-sm color_picker" value="'.$ui_style['items']['inline_form']['background'].'" />
            </div>';
            }
            if($color) {
                $html = '<div class="form-group">
                <label>'._("Text Color").'</label><br>
                <input id="'.$element.'_color" type="text" data-target="inline_form" data-target-type="color" class="form-control form-control-sm color_picker" value="'.$ui_style['items']['inline_form']['color'].'" />
            </div>';
            }
            break;
        case 'inline_form_button':
            if($background) {
                $html = '<div class="form-group">
                <label>'._("Button - Background").'</label><br>
                <input id="'.$element.'_background" type="text" data-target="inline_form_button" data-target-type="background" class="form-control form-control-sm color_picker" value="'.$ui_style['items']['inline_form']['button_background'].'" />
            </div>';
            }
            if($color) {
                $html = '<div class="form-group">
                <label>'._("Button - Text").'</label><br>
                <input id="'.$element.'_color" type="text" data-target="inline_form_button" data-target-type="color" class="form-control form-control-sm color_picker" value="'.$ui_style['items']['inline_form']['button_color'].'" />
            </div>';
            }
            break;
        case 'inline_form_field':
            if($background) {
                $html = '<div class="form-group">
                <label>'._("Field - Background").'</label><br>
                <input id="'.$element.'_background" type="text" data-target="inline_form_field" data-target-type="background" class="form-control form-control-sm color_picker" value="'.$ui_style['items']['inline_form']['field_background'].'" />
            </div>';
            }
            if($color) {
                $html = '<div class="form-group">
                <label>'._("Field - Text").'</label><br>
                <input id="'.$element.'_color" type="text" data-target="inline_form_field" data-target-type="color" class="form-control form-control-sm color_picker" value="'.$ui_style['items']['inline_form']['field_color'].'" />
            </div>';
            }
            break;
        case 'map_bar':
            if($background) {
                $html = '<div class="form-group">
                <label>'._("Background Color").'</label><br>
                <input id="'.$element.'_background" type="text" data-target="map_bar" data-target-type="background" class="form-control form-control-sm color_picker" value="'.$ui_style['items']['map']['background'].'" />
            </div>';
            }
            if($color) {
                $html = '<div class="form-group">
                <label>'._("Text Color").'</label><br>
                <input id="'.$element.'_color" type="text" data-target="map_bar" data-target-type="color" class="form-control form-control-sm color_picker" value="'.$ui_style['items']['map']['color'].'" />
            </div>';
            }
            break;
        case 'menu_sidebar':
            if($background) {
                $html = '<div class="form-group">
                <label>'._("Background Color").'</label><br>
                <input id="'.$element.'_background" type="text" data-target="menu_sidebar" data-target-type="background" class="form-control form-control-sm color_picker" value="'.$ui_style['sidebar']['background'].'" />
            </div>';
            }
            break;
        case 'title':
            if($background) {
                if(!empty($ui_style['items']['title']['background'])) {
                    $title_bg = str_replace("rgba","rgb",$ui_style['items']['title']['background']).")";
                } else {
                    $title_bg = "";
                }
                $html = '<div class="form-group">
                <label>' . _("Background Color") . '</label><br>
                <input id="title_background" type="text" data-target="header_vt" data-target-type="background" class="form-control form-control-sm color_picker_bg" value="'.$title_bg.'" />
            </div>';
            }
            if($color) {
                $html = '<div class="form-group">
                <label>' . _("Main Color") . '</label><br>
                <input id="title_color" type="text" data-target="header_vt" data-target-type="color" class="form-control form-control-sm color_picker" value="' . $ui_style['items']['title']['color'] . '" />
            </div>';
            }
            break;
        case 'multiple_room_views':
            if($color) {
                $html = '<div class="form-group">
                <label>' . _("Border Color") . '</label><br>
                <input id="multiple_room_views_border_color" type="text" data-target="rooms_alt" data-target-type="color" class="form-control form-control-sm color_picker" value="' . $ui_style['items']['multiple_room_views']['color'] . '" />
            </div>';
            }
            break;
        case 'comments':
            if($color) {
                $html = '<div class="form-group">
                <label>' . _("Main Color") . '</label><br>
                <input id="comments_color" type="text" data-target="comments_vt" data-target-type="color" class="form-control form-control-sm color_picker" value="' . $ui_style['items']['comments']['color'] . '" />
            </div>';
            }
            break;
        case 'list_alt_menu':
            $html = '<div class="form-group">
                <label>'._("Item").' - '._("Main Color").'</label><br>
                <input id="'.$element.'_color" type="text" data-target="'.$element.'_control" data-target-type="color" class="form-control form-control-sm color_picker '.((!$color) ? 'd-none' : '').'" value="'.get_string_between($ui_style['controls']['list_alt_menu']['style'],';color:',';').'" />
                <input id="'.$element.'_background" type="text" data-target="'.$element.'_control" data-target-type="background" class="form-control form-control-sm color_picker '.((!$background) ? 'd-none' : '').'" value="'.get_string_between($ui_style['controls']['list_alt_menu']['style'],'background-color:',';').'" />
            </div>';
            break;
        case 'list_alt_menu_icon':
            $html = '<div class="form-group">
                <label>'._("Item").' - '._("Icon Main Color").'</label><br>
                <input id="'.$element.'_color" type="text" data-target="'.$element.'_control" data-target-type="color" class="form-control form-control-sm color_picker '.((!$color) ? 'd-none' : '').'" value="'.$ui_style['controls']['list_alt_menu']['icon_color'].'" />
            </div>';
            break;
        case "visitors_rt_stats";
            if($background) {
                $html = '<div class="form-group">
                <label>'._("Background Color").'</label><br>
                <input id="'.$element.'_background" type="text" data-target="'.$element.'" data-target-type="background" class="form-control form-control-sm color_picker '.((!$background) ? 'd-none' : '').'" value="'.$ui_style['items'][$element]['background'].'" />
            </div>';
            }
            if($color) {
                $html = '<div class="form-group">
                <label>'._("Main Color").'</label><br>
                <input id="'.$element.'_color" type="text" data-target="'.$element.'" data-target-type="color" class="form-control form-control-sm color_picker '.((!$color) ? 'd-none' : '').'" value="'.$ui_style['items'][$element]['color'].'" />
            </div>';
            }
            break;
        default:
            $html = '<div class="form-group">
                <label>'._("Main Color").'</label><br>
                <input id="'.$element.'_color" type="text" data-target="'.$element.'_control" data-target-type="color" class="form-control form-control-sm color_picker '.((!$color) ? 'd-none' : '').'" value="'.get_string_between($ui_style['controls'][$element]['style'],';color:',';').'" />
                <input id="'.$element.'_background" type="text" data-target="'.$element.'_control" data-target-type="background" class="form-control form-control-sm color_picker '.((!$background) ? 'd-none' : '').'" value="'.get_string_between($ui_style['controls'][$element]['style'],'background-color:',';').'" />
            </div>';
            break;
    }
    if($apply_to_all) {
        $html .= "<span onclick=\"bulk_set_editor_colors('$element',false);\" style='cursor:pointer;' class='badge badge-primary'>"._("apply to all")."</span>";
    }
    return $html;
}

function print_ui_icon_color($element,$target) {
    global $ui_style;
    if($element=='nav_control') {
        $key = 'items';
    } else {
        $key = 'icons';
    }
    $html = '<div class="form-group">
                <label>'._("Main Color").'</label><br>
                <input id="'.$element.'_color" type="text" data-target="'.$target.'" data-target-type="color" class="form-control form-control-sm color_picker" value="'.$ui_style[$key][$element]['color'].'" />
            </div>';
    return $html;
}

function print_ui_icon_color_hover($element,$target) {
    global $ui_style;
    $element_a = $element;
    switch($element) {
        case 'nav_control':
            $key = 'items';
            break;
        case 'map_bar':
            $element_a = "map";
            $key = 'items';
            break;
        default:
            $key = 'icons';
            break;
    }
    $html = '<div class="form-group">
                <label>'._("Hover Color").'</label><br>
                <input id="'.$element.'_color_hover" type="text" data-target="'.$target.'" data-target-type="color_hover" class="form-control form-control-sm color_picker" value="'.$ui_style[$key][$element_a]['color_hover'].'" />
            </div>';
    return $html;
}

function print_ui_hover_color($element,$color,$background,$apply_to_all=false) {
    global $ui_style;
    switch($element) {
        case 'list':
            if($ui_style['controls'][$element]['type']=='default') {
                $background = false;
            }
            $html = '<div class="form-group">
                <label>'._("Hover Color").'</label><br>
                <input id="'.$element.'_color_hover" type="text" data-target="list_control" data-target-type="color_hover" class="form-control form-control-sm color_picker '.((!$color) ? 'd-none' : '').'" value="'.get_string_between($ui_style['controls']['list']['style_hover'],';color:',';').'" />
                <input id="'.$element.'_background_hover" type="text" data-target="list_control" data-target-type="background_hover" class="form-control form-control-sm color_picker '.((!$background) ? 'd-none' : '').'" value="'.get_string_between($ui_style['controls']['list']['style_hover'],'background-color:',';').'" />
            </div>';
            break;
        case 'arrows':
            if($ui_style['controls'][$element]['type']=='default') {
                $background = false;
            }
            $html = '<div class="form-group">
                <label>'._("Hover Color").'</label><br>
                <input id="'.$element.'_color_hover" type="text" data-target="controls_arrows" data-target-type="color_hover" class="form-control form-control-sm color_picker '.((!$color) ? 'd-none' : '').'" value="'.get_string_between($ui_style['controls']['arrows']['style_hover'],';color:',';').'" />
                <input id="'.$element.'_background_hover" type="text" data-target="controls_arrows" data-target-type="background_hover" class="form-control form-control-sm color_picker '.((!$background) ? 'd-none' : '').'" value="'.get_string_between($ui_style['controls']['arrows']['style_hover'],'background-color:',';').'" />
            </div>';
            break;
        case 'list_alt_menu_icon':
            $html = '<div class="form-group">
                <label>'._("Item").' - '._("Icon Hover Color").'</label><br>
                <input id="'.$element.'_color_hover" type="text" data-target="'.$element.'_control" data-target-type="color_hover" class="form-control form-control-sm color_picker '.((!$color) ? 'd-none' : '').'" value="'.$ui_style['controls']['list_alt_menu']['icon_color_hover'].'" />
            </div>';
            break;
        case 'list_alt_menu':
            $html = '<div class="form-group">
                <label>'._("Item").' - '._("Hover Color").'</label><br>
                <input id="'.$element.'_color_hover" type="text" data-target="'.$element.'_control" data-target-type="color_hover" class="form-control form-control-sm color_picker '.((!$color) ? 'd-none' : '').'" value="'.get_string_between($ui_style['controls'][$element]['style_hover'],';color:',';').'" />
                <input id="'.$element.'_background_hover" type="text" data-target="'.$element.'_control" data-target-type="background_hover" class="form-control form-control-sm color_picker '.((!$background) ? 'd-none' : '').'" value="'.get_string_between($ui_style['controls'][$element]['style_hover'],'background-color:',';').'" />
            </div>';
            break;
        default:
            $html = '<div class="form-group">
                <label>'._("Hover Color").'</label><br>
                <input id="'.$element.'_color_hover" type="text" data-target="'.$element.'_control" data-target-type="color_hover" class="form-control form-control-sm color_picker '.((!$color) ? 'd-none' : '').'" value="'.get_string_between($ui_style['controls'][$element]['style_hover'],';color:',';').'" />
                <input id="'.$element.'_background_hover" type="text" data-target="'.$element.'_control" data-target-type="background_hover" class="form-control form-control-sm color_picker '.((!$background) ? 'd-none' : '').'" value="'.get_string_between($ui_style['controls'][$element]['style_hover'],'background-color:',';').'" />
            </div>';
            break;
    }
    if($apply_to_all) {
        $html .= "<span onclick=\"bulk_set_editor_colors('$element',true);\" style='cursor:pointer;' class='badge badge-primary'>"._("apply to all")."</span>";
    }
    return $html;
}

function print_ui_icon($element) {
    global $ui_style,$array_library_icons,$array_public_library_icons,$s3_enabled,$s3_url;
    $image_library_icon = "";
    if(!empty($ui_style['controls'][$element]['icon_library']) && $ui_style['controls'][$element]['icon_library']!=0) {
        if(array_key_exists($ui_style['controls'][$element]['icon_library'],$array_library_icons)) {
            if($s3_enabled) {
                if(array_key_exists($ui_style['controls'][$element]['icon_library'],$array_public_library_icons)) {
                    $image_library_icon = "../viewer/icons/".$array_library_icons[$ui_style['controls'][$element]['icon_library']];
                } else {
                    $image_library_icon = $s3_url.'viewer/icons/'.$array_library_icons[$ui_style['controls'][$element]['icon_library']];
                }
            } else {
                $image_library_icon = "../viewer/icons/".$array_library_icons[$ui_style['controls'][$element]['icon_library']];
            }
        }
    }
    $html = '<div class="form-group">
                <div class="'.(($ui_style['controls'][$element]['icon_library'] == 0 || empty($ui_style['controls'][$element]['icon_library'])) ? '' : 'disabled').'">
                    <button data-target="'.$element.'" class="btn btn-sm btn-primary icon_picker" type="button" id="GetIconPicker_'.$element.'" data-iconpicker-input="input#'.$element.'_icon" data-iconpicker-preview="i#'.$element.'_icon_preview">'._("Select Icon").'</button>
                    <input class="icon_picker_value" readonly type="hidden" id="'.$element.'_icon" name="Icon" value="'.$ui_style['controls'][$element]['icon'].'" required="" placeholder="" autocomplete="off" spellcheck="false">
                    <div style="vertical-align: middle;" class="icon-preview d-inline-block ml-1" data-toggle="tooltip" title="">
                        <i style="font-size: 24px;" id="'.$element.'_icon_preview" class="'.$ui_style['controls'][$element]['icon'].'"></i>
                    </div>
                </div>
            </div>';
    $html .= '<div class="form-group">
                <button onclick="remove_library_icon(\''.$element.'\')" id="btn_remove_library_icon_'.$element.'" class="btn btn-sm btn-danger '.(($ui_style['controls'][$element]['icon_library'] == 0 || empty($ui_style['controls'][$element]['icon_library'])) ? 'disabled' : '').'"><i class="fas fa-times"></i></button>
                <button onclick="open_modal_library_icons(\''.$element.'\')" class="btn btn-sm btn-primary" type="button" id="btn_library_icon_'.$element.'">'._("Select Library Icon").'</button>
                <input class="library_icon_value" type="hidden" id="'.$element.'_library_icon" value="'.$ui_style['controls'][$element]['icon_library'].'" />
                <img id="'.$element.'_library_icon_preview" style="height:30px;'.(($ui_style['controls'][$element]['icon_library'] == 0 || empty($ui_style['controls'][$element]['icon_library'])) ? 'display:none;' : '').'" src="'.$image_library_icon.'" />
            </div>';
    return $html;
}

function print_library_icon($element,$w) {
    global $ui_style,$array_library_icons,$array_public_library_icons,$s3_enabled,$s3_url;
    $image_library_icon = "";
    if(!empty($ui_style['controls'][$element]['icon_library']) && $ui_style['controls'][$element]['icon_library']!=0) {
        if(array_key_exists($ui_style['controls'][$element]['icon_library'],$array_library_icons)) {
            $image_library_icon = $array_library_icons[$ui_style['controls'][$element]['icon_library']];
        } else {
            $ui_style['controls'][$element]['icon_library'] = 0;
            return '';
        }
    } else {
        $ui_style['controls'][$element]['icon_library'] = 0;
        return '';
    }
    if($s3_enabled) {
        if(array_key_exists($ui_style['controls'][$element]['icon_library'],$array_public_library_icons)) {
            $url_icon = "../viewer/icons/$image_library_icon";
        } else {
            $url_icon = $s3_url."viewer/icons/$image_library_icon";
        }
    } else {
        $url_icon = "../viewer/icons/$image_library_icon";
    }
    switch($w) {
        case 'list':
            return '<img style="width:12px;height:12px;vertical-align:middle;margin-bottom:2px;" src="'.$url_icon.'" />';
            break;
        case 'icon':
            return '<img src="'.$url_icon.'" />';
            break;
    }
}
?>