<?php $__env->startSection('page_title', $list->name); ?>

<?php $__env->startSection('styles'); ?>
    <?php echo Minify::stylesheet([
            '/css/pages/lists.css'
         ])->withFullUrl(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <?php echo Minify::javascript([
            '/js/pages/lists.js'
         ])->withFullUrl(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex flex-wrap">
        <div class="min-vh-100 border-right col-12 pr-md-0 px-0">
            <div class="pt-4 pl-4 px-3 d-flex justify-content-between pb-3 border-bottom">
                <h5 class="mb-0 text-truncate text-bold <?php echo e((Cookie::get('app_theme') == null ? (getSetting('site.default_user_theme') == 'dark' ? '' : 'text-dark-r') : (Cookie::get('app_theme') == 'dark' ? '' : 'text-dark-r'))); ?>"><?php echo e(__($list->name)); ?></h5>
                <?php if($list->isManageable): ?>
                    <div class="mr-2">
                        <div class="dropdown <?php echo e(GenericHelper::getSiteDirection() == 'rtl' ? 'dropright' : 'dropleft'); ?>">
                            <a class="btn btn-outline-primary btn-sm dropdown-toggle px-3 mb-0" data-toggle="dropdown" href="#" role="button" aria-haspopup="true" aria-expanded="false">
                                <?php echo $__env->make('elements.icon',['icon'=>'ellipsis-horizontal-outline'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </a>
                            <div class="dropdown-menu">
                                <!-- Dropdown menu links -->
                                <a class="dropdown-item" href="javascript:void(0);" onclick="Lists.showListEditDialog('edit')"><?php echo e(__('Rename list')); ?></a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item" href="#" onclick="Lists.showListClearConfirmation()"><?php echo e(__('Clear list')); ?></a>
                                <a class="dropdown-item" href="javascript:void(0);" onclick="Lists.showListDeleteConfirmation()"><?php echo e(__('Delete list')); ?></a>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            <div class="mx-4 pt-2">
                <div class="list-wrapper">
                    <?php if(count($list->members)): ?>
                        <div class="row">
                            <?php $__currentLoopData = $list->members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-12 col-md-6 col-xl-4 px-2 py-2">
                                    <?php echo $__env->make('elements.feed.suggestion-card',['profile' => $member, 'isListMode' => true, 'isListManageable' => ($list->type == \App\Model\UserList::FOLLOWERS_TYPE ? false : true)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php else: ?>
                        <p class="pl-0 pt-2"><?php echo e(__('No profiles available')); ?></p>
                    <?php endif; ?>
                </div>

            </div>

        </div>
    </div>
    <?php echo $__env->make('elements.lists.list-update-dialog',['mode'=>'edit'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('elements.lists.list-delete-dialog', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('elements.lists.list-member-delete-dialog', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('elements.lists.list-clear-dialog', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.user-no-nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sun9group/public_html/podaddy.sun9group.com/resources/views/pages/list.blade.php ENDPATH**/ ?>