<div class="pb-2">
    <div class="pb-2 text-center"><?php echo e(__('Copy your referral link and invite other people to get a fee from their earnings.')); ?></div>
    <div class="pl-5 pr-5">
        <div class="input-group">
            <input type="text" class="form-control text-center"
                   <?php switch(getSetting('referrals.referrals_default_link_page')):
                       case ('profile'): ?>
                           value="<?php echo e(route('profile',['ref'=> Auth::user()->referral_code, 'username'=> Auth::user()->username])); ?>"
                       <?php break; ?>
                       <?php case ('home'): ?>
                            value="<?php echo e(route('home',['ref'=> Auth::user()->referral_code])); ?>"
                       <?php break; ?>
                       <?php case ('register'): ?>
                            value="<?php echo e(route('register',['ref'=> Auth::user()->referral_code])); ?>"
                       <?php break; ?>
                   <?php endswitch; ?>
                   placeholder="<?php echo e(route('profile',['ref'=> Auth::user()->referral_code, 'username'=> Auth::user()->username])); ?>"
                   id="copy-input"
            >
            <div class="input-group-append">
      <button class="btn btn-primary btn-block rounded mr-0 text-truncate" type="button" id="copy-button"
              data-toggle="tooltip" data-placement="bottom"
              title=<?php echo e(__('Copy to Clipboard')); ?>>
        <?php echo e(__('Copy')); ?>

      </button>
    </div>
        </div>
    </div>
</div>
<div class="table-wrapper ">
    <div class="">
        <div class="col py-3 text-bold border-bottom">
            <div class="col-lg-12 text-truncate d-md-block text-center"><?php echo e(__('Your referral list')); ?></div>
        </div>
        <?php if(count($referrals)): ?>
            <?php $__currentLoopData = $referrals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $referral): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col d-flex align-items-center py-3 border-bottom">
                    <div class="pl-2">
                        <?php if($referral->usedBy): ?>
                            <a href="<?php echo e(route('profile',['username'=>$referral->usedBy->username])); ?>">
                                <img class="rounded-circle avatar" src="<?php echo e($referral->usedBy->avatar); ?>" alt="<?php echo e($referral->usedBy->username); ?>">
                            </a>
                        <?php else: ?>
                            <a href="<?php echo e(route('profile',['username'=>$referral->usedBy->username])); ?>">
                                <img class="rounded-circle avatar" src="<?php echo e(\App\Providers\GenericHelperServiceProvider::getStorageAvatarPath(null)); ?>" alt="Avatar">
                            </a>
                        <?php endif; ?>
                    </div>
                    <div class="col-lg-4 text-truncate">
                        <a href="<?php echo e(route('profile',['username'=>$referral->usedBy->username])); ?>" class="text-dark-r">
                            <?php echo e($referral->usedBy->name); ?>

                        </a>
                    </div>
                    <div class="col-lg-4 d-none d-md-block">
                        <?php echo e(__('Since')); ?>: <?php echo e(\Carbon\Carbon::parse($referral->created_at)->format('Y-m-d')); ?>

                    </div>
                    <div class="col-lg-4 text-truncate">
                        <?php echo e(__('Earned')); ?>:<b> <?php echo e(\App\Providers\SettingsServiceProvider::getWebsiteFormattedAmount(\App\Providers\UsersServiceProvider::getTotalAmountEarnedFromRewardsByUsers(\Illuminate\Support\Facades\Auth::user()->id, $referral->used_by))); ?></b>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <div class="d-flex flex-row-reverse mt-3 mr-4">
                <?php echo e($referrals->onEachSide(1)->links()); ?>

            </div>
        <?php else: ?>
            <div class="p-3 text-center">
                <p><?php echo e(__('There are no referrals to show.')); ?></p>
            </div>
        <?php endif; ?>
    </div>
</div>


<?php /**PATH /home/sun9group/public_html/podaddy.sun9group.com/resources/views/elements/settings/settings-referrals.blade.php ENDPATH**/ ?>