<div class="post-comment d-flex flex-row mb-3" data-commentID="<?php echo e($comment->id); ?>">

    <div class="">
        <img class="rounded-circle" src="<?php echo e($comment->author->avatar); ?>">
    </div>

    <div class="pl-3 w-100 post-comment-content">
        <div class="d-flex flex-row justify-content-between">
            <div class="text-bold d-flex align-items-center"><a href="<?php echo e(route('profile',['username'=>$comment->author->username])); ?>" class="text-dark-r"><?php echo e($comment->author->username); ?></a>
                <?php if($comment->author->email_verified_at && $comment->author->birthdate && ($comment->author->verification && $comment->author->verification->status == 'verified')): ?>
                    <span data-toggle="tooltip" data-placement="top" title="<?php echo e(__('Verified user')); ?>">
                        <?php echo $__env->make('elements.icon',['icon'=>'checkmark-circle-outline','centered'=>true,'classes'=>'ml-1 text-primary'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </span>
                <?php endif; ?>
            </div>
            <div class="position-absolute separator">
                <div class="d-flex">

                    <?php if(Auth::user()->id == $comment->author->id): ?>
                        <span class="ml-1 h-pill h-pill-primary rounded react-button" data-toggle="tooltip" data-placement="top" title="<?php echo e(__("Edit")); ?>" onclick="Post.showEditCommentInterface(<?php echo e($comment->post->id); ?>,<?php echo e($comment->id); ?>)">
                             <?php echo $__env->make('elements.icon',['icon'=>'create-outline'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </span>
                        <span class="ml-1 h-pill h-pill-primary rounded react-button" data-toggle="tooltip" data-placement="top" title="<?php echo e(__("Delete")); ?>" onclick="Post.showDeleteCommentDialog(<?php echo e($comment->post->id); ?>,<?php echo e($comment->id); ?>)">
                             <?php echo $__env->make('elements.icon',['icon'=>'trash-outline'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </span>
                    <?php else: ?>
                        <span class="h-pill h-pill-primary rounded react-button <?php echo e(PostsHelper::didUserReact($comment->reactions) ? 'active' : ''); ?>" data-toggle="tooltip" data-placement="top" title="<?php echo e(__("Like")); ?>" onclick="Post.reactTo('comment',<?php echo e($comment->id); ?>)">
                         <?php echo $__env->make('elements.icon',['icon'=>'heart-outline'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </span>
                    <?php endif; ?>
                </div>

            </div>
        </div>
        <div>
            <div class="">
                <div class="text-break comment-content"><?php echo e($comment->message); ?></div>
            </div>
            <div class="d-flex text-muted">
                <div class="d-flex align-items-center">
                    <?php if($comment->updated_at->notEqualTo($comment->created_at)): ?>
                    <div data-toggle="tooltip" data-placement="bottom" title="<?php echo e(__("Edited at")); ?> <?php echo e($comment->updated_at->format('g:i A')); ?>">
                        <?php echo e($comment->created_at->format('g:i A')); ?>

                    </div>
                    <?php else: ?>
                        <?php echo e($comment->created_at->format('g:i A')); ?>

                    <?php endif; ?>
                </div>
                <div class="ml-2">
                    <span class="comment-reactions-label-count"><?php echo e(count($comment->reactions)); ?></span>
                    <span class="comment-reactions-label"><?php echo e(trans_choice('likes',count($comment->reactions))); ?></span>
                </div>
                <div class="ml-2"><a href="javascript:void(0)" onclick="Post.addReplyUser('<?php echo e($comment->author->username); ?>')" class="text-muted"><?php echo e(__('Reply')); ?></a></div>
            </div>
        </div>
    </div>

    <div class="pl-3 w-100 post-comment-edit d-none">
        <div class="d-flex flex-row justify-content-between">
            <div class="w-100 pr-2">
                <div class="edit-post-comment-area">
                    <div class="d-flex justify-content-center align-items-center">
                        <div class="input-group w-100">
                            <textarea name="message" class="form-control comment-textarea comment-text edit-comment-textarea" placeholder="<?php echo e(__('Write a message..')); ?>"  onkeyup="textAreaAdjust(this)"><?php echo e($comment->message); ?></textarea>
                            <span class="invalid-feedback pl-2 text-bold" role="alert"></span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="">
                <div class="d-flex mt-2">
                    <span class="ml-1 h-pill h-pill-primary rounded react-button save-comment-edit-button" data-toggle="tooltip" data-placement="top" title="<?php echo e(__("Save")); ?>" onclick="Post.saveEditedComment(<?php echo e($comment->post->id); ?>,<?php echo e($comment->id); ?>)">
                         <?php echo $__env->make('elements.icon',['icon'=>'checkmark-outline'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </span>
                    <span class="ml-1 h-pill h-pill-primary rounded react-button" data-toggle="tooltip" data-placement="top" title="<?php echo e(__("Cancel")); ?>" onclick="Post.cancelEditCommentInterface()">
                         <?php echo $__env->make('elements.icon',['icon'=>'close-outline'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </span>
                </div>
            </div>
        </div>
    </div>

</div>
<?php /**PATH /home/sun9group/public_html/podaddy.sun9group.com/resources/views/elements/feed/post-comment.blade.php ENDPATH**/ ?>