<div class="modal fade" tabindex="-1" role="dialog" id="post-set-poll-dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(__('Create a poll')); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p><?php echo e(__('Add a few questions to your poll.')); ?></p>

                <div class="poll-questions-wrapper">
                    <?php if(isset($post) && $post->poll): ?>
                        <?php $__currentLoopData = $post->poll->answers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $answer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="form-group">
                                <div class="d-flex align-items-center">
                                    <input class="form-control" id="<?php echo e($answer->id); ?>" name="questions" placeholder="<?php echo e(__("Enter a poll question")); ?>" value="<?php echo e($answer->answer); ?>">
                                    <?php if($loop->index > 1): ?>
                                        <div class="ml-1 h-pill h-pill-primary rounded react-button w-32 d-flex align-items-center" data-toggle="tooltip" data-placement="top" title="<?php echo e(__("Cancel")); ?>" onclick="PostCreate.deletePollAnswer(this)">
                                            <ion-icon name="close-outline"></ion-icon>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <div class="form-group">
                            <div class="d-flex align-items-center">
                                <input class="form-control" name="questions" placeholder="<?php echo e(__("Enter a poll question")); ?>">
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="d-flex align-items-center">
                                <input class="form-control" name="questions" placeholder="<?php echo e(__("Enter a poll question")); ?>">
                            </div>
                        </div>
                    <?php endif; ?>
                </div>

                <a class="d-flex align-items-center" href="javascript:void(0);" onclick="PostCreate.appendNewPollQuestion();">
                    <?php echo $__env->make('elements.icon',['icon'=>'add-outline','variant'=>'', 'classes' => 'mr-1'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php echo e(__("Add another option")); ?>

                </a>

            </div>
            <div class="modal-footer d-flex justify-content-between">
                <button type="button" class="btn btn-white"   onclick="PostCreate.clearPoll()"><?php echo e(__('Clear')); ?></button>
                <button type="button" class="btn btn-primary" onclick="PostCreate.savePoll()"><?php echo e(__('Save')); ?></button>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/sun9group/public_html/podaddy.sun9group.com/resources/views/elements/post-poll-setup.blade.php ENDPATH**/ ?>