<div class="py-2 notification-box  px-3 px-md-4 <?php echo e(!$notification->read?'unread':''); ?>">
    <div class="d-flex flex-row-no-rtl my-1">
        <?php if($notification->fromUser): ?>
            <div class="">
                <img class="rounded-circle avatar" src="<?php echo e($notification->fromUser->avatar); ?>" alt="<?php echo e($notification->fromUser->username); ?>">
            </div>
        <?php else: ?>
            <div class="">
                <img class="rounded-circle avatar" src="<?php echo e(\App\Providers\GenericHelperServiceProvider::getStorageAvatarPath(null)); ?>" alt="Avatar">
            </div>
        <?php endif; ?>
        <div class="pl-3 w-100">
            <div class="d-flex flex-row-no-rtl justify-content-between w-100">
                <div class="d-flex flex-column w-100">
                    <div class="d-flex flex-row justify-content-between">
                        <?php if($notification->fromUser): ?>
                            <h6 class="text-bold  m-0 p-0 d-flex"><a href="<?php echo e(route('profile',['username'=>$notification->fromUser->username])); ?>" class="text-dark-r"><?php echo e($notification->fromUser->name); ?></a></h6>
                        <?php else: ?>
                            <h6 class="text-bold  m-0 p-0 d-flex"><?php echo e(__("Notification")); ?></h6>
                        <?php endif; ?>
                        <div class="d-flex text-muted">
                            <div><?php echo e(\Carbon\Carbon::parse($notification->created_at)->diffForhumans()); ?> </div>
                        </div>
                    </div>
                    
                </div>
                <div class="position-absolute separator">
                </div>
            </div>
            <div>
                <div class="my-1 text-break pr-3 <?php echo e(!$notification->read?'text-bold':''); ?>">
                    <?php switch($notification->type):
                        case (\App\Model\Notification::NEW_TIP): ?>
                            <?php if(isset($notification->transaction)): ?>
                                <?php echo e($notification->transaction->sender->name); ?> <?php echo e(__("sent you a tip of")); ?> <?php echo e(\App\Providers\SettingsServiceProvider::getWebsiteFormattedAmount(\App\Providers\PaymentsServiceProvider::getTransactionAmountWithTaxesDeducted($notification->transaction))); ?>.
                            <?php else: ?>
                                <?php echo e(__('No transaction data')); ?>

                            <?php endif; ?>
                            <?php break; ?>
                        <?php case (\App\Model\Notification::NEW_REACTION): ?>
                            <?php if($notification->post_id): ?>
                                <?php echo e(__(":name liked your",['name'=>$notification->fromUser->name])); ?> <a href="<?php echo e(route('posts.get', ['username' => $notification->post->user->username, 'post_id' => $notification->post->id])); ?>" target="_blank"><?php echo e(__('post')); ?></a>.
                            <?php endif; ?>
                            <?php if($notification->post_comment_id): ?>
                                <?php echo e(__(":name liked your comment",['name'=>$notification->postComment->author->name])); ?>

                            <?php endif; ?>
                            <?php break; ?>
                        <?php case (\App\Model\Notification::NEW_COMMENT): ?>
                            <?php echo e(__(':name added a new comment on your',['name'=>$notification->fromUser->name])); ?> <a href="<?php echo e(route('posts.get', ['username' => $notification->postComment->post->user->username, 'post_id' => $notification->postComment->post->id])); ?>" target="_blank"><?php echo e(__('post')); ?></a>.
                            <?php break; ?>
                        <?php case (\App\Model\Notification::NEW_SUBSCRIPTION): ?>
                            <?php echo e(__("A new user subscribed to your profile")); ?>

                            <?php break; ?>
                        <?php case (\App\Model\Notification::WITHDRAWAL_ACTION): ?>
                            <?php echo e(__(\App\Providers\SettingsServiceProvider::leftAlignedCurrencyPosition() ? 'Withdrawal processed' : 'Withdrawal processed rightAligned',[
                                                'currencySymbol' => \App\Providers\SettingsServiceProvider::getWebsiteCurrencySymbol(),
                                                'amount' => $notification->withdrawal->amount,
                                                'status' =>  lcfirst(__($notification->withdrawal->status)),
                                            ])); ?>

                            <?php break; ?>
                        <?php case (\App\Model\Notification::NEW_MESSAGE): ?>
                            <?php echo e(__("Send you a message: `:message`",['message'=>$notification->userMessage->message])); ?>.
                            <?php break; ?>
                        <?php case (\App\Model\Notification::EXPIRING_STREAM): ?>
                            <?php echo e(__('Your live streaming is about to end in 30 minutes. You can start another one afterwards.')); ?>

                            <?php break; ?>
                        <?php case (\App\Model\Notification::PPV_UNLOCK): ?>
                            <?php echo e(__('Someone unlocked your'). ' ' . $notification->PPVUnlockType . '.'); ?>

                            <?php break; ?>
                    <?php endswitch; ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/sun9group/public_html/podaddy.sun9group.com/resources/views/elements/notifications/notification-box.blade.php ENDPATH**/ ?>