@extends('layouts.generic')

@section('page_description', getSetting('site.description'))
@section('share_url', route('home'))
@section('share_title', getSetting('site.name') . ' - ' . getSetting('site.slogan'))
@section('share_description', getSetting('site.description'))
@section('share_type', 'article')
@section('share_img', GenericHelper::getOGMetaImage())

@section('scripts')
    <script type="application/ld+json">
        {
          "@context": "http://schema.org",
          "@type": "Organization",
          "name": "{{getSetting('site.name')}}",
    "url": "{{getSetting('site.app_url')}}",
    "address": ""
  }
    </script>
@stop

@section('styles')
    {!!
        Minify::stylesheet([
            '/css/pages/home.css',
            '/css/pages/search.css',
         ])->withFullUrl()
    !!}
@stop

@section('content')

    {{-- 最新動態 --}}
    <div class="py-0 home-bg-section">
        <div class="container-fluid py-4">
            <div class="text-left mb-0">
                <h5 class="font-weight-bolder">最新動態</h5>
            </div>

            <div class="creators-wrapper">
                <div class="row px-3">
                    @if(count($featuredMembers))
                        @foreach($featuredMembers as $member)
                            <div class="col-12 col-md-2 p-1">
                                <div class="p-2">
                                    @include('elements.feed.suggestion-card',['profile' => $member])
                                </div>
                            </div>
                        @endforeach
                    @endif
                </div>
            </div>
        </div>
    </div>

    {{-- 熱門動態 --}}
    <div class="py-0 home-bg-section">
        <div class="container-fluid py-4">
            <div class="text-left mb-0">
                <h5 class="font-weight-bolder">熱門動態</h5>
            </div>

            <div class="creators-wrapper">
                <div class="row px-3">
                    @if(count($featuredMembers))
                        @foreach($featuredMembers as $member)
                            <div class="col-12 col-md-2 p-1">
                                <div class="p-2">
                                    @include('elements.feed.suggestion-card',['profile' => $member])
                                </div>
                            </div>
                        @endforeach
                    @endif
                </div>
            </div>
        </div>
    </div>

    {{-- 精選創作者 --}}
    <div class="py-0 home-bg-section">
        <div class="container-fluid py-4">
            <div class="text-left mb-0">
                <h5 class="font-weight-bolder">{{__("Featured creators")}}</h5>
            </div>

            <div class="creators-wrapper">
                <div class="row px-3">
                    @if(count($featuredMembers))
                        @foreach($featuredMembers as $member)
                            <div class="col-12 col-md-2 p-1">
                                <div class="p-2">
                                    @include('elements.feed.suggestion-card',['profile' => $member])
                                </div>
                            </div>
                        @endforeach
                    @endif
                </div>
            </div>
        </div>
    </div>
    
    {{-- 熱門直播 --}}
    <div class="py-0 home-bg-section">
        <div class="container-fluid py-4">
            <div class="text-left mb-0">
                <h5 class="font-weight-bolder">熱門直播</h5>
            </div>

            <div class="creators-wrapper">
                <div class="row px-3">
                    @if(count($featuredMembers))
                        @foreach($featuredMembers as $member)
                            <div class="col-12 col-md-2 p-1">
                                <div class="p-2">
                                    @include('elements.feed.suggestion-card',['profile' => $member])
                                </div>
                            </div>
                        @endforeach
                    @endif
                </div>
            </div>
        </div>
    </div>

    {{-- 所有直播 --}}
    <div class="py-0 home-bg-section">
        <div class="container-fluid py-4">
            <div class="text-left mb-0">
                <h5 class="font-weight-bolder">所有直播</h5>
            </div>

            <div class="creators-wrapper">
                <div class="row px-3">
                    @if(count($featuredMembers))
                        @foreach($featuredMembers as $member)
                            <div class="col-12 col-md-2 p-1">
                                <div class="p-2">
                                    @include('elements.feed.suggestion-card',['profile' => $member])
                                </div>
                            </div>
                        @endforeach
                    @endif
                </div>
            </div>
        </div>
    </div>
@stop
