/**
 * Notification settings component
 */
"use strict";
/* global app, trans, launchToast */

$(function () {
    $('.notification-checkbox').on('click',function () {
        const key = $(this).attr('id');
        const val = $(this).prop("checked");
        NotificationsSettings.updateUserSettings(key,val);
    });
});

var NotificationsSettings = {

    /**
     * Updates user notifications flags
     * @param key
     * @param value
     */
    updateUserSettings: function (key,value) {
        $.ajax({
            type: 'POST',
            data: {
                'key': key,
                'value': value
            },
            dataType: 'json',
            url: app.baseUrl+'/my/settings/save',
            success: function (result) {
                if(result.success){
                    launchToast('success',trans('Success'), trans('設定已儲存'));
                }
                else{
                    launchToast('danger',trans('Error'), trans('設定儲存失敗'));
                }
            },
            error: function () {
                launchToast('danger',trans('Error'), trans('設定儲存失敗'));
            }
        });
    }

};
