<?php
/**
 * Template Name: Actors
 **/
get_header(); ?>

<div id="primary" class="content-area categories-list">
    <main id="main" class="site-main" role="main">

        <header class="entry-header">
            <?php the_title( '<h1><i class="fa fa-star"></i>', '</h1>' ); ?>
        </header>

        <?php the_content(); ?>

        <div class="videos-list">
        <?php
        //get_query_var to get page id from url
        $page = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
            
        // number of tags to show per-page
        $per_page = xbox_get_field_value( 'wpst-options', 'actors-per-page' );
        
        //count total number of terms related to passed taxonomy
        $number_of_series = count(get_terms('actors'));
        $offset = ( $page - 1 ) * $per_page;
        
        $term_args = array(
            'number' => $per_page,
            'offset' => $offset
        );
        $terms = get_terms('actors', $term_args);

        if ($terms) {

            foreach ($terms as $term) {

                $args = array(
                    'post_type'        => 'post',
                    'posts_per_page'   => 1,
                    'show_count'       => 1,
                    'orderby'          => 'rand',
                    'post_status'      => 'publish',
                    'tax_query' => array(
                        array(
                            'taxonomy' => 'actors',
                            'field' => 'slug',
                            'terms' => $term->slug
                            )
                        )
                    );

                $video_from_actor = new WP_Query( $args );

                if( $video_from_actor->have_posts() ){

                    $video_from_actor->the_post();

                }else{}

                $term->slug;
                $term->name; ?>               

                <article id="post-<?php the_ID(); ?>" <?php post_class('thumb-block'); ?>>
                    <a href="<?php echo bloginfo('url'); ?>?actors=<?php echo $term->slug; ?>" title="<?php echo $term->name; ?>">
                        <!-- Thumbnail -->
                        <div class="post-thumbnail">
                            <?php $thumb_url = get_post_meta($post->ID, 'thumb', true);
                            $image_id = get_term_meta ( $term->term_id, 'actors-image-id', true );
                            $cat_image = wp_get_attachment_image( $image_id, 'wpst_thumb_medium' );
                            $cat_image_url = wp_get_attachment_image_src( $image_id, 'wpst_thumb_medium' );
                            if ( $cat_image ){
                                echo '<div class="inner-border">' . $cat_image . '</div>';
                            }elseif ( has_post_thumbnail() ){ 
                                if( wp_is_mobile() ){
                                    echo '<img src="' . get_the_post_thumbnail_url($post->ID, 'wpst_thumb_medium') . '" alt="' . get_the_title() . '">';
                                }else{
                                    echo '<div class="inner-border"><img data-src="' . get_the_post_thumbnail_url($post->ID, 'wpst_thumb_medium') . '" alt="' . get_the_title() . '" src="' . get_template_directory_uri() . '/assets/img/px.gif"></div>';
                                }
                            }elseif( $thumb_url != '' ){
                                echo '<div class="inner-border"><img src="' . $thumb_url . '" alt="' . get_the_title() . '"></div>';
                            }else{
                                echo '<div class="inner-border"><div class="no-thumb"><span><i class="fa fa-image"></i> ' . __('No image', 'wpst') . '</span></div></div>';
                            } ?>
                            <header class="entry-header">		
                                <span class="cat-title"><?php echo $term->name; ?></span>
                            </header><!-- .entry-header -->
                        </div>                       
                    </a>
                </article><!-- #post-## -->

            <?php }

            wpst_page_navi(ceil($number_of_series / $per_page), $per_page);

        } ?>
        </div>

    </main><!-- #main -->
</div><!-- #primary -->

<?php get_footer();