<?php
/**
 * Check if the user has already voted.
 *
 * @param int $post_id The post ID.
 *
 * @return bool True if the user has already voted, false otherwise.
 */
function wpst_has_already_voted( $post_id ) {
	$timebeforerevote = 86400;// 60sec * 60min * 24h
	$ip               = isset( $_SERVER['REMOTE_ADDR'] ) ? sanitize_text_field( wp_unslash( $_SERVER['REMOTE_ADDR'] ) ) : false;
	if ( false === $ip ) {
		return false;
	}

	$voted_ips = get_post_meta( $post_id, 'voted_IP', true );
	if ( ! is_array( $voted_ips ) ) {
		$voted_ips = array();
	}

	if ( in_array( $ip, array_keys( $voted_ips ), true ) ) {
		$time = $voted_ips[ $ip ];
		$now  = time();
		if ( round( ( $now - $time ) / 60 ) > $timebeforerevote ) {
			return false;
		}
		return true;
	}
	return false;
}

/**
 * Get the post like link.
 *
 * @param int $post_id The post ID.
 *
 * @return string The post like link.
 */
function wpst_get_post_like_link( $post_id ) {
	$output = '<span class="post-like">';
	if ( wpst_has_already_voted( $post_id ) ) {
		$output .= '';
	} else {
		$output .= '<a class="button" href="#" data-post_id="' . $post_id . '" data-post_like="like"><span class="like" title="' . __( 'I like it', 'wpst' ) . '"><span id="more"><i class="fa fa-heart"></i> ' . __( 'Like it', 'wpst' ) . '</span></a>';
		$output .= '</span>';
	}
	return $output;
}

/**
 * Get the post like rate.
 *
 * @param int $post_id The post ID.
 *
 * @return int The post like rate.
 */
function wpst_get_post_like_rate( $post_id ) {
	$like_count    = intval( get_post_meta( $post_id, 'likes_count', true ) );
	$dislike_count = intval( get_post_meta( $post_id, 'dislikes_count', true ) );
	$total_count   = $like_count + $dislike_count;
	return 0 === $total_count ? 0 : round( $like_count / $total_count * 100 );
}
