<?php
/**
 * Plugin Name: WPS Player
 * Plugin URI: https://www.wp-script.com/plugins/clean-tube-player/
 * Description: The most simple and powerful WordPress video player ever created.
 * Author: WP-Script
 * Author URI: https://www.wp-script.com
 * Version: 2.3.1
 * Text Domain: clean-tube-player
 * Domain Path: /languages
 *
 * @package ctpl\main
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

// CTPL constants.
define( 'CTPL_VERSION', '2.3.1' );
define( 'CTPL_DIR', plugin_dir_path( __FILE__ ) );
define( 'CTPL_URL', plugin_dir_url( __FILE__ ) );
define( 'CTPL_FILE', __FILE__ );

// CTPL requires wp-script-core plugin.
require_once ABSPATH . 'wp-admin/includes/plugin.php';
if ( ! is_plugin_active( 'wp-script-core/wp-script-core.php' ) ) {
	require_once CTPL_DIR . 'tgmpa/class-tgm-plugin-activation.php';
	require_once CTPL_DIR . 'tgmpa/config.php';
	return;
}

// CTPL Autoload classes.
require_once 'vendor/autoload.php';

/**
 * Create the plugin instance in a function and call it.
 *
 * @return CTPL::instance();
 */
if ( ! function_exists( 'CTPL' ) ) {
	/**
	 * Run the plugin.
	 */
	function CTPL() {
		if ( class_exists( CTPL::class ) ) {
			return CTPL::instance();
		}
	}
}

add_action( 'init', 'ctpl_check_plugin_status' );
/**
 * Init hook callback to run the Player only if it is connected.
 */
function ctpl_check_plugin_status() {
	// Do not run the plugin if WPSCORE is not installed.
	if ( ! function_exists( 'WPSCORE' ) ) {
		return;
	}

	// Do not run the plugin if it is not connected.
	if ( 'connected' !== WPSCORE()->get_product_status( 'CTPL' ) ) {
		return;
	}

	// Do not run the plugin if we are in widget iframe preview.
	if ( isset( $_SERVER['REQUEST_URI'] ) && false !== strpos( $_SERVER['REQUEST_URI'], 'widget' ) ) {
		return;
	}

	CTPL();
}
