<?php
    $videos_per_row = xbox_get_field_value( 'wpst-options', 'videos-per-row' );
    if( $videos_per_row == '2' ){
        $videos_per_row = '50';
    }elseif( $videos_per_row == '3' ){
        $videos_per_row = '33.33';
    }elseif( $videos_per_row == '4' ){
        $videos_per_row = '25';
    }elseif( $videos_per_row == '5' ){
        $videos_per_row = '20';
    }elseif( $videos_per_row == '6' ){
        $videos_per_row = '16.66';
    }
?>

<?php
$ratio_option = xbox_get_field_value( 'wpst-options', 'thumbnails-ratio', '16/9' );
$ratio_width  = intval( explode( '/', $ratio_option )[0] );
$ratio_height = intval( explode( '/', $ratio_option )[1] );
$ratio_format = floatval( $ratio_height * 100 / $ratio_width );

$thumbnails_fit = xbox_get_field_value( 'wpst-options', 'thumbnails-fit', 'fill' );
?>

<style>
	.post-thumbnail {
		padding-bottom: <?php echo esc_html( str_replace( ',', '.', (string) $ratio_format ) ); ?>%;
	}

	.post-thumbnail .wpst-trailer,
	.post-thumbnail img {
		object-fit: <?php echo esc_html( str_replace( ',', '.', (string) $thumbnails_fit ) ); ?>;
	}


    <?php if ( xbox_get_field_value( 'wpst-options', 'use-logo-image' ) == 'off' ) : ?>
        @import url(https://fonts.googleapis.com/css?family=<?php echo str_replace( ' ', '+', xbox_get_field_value( 'wpst-options', 'logo-font-family' ) ); ?>);
    <?php endif; ?>
    .site-title a {
        font-family: <?php echo xbox_get_field_value( 'wpst-options', 'logo-font-family' ); ?>;
        font-size: <?php echo xbox_get_field_value( 'wpst-options', 'logo-font-size' ); ?>px;
    }
    .site-branding .logo img {
        max-width: <?php echo xbox_get_field_value( 'wpst-options', 'logo-max-width' ); ?>px;
        max-height: <?php echo xbox_get_field_value( 'wpst-options', 'logo-max-height' ); ?>px;
        margin-top: <?php echo xbox_get_field_value( 'wpst-options', 'logo-margin-top' ); ?>px;
        margin-left: <?php echo xbox_get_field_value( 'wpst-options', 'logo-margin-left' ); ?>px;
    }
    a,
    .site-title a i,
    .thumb-block:hover .rating-bar i,
    .categories-list .thumb-block:hover .entry-header .cat-title:before,
    .required,
    .top-bar i:hover,
    #site-navigation > ul > li:hover > a,
    #site-navigation > ul > li:focus > a,
    #site-navigation > ul > li.current_page_item > a,
    #site-navigation > ul > li.current-menu-item > a,
    #site-navigation ul ul li a:hover,
    #filters .filters-select:after,
    .morelink i,
    .site-branding .header-search input#searchsubmit:hover,
    #filters .filters-select,
    #filters .filters-options span:hover a,
    a.tag-cloud-link:hover,
    .template-actors li a:hover,
    .video-tags a.label:hover,
    a.tag-cloud-link:focus,
    .template-actors li a:focus,
    .video-tags a.label:focus,
    .main-navigation li.my-area i,
    .thumb-block:hover .photos-count i
    .more-videos {
        color: <?php echo xbox_get_field_value( 'wpst-options', 'main-color' ); ?>;
    }
    button,
    .button,
    input[type="button"],
    input[type="reset"],
    /*input[type="submit"],*/
    .label
    body #filters .label.secondary.active,
    .label.secondary:hover,
    .widget_categories ul li a:hover,
    .comment-reply-link,
    span.post-like a.disabled:hover,
    .sharing-buttons i:hover {
        border-color: <?php echo xbox_get_field_value( 'wpst-options', 'main-color' ); ?>!important;
        background-color: <?php echo xbox_get_field_value( 'wpst-options', 'main-color' ); ?>!important;
    }
    .rating-bar-meter,
    .vjs-play-progress,
    .bx-wrapper .bx-controls-direction a {
        background-color: <?php echo xbox_get_field_value( 'wpst-options', 'main-color' ); ?>!important;
    }
    #video-tabs button.tab-link.active,
    .title-block,
    .widget-title,
    .page-title,
    .page .entry-title,
    .comments-title,
    .comment-reply-title,
    .morelink:hover,
    input[type="text"]:focus,
    input[type="email"]:focus,
    input[type="url"]:focus,
    input[type="password"]:focus,
    input[type="search"]:focus,
    input[type="number"]:focus,
    input[type="tel"]:focus,
    input[type="range"]:focus,
    input[type="date"]:focus,
    input[type="month"]:focus,
    input[type="week"]:focus,
    input[type="time"]:focus,
    input[type="datetime"]:focus,
    input[type="datetime-local"]:focus,
    input[type="color"]:focus,
    textarea:focus,
    .thumb-block:hover .post-thumbnail img,
    .no-thumb:hover,
    a.tag-cloud-link:hover,
    .template-actors li a:hover,
    .video-tags a.label:hover {
        border-color: <?php echo xbox_get_field_value( 'wpst-options', 'main-color' ); ?>!important;
    }

    .logo-watermark-img {
        max-width: <?php echo xbox_get_field_value( 'wpst-options', 'logo-watermark-max-width' ); ?>px;
    }

     <?php if( xbox_get_field_value( 'wpst-options', 'logo-watermark-grayscale' ) == 'on' ) : ?>
        .logo_maintain_display img {
            -webkit-filter: saturate(0);
	        filter: saturate(0);
        }
    <?php endif; ?>

    .thumb-block .inner-border::after {
        -webkit-box-shadow: inset 0px 0px 0px 0px <?php echo xbox_get_field_value( 'wpst-options', 'main-color' ); ?>;
        -moz-box-shadow: inset 0px 0px 0px 0px <?php echo xbox_get_field_value( 'wpst-options', 'main-color' ); ?>;
        box-shadow: inset 0px 0px 0px 0px <?php echo xbox_get_field_value( 'wpst-options', 'main-color' ); ?>;
    }
    .thumb-block .inner-border:hover::after {
        -webkit-box-shadow: inset 0px 0px 0px 3px <?php echo xbox_get_field_value( 'wpst-options', 'main-color' ); ?>;
        -moz-box-shadow: inset 0px 0px 0px 3px <?php echo xbox_get_field_value( 'wpst-options', 'main-color' ); ?>;
        box-shadow: inset 0px 0px 0px 3px <?php echo xbox_get_field_value( 'wpst-options', 'main-color' ); ?>;
    }

    /* Small desktops ----------- */
    @media only screen  and (min-width : 64.001em) and (max-width : 84em) {
        #main .thumb-block {
            width: <?php echo $videos_per_row; ?>%!important;
        }
    }

    /* Desktops and laptops ----------- */
    @media only screen  and (min-width : 84.001em) {
        #main .thumb-block {
            width: <?php echo $videos_per_row; ?>%!important;
        }
    }

</style>
