<?php

function wpst_pre_get_posts( $query ) {
    if ( is_admin() || ! $query->is_main_query() )
        return;   
    
    if(wp_is_mobile()){
        $query->set( 'posts_per_page', xbox_get_field_value( 'wpst-options', 'videos-per-page-mobile' ) );
    }else{
        $query->set( 'posts_per_page', xbox_get_field_value( 'wpst-options', 'videos-per-page' ) );
    } 
    
    $filter = '';
    if(is_home()) {
        $filter = xbox_get_field_value( 'wpst-options', 'show-videos-homepage' );
    }
    
    if(isset($_GET['filter'])) {
        $filter = $_GET['filter'];
    }

    switch($filter) {
        case 'latest' :
            $query->set( 'orderby', 'date');
            $query->set( 'order', 'DESC');
            break;
        case 'most-viewed' :
            $query->set( 'meta_key', 'post_views_count');
            $query->set( 'orderby', 'meta_value_num');
            $query->set( 'order', 'DESC');
            break;
        case 'longest' :
            $query->set( 'meta_key', 'duration');
            $query->set( 'orderby', 'meta_value_num');
            $query->set( 'order', 'DESC');
            break;
        case 'popular' :
            $query->set( 'orderby', 'meta_value_num');
            $query->set( 'order', 'DESC');
            $query->set( 'meta_query', array(
                                        'relation'  => 'OR',
                                        array(
                                            'key'     => 'rate',
                                            'compare' => 'NOT EXISTS'
                                        ),
                                        array(
                                            'key'     => 'rate',
                                            'compare' => 'EXISTS'
                                        )
                                    )
                        );            
            break;
        case 'random' :
            $query->set( 'orderby', 'rand');
            $query->set( 'order', 'DESC');
            break;            
        default;
    }
    return;
}
add_action( 'pre_get_posts', 'wpst_pre_get_posts', 1 );


function my_nav_wrap() {
    // default value of 'items_wrap' is <ul id="%1$s" class="%2$s">%3$s</ul>'    
    // open the <ul>, set 'menu_class' and 'menu_id' values

    /*if( wp_is_mobile() ){
        $myaccount_icon = ' <i class="fa fa-chevron-down"></i>';
    }else{
        $myaccount_icon = ' <i class="fa fa-bars"></i>';
    }*/
    

    $wrap = '<ul id="%1$s" class="%2$s">';    
    // get nav items as configured in /wp-admin/
    $wrap .= '%3$s';    
    // the static link 
    if( xbox_get_field_value( 'wpst-options', 'enable-membership' ) == 'on' ){
        // 修改 : 英文 語系的網址參數
        if(esc_url( home_url( '/' ) ) == 'https://missav456.com/') {
            $lang_url = '/';
        }

        // 修改 : 繁體 語系的網址參數
        if(esc_url( home_url( '/' ) ) == 'https://missav456.com/zh/home/') {
            $lang_url = '/zh/';
        }

        // 修改 : 簡體 語系的網址參數
        if(esc_url( home_url( '/' ) ) == 'https://missav456.com/zh-cn/home/') {
            $lang_url = '/zh-cn/';
        }

        // 修改 : 日文 語系的網址參數
        if(esc_url( home_url( '/' ) ) == 'https://missav456.com/ja/home/') {
            $lang_url = '/ja/';
        }

        // 修改 : 韓文 語系的網址參數
        if(esc_url( home_url( '/' ) ) == 'https://missav456.com/ko/home/') {
            $lang_url = '/ko/';
        }

        // 修改 : 印度 語系的網址參數
        if(esc_url( home_url( '/' ) ) == 'https://missav456.com/hi/home/') {
            $lang_url = '/hi/';
        }

        // 修改 : 越南 語系的網址參數
        if(esc_url( home_url( '/' ) ) == 'https://missav456.com/vi/home/') {
            $lang_url = '/vi/';
        }

        // 修改 : 泰文 語系的網址參數
        if(esc_url( home_url( '/' ) ) == 'https://missav456.com/th/home/') {
            $lang_url = '/th/';
        }

        // 修改 : 俄文 語系的網址參數
        if(esc_url( home_url( '/' ) ) == 'https://missav456.com/ru/home/') {
            $lang_url = '/ru/';
        }

        // 修改 : 土耳其 語系的網址參數
        if(esc_url( home_url( '/' ) ) == 'https://missav456.com/tr/home/') {
            $lang_url = '/tr/';
        }

        // 修改 : 德文 語系的網址參數
        if(esc_url( home_url( '/' ) ) == 'https://missav456.com/de/home/') {
            $lang_url = '/de/';
        }

        // 修改 : 法文 語系的網址參數
        if(esc_url( home_url( '/' ) ) == 'https://missav456.com/fr/home/') {
            $lang_url = '/fr/';
        }

        // 修改 : 印尼 語系的網址參數
        if(esc_url( home_url( '/' ) ) == 'https://missav456.com/id/home/') {
            $lang_url = '/id/';
        }

        if( is_user_logged_in() ){
            // 修改 : 我的帳戶 選單
            // $wrap .= '<li class="my-area"><a href="#">' . esc_html__('My Account', 'wpst') . '</a>';

            // 我的帳戶
            $wrap .= '<li><a href="' . $lang_url . 'my-account/">' . esc_html__('My Account', 'wpst') . '</a>';
            
            // 修改 : 預設選單
            // $wrap .= '<ul>';
            // $wrap .= '<li><a href="' . esc_url( home_url( '/' ) ) . 'submit-a-video" title="' . esc_html__('Submit a Video', 'wpst') . '">' . esc_html__('Submit a Video', 'wpst') . '</a></li>';
            // $wrap .= '<li><a href="' . get_author_posts_url(get_current_user_id()) . '">' . esc_html__('My Channel', 'wpst') . '</a></li>';
            // $wrap .= '<li><a href="' . esc_url( home_url( '/' ) ) . 'my-profile" title="' . esc_html__('My Profile', 'wpst') . '">' . esc_html__('My Profile', 'wpst') . '</a></li>';
            // $wrap .= '</ul>'; 
               
            $wrap .= '</li>';        
        }else{
            // 修改 : 預設選單
            // $wrap .= '<li><a href="#wpst-login">' . esc_html__('Login', 'wpst') . '</a></li>';

            // 登入連結
            $wrap .= '<li><a href="' . $lang_url . 'user-login/">' . esc_html__('Login', 'wpst') . '</a></li>';

            // 註冊連結
            $wrap .= '<li><a href="' . $lang_url . 'user-register/">' . esc_html__('Sign up', 'wpst') . '</a></li>';
        }
    }
    // close the <ul>
    $wrap .= '</ul>';
    // return the result
    return $wrap;
}

// Gallery images
function wpst_fancybox_gallery_attribute( $content, $id ) {
	// Restore title attribute
	$title = get_the_title( $id );
	return str_replace('<a', '<a data-type="image" data-caption="' . esc_attr( $title ) . '" ', $content);
}
//add_filter( 'wp_get_attachment_link', 'wpst_fancybox_gallery_attribute', 10, 4 );

// Single images
function wpst_fancybox_image_attribute( $content ) {
    global $post;
    $pattern = "/<a(.*?)href=('|\")(.*?).(bmp|gif|jpeg|jpg|png)('|\")(.*?)>/i";
    $replace = '<a$1href=$2$3.$4$5 data-type="image" data-fancybox="image">';
    $content = preg_replace( $pattern, $replace, $content );
    return $content;
}
//add_filter( 'the_content', 'wpst_fancybox_image_attribute' );

function get_first_image() {
    global $post, $posts;
    $first_img = '';
    ob_start();
    ob_end_clean();

    $output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', get_the_content(), $matches); 
    $first_img = $matches[1][0];

    return '<div class="photo-bg" style="background: url(' . $first_img . ') no-repeat; background-size: cover;">';
}