<?php
/**
 * Plugin Name: WPS Booster
 * Plugin URI: https://www.wp-script.com/plugins/wps-booster/
 * Description: Boost views and rating on your new site to make it bigger
 * Author: WP-Script
 * Author URI: https://www.wp-script.com
 * Version: 2.0.1
 * Text Domain: wps-booster
 * Domain Path: /languages
 *
 * @package bstr\main
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

// BSTR constants.
define( 'BSTR_VERSION', '2.0.1' );
define( 'BSTR_DIR', plugin_dir_path( __FILE__ ) );
define( 'BSTR_URL', plugin_dir_url( __FILE__ ) );
define( 'BSTR_FILE', __FILE__ );

// BSTR requires wp-script-core plugin.
require_once ABSPATH . 'wp-admin/includes/plugin.php';
if ( ! is_plugin_active( 'wp-script-core/wp-script-core.php' ) ) {
	require_once BSTR_DIR . 'tgmpa/class-tgm-plugin-activation.php';
	require_once BSTR_DIR . 'tgmpa/config.php';
	return;
}

// BSTR Autoload classes.
require_once 'vendor/autoload.php';

/**
 * Create the plugin instance in a function and call it.
 *
 * @return BSTR::instance();
 */
if ( ! function_exists( 'BSTR' ) ) {
	/**
	 * Run the plugin.
	 */
	function BSTR() {
		if ( class_exists( BSTR::class ) ) {
			return BSTR::instance();
		}
	}
	BSTR();
}

add_action( 'init', 'bstr_check_plugin_status' );
/**
 * Init hook callback to run the BSTR only if it is connected.
 */
function bstr_check_plugin_status() {
	if ( 'connected' === WPSCORE()->get_product_status( 'BSTR' ) ) {
		BSTR();
	}
}



