<?php
/**
 * Options page.
 *
 * @package DVIC\Admin\Pages
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_filter( 'dvic-options', 'dvic_options_page' );
/**
 * This function is a dvic-options filter callback of the Xbox options page.
 *
 * @param string $options_table - default options HTML string to render the Xbox options in the page.
 * @return $output
 */
function dvic_options_page( $options_table ) {
	$output  = '<div id="wp-script"><div class="content-tabs">';
	$output .= WPSCORE()->display_logo( false );
	$output .= WPSCORE()->display_tabs( false );
	$output .= '
		<div class="tab-content tab-options">
			<div class="tab-pane fade in active" id="DVIC-options-tab">
				<div v-cloak>
					<ul class="list-inline">
						<li><a href="admin.php?page=dvic-check-links"><i class="fa fa-link"></i> ' . __( 'Check links', 'dvic_lang' ) . '</a></li>
						<li>|</li>
						<li class="active"><a href="admin.php?page=dvic-options"><i class="fa fa-wrench"></i> ' . __( 'Options', 'dvic_lang' ) . '</a></li>
					</ul>
				</div>
			</div>';
	$output .= $options_table;
	$output .= '</div>';
	$output .= WPSCORE()->display_footer( false );
	$output .= '</div></div>';
	return $output;
}
add_action( 'xbox_init', 'dvic_options' );

/**
 * Set DVIC options.
 * xbox_init action callback to define all the plugin Xbox options.
 *
 * @return void
 */
function dvic_options() {
	$options = array(
		'id'         => 'DVIC-options',
		'icon'       => XBOX_URL . 'img/xbox-light-small.png', // Menu icon.
		'skin'       => 'pink', // Skins: blue, lightblue, green, teal, pink, purple, bluepurple, yellow, orange'.
		'layout'     => 'boxed', // wide.
		'header'     => array(
			'icon' => '<img src="' . XBOX_URL . 'img/xbox-light.png"/>',
			'desc' => 'Customize here your Theme',
		),
		'capability' => 'edit_published_posts',
	);
	$xbox    = xbox_new_admin_page( $options );
	$xbox->add_main_tab(
		array(
			'name'  => 'Main tab',
			'id'    => 'main-tab',
			'items' => array(
				'bg-process' => '<i class="xbox-icon xbox-icon-gear"></i>Background Process',
			),
		)
	);
		/**
		 * GENERAL
		 */
		$xbox->open_tab_item( 'bg-process' );
			$xbox->add_field(
				array(
					'name'    => esc_html__( 'Enable Background Process', 'dvic_lang' ),
					'id'      => 'enable-bg-process',
					'type'    => 'switcher',
					'default' => 'on',
					'grid'    => '4-of-8',
					'desc'    => esc_html__( 'Check for broken links automatically while navigating on the site', 'dvic_lang' ),
				)
			);
			$xbox->open_mixed_field(
				array(
					'id'   => 'displayed-when:switch:enable-bg-process:on:bg-process-settings',
					'name' => 'Background Process Settings',
				)
			);
			$twice_daily = 60 * 60 * 12;
			$daily       = 60 * 60 * 24;
				$xbox->add_field(
					array(
						'name'    => esc_html__( 'Frequency', 'dvic_lang' ),
						'id'      => 'bg-process-frequency',
						'type'    => 'select',
						'default' => $daily,
						'items'   => array(
							$twice_daily => 'Every 12 hours',
							$daily       => 'Every 24 hours',
						),
						'desc'    => esc_html__( 'Choose how often to check for broken links', 'dvic_lang' ),
					)
				);
				$xbox->add_field(
					array(
						'name'    => esc_html__( 'Action', 'dvic_lang' ),
						'id'      => 'bg-process-action',
						'type'    => 'radio',
						'default' => 'report-post',
						'items'   => array(
							'report-post' => esc_html__( 'Report the post only', 'dvic_lang' ),
							'draft-post'  => esc_html__( 'Draft the post', 'dvic_lang' ),
						),
						'desc'    => esc_html__( 'Select an action when some broken links are found on a post', 'dvic_lang' ),
					)
				);
				$xbox->add_field(
					array(
						'name'    => esc_html__( 'Check only for videos broken links?', 'dvic_lang' ),
						'id'      => 'bg-process-only-videos-links',
						'type'    => 'switcher',
						'default' => 'on',
						'desc'    => esc_html__( 'Set to off could slow down your site.', 'dvic_lang' ),
					)
				);
				$xbox->add_field(
					array(
						'name'    => esc_html__( 'Stop process on current post after a broken links is found?', 'dvic_lang' ),
						'id'      => 'bg-process-stop-after-broken-link-found',
						'type'    => 'switcher',
						'default' => 'on',
						'desc'    => esc_html__( 'Set to off could slow down your site.', 'dvic_lang' ),
					)
				);
			$xbox->close_mixed_field();

		$xbox->close_tab_item( 'bg-process' );

	$xbox->close_tab( 'main-tab' );
}
