<?php
/**
 * Ajax function to delete a post given its post_id.
 *
 * @package dvic\admin\actions
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Delete a post of a given post_id.
 *
 * @return void
 */
function dvic_delete_post() {
	check_ajax_referer( 'ajax-nonce', 'nonce' );
	if ( ! isset( $_POST['post_id'] ) ) {
		wp_send_json_error( array( 'message' => 'post_id parameter is missing' ) );
	}
	$response = wp_delete_post( intval( $_POST['post_id'] ), true );
	if ( false === $response ) {
		wp_send_json_error( array( 'message' => 'error while deleting post' ) );
	}
	wp_send_json_success();
	wp_die();
}
add_action( 'wp_ajax_dvic_delete_post', 'dvic_delete_post' );
