<?php
/**
 * Ajax function to check for broken links in a post given its post_id.
 *
 * @package dvic\admin\actions
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Return array with the amount of links tests.
 *
 * @return void
 */
function dvic_check_post_links() {
	check_ajax_referer( 'ajax-nonce', 'nonce' );
	$results = null;
	if ( ! isset( $_POST['post_id'] ) ) {
		wp_send_json_error( array( 'message' => 'post_id parameter is missing' ) );
	}
	if ( ! isset( $_POST['scan_only_videos_links'] ) ) {
		wp_send_json_error( array( 'message' => 'scan_only_videos_links parameter is missing' ) );
	}
	if ( ! isset( $_POST['stop_post_scan_after_broken_link_found'] ) ) {
		wp_send_json_error( array( 'message' => 'stop_post_scan_after_broken_link_found parameter is missing' ) );
	}
	$post_id                                = intval( $_POST['post_id'] );
	$scan_only_videos_links                 = 'true' === $_POST['scan_only_videos_links'] ? true : false;
	$stop_post_scan_after_broken_link_found = 'true' === $_POST['stop_post_scan_after_broken_link_found'] ? true : false;

	$results = DVIC\Checker::find_broken_links_in_post( $post_id, $scan_only_videos_links, $stop_post_scan_after_broken_link_found );
	wp_send_json_success(
		array(
			'links_tested_counter'  => $results['links_tested_counter'],
			'has_broken_links'      => $results['has_broken_links'],
			'formatted_post'        => $results['formatted_post'],
			'scanned_posts_counter' => DVIC\Checker::get_count_scanned_posts(),
		)
	);
	wp_die();
}
add_action( 'wp_ajax_dvic_check_post_links', 'dvic_check_post_links' );
