<?php
/**
 * Options page.
 *
 * @package COCO\Admin\Pages
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_filter( 'coco-options', 'coco_options_page' );
/**
 * This function is a coco-options filter callback to display WP-Script logo & tabs at the top of the Xbox options page.
 *
 * @param string $options_table - default options HTML string to render the Xbox options in the page.
 * @return $output
 */
function coco_options_page( $options_table ) {
	$output  = '<div id="wp-script"><div class="content-tabs">';
	$output .= WPSCORE()->display_logo( false );
	$output .= WPSCORE()->display_tabs( false );
	$output .= '
		<div class="tab-content tab-options">
			<div class="tab-pane fade in active" id="COCO-options-tab">
				<div v-cloak>
					<ul class="list-inline">
						<li class="active"><a href="admin.php?page=coco-options">' . esc_html__( 'Options', 'coco' ) . '</a></li>
					</ul>
				</div>
			</div>';
	$output .= $options_table;
	$output .= '</div>';
	$output .= WPSCORE()->display_footer( false );
	$output .= '</div></div>';
	return $output;
}

add_action( 'xbox_init', 'coco_options' );

/**
 * This function is a xbox_init action callback to define all the plugin Xbox options.
 *
 * @return void
 */
function coco_options() {
	$current_theme       = wp_get_theme();
	$wpscript_theme_info = '';

	$options = array(
		'id'         => 'COCO-options',
		'icon'       => XBOX_URL . 'img/xbox-light-small.png', // Menu icon.
		'skin'       => 'pink', // Skins: blue, lightblue, green, teal, pink, purple, bluepurple, yellow, orange'.
		'layout'     => 'boxed', // wide.
		'header'     => array(
			'icon' => '<img src="' . XBOX_URL . 'img/xbox-light.png"/>',
			'desc' => 'Customize here your Theme',
		),
		'capability' => 'edit_published_posts',
	);
	$xbox    = xbox_new_admin_page( $options );

	$items['wps-cookie-consent-general']     = '<i class="xbox-icon xbox-icon-gear"></i>' . esc_html__( 'General', 'coco' );
	$items['wps-cookie-consent-content']     = '<i class="xbox-icon xbox-icon-edit"></i>' . esc_html__( 'Content', 'coco' );

	$xbox->add_main_tab(
		array(
			'name'  => 'Main tab',
			'id'    => 'main-tab',
			'items' => $items,
		)
	);

	/*********************/
	/****** GENERAL ******/
	/*********************/
		$xbox->open_tab_item( 'wps-cookie-consent-general' );
		$xbox->add_field(
			array(
				'name'    => esc_html__( 'Dev mode for admin', 'coco' ),
				'id'      => 'cookie-consent-disable-cookie-admin',
				'type'    => 'switcher',
				'default' => 'off',
				'grid'    => '2-of-8',
				'desc'    => esc_html__( 'This option allows you to continue seeing the cookie consent message even if you click on "Got it!" button. Useful to make tests ;)', 'coco' ),
			)
		);

		$xbox->add_field(array(
			'name' => esc_html__('Bar position', 'wpst'),
			'id' => 'cookie-consent-bar-position',
			'type' => 'image_selector',
			'default' => 'bottom',
			'items' => array(
				'bottom-left' => COCO_URL . 'admin/assets/img/options/bar-position-bottom-left.jpg',
				'bottom' => COCO_URL . 'admin/assets/img/options/bar-position-bottom.jpg',
				'bottom-right' => COCO_URL . 'admin/assets/img/options/bar-position-bottom-right.jpg',
			),
			'items_desc' => array(
				'bottom-left' => esc_html__('Bottom Left', 'wpst'),
				'bottom' => esc_html__('Bottom', 'wpst'),
				'bottom-right' => esc_html__('Bottom Right', 'wpst')
			),
			'options' => array(
				'width' => '160px',
				'in_line' => true
			)
		));

		/*************************/
		/****** BACKGROUND *******/
		/*************************/
		$xbox->open_mixed_field(array('name' => esc_html__('Bar background', 'coco')));
			$xbox->add_field(
				array(
					'id'      => 'cookie-consent-background-color',
					'name'    => esc_html__( 'Background color', 'coco' ),
					'type'    => 'colorpicker',
					'default' => '#000000',
					'desc'    => esc_html__( 'Choose the color of the Consent button.', 'coco' ),
					'grid'    => '2-of-8',
				)
			);
			$xbox->add_field(
				array(
					'name'       => esc_html__( 'Background opacity', 'coco' ),
					'id'         => 'cookie-consent-background-color-opacity',
					'type'       => 'number',
					'default'    => 90,
					'attributes' => array(
						'min'       => 1,
						'max'       => 100,
						'step'      => 1,
						'precision' => 0,
					),
					'options'    => array(
						'unit' => esc_html__( '%', 'coco' ),
					),
					'desc'       => esc_html__( 'Set the logo opacity (1% - 100%).', 'coco' ),
					'grid'       => '2-of-8 last',
				)
			);
		$xbox->close_mixed_field();

		/**********************/
		/****** BUTTONS *******/
		/**********************/
		$xbox->open_mixed_field(array('name' => esc_html__('Button color', 'coco')));
			$xbox->add_field(
				array(
					'id'      => 'cookie-consent-button-color',
					'name'    => esc_html__( 'Consent button', 'coco' ),
					'type'    => 'colorpicker',
					'default' => '#ffcc00',
					'desc'    => esc_html__( 'Choose the color of the Consent button.', 'coco' ),
					'grid'    => '2-of-8',
				)
			);
		$xbox->close_mixed_field();
	$xbox->close_tab_item( 'wps-cookie-consent-general' );

	/*********************/
	/****** CONTENT ******/
	/*********************/
	$xbox->open_tab_item( 'wps-cookie-consent-content' );
		$xbox->add_field(
			array(
				'id'      	=> 'cookie-consent-text',
				'name'    	=> esc_html__( 'Consent text', 'coco' ),
				'type' 		=> 'textarea',
				'default' 	=> 'We use cookies to provide our services. By using this website, you agree to this.',
				'grid' 		=> '4-of-8',
				'desc'    	=> esc_html__( 'Set the cookie consent text.', 'coco' )
			)
		);

		$xbox->add_field(
			array(
				'id'      => 'cookie-consent-button',
				'name'    => esc_html__( 'Consent button', 'coco' ),
				'type'    => 'text',
				'default' => 'Got it!',
				'desc'    => esc_html__( 'Set the cookie consent button text.', 'coco' ),
				'grid'    => '2-of-8',
			)
		);

		$xbox->add_field(array(
			'name' => esc_html__('More information', 'coco'),
			'id' => 'cookie-consent-display-more-information',
			'desc'    => esc_html__( 'Display a more information link.', 'coco' ),
			'type' => 'switcher',
			'default' => 'on'
		));
		$xbox->open_mixed_field(array('id'=> 'displayed-when:switch:cookie-consent-display-more-information:on:cookie-consent-more-information-settings', 'name' => esc_html__('More information settings', 'coco')));
				$xbox->add_field(
					array(
						'id'      => 'cookie-consent-more-information-link-text',
						'name'    => esc_html__( 'Link text', 'coco' ),
						'type'    => 'text',
						'default' => 'More information',
						'desc'    => esc_html__( 'Set the more information link text.', 'coco' ),
						'grid'    => '2-of-8',
					)
				);
				$xbox->add_field(
					array(
						'id'      => 'cookie-consent-more-information-link-url',
						'name'    => esc_html__( 'Link URL', 'coco' ),
						'type'    => 'text',
						'default' => 'https://www.google.com/policies/technologies/cookies/',
						'desc'    => esc_html__( 'Set the more information link URL.', 'coco' ),
						'grid'    => '4-of-8 last',
					)
				);
		$xbox->close_mixed_field();

		$xbox->add_field(array(
			'name' => esc_html__('Privacy protection', 'coco'),
			'id' => 'cookie-consent-display-privacy-protection',
			'desc'    => esc_html__( 'Display a privacy protection link.', 'coco' ),
			'type' => 'switcher',
			'default' => 'off'
		));
		$xbox->open_mixed_field(array('id'=> 'displayed-when:switch:cookie-consent-display-privacy-protection:on:cookie-consent-privacy-protection-settings', 'name' => esc_html__('Privacy protection settings', 'coco')));
			$xbox->add_field(
				array(
					'id'      => 'cookie-consent-privacy-protection-link-text',
					'name'    => esc_html__( 'Link text', 'coco' ),
					'type'    => 'text',
					'default' => 'Privacy protection',
					'desc'    => esc_html__( 'Set the privacy protection link text.', 'coco' ),
					'grid'    => '2-of-8',
				)
			);
			$xbox->add_field(
				array(
					'id'      => 'cookie-consent-privacy-protection-popup-content',
					'name'    => esc_html__( 'Popup content', 'coco' ),
					'type'    => 'textarea',
					'default' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
					'desc'    => esc_html__( 'Set the privacy protection popup content.', 'coco' ),
					'grid'    => '4-of-8',
				)
			);
			$xbox->add_field(
				array(
					'name'    => esc_html__( 'Dark mode', 'coco' ),
					'id'      => 'cookie-consent-privacy-dark-popup',
					'type'    => 'switcher',
					'default' => 'off',
					'grid'    => '2-of-8 last',
					'desc'    => esc_html__( 'Check this option to display a dark popup for privacy protection data.', 'coco' ),
				)
			);
		$xbox->close_mixed_field();
	$xbox->close_tab_item( 'wps-cookie-consent-content' );

	$xbox->close_tab( 'main-tab' );
}
