<?php
/**
 * Plugin Name: Deleted Videos Checker
 * Plugin URI: https://www.wp-script.com/plugins/deleted-videos-checker/
 * Description: Check and report all deleted videos from tubes and any broken link on your site
 * Author: WP-Script
 * Author URI: https://www.wp-script.com
 * Version: 2.1.3
 * Text Domain: deleted-videos-checker
 * Domain Path: /languages
 *
 * @package dvic\main
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Create the plugin instance in a function and call it.
 *
 * @return DVIC::instance();
 */
if ( ! function_exists( 'run_dvic' ) ) {
	/**
	 * Run the plugin.
	 */
	function run_dvic() {
		// DVIC constants.
		define( 'DVIC_VERSION', '2.1.3' );
		define( 'DVIC_DIR', plugin_dir_path( __FILE__ ) );
		define( 'DVIC_URL', plugin_dir_url( __FILE__ ) );
		define( 'DVIC_FILE', __FILE__ );

		// DVIC Autoload classes.
		include_once 'vendor/autoload.php';

		// DVIC requires wp-script-core plugin.
		include_once ABSPATH . 'wp-admin/includes/plugin.php';
		if ( ! is_plugin_active( 'wp-script-core/wp-script-core.php' ) ) {
			include_once DVIC_DIR . 'tgmpa/class-tgm-plugin-activation.php';
			include_once DVIC_DIR . 'tgmpa/config.php';
			return;
		}

		if ( class_exists( 'DVIC' ) ) {
			return DVIC::instance();
		}
	}
	run_dvic();
}
