<?php
/**
 * Plugin config file.
 *
 * @package dvic\main
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Navigation config
 */
self::$config['nav'] = array(
	'15'           => array(
		'slug'     => 'dvic-check-links',
		'callback' => 'dvic_check_links_page',
		'title'    => 'Checker',
	),
	'dvic-options' => array(
		'slug' => 'dvic-options',
	),
);

/**
 * JS config
 */
self::$config['scripts']['js'] = array(
	// pages.
	'DVIC_check-links.js' => array(
		'in_pages'  => array( 'dvic-check-links' ),
		'path'      => 'admin/pages/page-check-links.js',
		'require'   => array( 'WPSCORE_vue.js' ),
		'version'   => DVIC_VERSION,
		'in_footer' => true,
		'localize'  => array(
			'ajax'    => true,
			'i18n'    => dvic_localize(),
			'dvicUrl' => DVIC_URL,
		),
	),
);

/**
 * Function to parse ./localize.json file to an array of localized strings.
 *
 * @return array Localized strings.
 */
function dvic_localize() {
	$localize = array();

	// Parse localize.php file.
	$localize_file = wp_normalize_path( DVIC_DIR . 'localize.php' );
	if ( file_exists( $localize_file ) ) {
		$localize = include_once $localize_file;
	}

	return $localize;
}

/**
 *  CSS config.
 */
self::$config['scripts']['css'] = array(
	// assets.
	'DVIC_admin.css' => array(
		'in_pages' => array( 'dvic-check-links' ),
		'path'     => 'admin/assets/css/admin.css',
		'require'  => array(),
		'version'  => DVIC_VERSION,
		'media'    => 'all',
	),
);
