<?php
/**
 * Default page
 *
 * @package dvic\admin\pages
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * DVIC Check links page callback function
 *
 * @return void
 */
function dvic_check_links_page() {
	?>
<div id="wp-script">
	<div class="content-tabs">
		<?php WPSCORE()->display_logo(); ?>
		<?php WPSCORE()->display_tabs(); ?>
		<div class="tab-content">
			<div class="tab-pane fade in active" id="check-links">
				<!-- empty div for auto margin -->
				<div>
					<ul class="list-inline">
					<li class="active"><a href="admin.php?page=dvic-check-links"><i class="fa fa-link"></i> <?php esc_html_e( 'Check links', 'dvic_lang' ); ?></a></li>
						<li>|</li>
						<li><a href="admin.php?page=dvic-options"><i class="fa fa-wrench"></i> <?php esc_html_e( 'Options', 'dvic_lang' ); ?></a></li>
					</ul>
				</div>
				<div id="dvic-check-links"></div>
			</div>
		</div>
		<?php WPSCORE()->display_footer(); ?>
	</div>
</div>
	<?php
}

