<?php
/**
 * Ajax function to load data on check links page.
 *
 * @package dvic\admin\actions
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Returns an array with data needed on check links page.
 *
 * @return void
 */
function dvic_load_check_links_data() {
	check_ajax_referer( 'ajax-nonce', 'nonce' );
	$data = array(
		'posts_data'    => DVIC\Checker::get_posts_data_for_filters(),
		'total_posts'   => DVIC\Checker::get_count_posts(),
		'scanned_posts' => DVIC\Checker::get_count_scanned_posts(),
		'broken_posts'  => DVIC\Checker::get_formatted_posts_with_broken_links(),
	);
	wp_send_json_success( $data );
	wp_die();
}
add_action( 'wp_ajax_dvic_load_check_links_data', 'dvic_load_check_links_data' );
