<?php
/**
 * Ajax function to draft a post given its post_id.
 *
 * @package dvic\admin\actions
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Draft a post of a given post_id.
 *
 * @return void
 */
function dvic_draft_post() {
	check_ajax_referer( 'ajax-nonce', 'nonce' );
	if ( ! isset( $_POST['post_id'] ) ) {
		wp_send_json_error( array( 'message' => 'post_id parameter is missing' ) );
	}
	$post     = array(
		'ID'          => intval( $_POST['post_id'] ),
		'post_status' => 'draft',
	);
	$response = wp_update_post( $post );
	if ( false === $response ) {
		wp_send_json_error( array( 'message' => 'error while drafting post' ) );
	}
	wp_send_json_success();
	wp_die();
}
add_action( 'wp_ajax_dvic_draft_post', 'dvic_draft_post' );
