<?php
$website = isset($options_by_locationID['url']) ? $options_by_locationID['url'] : '';

$name = isset($options_by_locationID['name']) ? $options_by_locationID['name'] : __('Sorry, this business does not have a proper Place ID set.', 'njt-google-reviews');
$ratings_count = isset($options_by_locationID['user_ratings_total']) ? intval($options_by_locationID['user_ratings_total']) : 0;
$place_avatar = $options_by_locationID['place_avatar'];

$disshahow = $shadow == "disabled" ? 'njt-disabled-shadow' : '';
$place_avatar = $google_logo == "disabled" ? $place_avatar : NJT_PLUGIN_URL . '/assets/frontend/img/google_place.svg';
$googleplus_page = isset($options_by_locationID['url']) ? $options_by_locationID['url'] : '';

$first_review_id = $postReviews[0]->ID ? $postReviews[0]->ID : null;

if ($first_review_id) {
	$google_action_data = json_encode([
		'locationId' => get_post_meta($first_review_id, 'location_id', true),
		'googlePlusPage' => $googleplus_page,
		'btnSeeAllReviewsLabel' =>  sprintf(esc_html__('Read All %d Reviews', 'njt-google-reviews'), $ratings_count),
		'btnWriteAReviewLabel' =>  __('Write a review', 'njt-google-reviews'),
	]);
} else {
	$google_action_data = null;
}

$firstFiveReviews = array_slice($postReviews, 0, 5, true);
$firstFiveReviews = json_encode(array_map(
	function ($post) {
		return [
			'id' => $post->ID,
			'authorName' => get_post_meta($post->ID, 'author_name', true),
			'reviewText' => urldecode(get_post_meta($post->ID, 'text', true)),
			'time' => get_post_meta($post->ID, 'relative_time_description', true),
			'avatar' => get_post_meta($post->ID, 'avatar', true)
				? get_post_meta($post->ID, 'avatar', true)
				: NJT_PLUGIN_PATH . '/assets/images/mystery-man.png',
			'rating' =>  get_post_meta($post->ID, 'rating', true),
		];
	},
	$firstFiveReviews
));

$firstFiveReviews = str_replace("'", '&lsquo;', $firstFiveReviews);

echo '<div class=" njt-google-places-reviews  njt-google-places-reviews-wap njt-badge ' . $disshahow . '">';
?>
<div class="njt-header" google-reviews='<?php echo $firstFiveReviews; ?>' data-google-actions='<?php echo $google_action_data ?>'>
	<div class="njt-header-image">
		<img title="<?php echo $name ?>" src="<?php echo $place_avatar ?>" alt="<?php echo $name ?>">
	</div>
	<div class="njt-header-content">
		<div class="njt-header-title">
			<a href="<?php echo $website ?>" target="_blank">
				<?php echo $name; ?>
			</a>
		</div>
		<?php
		$overall_rating = isset($options_by_locationID['rating']) ? $options_by_locationID['rating'] : '';
		if ($overall_rating) {
			echo $reviews->get_star_rating($overall_rating, null, $hide_out_of_rating, $hide_google_image);
		}
		?>
		<div class="njt-read-all-reviews">
			<a href="<?php echo esc_url($googleplus_page) ?>" target="_blank"><?php printf(esc_html__('Read All %d Reviews', 'njt-google-reviews'), $ratings_count); ?></a>
		</div>
	</div>
</div>
</div>