<?php
/*
 Plugin Name: EventON - Weekly View
 Plugin URI: http://www.myeventon.com/
 Description: Create a week view of events for EventON Calendar
 Author: Ashan Jay
 Version: 2.0
 Author URI: http://www.ashanjay.com/
 Requires at least: 5.0
 Tested up to: 5.8
 */
class eventon_weeklyview{	
	public $version='2.0';
	public $eventon_version = '4.0';
	public $name = 'WeeklyView';

	public $addon_data = array();
	public $slug, $plugin_slug , $plugin_url , $plugin_path ;
	private $urls;
	public $template_url ;	

	public $shortcode_args = array();
	public $is_running_wv = false;
	public $load_script = false;
	
	/* Construct	 */
		protected static $_instance = null;
		public static function instance() {
			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}
			return self::$_instance;
		}
		public function __construct(){			
			// check if eventon exists with addon class
			if( !isset($GLOBALS['eventon']) || !class_exists('evo_addons') ){
				add_action('admin_notices', array($this, 'notice'));
				return false;			
			}
			
			$this->super_init();
			$this->addon = new evo_addons($this->addon_data);

			if($this->addon->evo_version_check()){
				add_action( 'init', array( $this, 'init' ), 0 );
			}				
		}
		// Eventon missing
			public function notice(){
				?><div class="message error"><p><?php printf(__('EventON %s is NOT active! - '), $this->name); 
		        	echo "You do not have EventON main plugin, which is REQUIRED.";?></p></div><?php
			}
		
	// SUPER init
		function super_init(){
			// PLUGIN SLUGS			
			$this->addon_data['plugin_url'] = path_join(plugins_url(), basename(dirname(__FILE__)));
			$this->addon_data['plugin_slug'] = plugin_basename(__FILE__);
			list ($t1, $t2) = explode('/', $this->addon_data['plugin_slug'] );
	        $this->addon_data['slug'] = $t1;
	        $this->addon_data['plugin_path'] = dirname( __FILE__ );
	        $this->addon_data['evo_version'] = $this->eventon_version;
	        $this->addon_data['version'] = $this->version;
	        $this->addon_data['name'] = $this->name;

	        $this->plugin_url = $this->addon_data['plugin_url'];
	        $this->plugin_slug = $this->addon_data['plugin_slug'];
	        $this->slug = $this->addon_data['slug'];
	        $this->plugin_path = $this->addon_data['plugin_path'];
		}

	// INITIATE please
		function init(){
			// Deactivation
			register_deactivation_hook( __FILE__, array($this,'deactivate'));

			// RUN addon updater only in dedicated pages
			if ( is_admin() ){
				include_once( 'includes/admin/admin-init.php' );						
			}

			include_once( 'includes/class-frontend.php' );
			include_once( 'includes/class-shortcode.php' );

			if ( defined('DOING_AJAX') ){
				include_once( 'includes/class-ajax.php' );
			}

			$this->shortcodes = new EVOWV_shortcode();
			$this->frontend = new EVOWV_frontend();
		}
	
	// SECONDARY FUNCTIONS
		// Deactivate addon
		function deactivate(){
			$this->addon->remove_addon();
		}
		function print_scripts(){
			$this->frontend->print_scripts();
		}
}

// Initiate this addon within the plugin
function EVOWV(){ return eventon_weeklyview::instance(); }
$GLOBALS['eventon_wv'] = EVOWV();


// php tag
function add_eventon_wv($args='') {
	echo EVOWV()->shortcodes->evoWV_generate_calendar($args);
}
?>