<?php
/**
 * Event Taxonomy Class 
 * @version 4.3.5
 */

if ( ! defined( 'ABSPATH' ) ) exit; 

class EVO_Event_Tax {
	
	function get_organizer_data(){
		$O_term = apply_filters('evodata_organizer_term', $this->get_organizer_term_id('all'), $this);
		if($O_term && !is_wp_error( $O_term)){
			$R = array();

			$org_term_meta = evo_get_term_meta( 'event_organizer', (int)$O_term->term_id);
			
			$R['organizer'] = $O_term;
			$R['organizer_term'] = $O_term;
			$R['organizer_term_id'] = (int)$O_term->term_id;
			$R['organizer_name'] = $O_term->name;
			$R['organizer_description'] = $O_term->description;

			$organizer_meta = $this->get_organizer_social_meta_array();
			$organizer_meta['organizer_img_id'] = 'evo_org_img';
			$organizer_meta['organizer_contact'] = 'evcal_org_contact';
			$organizer_meta['organizer_address'] = 'evcal_org_address';
			$organizer_meta['organizer_link'] = 'evcal_org_exlink';
			$organizer_meta['organizer_link_target'] = '_evocal_org_exlink_target';

			// meta values
			foreach($organizer_meta as $I=>$key){	
				$K = is_integer($I)? $key: $I;				
				$R[$K] = (empty($org_term_meta[$key]))? '': $org_term_meta[$key];
			}				

			return $R;
		}else{
			return false;
		}
	}
	function get_organizer_social_meta_array(){
		return eventon_get_organizer_social_meta_array();
	}

	// event taxonomy data / @4.2
		function get_taxonomy_data($tax, $load_meta_data = true, $term_id = false){
			
			// get terms
			$terms = apply_filters('evodata_taxonomy_terms', wp_get_post_terms($this->ID, $tax), $tax, $term_id, $this );

			
			if ( $terms && ! is_wp_error( $terms ) ){
				$R = array();

				if( $load_meta_data){
					$meta_key_array = $this->get_taxonomy_meta_array( $tax );
				}

				foreach($terms as $term){

					if( $term_id && $term->term_id != $term_id ) continue; 

					$R[ $tax ][ $term->term_id ] = $term;

					// if meta data key exists
					if( $meta_key_array && count($meta_key_array)>0){
						$term_meta = evo_get_term_meta( $tax, (int)($term->term_id) );

						foreach( $meta_key_array as $I=>$key){
							$K = is_integer($I)? $key: $I;				
							$R[ $tax ][ $term->term_id ]->$K = (empty($term_meta[$key]))? '': $term_meta[$key];
						}
					}

					// append secondary description to main description
					if( !empty( $R[ $tax ][ $term->term_id ]->description2 )){
						$R[ $tax ][ $term->term_id ]->description .= '<div class="evo_sd">'. $R[ $tax ][ $term->term_id ]->description2 .'</div>';
					}

					// pass link 
					$R[ $tax ][ $term->term_id ]->link = get_term_link( $term , $tax);
				}				
				return $R;			

			}else{
				return false;
			}
		}

		function get_taxonomy_meta_array($tax){
			$meta_data = array();

			$meta_data['event_organizer'] = $this->get_organizer_social_meta_array();
			
			$meta_data['event_organizer']['img_id'] = 'evo_org_img';
			$meta_data['event_organizer']['organizer_img_id'] = 'evo_org_img';
			$meta_data['event_organizer']['organizer_contact'] = 'evcal_org_contact';
			$meta_data['event_organizer']['contact_email'] = 'evcal_org_contact_e';
			$meta_data['event_organizer']['organizer_address'] = 'evcal_org_address';
			$meta_data['event_organizer']['organizer_link'] = 'evcal_org_exlink';
			$meta_data['event_organizer']['organizer_link_target'] = '_evocal_org_exlink_target';
			$meta_data['event_organizer']['description2'] = 'description2';

			$meta_data = apply_filters( 'evo_single_event_taxonomy_meta_array', $meta_data, $tax, $this);

			return isset($meta_data[ $tax ]) ? $meta_data[ $tax ]: false;
		}

		// get any taxonomy term data including evo saved term meta from options
		// @since 4.3
		function get_term_data($tax, $term_id){
			$term = get_term_by('term_id', $term_id, $tax);

			if ( !$term && is_wp_error( $term ) ) return false;

			// load term meta
			$termmeta = evo_get_term_meta($tax,$term_id);
			if($termmeta && is_array($termmeta)) $term->termmeta = $termmeta;

			return $term;
		}

}