<?php
/**
 * Score
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  MuxPhp
 * @author   Mux API team
 * @link     https://docs.mux.com
 */

/**
 * Mux API
 *
 * Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.
 *
 * The version of the OpenAPI document: v1
 * Contact: devex@mux.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace MuxPhp\Models;

use \ArrayAccess;
use \MuxPhp\ObjectSerializer;

/**
 * Score Class Doc Comment
 *
 * @category Class
 * @package  MuxPhp
 * @author   Mux API team
 * @link     https://docs.mux.com
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class Score implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Score';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'watch_time' => 'int',
        'view_count' => 'int',
        'unique_viewers' => 'int',
        'started_views' => 'int',
        'total_playing_time' => 'int',
        'name' => 'string',
        'ended_views' => 'int',
        'value' => 'double',
        'type' => 'string',
        'metric' => 'string',
        'items' => '\MuxPhp\Models\Metric[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'watch_time' => 'int64',
        'view_count' => 'int64',
        'unique_viewers' => 'int64',
        'started_views' => 'int64',
        'total_playing_time' => 'int64',
        'name' => null,
        'ended_views' => 'int64',
        'value' => 'double',
        'type' => null,
        'metric' => null,
        'items' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'watch_time' => true,
        'view_count' => false,
        'unique_viewers' => false,
        'started_views' => false,
        'total_playing_time' => true,
        'name' => false,
        'ended_views' => false,
        'value' => false,
        'type' => false,
        'metric' => false,
        'items' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'watch_time' => 'watch_time',
        'view_count' => 'view_count',
        'unique_viewers' => 'unique_viewers',
        'started_views' => 'started_views',
        'total_playing_time' => 'total_playing_time',
        'name' => 'name',
        'ended_views' => 'ended_views',
        'value' => 'value',
        'type' => 'type',
        'metric' => 'metric',
        'items' => 'items'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'watch_time' => 'setWatchTime',
        'view_count' => 'setViewCount',
        'unique_viewers' => 'setUniqueViewers',
        'started_views' => 'setStartedViews',
        'total_playing_time' => 'setTotalPlayingTime',
        'name' => 'setName',
        'ended_views' => 'setEndedViews',
        'value' => 'setValue',
        'type' => 'setType',
        'metric' => 'setMetric',
        'items' => 'setItems'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'watch_time' => 'getWatchTime',
        'view_count' => 'getViewCount',
        'unique_viewers' => 'getUniqueViewers',
        'started_views' => 'getStartedViews',
        'total_playing_time' => 'getTotalPlayingTime',
        'name' => 'getName',
        'ended_views' => 'getEndedViews',
        'value' => 'getValue',
        'type' => 'getType',
        'metric' => 'getMetric',
        'items' => 'getItems'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        // MUX: enum hack (self::) due to OAS emitting problems.
        //      please re-integrate with mainline when possible.
        //      src: https://github.com/OpenAPITools/openapi-generator/issues/9038
        $this->setIfExists('watch_time', $data ?? [], null);
        $this->setIfExists('view_count', $data ?? [], null);
        $this->setIfExists('unique_viewers', $data ?? [], null);
        $this->setIfExists('started_views', $data ?? [], null);
        $this->setIfExists('total_playing_time', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('ended_views', $data ?? [], null);
        $this->setIfExists('value', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('metric', $data ?? [], null);
        $this->setIfExists('items', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets watch_time
     *
     * @return int|null
     */
    public function getWatchTime()
    {
        return $this->container['watch_time'];
    }

    /**
     * Sets watch_time
     *
     * @param int|null $watch_time watch_time
     *
     * @return self
     */
    public function setWatchTime($watch_time)
    {

        if (is_null($watch_time)) {
            array_push($this->openAPINullablesSetToNull, 'watch_time');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('watch_time', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['watch_time'] = $watch_time;

        return $this;
    }

    /**
     * Gets view_count
     *
     * @return int|null
     */
    public function getViewCount()
    {
        return $this->container['view_count'];
    }

    /**
     * Sets view_count
     *
     * @param int|null $view_count view_count
     *
     * @return self
     */
    public function setViewCount($view_count)
    {

        if (is_null($view_count)) {
            throw new \InvalidArgumentException('non-nullable view_count cannot be null');
        }

        $this->container['view_count'] = $view_count;

        return $this;
    }

    /**
     * Gets unique_viewers
     *
     * @return int|null
     */
    public function getUniqueViewers()
    {
        return $this->container['unique_viewers'];
    }

    /**
     * Sets unique_viewers
     *
     * @param int|null $unique_viewers unique_viewers
     *
     * @return self
     */
    public function setUniqueViewers($unique_viewers)
    {

        if (is_null($unique_viewers)) {
            throw new \InvalidArgumentException('non-nullable unique_viewers cannot be null');
        }

        $this->container['unique_viewers'] = $unique_viewers;

        return $this;
    }

    /**
     * Gets started_views
     *
     * @return int|null
     */
    public function getStartedViews()
    {
        return $this->container['started_views'];
    }

    /**
     * Sets started_views
     *
     * @param int|null $started_views started_views
     *
     * @return self
     */
    public function setStartedViews($started_views)
    {

        if (is_null($started_views)) {
            throw new \InvalidArgumentException('non-nullable started_views cannot be null');
        }

        $this->container['started_views'] = $started_views;

        return $this;
    }

    /**
     * Gets total_playing_time
     *
     * @return int|null
     */
    public function getTotalPlayingTime()
    {
        return $this->container['total_playing_time'];
    }

    /**
     * Sets total_playing_time
     *
     * @param int|null $total_playing_time total_playing_time
     *
     * @return self
     */
    public function setTotalPlayingTime($total_playing_time)
    {

        if (is_null($total_playing_time)) {
            array_push($this->openAPINullablesSetToNull, 'total_playing_time');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('total_playing_time', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['total_playing_time'] = $total_playing_time;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name name
     *
     * @return self
     */
    public function setName($name)
    {

        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }

        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets ended_views
     *
     * @return int|null
     */
    public function getEndedViews()
    {
        return $this->container['ended_views'];
    }

    /**
     * Sets ended_views
     *
     * @param int|null $ended_views ended_views
     *
     * @return self
     */
    public function setEndedViews($ended_views)
    {

        if (is_null($ended_views)) {
            throw new \InvalidArgumentException('non-nullable ended_views cannot be null');
        }

        $this->container['ended_views'] = $ended_views;

        return $this;
    }

    /**
     * Gets value
     *
     * @return double|null
     */
    public function getValue()
    {
        return $this->container['value'];
    }

    /**
     * Sets value
     *
     * @param double|null $value value
     *
     * @return self
     */
    public function setValue($value)
    {

        if (is_null($value)) {
            throw new \InvalidArgumentException('non-nullable value cannot be null');
        }

        $this->container['value'] = $value;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type type
     *
     * @return self
     */
    public function setType($type)
    {

        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }

        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets metric
     *
     * @return string|null
     */
    public function getMetric()
    {
        return $this->container['metric'];
    }

    /**
     * Sets metric
     *
     * @param string|null $metric metric
     *
     * @return self
     */
    public function setMetric($metric)
    {

        if (is_null($metric)) {
            throw new \InvalidArgumentException('non-nullable metric cannot be null');
        }

        $this->container['metric'] = $metric;

        return $this;
    }

    /**
     * Gets items
     *
     * @return \MuxPhp\Models\Metric[]|null
     */
    public function getItems()
    {
        return $this->container['items'];
    }

    /**
     * Sets items
     *
     * @param \MuxPhp\Models\Metric[]|null $items items
     *
     * @return self
     */
    public function setItems($items)
    {

        if (is_null($items)) {
            throw new \InvalidArgumentException('non-nullable items cannot be null');
        }

        $this->container['items'] = $items;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString(): string
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue(): string
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


