<?php
/**
 * CreateAssetRequest
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  MuxPhp
 * @author   Mux API team
 * @link     https://docs.mux.com
 */

/**
 * Mux API
 *
 * Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.
 *
 * The version of the OpenAPI document: v1
 * Contact: devex@mux.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace MuxPhp\Models;

use \ArrayAccess;
use \MuxPhp\ObjectSerializer;

/**
 * CreateAssetRequest Class Doc Comment
 *
 * @category Class
 * @package  MuxPhp
 * @author   Mux API team
 * @link     https://docs.mux.com
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class CreateAssetRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CreateAssetRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'input' => '\MuxPhp\Models\InputSettings[]',
        'playback_policy' => '\MuxPhp\Models\PlaybackPolicy[]',
        'per_title_encode' => 'bool',
        'passthrough' => 'string',
        'mp4_support' => 'string',
        'normalize_audio' => 'bool',
        'master_access' => 'string',
        'test' => 'bool',
        'max_resolution_tier' => 'string',
        'encoding_tier' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'input' => null,
        'playback_policy' => null,
        'per_title_encode' => 'boolean',
        'passthrough' => null,
        'mp4_support' => null,
        'normalize_audio' => 'boolean',
        'master_access' => null,
        'test' => 'boolean',
        'max_resolution_tier' => null,
        'encoding_tier' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'input' => false,
        'playback_policy' => false,
        'per_title_encode' => false,
        'passthrough' => false,
        'mp4_support' => false,
        'normalize_audio' => false,
        'master_access' => false,
        'test' => false,
        'max_resolution_tier' => false,
        'encoding_tier' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'input' => 'input',
        'playback_policy' => 'playback_policy',
        'per_title_encode' => 'per_title_encode',
        'passthrough' => 'passthrough',
        'mp4_support' => 'mp4_support',
        'normalize_audio' => 'normalize_audio',
        'master_access' => 'master_access',
        'test' => 'test',
        'max_resolution_tier' => 'max_resolution_tier',
        'encoding_tier' => 'encoding_tier'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'input' => 'setInput',
        'playback_policy' => 'setPlaybackPolicy',
        'per_title_encode' => 'setPerTitleEncode',
        'passthrough' => 'setPassthrough',
        'mp4_support' => 'setMp4Support',
        'normalize_audio' => 'setNormalizeAudio',
        'master_access' => 'setMasterAccess',
        'test' => 'setTest',
        'max_resolution_tier' => 'setMaxResolutionTier',
        'encoding_tier' => 'setEncodingTier'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'input' => 'getInput',
        'playback_policy' => 'getPlaybackPolicy',
        'per_title_encode' => 'getPerTitleEncode',
        'passthrough' => 'getPassthrough',
        'mp4_support' => 'getMp4Support',
        'normalize_audio' => 'getNormalizeAudio',
        'master_access' => 'getMasterAccess',
        'test' => 'getTest',
        'max_resolution_tier' => 'getMaxResolutionTier',
        'encoding_tier' => 'getEncodingTier'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const MP4_SUPPORT_NONE = 'none';
    public const MP4_SUPPORT_STANDARD = 'standard';
    public const MP4_SUPPORT_CAPPED_1080P = 'capped-1080p';
    public const MP4_SUPPORT_AUDIO_ONLY = 'audio-only';
    public const MP4_SUPPORT_AUDIO_ONLYCAPPED_1080P = 'audio-only,capped-1080p';
    public const MASTER_ACCESS_NONE = 'none';
    public const MASTER_ACCESS_TEMPORARY = 'temporary';
    public const MAX_RESOLUTION_TIER__1080P = '1080p';
    public const MAX_RESOLUTION_TIER__1440P = '1440p';
    public const MAX_RESOLUTION_TIER__2160P = '2160p';
    public const ENCODING_TIER_SMART = 'smart';
    public const ENCODING_TIER_BASELINE = 'baseline';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getMp4SupportAllowableValues()
    {
        return [
            self::MP4_SUPPORT_NONE,
            self::MP4_SUPPORT_STANDARD,
            self::MP4_SUPPORT_CAPPED_1080P,
            self::MP4_SUPPORT_AUDIO_ONLY,
            self::MP4_SUPPORT_AUDIO_ONLYCAPPED_1080P,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getMasterAccessAllowableValues()
    {
        return [
            self::MASTER_ACCESS_NONE,
            self::MASTER_ACCESS_TEMPORARY,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getMaxResolutionTierAllowableValues()
    {
        return [
            self::MAX_RESOLUTION_TIER__1080P,
            self::MAX_RESOLUTION_TIER__1440P,
            self::MAX_RESOLUTION_TIER__2160P,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getEncodingTierAllowableValues()
    {
        return [
            self::ENCODING_TIER_SMART,
            self::ENCODING_TIER_BASELINE,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        // MUX: enum hack (self::) due to OAS emitting problems.
        //      please re-integrate with mainline when possible.
        //      src: https://github.com/OpenAPITools/openapi-generator/issues/9038
        $this->setIfExists('input', $data ?? [], null);
        $this->setIfExists('playback_policy', $data ?? [], null);
        $this->setIfExists('per_title_encode', $data ?? [], null);
        $this->setIfExists('passthrough', $data ?? [], null);
        $this->setIfExists('mp4_support', $data ?? [], null);
        $this->setIfExists('normalize_audio', $data ?? [], false);
        $this->setIfExists('master_access', $data ?? [], null);
        $this->setIfExists('test', $data ?? [], null);
        $this->setIfExists('max_resolution_tier', $data ?? [], null);
        $this->setIfExists('encoding_tier', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getMp4SupportAllowableValues();
        if (!is_null($this->container['mp4_support']) && !in_array($this->container['mp4_support'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'mp4_support', must be one of '%s'",
                $this->container['mp4_support'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getMasterAccessAllowableValues();
        if (!is_null($this->container['master_access']) && !in_array($this->container['master_access'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'master_access', must be one of '%s'",
                $this->container['master_access'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getMaxResolutionTierAllowableValues();
        if (!is_null($this->container['max_resolution_tier']) && !in_array($this->container['max_resolution_tier'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'max_resolution_tier', must be one of '%s'",
                $this->container['max_resolution_tier'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getEncodingTierAllowableValues();
        if (!is_null($this->container['encoding_tier']) && !in_array($this->container['encoding_tier'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'encoding_tier', must be one of '%s'",
                $this->container['encoding_tier'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets input
     *
     * @return \MuxPhp\Models\InputSettings[]|null
     */
    public function getInput()
    {
        return $this->container['input'];
    }

    /**
     * Sets input
     *
     * @param \MuxPhp\Models\InputSettings[]|null $input An array of objects that each describe an input file to be used to create the asset. As a shortcut, input can also be a string URL for a file when only one input file is used. See `input[].url` for requirements.
     *
     * @return self
     */
    public function setInput($input)
    {

        if (is_null($input)) {
            throw new \InvalidArgumentException('non-nullable input cannot be null');
        }

        $this->container['input'] = $input;

        return $this;
    }

    /**
     * Gets playback_policy
     *
     * @return \MuxPhp\Models\PlaybackPolicy[]|null
     */
    public function getPlaybackPolicy()
    {
        return $this->container['playback_policy'];
    }

    /**
     * Sets playback_policy
     *
     * @param \MuxPhp\Models\PlaybackPolicy[]|null $playback_policy An array of playback policy names that you want applied to this asset and available through `playback_ids`. Options include: `\"public\"` (anyone with the playback URL can stream the asset). And `\"signed\"` (an additional access token is required to play the asset). If no playback_policy is set, the asset will have no playback IDs and will therefore not be playable. For simplicity, a single string name can be used in place of the array in the case of only one playback policy.
     *
     * @return self
     */
    public function setPlaybackPolicy($playback_policy)
    {

        if (is_null($playback_policy)) {
            throw new \InvalidArgumentException('non-nullable playback_policy cannot be null');
        }

        $this->container['playback_policy'] = $playback_policy;

        return $this;
    }

    /**
     * Gets per_title_encode
     *
     * @return bool|null
     * @deprecated
     */
    public function getPerTitleEncode()
    {
        return $this->container['per_title_encode'];
    }

    /**
     * Sets per_title_encode
     *
     * @param bool|null $per_title_encode per_title_encode
     *
     * @return self
     * @deprecated
     */
    public function setPerTitleEncode($per_title_encode)
    {

        if (is_null($per_title_encode)) {
            throw new \InvalidArgumentException('non-nullable per_title_encode cannot be null');
        }

        $this->container['per_title_encode'] = $per_title_encode;

        return $this;
    }

    /**
     * Gets passthrough
     *
     * @return string|null
     */
    public function getPassthrough()
    {
        return $this->container['passthrough'];
    }

    /**
     * Sets passthrough
     *
     * @param string|null $passthrough Arbitrary user-supplied metadata that will be included in the asset details and related webhooks. Can be used to store your own ID for a video along with the asset. **Max: 255 characters**.
     *
     * @return self
     */
    public function setPassthrough($passthrough)
    {

        if (is_null($passthrough)) {
            throw new \InvalidArgumentException('non-nullable passthrough cannot be null');
        }

        $this->container['passthrough'] = $passthrough;

        return $this;
    }

    /**
     * Gets mp4_support
     *
     * @return string|null
     */
    public function getMp4Support()
    {
        return $this->container['mp4_support'];
    }

    /**
     * Sets mp4_support
     *
     * @param string|null $mp4_support Specify what level of support for mp4 playback.  * The `capped-1080p` option produces a single MP4 file, called `capped-1080p.mp4`, with the video resolution capped at 1080p. This option produces an `audio.m4a` file for an audio-only asset. * The `audio-only` option produces a single M4A file, called `audio.m4a` for a video or an audio-only asset. MP4 generation will error when this option is specified for a video-only asset. * The `audio-only,capped-1080p` option produces both the `audio.m4a` and `capped-1080p.mp4` files. Only the `capped-1080p.mp4` file is produced for a video-only asset, while only the `audio.m4a` file is produced for an audio-only asset.  The `standard`(deprecated) option produces up to three MP4 files with different levels of resolution (`high.mp4`, `medium.mp4`, `low.mp4`, or `audio.m4a` for an audio-only asset).  MP4 files are not produced for `none` (default).  In most cases you should use our default HLS-based streaming playback (`{playback_id}.m3u8`) which can automatically adjust to viewers' connection speeds, but an mp4 can be useful for some legacy devices or downloading for offline playback. See the [Download your videos guide](https://docs.mux.com/guides/enable-static-mp4-renditions) for more information.
     *
     * @return self
     */
    public function setMp4Support($mp4_support)
    {
        $allowedValues = $this->getMp4SupportAllowableValues();
        if (!is_null($mp4_support) && !in_array($mp4_support, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'mp4_support', must be one of '%s'",
                    $mp4_support,
                    implode("', '", $allowedValues)
                )
            );
        }

        if (is_null($mp4_support)) {
            throw new \InvalidArgumentException('non-nullable mp4_support cannot be null');
        }

        $this->container['mp4_support'] = $mp4_support;

        return $this;
    }

    /**
     * Gets normalize_audio
     *
     * @return bool|null
     */
    public function getNormalizeAudio()
    {
        return $this->container['normalize_audio'];
    }

    /**
     * Sets normalize_audio
     *
     * @param bool|null $normalize_audio Normalize the audio track loudness level. This parameter is only applicable to on-demand (not live) assets.
     *
     * @return self
     */
    public function setNormalizeAudio($normalize_audio)
    {

        if (is_null($normalize_audio)) {
            throw new \InvalidArgumentException('non-nullable normalize_audio cannot be null');
        }

        $this->container['normalize_audio'] = $normalize_audio;

        return $this;
    }

    /**
     * Gets master_access
     *
     * @return string|null
     */
    public function getMasterAccess()
    {
        return $this->container['master_access'];
    }

    /**
     * Sets master_access
     *
     * @param string|null $master_access Specify what level (if any) of support for master access. Master access can be enabled temporarily for your asset to be downloaded. See the [Download your videos guide](https://docs.mux.com/guides/enable-static-mp4-renditions) for more information.
     *
     * @return self
     */
    public function setMasterAccess($master_access)
    {
        $allowedValues = $this->getMasterAccessAllowableValues();
        if (!is_null($master_access) && !in_array($master_access, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'master_access', must be one of '%s'",
                    $master_access,
                    implode("', '", $allowedValues)
                )
            );
        }

        if (is_null($master_access)) {
            throw new \InvalidArgumentException('non-nullable master_access cannot be null');
        }

        $this->container['master_access'] = $master_access;

        return $this;
    }

    /**
     * Gets test
     *
     * @return bool|null
     */
    public function getTest()
    {
        return $this->container['test'];
    }

    /**
     * Sets test
     *
     * @param bool|null $test Marks the asset as a test asset when the value is set to true. A Test asset can help evaluate the Mux Video APIs without incurring any cost. There is no limit on number of test assets created. Test asset are watermarked with the Mux logo, limited to 10 seconds, deleted after 24 hrs.
     *
     * @return self
     */
    public function setTest($test)
    {

        if (is_null($test)) {
            throw new \InvalidArgumentException('non-nullable test cannot be null');
        }

        $this->container['test'] = $test;

        return $this;
    }

    /**
     * Gets max_resolution_tier
     *
     * @return string|null
     */
    public function getMaxResolutionTier()
    {
        return $this->container['max_resolution_tier'];
    }

    /**
     * Sets max_resolution_tier
     *
     * @param string|null $max_resolution_tier Max resolution tier can be used to control the maximum `resolution_tier` your asset is encoded, stored, and streamed at. If not set, this defaults to `1080p`.
     *
     * @return self
     */
    public function setMaxResolutionTier($max_resolution_tier)
    {
        $allowedValues = $this->getMaxResolutionTierAllowableValues();
        if (!is_null($max_resolution_tier) && !in_array($max_resolution_tier, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'max_resolution_tier', must be one of '%s'",
                    $max_resolution_tier,
                    implode("', '", $allowedValues)
                )
            );
        }

        if (is_null($max_resolution_tier)) {
            throw new \InvalidArgumentException('non-nullable max_resolution_tier cannot be null');
        }

        $this->container['max_resolution_tier'] = $max_resolution_tier;

        return $this;
    }

    /**
     * Gets encoding_tier
     *
     * @return string|null
     */
    public function getEncodingTier()
    {
        return $this->container['encoding_tier'];
    }

    /**
     * Sets encoding_tier
     *
     * @param string|null $encoding_tier The encoding tier informs the cost, quality, and available platform features for the asset. By default the `smart` encoding tier is used. [See the guide for more details.](https://docs.mux.com/guides/use-encoding-tiers)
     *
     * @return self
     */
    public function setEncodingTier($encoding_tier)
    {
        $allowedValues = $this->getEncodingTierAllowableValues();
        if (!is_null($encoding_tier) && !in_array($encoding_tier, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'encoding_tier', must be one of '%s'",
                    $encoding_tier,
                    implode("', '", $allowedValues)
                )
            );
        }

        if (is_null($encoding_tier)) {
            throw new \InvalidArgumentException('non-nullable encoding_tier cannot be null');
        }

        $this->container['encoding_tier'] = $encoding_tier;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString(): string
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue(): string
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


