import {useMutation} from '@tanstack/react-query';
import {apiClient} from '@common/http/query-client';
import {showHttpErrorToast} from '@common/utils/http/show-http-error-toast';
import {downloadFileFromUrl} from '@common/uploads/utils/download-file-from-url';

interface Payload {
  identifier: string;
  name: string;
}

export function useDownloadErrorLog() {
  return useMutation({
    mutationFn: (payload: Payload) => requestLink(payload),
    onSuccess: (response, props) => {
      downloadFileFromUrl(response.url, props.name);
    },
    onError: err => showHttpErrorToast(err),
  });
}

function requestLink({identifier}: Payload) {
  return apiClient.get(`logs/error/${identifier}/download`).then(r => r.data);
}
