<?php
/**
 * Plugin Name: WooCommerce Notification Premium
 * Plugin URI: http://villatheme.com
 * Description: Increase conversion rate by highlighting other customers that have bought products.
 * Version: 1.6.1
 * Author: Andy Ha (villatheme.com)
 * Author URI: http://villatheme.com
 * Text Domain: woocommerce-notification
 * Copyright 2016-2024 VillaTheme.com. All rights reserved.
 * Requires Plugins: woocommerce
 * Requires PHP: 7.0
 * Requires at least: 5.0
 * Tested up to: 6.7
 * WC requires at least: 5.0
 * WC tested up to: 9.5.1
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define( 'VI_WNOTIFICATION_VERSION', '1.6.1' );

/**
 * Class VI_WNOTIFICATION
 */
class VI_WNOTIFICATION {
    
    public function __construct() {
        add_action( 'plugins_loaded', array( $this, 'init' ) );
        add_action( 'before_woocommerce_init', [ $this, 'custom_order_tables_declare_compatibility' ] );
    }
    
    public function init() {
        $include_dir = plugin_dir_path( __FILE__ ) . 'includes/';
        if ( ! class_exists( 'VillaTheme_Require_Environment' ) ) {
            include_once $include_dir . 'support.php';
        }
        
        $environment = new \VillaTheme_Require_Environment( [
            'plugin_name'     => 'WooCommerce Notification Premium',
            'php_version'     => '7.0',
            'wp_version'      => '5.0',
            'wc_version'      => '7.0',
            'require_plugins' => [
                [
                    'slug' => 'woocommerce',
                    'name' => 'WooCommerce',
                    'file' => 'woocommerce/woocommerce.php',
                    'version' => '7.0',
                ],
            ]
        ] );
        
        if ( $environment->has_error() ) {
            return;
        }
        
        include_once $include_dir . 'define.php';
    }
    
    public function custom_order_tables_declare_compatibility() {
        if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
            \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
        }
    }
    
}

new VI_WNOTIFICATION();