<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class VI_WNOTIFICATION_Admin_Gemini {
	protected $settings;
	protected $api_key;
	protected $ai_gemini_version;
	protected $ai_gemini_model;

	public function __construct() {
		$this->settings          = VI_WNOTIFICATION_Data::get_instance();
		$this->api_key           = $this->settings->get_params( 'ai_gemini_api_key' );
		$this->ai_gemini_version = $this->settings->get_params( 'ai_gemini_version' );
		$this->ai_gemini_model   = $this->settings->get_params( 'ai_gemini_model' );
	}


	public function get_model_list() {
		if ( ! $this->api_key && ! $this->ai_gemini_version ) {
			return false;
		}
		$args = array();
		$url  = "https://generativelanguage.googleapis.com/" . $this->ai_gemini_version . "/models/?key=" . $this->api_key;

		try {

			$r = wp_remote_get( $url, $args );

			$body = wp_remote_retrieve_body( $r );

			$models      = json_decode( $body )->models ?? [];
			$list_models = array();
			if ( ! empty( $models ) ) {
				foreach ( $models as $model ) {
					$list_models[] = [
						'name'        => $model->name,
						'displayName' => $model->displayName,
					];
				}
			}

			return $list_models;

		} catch ( \Exception $e ) {
			return false;
		}

	}

	public function generator( $type = '', $language = '' ) {
		if ( ! $this->api_key && ! $this->ai_gemini_version ) {
			return '';
		}
		if ( ! $type ) {
			return '';
		}
		$key_render = '';
		switch ( $type ) {
			case 'mess_purchase':
				$key_render = $this->settings->get_params( 'ai_gemini_key_purchase_mess' );
				if ( $language ) {
					$key_render = $this->settings->get_params( 'ai_gemini_key_purchase_mess_' . $language );
				}
				break;
			case 'first_name':
				$key_render = $this->settings->get_params( 'ai_gemini_key_virtual_first_name' );
				if ( $language ) {
					$key_render = $this->settings->get_params( 'ai_gemini_key_virtual_first_name_' . $language );
				}
				break;
			case 'city':
				$key_render = $this->settings->get_params( 'ai_gemini_key_virtual_city' );
				if ( $language ) {
					$key_render = $this->settings->get_params( 'ai_gemini_key_virtual_city_' . $language );
				}
				break;
			default:
				break;
		}
		$headers_gemini = [
			'Content-Type' => 'application/json',
		];
		$data_gemini    = [
			"contents" => [
				[
					"parts" => [
						[
							"text" => $key_render
						]
					],
				]
			],
		];
		$args           = [
			'headers' => $headers_gemini,
			'body'    => json_encode( $data_gemini ),
			'timeout' => 120
		];
		try {
			$res = wp_remote_post( 'https://generativelanguage.googleapis.com/' . $this->ai_gemini_version . '/' . $this->ai_gemini_model . ':generateContent?key=' . $this->api_key, $args );

			$body             = wp_remote_retrieve_body( $res );
			$body             = json_decode( $body );
			$candidates       = $body->candidates ?? [];
			$candidates_first = $candidates[0] ?? [];
			$content          = $candidates_first->content ?? [];
			$parts            = $content->parts ?? [];
			$parts_first      = $parts[0] ?? [];

			return $parts_first->text ?? '';
		} catch ( \Exception $e ) {
			return '';
		}

	}


}
