<?php
/**
 * View for course builder.
 *
 * @package Tutor\Views
 * @subpackage Pages
 * @author Themeum <support@themeum.com>
 * @link https://themeum.com
 * @since 3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title><?php esc_html_e( 'Tutor Course Builder', 'tutor' ); ?></title>
	<?php wp_print_styles(); ?>

	<!-- 修改 : 自訂 CSS 樣式 -->
	<style>
		/* 隱藏 傳統模式 的子選單 */
		.tutor-portal-popover .css-1q6auea .css-17mqj93 .css-1rvrtua button:nth-child(3) {
			display: none !important;
		}

		/* 設定網站標誌(LOGO)的尺寸 */
		#tutor-course-builder .css-1ksx181 img {
			max-height: 50px !important;
		}

		/* 隱藏選擇商品(預設直接新增 Woocommerce 商品，不需要選擇其他 Woocommerce 商品) */
		.css-1wap2av:has(+.css-1xhi066) {
			display: none !important;
		}

		/* 文字區域的高度(課程摘要) */
		textarea.css-t5hqk3 {
			height: 500px !important;
		}

		/* 文字區域的高度(我將會學到/目標受眾/教材已包括/要求) */
		textarea.css-1sz1wx {
			height: 150px !important;
		}
	</style>
</head>
<body data-tutor-context="<?php echo is_admin() ? 'backend' : 'frontend'; ?>">
	<div id="tutor-course-builder"></div>
	<?php
		do_action( 'tutor_course_builder_footer' );
		wp_print_footer_scripts();
	?>
</body>
</html>

