<?php
/**
 * Export Template
 *
 * @package TutorPro\Report
 * @author Themeum <support@themeum.com>
 * @link https://themeum.com
 * @since 1.9.9
 */

use \TUTOR_REPORT\Analytics;

$analytics = new Analytics();
$data      = $analytics->analytics_data();
$students  = $data['students'];
$earnings  = $data['earnings'];
$discounts = $data['discounts'];
$refunds   = $data['refunds'];
$disabled  = true;

if ( count( $students ) || count( $earnings ) || count( $discounts ) || count( $refunds ) ) {
	$disabled = false;
}
?>
<div class="analytics-export-wrapper">
	<div class="tutor-row tutor-xg-0">
		<div class="tutor-col-xl">
			<div class="tutor-p-32 tutor-p-xl-64">
				<div class="tutor-fs-3 tutor-fw-medium tutor-color-black">
					<?php esc_html_e( 'Detailed Report of Your Sales & Students', 'tutor-pro' ); ?>
				</div>
				<div class="tutor-fs-6 tutor-color-secondary tutor-mt-16">
					<?php esc_html_e( 'Export to keep a copy of your analytics data.', 'tutor-pro' ); ?>
				</div>
				<div class="tutor-mt-28">
					<button type="button" id="download_analytics" class="<?php esc_attr_e( 'tutor-btn tutor-btn-primary' ); ?>"<?php echo esc_attr( $disabled ? ' disabled' : '' ); ?>>
						<!-- 修改 : 翻譯錯誤
						<i class="tutor-icon-import-o tutor-mr-12"></i> <?php esc_html_e( 'Download CSV' ); ?>
						-->

						<i class="tutor-icon-import-o tutor-mr-12"></i> 下載 CSV
					</button>
				</div>
			</div>
		</div>
		<div class="tutor-col-xl-auto tutor-align-self-end">
			<div class="tutor-d-flex">
				<svg xmlns="http://www.w3.org/2000/svg" width="389" height="269" fill="none"><g clip-path="url(#a)"><path fill="#FDCC40" d="M107 156.46c-7.56-7.8-16.35-14.54-21.81-24.14-.43-.75-.59-1.53-.84-2.32H16.53A7.53 7.53 0 0 0 9 137.52v130.96a7.53 7.53 0 0 0 7.53 7.52h99.94a7.53 7.53 0 0 0 7.53-7.52v-95.33a379.47 379.47 0 0 1-17-16.7Z"/><path fill="#EC8D03" d="M64.5 234a23.5 23.5 0 1 0 0-47 23.5 23.5 0 0 0 0 47Z" opacity=".3"/><path fill="#EC8D03" d="M64.27 197a2.62 2.62 0 0 0-2.62 2.62v14.72l-4.16-3.74a2.77 2.77 0 1 0-3.67 4.15l9.67 8.37c.57.5 1.43.48 1.98-.05l9.48-9.05a2.62 2.62 0 1 0-3.65-3.77l-4.5 4.4.1-15.01a2.62 2.62 0 0 0-2.63-2.64Z"/><path fill="#7B443D" d="M319.4 98.33s-2.34.43-6.43-1.9-9.05-3.94-10.8-3.8c-1.75.15-1.44 1.88 3.05 5.11 4.49 3.23-.55 3.89-.99 4.49-.44.6-1.26 2.24 3.83 1.97 5.09-.28 6.35-.99 7.39-.66 1.04.33 2.9 1.75 2.9 1.75l1.42-.05-.38-6.91Z"/><path fill="#0A4EDC" d="M382.85 63.16s32.1 33.41 40.7 84.18l-30.63.15s.58-15.03-.88-20.13l-40.84.14 2.92-8.75s-19.55 11.82-38.23 7.15l3.5-27.57s22.9 3.21 34.43-8.02c0 0 11.23-11.82 12.84-21.16l16.2-5.99Z"/><path fill="#022E74" d="m366.66 69.15-12.55 49.6s-20.43 12.55-38.23 7.15l3.5-27.57c.01 0 35.6 5.25 47.28-29.18Z"/><path fill="#FEDC7A" d="M392.98 128.51c.41 5.73 1.33 31.77 1.11 54.22 0 .41.18.8.5 1.05l42.28 33.8c.46.36.53 1.03.17 1.5l-6.08 7.53a.98.98 0 0 1-1.29.21c-6.17-3.88-48.88-30.83-51.05-35.57-2.14-4.68-18.37-54.34-21.07-62.6a.89.89 0 0 1 .85-1.16l32.49-.13c.65 0 2.04.5 2.1 1.15Z"/><path fill="#F1B400" d="m370.03 167.64-29.68 82.46a1.82 1.82 0 0 1-1.82 1.2l-9-.54c-1-.06-1.71-1-1.5-1.98l25.85-120.06c.13-.63.67-1.1 1.31-1.12l1.98-.1 12.88 38.64c.17.48.16 1.02-.02 1.5Z"/><path fill="#181338" d="m340.49 249.38.16 11.48c.01.34-.27.75-.61.74l-4.56-.06c-.33-.02-.47-.46-.48-.78v-.49c-.01-.1-.1-.24-.2-.22-1.08.17-6.01.95-7.9.92-1.28-.03-14.79.44-19.6.24a1.62 1.62 0 0 1-.21-3.21c3.62-.67 13.77-3.2 20.83-8.5l12.57-.12Z"/><path fill="#7B443D" d="m370.16 67.87-1.17-6.9s-4.88 5.59-7.7 5.88c-2.8.3-4-2.7-5.8-5.43 0 0-4.92-9.23-3.39-17.04 0 0 6.25-.04 9.39-1.83 0 0 .17-.8 2.47 6.32 0 0 .26-3.53 4.81-1.59 4.7 2-.15 6.99-.15 6.99s.82 2.5 7.51 3.68l3.87 6.2-9.84 3.72Z"/><path fill="#181338" d="M352.1 44.38s-4.4-.5-4.77-5.8c-.36-5.28 7.44-9.4 11.9-2.11 0 0 12.5-6.64 17.64 1.79 0 0 7.15-8 14.48-8.8 7.33-.8 10.9 4.7 10 10.76-.92 6.06-7 9.78-14.85 5.48-7.84-4.3-7.73-3.29-7.73-3.29s5.47 10.76-2.63 15.54c0 0-6.63-.95-7.51-3.69 0 0 3.5-3.83 1.2-6.05-2.3-2.22-5.58-1.35-5.87.66 0 0-1.9-6.1-2.48-6.1-.58 0-1.64 1.61-9.37 1.61Z"/><path fill="#231F20" d="M355.14 51.64c.7 0 .7-1.09 0-1.09s-.7 1.09 0 1.09ZM351.35 52.06c.7 0 .7-1.09 0-1.09s-.7 1.09 0 1.09ZM353.51 53.46l-.3 1.95c-.1.61-.25 1.25-.19 1.88.05.47.25.79.67 1.02.36.2.78.34 1.2.4.4.07.58-.56.17-.63a3.26 3.26 0 0 1-.96-.29.94.94 0 0 1-.35-.25c-.11-.15-.1-.42-.1-.6.02-.53.13-1.06.22-1.59l.26-1.72c.03-.17-.04-.35-.22-.4-.15-.04-.37.06-.4.23ZM358.5 60.53c-.7.56-1.6.9-2.5.94a.33.33 0 0 0-.32.33c0 .17.14.33.32.33a5.23 5.23 0 0 0 2.96-1.14c.14-.11.11-.35 0-.46-.14-.14-.32-.11-.46 0Z"/><path fill="#181338" d="M392.4 126.8c-.04-2.93-.22-5.87-.44-8.8a138.28 138.28 0 0 0-2.38-18.09 55.23 55.23 0 0 0-2.82-9.69c-.13-.32-.66-.18-.53.14 2.33 5.7 3.41 11.91 4.21 17.99a175.72 175.72 0 0 1 1.42 18.46c0 .35.54.35.54 0Z"/><path fill="#F19F00" d="M170.84 59.1s29.15 23.84 34.88 36.9c5.4 12.32 31.98 47.72 42.3 53.8.85.5 1.1 1.6.53 2.4l-4.88 6.98c-.42.61-1.11.98-1.85 1-4.87.13-23.46-.18-34.76-11.59 0 0 2.58-2.93-5.04-19.65s-32.53-55.09-31.18-69.84Z"/><path fill="#7B443D" d="M153.57 57.96c.1.33-.22-9.7-.22-9.7l3.2-6.3s-5.75-2.32-1.66-8.74c0 0 1.1-1.66 3.2-1.55l10.95 27.2-15.47-.91Z"/><path fill="#B7E4FF" d="M170.84 59.1c-.44 1.31 30.3 61.47 30.3 61.47l12.63 27.36-7.27.52s.96 1.76-.8 3.5l-21.12 17.85-10.36-74-10.95-38"/><path fill="#F1B400" d="M141.88 82c-12.45-1.23-16.48-30.52-1.58-27 14.9 3.5 22.97 2.81 22.97 2.81 27.97 87.15 21.3 112 21.3 112l-43.41 2.72S124 162.34 121.5 141.44a67.23 67.23 0 0 1 10.84-45L141.88 82Z"/><path fill="#7B443D" d="M183.9 137.63c.27.1 7.53-1.92 11.25-2.7 4.54-.93 11.05-3.88 19.76-3.94 8.7-.07-6.17 5.64-6.48 8.9-.32 3.28 5.1 2.33 4.01 4.19-1.1 1.86-13.55-.41-15.52-1.1-1.97-.67-6.28.97-6.28.97l-6.74-6.32Z"/><path fill="#F1B400" d="M140.22 94.43a5.43 5.43 0 0 0-4.78 4.78c-1.07 9.35-4.71 24.14-5.14 40.26a22.94 22.94 0 0 0 5.22 15.39c7.15 8.5 18.7 15.26 55.4-8.74.6-.39.77-1.18.4-1.79l-4.22-7.04a1.9 1.9 0 0 0-2.57-.7c-6.08 3.43-16.56 2.53-26.36.23-7.46-1.74-6.31-23.95-7.14-34.11a9.15 9.15 0 0 0-10.18-8.35l-.63.07Z"/><path fill="#7B443D" d="M165.52 50.94s2.2 4.06 8.39 3.4c3.97-.43 6.35-.26 8.07-.85a3.05 3.05 0 0 0 1.95-3.68c-.3-1.11-.63-2.37-.63-2.55 0-.33 1.33-3.31.67-6.74-.67-3.42-3.43-14.48-10.62-23.54 0 0-2.76 2.32-6.52 2.98-3.76.67-6.19 8.62-6.19 8.62s6.86 12.16 5.53 12.72c-1.33.55-3.54 1.65-3.54 1.65l2.9 8Z"/><path fill="#181338" d="M166.41 41.19s1.2-.73-5.77-12.6c0 0 1.7-5.31 4.56-7.65 1.99-1.62 2.04-.64 1.81.02-.05.16.12.3.26.23 1.17-.63 4.38-2.42 6.08-4.21 2.1-2.21.55-5.97-.22-6.3-.77-.34-12.5-1.44-22.44 3.1-9.94 4.53-9.5 12.26-9.28 17.46.22 5.2 1.76 13.04 11.94 17.02l3.2-6.3s-5.6-2.23-1.66-8.74c0 0 1-1.34 3.2-1.54l4.54 11.27 3.78-1.76Z"/><path fill="#231F20" d="M176 30.26v-.02.15-.04a1.84 1.84 0 0 1-.04.1l-.09.1c.01 0 .02 0 .03-.02l-.1.09.03-.03-.13.06a.3.3 0 0 1 .07-.02l-.14.02a.2.2 0 0 1 .08 0l-.15-.02.07.02a1.54 1.54 0 0 1-.13-.06l.04.03-.1-.09.02.03-.09-.11.02.03a1.8 1.8 0 0 0-.05-.13v.04l-.01-.15v.02c0 .08.01.15.04.21a.4.4 0 0 0 .12.18c.04.05.1.09.17.1.07.04.14.06.21.06l.14-.02c.1-.03.18-.07.24-.14l.09-.1a.55.55 0 0 0 .07-.28v-.1l-.01-.08-.01-.03a.7.7 0 0 0-.5-.47.8.8 0 0 0-.22-.03l-.2.03h-.04l-.15.07a.7.7 0 0 0-.15.11l-.07.08-.06.08a.7.7 0 0 0-.08.34c0 .07.01.14.05.2a.42.42 0 0 0 .29.29c.06.04.13.05.2.05l.14-.02c.1-.02.18-.07.24-.14l.1-.1c.05-.1.07-.2.07-.29ZM181.2 29.03h-.1a.39.39 0 0 0-.22.05.4.4 0 0 0-.17.12.4.4 0 0 0-.11.17.43.43 0 0 0-.05.2l.02.15c.02.1.07.17.14.24l.1.09c.09.04.18.07.28.07h.1c.08 0 .15-.01.22-.05a.39.39 0 0 0 .17-.11c.05-.05.1-.1.11-.17a.43.43 0 0 0 .05-.21l-.02-.15a.54.54 0 0 0-.14-.23l-.1-.1a.56.56 0 0 0-.28-.07ZM181.05 33.49c.55.92 1.11 1.83 1.65 2.76.37.64.85 1.8.03 2.32-.36.23-.03.8.33.57.94-.6.89-1.8.47-2.71-.25-.55-.6-1.06-.9-1.57l-1.02-1.7c-.21-.37-.78-.04-.56.33ZM180.86 44.3c1.15.28 2.38.21 3.48-.22.17-.06.28-.21.23-.4-.04-.15-.23-.29-.4-.22-1 .39-2.1.47-3.14.22-.4-.1-.58.52-.17.62Z"/><path fill="#AB573A" d="M173.3 40.2a1.27 1.27 0 1 0 0-2.55 1.27 1.27 0 0 0 0 2.54Z"/><path fill="#000" d="M221.29 92.28c.07-.32-.17-.63-.5-.6-1.04.07-3.3 1.64-5.94 12.07-3.46 13.65-10.03 39.92-10.66 42.49a.5.5 0 0 1-.24.3l-25.41 14.2a8.98 8.98 0 0 0-4.32 5.35c-.4 1.45-.34 2.71 1.18 2.58.07 0 .14-.03.2-.07l32.95-18.88c.42-.24.27-.88-.2-.92a.5.5 0 0 1-.44-.6l13.38-55.92Z"/><path fill="#779ED8" d="m281.46 150.21-31.83 17.1-74.12 1.35 32.12-19.85 73.83 1.4Z"/><path fill="#0A4EDC" d="M207.7 147.92 221 92.68c.11-.47.53-.8 1.02-.78l73.73 1.29c.67.01 1.16.65.98 1.3l-15 55.29c-.1.4-.48.68-.9.67l-72.15-1.26c-.65-.01-1.13-.63-.97-1.27Z"/><path fill="#F1B400" d="M256.38 43h37.24c.76 0 1.38.55 1.38 1.23v31.54c0 .68-.62 1.23-1.38 1.23h-37.24c-.76 0-1.38-.55-1.38-1.23V44.23c0-.68.62-1.23 1.38-1.23Z"/><path fill="#F1B400" d="M255 80.66V75l8.5 2-6.96 4.5a1 1 0 0 1-1.54-.84Z"/><path fill="#F3F7F8" d="M263.83 53.96a1.48 1.48 0 1 0 0-2.96 1.48 1.48 0 0 0 0 2.96ZM263.83 61.96a1.48 1.48 0 1 0 0-2.96 1.48 1.48 0 0 0 0 2.96ZM268.62 53.15h17.42c.74 0 .74-1.15 0-1.15H268.62c-.74 0-.74 1.15 0 1.15ZM268.62 61.15h17.42c.74 0 .74-1.15 0-1.15H268.62c-.74 0-.74 1.15 0 1.15ZM263.83 68.96a1.48 1.48 0 1 0 0-2.96 1.48 1.48 0 0 0 0 2.96ZM268.62 68.15h17.42c.74 0 .74-1.15 0-1.15H268.62c-.74 0-.74 1.15 0 1.15Z"/><path fill="#1AADFF" d="m175.73 158.17 42.8-11.17a77.11 77.11 0 0 0 6.98-2.15c4.02-1.47 12.55-3.7 16.36 1.95 4.59 6.8 31.39 55.3 36.45 64.47.5.9-.17 2.21-.23 3.24-.18 2.99-6.4 4.98-7.94 4.98-2.1 0-40-51.88-40-51.88s-35.87 32.2-65.61 30.8c-22.31-1.06-23.95-17.65-23.38-25.89a6.46 6.46 0 0 1 4.68-5.73l29.89-8.62Z"/><path fill="#022E74" d="M171.41 198.1h-9.26c-45.36-24.98-47.15 0-47.15 0V270h86v-71.89c-17.29-5.65-25.7-2.9-29.59 0Z"/><path stroke="#231F20" stroke-miterlimit="10" d="M230.15 167.61s3.81-4.82 2.36-11.58M141.88 82s10.93 3.02 16.72-1.81M152.32 105.8s5.31 27.04 1.45 35.74M137.35 142.02s1.45 19.33 21.73 11.6"/><path stroke="#181338" stroke-miterlimit="10" d="M171.8 207.72s-9.82-13.85-31.07-19"/><path stroke="#000" stroke-miterlimit="10" d="M394.05 171.83s1.7 16.56-5.95 20.8"/><path fill="#181238" d="M270.68 217.6s5.62-2.26 5.57-10.58c0 0 3.61.16 6.91.75 2.96.54 13.98.1 18.46-.12a9.78 9.78 0 0 0 3.58-.86c1.56-.7 3.69-2.03 4.46-1.97 1.53.11 2.5 2.45 3.29 3.86.24.43.13.94-.23 1.14L276 229.4c-.83.44-1.92.04-2.5-.92-1.55-2.6-5.2-7.95-4.63-10.4a.5.5 0 0 1 .46-.4l1.35-.09Z"/><path fill="#0092D3" d="m185 195.08 38.85-.34c.6 0 1.21-.06 1.81-.1.76-.04 2.3.48 2.56 5.34.32 5.92 5.33 52 6.18 59.77.06.6.63.99 1.21.84l10.03-2.58a1.5 1.5 0 0 0 1.12-1.46l-.7-76.52s-.16-5.94-15.24-12.14c-.42-.18-.9-.13-1.28.11-5.33 3.37-43.72 27.57-44.54 27.08Z"/><path fill="#181238" d="M235.25 256.9s7.75.48 11.48-6.96c0 0 3.14 1.78 5.81 3.8 2.4 1.83 12.42 6.42 16.52 8.25 1.15.52 2.36.8 3.58.86 1.72.07 4.2-.14 4.87.26 1.3.8 1.12 4.18 1.18 5.79.02.49-.3.9-.72.9l-41.6-.02c-.94.02-1.73-.84-1.81-1.95-.21-3.03-2.75-9.4-1.14-11.32a.5.5 0 0 1 .6-.14l1.23.53Z"/><path fill="#EC8D03" d="m84 172.12.35-42.12L124 173l-39.39-.25a.62.62 0 0 1-.61-.63Z"/></g><defs><clipPath id="a"><path fill="#fff" d="M0 0h572v287.95H0z"/></clipPath></defs></svg>
			</div>
		</div>
	</div>
</div>
