var cp_loadingpage = cp_loadingpage || {};
cp_loadingpage.graphics = cp_loadingpage.graphics || {};
cp_loadingpage.graphics['centered_bar'] = {
	created: false,
	attr   : {},
	create : function(opt){
		function ColorLuminance(hex, lum) {
			hex = String(hex).replace(/[^0-9a-f]/gi, '');
			if (hex.length < 6) {
				hex = hex[0]+hex[0]+hex[1]+hex[1]+hex[2]+hex[2];
			}
			lum = lum || 0;
			var rgb = "#", c, i;
			for (i = 0; i < 3; i++) {
				c = parseInt(hex.substr(i*2,2), 16);
				c = Math.round(Math.min(Math.max(0, c + (c * lum)), 255)).toString(16);
				rgb += ("00"+c).substr(c.length);
			}
			return rgb;
		};
		opt.backgroundColor = opt.backgroundColor || "#000000";
		opt.height          = opt.height || 1;
		opt.foregroundColor = opt.foregroundColor || "#FFFFFF";

		var css_o = {
			width: "100%",
			height: "100%",
			backgroundColor: opt.backgroundColor,
			position: "fixed",
			zIndex: 666999,
			top: 0,
			left: 0
		};

		if( opt[ 'backgroundImage' ] ){
			css_o['backgroundImage']  = 'url('+opt[ 'backgroundImage' ]+')';
			css_o['background-repeat'] = opt[ 'backgroundRepeat' ];
			css_o['background-position'] = 'center center';

			if(
				css_o['background-repeat'].toLowerCase() == 'no-repeat' &&
				typeof opt['fullscreen'] !== 'undefined' &&
				opt['fullscreen']*1 == 1
			)
			{
				css_o[ "background-attachment" ] = "fixed";
				css_o[ "-webkit-background-size" ] = "contain";
				css_o[ "-moz-background-size" ] = "contain";
				css_o[ "-o-background-size" ] = "contain";
				css_o[ "background-size" ] = "contain";
			}
		}

		this.attr['overlay'] = jQuery("<div id='loading_page_overlay' class='lp-screen'></div>").css(css_o).appendTo("html");

		opt.foregroundColorB = ColorLuminance( opt.foregroundColor, -0.4 );
		jQuery(
			"<style>"+
			"#loading_page_overlay progress {"+
			"	background-color: #999999;"+
			"	border: 0;"+
			"	width: 80%;"+
			"	height: 10px;"+
			"	border-radius: 9px;"+
			"}"+
			"#loading_page_overlay progress::-webkit-progress-bar {"+
			"	background-color: #999999;"+
			"	border-radius: 9px;"+
			"}"+
			"#loading_page_overlay progress::-webkit-progress-value {"+
			"	background: "+opt.foregroundColor+";"+
			"	background: -moz-linear-gradient(top,  "+opt.foregroundColor+" 0%, "+opt.foregroundColorB+" 100%);"+
			"	background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,"+opt.foregroundColor+"), color-stop(100%,"+opt.foregroundColorB+"));"+
			"	background: -webkit-linear-gradient(top,  "+opt.foregroundColor+" 0%,"+opt.foregroundColorB+" 100%);"+
			"	background: -o-linear-gradient(top,  "+opt.foregroundColor+" 0%,"+opt.foregroundColorB+" 100%);"+
			"	background: -ms-linear-gradient(top,  "+opt.foregroundColor+" 0%,"+opt.foregroundColorB+" 100%);"+
			"	background: linear-gradient(to bottom,  "+opt.foregroundColor+" 0%,"+opt.foregroundColorB+" 100%);"+
			"	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='"+opt.foregroundColor+"', endColorstr='"+opt.foregroundColorB+"',GradientType=0 );"+
			"	border-radius: 9px;"+
			"}"+
			"#loading_page_overlay progress::-moz-progress-bar {"+
			"	background: "+opt.foregroundColor+";"+
			"	background: -moz-linear-gradient(top,  "+opt.foregroundColor+" 0%, "+opt.foregroundColorB+" 100%);"+
			"	background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,"+opt.foregroundColor+"), color-stop(100%,"+opt.foregroundColorB+"));"+
			"	background: -webkit-linear-gradient(top,  "+opt.foregroundColor+" 0%,"+opt.foregroundColorB+" 100%);"+
			"	background: -o-linear-gradient(top,  "+opt.foregroundColor+" 0%,"+opt.foregroundColorB+" 100%);"+
			"	background: -ms-linear-gradient(top,  "+opt.foregroundColor+" 0%,"+opt.foregroundColorB+" 100%);"+
			"	background: linear-gradient(to bottom,  "+opt.foregroundColor+" 0%,"+opt.foregroundColorB+" 100%);"+
			"	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='"+opt.foregroundColor+"', endColorstr='"+opt.foregroundColorB+"',GradientType=0 );"+
			"	border-radius: 9px;"+
			"}"+
			"</style>"
		).appendTo( 'html' );

		this.attr['bar'] = jQuery('<progress value="0" max="100" class="lp-screen-graphic"></progress>').css({
			marginTop: "-" + (opt.height / 2) + "px",
			width: "50%",
			marginLeft: "25%",
			position: "absolute",
			top: "50%"
		}).appendTo(this.attr['overlay']);

		if (opt.text) {
			this.attr['text'] = jQuery("<div class='lp-screen-text'></div>").text("0%").css({
				height: "40px",
				width: "100px",
				position: "absolute",
				fontSize: "3em",
				top: "50%",
				left: "50%",
				marginTop: "-" + (59 + opt.height) + "px",
				textAlign: "center",
				marginLeft: "-50px",
				color: opt.foregroundColor
			}).appendTo(this.attr['overlay']);
		}
		this.created = true;
	},

	set : function(percentage){
		this.attr['bar'].val(percentage);

		if (this.attr['text']) {
			this.attr['text'].text(Math.ceil(percentage) + "%");
		}
	},

	complete : function(callback){
		callback();
		var me = this;
		this.attr['overlay'].fadeOut(1500, function () {
			me.attr['overlay'].remove();
		});
	}
};