<?php
   $course_id = get_the_ID();
   $tutor_lesson_count = tutor_utils()->get_lesson_count_by_course($course_id);
   $tutor_course_duration = get_tutor_course_duration_context($course_id);
   $maximum_students = tutor_utils()->get_course_settings($course_id, 'maximum_students');
   $certificate = tutor_utils()->get_course_settings($course_id, 'certificate');
   $language = tutor_utils()->get_course_settings($course_id, 'language');
?>
<div class="course-single-meta">
   <!-- 等級 -->
   <div class="meta-item">
      <span class="icon"><i class="far fa-flag"></i></span>
      <span>
         <?php echo esc_html__('Level:', 'zilom') ?> 
         <span class="value"><?php echo get_tutor_course_level() ?></span>
      </span>
   </div>

   <!-- 時數 -->
   <div class="meta-item">
      <span class="icon"><i class="far fa-clock"></i></span>
      <span>
         <?php echo esc_html__('Durations:', 'zilom') ?>
         <span class="value"><?php echo trim($tutor_course_duration) ?></span>
      </span>
   </div>

   <!-- 單元 -->
   <div class="meta-item">
      <span class="icon"><i class="far fa-folder-open"></i></span>
      <span>
         <?php echo esc_html__('Lectures:', 'zilom') ?>
         <span class="value"><?php echo esc_html($tutor_lesson_count) ?></span>
      </span>
   </div>
   
   <!-- 學生 -->
   <div class="meta-item">
      <span class="icon"><i class="far fa-user-circle"></i></span>
      <span>
         <?php echo esc_html__('Students:', 'zilom') ?>

         <!-- 修改 : 格式錯誤
         <span class="value"><?php //echo esc_html__('Max', 'zilom') ?> <?php //echo esc_attr($maximum_students) ?></span>
         -->

         <span class="value">
            <?php
            if($maximum_students == 0) {
               echo esc_html__('No limit', 'zilom');
            } else {
               echo esc_html__('Max', 'zilom') . ' ' . esc_attr($maximum_students);
            }
            ?>
         </span>
      </span>
   </div>
   
   <!-- 修改 : 隱藏語言 (新版 Tutor LMS 3 已取消)
   <div class="meta-item">
      <span class="icon"><i class="fas fa-language"></i></span>
      <span>
         <?php //echo esc_html__('Language:', 'zilom') ?> 
         <span class="value"><?php //echo esc_html($language) ?></span>
      </span>
   </div>
   -->
   
   <!-- 修改 : 隱藏證書 (新版 Tutor LMS 3 已取消)
   <div class="meta-item">
      <span class="icon"><i class="fas fa-certificate"></i></span>
      <span>
         <?php //echo esc_html__('Certificate:', 'zilom') ?> 
         <span class="value"><?php //echo esc_html($certificate) ?></span>
      </span>
   </div>
   -->
</div>