var cp_loadingpage = cp_loadingpage || {};
cp_loadingpage.graphics = cp_loadingpage.graphics || {};
cp_loadingpage.graphics['double_ring'] = {
	created: false,
	attr   : {},
	create : function(opt){
		function ColorLuminance(hex, lum) {
			hex = String(hex).replace(/[^0-9a-f]/gi, '');
			if (hex.length < 6) {
				hex = hex[0]+hex[0]+hex[1]+hex[1]+hex[2]+hex[2];
			}
			lum = lum || 0;
			var rgb = "#", c, i;
			for (i = 0; i < 3; i++) {
				c = parseInt(hex.substr(i*2,2), 16);
				c = Math.round(Math.min(Math.max(0, c + (c * lum)), 255)).toString(16);
				rgb += ("00"+c).substr(c.length);
			}
			return rgb;
		};
		opt.backgroundColor = opt.backgroundColor || "#000000";
		opt.foregroundColor = opt.foregroundColor || "#FFFFFF";
		opt.foregroundColorB = ColorLuminance( opt.foregroundColor, -0.6 );

		this.attr['foreground'] = opt.foregroundColor;
		this.attr['foregroundB'] = opt.foregroundColorB;

		var css_o = {
			width: "100%",
			height: "100%",
			backgroundColor: opt.backgroundColor,
			position: "fixed",
			zIndex: 666999,
			top: 0,
			left: 0
		};

		if( opt[ 'backgroundImage' ] ){
			css_o['backgroundImage']  = 'url('+opt[ 'backgroundImage' ]+')';
			css_o['background-repeat'] = opt[ 'backgroundRepeat' ];
			css_o['background-position'] = 'center center';

			if(
				css_o['background-repeat'].toLowerCase() == 'no-repeat' &&
				typeof opt['fullscreen'] !== 'undefined' &&
				opt['fullscreen']*1 == 1
			)
			{
				css_o[ "background-attachment" ] = "fixed";
				css_o[ "-webkit-background-size" ] = "contain";
				css_o[ "-moz-background-size" ] = "contain";
				css_o[ "-o-background-size" ] = "contain";
				css_o[ "background-size" ] = "contain";
			}
		}

		this.attr['overlay'] = jQuery("<div class='lp-screen'></div>").css(css_o).appendTo("html");

		if (opt.text) {
			this.attr['text'] = jQuery("<div class='lp-screen-text'></div>").text("0%").css({
				lineHeight: "40px",
				height: "40px",
				width: "100px",
				position: "absolute",
				fontSize: "32px",
				top: this.attr['overlay'].height()/2-20,
				left: this.attr['overlay'].width()/2-50,
				textAlign: "center",
				color: opt.foregroundColor
			}).appendTo(this.attr['overlay']);
		}

		jQuery("<div class='lp-screen-graphic'><canvas></canvas></div>").css({
			position: "absolute",
			top: this.attr['overlay'].height()/2-150,
			left:this.attr['overlay'].width()/2-150,
		}).appendTo(this.attr['overlay']);

		this.attr['canvas']  = this.attr['overlay'].find('canvas')[0];

		this.attr['canvas'].height = 300;
		this.attr['canvas'].width = 300;

		this.attr['ctx'] = this.attr['canvas'].getContext("2d");
		this.attr['previous'] = 0;
		this.set(0);
		this.created = true;
	},

	set : function(percentage){
		this.attr[ 'next' ] = Math.floor(percentage*3.6);

		for( $i = this.attr['previous']; $i <= this.attr[ 'next' ]; $i++ ){
			this._draw();
		}

		if (this.attr['text']) {
			this.attr['text'].text(Math.ceil(percentage) + "%");
		}
	},

	_draw : function(){
		if( this.attr[ 'previous' ] > this.attr[ 'next' ]){
			return
		};

		var ctx      = this.attr['ctx'],
			e, s;

		s = this.attr['previous'];
		e = this.attr['previous']+1;
		this.attr['previous'] += 1;

		ctx.save();

		// line out
		ctx.beginPath();
		ctx.strokeStyle = this.attr['foreground'];
		ctx.lineWidth = 15;
		ctx.arc(150, 150, 80, (Math.PI/180)*s, (Math.PI/180)*e, false);
		ctx.stroke();

		// line in
		ctx.beginPath();
		ctx.strokeStyle = this.attr['foregroundB'];
		ctx.lineWidth = 10;
		ctx.arc(150, 150, 60, -1*(Math.PI/180)*s, -1*(Math.PI/180)*e, true);
		ctx.stroke();

	},

	complete : function(callback){
		if(this.attr['previous'] < 360){
			this.attr['next'] = 360;
			for( $i = this.attr['previous']; $i <= 360; $i++ ){
				this._draw();
			}
		}
		callback();
		var me = this;
		this.attr['overlay'].fadeOut(1500, function () {
			me.attr['overlay'].remove();
		});
	}
};