<?php isset($check_system_key) or exit('No direct script access allowed'); // Framework - AhWei - fezexp9987@gmail.com - line: fezexp

use Illuminate\Container\Container;
use Illuminate\Events\Dispatcher;
use Illuminate\Support\Facades\Facade;
use Illuminate\Config\Repository as Config;
use Illuminate\Http\Request;

$app = new Container();
$app['config'] = new Config();
$app['request'] = Request::capture();
$app['path.lang'] = __DIR__ . '/lang';

foreach (config('system.config_load') as $prefix => $config) {
	foreach (config($config) as $key => $value) {
		$app['config'][$prefix .'.'. $key] = $value;
	}
}

foreach (config('system.providers_register') as $provider) {
	with(new $provider($app))->register();
}

Facade::setFacadeApplication($app);

foreach (config('system.aliases') as $key => $alias) {
	class_alias($alias, $key);
}

Eloquent::setConnectionResolver($app['db']);
Eloquent::setEventDispatcher($app['events']);