<?php

// 路由 - 只接受三個參數 0 => Http Method , 2 => 控制器@方法 , 3 => 中介層 (陣列 可多個)
// 路由路徑 - 帶入控制器方法的參數 請務必用 {} 包起來, 以搜尋 " /{ " 來判斷後面的全都是參數

return [
	// 工具
		# 驗證器
	['tool-ajax-validate' => ['any', 'ToolController@ajax_validate'] ],
		# 暫存輸入資料
	['tool-ajax-temp-input' => ['any', 'ToolController@ajax_temp_input'] ],
		# 驗證碼
	['tool-captcha'       => ['get', 'ToolController@captcha'] ],
	 	# 檔案下載
	['tool-download/{table}/{column}/{id}' => ['get', 'ToolController@download'] ],
	['tool-download/{table}/{column}/{id}/{inline_name}' => ['get', 'ToolController@download'] ],

	// 圖片編輯器
	['image-editor/{image_url}' => ['get', 'ImageEditorController@index'] ],
	['image-editor/save'        => ['post', 'ImageEditorController@save'] ],

	// 資料庫遷移
	['migrations/up/{key}'    => ['get', 'MigrationsController@up'] ],
	['migrations/down/{key}'  => ['get', 'MigrationsController@down'] ],
	['migrations/check/{key}' => ['get', 'MigrationsController@check'] ],

	// sitemap
	['sitemap' => ['get', 'Web\SitemapController@process'] ],

	// 首頁
	['/'     => ['get', 'Web\IndexController@index'] ],
	['index' => ['get', 'Web\IndexController@index'] ],

 	// 公司介紹
	['about'      => ['get', 'Web\AboutController@detail'] ],
	['about/{id}' => ['get', 'Web\AboutController@detail'] ],

 	// 健康能量木地板
	['floors'      => ['get', 'Web\FloorsController@detail'] ],
	['floors/{id}' => ['get', 'Web\FloorsController@detail'] ],

 	// 產品
	['product'      => ['get', 'Web\ProductController@index'] ],
	['product/{id}' => ['get', 'Web\ProductController@detail'] ],
	['product/ajax/data'                   => ['get', 'Web\ProductController@ajax_get_data'] ],
	['product/ajax/search_attribute'       => ['post', 'Web\ProductController@ajax_search_attribute_add_and_del'] ],
	['product/ajax/search_attribute/reset' => ['delete', 'Web\ProductController@ajax_search_attribute_reset'] ],
	['product/ajax/search_attribute/init'  => ['get', 'Web\ProductController@ajax_search_attribute_init'] ],
	['product/ajax/search_attribute/init'  => ['post', 'Web\ProductController@ajax_search_attribute_init'] ],

	// 修改 : 新增 產品彈出視窗
	['popup'                  => ['get', 'Web\ProductController@popup'] ],
	['product/ajax/datapopup' => ['get', 'Web\ProductController@ajax_get_datapopup'] ],

	// 修改 : 新增 產品比較
	['compare' => ['get', 'Web\ProductController@compare'] ],

	// 修改 : 新增 Roomvo
	['roomvo' => ['get', 'Web\ProductController@roomvo'] ],

	// 修改 : 新增 即時報價
	['quote'         => ['get', 'Web\ProductController@quote'] ],   // 表單頁面
	['quote/success' => ['get', 'Web\ProductController@success'] ], // 完成頁面
	
	// 修改 : 新增 預約鑑賞
	['service/reserve'         => ['get', 'Web\ServiceReserveController@index'] ],   // 表單頁面
	['service/reserve/check'   => ['get', 'Web\ServiceReserveController@check'] ],   // 確認頁面
	['service/reserve/success' => ['get', 'Web\ServiceReserveController@success'] ], // 完成頁面

	// 修改 : 新增 線上展間
	['room'   => ['get', 'Web\RoomController@index'] ],
	['room01' => ['get', 'Web\RoomController@room01'] ], // 查看新品櫥窗
	['room02' => ['get', 'Web\RoomController@room02'] ], // 查看周邊商品
	['room03' => ['get', 'Web\RoomController@room03'] ], // 展示架陳列 - 經典希臘系列
	['room04' => ['get', 'Web\RoomController@room04'] ], // 展示架陳列 - 古查爾斯頓系列
	['room05' => ['get', 'Web\RoomController@room05'] ], // 展示架陳列 - 樂活臺北系列
	['room06' => ['get', 'Web\RoomController@room06'] ], // 展示架陳列 - 巴黎輕法系列
	['room07' => ['get', 'Web\RoomController@room07'] ], // 展示架陳列 - 經典普拉斯系列
	['room08' => ['get', 'Web\RoomController@room08'] ], // 展示架陳列 - 工匠典藏系列
	['room09' => ['get', 'Web\RoomController@room09'] ], // 展示架陳列 - 卡扣系列
	['room10' => ['get', 'Web\RoomController@room10'] ], // 展示架陳列 - 熱帶森林系列
	['room11' => ['get', 'Web\RoomController@room11'] ], // 樣品索取
	['room12' => ['get', 'Web\RoomController@room12'] ], // 施工介紹
	['room13' => ['get', 'Web\RoomController@room13'] ], // 遠紅外線介紹
	
	['room20' => ['get', 'Web\RoomController@room20'] ], // 商品介紹


	// 場景
	// ['theme'                     => ['get', 'Web\ThemeController@index'] ],
	// ['theme/{product_id}'        => ['get', 'Web\ThemeController@index'] ],
	// ['theme/{product_id}/{theme_id}/{degree}' => ['get', 'Web\ThemeController@index'] ],	

	// ['theme/ajax/get_theme'      => ['post', 'Web\ThemeController@ajax_get_theme'] ],
	// ['theme/ajax/search_product' => ['post', 'Web\ThemeController@ajax_search'] ],
	// ['theme/ajax/save_pic'       => ['get', 'Web\ThemeController@ajax_save_pic'] ],
	// ['theme/ajax/save_pic'       => ['post', 'Web\ThemeController@ajax_save_pic'] ],

 	// 專案實績
	['case'      => ['get', 'Web\CaseController@index'] ],
	['case/{id}' => ['get', 'Web\CaseController@detail'] ],
	['case/ajax/data'                   => ['get', 'Web\CaseController@ajax_get_data'] ],
	['case/ajax/search_attribute'       => ['post', 'Web\CaseController@ajax_search_attribute_add_and_del'] ],
	['case/ajax/search_attribute/reset' => ['delete', 'Web\CaseController@ajax_search_attribute_reset'] ],
	['case/ajax/search_attribute/init'  => ['get', 'Web\CaseController@ajax_search_attribute_init'] ],
	['case/ajax/search_attribute/init'  => ['post', 'Web\CaseController@ajax_search_attribute_init'] ],

	// 影音訊息
	['video'                         => ['get', 'Web\VideoController@index'] ],
	['video/{level_1_class_id}'      => ['get', 'Web\VideoController@list'] ],
	['video/{level_1_class_id}/{id}' => ['get', 'Web\VideoController@detail'] ],

	// 客戶服務 - 門市據點
	['service/store'                    => ['get', 'Web\ServiceStoreController@index'] ],
	['service/store/{level_1_class_id}' => ['get', 'Web\ServiceStoreController@index'] ],

	// 客戶服務 - 檔案下載
	['service/download'                    => ['get', 'Web\ServiceDownloadController@index'] ],
	['service/download/{level_1_class_id}' => ['get', 'Web\ServiceDownloadController@index'] ],

	// 客戶服務 - 聯絡我們
	['service/contact' => ['get', 'Web\ServiceContactController@index'] ],
	['service/contact' => ['post', 'Web\ServiceContactController@add'] ],

	// 木學堂百科 - 常見問題
	['library/faq' => ['get', 'Web\LibraryFaqController@index'] ],

 	// 木學堂百科 - 百科文章
	['library/article'                         => ['get', 'Web\LibraryArticleController@index'] ],
	['library/article/{level_1_class_id}'      => ['get', 'Web\LibraryArticleController@index'] ],
	['library/article/{level_1_class_id}/{id}' => ['get', 'Web\LibraryArticleController@detail'] ],

	// 購物車 - 訂單
	['order/step1'             => ['get', 'Web\CargoOrderController@step1', ['member'] ] ],
	['order/step2'             => ['any', 'Web\CargoOrderController@step2', ['member'] ] ],
	['order/step2/{back_code}' => ['any', 'Web\CargoOrderController@step2', ['member'] ] ],
	['order/process'           => ['post', 'Web\CargoOrderController@process', ['member'] ] ],

	// 購物車
	['cargo/ajax/cart/{get}' => ['get', 'Web\CargoAjaxController@get'] ],
	['cargo/ajax/cart'       => ['post', 'Web\CargoAjaxController@add'] ],
	['cargo/ajax/cart'       => ['patch', 'Web\CargoAjaxController@upd'] ],
	['cargo/ajax/cart'       => ['delete', 'Web\CargoAjaxController@del'] ],

	// ['test'      => ['get', 'Api\TestController@test' ] ],
];