<?php

// 路由 - 只接受三個參數 0 => Http Method , 2 => 控制器@方法 , 3 => 中介層 (陣列 可多個)
// 路由路徑 - 帶入控制器方法的參數 請務必用 {} 包起來, 以搜尋 " /{ " 來判斷後面的全都是參數

return [
 	// 會員
	['member/login'            => ['get', 'Member\LoginController@index', ['member.guest'] ] ],
	['member/login'            => ['post', 'Member\LoginController@login', ['member.guest'] ] ],
	['member/logout'           => ['get', 'Member\LoginController@logout'] ],
	['member/register'         => ['get', 'Member\RegisterController@index', ['member.guest'] ] ],
	['member/register'         => ['post', 'Member\RegisterController@register', ['member.guest'] ] ],
	['member/forget'           => ['get', 'Member\ForgetPasswordController@index', ['member.guest'] ] ],
	['member/forget'           => ['post', 'Member\ForgetPasswordController@send_mail', ['member.guest'] ] ],

	['member'             => ['get', 'Member\DataController@index', ['member'] ] ],
	['member/index'       => ['get', 'Member\DataController@index', ['member'] ] ],
	// ['member/data'     => ['get', 'Member\DataController@show_upd', ['member'] ] ],
	['member/data'        => ['patch', 'Member\DataController@upd', ['member'] ] ],
	// ['member/password' => ['get', 'Member\DataController@show_upd_pw', ['member'] ] ],
	['member/password'    => ['patch', 'Member\DataController@upd_pw', ['member'] ] ],

	['member/order'                   => ['any', 'Member\DataController@show_order', ['member'] ] ],
	['member/order/{oid}/{back_code}' => ['get', 'Member\DataController@show_order_detail', ['member'] ] ],
	['member/order/payment/{oid}' => ['get', 'Member\DataController@member_order_payment', ['member'] ] ],
	// ['member/order/cancel/{oid}' => ['patch', 'Member\DataController@member_order_cancel_process', ['member'] ] ],

 	// 會員 - 公佈欄
	['member/news'      => ['get', 'Member\NewsController@index', ['member'] ] ],
	['member/news/{id}' => ['get', 'Member\NewsController@detail', ['member'] ] ],

	// 會員 - 下載型錄
	['member/download'                    => ['get', 'Member\DownloadController@index', ['member'] ] ],
	['member/download/{level_1_class_id}' => ['get', 'Member\DownloadController@index', ['member'] ] ],
	['member/download/process/{id}'       => ['get', 'Member\DownloadController@process', ['member'] ] ],

	// 會員 - 特殊檔案下載
	['member/special_download/{code}' => ['get', 'Member\SpecialDownloadController@process', ['member'] ] ],

	//場景	//
	['member/theme'                     => ['get', 'Member\ThemeController@index' , ['member'] ]  ],
	['member/theme/{product_id}'        => ['get', 'Member\ThemeController@index' , ['member'] ]  ],
	['member/theme/{product_id}/{theme_id}/{degree}' => ['get', 'Member\ThemeController@index', ['member'] ] ],	

	['member/theme/ajax/get_theme'      => ['post', 'Member\ThemeController@ajax_get_theme', ['member']] ],
	['member/theme/ajax/search_product' => ['post', 'Member\ThemeController@ajax_search', ['member']] ],
	['member/theme/ajax/save_pic'       => ['get', 'Member\ThemeController@ajax_save_pic', ['member']] ],
	['member/theme/ajax/save_pic'       => ['post', 'Member\ThemeController@ajax_save_pic', ['member']] ],
];